<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVervolgAbonnementRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Maakt op basis van een bestaand (proef-) abonnement een vervolgabonnement aan.</p> <p>Met createVervolgAbonnement kan een bestaand (proef-) abonnement opgevolgd worden met een nieuw abonnement. Voor het nieuwe abonnement kan een
 * afwijkende debiteur opgegeven worden, dit kan handig zijn bij het opvolgen van cadeauabonnementen (die doorgaans door een andere debiteur betaald worden). Indien dit leeggelaten wordt, zal de abonnee zelf als debiteur genomen worden. </p> <p>(N.B.
 * het veld ingangsDatum van het aboObject kan gevuld worden, maar zal bij invoer van het vervolgAbonnement genegeerd worden).
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class CreateVervolgAbonnementRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementnummer van een bestaand (proef-) abonnement waarvoor een vervolgabonnement aangemaakt moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The aboObject
     * Meta informations extracted from the WSDL
     * - documentation: Abonnementsgegevens van het nieuwe abonnment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \WebApiV4\StructType\AboObjectV4
     */
    public $aboObject;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relNoDeb
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer van de debiteur. De relatie moet bestaan. Indien leeg, wordt de abonnee van het bestaande abonnement zelf als debiteur genomen.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoDeb;
    /**
     * The geenControleLopendAbo
     * Meta informations extracted from the WSDL
     * - documentation: Controle actief abonnement niet uitvoeren voor deze aanvraag. Default false dus wel uitvoeren.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $geenControleLopendAbo;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen vervolg abonnement aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createVervolgAbonnementRequest
     * @uses CreateVervolgAbonnementRequest::setAboNo()
     * @uses CreateVervolgAbonnementRequest::setAboObject()
     * @uses CreateVervolgAbonnementRequest::setRequestTag()
     * @uses CreateVervolgAbonnementRequest::setRelNoDeb()
     * @uses CreateVervolgAbonnementRequest::setGeenControleLopendAbo()
     * @uses CreateVervolgAbonnementRequest::setCanCreate()
     * @param int $aboNo
     * @param \WebApiV4\StructType\AboObjectV4 $aboObject
     * @param string $requestTag
     * @param int $relNoDeb
     * @param bool $geenControleLopendAbo
     * @param bool $canCreate
     */
    public function __construct($aboNo = null, \WebApiV4\StructType\AboObjectV4 $aboObject = null, $requestTag = null, $relNoDeb = null, $geenControleLopendAbo = null, $canCreate = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setAboObject($aboObject)
            ->setRequestTag($requestTag)
            ->setRelNoDeb($relNoDeb)
            ->setGeenControleLopendAbo($geenControleLopendAbo)
            ->setCanCreate($canCreate);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \WebApiV4\StructType\CreateVervolgAbonnementRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get aboObject value
     * @return \WebApiV4\StructType\AboObjectV4
     */
    public function getAboObject()
    {
        return $this->aboObject;
    }
    /**
     * Set aboObject value
     * @param \WebApiV4\StructType\AboObjectV4 $aboObject
     * @return \WebApiV4\StructType\CreateVervolgAbonnementRequest
     */
    public function setAboObject(\WebApiV4\StructType\AboObjectV4 $aboObject = null)
    {
        $this->aboObject = $aboObject;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\CreateVervolgAbonnementRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNoDeb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoDeb()
    {
        return isset($this->relNoDeb) ? $this->relNoDeb : null;
    }
    /**
     * Set relNoDeb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoDeb
     * @return \WebApiV4\StructType\CreateVervolgAbonnementRequest
     */
    public function setRelNoDeb($relNoDeb = null)
    {
        // validation for constraint: int
        if (!is_null($relNoDeb) && !(is_int($relNoDeb) || ctype_digit($relNoDeb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoDeb, true), gettype($relNoDeb)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoDeb) && mb_strlen(preg_replace('/(\D)/', '', $relNoDeb)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoDeb, true), mb_strlen(preg_replace('/(\D)/', '', $relNoDeb))), __LINE__);
        }
        if (is_null($relNoDeb) || (is_array($relNoDeb) && empty($relNoDeb))) {
            unset($this->relNoDeb);
        } else {
            $this->relNoDeb = $relNoDeb;
        }
        return $this;
    }
    /**
     * Get geenControleLopendAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGeenControleLopendAbo()
    {
        return isset($this->geenControleLopendAbo) ? $this->geenControleLopendAbo : null;
    }
    /**
     * Set geenControleLopendAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $geenControleLopendAbo
     * @return \WebApiV4\StructType\CreateVervolgAbonnementRequest
     */
    public function setGeenControleLopendAbo($geenControleLopendAbo = null)
    {
        // validation for constraint: boolean
        if (!is_null($geenControleLopendAbo) && !is_bool($geenControleLopendAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($geenControleLopendAbo, true), gettype($geenControleLopendAbo)), __LINE__);
        }
        if (is_null($geenControleLopendAbo) || (is_array($geenControleLopendAbo) && empty($geenControleLopendAbo))) {
            unset($this->geenControleLopendAbo);
        } else {
            $this->geenControleLopendAbo = $geenControleLopendAbo;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \WebApiV4\StructType\CreateVervolgAbonnementRequest
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\CreateVervolgAbonnementRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
