<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdresObjectV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Het adresobject bestaat uit de volgende velden
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class AdresObjectV4 extends AbstractStructBase
{
    /**
     * The relHuisNummer
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer, groter dan 0.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relHuisNummer;
    /**
     * The relPlaats
     * Meta informations extracted from the WSDL
     * - documentation: Woonplaats.
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $relPlaats;
    /**
     * The relPostcode
     * Meta informations extracted from the WSDL
     * - documentation: Postcode.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $relPostcode;
    /**
     * The relStraat
     * Meta informations extracted from the WSDL
     * - documentation: Straatnaam.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $relStraat;
    /**
     * The relHuisNummerToev
     * Meta informations extracted from the WSDL
     * - documentation: Huisnummer toevoeging.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relHuisNummerToev;
    /**
     * The relLandCode
     * Meta informations extracted from the WSDL
     * - documentation: Land code, moet bestaan in de landen tabel.
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relLandCode;
    /**
     * The relProvincieCode
     * Meta informations extracted from the WSDL
     * - documentation: De Provincie waar iemand woont. Alleen noodzakelijk en toegestaan voor buitenland. Code moet bestaan in de provincie tabel. Provincie moet gekoppeld zijn aan Land.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $relProvincieCode;
    /**
     * Constructor method for AdresObjectV4
     * @uses AdresObjectV4::setRelHuisNummer()
     * @uses AdresObjectV4::setRelPlaats()
     * @uses AdresObjectV4::setRelPostcode()
     * @uses AdresObjectV4::setRelStraat()
     * @uses AdresObjectV4::setRelHuisNummerToev()
     * @uses AdresObjectV4::setRelLandCode()
     * @uses AdresObjectV4::setRelProvincieCode()
     * @param int $relHuisNummer
     * @param string $relPlaats
     * @param string $relPostcode
     * @param string $relStraat
     * @param string $relHuisNummerToev
     * @param string $relLandCode
     * @param string $relProvincieCode
     */
    public function __construct($relHuisNummer = null, $relPlaats = null, $relPostcode = null, $relStraat = null, $relHuisNummerToev = null, $relLandCode = null, $relProvincieCode = null)
    {
        $this
            ->setRelHuisNummer($relHuisNummer)
            ->setRelPlaats($relPlaats)
            ->setRelPostcode($relPostcode)
            ->setRelStraat($relStraat)
            ->setRelHuisNummerToev($relHuisNummerToev)
            ->setRelLandCode($relLandCode)
            ->setRelProvincieCode($relProvincieCode);
    }
    /**
     * Get relHuisNummer value
     * @return int
     */
    public function getRelHuisNummer()
    {
        return $this->relHuisNummer;
    }
    /**
     * Set relHuisNummer value
     * @param int $relHuisNummer
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public function setRelHuisNummer($relHuisNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relHuisNummer) && !(is_int($relHuisNummer) || ctype_digit($relHuisNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relHuisNummer, true), gettype($relHuisNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relHuisNummer) && mb_strlen(preg_replace('/(\D)/', '', $relHuisNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relHuisNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relHuisNummer))), __LINE__);
        }
        $this->relHuisNummer = $relHuisNummer;
        return $this;
    }
    /**
     * Get relPlaats value
     * @return string
     */
    public function getRelPlaats()
    {
        return $this->relPlaats;
    }
    /**
     * Set relPlaats value
     * @param string $relPlaats
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public function setRelPlaats($relPlaats = null)
    {
        // validation for constraint: string
        if (!is_null($relPlaats) && !is_string($relPlaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relPlaats, true), gettype($relPlaats)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($relPlaats) && mb_strlen($relPlaats) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($relPlaats)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($relPlaats) && mb_strlen($relPlaats) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($relPlaats)), __LINE__);
        }
        $this->relPlaats = $relPlaats;
        return $this;
    }
    /**
     * Get relPostcode value
     * @return string
     */
    public function getRelPostcode()
    {
        return $this->relPostcode;
    }
    /**
     * Set relPostcode value
     * @param string $relPostcode
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public function setRelPostcode($relPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($relPostcode) && !is_string($relPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relPostcode, true), gettype($relPostcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($relPostcode) && mb_strlen($relPostcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($relPostcode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($relPostcode) && mb_strlen($relPostcode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($relPostcode)), __LINE__);
        }
        $this->relPostcode = $relPostcode;
        return $this;
    }
    /**
     * Get relStraat value
     * @return string
     */
    public function getRelStraat()
    {
        return $this->relStraat;
    }
    /**
     * Set relStraat value
     * @param string $relStraat
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public function setRelStraat($relStraat = null)
    {
        // validation for constraint: string
        if (!is_null($relStraat) && !is_string($relStraat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relStraat, true), gettype($relStraat)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($relStraat) && mb_strlen($relStraat) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($relStraat)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($relStraat) && mb_strlen($relStraat) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($relStraat)), __LINE__);
        }
        $this->relStraat = $relStraat;
        return $this;
    }
    /**
     * Get relHuisNummerToev value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelHuisNummerToev()
    {
        return isset($this->relHuisNummerToev) ? $this->relHuisNummerToev : null;
    }
    /**
     * Set relHuisNummerToev value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relHuisNummerToev
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public function setRelHuisNummerToev($relHuisNummerToev = null)
    {
        // validation for constraint: string
        if (!is_null($relHuisNummerToev) && !is_string($relHuisNummerToev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relHuisNummerToev, true), gettype($relHuisNummerToev)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($relHuisNummerToev) && mb_strlen($relHuisNummerToev) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($relHuisNummerToev)), __LINE__);
        }
        if (is_null($relHuisNummerToev) || (is_array($relHuisNummerToev) && empty($relHuisNummerToev))) {
            unset($this->relHuisNummerToev);
        } else {
            $this->relHuisNummerToev = $relHuisNummerToev;
        }
        return $this;
    }
    /**
     * Get relLandCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelLandCode()
    {
        return isset($this->relLandCode) ? $this->relLandCode : null;
    }
    /**
     * Set relLandCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relLandCode
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public function setRelLandCode($relLandCode = null)
    {
        // validation for constraint: string
        if (!is_null($relLandCode) && !is_string($relLandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relLandCode, true), gettype($relLandCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($relLandCode) && mb_strlen($relLandCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($relLandCode)), __LINE__);
        }
        if (is_null($relLandCode) || (is_array($relLandCode) && empty($relLandCode))) {
            unset($this->relLandCode);
        } else {
            $this->relLandCode = $relLandCode;
        }
        return $this;
    }
    /**
     * Get relProvincieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelProvincieCode()
    {
        return isset($this->relProvincieCode) ? $this->relProvincieCode : null;
    }
    /**
     * Set relProvincieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relProvincieCode
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public function setRelProvincieCode($relProvincieCode = null)
    {
        // validation for constraint: string
        if (!is_null($relProvincieCode) && !is_string($relProvincieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relProvincieCode, true), gettype($relProvincieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($relProvincieCode) && mb_strlen($relProvincieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($relProvincieCode)), __LINE__);
        }
        if (is_null($relProvincieCode) || (is_array($relProvincieCode) && empty($relProvincieCode))) {
            unset($this->relProvincieCode);
        } else {
            $this->relProvincieCode = $relProvincieCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
