<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbonnementTabV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst abonnementen.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class AbonnementTabV4 extends AbstractStructBase
{
    /**
     * The abonnement
     * Meta informations extracted from the WSDL
     * - documentation: Lijst abonnementen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\AbonnementV4[]
     */
    public $abonnement;
    /**
     * Constructor method for AbonnementTabV4
     * @uses AbonnementTabV4::setAbonnement()
     * @param \WebApiV4\StructType\AbonnementV4[] $abonnement
     */
    public function __construct(array $abonnement = array())
    {
        $this
            ->setAbonnement($abonnement);
    }
    /**
     * Get abonnement value
     * @return \WebApiV4\StructType\AbonnementV4[]|null
     */
    public function getAbonnement()
    {
        return $this->abonnement;
    }
    /**
     * This method is responsible for validating the values passed to the setAbonnement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbonnement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbonnementForArrayConstraintsFromSetAbonnement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $abonnementTabV4AbonnementItem) {
            // validation for constraint: itemType
            if (!$abonnementTabV4AbonnementItem instanceof \WebApiV4\StructType\AbonnementV4) {
                $invalidValues[] = is_object($abonnementTabV4AbonnementItem) ? get_class($abonnementTabV4AbonnementItem) : sprintf('%s(%s)', gettype($abonnementTabV4AbonnementItem), var_export($abonnementTabV4AbonnementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The abonnement property can only contain items of type \WebApiV4\StructType\AbonnementV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set abonnement value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\AbonnementV4[] $abonnement
     * @return \WebApiV4\StructType\AbonnementTabV4
     */
    public function setAbonnement(array $abonnement = array())
    {
        // validation for constraint: array
        if ('' !== ($abonnementArrayErrorMessage = self::validateAbonnementForArrayConstraintsFromSetAbonnement($abonnement))) {
            throw new \InvalidArgumentException($abonnementArrayErrorMessage, __LINE__);
        }
        $this->abonnement = $abonnement;
        return $this;
    }
    /**
     * Add item to abonnement value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\AbonnementV4 $item
     * @return \WebApiV4\StructType\AbonnementTabV4
     */
    public function addToAbonnement(\WebApiV4\StructType\AbonnementV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\AbonnementV4) {
            throw new \InvalidArgumentException(sprintf('The abonnement property can only contain items of type \WebApiV4\StructType\AbonnementV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->abonnement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\AbonnementTabV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
