<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboPakketV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abonnements pakket object
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class AboPakketV4 extends AbstractStructBase
{
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het pakket.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pakketCode;
    /**
     * The pakketNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van het pakket.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketNaam;
    /**
     * The pakketActief
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie actief.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $pakketActief;
    /**
     * The totaalPrijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Totaal prijs inclusief BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $totaalPrijsInclBtw;
    /**
     * The totaalPrijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Totaal prijs exclusief BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $totaalPrijsExclBtw;
    /**
     * The aboSoorten
     * Meta informations extracted from the WSDL
     * - documentation: Onderliggende abonnementsoorten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\AboPakketAboSoortInfoV4
     */
    public $aboSoorten;
    /**
     * The aanvProducten
     * Meta informations extracted from the WSDL
     * - documentation: Onderliggende aanvullende producten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\AboPakketAanvProdInfoV4
     */
    public $aanvProducten;
    /**
     * Constructor method for AboPakketV4
     * @uses AboPakketV4::setPakketCode()
     * @uses AboPakketV4::setPakketNaam()
     * @uses AboPakketV4::setPakketActief()
     * @uses AboPakketV4::setTotaalPrijsInclBtw()
     * @uses AboPakketV4::setTotaalPrijsExclBtw()
     * @uses AboPakketV4::setAboSoorten()
     * @uses AboPakketV4::setAanvProducten()
     * @param string $pakketCode
     * @param string $pakketNaam
     * @param bool $pakketActief
     * @param float $totaalPrijsInclBtw
     * @param float $totaalPrijsExclBtw
     * @param \WebApiV4\StructType\AboPakketAboSoortInfoV4 $aboSoorten
     * @param \WebApiV4\StructType\AboPakketAanvProdInfoV4 $aanvProducten
     */
    public function __construct($pakketCode = null, $pakketNaam = null, $pakketActief = null, $totaalPrijsInclBtw = null, $totaalPrijsExclBtw = null, \WebApiV4\StructType\AboPakketAboSoortInfoV4 $aboSoorten = null, \WebApiV4\StructType\AboPakketAanvProdInfoV4 $aanvProducten = null)
    {
        $this
            ->setPakketCode($pakketCode)
            ->setPakketNaam($pakketNaam)
            ->setPakketActief($pakketActief)
            ->setTotaalPrijsInclBtw($totaalPrijsInclBtw)
            ->setTotaalPrijsExclBtw($totaalPrijsExclBtw)
            ->setAboSoorten($aboSoorten)
            ->setAanvProducten($aanvProducten);
    }
    /**
     * Get pakketCode value
     * @return string
     */
    public function getPakketCode()
    {
        return $this->pakketCode;
    }
    /**
     * Set pakketCode value
     * @param string $pakketCode
     * @return \WebApiV4\StructType\AboPakketV4
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketCode, true), gettype($pakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pakketCode) && mb_strlen($pakketCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($pakketCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($pakketCode) && mb_strlen($pakketCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($pakketCode)), __LINE__);
        }
        $this->pakketCode = $pakketCode;
        return $this;
    }
    /**
     * Get pakketNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketNaam()
    {
        return isset($this->pakketNaam) ? $this->pakketNaam : null;
    }
    /**
     * Set pakketNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketNaam
     * @return \WebApiV4\StructType\AboPakketV4
     */
    public function setPakketNaam($pakketNaam = null)
    {
        // validation for constraint: string
        if (!is_null($pakketNaam) && !is_string($pakketNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketNaam, true), gettype($pakketNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($pakketNaam) && mb_strlen($pakketNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($pakketNaam)), __LINE__);
        }
        if (is_null($pakketNaam) || (is_array($pakketNaam) && empty($pakketNaam))) {
            unset($this->pakketNaam);
        } else {
            $this->pakketNaam = $pakketNaam;
        }
        return $this;
    }
    /**
     * Get pakketActief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPakketActief()
    {
        return isset($this->pakketActief) ? $this->pakketActief : null;
    }
    /**
     * Set pakketActief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $pakketActief
     * @return \WebApiV4\StructType\AboPakketV4
     */
    public function setPakketActief($pakketActief = null)
    {
        // validation for constraint: boolean
        if (!is_null($pakketActief) && !is_bool($pakketActief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pakketActief, true), gettype($pakketActief)), __LINE__);
        }
        if (is_null($pakketActief) || (is_array($pakketActief) && empty($pakketActief))) {
            unset($this->pakketActief);
        } else {
            $this->pakketActief = $pakketActief;
        }
        return $this;
    }
    /**
     * Get totaalPrijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotaalPrijsInclBtw()
    {
        return isset($this->totaalPrijsInclBtw) ? $this->totaalPrijsInclBtw : null;
    }
    /**
     * Set totaalPrijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totaalPrijsInclBtw
     * @return \WebApiV4\StructType\AboPakketV4
     */
    public function setTotaalPrijsInclBtw($totaalPrijsInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($totaalPrijsInclBtw) && !(is_float($totaalPrijsInclBtw) || is_numeric($totaalPrijsInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totaalPrijsInclBtw, true), gettype($totaalPrijsInclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($totaalPrijsInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $totaalPrijsInclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($totaalPrijsInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $totaalPrijsInclBtw))), __LINE__);
        }
        if (is_null($totaalPrijsInclBtw) || (is_array($totaalPrijsInclBtw) && empty($totaalPrijsInclBtw))) {
            unset($this->totaalPrijsInclBtw);
        } else {
            $this->totaalPrijsInclBtw = $totaalPrijsInclBtw;
        }
        return $this;
    }
    /**
     * Get totaalPrijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotaalPrijsExclBtw()
    {
        return isset($this->totaalPrijsExclBtw) ? $this->totaalPrijsExclBtw : null;
    }
    /**
     * Set totaalPrijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totaalPrijsExclBtw
     * @return \WebApiV4\StructType\AboPakketV4
     */
    public function setTotaalPrijsExclBtw($totaalPrijsExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($totaalPrijsExclBtw) && !(is_float($totaalPrijsExclBtw) || is_numeric($totaalPrijsExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totaalPrijsExclBtw, true), gettype($totaalPrijsExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($totaalPrijsExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $totaalPrijsExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($totaalPrijsExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $totaalPrijsExclBtw))), __LINE__);
        }
        if (is_null($totaalPrijsExclBtw) || (is_array($totaalPrijsExclBtw) && empty($totaalPrijsExclBtw))) {
            unset($this->totaalPrijsExclBtw);
        } else {
            $this->totaalPrijsExclBtw = $totaalPrijsExclBtw;
        }
        return $this;
    }
    /**
     * Get aboSoorten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\AboPakketAboSoortInfoV4|null
     */
    public function getAboSoorten()
    {
        return isset($this->aboSoorten) ? $this->aboSoorten : null;
    }
    /**
     * Set aboSoorten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\AboPakketAboSoortInfoV4 $aboSoorten
     * @return \WebApiV4\StructType\AboPakketV4
     */
    public function setAboSoorten(\WebApiV4\StructType\AboPakketAboSoortInfoV4 $aboSoorten = null)
    {
        if (is_null($aboSoorten) || (is_array($aboSoorten) && empty($aboSoorten))) {
            unset($this->aboSoorten);
        } else {
            $this->aboSoorten = $aboSoorten;
        }
        return $this;
    }
    /**
     * Get aanvProducten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\AboPakketAanvProdInfoV4|null
     */
    public function getAanvProducten()
    {
        return isset($this->aanvProducten) ? $this->aanvProducten : null;
    }
    /**
     * Set aanvProducten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\AboPakketAanvProdInfoV4 $aanvProducten
     * @return \WebApiV4\StructType\AboPakketV4
     */
    public function setAanvProducten(\WebApiV4\StructType\AboPakketAanvProdInfoV4 $aanvProducten = null)
    {
        if (is_null($aanvProducten) || (is_array($aanvProducten) && empty($aanvProducten))) {
            unset($this->aanvProducten);
        } else {
            $this->aanvProducten = $aanvProducten;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\AboPakketV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
