<?php

namespace WebApiV4\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Renew ServiceType
 * @subpackage Services
 * @date 20190723
 * @package WebApiV4
 */
class Renew extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \WebApiV4\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\WebApiV4\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named renewAbonnement
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \WebApiV4\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Een bestaand, gestopt abonnement, renewenerror1: Kan geen abonnement vinden voor opgegeven aboNoerror2: renewPerWanneer heeft een ongeldige waarde.error3: renewPerEditie mag alleen worden opgegeven als
     * renewPerWanneer=specifieke_editieerror4: renewPerEditie moet groter zijn dan de huidige stopeditie van het abonnementerror5: renewNaarAbonnement heeft een ongeldige waardeerror6: Als renewNaarAbonnement=zelfde, moeten renewNaarAbosoortCode,
     * renewNaarActieCode en renewNaarPakketCode leeg zijnerror7: Als renewNaarAbonnement=ander, mag alleen renewNaarAbosoortCode of renewNaarActieCode of renewNaarPakketCode gevuld zijn.error8: Het huidige abonnement is niet gestopt.error9: De
     * abonnementsoort van het huidige abonnement is niet van een geldig typeerror10: Het abonnement is reeds gerenewed.error11: Kan geen volgende editie bepalen voor het huidige abonnementerror12: Het is niet mogelijk om dit abonnement te renewen, het is
     * reeds definitief stopgezet.error50: Er is een onbekende foutmelding opgetreden.error51: De renew-optie is niet actief
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WebApiV4\StructType\RenewAbonnementRequest $request_parameters
     * @return \WebApiV4\StructType\RenewAbonnementResponse|bool
     */
    public function renewAbonnement(\WebApiV4\StructType\RenewAbonnementRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->renewAbonnement($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WebApiV4\StructType\RenewAbonnementResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
