<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserRecordAccess StructType
 * @subpackage Structs
 */
class UserRecordAccess extends SObject
{
    /**
     * The HasAllAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasAllAccess;
    /**
     * The HasDeleteAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasDeleteAccess;
    /**
     * The HasEditAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasEditAccess;
    /**
     * The HasReadAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasReadAccess;
    /**
     * The HasTransferAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasTransferAccess;
    /**
     * The MaxAccessLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MaxAccessLevel;
    /**
     * The RecordId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordId;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for UserRecordAccess
     * @uses UserRecordAccess::setHasAllAccess()
     * @uses UserRecordAccess::setHasDeleteAccess()
     * @uses UserRecordAccess::setHasEditAccess()
     * @uses UserRecordAccess::setHasReadAccess()
     * @uses UserRecordAccess::setHasTransferAccess()
     * @uses UserRecordAccess::setMaxAccessLevel()
     * @uses UserRecordAccess::setRecordId()
     * @uses UserRecordAccess::setUserId()
     * @param bool $hasAllAccess
     * @param bool $hasDeleteAccess
     * @param bool $hasEditAccess
     * @param bool $hasReadAccess
     * @param bool $hasTransferAccess
     * @param string $maxAccessLevel
     * @param string $recordId
     * @param string $userId
     */
    public function __construct($hasAllAccess = null, $hasDeleteAccess = null, $hasEditAccess = null, $hasReadAccess = null, $hasTransferAccess = null, $maxAccessLevel = null, $recordId = null, $userId = null)
    {
        $this
            ->setHasAllAccess($hasAllAccess)
            ->setHasDeleteAccess($hasDeleteAccess)
            ->setHasEditAccess($hasEditAccess)
            ->setHasReadAccess($hasReadAccess)
            ->setHasTransferAccess($hasTransferAccess)
            ->setMaxAccessLevel($maxAccessLevel)
            ->setRecordId($recordId)
            ->setUserId($userId);
    }
    /**
     * Get HasAllAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasAllAccess()
    {
        return isset($this->HasAllAccess) ? $this->HasAllAccess : null;
    }
    /**
     * Set HasAllAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasAllAccess
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public function setHasAllAccess($hasAllAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasAllAccess) && !is_bool($hasAllAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasAllAccess, true), gettype($hasAllAccess)), __LINE__);
        }
        if (is_null($hasAllAccess) || (is_array($hasAllAccess) && empty($hasAllAccess))) {
            unset($this->HasAllAccess);
        } else {
            $this->HasAllAccess = $hasAllAccess;
        }
        return $this;
    }
    /**
     * Get HasDeleteAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasDeleteAccess()
    {
        return isset($this->HasDeleteAccess) ? $this->HasDeleteAccess : null;
    }
    /**
     * Set HasDeleteAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasDeleteAccess
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public function setHasDeleteAccess($hasDeleteAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasDeleteAccess) && !is_bool($hasDeleteAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasDeleteAccess, true), gettype($hasDeleteAccess)), __LINE__);
        }
        if (is_null($hasDeleteAccess) || (is_array($hasDeleteAccess) && empty($hasDeleteAccess))) {
            unset($this->HasDeleteAccess);
        } else {
            $this->HasDeleteAccess = $hasDeleteAccess;
        }
        return $this;
    }
    /**
     * Get HasEditAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasEditAccess()
    {
        return isset($this->HasEditAccess) ? $this->HasEditAccess : null;
    }
    /**
     * Set HasEditAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasEditAccess
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public function setHasEditAccess($hasEditAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasEditAccess) && !is_bool($hasEditAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasEditAccess, true), gettype($hasEditAccess)), __LINE__);
        }
        if (is_null($hasEditAccess) || (is_array($hasEditAccess) && empty($hasEditAccess))) {
            unset($this->HasEditAccess);
        } else {
            $this->HasEditAccess = $hasEditAccess;
        }
        return $this;
    }
    /**
     * Get HasReadAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasReadAccess()
    {
        return isset($this->HasReadAccess) ? $this->HasReadAccess : null;
    }
    /**
     * Set HasReadAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasReadAccess
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public function setHasReadAccess($hasReadAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasReadAccess) && !is_bool($hasReadAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasReadAccess, true), gettype($hasReadAccess)), __LINE__);
        }
        if (is_null($hasReadAccess) || (is_array($hasReadAccess) && empty($hasReadAccess))) {
            unset($this->HasReadAccess);
        } else {
            $this->HasReadAccess = $hasReadAccess;
        }
        return $this;
    }
    /**
     * Get HasTransferAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasTransferAccess()
    {
        return isset($this->HasTransferAccess) ? $this->HasTransferAccess : null;
    }
    /**
     * Set HasTransferAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasTransferAccess
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public function setHasTransferAccess($hasTransferAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTransferAccess) && !is_bool($hasTransferAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTransferAccess, true), gettype($hasTransferAccess)), __LINE__);
        }
        if (is_null($hasTransferAccess) || (is_array($hasTransferAccess) && empty($hasTransferAccess))) {
            unset($this->HasTransferAccess);
        } else {
            $this->HasTransferAccess = $hasTransferAccess;
        }
        return $this;
    }
    /**
     * Get MaxAccessLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxAccessLevel()
    {
        return isset($this->MaxAccessLevel) ? $this->MaxAccessLevel : null;
    }
    /**
     * Set MaxAccessLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxAccessLevel
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public function setMaxAccessLevel($maxAccessLevel = null)
    {
        // validation for constraint: string
        if (!is_null($maxAccessLevel) && !is_string($maxAccessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxAccessLevel, true), gettype($maxAccessLevel)), __LINE__);
        }
        if (is_null($maxAccessLevel) || (is_array($maxAccessLevel) && empty($maxAccessLevel))) {
            unset($this->MaxAccessLevel);
        } else {
            $this->MaxAccessLevel = $maxAccessLevel;
        }
        return $this;
    }
    /**
     * Get RecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordId()
    {
        return isset($this->RecordId) ? $this->RecordId : null;
    }
    /**
     * Set RecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordId
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public function setRecordId($recordId = null)
    {
        // validation for constraint: string
        if (!is_null($recordId) && !is_string($recordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordId, true), gettype($recordId)), __LINE__);
        }
        if (is_null($recordId) || (is_array($recordId) && empty($recordId))) {
            unset($this->RecordId);
        } else {
            $this->RecordId = $recordId;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
