<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserEntityAccess StructType
 * @subpackage Structs
 */
class UserEntityAccess extends SObject
{
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The EntityDefinition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\EntityDefinition
     */
    public $EntityDefinition;
    /**
     * The EntityDefinitionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityDefinitionId;
    /**
     * The IsActivateable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActivateable;
    /**
     * The IsCreatable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCreatable;
    /**
     * The IsDeletable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeletable;
    /**
     * The IsEditable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEditable;
    /**
     * The IsFlsUpdatable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFlsUpdatable;
    /**
     * The IsMergeable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMergeable;
    /**
     * The IsReadable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReadable;
    /**
     * The IsUndeletable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUndeletable;
    /**
     * The IsUpdatable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdatable;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for UserEntityAccess
     * @uses UserEntityAccess::setDurableId()
     * @uses UserEntityAccess::setEntityDefinition()
     * @uses UserEntityAccess::setEntityDefinitionId()
     * @uses UserEntityAccess::setIsActivateable()
     * @uses UserEntityAccess::setIsCreatable()
     * @uses UserEntityAccess::setIsDeletable()
     * @uses UserEntityAccess::setIsEditable()
     * @uses UserEntityAccess::setIsFlsUpdatable()
     * @uses UserEntityAccess::setIsMergeable()
     * @uses UserEntityAccess::setIsReadable()
     * @uses UserEntityAccess::setIsUndeletable()
     * @uses UserEntityAccess::setIsUpdatable()
     * @uses UserEntityAccess::setUser()
     * @uses UserEntityAccess::setUserId()
     * @param string $durableId
     * @param \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition
     * @param string $entityDefinitionId
     * @param bool $isActivateable
     * @param bool $isCreatable
     * @param bool $isDeletable
     * @param bool $isEditable
     * @param bool $isFlsUpdatable
     * @param bool $isMergeable
     * @param bool $isReadable
     * @param bool $isUndeletable
     * @param bool $isUpdatable
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     */
    public function __construct($durableId = null, \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition = null, $entityDefinitionId = null, $isActivateable = null, $isCreatable = null, $isDeletable = null, $isEditable = null, $isFlsUpdatable = null, $isMergeable = null, $isReadable = null, $isUndeletable = null, $isUpdatable = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null)
    {
        $this
            ->setDurableId($durableId)
            ->setEntityDefinition($entityDefinition)
            ->setEntityDefinitionId($entityDefinitionId)
            ->setIsActivateable($isActivateable)
            ->setIsCreatable($isCreatable)
            ->setIsDeletable($isDeletable)
            ->setIsEditable($isEditable)
            ->setIsFlsUpdatable($isFlsUpdatable)
            ->setIsMergeable($isMergeable)
            ->setIsReadable($isReadable)
            ->setIsUndeletable($isUndeletable)
            ->setIsUpdatable($isUpdatable)
            ->setUser($user)
            ->setUserId($userId);
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get EntityDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\EntityDefinition|null
     */
    public function getEntityDefinition()
    {
        return isset($this->EntityDefinition) ? $this->EntityDefinition : null;
    }
    /**
     * Set EntityDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setEntityDefinition(\NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition = null)
    {
        if (is_null($entityDefinition) || (is_array($entityDefinition) && empty($entityDefinition))) {
            unset($this->EntityDefinition);
        } else {
            $this->EntityDefinition = $entityDefinition;
        }
        return $this;
    }
    /**
     * Get EntityDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityDefinitionId()
    {
        return isset($this->EntityDefinitionId) ? $this->EntityDefinitionId : null;
    }
    /**
     * Set EntityDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityDefinitionId
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setEntityDefinitionId($entityDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($entityDefinitionId) && !is_string($entityDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityDefinitionId, true), gettype($entityDefinitionId)), __LINE__);
        }
        if (is_null($entityDefinitionId) || (is_array($entityDefinitionId) && empty($entityDefinitionId))) {
            unset($this->EntityDefinitionId);
        } else {
            $this->EntityDefinitionId = $entityDefinitionId;
        }
        return $this;
    }
    /**
     * Get IsActivateable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActivateable()
    {
        return isset($this->IsActivateable) ? $this->IsActivateable : null;
    }
    /**
     * Set IsActivateable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActivateable
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setIsActivateable($isActivateable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActivateable) && !is_bool($isActivateable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActivateable, true), gettype($isActivateable)), __LINE__);
        }
        if (is_null($isActivateable) || (is_array($isActivateable) && empty($isActivateable))) {
            unset($this->IsActivateable);
        } else {
            $this->IsActivateable = $isActivateable;
        }
        return $this;
    }
    /**
     * Get IsCreatable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCreatable()
    {
        return isset($this->IsCreatable) ? $this->IsCreatable : null;
    }
    /**
     * Set IsCreatable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCreatable
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setIsCreatable($isCreatable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCreatable) && !is_bool($isCreatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCreatable, true), gettype($isCreatable)), __LINE__);
        }
        if (is_null($isCreatable) || (is_array($isCreatable) && empty($isCreatable))) {
            unset($this->IsCreatable);
        } else {
            $this->IsCreatable = $isCreatable;
        }
        return $this;
    }
    /**
     * Get IsDeletable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeletable()
    {
        return isset($this->IsDeletable) ? $this->IsDeletable : null;
    }
    /**
     * Set IsDeletable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeletable
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setIsDeletable($isDeletable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeletable) && !is_bool($isDeletable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeletable, true), gettype($isDeletable)), __LINE__);
        }
        if (is_null($isDeletable) || (is_array($isDeletable) && empty($isDeletable))) {
            unset($this->IsDeletable);
        } else {
            $this->IsDeletable = $isDeletable;
        }
        return $this;
    }
    /**
     * Get IsEditable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEditable()
    {
        return isset($this->IsEditable) ? $this->IsEditable : null;
    }
    /**
     * Set IsEditable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEditable
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setIsEditable($isEditable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEditable) && !is_bool($isEditable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEditable, true), gettype($isEditable)), __LINE__);
        }
        if (is_null($isEditable) || (is_array($isEditable) && empty($isEditable))) {
            unset($this->IsEditable);
        } else {
            $this->IsEditable = $isEditable;
        }
        return $this;
    }
    /**
     * Get IsFlsUpdatable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFlsUpdatable()
    {
        return isset($this->IsFlsUpdatable) ? $this->IsFlsUpdatable : null;
    }
    /**
     * Set IsFlsUpdatable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFlsUpdatable
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setIsFlsUpdatable($isFlsUpdatable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFlsUpdatable) && !is_bool($isFlsUpdatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFlsUpdatable, true), gettype($isFlsUpdatable)), __LINE__);
        }
        if (is_null($isFlsUpdatable) || (is_array($isFlsUpdatable) && empty($isFlsUpdatable))) {
            unset($this->IsFlsUpdatable);
        } else {
            $this->IsFlsUpdatable = $isFlsUpdatable;
        }
        return $this;
    }
    /**
     * Get IsMergeable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMergeable()
    {
        return isset($this->IsMergeable) ? $this->IsMergeable : null;
    }
    /**
     * Set IsMergeable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMergeable
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setIsMergeable($isMergeable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMergeable) && !is_bool($isMergeable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMergeable, true), gettype($isMergeable)), __LINE__);
        }
        if (is_null($isMergeable) || (is_array($isMergeable) && empty($isMergeable))) {
            unset($this->IsMergeable);
        } else {
            $this->IsMergeable = $isMergeable;
        }
        return $this;
    }
    /**
     * Get IsReadable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReadable()
    {
        return isset($this->IsReadable) ? $this->IsReadable : null;
    }
    /**
     * Set IsReadable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReadable
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setIsReadable($isReadable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReadable) && !is_bool($isReadable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReadable, true), gettype($isReadable)), __LINE__);
        }
        if (is_null($isReadable) || (is_array($isReadable) && empty($isReadable))) {
            unset($this->IsReadable);
        } else {
            $this->IsReadable = $isReadable;
        }
        return $this;
    }
    /**
     * Get IsUndeletable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUndeletable()
    {
        return isset($this->IsUndeletable) ? $this->IsUndeletable : null;
    }
    /**
     * Set IsUndeletable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUndeletable
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setIsUndeletable($isUndeletable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUndeletable) && !is_bool($isUndeletable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUndeletable, true), gettype($isUndeletable)), __LINE__);
        }
        if (is_null($isUndeletable) || (is_array($isUndeletable) && empty($isUndeletable))) {
            unset($this->IsUndeletable);
        } else {
            $this->IsUndeletable = $isUndeletable;
        }
        return $this;
    }
    /**
     * Get IsUpdatable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdatable()
    {
        return isset($this->IsUpdatable) ? $this->IsUpdatable : null;
    }
    /**
     * Set IsUpdatable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdatable
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setIsUpdatable($isUpdatable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdatable) && !is_bool($isUpdatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdatable, true), gettype($isUpdatable)), __LINE__);
        }
        if (is_null($isUpdatable) || (is_array($isUpdatable) && empty($isUpdatable))) {
            unset($this->IsUpdatable);
        } else {
            $this->IsUpdatable = $isUpdatable;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\UserEntityAccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
