<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SamlSsoConfig StructType
 * @subpackage Structs
 */
class SamlSsoConfig extends SObject
{
    /**
     * The AttributeFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttributeFormat;
    /**
     * The AttributeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttributeName;
    /**
     * The Audience
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Audience;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The ErrorUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorUrl;
    /**
     * The ExecutionUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $ExecutionUser;
    /**
     * The ExecutionUserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ExecutionUserId;
    /**
     * The IdentityLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentityLocation;
    /**
     * The IdentityMapping
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentityMapping;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The Issuer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Issuer;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LoginUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginUrl;
    /**
     * The LogoutUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogoutUrl;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The NamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamespacePrefix;
    /**
     * The OptionsSpInitBinding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsSpInitBinding;
    /**
     * The OptionsUserProvisioning
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsUserProvisioning;
    /**
     * The RequestSignatureMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestSignatureMethod;
    /**
     * The SamlJitHandler
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ApexClass
     */
    public $SamlJitHandler;
    /**
     * The SamlJitHandlerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $SamlJitHandlerId;
    /**
     * The SingleLogoutBinding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SingleLogoutBinding;
    /**
     * The SingleLogoutUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SingleLogoutUrl;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The ValidationCert
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationCert;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Version;
    /**
     * Constructor method for SamlSsoConfig
     * @uses SamlSsoConfig::setAttributeFormat()
     * @uses SamlSsoConfig::setAttributeName()
     * @uses SamlSsoConfig::setAudience()
     * @uses SamlSsoConfig::setCreatedBy()
     * @uses SamlSsoConfig::setCreatedById()
     * @uses SamlSsoConfig::setCreatedDate()
     * @uses SamlSsoConfig::setDeveloperName()
     * @uses SamlSsoConfig::setErrorUrl()
     * @uses SamlSsoConfig::setExecutionUser()
     * @uses SamlSsoConfig::setExecutionUserId()
     * @uses SamlSsoConfig::setIdentityLocation()
     * @uses SamlSsoConfig::setIdentityMapping()
     * @uses SamlSsoConfig::setIsDeleted()
     * @uses SamlSsoConfig::setIssuer()
     * @uses SamlSsoConfig::setLanguage()
     * @uses SamlSsoConfig::setLastModifiedBy()
     * @uses SamlSsoConfig::setLastModifiedById()
     * @uses SamlSsoConfig::setLastModifiedDate()
     * @uses SamlSsoConfig::setLoginUrl()
     * @uses SamlSsoConfig::setLogoutUrl()
     * @uses SamlSsoConfig::setMasterLabel()
     * @uses SamlSsoConfig::setNamespacePrefix()
     * @uses SamlSsoConfig::setOptionsSpInitBinding()
     * @uses SamlSsoConfig::setOptionsUserProvisioning()
     * @uses SamlSsoConfig::setRequestSignatureMethod()
     * @uses SamlSsoConfig::setSamlJitHandler()
     * @uses SamlSsoConfig::setSamlJitHandlerId()
     * @uses SamlSsoConfig::setSingleLogoutBinding()
     * @uses SamlSsoConfig::setSingleLogoutUrl()
     * @uses SamlSsoConfig::setSystemModstamp()
     * @uses SamlSsoConfig::setValidationCert()
     * @uses SamlSsoConfig::setVersion()
     * @param string $attributeFormat
     * @param string $attributeName
     * @param string $audience
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $developerName
     * @param string $errorUrl
     * @param \NexusDigital/MiratelForce\StructType\User $executionUser
     * @param string $executionUserId
     * @param string $identityLocation
     * @param string $identityMapping
     * @param bool $isDeleted
     * @param string $issuer
     * @param string $language
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $loginUrl
     * @param string $logoutUrl
     * @param string $masterLabel
     * @param string $namespacePrefix
     * @param bool $optionsSpInitBinding
     * @param bool $optionsUserProvisioning
     * @param string $requestSignatureMethod
     * @param \NexusDigital/MiratelForce\StructType\ApexClass $samlJitHandler
     * @param string $samlJitHandlerId
     * @param string $singleLogoutBinding
     * @param string $singleLogoutUrl
     * @param string $systemModstamp
     * @param string $validationCert
     * @param string $version
     */
    public function __construct($attributeFormat = null, $attributeName = null, $audience = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $developerName = null, $errorUrl = null, \NexusDigital/MiratelForce\StructType\User $executionUser = null, $executionUserId = null, $identityLocation = null, $identityMapping = null, $isDeleted = null, $issuer = null, $language = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $loginUrl = null, $logoutUrl = null, $masterLabel = null, $namespacePrefix = null, $optionsSpInitBinding = null, $optionsUserProvisioning = null, $requestSignatureMethod = null, \NexusDigital/MiratelForce\StructType\ApexClass $samlJitHandler = null, $samlJitHandlerId = null, $singleLogoutBinding = null, $singleLogoutUrl = null, $systemModstamp = null, $validationCert = null, $version = null)
    {
        $this
            ->setAttributeFormat($attributeFormat)
            ->setAttributeName($attributeName)
            ->setAudience($audience)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDeveloperName($developerName)
            ->setErrorUrl($errorUrl)
            ->setExecutionUser($executionUser)
            ->setExecutionUserId($executionUserId)
            ->setIdentityLocation($identityLocation)
            ->setIdentityMapping($identityMapping)
            ->setIsDeleted($isDeleted)
            ->setIssuer($issuer)
            ->setLanguage($language)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLoginUrl($loginUrl)
            ->setLogoutUrl($logoutUrl)
            ->setMasterLabel($masterLabel)
            ->setNamespacePrefix($namespacePrefix)
            ->setOptionsSpInitBinding($optionsSpInitBinding)
            ->setOptionsUserProvisioning($optionsUserProvisioning)
            ->setRequestSignatureMethod($requestSignatureMethod)
            ->setSamlJitHandler($samlJitHandler)
            ->setSamlJitHandlerId($samlJitHandlerId)
            ->setSingleLogoutBinding($singleLogoutBinding)
            ->setSingleLogoutUrl($singleLogoutUrl)
            ->setSystemModstamp($systemModstamp)
            ->setValidationCert($validationCert)
            ->setVersion($version);
    }
    /**
     * Get AttributeFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributeFormat()
    {
        return isset($this->AttributeFormat) ? $this->AttributeFormat : null;
    }
    /**
     * Set AttributeFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attributeFormat
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setAttributeFormat($attributeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($attributeFormat) && !is_string($attributeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeFormat, true), gettype($attributeFormat)), __LINE__);
        }
        if (is_null($attributeFormat) || (is_array($attributeFormat) && empty($attributeFormat))) {
            unset($this->AttributeFormat);
        } else {
            $this->AttributeFormat = $attributeFormat;
        }
        return $this;
    }
    /**
     * Get AttributeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributeName()
    {
        return isset($this->AttributeName) ? $this->AttributeName : null;
    }
    /**
     * Set AttributeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attributeName
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setAttributeName($attributeName = null)
    {
        // validation for constraint: string
        if (!is_null($attributeName) && !is_string($attributeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeName, true), gettype($attributeName)), __LINE__);
        }
        if (is_null($attributeName) || (is_array($attributeName) && empty($attributeName))) {
            unset($this->AttributeName);
        } else {
            $this->AttributeName = $attributeName;
        }
        return $this;
    }
    /**
     * Get Audience value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAudience()
    {
        return isset($this->Audience) ? $this->Audience : null;
    }
    /**
     * Set Audience value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $audience
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setAudience($audience = null)
    {
        // validation for constraint: string
        if (!is_null($audience) && !is_string($audience)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($audience, true), gettype($audience)), __LINE__);
        }
        if (is_null($audience) || (is_array($audience) && empty($audience))) {
            unset($this->Audience);
        } else {
            $this->Audience = $audience;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get ErrorUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorUrl()
    {
        return isset($this->ErrorUrl) ? $this->ErrorUrl : null;
    }
    /**
     * Set ErrorUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorUrl
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setErrorUrl($errorUrl = null)
    {
        // validation for constraint: string
        if (!is_null($errorUrl) && !is_string($errorUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorUrl, true), gettype($errorUrl)), __LINE__);
        }
        if (is_null($errorUrl) || (is_array($errorUrl) && empty($errorUrl))) {
            unset($this->ErrorUrl);
        } else {
            $this->ErrorUrl = $errorUrl;
        }
        return $this;
    }
    /**
     * Get ExecutionUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getExecutionUser()
    {
        return isset($this->ExecutionUser) ? $this->ExecutionUser : null;
    }
    /**
     * Set ExecutionUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $executionUser
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setExecutionUser(\NexusDigital/MiratelForce\StructType\User $executionUser = null)
    {
        if (is_null($executionUser) || (is_array($executionUser) && empty($executionUser))) {
            unset($this->ExecutionUser);
        } else {
            $this->ExecutionUser = $executionUser;
        }
        return $this;
    }
    /**
     * Get ExecutionUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionUserId()
    {
        return isset($this->ExecutionUserId) ? $this->ExecutionUserId : null;
    }
    /**
     * Set ExecutionUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionUserId
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setExecutionUserId($executionUserId = null)
    {
        // validation for constraint: string
        if (!is_null($executionUserId) && !is_string($executionUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionUserId, true), gettype($executionUserId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($executionUserId) && mb_strlen($executionUserId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($executionUserId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($executionUserId) && !preg_match('/[a-zA-Z0-9]{18}/', $executionUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($executionUserId, true)), __LINE__);
        }
        if (is_null($executionUserId) || (is_array($executionUserId) && empty($executionUserId))) {
            unset($this->ExecutionUserId);
        } else {
            $this->ExecutionUserId = $executionUserId;
        }
        return $this;
    }
    /**
     * Get IdentityLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentityLocation()
    {
        return isset($this->IdentityLocation) ? $this->IdentityLocation : null;
    }
    /**
     * Set IdentityLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identityLocation
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setIdentityLocation($identityLocation = null)
    {
        // validation for constraint: string
        if (!is_null($identityLocation) && !is_string($identityLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityLocation, true), gettype($identityLocation)), __LINE__);
        }
        if (is_null($identityLocation) || (is_array($identityLocation) && empty($identityLocation))) {
            unset($this->IdentityLocation);
        } else {
            $this->IdentityLocation = $identityLocation;
        }
        return $this;
    }
    /**
     * Get IdentityMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentityMapping()
    {
        return isset($this->IdentityMapping) ? $this->IdentityMapping : null;
    }
    /**
     * Set IdentityMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identityMapping
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setIdentityMapping($identityMapping = null)
    {
        // validation for constraint: string
        if (!is_null($identityMapping) && !is_string($identityMapping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityMapping, true), gettype($identityMapping)), __LINE__);
        }
        if (is_null($identityMapping) || (is_array($identityMapping) && empty($identityMapping))) {
            unset($this->IdentityMapping);
        } else {
            $this->IdentityMapping = $identityMapping;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get Issuer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuer()
    {
        return isset($this->Issuer) ? $this->Issuer : null;
    }
    /**
     * Set Issuer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuer
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setIssuer($issuer = null)
    {
        // validation for constraint: string
        if (!is_null($issuer) && !is_string($issuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuer, true), gettype($issuer)), __LINE__);
        }
        if (is_null($issuer) || (is_array($issuer) && empty($issuer))) {
            unset($this->Issuer);
        } else {
            $this->Issuer = $issuer;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LoginUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginUrl()
    {
        return isset($this->LoginUrl) ? $this->LoginUrl : null;
    }
    /**
     * Set LoginUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginUrl
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setLoginUrl($loginUrl = null)
    {
        // validation for constraint: string
        if (!is_null($loginUrl) && !is_string($loginUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginUrl, true), gettype($loginUrl)), __LINE__);
        }
        if (is_null($loginUrl) || (is_array($loginUrl) && empty($loginUrl))) {
            unset($this->LoginUrl);
        } else {
            $this->LoginUrl = $loginUrl;
        }
        return $this;
    }
    /**
     * Get LogoutUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogoutUrl()
    {
        return isset($this->LogoutUrl) ? $this->LogoutUrl : null;
    }
    /**
     * Set LogoutUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logoutUrl
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setLogoutUrl($logoutUrl = null)
    {
        // validation for constraint: string
        if (!is_null($logoutUrl) && !is_string($logoutUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoutUrl, true), gettype($logoutUrl)), __LINE__);
        }
        if (is_null($logoutUrl) || (is_array($logoutUrl) && empty($logoutUrl))) {
            unset($this->LogoutUrl);
        } else {
            $this->LogoutUrl = $logoutUrl;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get NamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamespacePrefix()
    {
        return isset($this->NamespacePrefix) ? $this->NamespacePrefix : null;
    }
    /**
     * Set NamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setNamespacePrefix($namespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namespacePrefix) && !is_string($namespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespacePrefix, true), gettype($namespacePrefix)), __LINE__);
        }
        if (is_null($namespacePrefix) || (is_array($namespacePrefix) && empty($namespacePrefix))) {
            unset($this->NamespacePrefix);
        } else {
            $this->NamespacePrefix = $namespacePrefix;
        }
        return $this;
    }
    /**
     * Get OptionsSpInitBinding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsSpInitBinding()
    {
        return isset($this->OptionsSpInitBinding) ? $this->OptionsSpInitBinding : null;
    }
    /**
     * Set OptionsSpInitBinding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsSpInitBinding
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setOptionsSpInitBinding($optionsSpInitBinding = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsSpInitBinding) && !is_bool($optionsSpInitBinding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsSpInitBinding, true), gettype($optionsSpInitBinding)), __LINE__);
        }
        if (is_null($optionsSpInitBinding) || (is_array($optionsSpInitBinding) && empty($optionsSpInitBinding))) {
            unset($this->OptionsSpInitBinding);
        } else {
            $this->OptionsSpInitBinding = $optionsSpInitBinding;
        }
        return $this;
    }
    /**
     * Get OptionsUserProvisioning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsUserProvisioning()
    {
        return isset($this->OptionsUserProvisioning) ? $this->OptionsUserProvisioning : null;
    }
    /**
     * Set OptionsUserProvisioning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsUserProvisioning
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setOptionsUserProvisioning($optionsUserProvisioning = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsUserProvisioning) && !is_bool($optionsUserProvisioning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsUserProvisioning, true), gettype($optionsUserProvisioning)), __LINE__);
        }
        if (is_null($optionsUserProvisioning) || (is_array($optionsUserProvisioning) && empty($optionsUserProvisioning))) {
            unset($this->OptionsUserProvisioning);
        } else {
            $this->OptionsUserProvisioning = $optionsUserProvisioning;
        }
        return $this;
    }
    /**
     * Get RequestSignatureMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestSignatureMethod()
    {
        return isset($this->RequestSignatureMethod) ? $this->RequestSignatureMethod : null;
    }
    /**
     * Set RequestSignatureMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestSignatureMethod
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setRequestSignatureMethod($requestSignatureMethod = null)
    {
        // validation for constraint: string
        if (!is_null($requestSignatureMethod) && !is_string($requestSignatureMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestSignatureMethod, true), gettype($requestSignatureMethod)), __LINE__);
        }
        if (is_null($requestSignatureMethod) || (is_array($requestSignatureMethod) && empty($requestSignatureMethod))) {
            unset($this->RequestSignatureMethod);
        } else {
            $this->RequestSignatureMethod = $requestSignatureMethod;
        }
        return $this;
    }
    /**
     * Get SamlJitHandler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ApexClass|null
     */
    public function getSamlJitHandler()
    {
        return isset($this->SamlJitHandler) ? $this->SamlJitHandler : null;
    }
    /**
     * Set SamlJitHandler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ApexClass $samlJitHandler
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setSamlJitHandler(\NexusDigital/MiratelForce\StructType\ApexClass $samlJitHandler = null)
    {
        if (is_null($samlJitHandler) || (is_array($samlJitHandler) && empty($samlJitHandler))) {
            unset($this->SamlJitHandler);
        } else {
            $this->SamlJitHandler = $samlJitHandler;
        }
        return $this;
    }
    /**
     * Get SamlJitHandlerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSamlJitHandlerId()
    {
        return isset($this->SamlJitHandlerId) ? $this->SamlJitHandlerId : null;
    }
    /**
     * Set SamlJitHandlerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $samlJitHandlerId
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setSamlJitHandlerId($samlJitHandlerId = null)
    {
        // validation for constraint: string
        if (!is_null($samlJitHandlerId) && !is_string($samlJitHandlerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($samlJitHandlerId, true), gettype($samlJitHandlerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($samlJitHandlerId) && mb_strlen($samlJitHandlerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($samlJitHandlerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($samlJitHandlerId) && !preg_match('/[a-zA-Z0-9]{18}/', $samlJitHandlerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($samlJitHandlerId, true)), __LINE__);
        }
        if (is_null($samlJitHandlerId) || (is_array($samlJitHandlerId) && empty($samlJitHandlerId))) {
            unset($this->SamlJitHandlerId);
        } else {
            $this->SamlJitHandlerId = $samlJitHandlerId;
        }
        return $this;
    }
    /**
     * Get SingleLogoutBinding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSingleLogoutBinding()
    {
        return isset($this->SingleLogoutBinding) ? $this->SingleLogoutBinding : null;
    }
    /**
     * Set SingleLogoutBinding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $singleLogoutBinding
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setSingleLogoutBinding($singleLogoutBinding = null)
    {
        // validation for constraint: string
        if (!is_null($singleLogoutBinding) && !is_string($singleLogoutBinding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleLogoutBinding, true), gettype($singleLogoutBinding)), __LINE__);
        }
        if (is_null($singleLogoutBinding) || (is_array($singleLogoutBinding) && empty($singleLogoutBinding))) {
            unset($this->SingleLogoutBinding);
        } else {
            $this->SingleLogoutBinding = $singleLogoutBinding;
        }
        return $this;
    }
    /**
     * Get SingleLogoutUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSingleLogoutUrl()
    {
        return isset($this->SingleLogoutUrl) ? $this->SingleLogoutUrl : null;
    }
    /**
     * Set SingleLogoutUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $singleLogoutUrl
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setSingleLogoutUrl($singleLogoutUrl = null)
    {
        // validation for constraint: string
        if (!is_null($singleLogoutUrl) && !is_string($singleLogoutUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleLogoutUrl, true), gettype($singleLogoutUrl)), __LINE__);
        }
        if (is_null($singleLogoutUrl) || (is_array($singleLogoutUrl) && empty($singleLogoutUrl))) {
            unset($this->SingleLogoutUrl);
        } else {
            $this->SingleLogoutUrl = $singleLogoutUrl;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get ValidationCert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationCert()
    {
        return isset($this->ValidationCert) ? $this->ValidationCert : null;
    }
    /**
     * Set ValidationCert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validationCert
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setValidationCert($validationCert = null)
    {
        // validation for constraint: string
        if (!is_null($validationCert) && !is_string($validationCert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationCert, true), gettype($validationCert)), __LINE__);
        }
        if (is_null($validationCert) || (is_array($validationCert) && empty($validationCert))) {
            unset($this->ValidationCert);
        } else {
            $this->ValidationCert = $validationCert;
        }
        return $this;
    }
    /**
     * Get Version value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersion()
    {
        return isset($this->Version) ? $this->Version : null;
    }
    /**
     * Set Version value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $version
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        if (is_null($version) || (is_array($version) && empty($version))) {
            unset($this->Version);
        } else {
            $this->Version = $version;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\SamlSsoConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
