<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelationshipInfo StructType
 * @subpackage Structs
 */
class RelationshipInfo extends SObject
{
    /**
     * The ChildSobject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\EntityDefinition
     */
    public $ChildSobject;
    /**
     * The ChildSobjectId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChildSobjectId;
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The Field
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\FieldDefinition
     */
    public $Field;
    /**
     * The FieldId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FieldId;
    /**
     * The IsCascadeDelete
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCascadeDelete;
    /**
     * The IsDeprecatedAndHidden
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeprecatedAndHidden;
    /**
     * The IsRestrictedDelete
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRestrictedDelete;
    /**
     * The JunctionIdListNames
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\JunctionIdListNames
     */
    public $JunctionIdListNames;
    /**
     * The RelationshipDomains
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RelationshipDomains;
    /**
     * Constructor method for RelationshipInfo
     * @uses RelationshipInfo::setChildSobject()
     * @uses RelationshipInfo::setChildSobjectId()
     * @uses RelationshipInfo::setDurableId()
     * @uses RelationshipInfo::setField()
     * @uses RelationshipInfo::setFieldId()
     * @uses RelationshipInfo::setIsCascadeDelete()
     * @uses RelationshipInfo::setIsDeprecatedAndHidden()
     * @uses RelationshipInfo::setIsRestrictedDelete()
     * @uses RelationshipInfo::setJunctionIdListNames()
     * @uses RelationshipInfo::setRelationshipDomains()
     * @param \NexusDigital/MiratelForce\StructType\EntityDefinition $childSobject
     * @param string $childSobjectId
     * @param string $durableId
     * @param \NexusDigital/MiratelForce\StructType\FieldDefinition $field
     * @param string $fieldId
     * @param bool $isCascadeDelete
     * @param bool $isDeprecatedAndHidden
     * @param bool $isRestrictedDelete
     * @param \NexusDigital/MiratelForce\StructType\JunctionIdListNames $junctionIdListNames
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $relationshipDomains
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\EntityDefinition $childSobject = null, $childSobjectId = null, $durableId = null, \NexusDigital/MiratelForce\StructType\FieldDefinition $field = null, $fieldId = null, $isCascadeDelete = null, $isDeprecatedAndHidden = null, $isRestrictedDelete = null, \NexusDigital/MiratelForce\StructType\JunctionIdListNames $junctionIdListNames = null, \NexusDigital/MiratelForce\StructType\QueryResult $relationshipDomains = null)
    {
        $this
            ->setChildSobject($childSobject)
            ->setChildSobjectId($childSobjectId)
            ->setDurableId($durableId)
            ->setField($field)
            ->setFieldId($fieldId)
            ->setIsCascadeDelete($isCascadeDelete)
            ->setIsDeprecatedAndHidden($isDeprecatedAndHidden)
            ->setIsRestrictedDelete($isRestrictedDelete)
            ->setJunctionIdListNames($junctionIdListNames)
            ->setRelationshipDomains($relationshipDomains);
    }
    /**
     * Get ChildSobject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\EntityDefinition|null
     */
    public function getChildSobject()
    {
        return isset($this->ChildSobject) ? $this->ChildSobject : null;
    }
    /**
     * Set ChildSobject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\EntityDefinition $childSobject
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public function setChildSobject(\NexusDigital/MiratelForce\StructType\EntityDefinition $childSobject = null)
    {
        if (is_null($childSobject) || (is_array($childSobject) && empty($childSobject))) {
            unset($this->ChildSobject);
        } else {
            $this->ChildSobject = $childSobject;
        }
        return $this;
    }
    /**
     * Get ChildSobjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChildSobjectId()
    {
        return isset($this->ChildSobjectId) ? $this->ChildSobjectId : null;
    }
    /**
     * Set ChildSobjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $childSobjectId
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public function setChildSobjectId($childSobjectId = null)
    {
        // validation for constraint: string
        if (!is_null($childSobjectId) && !is_string($childSobjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($childSobjectId, true), gettype($childSobjectId)), __LINE__);
        }
        if (is_null($childSobjectId) || (is_array($childSobjectId) && empty($childSobjectId))) {
            unset($this->ChildSobjectId);
        } else {
            $this->ChildSobjectId = $childSobjectId;
        }
        return $this;
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get Field value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\FieldDefinition|null
     */
    public function getField()
    {
        return isset($this->Field) ? $this->Field : null;
    }
    /**
     * Set Field value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\FieldDefinition $field
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public function setField(\NexusDigital/MiratelForce\StructType\FieldDefinition $field = null)
    {
        if (is_null($field) || (is_array($field) && empty($field))) {
            unset($this->Field);
        } else {
            $this->Field = $field;
        }
        return $this;
    }
    /**
     * Get FieldId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFieldId()
    {
        return isset($this->FieldId) ? $this->FieldId : null;
    }
    /**
     * Set FieldId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fieldId
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public function setFieldId($fieldId = null)
    {
        // validation for constraint: string
        if (!is_null($fieldId) && !is_string($fieldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldId, true), gettype($fieldId)), __LINE__);
        }
        if (is_null($fieldId) || (is_array($fieldId) && empty($fieldId))) {
            unset($this->FieldId);
        } else {
            $this->FieldId = $fieldId;
        }
        return $this;
    }
    /**
     * Get IsCascadeDelete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCascadeDelete()
    {
        return isset($this->IsCascadeDelete) ? $this->IsCascadeDelete : null;
    }
    /**
     * Set IsCascadeDelete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCascadeDelete
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public function setIsCascadeDelete($isCascadeDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCascadeDelete) && !is_bool($isCascadeDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCascadeDelete, true), gettype($isCascadeDelete)), __LINE__);
        }
        if (is_null($isCascadeDelete) || (is_array($isCascadeDelete) && empty($isCascadeDelete))) {
            unset($this->IsCascadeDelete);
        } else {
            $this->IsCascadeDelete = $isCascadeDelete;
        }
        return $this;
    }
    /**
     * Get IsDeprecatedAndHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeprecatedAndHidden()
    {
        return isset($this->IsDeprecatedAndHidden) ? $this->IsDeprecatedAndHidden : null;
    }
    /**
     * Set IsDeprecatedAndHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeprecatedAndHidden
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public function setIsDeprecatedAndHidden($isDeprecatedAndHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeprecatedAndHidden) && !is_bool($isDeprecatedAndHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeprecatedAndHidden, true), gettype($isDeprecatedAndHidden)), __LINE__);
        }
        if (is_null($isDeprecatedAndHidden) || (is_array($isDeprecatedAndHidden) && empty($isDeprecatedAndHidden))) {
            unset($this->IsDeprecatedAndHidden);
        } else {
            $this->IsDeprecatedAndHidden = $isDeprecatedAndHidden;
        }
        return $this;
    }
    /**
     * Get IsRestrictedDelete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRestrictedDelete()
    {
        return isset($this->IsRestrictedDelete) ? $this->IsRestrictedDelete : null;
    }
    /**
     * Set IsRestrictedDelete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRestrictedDelete
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public function setIsRestrictedDelete($isRestrictedDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRestrictedDelete) && !is_bool($isRestrictedDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRestrictedDelete, true), gettype($isRestrictedDelete)), __LINE__);
        }
        if (is_null($isRestrictedDelete) || (is_array($isRestrictedDelete) && empty($isRestrictedDelete))) {
            unset($this->IsRestrictedDelete);
        } else {
            $this->IsRestrictedDelete = $isRestrictedDelete;
        }
        return $this;
    }
    /**
     * Get JunctionIdListNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\JunctionIdListNames|null
     */
    public function getJunctionIdListNames()
    {
        return isset($this->JunctionIdListNames) ? $this->JunctionIdListNames : null;
    }
    /**
     * Set JunctionIdListNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\JunctionIdListNames $junctionIdListNames
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public function setJunctionIdListNames(\NexusDigital/MiratelForce\StructType\JunctionIdListNames $junctionIdListNames = null)
    {
        if (is_null($junctionIdListNames) || (is_array($junctionIdListNames) && empty($junctionIdListNames))) {
            unset($this->JunctionIdListNames);
        } else {
            $this->JunctionIdListNames = $junctionIdListNames;
        }
        return $this;
    }
    /**
     * Get RelationshipDomains value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRelationshipDomains()
    {
        return isset($this->RelationshipDomains) ? $this->RelationshipDomains : null;
    }
    /**
     * Set RelationshipDomains value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $relationshipDomains
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public function setRelationshipDomains(\NexusDigital/MiratelForce\StructType\QueryResult $relationshipDomains = null)
    {
        if (is_null($relationshipDomains) || (is_array($relationshipDomains) && empty($relationshipDomains))) {
            unset($this->RelationshipDomains);
        } else {
            $this->RelationshipDomains = $relationshipDomains;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\RelationshipInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
