<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueRoutingConfig StructType
 * @subpackage Structs
 */
class QueueRoutingConfig extends SObject
{
    /**
     * The CapacityPercentage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CapacityPercentage;
    /**
     * The CapacityWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CapacityWeight;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The DropAdditionalSkillsTimeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DropAdditionalSkillsTimeout;
    /**
     * The IsAttributeBased
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAttributeBased;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The OverflowAssignee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $OverflowAssignee;
    /**
     * The OverflowAssigneeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OverflowAssigneeId;
    /**
     * The PushTimeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PushTimeout;
    /**
     * The RoutingModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutingModel;
    /**
     * The RoutingPriority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RoutingPriority;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for QueueRoutingConfig
     * @uses QueueRoutingConfig::setCapacityPercentage()
     * @uses QueueRoutingConfig::setCapacityWeight()
     * @uses QueueRoutingConfig::setCreatedBy()
     * @uses QueueRoutingConfig::setCreatedById()
     * @uses QueueRoutingConfig::setCreatedDate()
     * @uses QueueRoutingConfig::setDeveloperName()
     * @uses QueueRoutingConfig::setDropAdditionalSkillsTimeout()
     * @uses QueueRoutingConfig::setIsAttributeBased()
     * @uses QueueRoutingConfig::setIsDeleted()
     * @uses QueueRoutingConfig::setLanguage()
     * @uses QueueRoutingConfig::setLastModifiedBy()
     * @uses QueueRoutingConfig::setLastModifiedById()
     * @uses QueueRoutingConfig::setLastModifiedDate()
     * @uses QueueRoutingConfig::setMasterLabel()
     * @uses QueueRoutingConfig::setOverflowAssignee()
     * @uses QueueRoutingConfig::setOverflowAssigneeId()
     * @uses QueueRoutingConfig::setPushTimeout()
     * @uses QueueRoutingConfig::setRoutingModel()
     * @uses QueueRoutingConfig::setRoutingPriority()
     * @uses QueueRoutingConfig::setSystemModstamp()
     * @param float $capacityPercentage
     * @param float $capacityWeight
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $developerName
     * @param int $dropAdditionalSkillsTimeout
     * @param bool $isAttributeBased
     * @param bool $isDeleted
     * @param string $language
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $masterLabel
     * @param \NexusDigital/MiratelForce\StructType\SObject $overflowAssignee
     * @param string $overflowAssigneeId
     * @param int $pushTimeout
     * @param string $routingModel
     * @param int $routingPriority
     * @param string $systemModstamp
     */
    public function __construct($capacityPercentage = null, $capacityWeight = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $developerName = null, $dropAdditionalSkillsTimeout = null, $isAttributeBased = null, $isDeleted = null, $language = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $masterLabel = null, \NexusDigital/MiratelForce\StructType\SObject $overflowAssignee = null, $overflowAssigneeId = null, $pushTimeout = null, $routingModel = null, $routingPriority = null, $systemModstamp = null)
    {
        $this
            ->setCapacityPercentage($capacityPercentage)
            ->setCapacityWeight($capacityWeight)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDeveloperName($developerName)
            ->setDropAdditionalSkillsTimeout($dropAdditionalSkillsTimeout)
            ->setIsAttributeBased($isAttributeBased)
            ->setIsDeleted($isDeleted)
            ->setLanguage($language)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMasterLabel($masterLabel)
            ->setOverflowAssignee($overflowAssignee)
            ->setOverflowAssigneeId($overflowAssigneeId)
            ->setPushTimeout($pushTimeout)
            ->setRoutingModel($routingModel)
            ->setRoutingPriority($routingPriority)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get CapacityPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCapacityPercentage()
    {
        return isset($this->CapacityPercentage) ? $this->CapacityPercentage : null;
    }
    /**
     * Set CapacityPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $capacityPercentage
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setCapacityPercentage($capacityPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($capacityPercentage) && !(is_float($capacityPercentage) || is_numeric($capacityPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($capacityPercentage, true), gettype($capacityPercentage)), __LINE__);
        }
        if (is_null($capacityPercentage) || (is_array($capacityPercentage) && empty($capacityPercentage))) {
            unset($this->CapacityPercentage);
        } else {
            $this->CapacityPercentage = $capacityPercentage;
        }
        return $this;
    }
    /**
     * Get CapacityWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCapacityWeight()
    {
        return isset($this->CapacityWeight) ? $this->CapacityWeight : null;
    }
    /**
     * Set CapacityWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $capacityWeight
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setCapacityWeight($capacityWeight = null)
    {
        // validation for constraint: float
        if (!is_null($capacityWeight) && !(is_float($capacityWeight) || is_numeric($capacityWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($capacityWeight, true), gettype($capacityWeight)), __LINE__);
        }
        if (is_null($capacityWeight) || (is_array($capacityWeight) && empty($capacityWeight))) {
            unset($this->CapacityWeight);
        } else {
            $this->CapacityWeight = $capacityWeight;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get DropAdditionalSkillsTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDropAdditionalSkillsTimeout()
    {
        return isset($this->DropAdditionalSkillsTimeout) ? $this->DropAdditionalSkillsTimeout : null;
    }
    /**
     * Set DropAdditionalSkillsTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dropAdditionalSkillsTimeout
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setDropAdditionalSkillsTimeout($dropAdditionalSkillsTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($dropAdditionalSkillsTimeout) && !(is_int($dropAdditionalSkillsTimeout) || ctype_digit($dropAdditionalSkillsTimeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dropAdditionalSkillsTimeout, true), gettype($dropAdditionalSkillsTimeout)), __LINE__);
        }
        if (is_null($dropAdditionalSkillsTimeout) || (is_array($dropAdditionalSkillsTimeout) && empty($dropAdditionalSkillsTimeout))) {
            unset($this->DropAdditionalSkillsTimeout);
        } else {
            $this->DropAdditionalSkillsTimeout = $dropAdditionalSkillsTimeout;
        }
        return $this;
    }
    /**
     * Get IsAttributeBased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAttributeBased()
    {
        return isset($this->IsAttributeBased) ? $this->IsAttributeBased : null;
    }
    /**
     * Set IsAttributeBased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAttributeBased
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setIsAttributeBased($isAttributeBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAttributeBased) && !is_bool($isAttributeBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAttributeBased, true), gettype($isAttributeBased)), __LINE__);
        }
        if (is_null($isAttributeBased) || (is_array($isAttributeBased) && empty($isAttributeBased))) {
            unset($this->IsAttributeBased);
        } else {
            $this->IsAttributeBased = $isAttributeBased;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get OverflowAssignee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getOverflowAssignee()
    {
        return isset($this->OverflowAssignee) ? $this->OverflowAssignee : null;
    }
    /**
     * Set OverflowAssignee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $overflowAssignee
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setOverflowAssignee(\NexusDigital/MiratelForce\StructType\SObject $overflowAssignee = null)
    {
        if (is_null($overflowAssignee) || (is_array($overflowAssignee) && empty($overflowAssignee))) {
            unset($this->OverflowAssignee);
        } else {
            $this->OverflowAssignee = $overflowAssignee;
        }
        return $this;
    }
    /**
     * Get OverflowAssigneeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverflowAssigneeId()
    {
        return isset($this->OverflowAssigneeId) ? $this->OverflowAssigneeId : null;
    }
    /**
     * Set OverflowAssigneeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overflowAssigneeId
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setOverflowAssigneeId($overflowAssigneeId = null)
    {
        // validation for constraint: string
        if (!is_null($overflowAssigneeId) && !is_string($overflowAssigneeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overflowAssigneeId, true), gettype($overflowAssigneeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($overflowAssigneeId) && mb_strlen($overflowAssigneeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($overflowAssigneeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($overflowAssigneeId) && !preg_match('/[a-zA-Z0-9]{18}/', $overflowAssigneeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($overflowAssigneeId, true)), __LINE__);
        }
        if (is_null($overflowAssigneeId) || (is_array($overflowAssigneeId) && empty($overflowAssigneeId))) {
            unset($this->OverflowAssigneeId);
        } else {
            $this->OverflowAssigneeId = $overflowAssigneeId;
        }
        return $this;
    }
    /**
     * Get PushTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPushTimeout()
    {
        return isset($this->PushTimeout) ? $this->PushTimeout : null;
    }
    /**
     * Set PushTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pushTimeout
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setPushTimeout($pushTimeout = null)
    {
        // validation for constraint: int
        if (!is_null($pushTimeout) && !(is_int($pushTimeout) || ctype_digit($pushTimeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pushTimeout, true), gettype($pushTimeout)), __LINE__);
        }
        if (is_null($pushTimeout) || (is_array($pushTimeout) && empty($pushTimeout))) {
            unset($this->PushTimeout);
        } else {
            $this->PushTimeout = $pushTimeout;
        }
        return $this;
    }
    /**
     * Get RoutingModel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingModel()
    {
        return isset($this->RoutingModel) ? $this->RoutingModel : null;
    }
    /**
     * Set RoutingModel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routingModel
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setRoutingModel($routingModel = null)
    {
        // validation for constraint: string
        if (!is_null($routingModel) && !is_string($routingModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingModel, true), gettype($routingModel)), __LINE__);
        }
        if (is_null($routingModel) || (is_array($routingModel) && empty($routingModel))) {
            unset($this->RoutingModel);
        } else {
            $this->RoutingModel = $routingModel;
        }
        return $this;
    }
    /**
     * Get RoutingPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRoutingPriority()
    {
        return isset($this->RoutingPriority) ? $this->RoutingPriority : null;
    }
    /**
     * Set RoutingPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $routingPriority
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setRoutingPriority($routingPriority = null)
    {
        // validation for constraint: int
        if (!is_null($routingPriority) && !(is_int($routingPriority) || ctype_digit($routingPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routingPriority, true), gettype($routingPriority)), __LINE__);
        }
        if (is_null($routingPriority) || (is_array($routingPriority) && empty($routingPriority))) {
            unset($this->RoutingPriority);
        } else {
            $this->RoutingPriority = $routingPriority;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\QueueRoutingConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
