<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PresenceUserConfig StructType
 * @subpackage Structs
 */
class PresenceUserConfig extends SObject
{
    /**
     * The Capacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Capacity;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The OptionsIsAutoAcceptEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsIsAutoAcceptEnabled;
    /**
     * The OptionsIsDeclineEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsIsDeclineEnabled;
    /**
     * The OptionsIsDeclineReasonEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsIsDeclineReasonEnabled;
    /**
     * The OptionsIsDisconnectSoundEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsIsDisconnectSoundEnabled;
    /**
     * The OptionsIsRequestSoundEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsIsRequestSoundEnabled;
    /**
     * The PresenceStatusOnDecline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ServicePresenceStatus
     */
    public $PresenceStatusOnDecline;
    /**
     * The PresenceStatusOnDeclineId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PresenceStatusOnDeclineId;
    /**
     * The PresenceStatusOnPushTimeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ServicePresenceStatus
     */
    public $PresenceStatusOnPushTimeout;
    /**
     * The PresenceStatusOnPushTimeoutId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PresenceStatusOnPushTimeoutId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for PresenceUserConfig
     * @uses PresenceUserConfig::setCapacity()
     * @uses PresenceUserConfig::setCreatedBy()
     * @uses PresenceUserConfig::setCreatedById()
     * @uses PresenceUserConfig::setCreatedDate()
     * @uses PresenceUserConfig::setDeveloperName()
     * @uses PresenceUserConfig::setIsDeleted()
     * @uses PresenceUserConfig::setLanguage()
     * @uses PresenceUserConfig::setLastModifiedBy()
     * @uses PresenceUserConfig::setLastModifiedById()
     * @uses PresenceUserConfig::setLastModifiedDate()
     * @uses PresenceUserConfig::setMasterLabel()
     * @uses PresenceUserConfig::setOptionsIsAutoAcceptEnabled()
     * @uses PresenceUserConfig::setOptionsIsDeclineEnabled()
     * @uses PresenceUserConfig::setOptionsIsDeclineReasonEnabled()
     * @uses PresenceUserConfig::setOptionsIsDisconnectSoundEnabled()
     * @uses PresenceUserConfig::setOptionsIsRequestSoundEnabled()
     * @uses PresenceUserConfig::setPresenceStatusOnDecline()
     * @uses PresenceUserConfig::setPresenceStatusOnDeclineId()
     * @uses PresenceUserConfig::setPresenceStatusOnPushTimeout()
     * @uses PresenceUserConfig::setPresenceStatusOnPushTimeoutId()
     * @uses PresenceUserConfig::setSystemModstamp()
     * @param int $capacity
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $developerName
     * @param bool $isDeleted
     * @param string $language
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $masterLabel
     * @param bool $optionsIsAutoAcceptEnabled
     * @param bool $optionsIsDeclineEnabled
     * @param bool $optionsIsDeclineReasonEnabled
     * @param bool $optionsIsDisconnectSoundEnabled
     * @param bool $optionsIsRequestSoundEnabled
     * @param \NexusDigital/MiratelForce\StructType\ServicePresenceStatus $presenceStatusOnDecline
     * @param string $presenceStatusOnDeclineId
     * @param \NexusDigital/MiratelForce\StructType\ServicePresenceStatus $presenceStatusOnPushTimeout
     * @param string $presenceStatusOnPushTimeoutId
     * @param string $systemModstamp
     */
    public function __construct($capacity = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $developerName = null, $isDeleted = null, $language = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $masterLabel = null, $optionsIsAutoAcceptEnabled = null, $optionsIsDeclineEnabled = null, $optionsIsDeclineReasonEnabled = null, $optionsIsDisconnectSoundEnabled = null, $optionsIsRequestSoundEnabled = null, \NexusDigital/MiratelForce\StructType\ServicePresenceStatus $presenceStatusOnDecline = null, $presenceStatusOnDeclineId = null, \NexusDigital/MiratelForce\StructType\ServicePresenceStatus $presenceStatusOnPushTimeout = null, $presenceStatusOnPushTimeoutId = null, $systemModstamp = null)
    {
        $this
            ->setCapacity($capacity)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDeveloperName($developerName)
            ->setIsDeleted($isDeleted)
            ->setLanguage($language)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMasterLabel($masterLabel)
            ->setOptionsIsAutoAcceptEnabled($optionsIsAutoAcceptEnabled)
            ->setOptionsIsDeclineEnabled($optionsIsDeclineEnabled)
            ->setOptionsIsDeclineReasonEnabled($optionsIsDeclineReasonEnabled)
            ->setOptionsIsDisconnectSoundEnabled($optionsIsDisconnectSoundEnabled)
            ->setOptionsIsRequestSoundEnabled($optionsIsRequestSoundEnabled)
            ->setPresenceStatusOnDecline($presenceStatusOnDecline)
            ->setPresenceStatusOnDeclineId($presenceStatusOnDeclineId)
            ->setPresenceStatusOnPushTimeout($presenceStatusOnPushTimeout)
            ->setPresenceStatusOnPushTimeoutId($presenceStatusOnPushTimeoutId)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get Capacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCapacity()
    {
        return isset($this->Capacity) ? $this->Capacity : null;
    }
    /**
     * Set Capacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $capacity
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !(is_int($capacity) || ctype_digit($capacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capacity, true), gettype($capacity)), __LINE__);
        }
        if (is_null($capacity) || (is_array($capacity) && empty($capacity))) {
            unset($this->Capacity);
        } else {
            $this->Capacity = $capacity;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get OptionsIsAutoAcceptEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsIsAutoAcceptEnabled()
    {
        return isset($this->OptionsIsAutoAcceptEnabled) ? $this->OptionsIsAutoAcceptEnabled : null;
    }
    /**
     * Set OptionsIsAutoAcceptEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsIsAutoAcceptEnabled
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setOptionsIsAutoAcceptEnabled($optionsIsAutoAcceptEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsIsAutoAcceptEnabled) && !is_bool($optionsIsAutoAcceptEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsIsAutoAcceptEnabled, true), gettype($optionsIsAutoAcceptEnabled)), __LINE__);
        }
        if (is_null($optionsIsAutoAcceptEnabled) || (is_array($optionsIsAutoAcceptEnabled) && empty($optionsIsAutoAcceptEnabled))) {
            unset($this->OptionsIsAutoAcceptEnabled);
        } else {
            $this->OptionsIsAutoAcceptEnabled = $optionsIsAutoAcceptEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsIsDeclineEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsIsDeclineEnabled()
    {
        return isset($this->OptionsIsDeclineEnabled) ? $this->OptionsIsDeclineEnabled : null;
    }
    /**
     * Set OptionsIsDeclineEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsIsDeclineEnabled
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setOptionsIsDeclineEnabled($optionsIsDeclineEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsIsDeclineEnabled) && !is_bool($optionsIsDeclineEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsIsDeclineEnabled, true), gettype($optionsIsDeclineEnabled)), __LINE__);
        }
        if (is_null($optionsIsDeclineEnabled) || (is_array($optionsIsDeclineEnabled) && empty($optionsIsDeclineEnabled))) {
            unset($this->OptionsIsDeclineEnabled);
        } else {
            $this->OptionsIsDeclineEnabled = $optionsIsDeclineEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsIsDeclineReasonEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsIsDeclineReasonEnabled()
    {
        return isset($this->OptionsIsDeclineReasonEnabled) ? $this->OptionsIsDeclineReasonEnabled : null;
    }
    /**
     * Set OptionsIsDeclineReasonEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsIsDeclineReasonEnabled
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setOptionsIsDeclineReasonEnabled($optionsIsDeclineReasonEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsIsDeclineReasonEnabled) && !is_bool($optionsIsDeclineReasonEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsIsDeclineReasonEnabled, true), gettype($optionsIsDeclineReasonEnabled)), __LINE__);
        }
        if (is_null($optionsIsDeclineReasonEnabled) || (is_array($optionsIsDeclineReasonEnabled) && empty($optionsIsDeclineReasonEnabled))) {
            unset($this->OptionsIsDeclineReasonEnabled);
        } else {
            $this->OptionsIsDeclineReasonEnabled = $optionsIsDeclineReasonEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsIsDisconnectSoundEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsIsDisconnectSoundEnabled()
    {
        return isset($this->OptionsIsDisconnectSoundEnabled) ? $this->OptionsIsDisconnectSoundEnabled : null;
    }
    /**
     * Set OptionsIsDisconnectSoundEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsIsDisconnectSoundEnabled
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setOptionsIsDisconnectSoundEnabled($optionsIsDisconnectSoundEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsIsDisconnectSoundEnabled) && !is_bool($optionsIsDisconnectSoundEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsIsDisconnectSoundEnabled, true), gettype($optionsIsDisconnectSoundEnabled)), __LINE__);
        }
        if (is_null($optionsIsDisconnectSoundEnabled) || (is_array($optionsIsDisconnectSoundEnabled) && empty($optionsIsDisconnectSoundEnabled))) {
            unset($this->OptionsIsDisconnectSoundEnabled);
        } else {
            $this->OptionsIsDisconnectSoundEnabled = $optionsIsDisconnectSoundEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsIsRequestSoundEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsIsRequestSoundEnabled()
    {
        return isset($this->OptionsIsRequestSoundEnabled) ? $this->OptionsIsRequestSoundEnabled : null;
    }
    /**
     * Set OptionsIsRequestSoundEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsIsRequestSoundEnabled
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setOptionsIsRequestSoundEnabled($optionsIsRequestSoundEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsIsRequestSoundEnabled) && !is_bool($optionsIsRequestSoundEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsIsRequestSoundEnabled, true), gettype($optionsIsRequestSoundEnabled)), __LINE__);
        }
        if (is_null($optionsIsRequestSoundEnabled) || (is_array($optionsIsRequestSoundEnabled) && empty($optionsIsRequestSoundEnabled))) {
            unset($this->OptionsIsRequestSoundEnabled);
        } else {
            $this->OptionsIsRequestSoundEnabled = $optionsIsRequestSoundEnabled;
        }
        return $this;
    }
    /**
     * Get PresenceStatusOnDecline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ServicePresenceStatus|null
     */
    public function getPresenceStatusOnDecline()
    {
        return isset($this->PresenceStatusOnDecline) ? $this->PresenceStatusOnDecline : null;
    }
    /**
     * Set PresenceStatusOnDecline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ServicePresenceStatus $presenceStatusOnDecline
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setPresenceStatusOnDecline(\NexusDigital/MiratelForce\StructType\ServicePresenceStatus $presenceStatusOnDecline = null)
    {
        if (is_null($presenceStatusOnDecline) || (is_array($presenceStatusOnDecline) && empty($presenceStatusOnDecline))) {
            unset($this->PresenceStatusOnDecline);
        } else {
            $this->PresenceStatusOnDecline = $presenceStatusOnDecline;
        }
        return $this;
    }
    /**
     * Get PresenceStatusOnDeclineId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPresenceStatusOnDeclineId()
    {
        return isset($this->PresenceStatusOnDeclineId) ? $this->PresenceStatusOnDeclineId : null;
    }
    /**
     * Set PresenceStatusOnDeclineId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $presenceStatusOnDeclineId
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setPresenceStatusOnDeclineId($presenceStatusOnDeclineId = null)
    {
        // validation for constraint: string
        if (!is_null($presenceStatusOnDeclineId) && !is_string($presenceStatusOnDeclineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presenceStatusOnDeclineId, true), gettype($presenceStatusOnDeclineId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($presenceStatusOnDeclineId) && mb_strlen($presenceStatusOnDeclineId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($presenceStatusOnDeclineId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($presenceStatusOnDeclineId) && !preg_match('/[a-zA-Z0-9]{18}/', $presenceStatusOnDeclineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($presenceStatusOnDeclineId, true)), __LINE__);
        }
        if (is_null($presenceStatusOnDeclineId) || (is_array($presenceStatusOnDeclineId) && empty($presenceStatusOnDeclineId))) {
            unset($this->PresenceStatusOnDeclineId);
        } else {
            $this->PresenceStatusOnDeclineId = $presenceStatusOnDeclineId;
        }
        return $this;
    }
    /**
     * Get PresenceStatusOnPushTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ServicePresenceStatus|null
     */
    public function getPresenceStatusOnPushTimeout()
    {
        return isset($this->PresenceStatusOnPushTimeout) ? $this->PresenceStatusOnPushTimeout : null;
    }
    /**
     * Set PresenceStatusOnPushTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ServicePresenceStatus $presenceStatusOnPushTimeout
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setPresenceStatusOnPushTimeout(\NexusDigital/MiratelForce\StructType\ServicePresenceStatus $presenceStatusOnPushTimeout = null)
    {
        if (is_null($presenceStatusOnPushTimeout) || (is_array($presenceStatusOnPushTimeout) && empty($presenceStatusOnPushTimeout))) {
            unset($this->PresenceStatusOnPushTimeout);
        } else {
            $this->PresenceStatusOnPushTimeout = $presenceStatusOnPushTimeout;
        }
        return $this;
    }
    /**
     * Get PresenceStatusOnPushTimeoutId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPresenceStatusOnPushTimeoutId()
    {
        return isset($this->PresenceStatusOnPushTimeoutId) ? $this->PresenceStatusOnPushTimeoutId : null;
    }
    /**
     * Set PresenceStatusOnPushTimeoutId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $presenceStatusOnPushTimeoutId
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setPresenceStatusOnPushTimeoutId($presenceStatusOnPushTimeoutId = null)
    {
        // validation for constraint: string
        if (!is_null($presenceStatusOnPushTimeoutId) && !is_string($presenceStatusOnPushTimeoutId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presenceStatusOnPushTimeoutId, true), gettype($presenceStatusOnPushTimeoutId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($presenceStatusOnPushTimeoutId) && mb_strlen($presenceStatusOnPushTimeoutId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($presenceStatusOnPushTimeoutId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($presenceStatusOnPushTimeoutId) && !preg_match('/[a-zA-Z0-9]{18}/', $presenceStatusOnPushTimeoutId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($presenceStatusOnPushTimeoutId, true)), __LINE__);
        }
        if (is_null($presenceStatusOnPushTimeoutId) || (is_array($presenceStatusOnPushTimeoutId) && empty($presenceStatusOnPushTimeoutId))) {
            unset($this->PresenceStatusOnPushTimeoutId);
        } else {
            $this->PresenceStatusOnPushTimeoutId = $presenceStatusOnPushTimeoutId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\PresenceUserConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
