<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlatformAction StructType
 * @subpackage Structs
 */
class PlatformAction extends SObject
{
    /**
     * The ActionListContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionListContext;
    /**
     * The ActionTarget
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionTarget;
    /**
     * The ActionTargetType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionTargetType;
    /**
     * The ApiName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiName;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The ConfirmationMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationMessage;
    /**
     * The DeviceFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceFormat;
    /**
     * The ExternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The GroupId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $GroupId;
    /**
     * The IconContentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IconContentType;
    /**
     * The IconHeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IconHeight;
    /**
     * The IconUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IconUrl;
    /**
     * The IconWidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IconWidth;
    /**
     * The InvocationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvocationStatus;
    /**
     * The InvokedByUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $InvokedByUser;
    /**
     * The InvokedByUserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $InvokedByUserId;
    /**
     * The IsGroupDefault
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupDefault;
    /**
     * The IsMassAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMassAction;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The PrimaryColor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryColor;
    /**
     * The RelatedListRecordId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedListRecordId;
    /**
     * The RelatedSourceEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedSourceEntity;
    /**
     * The Section
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Section;
    /**
     * The SourceEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceEntity;
    /**
     * The Subtype
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Subtype;
    /**
     * The TargetObject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetObject;
    /**
     * The TargetUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetUrl;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for PlatformAction
     * @uses PlatformAction::setActionListContext()
     * @uses PlatformAction::setActionTarget()
     * @uses PlatformAction::setActionTargetType()
     * @uses PlatformAction::setApiName()
     * @uses PlatformAction::setCategory()
     * @uses PlatformAction::setConfirmationMessage()
     * @uses PlatformAction::setDeviceFormat()
     * @uses PlatformAction::setExternalId()
     * @uses PlatformAction::setGroupId()
     * @uses PlatformAction::setIconContentType()
     * @uses PlatformAction::setIconHeight()
     * @uses PlatformAction::setIconUrl()
     * @uses PlatformAction::setIconWidth()
     * @uses PlatformAction::setInvocationStatus()
     * @uses PlatformAction::setInvokedByUser()
     * @uses PlatformAction::setInvokedByUserId()
     * @uses PlatformAction::setIsGroupDefault()
     * @uses PlatformAction::setIsMassAction()
     * @uses PlatformAction::setLabel()
     * @uses PlatformAction::setLastModifiedDate()
     * @uses PlatformAction::setPrimaryColor()
     * @uses PlatformAction::setRelatedListRecordId()
     * @uses PlatformAction::setRelatedSourceEntity()
     * @uses PlatformAction::setSection()
     * @uses PlatformAction::setSourceEntity()
     * @uses PlatformAction::setSubtype()
     * @uses PlatformAction::setTargetObject()
     * @uses PlatformAction::setTargetUrl()
     * @uses PlatformAction::setType()
     * @param string $actionListContext
     * @param string $actionTarget
     * @param string $actionTargetType
     * @param string $apiName
     * @param string $category
     * @param string $confirmationMessage
     * @param string $deviceFormat
     * @param string $externalId
     * @param string $groupId
     * @param string $iconContentType
     * @param int $iconHeight
     * @param string $iconUrl
     * @param int $iconWidth
     * @param string $invocationStatus
     * @param \NexusDigital/MiratelForce\StructType\User $invokedByUser
     * @param string $invokedByUserId
     * @param bool $isGroupDefault
     * @param bool $isMassAction
     * @param string $label
     * @param string $lastModifiedDate
     * @param string $primaryColor
     * @param string $relatedListRecordId
     * @param string $relatedSourceEntity
     * @param string $section
     * @param string $sourceEntity
     * @param string $subtype
     * @param string $targetObject
     * @param string $targetUrl
     * @param string $type
     */
    public function __construct($actionListContext = null, $actionTarget = null, $actionTargetType = null, $apiName = null, $category = null, $confirmationMessage = null, $deviceFormat = null, $externalId = null, $groupId = null, $iconContentType = null, $iconHeight = null, $iconUrl = null, $iconWidth = null, $invocationStatus = null, \NexusDigital/MiratelForce\StructType\User $invokedByUser = null, $invokedByUserId = null, $isGroupDefault = null, $isMassAction = null, $label = null, $lastModifiedDate = null, $primaryColor = null, $relatedListRecordId = null, $relatedSourceEntity = null, $section = null, $sourceEntity = null, $subtype = null, $targetObject = null, $targetUrl = null, $type = null)
    {
        $this
            ->setActionListContext($actionListContext)
            ->setActionTarget($actionTarget)
            ->setActionTargetType($actionTargetType)
            ->setApiName($apiName)
            ->setCategory($category)
            ->setConfirmationMessage($confirmationMessage)
            ->setDeviceFormat($deviceFormat)
            ->setExternalId($externalId)
            ->setGroupId($groupId)
            ->setIconContentType($iconContentType)
            ->setIconHeight($iconHeight)
            ->setIconUrl($iconUrl)
            ->setIconWidth($iconWidth)
            ->setInvocationStatus($invocationStatus)
            ->setInvokedByUser($invokedByUser)
            ->setInvokedByUserId($invokedByUserId)
            ->setIsGroupDefault($isGroupDefault)
            ->setIsMassAction($isMassAction)
            ->setLabel($label)
            ->setLastModifiedDate($lastModifiedDate)
            ->setPrimaryColor($primaryColor)
            ->setRelatedListRecordId($relatedListRecordId)
            ->setRelatedSourceEntity($relatedSourceEntity)
            ->setSection($section)
            ->setSourceEntity($sourceEntity)
            ->setSubtype($subtype)
            ->setTargetObject($targetObject)
            ->setTargetUrl($targetUrl)
            ->setType($type);
    }
    /**
     * Get ActionListContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionListContext()
    {
        return isset($this->ActionListContext) ? $this->ActionListContext : null;
    }
    /**
     * Set ActionListContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionListContext
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setActionListContext($actionListContext = null)
    {
        // validation for constraint: string
        if (!is_null($actionListContext) && !is_string($actionListContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionListContext, true), gettype($actionListContext)), __LINE__);
        }
        if (is_null($actionListContext) || (is_array($actionListContext) && empty($actionListContext))) {
            unset($this->ActionListContext);
        } else {
            $this->ActionListContext = $actionListContext;
        }
        return $this;
    }
    /**
     * Get ActionTarget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionTarget()
    {
        return isset($this->ActionTarget) ? $this->ActionTarget : null;
    }
    /**
     * Set ActionTarget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionTarget
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setActionTarget($actionTarget = null)
    {
        // validation for constraint: string
        if (!is_null($actionTarget) && !is_string($actionTarget)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionTarget, true), gettype($actionTarget)), __LINE__);
        }
        if (is_null($actionTarget) || (is_array($actionTarget) && empty($actionTarget))) {
            unset($this->ActionTarget);
        } else {
            $this->ActionTarget = $actionTarget;
        }
        return $this;
    }
    /**
     * Get ActionTargetType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionTargetType()
    {
        return isset($this->ActionTargetType) ? $this->ActionTargetType : null;
    }
    /**
     * Set ActionTargetType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionTargetType
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setActionTargetType($actionTargetType = null)
    {
        // validation for constraint: string
        if (!is_null($actionTargetType) && !is_string($actionTargetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionTargetType, true), gettype($actionTargetType)), __LINE__);
        }
        if (is_null($actionTargetType) || (is_array($actionTargetType) && empty($actionTargetType))) {
            unset($this->ActionTargetType);
        } else {
            $this->ActionTargetType = $actionTargetType;
        }
        return $this;
    }
    /**
     * Get ApiName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiName()
    {
        return isset($this->ApiName) ? $this->ApiName : null;
    }
    /**
     * Set ApiName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiName
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setApiName($apiName = null)
    {
        // validation for constraint: string
        if (!is_null($apiName) && !is_string($apiName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiName, true), gettype($apiName)), __LINE__);
        }
        if (is_null($apiName) || (is_array($apiName) && empty($apiName))) {
            unset($this->ApiName);
        } else {
            $this->ApiName = $apiName;
        }
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get ConfirmationMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationMessage()
    {
        return isset($this->ConfirmationMessage) ? $this->ConfirmationMessage : null;
    }
    /**
     * Set ConfirmationMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationMessage
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setConfirmationMessage($confirmationMessage = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationMessage) && !is_string($confirmationMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationMessage, true), gettype($confirmationMessage)), __LINE__);
        }
        if (is_null($confirmationMessage) || (is_array($confirmationMessage) && empty($confirmationMessage))) {
            unset($this->ConfirmationMessage);
        } else {
            $this->ConfirmationMessage = $confirmationMessage;
        }
        return $this;
    }
    /**
     * Get DeviceFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceFormat()
    {
        return isset($this->DeviceFormat) ? $this->DeviceFormat : null;
    }
    /**
     * Set DeviceFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceFormat
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setDeviceFormat($deviceFormat = null)
    {
        // validation for constraint: string
        if (!is_null($deviceFormat) && !is_string($deviceFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceFormat, true), gettype($deviceFormat)), __LINE__);
        }
        if (is_null($deviceFormat) || (is_array($deviceFormat) && empty($deviceFormat))) {
            unset($this->DeviceFormat);
        } else {
            $this->DeviceFormat = $deviceFormat;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupId()
    {
        return isset($this->GroupId) ? $this->GroupId : null;
    }
    /**
     * Set GroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupId
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($groupId) && mb_strlen($groupId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($groupId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($groupId) && !preg_match('/[a-zA-Z0-9]{18}/', $groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($groupId, true)), __LINE__);
        }
        if (is_null($groupId) || (is_array($groupId) && empty($groupId))) {
            unset($this->GroupId);
        } else {
            $this->GroupId = $groupId;
        }
        return $this;
    }
    /**
     * Get IconContentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIconContentType()
    {
        return isset($this->IconContentType) ? $this->IconContentType : null;
    }
    /**
     * Set IconContentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iconContentType
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setIconContentType($iconContentType = null)
    {
        // validation for constraint: string
        if (!is_null($iconContentType) && !is_string($iconContentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iconContentType, true), gettype($iconContentType)), __LINE__);
        }
        if (is_null($iconContentType) || (is_array($iconContentType) && empty($iconContentType))) {
            unset($this->IconContentType);
        } else {
            $this->IconContentType = $iconContentType;
        }
        return $this;
    }
    /**
     * Get IconHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIconHeight()
    {
        return isset($this->IconHeight) ? $this->IconHeight : null;
    }
    /**
     * Set IconHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iconHeight
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setIconHeight($iconHeight = null)
    {
        // validation for constraint: int
        if (!is_null($iconHeight) && !(is_int($iconHeight) || ctype_digit($iconHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iconHeight, true), gettype($iconHeight)), __LINE__);
        }
        if (is_null($iconHeight) || (is_array($iconHeight) && empty($iconHeight))) {
            unset($this->IconHeight);
        } else {
            $this->IconHeight = $iconHeight;
        }
        return $this;
    }
    /**
     * Get IconUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIconUrl()
    {
        return isset($this->IconUrl) ? $this->IconUrl : null;
    }
    /**
     * Set IconUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iconUrl
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setIconUrl($iconUrl = null)
    {
        // validation for constraint: string
        if (!is_null($iconUrl) && !is_string($iconUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iconUrl, true), gettype($iconUrl)), __LINE__);
        }
        if (is_null($iconUrl) || (is_array($iconUrl) && empty($iconUrl))) {
            unset($this->IconUrl);
        } else {
            $this->IconUrl = $iconUrl;
        }
        return $this;
    }
    /**
     * Get IconWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIconWidth()
    {
        return isset($this->IconWidth) ? $this->IconWidth : null;
    }
    /**
     * Set IconWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iconWidth
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setIconWidth($iconWidth = null)
    {
        // validation for constraint: int
        if (!is_null($iconWidth) && !(is_int($iconWidth) || ctype_digit($iconWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iconWidth, true), gettype($iconWidth)), __LINE__);
        }
        if (is_null($iconWidth) || (is_array($iconWidth) && empty($iconWidth))) {
            unset($this->IconWidth);
        } else {
            $this->IconWidth = $iconWidth;
        }
        return $this;
    }
    /**
     * Get InvocationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvocationStatus()
    {
        return isset($this->InvocationStatus) ? $this->InvocationStatus : null;
    }
    /**
     * Set InvocationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invocationStatus
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setInvocationStatus($invocationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($invocationStatus) && !is_string($invocationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invocationStatus, true), gettype($invocationStatus)), __LINE__);
        }
        if (is_null($invocationStatus) || (is_array($invocationStatus) && empty($invocationStatus))) {
            unset($this->InvocationStatus);
        } else {
            $this->InvocationStatus = $invocationStatus;
        }
        return $this;
    }
    /**
     * Get InvokedByUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getInvokedByUser()
    {
        return isset($this->InvokedByUser) ? $this->InvokedByUser : null;
    }
    /**
     * Set InvokedByUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $invokedByUser
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setInvokedByUser(\NexusDigital/MiratelForce\StructType\User $invokedByUser = null)
    {
        if (is_null($invokedByUser) || (is_array($invokedByUser) && empty($invokedByUser))) {
            unset($this->InvokedByUser);
        } else {
            $this->InvokedByUser = $invokedByUser;
        }
        return $this;
    }
    /**
     * Get InvokedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvokedByUserId()
    {
        return isset($this->InvokedByUserId) ? $this->InvokedByUserId : null;
    }
    /**
     * Set InvokedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invokedByUserId
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setInvokedByUserId($invokedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($invokedByUserId) && !is_string($invokedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invokedByUserId, true), gettype($invokedByUserId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($invokedByUserId) && mb_strlen($invokedByUserId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($invokedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($invokedByUserId) && !preg_match('/[a-zA-Z0-9]{18}/', $invokedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($invokedByUserId, true)), __LINE__);
        }
        if (is_null($invokedByUserId) || (is_array($invokedByUserId) && empty($invokedByUserId))) {
            unset($this->InvokedByUserId);
        } else {
            $this->InvokedByUserId = $invokedByUserId;
        }
        return $this;
    }
    /**
     * Get IsGroupDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupDefault()
    {
        return isset($this->IsGroupDefault) ? $this->IsGroupDefault : null;
    }
    /**
     * Set IsGroupDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupDefault
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setIsGroupDefault($isGroupDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupDefault) && !is_bool($isGroupDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupDefault, true), gettype($isGroupDefault)), __LINE__);
        }
        if (is_null($isGroupDefault) || (is_array($isGroupDefault) && empty($isGroupDefault))) {
            unset($this->IsGroupDefault);
        } else {
            $this->IsGroupDefault = $isGroupDefault;
        }
        return $this;
    }
    /**
     * Get IsMassAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMassAction()
    {
        return isset($this->IsMassAction) ? $this->IsMassAction : null;
    }
    /**
     * Set IsMassAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMassAction
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setIsMassAction($isMassAction = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMassAction) && !is_bool($isMassAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMassAction, true), gettype($isMassAction)), __LINE__);
        }
        if (is_null($isMassAction) || (is_array($isMassAction) && empty($isMassAction))) {
            unset($this->IsMassAction);
        } else {
            $this->IsMassAction = $isMassAction;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get PrimaryColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryColor()
    {
        return isset($this->PrimaryColor) ? $this->PrimaryColor : null;
    }
    /**
     * Set PrimaryColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryColor
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setPrimaryColor($primaryColor = null)
    {
        // validation for constraint: string
        if (!is_null($primaryColor) && !is_string($primaryColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryColor, true), gettype($primaryColor)), __LINE__);
        }
        if (is_null($primaryColor) || (is_array($primaryColor) && empty($primaryColor))) {
            unset($this->PrimaryColor);
        } else {
            $this->PrimaryColor = $primaryColor;
        }
        return $this;
    }
    /**
     * Get RelatedListRecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedListRecordId()
    {
        return isset($this->RelatedListRecordId) ? $this->RelatedListRecordId : null;
    }
    /**
     * Set RelatedListRecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedListRecordId
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setRelatedListRecordId($relatedListRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedListRecordId) && !is_string($relatedListRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedListRecordId, true), gettype($relatedListRecordId)), __LINE__);
        }
        if (is_null($relatedListRecordId) || (is_array($relatedListRecordId) && empty($relatedListRecordId))) {
            unset($this->RelatedListRecordId);
        } else {
            $this->RelatedListRecordId = $relatedListRecordId;
        }
        return $this;
    }
    /**
     * Get RelatedSourceEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedSourceEntity()
    {
        return isset($this->RelatedSourceEntity) ? $this->RelatedSourceEntity : null;
    }
    /**
     * Set RelatedSourceEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedSourceEntity
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setRelatedSourceEntity($relatedSourceEntity = null)
    {
        // validation for constraint: string
        if (!is_null($relatedSourceEntity) && !is_string($relatedSourceEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedSourceEntity, true), gettype($relatedSourceEntity)), __LINE__);
        }
        if (is_null($relatedSourceEntity) || (is_array($relatedSourceEntity) && empty($relatedSourceEntity))) {
            unset($this->RelatedSourceEntity);
        } else {
            $this->RelatedSourceEntity = $relatedSourceEntity;
        }
        return $this;
    }
    /**
     * Get Section value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSection()
    {
        return isset($this->Section) ? $this->Section : null;
    }
    /**
     * Set Section value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $section
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setSection($section = null)
    {
        // validation for constraint: string
        if (!is_null($section) && !is_string($section)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($section, true), gettype($section)), __LINE__);
        }
        if (is_null($section) || (is_array($section) && empty($section))) {
            unset($this->Section);
        } else {
            $this->Section = $section;
        }
        return $this;
    }
    /**
     * Get SourceEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceEntity()
    {
        return isset($this->SourceEntity) ? $this->SourceEntity : null;
    }
    /**
     * Set SourceEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceEntity
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setSourceEntity($sourceEntity = null)
    {
        // validation for constraint: string
        if (!is_null($sourceEntity) && !is_string($sourceEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceEntity, true), gettype($sourceEntity)), __LINE__);
        }
        if (is_null($sourceEntity) || (is_array($sourceEntity) && empty($sourceEntity))) {
            unset($this->SourceEntity);
        } else {
            $this->SourceEntity = $sourceEntity;
        }
        return $this;
    }
    /**
     * Get Subtype value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubtype()
    {
        return isset($this->Subtype) ? $this->Subtype : null;
    }
    /**
     * Set Subtype value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subtype
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setSubtype($subtype = null)
    {
        // validation for constraint: string
        if (!is_null($subtype) && !is_string($subtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subtype, true), gettype($subtype)), __LINE__);
        }
        if (is_null($subtype) || (is_array($subtype) && empty($subtype))) {
            unset($this->Subtype);
        } else {
            $this->Subtype = $subtype;
        }
        return $this;
    }
    /**
     * Get TargetObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetObject()
    {
        return isset($this->TargetObject) ? $this->TargetObject : null;
    }
    /**
     * Set TargetObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetObject
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setTargetObject($targetObject = null)
    {
        // validation for constraint: string
        if (!is_null($targetObject) && !is_string($targetObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetObject, true), gettype($targetObject)), __LINE__);
        }
        if (is_null($targetObject) || (is_array($targetObject) && empty($targetObject))) {
            unset($this->TargetObject);
        } else {
            $this->TargetObject = $targetObject;
        }
        return $this;
    }
    /**
     * Get TargetUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetUrl()
    {
        return isset($this->TargetUrl) ? $this->TargetUrl : null;
    }
    /**
     * Set TargetUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetUrl
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setTargetUrl($targetUrl = null)
    {
        // validation for constraint: string
        if (!is_null($targetUrl) && !is_string($targetUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetUrl, true), gettype($targetUrl)), __LINE__);
        }
        if (is_null($targetUrl) || (is_array($targetUrl) && empty($targetUrl))) {
            unset($this->TargetUrl);
        } else {
            $this->TargetUrl = $targetUrl;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\PlatformAction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
