<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PermissionSetAssignment StructType
 * @subpackage Structs
 */
class PermissionSetAssignment extends SObject
{
    /**
     * The Assignee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Assignee;
    /**
     * The AssigneeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AssigneeId;
    /**
     * The PermissionSet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\PermissionSet
     */
    public $PermissionSet;
    /**
     * The PermissionSetId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PermissionSetId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for PermissionSetAssignment
     * @uses PermissionSetAssignment::setAssignee()
     * @uses PermissionSetAssignment::setAssigneeId()
     * @uses PermissionSetAssignment::setPermissionSet()
     * @uses PermissionSetAssignment::setPermissionSetId()
     * @uses PermissionSetAssignment::setSystemModstamp()
     * @param \NexusDigital/MiratelForce\StructType\User $assignee
     * @param string $assigneeId
     * @param \NexusDigital/MiratelForce\StructType\PermissionSet $permissionSet
     * @param string $permissionSetId
     * @param string $systemModstamp
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $assignee = null, $assigneeId = null, \NexusDigital/MiratelForce\StructType\PermissionSet $permissionSet = null, $permissionSetId = null, $systemModstamp = null)
    {
        $this
            ->setAssignee($assignee)
            ->setAssigneeId($assigneeId)
            ->setPermissionSet($permissionSet)
            ->setPermissionSetId($permissionSetId)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get Assignee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getAssignee()
    {
        return isset($this->Assignee) ? $this->Assignee : null;
    }
    /**
     * Set Assignee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $assignee
     * @return \NexusDigital/MiratelForce\StructType\PermissionSetAssignment
     */
    public function setAssignee(\NexusDigital/MiratelForce\StructType\User $assignee = null)
    {
        if (is_null($assignee) || (is_array($assignee) && empty($assignee))) {
            unset($this->Assignee);
        } else {
            $this->Assignee = $assignee;
        }
        return $this;
    }
    /**
     * Get AssigneeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssigneeId()
    {
        return isset($this->AssigneeId) ? $this->AssigneeId : null;
    }
    /**
     * Set AssigneeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assigneeId
     * @return \NexusDigital/MiratelForce\StructType\PermissionSetAssignment
     */
    public function setAssigneeId($assigneeId = null)
    {
        // validation for constraint: string
        if (!is_null($assigneeId) && !is_string($assigneeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assigneeId, true), gettype($assigneeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($assigneeId) && mb_strlen($assigneeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($assigneeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($assigneeId) && !preg_match('/[a-zA-Z0-9]{18}/', $assigneeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($assigneeId, true)), __LINE__);
        }
        if (is_null($assigneeId) || (is_array($assigneeId) && empty($assigneeId))) {
            unset($this->AssigneeId);
        } else {
            $this->AssigneeId = $assigneeId;
        }
        return $this;
    }
    /**
     * Get PermissionSet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\PermissionSet|null
     */
    public function getPermissionSet()
    {
        return isset($this->PermissionSet) ? $this->PermissionSet : null;
    }
    /**
     * Set PermissionSet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\PermissionSet $permissionSet
     * @return \NexusDigital/MiratelForce\StructType\PermissionSetAssignment
     */
    public function setPermissionSet(\NexusDigital/MiratelForce\StructType\PermissionSet $permissionSet = null)
    {
        if (is_null($permissionSet) || (is_array($permissionSet) && empty($permissionSet))) {
            unset($this->PermissionSet);
        } else {
            $this->PermissionSet = $permissionSet;
        }
        return $this;
    }
    /**
     * Get PermissionSetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPermissionSetId()
    {
        return isset($this->PermissionSetId) ? $this->PermissionSetId : null;
    }
    /**
     * Set PermissionSetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $permissionSetId
     * @return \NexusDigital/MiratelForce\StructType\PermissionSetAssignment
     */
    public function setPermissionSetId($permissionSetId = null)
    {
        // validation for constraint: string
        if (!is_null($permissionSetId) && !is_string($permissionSetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($permissionSetId, true), gettype($permissionSetId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($permissionSetId) && mb_strlen($permissionSetId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($permissionSetId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($permissionSetId) && !preg_match('/[a-zA-Z0-9]{18}/', $permissionSetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($permissionSetId, true)), __LINE__);
        }
        if (is_null($permissionSetId) || (is_array($permissionSetId) && empty($permissionSetId))) {
            unset($this->PermissionSetId);
        } else {
            $this->PermissionSetId = $permissionSetId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\PermissionSetAssignment
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\PermissionSetAssignment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
