<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Period StructType
 * @subpackage Structs
 */
class Period extends SObject
{
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The FiscalYearSettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public $FiscalYearSettings;
    /**
     * The FiscalYearSettingsId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $FiscalYearSettingsId;
    /**
     * The FullyQualifiedLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullyQualifiedLabel;
    /**
     * The IsForecastPeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForecastPeriod;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Number;
    /**
     * The PeriodLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PeriodLabel;
    /**
     * The QuarterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuarterLabel;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Period
     * @uses Period::setEndDate()
     * @uses Period::setFiscalYearSettings()
     * @uses Period::setFiscalYearSettingsId()
     * @uses Period::setFullyQualifiedLabel()
     * @uses Period::setIsForecastPeriod()
     * @uses Period::setNumber()
     * @uses Period::setPeriodLabel()
     * @uses Period::setQuarterLabel()
     * @uses Period::setStartDate()
     * @uses Period::setSystemModstamp()
     * @uses Period::setType()
     * @param string $endDate
     * @param \NexusDigital/MiratelForce\StructType\FiscalYearSettings $fiscalYearSettings
     * @param string $fiscalYearSettingsId
     * @param string $fullyQualifiedLabel
     * @param bool $isForecastPeriod
     * @param int $number
     * @param string $periodLabel
     * @param string $quarterLabel
     * @param string $startDate
     * @param string $systemModstamp
     * @param string $type
     */
    public function __construct($endDate = null, \NexusDigital/MiratelForce\StructType\FiscalYearSettings $fiscalYearSettings = null, $fiscalYearSettingsId = null, $fullyQualifiedLabel = null, $isForecastPeriod = null, $number = null, $periodLabel = null, $quarterLabel = null, $startDate = null, $systemModstamp = null, $type = null)
    {
        $this
            ->setEndDate($endDate)
            ->setFiscalYearSettings($fiscalYearSettings)
            ->setFiscalYearSettingsId($fiscalYearSettingsId)
            ->setFullyQualifiedLabel($fullyQualifiedLabel)
            ->setIsForecastPeriod($isForecastPeriod)
            ->setNumber($number)
            ->setPeriodLabel($periodLabel)
            ->setQuarterLabel($quarterLabel)
            ->setStartDate($startDate)
            ->setSystemModstamp($systemModstamp)
            ->setType($type);
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get FiscalYearSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings|null
     */
    public function getFiscalYearSettings()
    {
        return isset($this->FiscalYearSettings) ? $this->FiscalYearSettings : null;
    }
    /**
     * Set FiscalYearSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\FiscalYearSettings $fiscalYearSettings
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setFiscalYearSettings(\NexusDigital/MiratelForce\StructType\FiscalYearSettings $fiscalYearSettings = null)
    {
        if (is_null($fiscalYearSettings) || (is_array($fiscalYearSettings) && empty($fiscalYearSettings))) {
            unset($this->FiscalYearSettings);
        } else {
            $this->FiscalYearSettings = $fiscalYearSettings;
        }
        return $this;
    }
    /**
     * Get FiscalYearSettingsId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFiscalYearSettingsId()
    {
        return isset($this->FiscalYearSettingsId) ? $this->FiscalYearSettingsId : null;
    }
    /**
     * Set FiscalYearSettingsId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fiscalYearSettingsId
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setFiscalYearSettingsId($fiscalYearSettingsId = null)
    {
        // validation for constraint: string
        if (!is_null($fiscalYearSettingsId) && !is_string($fiscalYearSettingsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fiscalYearSettingsId, true), gettype($fiscalYearSettingsId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($fiscalYearSettingsId) && mb_strlen($fiscalYearSettingsId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($fiscalYearSettingsId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($fiscalYearSettingsId) && !preg_match('/[a-zA-Z0-9]{18}/', $fiscalYearSettingsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($fiscalYearSettingsId, true)), __LINE__);
        }
        if (is_null($fiscalYearSettingsId) || (is_array($fiscalYearSettingsId) && empty($fiscalYearSettingsId))) {
            unset($this->FiscalYearSettingsId);
        } else {
            $this->FiscalYearSettingsId = $fiscalYearSettingsId;
        }
        return $this;
    }
    /**
     * Get FullyQualifiedLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullyQualifiedLabel()
    {
        return isset($this->FullyQualifiedLabel) ? $this->FullyQualifiedLabel : null;
    }
    /**
     * Set FullyQualifiedLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullyQualifiedLabel
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setFullyQualifiedLabel($fullyQualifiedLabel = null)
    {
        // validation for constraint: string
        if (!is_null($fullyQualifiedLabel) && !is_string($fullyQualifiedLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullyQualifiedLabel, true), gettype($fullyQualifiedLabel)), __LINE__);
        }
        if (is_null($fullyQualifiedLabel) || (is_array($fullyQualifiedLabel) && empty($fullyQualifiedLabel))) {
            unset($this->FullyQualifiedLabel);
        } else {
            $this->FullyQualifiedLabel = $fullyQualifiedLabel;
        }
        return $this;
    }
    /**
     * Get IsForecastPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForecastPeriod()
    {
        return isset($this->IsForecastPeriod) ? $this->IsForecastPeriod : null;
    }
    /**
     * Set IsForecastPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForecastPeriod
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setIsForecastPeriod($isForecastPeriod = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForecastPeriod) && !is_bool($isForecastPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForecastPeriod, true), gettype($isForecastPeriod)), __LINE__);
        }
        if (is_null($isForecastPeriod) || (is_array($isForecastPeriod) && empty($isForecastPeriod))) {
            unset($this->IsForecastPeriod);
        } else {
            $this->IsForecastPeriod = $isForecastPeriod;
        }
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $number
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get PeriodLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodLabel()
    {
        return isset($this->PeriodLabel) ? $this->PeriodLabel : null;
    }
    /**
     * Set PeriodLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodLabel
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setPeriodLabel($periodLabel = null)
    {
        // validation for constraint: string
        if (!is_null($periodLabel) && !is_string($periodLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodLabel, true), gettype($periodLabel)), __LINE__);
        }
        if (is_null($periodLabel) || (is_array($periodLabel) && empty($periodLabel))) {
            unset($this->PeriodLabel);
        } else {
            $this->PeriodLabel = $periodLabel;
        }
        return $this;
    }
    /**
     * Get QuarterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuarterLabel()
    {
        return isset($this->QuarterLabel) ? $this->QuarterLabel : null;
    }
    /**
     * Set QuarterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $quarterLabel
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setQuarterLabel($quarterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($quarterLabel) && !is_string($quarterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quarterLabel, true), gettype($quarterLabel)), __LINE__);
        }
        if (is_null($quarterLabel) || (is_array($quarterLabel) && empty($quarterLabel))) {
            unset($this->QuarterLabel);
        } else {
            $this->QuarterLabel = $quarterLabel;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Period
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
