<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpenActivity StructType
 * @subpackage Structs
 */
class OpenActivity extends SObject
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Account
     */
    public $Account;
    /**
     * The AccountId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AccountId;
    /**
     * The ActivityDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityDate;
    /**
     * The ActivityDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityDateTime;
    /**
     * The ActivitySubtype
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivitySubtype;
    /**
     * The ActivityType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityType;
    /**
     * The Adds_Changes_Removes_SMD__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Adds_Changes_Removes_SMD__c;
    /**
     * The Adds_Changes_Removes_StolleryLottery__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Adds_Changes_Removes_StolleryLottery__c;
    /**
     * The Adds_Changes_Removes__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Adds_Changes_Removes__c;
    /**
     * The Agent_ID__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Agent_ID__c;
    /**
     * The Agent__c
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $Agent__c;
    /**
     * The Agent__r
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Agent__r;
    /**
     * The AlternateDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public $AlternateDetail;
    /**
     * The AlternateDetailId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AlternateDetailId;
    /**
     * The Business_Phone__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Business_Phone__c;
    /**
     * The CallDisposition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CallDisposition;
    /**
     * The CallDurationInSeconds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CallDurationInSeconds;
    /**
     * The CallObject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CallObject;
    /**
     * The CallType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CallType;
    /**
     * The Call_Back_Later_Date_Time__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Call_Back_Later_Date_Time__c;
    /**
     * The Call_Back__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Call_Back__c;
    /**
     * The Call_Duration_in_Minutes__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Call_Duration_in_Minutes__c;
    /**
     * The Call_End_Time__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Call_End_Time__c;
    /**
     * The Call_Reasons__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Call_Reasons__c;
    /**
     * The Call_Start_Time__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Call_Start_Time__c;
    /**
     * The Campaign_Agent__c
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $Campaign_Agent__c;
    /**
     * The Campaign_Agent__r
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Campaign_Agent__c
     */
    public $Campaign_Agent__r;
    /**
     * The Campaign_Extension__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Campaign_Extension__c;
    /**
     * The Campaign_Member__c
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $Campaign_Member__c;
    /**
     * The Campaign_Member__r
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Campaign_Member__c
     */
    public $Campaign_Member__r;
    /**
     * The Campaign__c
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $Campaign__c;
    /**
     * The Campaign__r
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Campaign__c
     */
    public $Campaign__r;
    /**
     * The Cell_Phone__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cell_Phone__c;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Created_by_Logged_in_User__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Created_by_Logged_in_User__c;
    /**
     * The Customer_ID__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Customer_ID__c;
    /**
     * The DB_Activity_Type__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DB_Activity_Type__c;
    /**
     * The DST_Deliver__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DST_Deliver__c;
    /**
     * The DST_Order__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DST_Order__c;
    /**
     * The DateMDY__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateMDY__c;
    /**
     * The Daytime_Phone_Number__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Daytime_Phone_Number__c;
    /**
     * The Deliver_Date_Time__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Deliver_Date_Time__c;
    /**
     * The Deliver_Date__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Deliver_Date__c;
    /**
     * The Deliver_Time__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Deliver_Time__c;
    /**
     * The Deliver__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Deliver__c;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Donation__c
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $Donation__c;
    /**
     * The Donation__r
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Donation__c
     */
    public $Donation__r;
    /**
     * The Donor_Service_Call_Back_Hour__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Donor_Service_Call_Back_Hour__c;
    /**
     * The Donor_Service_Call_Back_Minute__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Donor_Service_Call_Back_Minute__c;
    /**
     * The DurationInMinutes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DurationInMinutes;
    /**
     * The Email_Address__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email_Address__c;
    /**
     * The Email__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email__c;
    /**
     * The EndDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDateTime;
    /**
     * The First_Name__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $First_Name__c;
    /**
     * The Honourific__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Honourific__c;
    /**
     * The Inbound_Outbound__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Inbound_Outbound__c;
    /**
     * The Inbound_Phone_Display__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Inbound_Phone_Display__c;
    /**
     * The IsAllDayEvent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllDayEvent;
    /**
     * The IsClosed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClosed;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsHighPriority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHighPriority;
    /**
     * The IsReminderSet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReminderSet;
    /**
     * The IsTask
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTask;
    /**
     * The IsVisibleInSelfService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisibleInSelfService;
    /**
     * The Language__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language__c;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Last_Name__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Last_Name__c;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Location;
    /**
     * The Mailing_City__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mailing_City__c;
    /**
     * The Mailing_Country__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mailing_Country__c;
    /**
     * The Mailing_Province__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mailing_Province__c;
    /**
     * The Mailing_Street__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mailing_Street__c;
    /**
     * The Mailing_Suite_Apt__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mailing_Suite_Apt__c;
    /**
     * The Mailing_Zip_Postal_Code__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mailing_Zip_Postal_Code__c;
    /**
     * The Message_Content__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message_Content__c;
    /**
     * The Not_Interested_Reasons__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Not_Interested_Reasons__c;
    /**
     * The OPSTFNS1__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OPSTFNS1__c;
    /**
     * The OPSTFNS2__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OPSTFNS2__c;
    /**
     * The OPSTFNS3__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OPSTFNS3__c;
    /**
     * The Order_Date_Time__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Order_Date_Time__c;
    /**
     * The Order_Date__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Order_Date__c;
    /**
     * The Order_Time__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Order_Time__c;
    /**
     * The OutboundCall_Result_SMD_Lottery__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OutboundCall_Result_SMD_Lottery__c;
    /**
     * The Outbound_Call_Result__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Outbound_Call_Result__c;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The PrimaryAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Account
     */
    public $PrimaryAccount;
    /**
     * The PrimaryAccountId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PrimaryAccountId;
    /**
     * The PrimaryWho
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $PrimaryWho;
    /**
     * The PrimaryWhoId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PrimaryWhoId;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Priority;
    /**
     * The ReminderDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReminderDateTime;
    /**
     * The StartDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateTime;
    /**
     * The Station_ID__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Station_ID__c;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Status_Code__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status_Code__c;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Subject;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TaskTime__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaskTime__c;
    /**
     * The Ticket_Order__c
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $Ticket_Order__c;
    /**
     * The Ticket_Order__r
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Ticket_Order__c
     */
    public $Ticket_Order__r;
    /**
     * The Update_City__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Update_City__c;
    /**
     * The Update_Country__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Update_Country__c;
    /**
     * The Update_Email__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Update_Email__c;
    /**
     * The Update_Primary_Phone__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Update_Primary_Phone__c;
    /**
     * The Update_Province__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Update_Province__c;
    /**
     * The Update_Street_2__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Update_Street_2__c;
    /**
     * The Update_Street__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Update_Street__c;
    /**
     * The Update_Zip_Postal_Code__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Update_Zip_Postal_Code__c;
    /**
     * The What
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $What;
    /**
     * The WhatId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $WhatId;
    /**
     * The Who
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Who;
    /**
     * The WhoId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $WhoId;
    /**
     * The Winner_List_Lottery__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Winner_List_Lottery__c;
    /**
     * Constructor method for OpenActivity
     * @uses OpenActivity::setAccount()
     * @uses OpenActivity::setAccountId()
     * @uses OpenActivity::setActivityDate()
     * @uses OpenActivity::setActivityDateTime()
     * @uses OpenActivity::setActivitySubtype()
     * @uses OpenActivity::setActivityType()
     * @uses OpenActivity::setAdds_Changes_Removes_SMD__c()
     * @uses OpenActivity::setAdds_Changes_Removes_StolleryLottery__c()
     * @uses OpenActivity::setAdds_Changes_Removes__c()
     * @uses OpenActivity::setAgent_ID__c()
     * @uses OpenActivity::setAgent__c()
     * @uses OpenActivity::setAgent__r()
     * @uses OpenActivity::setAlternateDetail()
     * @uses OpenActivity::setAlternateDetailId()
     * @uses OpenActivity::setBusiness_Phone__c()
     * @uses OpenActivity::setCallDisposition()
     * @uses OpenActivity::setCallDurationInSeconds()
     * @uses OpenActivity::setCallObject()
     * @uses OpenActivity::setCallType()
     * @uses OpenActivity::setCall_Back_Later_Date_Time__c()
     * @uses OpenActivity::setCall_Back__c()
     * @uses OpenActivity::setCall_Duration_in_Minutes__c()
     * @uses OpenActivity::setCall_End_Time__c()
     * @uses OpenActivity::setCall_Reasons__c()
     * @uses OpenActivity::setCall_Start_Time__c()
     * @uses OpenActivity::setCampaign_Agent__c()
     * @uses OpenActivity::setCampaign_Agent__r()
     * @uses OpenActivity::setCampaign_Extension__c()
     * @uses OpenActivity::setCampaign_Member__c()
     * @uses OpenActivity::setCampaign_Member__r()
     * @uses OpenActivity::setCampaign__c()
     * @uses OpenActivity::setCampaign__r()
     * @uses OpenActivity::setCell_Phone__c()
     * @uses OpenActivity::setCreatedBy()
     * @uses OpenActivity::setCreatedById()
     * @uses OpenActivity::setCreatedDate()
     * @uses OpenActivity::setCreated_by_Logged_in_User__c()
     * @uses OpenActivity::setCustomer_ID__c()
     * @uses OpenActivity::setDB_Activity_Type__c()
     * @uses OpenActivity::setDST_Deliver__c()
     * @uses OpenActivity::setDST_Order__c()
     * @uses OpenActivity::setDateMDY__c()
     * @uses OpenActivity::setDaytime_Phone_Number__c()
     * @uses OpenActivity::setDeliver_Date_Time__c()
     * @uses OpenActivity::setDeliver_Date__c()
     * @uses OpenActivity::setDeliver_Time__c()
     * @uses OpenActivity::setDeliver__c()
     * @uses OpenActivity::setDescription()
     * @uses OpenActivity::setDonation__c()
     * @uses OpenActivity::setDonation__r()
     * @uses OpenActivity::setDonor_Service_Call_Back_Hour__c()
     * @uses OpenActivity::setDonor_Service_Call_Back_Minute__c()
     * @uses OpenActivity::setDurationInMinutes()
     * @uses OpenActivity::setEmail_Address__c()
     * @uses OpenActivity::setEmail__c()
     * @uses OpenActivity::setEndDateTime()
     * @uses OpenActivity::setFirst_Name__c()
     * @uses OpenActivity::setHonourific__c()
     * @uses OpenActivity::setInbound_Outbound__c()
     * @uses OpenActivity::setInbound_Phone_Display__c()
     * @uses OpenActivity::setIsAllDayEvent()
     * @uses OpenActivity::setIsClosed()
     * @uses OpenActivity::setIsDeleted()
     * @uses OpenActivity::setIsHighPriority()
     * @uses OpenActivity::setIsReminderSet()
     * @uses OpenActivity::setIsTask()
     * @uses OpenActivity::setIsVisibleInSelfService()
     * @uses OpenActivity::setLanguage__c()
     * @uses OpenActivity::setLastModifiedBy()
     * @uses OpenActivity::setLastModifiedById()
     * @uses OpenActivity::setLastModifiedDate()
     * @uses OpenActivity::setLast_Name__c()
     * @uses OpenActivity::setLocation()
     * @uses OpenActivity::setMailing_City__c()
     * @uses OpenActivity::setMailing_Country__c()
     * @uses OpenActivity::setMailing_Province__c()
     * @uses OpenActivity::setMailing_Street__c()
     * @uses OpenActivity::setMailing_Suite_Apt__c()
     * @uses OpenActivity::setMailing_Zip_Postal_Code__c()
     * @uses OpenActivity::setMessage_Content__c()
     * @uses OpenActivity::setNot_Interested_Reasons__c()
     * @uses OpenActivity::setOPSTFNS1__c()
     * @uses OpenActivity::setOPSTFNS2__c()
     * @uses OpenActivity::setOPSTFNS3__c()
     * @uses OpenActivity::setOrder_Date_Time__c()
     * @uses OpenActivity::setOrder_Date__c()
     * @uses OpenActivity::setOrder_Time__c()
     * @uses OpenActivity::setOutboundCall_Result_SMD_Lottery__c()
     * @uses OpenActivity::setOutbound_Call_Result__c()
     * @uses OpenActivity::setOwner()
     * @uses OpenActivity::setOwnerId()
     * @uses OpenActivity::setPrimaryAccount()
     * @uses OpenActivity::setPrimaryAccountId()
     * @uses OpenActivity::setPrimaryWho()
     * @uses OpenActivity::setPrimaryWhoId()
     * @uses OpenActivity::setPriority()
     * @uses OpenActivity::setReminderDateTime()
     * @uses OpenActivity::setStartDateTime()
     * @uses OpenActivity::setStation_ID__c()
     * @uses OpenActivity::setStatus()
     * @uses OpenActivity::setStatus_Code__c()
     * @uses OpenActivity::setSubject()
     * @uses OpenActivity::setSystemModstamp()
     * @uses OpenActivity::setTaskTime__c()
     * @uses OpenActivity::setTicket_Order__c()
     * @uses OpenActivity::setTicket_Order__r()
     * @uses OpenActivity::setUpdate_City__c()
     * @uses OpenActivity::setUpdate_Country__c()
     * @uses OpenActivity::setUpdate_Email__c()
     * @uses OpenActivity::setUpdate_Primary_Phone__c()
     * @uses OpenActivity::setUpdate_Province__c()
     * @uses OpenActivity::setUpdate_Street_2__c()
     * @uses OpenActivity::setUpdate_Street__c()
     * @uses OpenActivity::setUpdate_Zip_Postal_Code__c()
     * @uses OpenActivity::setWhat()
     * @uses OpenActivity::setWhatId()
     * @uses OpenActivity::setWho()
     * @uses OpenActivity::setWhoId()
     * @uses OpenActivity::setWinner_List_Lottery__c()
     * @param \NexusDigital/MiratelForce\StructType\Account $account
     * @param string $accountId
     * @param string $activityDate
     * @param string $activityDateTime
     * @param string $activitySubtype
     * @param string $activityType
     * @param string $adds_Changes_Removes_SMD__c
     * @param string $adds_Changes_Removes_StolleryLottery__c
     * @param string $adds_Changes_Removes__c
     * @param string $agent_ID__c
     * @param string $agent__c
     * @param \NexusDigital/MiratelForce\StructType\User $agent__r
     * @param \NexusDigital/MiratelForce\StructType\EmailMessage $alternateDetail
     * @param string $alternateDetailId
     * @param string $business_Phone__c
     * @param string $callDisposition
     * @param int $callDurationInSeconds
     * @param string $callObject
     * @param string $callType
     * @param string $call_Back_Later_Date_Time__c
     * @param string $call_Back__c
     * @param float $call_Duration_in_Minutes__c
     * @param string $call_End_Time__c
     * @param string $call_Reasons__c
     * @param string $call_Start_Time__c
     * @param string $campaign_Agent__c
     * @param \NexusDigital/MiratelForce\StructType\Campaign_Agent__c $campaign_Agent__r
     * @param string $campaign_Extension__c
     * @param string $campaign_Member__c
     * @param \NexusDigital/MiratelForce\StructType\Campaign_Member__c $campaign_Member__r
     * @param string $campaign__c
     * @param \NexusDigital/MiratelForce\StructType\Campaign__c $campaign__r
     * @param string $cell_Phone__c
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param bool $created_by_Logged_in_User__c
     * @param string $customer_ID__c
     * @param string $dB_Activity_Type__c
     * @param bool $dST_Deliver__c
     * @param bool $dST_Order__c
     * @param string $dateMDY__c
     * @param string $daytime_Phone_Number__c
     * @param string $deliver_Date_Time__c
     * @param string $deliver_Date__c
     * @param string $deliver_Time__c
     * @param string $deliver__c
     * @param string $description
     * @param string $donation__c
     * @param \NexusDigital/MiratelForce\StructType\Donation__c $donation__r
     * @param string $donor_Service_Call_Back_Hour__c
     * @param string $donor_Service_Call_Back_Minute__c
     * @param int $durationInMinutes
     * @param string $email_Address__c
     * @param string $email__c
     * @param string $endDateTime
     * @param string $first_Name__c
     * @param string $honourific__c
     * @param string $inbound_Outbound__c
     * @param string $inbound_Phone_Display__c
     * @param bool $isAllDayEvent
     * @param bool $isClosed
     * @param bool $isDeleted
     * @param bool $isHighPriority
     * @param bool $isReminderSet
     * @param bool $isTask
     * @param bool $isVisibleInSelfService
     * @param string $language__c
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $last_Name__c
     * @param string $location
     * @param string $mailing_City__c
     * @param string $mailing_Country__c
     * @param string $mailing_Province__c
     * @param string $mailing_Street__c
     * @param string $mailing_Suite_Apt__c
     * @param string $mailing_Zip_Postal_Code__c
     * @param string $message_Content__c
     * @param string $not_Interested_Reasons__c
     * @param string $oPSTFNS1__c
     * @param string $oPSTFNS2__c
     * @param string $oPSTFNS3__c
     * @param string $order_Date_Time__c
     * @param string $order_Date__c
     * @param string $order_Time__c
     * @param string $outboundCall_Result_SMD_Lottery__c
     * @param string $outbound_Call_Result__c
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @param string $ownerId
     * @param \NexusDigital/MiratelForce\StructType\Account $primaryAccount
     * @param string $primaryAccountId
     * @param \NexusDigital/MiratelForce\StructType\SObject $primaryWho
     * @param string $primaryWhoId
     * @param string $priority
     * @param string $reminderDateTime
     * @param string $startDateTime
     * @param string $station_ID__c
     * @param string $status
     * @param string $status_Code__c
     * @param string $subject
     * @param string $systemModstamp
     * @param string $taskTime__c
     * @param string $ticket_Order__c
     * @param \NexusDigital/MiratelForce\StructType\Ticket_Order__c $ticket_Order__r
     * @param string $update_City__c
     * @param string $update_Country__c
     * @param string $update_Email__c
     * @param string $update_Primary_Phone__c
     * @param string $update_Province__c
     * @param string $update_Street_2__c
     * @param string $update_Street__c
     * @param string $update_Zip_Postal_Code__c
     * @param \NexusDigital/MiratelForce\StructType\SObject $what
     * @param string $whatId
     * @param \NexusDigital/MiratelForce\StructType\SObject $who
     * @param string $whoId
     * @param string $winner_List_Lottery__c
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\Account $account = null, $accountId = null, $activityDate = null, $activityDateTime = null, $activitySubtype = null, $activityType = null, $adds_Changes_Removes_SMD__c = null, $adds_Changes_Removes_StolleryLottery__c = null, $adds_Changes_Removes__c = null, $agent_ID__c = null, $agent__c = null, \NexusDigital/MiratelForce\StructType\User $agent__r = null, \NexusDigital/MiratelForce\StructType\EmailMessage $alternateDetail = null, $alternateDetailId = null, $business_Phone__c = null, $callDisposition = null, $callDurationInSeconds = null, $callObject = null, $callType = null, $call_Back_Later_Date_Time__c = null, $call_Back__c = null, $call_Duration_in_Minutes__c = null, $call_End_Time__c = null, $call_Reasons__c = null, $call_Start_Time__c = null, $campaign_Agent__c = null, \NexusDigital/MiratelForce\StructType\Campaign_Agent__c $campaign_Agent__r = null, $campaign_Extension__c = null, $campaign_Member__c = null, \NexusDigital/MiratelForce\StructType\Campaign_Member__c $campaign_Member__r = null, $campaign__c = null, \NexusDigital/MiratelForce\StructType\Campaign__c $campaign__r = null, $cell_Phone__c = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $created_by_Logged_in_User__c = null, $customer_ID__c = null, $dB_Activity_Type__c = null, $dST_Deliver__c = null, $dST_Order__c = null, $dateMDY__c = null, $daytime_Phone_Number__c = null, $deliver_Date_Time__c = null, $deliver_Date__c = null, $deliver_Time__c = null, $deliver__c = null, $description = null, $donation__c = null, \NexusDigital/MiratelForce\StructType\Donation__c $donation__r = null, $donor_Service_Call_Back_Hour__c = null, $donor_Service_Call_Back_Minute__c = null, $durationInMinutes = null, $email_Address__c = null, $email__c = null, $endDateTime = null, $first_Name__c = null, $honourific__c = null, $inbound_Outbound__c = null, $inbound_Phone_Display__c = null, $isAllDayEvent = null, $isClosed = null, $isDeleted = null, $isHighPriority = null, $isReminderSet = null, $isTask = null, $isVisibleInSelfService = null, $language__c = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $last_Name__c = null, $location = null, $mailing_City__c = null, $mailing_Country__c = null, $mailing_Province__c = null, $mailing_Street__c = null, $mailing_Suite_Apt__c = null, $mailing_Zip_Postal_Code__c = null, $message_Content__c = null, $not_Interested_Reasons__c = null, $oPSTFNS1__c = null, $oPSTFNS2__c = null, $oPSTFNS3__c = null, $order_Date_Time__c = null, $order_Date__c = null, $order_Time__c = null, $outboundCall_Result_SMD_Lottery__c = null, $outbound_Call_Result__c = null, \NexusDigital/MiratelForce\StructType\SObject $owner = null, $ownerId = null, \NexusDigital/MiratelForce\StructType\Account $primaryAccount = null, $primaryAccountId = null, \NexusDigital/MiratelForce\StructType\SObject $primaryWho = null, $primaryWhoId = null, $priority = null, $reminderDateTime = null, $startDateTime = null, $station_ID__c = null, $status = null, $status_Code__c = null, $subject = null, $systemModstamp = null, $taskTime__c = null, $ticket_Order__c = null, \NexusDigital/MiratelForce\StructType\Ticket_Order__c $ticket_Order__r = null, $update_City__c = null, $update_Country__c = null, $update_Email__c = null, $update_Primary_Phone__c = null, $update_Province__c = null, $update_Street_2__c = null, $update_Street__c = null, $update_Zip_Postal_Code__c = null, \NexusDigital/MiratelForce\StructType\SObject $what = null, $whatId = null, \NexusDigital/MiratelForce\StructType\SObject $who = null, $whoId = null, $winner_List_Lottery__c = null)
    {
        $this
            ->setAccount($account)
            ->setAccountId($accountId)
            ->setActivityDate($activityDate)
            ->setActivityDateTime($activityDateTime)
            ->setActivitySubtype($activitySubtype)
            ->setActivityType($activityType)
            ->setAdds_Changes_Removes_SMD__c($adds_Changes_Removes_SMD__c)
            ->setAdds_Changes_Removes_StolleryLottery__c($adds_Changes_Removes_StolleryLottery__c)
            ->setAdds_Changes_Removes__c($adds_Changes_Removes__c)
            ->setAgent_ID__c($agent_ID__c)
            ->setAgent__c($agent__c)
            ->setAgent__r($agent__r)
            ->setAlternateDetail($alternateDetail)
            ->setAlternateDetailId($alternateDetailId)
            ->setBusiness_Phone__c($business_Phone__c)
            ->setCallDisposition($callDisposition)
            ->setCallDurationInSeconds($callDurationInSeconds)
            ->setCallObject($callObject)
            ->setCallType($callType)
            ->setCall_Back_Later_Date_Time__c($call_Back_Later_Date_Time__c)
            ->setCall_Back__c($call_Back__c)
            ->setCall_Duration_in_Minutes__c($call_Duration_in_Minutes__c)
            ->setCall_End_Time__c($call_End_Time__c)
            ->setCall_Reasons__c($call_Reasons__c)
            ->setCall_Start_Time__c($call_Start_Time__c)
            ->setCampaign_Agent__c($campaign_Agent__c)
            ->setCampaign_Agent__r($campaign_Agent__r)
            ->setCampaign_Extension__c($campaign_Extension__c)
            ->setCampaign_Member__c($campaign_Member__c)
            ->setCampaign_Member__r($campaign_Member__r)
            ->setCampaign__c($campaign__c)
            ->setCampaign__r($campaign__r)
            ->setCell_Phone__c($cell_Phone__c)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCreated_by_Logged_in_User__c($created_by_Logged_in_User__c)
            ->setCustomer_ID__c($customer_ID__c)
            ->setDB_Activity_Type__c($dB_Activity_Type__c)
            ->setDST_Deliver__c($dST_Deliver__c)
            ->setDST_Order__c($dST_Order__c)
            ->setDateMDY__c($dateMDY__c)
            ->setDaytime_Phone_Number__c($daytime_Phone_Number__c)
            ->setDeliver_Date_Time__c($deliver_Date_Time__c)
            ->setDeliver_Date__c($deliver_Date__c)
            ->setDeliver_Time__c($deliver_Time__c)
            ->setDeliver__c($deliver__c)
            ->setDescription($description)
            ->setDonation__c($donation__c)
            ->setDonation__r($donation__r)
            ->setDonor_Service_Call_Back_Hour__c($donor_Service_Call_Back_Hour__c)
            ->setDonor_Service_Call_Back_Minute__c($donor_Service_Call_Back_Minute__c)
            ->setDurationInMinutes($durationInMinutes)
            ->setEmail_Address__c($email_Address__c)
            ->setEmail__c($email__c)
            ->setEndDateTime($endDateTime)
            ->setFirst_Name__c($first_Name__c)
            ->setHonourific__c($honourific__c)
            ->setInbound_Outbound__c($inbound_Outbound__c)
            ->setInbound_Phone_Display__c($inbound_Phone_Display__c)
            ->setIsAllDayEvent($isAllDayEvent)
            ->setIsClosed($isClosed)
            ->setIsDeleted($isDeleted)
            ->setIsHighPriority($isHighPriority)
            ->setIsReminderSet($isReminderSet)
            ->setIsTask($isTask)
            ->setIsVisibleInSelfService($isVisibleInSelfService)
            ->setLanguage__c($language__c)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLast_Name__c($last_Name__c)
            ->setLocation($location)
            ->setMailing_City__c($mailing_City__c)
            ->setMailing_Country__c($mailing_Country__c)
            ->setMailing_Province__c($mailing_Province__c)
            ->setMailing_Street__c($mailing_Street__c)
            ->setMailing_Suite_Apt__c($mailing_Suite_Apt__c)
            ->setMailing_Zip_Postal_Code__c($mailing_Zip_Postal_Code__c)
            ->setMessage_Content__c($message_Content__c)
            ->setNot_Interested_Reasons__c($not_Interested_Reasons__c)
            ->setOPSTFNS1__c($oPSTFNS1__c)
            ->setOPSTFNS2__c($oPSTFNS2__c)
            ->setOPSTFNS3__c($oPSTFNS3__c)
            ->setOrder_Date_Time__c($order_Date_Time__c)
            ->setOrder_Date__c($order_Date__c)
            ->setOrder_Time__c($order_Time__c)
            ->setOutboundCall_Result_SMD_Lottery__c($outboundCall_Result_SMD_Lottery__c)
            ->setOutbound_Call_Result__c($outbound_Call_Result__c)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setPrimaryAccount($primaryAccount)
            ->setPrimaryAccountId($primaryAccountId)
            ->setPrimaryWho($primaryWho)
            ->setPrimaryWhoId($primaryWhoId)
            ->setPriority($priority)
            ->setReminderDateTime($reminderDateTime)
            ->setStartDateTime($startDateTime)
            ->setStation_ID__c($station_ID__c)
            ->setStatus($status)
            ->setStatus_Code__c($status_Code__c)
            ->setSubject($subject)
            ->setSystemModstamp($systemModstamp)
            ->setTaskTime__c($taskTime__c)
            ->setTicket_Order__c($ticket_Order__c)
            ->setTicket_Order__r($ticket_Order__r)
            ->setUpdate_City__c($update_City__c)
            ->setUpdate_Country__c($update_Country__c)
            ->setUpdate_Email__c($update_Email__c)
            ->setUpdate_Primary_Phone__c($update_Primary_Phone__c)
            ->setUpdate_Province__c($update_Province__c)
            ->setUpdate_Street_2__c($update_Street_2__c)
            ->setUpdate_Street__c($update_Street__c)
            ->setUpdate_Zip_Postal_Code__c($update_Zip_Postal_Code__c)
            ->setWhat($what)
            ->setWhatId($whatId)
            ->setWho($who)
            ->setWhoId($whoId)
            ->setWinner_List_Lottery__c($winner_List_Lottery__c);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Account|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Account $account
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setAccount(\NexusDigital/MiratelForce\StructType\Account $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($accountId) && mb_strlen($accountId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($accountId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($accountId) && !preg_match('/[a-zA-Z0-9]{18}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($accountId, true)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get ActivityDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityDate()
    {
        return isset($this->ActivityDate) ? $this->ActivityDate : null;
    }
    /**
     * Set ActivityDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityDate
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setActivityDate($activityDate = null)
    {
        // validation for constraint: string
        if (!is_null($activityDate) && !is_string($activityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityDate, true), gettype($activityDate)), __LINE__);
        }
        if (is_null($activityDate) || (is_array($activityDate) && empty($activityDate))) {
            unset($this->ActivityDate);
        } else {
            $this->ActivityDate = $activityDate;
        }
        return $this;
    }
    /**
     * Get ActivityDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityDateTime()
    {
        return isset($this->ActivityDateTime) ? $this->ActivityDateTime : null;
    }
    /**
     * Set ActivityDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityDateTime
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setActivityDateTime($activityDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($activityDateTime) && !is_string($activityDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityDateTime, true), gettype($activityDateTime)), __LINE__);
        }
        if (is_null($activityDateTime) || (is_array($activityDateTime) && empty($activityDateTime))) {
            unset($this->ActivityDateTime);
        } else {
            $this->ActivityDateTime = $activityDateTime;
        }
        return $this;
    }
    /**
     * Get ActivitySubtype value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivitySubtype()
    {
        return isset($this->ActivitySubtype) ? $this->ActivitySubtype : null;
    }
    /**
     * Set ActivitySubtype value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activitySubtype
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setActivitySubtype($activitySubtype = null)
    {
        // validation for constraint: string
        if (!is_null($activitySubtype) && !is_string($activitySubtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activitySubtype, true), gettype($activitySubtype)), __LINE__);
        }
        if (is_null($activitySubtype) || (is_array($activitySubtype) && empty($activitySubtype))) {
            unset($this->ActivitySubtype);
        } else {
            $this->ActivitySubtype = $activitySubtype;
        }
        return $this;
    }
    /**
     * Get ActivityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityType()
    {
        return isset($this->ActivityType) ? $this->ActivityType : null;
    }
    /**
     * Set ActivityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityType
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setActivityType($activityType = null)
    {
        // validation for constraint: string
        if (!is_null($activityType) && !is_string($activityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityType, true), gettype($activityType)), __LINE__);
        }
        if (is_null($activityType) || (is_array($activityType) && empty($activityType))) {
            unset($this->ActivityType);
        } else {
            $this->ActivityType = $activityType;
        }
        return $this;
    }
    /**
     * Get Adds_Changes_Removes_SMD__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdds_Changes_Removes_SMD__c()
    {
        return isset($this->Adds_Changes_Removes_SMD__c) ? $this->Adds_Changes_Removes_SMD__c : null;
    }
    /**
     * Set Adds_Changes_Removes_SMD__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adds_Changes_Removes_SMD__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setAdds_Changes_Removes_SMD__c($adds_Changes_Removes_SMD__c = null)
    {
        // validation for constraint: string
        if (!is_null($adds_Changes_Removes_SMD__c) && !is_string($adds_Changes_Removes_SMD__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adds_Changes_Removes_SMD__c, true), gettype($adds_Changes_Removes_SMD__c)), __LINE__);
        }
        if (is_null($adds_Changes_Removes_SMD__c) || (is_array($adds_Changes_Removes_SMD__c) && empty($adds_Changes_Removes_SMD__c))) {
            unset($this->Adds_Changes_Removes_SMD__c);
        } else {
            $this->Adds_Changes_Removes_SMD__c = $adds_Changes_Removes_SMD__c;
        }
        return $this;
    }
    /**
     * Get Adds_Changes_Removes_StolleryLottery__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdds_Changes_Removes_StolleryLottery__c()
    {
        return isset($this->Adds_Changes_Removes_StolleryLottery__c) ? $this->Adds_Changes_Removes_StolleryLottery__c : null;
    }
    /**
     * Set Adds_Changes_Removes_StolleryLottery__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adds_Changes_Removes_StolleryLottery__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setAdds_Changes_Removes_StolleryLottery__c($adds_Changes_Removes_StolleryLottery__c = null)
    {
        // validation for constraint: string
        if (!is_null($adds_Changes_Removes_StolleryLottery__c) && !is_string($adds_Changes_Removes_StolleryLottery__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adds_Changes_Removes_StolleryLottery__c, true), gettype($adds_Changes_Removes_StolleryLottery__c)), __LINE__);
        }
        if (is_null($adds_Changes_Removes_StolleryLottery__c) || (is_array($adds_Changes_Removes_StolleryLottery__c) && empty($adds_Changes_Removes_StolleryLottery__c))) {
            unset($this->Adds_Changes_Removes_StolleryLottery__c);
        } else {
            $this->Adds_Changes_Removes_StolleryLottery__c = $adds_Changes_Removes_StolleryLottery__c;
        }
        return $this;
    }
    /**
     * Get Adds_Changes_Removes__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdds_Changes_Removes__c()
    {
        return isset($this->Adds_Changes_Removes__c) ? $this->Adds_Changes_Removes__c : null;
    }
    /**
     * Set Adds_Changes_Removes__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adds_Changes_Removes__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setAdds_Changes_Removes__c($adds_Changes_Removes__c = null)
    {
        // validation for constraint: string
        if (!is_null($adds_Changes_Removes__c) && !is_string($adds_Changes_Removes__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adds_Changes_Removes__c, true), gettype($adds_Changes_Removes__c)), __LINE__);
        }
        if (is_null($adds_Changes_Removes__c) || (is_array($adds_Changes_Removes__c) && empty($adds_Changes_Removes__c))) {
            unset($this->Adds_Changes_Removes__c);
        } else {
            $this->Adds_Changes_Removes__c = $adds_Changes_Removes__c;
        }
        return $this;
    }
    /**
     * Get Agent_ID__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgent_ID__c()
    {
        return isset($this->Agent_ID__c) ? $this->Agent_ID__c : null;
    }
    /**
     * Set Agent_ID__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agent_ID__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setAgent_ID__c($agent_ID__c = null)
    {
        // validation for constraint: string
        if (!is_null($agent_ID__c) && !is_string($agent_ID__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agent_ID__c, true), gettype($agent_ID__c)), __LINE__);
        }
        if (is_null($agent_ID__c) || (is_array($agent_ID__c) && empty($agent_ID__c))) {
            unset($this->Agent_ID__c);
        } else {
            $this->Agent_ID__c = $agent_ID__c;
        }
        return $this;
    }
    /**
     * Get Agent__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgent__c()
    {
        return isset($this->Agent__c) ? $this->Agent__c : null;
    }
    /**
     * Set Agent__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agent__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setAgent__c($agent__c = null)
    {
        // validation for constraint: string
        if (!is_null($agent__c) && !is_string($agent__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agent__c, true), gettype($agent__c)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($agent__c) && mb_strlen($agent__c) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($agent__c)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($agent__c) && !preg_match('/[a-zA-Z0-9]{18}/', $agent__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($agent__c, true)), __LINE__);
        }
        if (is_null($agent__c) || (is_array($agent__c) && empty($agent__c))) {
            unset($this->Agent__c);
        } else {
            $this->Agent__c = $agent__c;
        }
        return $this;
    }
    /**
     * Get Agent__r value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getAgent__r()
    {
        return isset($this->Agent__r) ? $this->Agent__r : null;
    }
    /**
     * Set Agent__r value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $agent__r
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setAgent__r(\NexusDigital/MiratelForce\StructType\User $agent__r = null)
    {
        if (is_null($agent__r) || (is_array($agent__r) && empty($agent__r))) {
            unset($this->Agent__r);
        } else {
            $this->Agent__r = $agent__r;
        }
        return $this;
    }
    /**
     * Get AlternateDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage|null
     */
    public function getAlternateDetail()
    {
        return isset($this->AlternateDetail) ? $this->AlternateDetail : null;
    }
    /**
     * Set AlternateDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\EmailMessage $alternateDetail
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setAlternateDetail(\NexusDigital/MiratelForce\StructType\EmailMessage $alternateDetail = null)
    {
        if (is_null($alternateDetail) || (is_array($alternateDetail) && empty($alternateDetail))) {
            unset($this->AlternateDetail);
        } else {
            $this->AlternateDetail = $alternateDetail;
        }
        return $this;
    }
    /**
     * Get AlternateDetailId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternateDetailId()
    {
        return isset($this->AlternateDetailId) ? $this->AlternateDetailId : null;
    }
    /**
     * Set AlternateDetailId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternateDetailId
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setAlternateDetailId($alternateDetailId = null)
    {
        // validation for constraint: string
        if (!is_null($alternateDetailId) && !is_string($alternateDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateDetailId, true), gettype($alternateDetailId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($alternateDetailId) && mb_strlen($alternateDetailId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($alternateDetailId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($alternateDetailId) && !preg_match('/[a-zA-Z0-9]{18}/', $alternateDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($alternateDetailId, true)), __LINE__);
        }
        if (is_null($alternateDetailId) || (is_array($alternateDetailId) && empty($alternateDetailId))) {
            unset($this->AlternateDetailId);
        } else {
            $this->AlternateDetailId = $alternateDetailId;
        }
        return $this;
    }
    /**
     * Get Business_Phone__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusiness_Phone__c()
    {
        return isset($this->Business_Phone__c) ? $this->Business_Phone__c : null;
    }
    /**
     * Set Business_Phone__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $business_Phone__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setBusiness_Phone__c($business_Phone__c = null)
    {
        // validation for constraint: string
        if (!is_null($business_Phone__c) && !is_string($business_Phone__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Phone__c, true), gettype($business_Phone__c)), __LINE__);
        }
        if (is_null($business_Phone__c) || (is_array($business_Phone__c) && empty($business_Phone__c))) {
            unset($this->Business_Phone__c);
        } else {
            $this->Business_Phone__c = $business_Phone__c;
        }
        return $this;
    }
    /**
     * Get CallDisposition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallDisposition()
    {
        return isset($this->CallDisposition) ? $this->CallDisposition : null;
    }
    /**
     * Set CallDisposition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callDisposition
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCallDisposition($callDisposition = null)
    {
        // validation for constraint: string
        if (!is_null($callDisposition) && !is_string($callDisposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callDisposition, true), gettype($callDisposition)), __LINE__);
        }
        if (is_null($callDisposition) || (is_array($callDisposition) && empty($callDisposition))) {
            unset($this->CallDisposition);
        } else {
            $this->CallDisposition = $callDisposition;
        }
        return $this;
    }
    /**
     * Get CallDurationInSeconds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCallDurationInSeconds()
    {
        return isset($this->CallDurationInSeconds) ? $this->CallDurationInSeconds : null;
    }
    /**
     * Set CallDurationInSeconds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $callDurationInSeconds
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCallDurationInSeconds($callDurationInSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($callDurationInSeconds) && !(is_int($callDurationInSeconds) || ctype_digit($callDurationInSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($callDurationInSeconds, true), gettype($callDurationInSeconds)), __LINE__);
        }
        if (is_null($callDurationInSeconds) || (is_array($callDurationInSeconds) && empty($callDurationInSeconds))) {
            unset($this->CallDurationInSeconds);
        } else {
            $this->CallDurationInSeconds = $callDurationInSeconds;
        }
        return $this;
    }
    /**
     * Get CallObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallObject()
    {
        return isset($this->CallObject) ? $this->CallObject : null;
    }
    /**
     * Set CallObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callObject
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCallObject($callObject = null)
    {
        // validation for constraint: string
        if (!is_null($callObject) && !is_string($callObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callObject, true), gettype($callObject)), __LINE__);
        }
        if (is_null($callObject) || (is_array($callObject) && empty($callObject))) {
            unset($this->CallObject);
        } else {
            $this->CallObject = $callObject;
        }
        return $this;
    }
    /**
     * Get CallType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallType()
    {
        return isset($this->CallType) ? $this->CallType : null;
    }
    /**
     * Set CallType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callType
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCallType($callType = null)
    {
        // validation for constraint: string
        if (!is_null($callType) && !is_string($callType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callType, true), gettype($callType)), __LINE__);
        }
        if (is_null($callType) || (is_array($callType) && empty($callType))) {
            unset($this->CallType);
        } else {
            $this->CallType = $callType;
        }
        return $this;
    }
    /**
     * Get Call_Back_Later_Date_Time__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCall_Back_Later_Date_Time__c()
    {
        return isset($this->Call_Back_Later_Date_Time__c) ? $this->Call_Back_Later_Date_Time__c : null;
    }
    /**
     * Set Call_Back_Later_Date_Time__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $call_Back_Later_Date_Time__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCall_Back_Later_Date_Time__c($call_Back_Later_Date_Time__c = null)
    {
        // validation for constraint: string
        if (!is_null($call_Back_Later_Date_Time__c) && !is_string($call_Back_Later_Date_Time__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($call_Back_Later_Date_Time__c, true), gettype($call_Back_Later_Date_Time__c)), __LINE__);
        }
        if (is_null($call_Back_Later_Date_Time__c) || (is_array($call_Back_Later_Date_Time__c) && empty($call_Back_Later_Date_Time__c))) {
            unset($this->Call_Back_Later_Date_Time__c);
        } else {
            $this->Call_Back_Later_Date_Time__c = $call_Back_Later_Date_Time__c;
        }
        return $this;
    }
    /**
     * Get Call_Back__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCall_Back__c()
    {
        return isset($this->Call_Back__c) ? $this->Call_Back__c : null;
    }
    /**
     * Set Call_Back__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $call_Back__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCall_Back__c($call_Back__c = null)
    {
        // validation for constraint: string
        if (!is_null($call_Back__c) && !is_string($call_Back__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($call_Back__c, true), gettype($call_Back__c)), __LINE__);
        }
        if (is_null($call_Back__c) || (is_array($call_Back__c) && empty($call_Back__c))) {
            unset($this->Call_Back__c);
        } else {
            $this->Call_Back__c = $call_Back__c;
        }
        return $this;
    }
    /**
     * Get Call_Duration_in_Minutes__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCall_Duration_in_Minutes__c()
    {
        return isset($this->Call_Duration_in_Minutes__c) ? $this->Call_Duration_in_Minutes__c : null;
    }
    /**
     * Set Call_Duration_in_Minutes__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $call_Duration_in_Minutes__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCall_Duration_in_Minutes__c($call_Duration_in_Minutes__c = null)
    {
        // validation for constraint: float
        if (!is_null($call_Duration_in_Minutes__c) && !(is_float($call_Duration_in_Minutes__c) || is_numeric($call_Duration_in_Minutes__c))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($call_Duration_in_Minutes__c, true), gettype($call_Duration_in_Minutes__c)), __LINE__);
        }
        if (is_null($call_Duration_in_Minutes__c) || (is_array($call_Duration_in_Minutes__c) && empty($call_Duration_in_Minutes__c))) {
            unset($this->Call_Duration_in_Minutes__c);
        } else {
            $this->Call_Duration_in_Minutes__c = $call_Duration_in_Minutes__c;
        }
        return $this;
    }
    /**
     * Get Call_End_Time__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCall_End_Time__c()
    {
        return isset($this->Call_End_Time__c) ? $this->Call_End_Time__c : null;
    }
    /**
     * Set Call_End_Time__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $call_End_Time__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCall_End_Time__c($call_End_Time__c = null)
    {
        // validation for constraint: string
        if (!is_null($call_End_Time__c) && !is_string($call_End_Time__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($call_End_Time__c, true), gettype($call_End_Time__c)), __LINE__);
        }
        if (is_null($call_End_Time__c) || (is_array($call_End_Time__c) && empty($call_End_Time__c))) {
            unset($this->Call_End_Time__c);
        } else {
            $this->Call_End_Time__c = $call_End_Time__c;
        }
        return $this;
    }
    /**
     * Get Call_Reasons__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCall_Reasons__c()
    {
        return isset($this->Call_Reasons__c) ? $this->Call_Reasons__c : null;
    }
    /**
     * Set Call_Reasons__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $call_Reasons__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCall_Reasons__c($call_Reasons__c = null)
    {
        // validation for constraint: string
        if (!is_null($call_Reasons__c) && !is_string($call_Reasons__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($call_Reasons__c, true), gettype($call_Reasons__c)), __LINE__);
        }
        if (is_null($call_Reasons__c) || (is_array($call_Reasons__c) && empty($call_Reasons__c))) {
            unset($this->Call_Reasons__c);
        } else {
            $this->Call_Reasons__c = $call_Reasons__c;
        }
        return $this;
    }
    /**
     * Get Call_Start_Time__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCall_Start_Time__c()
    {
        return isset($this->Call_Start_Time__c) ? $this->Call_Start_Time__c : null;
    }
    /**
     * Set Call_Start_Time__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $call_Start_Time__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCall_Start_Time__c($call_Start_Time__c = null)
    {
        // validation for constraint: string
        if (!is_null($call_Start_Time__c) && !is_string($call_Start_Time__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($call_Start_Time__c, true), gettype($call_Start_Time__c)), __LINE__);
        }
        if (is_null($call_Start_Time__c) || (is_array($call_Start_Time__c) && empty($call_Start_Time__c))) {
            unset($this->Call_Start_Time__c);
        } else {
            $this->Call_Start_Time__c = $call_Start_Time__c;
        }
        return $this;
    }
    /**
     * Get Campaign_Agent__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaign_Agent__c()
    {
        return isset($this->Campaign_Agent__c) ? $this->Campaign_Agent__c : null;
    }
    /**
     * Set Campaign_Agent__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaign_Agent__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCampaign_Agent__c($campaign_Agent__c = null)
    {
        // validation for constraint: string
        if (!is_null($campaign_Agent__c) && !is_string($campaign_Agent__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaign_Agent__c, true), gettype($campaign_Agent__c)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($campaign_Agent__c) && mb_strlen($campaign_Agent__c) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($campaign_Agent__c)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($campaign_Agent__c) && !preg_match('/[a-zA-Z0-9]{18}/', $campaign_Agent__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($campaign_Agent__c, true)), __LINE__);
        }
        if (is_null($campaign_Agent__c) || (is_array($campaign_Agent__c) && empty($campaign_Agent__c))) {
            unset($this->Campaign_Agent__c);
        } else {
            $this->Campaign_Agent__c = $campaign_Agent__c;
        }
        return $this;
    }
    /**
     * Get Campaign_Agent__r value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Campaign_Agent__c|null
     */
    public function getCampaign_Agent__r()
    {
        return isset($this->Campaign_Agent__r) ? $this->Campaign_Agent__r : null;
    }
    /**
     * Set Campaign_Agent__r value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Campaign_Agent__c $campaign_Agent__r
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCampaign_Agent__r(\NexusDigital/MiratelForce\StructType\Campaign_Agent__c $campaign_Agent__r = null)
    {
        if (is_null($campaign_Agent__r) || (is_array($campaign_Agent__r) && empty($campaign_Agent__r))) {
            unset($this->Campaign_Agent__r);
        } else {
            $this->Campaign_Agent__r = $campaign_Agent__r;
        }
        return $this;
    }
    /**
     * Get Campaign_Extension__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaign_Extension__c()
    {
        return isset($this->Campaign_Extension__c) ? $this->Campaign_Extension__c : null;
    }
    /**
     * Set Campaign_Extension__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaign_Extension__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCampaign_Extension__c($campaign_Extension__c = null)
    {
        // validation for constraint: string
        if (!is_null($campaign_Extension__c) && !is_string($campaign_Extension__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaign_Extension__c, true), gettype($campaign_Extension__c)), __LINE__);
        }
        if (is_null($campaign_Extension__c) || (is_array($campaign_Extension__c) && empty($campaign_Extension__c))) {
            unset($this->Campaign_Extension__c);
        } else {
            $this->Campaign_Extension__c = $campaign_Extension__c;
        }
        return $this;
    }
    /**
     * Get Campaign_Member__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaign_Member__c()
    {
        return isset($this->Campaign_Member__c) ? $this->Campaign_Member__c : null;
    }
    /**
     * Set Campaign_Member__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaign_Member__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCampaign_Member__c($campaign_Member__c = null)
    {
        // validation for constraint: string
        if (!is_null($campaign_Member__c) && !is_string($campaign_Member__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaign_Member__c, true), gettype($campaign_Member__c)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($campaign_Member__c) && mb_strlen($campaign_Member__c) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($campaign_Member__c)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($campaign_Member__c) && !preg_match('/[a-zA-Z0-9]{18}/', $campaign_Member__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($campaign_Member__c, true)), __LINE__);
        }
        if (is_null($campaign_Member__c) || (is_array($campaign_Member__c) && empty($campaign_Member__c))) {
            unset($this->Campaign_Member__c);
        } else {
            $this->Campaign_Member__c = $campaign_Member__c;
        }
        return $this;
    }
    /**
     * Get Campaign_Member__r value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Campaign_Member__c|null
     */
    public function getCampaign_Member__r()
    {
        return isset($this->Campaign_Member__r) ? $this->Campaign_Member__r : null;
    }
    /**
     * Set Campaign_Member__r value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Campaign_Member__c $campaign_Member__r
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCampaign_Member__r(\NexusDigital/MiratelForce\StructType\Campaign_Member__c $campaign_Member__r = null)
    {
        if (is_null($campaign_Member__r) || (is_array($campaign_Member__r) && empty($campaign_Member__r))) {
            unset($this->Campaign_Member__r);
        } else {
            $this->Campaign_Member__r = $campaign_Member__r;
        }
        return $this;
    }
    /**
     * Get Campaign__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaign__c()
    {
        return isset($this->Campaign__c) ? $this->Campaign__c : null;
    }
    /**
     * Set Campaign__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaign__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCampaign__c($campaign__c = null)
    {
        // validation for constraint: string
        if (!is_null($campaign__c) && !is_string($campaign__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaign__c, true), gettype($campaign__c)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($campaign__c) && mb_strlen($campaign__c) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($campaign__c)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($campaign__c) && !preg_match('/[a-zA-Z0-9]{18}/', $campaign__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($campaign__c, true)), __LINE__);
        }
        if (is_null($campaign__c) || (is_array($campaign__c) && empty($campaign__c))) {
            unset($this->Campaign__c);
        } else {
            $this->Campaign__c = $campaign__c;
        }
        return $this;
    }
    /**
     * Get Campaign__r value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Campaign__c|null
     */
    public function getCampaign__r()
    {
        return isset($this->Campaign__r) ? $this->Campaign__r : null;
    }
    /**
     * Set Campaign__r value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Campaign__c $campaign__r
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCampaign__r(\NexusDigital/MiratelForce\StructType\Campaign__c $campaign__r = null)
    {
        if (is_null($campaign__r) || (is_array($campaign__r) && empty($campaign__r))) {
            unset($this->Campaign__r);
        } else {
            $this->Campaign__r = $campaign__r;
        }
        return $this;
    }
    /**
     * Get Cell_Phone__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCell_Phone__c()
    {
        return isset($this->Cell_Phone__c) ? $this->Cell_Phone__c : null;
    }
    /**
     * Set Cell_Phone__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cell_Phone__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCell_Phone__c($cell_Phone__c = null)
    {
        // validation for constraint: string
        if (!is_null($cell_Phone__c) && !is_string($cell_Phone__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cell_Phone__c, true), gettype($cell_Phone__c)), __LINE__);
        }
        if (is_null($cell_Phone__c) || (is_array($cell_Phone__c) && empty($cell_Phone__c))) {
            unset($this->Cell_Phone__c);
        } else {
            $this->Cell_Phone__c = $cell_Phone__c;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Created_by_Logged_in_User__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCreated_by_Logged_in_User__c()
    {
        return isset($this->Created_by_Logged_in_User__c) ? $this->Created_by_Logged_in_User__c : null;
    }
    /**
     * Set Created_by_Logged_in_User__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $created_by_Logged_in_User__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCreated_by_Logged_in_User__c($created_by_Logged_in_User__c = null)
    {
        // validation for constraint: boolean
        if (!is_null($created_by_Logged_in_User__c) && !is_bool($created_by_Logged_in_User__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($created_by_Logged_in_User__c, true), gettype($created_by_Logged_in_User__c)), __LINE__);
        }
        if (is_null($created_by_Logged_in_User__c) || (is_array($created_by_Logged_in_User__c) && empty($created_by_Logged_in_User__c))) {
            unset($this->Created_by_Logged_in_User__c);
        } else {
            $this->Created_by_Logged_in_User__c = $created_by_Logged_in_User__c;
        }
        return $this;
    }
    /**
     * Get Customer_ID__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomer_ID__c()
    {
        return isset($this->Customer_ID__c) ? $this->Customer_ID__c : null;
    }
    /**
     * Set Customer_ID__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customer_ID__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setCustomer_ID__c($customer_ID__c = null)
    {
        // validation for constraint: string
        if (!is_null($customer_ID__c) && !is_string($customer_ID__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_ID__c, true), gettype($customer_ID__c)), __LINE__);
        }
        if (is_null($customer_ID__c) || (is_array($customer_ID__c) && empty($customer_ID__c))) {
            unset($this->Customer_ID__c);
        } else {
            $this->Customer_ID__c = $customer_ID__c;
        }
        return $this;
    }
    /**
     * Get DB_Activity_Type__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDB_Activity_Type__c()
    {
        return isset($this->DB_Activity_Type__c) ? $this->DB_Activity_Type__c : null;
    }
    /**
     * Set DB_Activity_Type__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dB_Activity_Type__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDB_Activity_Type__c($dB_Activity_Type__c = null)
    {
        // validation for constraint: string
        if (!is_null($dB_Activity_Type__c) && !is_string($dB_Activity_Type__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dB_Activity_Type__c, true), gettype($dB_Activity_Type__c)), __LINE__);
        }
        if (is_null($dB_Activity_Type__c) || (is_array($dB_Activity_Type__c) && empty($dB_Activity_Type__c))) {
            unset($this->DB_Activity_Type__c);
        } else {
            $this->DB_Activity_Type__c = $dB_Activity_Type__c;
        }
        return $this;
    }
    /**
     * Get DST_Deliver__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDST_Deliver__c()
    {
        return isset($this->DST_Deliver__c) ? $this->DST_Deliver__c : null;
    }
    /**
     * Set DST_Deliver__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $dST_Deliver__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDST_Deliver__c($dST_Deliver__c = null)
    {
        // validation for constraint: boolean
        if (!is_null($dST_Deliver__c) && !is_bool($dST_Deliver__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dST_Deliver__c, true), gettype($dST_Deliver__c)), __LINE__);
        }
        if (is_null($dST_Deliver__c) || (is_array($dST_Deliver__c) && empty($dST_Deliver__c))) {
            unset($this->DST_Deliver__c);
        } else {
            $this->DST_Deliver__c = $dST_Deliver__c;
        }
        return $this;
    }
    /**
     * Get DST_Order__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDST_Order__c()
    {
        return isset($this->DST_Order__c) ? $this->DST_Order__c : null;
    }
    /**
     * Set DST_Order__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $dST_Order__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDST_Order__c($dST_Order__c = null)
    {
        // validation for constraint: boolean
        if (!is_null($dST_Order__c) && !is_bool($dST_Order__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dST_Order__c, true), gettype($dST_Order__c)), __LINE__);
        }
        if (is_null($dST_Order__c) || (is_array($dST_Order__c) && empty($dST_Order__c))) {
            unset($this->DST_Order__c);
        } else {
            $this->DST_Order__c = $dST_Order__c;
        }
        return $this;
    }
    /**
     * Get DateMDY__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateMDY__c()
    {
        return isset($this->DateMDY__c) ? $this->DateMDY__c : null;
    }
    /**
     * Set DateMDY__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateMDY__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDateMDY__c($dateMDY__c = null)
    {
        // validation for constraint: string
        if (!is_null($dateMDY__c) && !is_string($dateMDY__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateMDY__c, true), gettype($dateMDY__c)), __LINE__);
        }
        if (is_null($dateMDY__c) || (is_array($dateMDY__c) && empty($dateMDY__c))) {
            unset($this->DateMDY__c);
        } else {
            $this->DateMDY__c = $dateMDY__c;
        }
        return $this;
    }
    /**
     * Get Daytime_Phone_Number__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDaytime_Phone_Number__c()
    {
        return isset($this->Daytime_Phone_Number__c) ? $this->Daytime_Phone_Number__c : null;
    }
    /**
     * Set Daytime_Phone_Number__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $daytime_Phone_Number__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDaytime_Phone_Number__c($daytime_Phone_Number__c = null)
    {
        // validation for constraint: string
        if (!is_null($daytime_Phone_Number__c) && !is_string($daytime_Phone_Number__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daytime_Phone_Number__c, true), gettype($daytime_Phone_Number__c)), __LINE__);
        }
        if (is_null($daytime_Phone_Number__c) || (is_array($daytime_Phone_Number__c) && empty($daytime_Phone_Number__c))) {
            unset($this->Daytime_Phone_Number__c);
        } else {
            $this->Daytime_Phone_Number__c = $daytime_Phone_Number__c;
        }
        return $this;
    }
    /**
     * Get Deliver_Date_Time__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliver_Date_Time__c()
    {
        return isset($this->Deliver_Date_Time__c) ? $this->Deliver_Date_Time__c : null;
    }
    /**
     * Set Deliver_Date_Time__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliver_Date_Time__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDeliver_Date_Time__c($deliver_Date_Time__c = null)
    {
        // validation for constraint: string
        if (!is_null($deliver_Date_Time__c) && !is_string($deliver_Date_Time__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliver_Date_Time__c, true), gettype($deliver_Date_Time__c)), __LINE__);
        }
        if (is_null($deliver_Date_Time__c) || (is_array($deliver_Date_Time__c) && empty($deliver_Date_Time__c))) {
            unset($this->Deliver_Date_Time__c);
        } else {
            $this->Deliver_Date_Time__c = $deliver_Date_Time__c;
        }
        return $this;
    }
    /**
     * Get Deliver_Date__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliver_Date__c()
    {
        return isset($this->Deliver_Date__c) ? $this->Deliver_Date__c : null;
    }
    /**
     * Set Deliver_Date__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliver_Date__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDeliver_Date__c($deliver_Date__c = null)
    {
        // validation for constraint: string
        if (!is_null($deliver_Date__c) && !is_string($deliver_Date__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliver_Date__c, true), gettype($deliver_Date__c)), __LINE__);
        }
        if (is_null($deliver_Date__c) || (is_array($deliver_Date__c) && empty($deliver_Date__c))) {
            unset($this->Deliver_Date__c);
        } else {
            $this->Deliver_Date__c = $deliver_Date__c;
        }
        return $this;
    }
    /**
     * Get Deliver_Time__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliver_Time__c()
    {
        return isset($this->Deliver_Time__c) ? $this->Deliver_Time__c : null;
    }
    /**
     * Set Deliver_Time__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliver_Time__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDeliver_Time__c($deliver_Time__c = null)
    {
        // validation for constraint: string
        if (!is_null($deliver_Time__c) && !is_string($deliver_Time__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliver_Time__c, true), gettype($deliver_Time__c)), __LINE__);
        }
        if (is_null($deliver_Time__c) || (is_array($deliver_Time__c) && empty($deliver_Time__c))) {
            unset($this->Deliver_Time__c);
        } else {
            $this->Deliver_Time__c = $deliver_Time__c;
        }
        return $this;
    }
    /**
     * Get Deliver__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliver__c()
    {
        return isset($this->Deliver__c) ? $this->Deliver__c : null;
    }
    /**
     * Set Deliver__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliver__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDeliver__c($deliver__c = null)
    {
        // validation for constraint: string
        if (!is_null($deliver__c) && !is_string($deliver__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliver__c, true), gettype($deliver__c)), __LINE__);
        }
        if (is_null($deliver__c) || (is_array($deliver__c) && empty($deliver__c))) {
            unset($this->Deliver__c);
        } else {
            $this->Deliver__c = $deliver__c;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Donation__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonation__c()
    {
        return isset($this->Donation__c) ? $this->Donation__c : null;
    }
    /**
     * Set Donation__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donation__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDonation__c($donation__c = null)
    {
        // validation for constraint: string
        if (!is_null($donation__c) && !is_string($donation__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donation__c, true), gettype($donation__c)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($donation__c) && mb_strlen($donation__c) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($donation__c)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($donation__c) && !preg_match('/[a-zA-Z0-9]{18}/', $donation__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($donation__c, true)), __LINE__);
        }
        if (is_null($donation__c) || (is_array($donation__c) && empty($donation__c))) {
            unset($this->Donation__c);
        } else {
            $this->Donation__c = $donation__c;
        }
        return $this;
    }
    /**
     * Get Donation__r value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Donation__c|null
     */
    public function getDonation__r()
    {
        return isset($this->Donation__r) ? $this->Donation__r : null;
    }
    /**
     * Set Donation__r value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Donation__c $donation__r
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDonation__r(\NexusDigital/MiratelForce\StructType\Donation__c $donation__r = null)
    {
        if (is_null($donation__r) || (is_array($donation__r) && empty($donation__r))) {
            unset($this->Donation__r);
        } else {
            $this->Donation__r = $donation__r;
        }
        return $this;
    }
    /**
     * Get Donor_Service_Call_Back_Hour__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonor_Service_Call_Back_Hour__c()
    {
        return isset($this->Donor_Service_Call_Back_Hour__c) ? $this->Donor_Service_Call_Back_Hour__c : null;
    }
    /**
     * Set Donor_Service_Call_Back_Hour__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donor_Service_Call_Back_Hour__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDonor_Service_Call_Back_Hour__c($donor_Service_Call_Back_Hour__c = null)
    {
        // validation for constraint: string
        if (!is_null($donor_Service_Call_Back_Hour__c) && !is_string($donor_Service_Call_Back_Hour__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donor_Service_Call_Back_Hour__c, true), gettype($donor_Service_Call_Back_Hour__c)), __LINE__);
        }
        if (is_null($donor_Service_Call_Back_Hour__c) || (is_array($donor_Service_Call_Back_Hour__c) && empty($donor_Service_Call_Back_Hour__c))) {
            unset($this->Donor_Service_Call_Back_Hour__c);
        } else {
            $this->Donor_Service_Call_Back_Hour__c = $donor_Service_Call_Back_Hour__c;
        }
        return $this;
    }
    /**
     * Get Donor_Service_Call_Back_Minute__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonor_Service_Call_Back_Minute__c()
    {
        return isset($this->Donor_Service_Call_Back_Minute__c) ? $this->Donor_Service_Call_Back_Minute__c : null;
    }
    /**
     * Set Donor_Service_Call_Back_Minute__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donor_Service_Call_Back_Minute__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDonor_Service_Call_Back_Minute__c($donor_Service_Call_Back_Minute__c = null)
    {
        // validation for constraint: string
        if (!is_null($donor_Service_Call_Back_Minute__c) && !is_string($donor_Service_Call_Back_Minute__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donor_Service_Call_Back_Minute__c, true), gettype($donor_Service_Call_Back_Minute__c)), __LINE__);
        }
        if (is_null($donor_Service_Call_Back_Minute__c) || (is_array($donor_Service_Call_Back_Minute__c) && empty($donor_Service_Call_Back_Minute__c))) {
            unset($this->Donor_Service_Call_Back_Minute__c);
        } else {
            $this->Donor_Service_Call_Back_Minute__c = $donor_Service_Call_Back_Minute__c;
        }
        return $this;
    }
    /**
     * Get DurationInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDurationInMinutes()
    {
        return isset($this->DurationInMinutes) ? $this->DurationInMinutes : null;
    }
    /**
     * Set DurationInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $durationInMinutes
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setDurationInMinutes($durationInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($durationInMinutes) && !(is_int($durationInMinutes) || ctype_digit($durationInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durationInMinutes, true), gettype($durationInMinutes)), __LINE__);
        }
        if (is_null($durationInMinutes) || (is_array($durationInMinutes) && empty($durationInMinutes))) {
            unset($this->DurationInMinutes);
        } else {
            $this->DurationInMinutes = $durationInMinutes;
        }
        return $this;
    }
    /**
     * Get Email_Address__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail_Address__c()
    {
        return isset($this->Email_Address__c) ? $this->Email_Address__c : null;
    }
    /**
     * Set Email_Address__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email_Address__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setEmail_Address__c($email_Address__c = null)
    {
        // validation for constraint: string
        if (!is_null($email_Address__c) && !is_string($email_Address__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email_Address__c, true), gettype($email_Address__c)), __LINE__);
        }
        if (is_null($email_Address__c) || (is_array($email_Address__c) && empty($email_Address__c))) {
            unset($this->Email_Address__c);
        } else {
            $this->Email_Address__c = $email_Address__c;
        }
        return $this;
    }
    /**
     * Get Email__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail__c()
    {
        return isset($this->Email__c) ? $this->Email__c : null;
    }
    /**
     * Set Email__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setEmail__c($email__c = null)
    {
        // validation for constraint: string
        if (!is_null($email__c) && !is_string($email__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email__c, true), gettype($email__c)), __LINE__);
        }
        if (is_null($email__c) || (is_array($email__c) && empty($email__c))) {
            unset($this->Email__c);
        } else {
            $this->Email__c = $email__c;
        }
        return $this;
    }
    /**
     * Get EndDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDateTime()
    {
        return isset($this->EndDateTime) ? $this->EndDateTime : null;
    }
    /**
     * Set EndDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDateTime
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateTime, true), gettype($endDateTime)), __LINE__);
        }
        if (is_null($endDateTime) || (is_array($endDateTime) && empty($endDateTime))) {
            unset($this->EndDateTime);
        } else {
            $this->EndDateTime = $endDateTime;
        }
        return $this;
    }
    /**
     * Get First_Name__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirst_Name__c()
    {
        return isset($this->First_Name__c) ? $this->First_Name__c : null;
    }
    /**
     * Set First_Name__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $first_Name__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setFirst_Name__c($first_Name__c = null)
    {
        // validation for constraint: string
        if (!is_null($first_Name__c) && !is_string($first_Name__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first_Name__c, true), gettype($first_Name__c)), __LINE__);
        }
        if (is_null($first_Name__c) || (is_array($first_Name__c) && empty($first_Name__c))) {
            unset($this->First_Name__c);
        } else {
            $this->First_Name__c = $first_Name__c;
        }
        return $this;
    }
    /**
     * Get Honourific__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHonourific__c()
    {
        return isset($this->Honourific__c) ? $this->Honourific__c : null;
    }
    /**
     * Set Honourific__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $honourific__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setHonourific__c($honourific__c = null)
    {
        // validation for constraint: string
        if (!is_null($honourific__c) && !is_string($honourific__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($honourific__c, true), gettype($honourific__c)), __LINE__);
        }
        if (is_null($honourific__c) || (is_array($honourific__c) && empty($honourific__c))) {
            unset($this->Honourific__c);
        } else {
            $this->Honourific__c = $honourific__c;
        }
        return $this;
    }
    /**
     * Get Inbound_Outbound__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInbound_Outbound__c()
    {
        return isset($this->Inbound_Outbound__c) ? $this->Inbound_Outbound__c : null;
    }
    /**
     * Set Inbound_Outbound__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inbound_Outbound__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setInbound_Outbound__c($inbound_Outbound__c = null)
    {
        // validation for constraint: string
        if (!is_null($inbound_Outbound__c) && !is_string($inbound_Outbound__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inbound_Outbound__c, true), gettype($inbound_Outbound__c)), __LINE__);
        }
        if (is_null($inbound_Outbound__c) || (is_array($inbound_Outbound__c) && empty($inbound_Outbound__c))) {
            unset($this->Inbound_Outbound__c);
        } else {
            $this->Inbound_Outbound__c = $inbound_Outbound__c;
        }
        return $this;
    }
    /**
     * Get Inbound_Phone_Display__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInbound_Phone_Display__c()
    {
        return isset($this->Inbound_Phone_Display__c) ? $this->Inbound_Phone_Display__c : null;
    }
    /**
     * Set Inbound_Phone_Display__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inbound_Phone_Display__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setInbound_Phone_Display__c($inbound_Phone_Display__c = null)
    {
        // validation for constraint: string
        if (!is_null($inbound_Phone_Display__c) && !is_string($inbound_Phone_Display__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inbound_Phone_Display__c, true), gettype($inbound_Phone_Display__c)), __LINE__);
        }
        if (is_null($inbound_Phone_Display__c) || (is_array($inbound_Phone_Display__c) && empty($inbound_Phone_Display__c))) {
            unset($this->Inbound_Phone_Display__c);
        } else {
            $this->Inbound_Phone_Display__c = $inbound_Phone_Display__c;
        }
        return $this;
    }
    /**
     * Get IsAllDayEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllDayEvent()
    {
        return isset($this->IsAllDayEvent) ? $this->IsAllDayEvent : null;
    }
    /**
     * Set IsAllDayEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllDayEvent
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setIsAllDayEvent($isAllDayEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllDayEvent) && !is_bool($isAllDayEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllDayEvent, true), gettype($isAllDayEvent)), __LINE__);
        }
        if (is_null($isAllDayEvent) || (is_array($isAllDayEvent) && empty($isAllDayEvent))) {
            unset($this->IsAllDayEvent);
        } else {
            $this->IsAllDayEvent = $isAllDayEvent;
        }
        return $this;
    }
    /**
     * Get IsClosed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClosed()
    {
        return isset($this->IsClosed) ? $this->IsClosed : null;
    }
    /**
     * Set IsClosed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClosed
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        if (is_null($isClosed) || (is_array($isClosed) && empty($isClosed))) {
            unset($this->IsClosed);
        } else {
            $this->IsClosed = $isClosed;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsHighPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHighPriority()
    {
        return isset($this->IsHighPriority) ? $this->IsHighPriority : null;
    }
    /**
     * Set IsHighPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHighPriority
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setIsHighPriority($isHighPriority = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHighPriority) && !is_bool($isHighPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHighPriority, true), gettype($isHighPriority)), __LINE__);
        }
        if (is_null($isHighPriority) || (is_array($isHighPriority) && empty($isHighPriority))) {
            unset($this->IsHighPriority);
        } else {
            $this->IsHighPriority = $isHighPriority;
        }
        return $this;
    }
    /**
     * Get IsReminderSet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReminderSet()
    {
        return isset($this->IsReminderSet) ? $this->IsReminderSet : null;
    }
    /**
     * Set IsReminderSet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReminderSet
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setIsReminderSet($isReminderSet = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReminderSet) && !is_bool($isReminderSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReminderSet, true), gettype($isReminderSet)), __LINE__);
        }
        if (is_null($isReminderSet) || (is_array($isReminderSet) && empty($isReminderSet))) {
            unset($this->IsReminderSet);
        } else {
            $this->IsReminderSet = $isReminderSet;
        }
        return $this;
    }
    /**
     * Get IsTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTask()
    {
        return isset($this->IsTask) ? $this->IsTask : null;
    }
    /**
     * Set IsTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTask
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setIsTask($isTask = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTask) && !is_bool($isTask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTask, true), gettype($isTask)), __LINE__);
        }
        if (is_null($isTask) || (is_array($isTask) && empty($isTask))) {
            unset($this->IsTask);
        } else {
            $this->IsTask = $isTask;
        }
        return $this;
    }
    /**
     * Get IsVisibleInSelfService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisibleInSelfService()
    {
        return isset($this->IsVisibleInSelfService) ? $this->IsVisibleInSelfService : null;
    }
    /**
     * Set IsVisibleInSelfService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisibleInSelfService
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setIsVisibleInSelfService($isVisibleInSelfService = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisibleInSelfService) && !is_bool($isVisibleInSelfService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisibleInSelfService, true), gettype($isVisibleInSelfService)), __LINE__);
        }
        if (is_null($isVisibleInSelfService) || (is_array($isVisibleInSelfService) && empty($isVisibleInSelfService))) {
            unset($this->IsVisibleInSelfService);
        } else {
            $this->IsVisibleInSelfService = $isVisibleInSelfService;
        }
        return $this;
    }
    /**
     * Get Language__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage__c()
    {
        return isset($this->Language__c) ? $this->Language__c : null;
    }
    /**
     * Set Language__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setLanguage__c($language__c = null)
    {
        // validation for constraint: string
        if (!is_null($language__c) && !is_string($language__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language__c, true), gettype($language__c)), __LINE__);
        }
        if (is_null($language__c) || (is_array($language__c) && empty($language__c))) {
            unset($this->Language__c);
        } else {
            $this->Language__c = $language__c;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Last_Name__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLast_Name__c()
    {
        return isset($this->Last_Name__c) ? $this->Last_Name__c : null;
    }
    /**
     * Set Last_Name__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $last_Name__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setLast_Name__c($last_Name__c = null)
    {
        // validation for constraint: string
        if (!is_null($last_Name__c) && !is_string($last_Name__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Name__c, true), gettype($last_Name__c)), __LINE__);
        }
        if (is_null($last_Name__c) || (is_array($last_Name__c) && empty($last_Name__c))) {
            unset($this->Last_Name__c);
        } else {
            $this->Last_Name__c = $last_Name__c;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $location
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get Mailing_City__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailing_City__c()
    {
        return isset($this->Mailing_City__c) ? $this->Mailing_City__c : null;
    }
    /**
     * Set Mailing_City__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailing_City__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setMailing_City__c($mailing_City__c = null)
    {
        // validation for constraint: string
        if (!is_null($mailing_City__c) && !is_string($mailing_City__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailing_City__c, true), gettype($mailing_City__c)), __LINE__);
        }
        if (is_null($mailing_City__c) || (is_array($mailing_City__c) && empty($mailing_City__c))) {
            unset($this->Mailing_City__c);
        } else {
            $this->Mailing_City__c = $mailing_City__c;
        }
        return $this;
    }
    /**
     * Get Mailing_Country__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailing_Country__c()
    {
        return isset($this->Mailing_Country__c) ? $this->Mailing_Country__c : null;
    }
    /**
     * Set Mailing_Country__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailing_Country__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setMailing_Country__c($mailing_Country__c = null)
    {
        // validation for constraint: string
        if (!is_null($mailing_Country__c) && !is_string($mailing_Country__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailing_Country__c, true), gettype($mailing_Country__c)), __LINE__);
        }
        if (is_null($mailing_Country__c) || (is_array($mailing_Country__c) && empty($mailing_Country__c))) {
            unset($this->Mailing_Country__c);
        } else {
            $this->Mailing_Country__c = $mailing_Country__c;
        }
        return $this;
    }
    /**
     * Get Mailing_Province__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailing_Province__c()
    {
        return isset($this->Mailing_Province__c) ? $this->Mailing_Province__c : null;
    }
    /**
     * Set Mailing_Province__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailing_Province__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setMailing_Province__c($mailing_Province__c = null)
    {
        // validation for constraint: string
        if (!is_null($mailing_Province__c) && !is_string($mailing_Province__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailing_Province__c, true), gettype($mailing_Province__c)), __LINE__);
        }
        if (is_null($mailing_Province__c) || (is_array($mailing_Province__c) && empty($mailing_Province__c))) {
            unset($this->Mailing_Province__c);
        } else {
            $this->Mailing_Province__c = $mailing_Province__c;
        }
        return $this;
    }
    /**
     * Get Mailing_Street__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailing_Street__c()
    {
        return isset($this->Mailing_Street__c) ? $this->Mailing_Street__c : null;
    }
    /**
     * Set Mailing_Street__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailing_Street__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setMailing_Street__c($mailing_Street__c = null)
    {
        // validation for constraint: string
        if (!is_null($mailing_Street__c) && !is_string($mailing_Street__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailing_Street__c, true), gettype($mailing_Street__c)), __LINE__);
        }
        if (is_null($mailing_Street__c) || (is_array($mailing_Street__c) && empty($mailing_Street__c))) {
            unset($this->Mailing_Street__c);
        } else {
            $this->Mailing_Street__c = $mailing_Street__c;
        }
        return $this;
    }
    /**
     * Get Mailing_Suite_Apt__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailing_Suite_Apt__c()
    {
        return isset($this->Mailing_Suite_Apt__c) ? $this->Mailing_Suite_Apt__c : null;
    }
    /**
     * Set Mailing_Suite_Apt__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailing_Suite_Apt__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setMailing_Suite_Apt__c($mailing_Suite_Apt__c = null)
    {
        // validation for constraint: string
        if (!is_null($mailing_Suite_Apt__c) && !is_string($mailing_Suite_Apt__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailing_Suite_Apt__c, true), gettype($mailing_Suite_Apt__c)), __LINE__);
        }
        if (is_null($mailing_Suite_Apt__c) || (is_array($mailing_Suite_Apt__c) && empty($mailing_Suite_Apt__c))) {
            unset($this->Mailing_Suite_Apt__c);
        } else {
            $this->Mailing_Suite_Apt__c = $mailing_Suite_Apt__c;
        }
        return $this;
    }
    /**
     * Get Mailing_Zip_Postal_Code__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailing_Zip_Postal_Code__c()
    {
        return isset($this->Mailing_Zip_Postal_Code__c) ? $this->Mailing_Zip_Postal_Code__c : null;
    }
    /**
     * Set Mailing_Zip_Postal_Code__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailing_Zip_Postal_Code__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setMailing_Zip_Postal_Code__c($mailing_Zip_Postal_Code__c = null)
    {
        // validation for constraint: string
        if (!is_null($mailing_Zip_Postal_Code__c) && !is_string($mailing_Zip_Postal_Code__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailing_Zip_Postal_Code__c, true), gettype($mailing_Zip_Postal_Code__c)), __LINE__);
        }
        if (is_null($mailing_Zip_Postal_Code__c) || (is_array($mailing_Zip_Postal_Code__c) && empty($mailing_Zip_Postal_Code__c))) {
            unset($this->Mailing_Zip_Postal_Code__c);
        } else {
            $this->Mailing_Zip_Postal_Code__c = $mailing_Zip_Postal_Code__c;
        }
        return $this;
    }
    /**
     * Get Message_Content__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage_Content__c()
    {
        return isset($this->Message_Content__c) ? $this->Message_Content__c : null;
    }
    /**
     * Set Message_Content__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message_Content__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setMessage_Content__c($message_Content__c = null)
    {
        // validation for constraint: string
        if (!is_null($message_Content__c) && !is_string($message_Content__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message_Content__c, true), gettype($message_Content__c)), __LINE__);
        }
        if (is_null($message_Content__c) || (is_array($message_Content__c) && empty($message_Content__c))) {
            unset($this->Message_Content__c);
        } else {
            $this->Message_Content__c = $message_Content__c;
        }
        return $this;
    }
    /**
     * Get Not_Interested_Reasons__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNot_Interested_Reasons__c()
    {
        return isset($this->Not_Interested_Reasons__c) ? $this->Not_Interested_Reasons__c : null;
    }
    /**
     * Set Not_Interested_Reasons__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $not_Interested_Reasons__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setNot_Interested_Reasons__c($not_Interested_Reasons__c = null)
    {
        // validation for constraint: string
        if (!is_null($not_Interested_Reasons__c) && !is_string($not_Interested_Reasons__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($not_Interested_Reasons__c, true), gettype($not_Interested_Reasons__c)), __LINE__);
        }
        if (is_null($not_Interested_Reasons__c) || (is_array($not_Interested_Reasons__c) && empty($not_Interested_Reasons__c))) {
            unset($this->Not_Interested_Reasons__c);
        } else {
            $this->Not_Interested_Reasons__c = $not_Interested_Reasons__c;
        }
        return $this;
    }
    /**
     * Get OPSTFNS1__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPSTFNS1__c()
    {
        return isset($this->OPSTFNS1__c) ? $this->OPSTFNS1__c : null;
    }
    /**
     * Set OPSTFNS1__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPSTFNS1__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setOPSTFNS1__c($oPSTFNS1__c = null)
    {
        // validation for constraint: string
        if (!is_null($oPSTFNS1__c) && !is_string($oPSTFNS1__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oPSTFNS1__c, true), gettype($oPSTFNS1__c)), __LINE__);
        }
        if (is_null($oPSTFNS1__c) || (is_array($oPSTFNS1__c) && empty($oPSTFNS1__c))) {
            unset($this->OPSTFNS1__c);
        } else {
            $this->OPSTFNS1__c = $oPSTFNS1__c;
        }
        return $this;
    }
    /**
     * Get OPSTFNS2__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPSTFNS2__c()
    {
        return isset($this->OPSTFNS2__c) ? $this->OPSTFNS2__c : null;
    }
    /**
     * Set OPSTFNS2__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPSTFNS2__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setOPSTFNS2__c($oPSTFNS2__c = null)
    {
        // validation for constraint: string
        if (!is_null($oPSTFNS2__c) && !is_string($oPSTFNS2__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oPSTFNS2__c, true), gettype($oPSTFNS2__c)), __LINE__);
        }
        if (is_null($oPSTFNS2__c) || (is_array($oPSTFNS2__c) && empty($oPSTFNS2__c))) {
            unset($this->OPSTFNS2__c);
        } else {
            $this->OPSTFNS2__c = $oPSTFNS2__c;
        }
        return $this;
    }
    /**
     * Get OPSTFNS3__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOPSTFNS3__c()
    {
        return isset($this->OPSTFNS3__c) ? $this->OPSTFNS3__c : null;
    }
    /**
     * Set OPSTFNS3__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oPSTFNS3__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setOPSTFNS3__c($oPSTFNS3__c = null)
    {
        // validation for constraint: string
        if (!is_null($oPSTFNS3__c) && !is_string($oPSTFNS3__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oPSTFNS3__c, true), gettype($oPSTFNS3__c)), __LINE__);
        }
        if (is_null($oPSTFNS3__c) || (is_array($oPSTFNS3__c) && empty($oPSTFNS3__c))) {
            unset($this->OPSTFNS3__c);
        } else {
            $this->OPSTFNS3__c = $oPSTFNS3__c;
        }
        return $this;
    }
    /**
     * Get Order_Date_Time__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrder_Date_Time__c()
    {
        return isset($this->Order_Date_Time__c) ? $this->Order_Date_Time__c : null;
    }
    /**
     * Set Order_Date_Time__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $order_Date_Time__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setOrder_Date_Time__c($order_Date_Time__c = null)
    {
        // validation for constraint: string
        if (!is_null($order_Date_Time__c) && !is_string($order_Date_Time__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order_Date_Time__c, true), gettype($order_Date_Time__c)), __LINE__);
        }
        if (is_null($order_Date_Time__c) || (is_array($order_Date_Time__c) && empty($order_Date_Time__c))) {
            unset($this->Order_Date_Time__c);
        } else {
            $this->Order_Date_Time__c = $order_Date_Time__c;
        }
        return $this;
    }
    /**
     * Get Order_Date__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrder_Date__c()
    {
        return isset($this->Order_Date__c) ? $this->Order_Date__c : null;
    }
    /**
     * Set Order_Date__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $order_Date__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setOrder_Date__c($order_Date__c = null)
    {
        // validation for constraint: string
        if (!is_null($order_Date__c) && !is_string($order_Date__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order_Date__c, true), gettype($order_Date__c)), __LINE__);
        }
        if (is_null($order_Date__c) || (is_array($order_Date__c) && empty($order_Date__c))) {
            unset($this->Order_Date__c);
        } else {
            $this->Order_Date__c = $order_Date__c;
        }
        return $this;
    }
    /**
     * Get Order_Time__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrder_Time__c()
    {
        return isset($this->Order_Time__c) ? $this->Order_Time__c : null;
    }
    /**
     * Set Order_Time__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $order_Time__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setOrder_Time__c($order_Time__c = null)
    {
        // validation for constraint: string
        if (!is_null($order_Time__c) && !is_string($order_Time__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order_Time__c, true), gettype($order_Time__c)), __LINE__);
        }
        if (is_null($order_Time__c) || (is_array($order_Time__c) && empty($order_Time__c))) {
            unset($this->Order_Time__c);
        } else {
            $this->Order_Time__c = $order_Time__c;
        }
        return $this;
    }
    /**
     * Get OutboundCall_Result_SMD_Lottery__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutboundCall_Result_SMD_Lottery__c()
    {
        return isset($this->OutboundCall_Result_SMD_Lottery__c) ? $this->OutboundCall_Result_SMD_Lottery__c : null;
    }
    /**
     * Set OutboundCall_Result_SMD_Lottery__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $outboundCall_Result_SMD_Lottery__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setOutboundCall_Result_SMD_Lottery__c($outboundCall_Result_SMD_Lottery__c = null)
    {
        // validation for constraint: string
        if (!is_null($outboundCall_Result_SMD_Lottery__c) && !is_string($outboundCall_Result_SMD_Lottery__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outboundCall_Result_SMD_Lottery__c, true), gettype($outboundCall_Result_SMD_Lottery__c)), __LINE__);
        }
        if (is_null($outboundCall_Result_SMD_Lottery__c) || (is_array($outboundCall_Result_SMD_Lottery__c) && empty($outboundCall_Result_SMD_Lottery__c))) {
            unset($this->OutboundCall_Result_SMD_Lottery__c);
        } else {
            $this->OutboundCall_Result_SMD_Lottery__c = $outboundCall_Result_SMD_Lottery__c;
        }
        return $this;
    }
    /**
     * Get Outbound_Call_Result__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutbound_Call_Result__c()
    {
        return isset($this->Outbound_Call_Result__c) ? $this->Outbound_Call_Result__c : null;
    }
    /**
     * Set Outbound_Call_Result__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $outbound_Call_Result__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setOutbound_Call_Result__c($outbound_Call_Result__c = null)
    {
        // validation for constraint: string
        if (!is_null($outbound_Call_Result__c) && !is_string($outbound_Call_Result__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outbound_Call_Result__c, true), gettype($outbound_Call_Result__c)), __LINE__);
        }
        if (is_null($outbound_Call_Result__c) || (is_array($outbound_Call_Result__c) && empty($outbound_Call_Result__c))) {
            unset($this->Outbound_Call_Result__c);
        } else {
            $this->Outbound_Call_Result__c = $outbound_Call_Result__c;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\SObject $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get PrimaryAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Account|null
     */
    public function getPrimaryAccount()
    {
        return isset($this->PrimaryAccount) ? $this->PrimaryAccount : null;
    }
    /**
     * Set PrimaryAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Account $primaryAccount
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setPrimaryAccount(\NexusDigital/MiratelForce\StructType\Account $primaryAccount = null)
    {
        if (is_null($primaryAccount) || (is_array($primaryAccount) && empty($primaryAccount))) {
            unset($this->PrimaryAccount);
        } else {
            $this->PrimaryAccount = $primaryAccount;
        }
        return $this;
    }
    /**
     * Get PrimaryAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryAccountId()
    {
        return isset($this->PrimaryAccountId) ? $this->PrimaryAccountId : null;
    }
    /**
     * Set PrimaryAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryAccountId
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setPrimaryAccountId($primaryAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAccountId) && !is_string($primaryAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryAccountId, true), gettype($primaryAccountId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($primaryAccountId) && mb_strlen($primaryAccountId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($primaryAccountId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($primaryAccountId) && !preg_match('/[a-zA-Z0-9]{18}/', $primaryAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($primaryAccountId, true)), __LINE__);
        }
        if (is_null($primaryAccountId) || (is_array($primaryAccountId) && empty($primaryAccountId))) {
            unset($this->PrimaryAccountId);
        } else {
            $this->PrimaryAccountId = $primaryAccountId;
        }
        return $this;
    }
    /**
     * Get PrimaryWho value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getPrimaryWho()
    {
        return isset($this->PrimaryWho) ? $this->PrimaryWho : null;
    }
    /**
     * Set PrimaryWho value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $primaryWho
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setPrimaryWho(\NexusDigital/MiratelForce\StructType\SObject $primaryWho = null)
    {
        if (is_null($primaryWho) || (is_array($primaryWho) && empty($primaryWho))) {
            unset($this->PrimaryWho);
        } else {
            $this->PrimaryWho = $primaryWho;
        }
        return $this;
    }
    /**
     * Get PrimaryWhoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryWhoId()
    {
        return isset($this->PrimaryWhoId) ? $this->PrimaryWhoId : null;
    }
    /**
     * Set PrimaryWhoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryWhoId
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setPrimaryWhoId($primaryWhoId = null)
    {
        // validation for constraint: string
        if (!is_null($primaryWhoId) && !is_string($primaryWhoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryWhoId, true), gettype($primaryWhoId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($primaryWhoId) && mb_strlen($primaryWhoId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($primaryWhoId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($primaryWhoId) && !preg_match('/[a-zA-Z0-9]{18}/', $primaryWhoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($primaryWhoId, true)), __LINE__);
        }
        if (is_null($primaryWhoId) || (is_array($primaryWhoId) && empty($primaryWhoId))) {
            unset($this->PrimaryWhoId);
        } else {
            $this->PrimaryWhoId = $primaryWhoId;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priority
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ReminderDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReminderDateTime()
    {
        return isset($this->ReminderDateTime) ? $this->ReminderDateTime : null;
    }
    /**
     * Set ReminderDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reminderDateTime
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setReminderDateTime($reminderDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($reminderDateTime) && !is_string($reminderDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reminderDateTime, true), gettype($reminderDateTime)), __LINE__);
        }
        if (is_null($reminderDateTime) || (is_array($reminderDateTime) && empty($reminderDateTime))) {
            unset($this->ReminderDateTime);
        } else {
            $this->ReminderDateTime = $reminderDateTime;
        }
        return $this;
    }
    /**
     * Get StartDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateTime()
    {
        return isset($this->StartDateTime) ? $this->StartDateTime : null;
    }
    /**
     * Set StartDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateTime
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTime, true), gettype($startDateTime)), __LINE__);
        }
        if (is_null($startDateTime) || (is_array($startDateTime) && empty($startDateTime))) {
            unset($this->StartDateTime);
        } else {
            $this->StartDateTime = $startDateTime;
        }
        return $this;
    }
    /**
     * Get Station_ID__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStation_ID__c()
    {
        return isset($this->Station_ID__c) ? $this->Station_ID__c : null;
    }
    /**
     * Set Station_ID__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $station_ID__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setStation_ID__c($station_ID__c = null)
    {
        // validation for constraint: string
        if (!is_null($station_ID__c) && !is_string($station_ID__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($station_ID__c, true), gettype($station_ID__c)), __LINE__);
        }
        if (is_null($station_ID__c) || (is_array($station_ID__c) && empty($station_ID__c))) {
            unset($this->Station_ID__c);
        } else {
            $this->Station_ID__c = $station_ID__c;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Status_Code__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus_Code__c()
    {
        return isset($this->Status_Code__c) ? $this->Status_Code__c : null;
    }
    /**
     * Set Status_Code__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status_Code__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setStatus_Code__c($status_Code__c = null)
    {
        // validation for constraint: string
        if (!is_null($status_Code__c) && !is_string($status_Code__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status_Code__c, true), gettype($status_Code__c)), __LINE__);
        }
        if (is_null($status_Code__c) || (is_array($status_Code__c) && empty($status_Code__c))) {
            unset($this->Status_Code__c);
        } else {
            $this->Status_Code__c = $status_Code__c;
        }
        return $this;
    }
    /**
     * Get Subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubject()
    {
        return isset($this->Subject) ? $this->Subject : null;
    }
    /**
     * Set Subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subject
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->Subject);
        } else {
            $this->Subject = $subject;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TaskTime__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaskTime__c()
    {
        return isset($this->TaskTime__c) ? $this->TaskTime__c : null;
    }
    /**
     * Set TaskTime__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taskTime__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setTaskTime__c($taskTime__c = null)
    {
        // validation for constraint: string
        if (!is_null($taskTime__c) && !is_string($taskTime__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taskTime__c, true), gettype($taskTime__c)), __LINE__);
        }
        if (is_null($taskTime__c) || (is_array($taskTime__c) && empty($taskTime__c))) {
            unset($this->TaskTime__c);
        } else {
            $this->TaskTime__c = $taskTime__c;
        }
        return $this;
    }
    /**
     * Get Ticket_Order__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicket_Order__c()
    {
        return isset($this->Ticket_Order__c) ? $this->Ticket_Order__c : null;
    }
    /**
     * Set Ticket_Order__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticket_Order__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setTicket_Order__c($ticket_Order__c = null)
    {
        // validation for constraint: string
        if (!is_null($ticket_Order__c) && !is_string($ticket_Order__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket_Order__c, true), gettype($ticket_Order__c)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ticket_Order__c) && mb_strlen($ticket_Order__c) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ticket_Order__c)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ticket_Order__c) && !preg_match('/[a-zA-Z0-9]{18}/', $ticket_Order__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ticket_Order__c, true)), __LINE__);
        }
        if (is_null($ticket_Order__c) || (is_array($ticket_Order__c) && empty($ticket_Order__c))) {
            unset($this->Ticket_Order__c);
        } else {
            $this->Ticket_Order__c = $ticket_Order__c;
        }
        return $this;
    }
    /**
     * Get Ticket_Order__r value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Ticket_Order__c|null
     */
    public function getTicket_Order__r()
    {
        return isset($this->Ticket_Order__r) ? $this->Ticket_Order__r : null;
    }
    /**
     * Set Ticket_Order__r value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Ticket_Order__c $ticket_Order__r
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setTicket_Order__r(\NexusDigital/MiratelForce\StructType\Ticket_Order__c $ticket_Order__r = null)
    {
        if (is_null($ticket_Order__r) || (is_array($ticket_Order__r) && empty($ticket_Order__r))) {
            unset($this->Ticket_Order__r);
        } else {
            $this->Ticket_Order__r = $ticket_Order__r;
        }
        return $this;
    }
    /**
     * Get Update_City__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdate_City__c()
    {
        return isset($this->Update_City__c) ? $this->Update_City__c : null;
    }
    /**
     * Set Update_City__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $update_City__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setUpdate_City__c($update_City__c = null)
    {
        // validation for constraint: string
        if (!is_null($update_City__c) && !is_string($update_City__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($update_City__c, true), gettype($update_City__c)), __LINE__);
        }
        if (is_null($update_City__c) || (is_array($update_City__c) && empty($update_City__c))) {
            unset($this->Update_City__c);
        } else {
            $this->Update_City__c = $update_City__c;
        }
        return $this;
    }
    /**
     * Get Update_Country__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdate_Country__c()
    {
        return isset($this->Update_Country__c) ? $this->Update_Country__c : null;
    }
    /**
     * Set Update_Country__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $update_Country__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setUpdate_Country__c($update_Country__c = null)
    {
        // validation for constraint: string
        if (!is_null($update_Country__c) && !is_string($update_Country__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($update_Country__c, true), gettype($update_Country__c)), __LINE__);
        }
        if (is_null($update_Country__c) || (is_array($update_Country__c) && empty($update_Country__c))) {
            unset($this->Update_Country__c);
        } else {
            $this->Update_Country__c = $update_Country__c;
        }
        return $this;
    }
    /**
     * Get Update_Email__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdate_Email__c()
    {
        return isset($this->Update_Email__c) ? $this->Update_Email__c : null;
    }
    /**
     * Set Update_Email__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $update_Email__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setUpdate_Email__c($update_Email__c = null)
    {
        // validation for constraint: string
        if (!is_null($update_Email__c) && !is_string($update_Email__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($update_Email__c, true), gettype($update_Email__c)), __LINE__);
        }
        if (is_null($update_Email__c) || (is_array($update_Email__c) && empty($update_Email__c))) {
            unset($this->Update_Email__c);
        } else {
            $this->Update_Email__c = $update_Email__c;
        }
        return $this;
    }
    /**
     * Get Update_Primary_Phone__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdate_Primary_Phone__c()
    {
        return isset($this->Update_Primary_Phone__c) ? $this->Update_Primary_Phone__c : null;
    }
    /**
     * Set Update_Primary_Phone__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $update_Primary_Phone__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setUpdate_Primary_Phone__c($update_Primary_Phone__c = null)
    {
        // validation for constraint: string
        if (!is_null($update_Primary_Phone__c) && !is_string($update_Primary_Phone__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($update_Primary_Phone__c, true), gettype($update_Primary_Phone__c)), __LINE__);
        }
        if (is_null($update_Primary_Phone__c) || (is_array($update_Primary_Phone__c) && empty($update_Primary_Phone__c))) {
            unset($this->Update_Primary_Phone__c);
        } else {
            $this->Update_Primary_Phone__c = $update_Primary_Phone__c;
        }
        return $this;
    }
    /**
     * Get Update_Province__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdate_Province__c()
    {
        return isset($this->Update_Province__c) ? $this->Update_Province__c : null;
    }
    /**
     * Set Update_Province__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $update_Province__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setUpdate_Province__c($update_Province__c = null)
    {
        // validation for constraint: string
        if (!is_null($update_Province__c) && !is_string($update_Province__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($update_Province__c, true), gettype($update_Province__c)), __LINE__);
        }
        if (is_null($update_Province__c) || (is_array($update_Province__c) && empty($update_Province__c))) {
            unset($this->Update_Province__c);
        } else {
            $this->Update_Province__c = $update_Province__c;
        }
        return $this;
    }
    /**
     * Get Update_Street__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdate_Street_2__c()
    {
        return isset($this->Update_Street_2__c) ? $this->Update_Street_2__c : null;
    }
    /**
     * Set Update_Street__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $update_Street__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setUpdate_Street_2__c($update_Street_2__c = null)
    {
        // validation for constraint: string
        if (!is_null($update_Street_2__c) && !is_string($update_Street_2__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($update_Street_2__c, true), gettype($update_Street_2__c)), __LINE__);
        }
        if (is_null($update_Street_2__c) || (is_array($update_Street_2__c) && empty($update_Street_2__c))) {
            unset($this->Update_Street_2__c);
        } else {
            $this->Update_Street_2__c = $update_Street_2__c;
        }
        return $this;
    }
    /**
     * Get Update_Street__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdate_Street__c()
    {
        return isset($this->Update_Street__c) ? $this->Update_Street__c : null;
    }
    /**
     * Set Update_Street__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $update_Street__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setUpdate_Street__c($update_Street__c = null)
    {
        // validation for constraint: string
        if (!is_null($update_Street__c) && !is_string($update_Street__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($update_Street__c, true), gettype($update_Street__c)), __LINE__);
        }
        if (is_null($update_Street__c) || (is_array($update_Street__c) && empty($update_Street__c))) {
            unset($this->Update_Street__c);
        } else {
            $this->Update_Street__c = $update_Street__c;
        }
        return $this;
    }
    /**
     * Get Update_Zip_Postal_Code__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdate_Zip_Postal_Code__c()
    {
        return isset($this->Update_Zip_Postal_Code__c) ? $this->Update_Zip_Postal_Code__c : null;
    }
    /**
     * Set Update_Zip_Postal_Code__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $update_Zip_Postal_Code__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setUpdate_Zip_Postal_Code__c($update_Zip_Postal_Code__c = null)
    {
        // validation for constraint: string
        if (!is_null($update_Zip_Postal_Code__c) && !is_string($update_Zip_Postal_Code__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($update_Zip_Postal_Code__c, true), gettype($update_Zip_Postal_Code__c)), __LINE__);
        }
        if (is_null($update_Zip_Postal_Code__c) || (is_array($update_Zip_Postal_Code__c) && empty($update_Zip_Postal_Code__c))) {
            unset($this->Update_Zip_Postal_Code__c);
        } else {
            $this->Update_Zip_Postal_Code__c = $update_Zip_Postal_Code__c;
        }
        return $this;
    }
    /**
     * Get What value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getWhat()
    {
        return isset($this->What) ? $this->What : null;
    }
    /**
     * Set What value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $what
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setWhat(\NexusDigital/MiratelForce\StructType\SObject $what = null)
    {
        if (is_null($what) || (is_array($what) && empty($what))) {
            unset($this->What);
        } else {
            $this->What = $what;
        }
        return $this;
    }
    /**
     * Get WhatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhatId()
    {
        return isset($this->WhatId) ? $this->WhatId : null;
    }
    /**
     * Set WhatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $whatId
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setWhatId($whatId = null)
    {
        // validation for constraint: string
        if (!is_null($whatId) && !is_string($whatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whatId, true), gettype($whatId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($whatId) && mb_strlen($whatId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($whatId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($whatId) && !preg_match('/[a-zA-Z0-9]{18}/', $whatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($whatId, true)), __LINE__);
        }
        if (is_null($whatId) || (is_array($whatId) && empty($whatId))) {
            unset($this->WhatId);
        } else {
            $this->WhatId = $whatId;
        }
        return $this;
    }
    /**
     * Get Who value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getWho()
    {
        return isset($this->Who) ? $this->Who : null;
    }
    /**
     * Set Who value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $who
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setWho(\NexusDigital/MiratelForce\StructType\SObject $who = null)
    {
        if (is_null($who) || (is_array($who) && empty($who))) {
            unset($this->Who);
        } else {
            $this->Who = $who;
        }
        return $this;
    }
    /**
     * Get WhoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhoId()
    {
        return isset($this->WhoId) ? $this->WhoId : null;
    }
    /**
     * Set WhoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $whoId
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setWhoId($whoId = null)
    {
        // validation for constraint: string
        if (!is_null($whoId) && !is_string($whoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whoId, true), gettype($whoId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($whoId) && mb_strlen($whoId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($whoId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($whoId) && !preg_match('/[a-zA-Z0-9]{18}/', $whoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($whoId, true)), __LINE__);
        }
        if (is_null($whoId) || (is_array($whoId) && empty($whoId))) {
            unset($this->WhoId);
        } else {
            $this->WhoId = $whoId;
        }
        return $this;
    }
    /**
     * Get Winner_List_Lottery__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWinner_List_Lottery__c()
    {
        return isset($this->Winner_List_Lottery__c) ? $this->Winner_List_Lottery__c : null;
    }
    /**
     * Set Winner_List_Lottery__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $winner_List_Lottery__c
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public function setWinner_List_Lottery__c($winner_List_Lottery__c = null)
    {
        // validation for constraint: string
        if (!is_null($winner_List_Lottery__c) && !is_string($winner_List_Lottery__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($winner_List_Lottery__c, true), gettype($winner_List_Lottery__c)), __LINE__);
        }
        if (is_null($winner_List_Lottery__c) || (is_array($winner_List_Lottery__c) && empty($winner_List_Lottery__c))) {
            unset($this->Winner_List_Lottery__c);
        } else {
            $this->Winner_List_Lottery__c = $winner_List_Lottery__c;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\OpenActivity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
