<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OauthToken StructType
 * @subpackage Structs
 */
class OauthToken extends SObject
{
    /**
     * The AccessToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessToken;
    /**
     * The AppMenuItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public $AppMenuItem;
    /**
     * The AppMenuItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AppMenuItemId;
    /**
     * The AppName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AppName;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DeleteToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeleteToken;
    /**
     * The LastUsedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUsedDate;
    /**
     * The RequestToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestToken;
    /**
     * The UseCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UseCount;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for OauthToken
     * @uses OauthToken::setAccessToken()
     * @uses OauthToken::setAppMenuItem()
     * @uses OauthToken::setAppMenuItemId()
     * @uses OauthToken::setAppName()
     * @uses OauthToken::setCreatedDate()
     * @uses OauthToken::setDeleteToken()
     * @uses OauthToken::setLastUsedDate()
     * @uses OauthToken::setRequestToken()
     * @uses OauthToken::setUseCount()
     * @uses OauthToken::setUser()
     * @uses OauthToken::setUserId()
     * @param string $accessToken
     * @param \NexusDigital/MiratelForce\StructType\AppMenuItem $appMenuItem
     * @param string $appMenuItemId
     * @param string $appName
     * @param string $createdDate
     * @param string $deleteToken
     * @param string $lastUsedDate
     * @param string $requestToken
     * @param int $useCount
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     */
    public function __construct($accessToken = null, \NexusDigital/MiratelForce\StructType\AppMenuItem $appMenuItem = null, $appMenuItemId = null, $appName = null, $createdDate = null, $deleteToken = null, $lastUsedDate = null, $requestToken = null, $useCount = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null)
    {
        $this
            ->setAccessToken($accessToken)
            ->setAppMenuItem($appMenuItem)
            ->setAppMenuItemId($appMenuItemId)
            ->setAppName($appName)
            ->setCreatedDate($createdDate)
            ->setDeleteToken($deleteToken)
            ->setLastUsedDate($lastUsedDate)
            ->setRequestToken($requestToken)
            ->setUseCount($useCount)
            ->setUser($user)
            ->setUserId($userId);
    }
    /**
     * Get AccessToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessToken()
    {
        return isset($this->AccessToken) ? $this->AccessToken : null;
    }
    /**
     * Set AccessToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessToken
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setAccessToken($accessToken = null)
    {
        // validation for constraint: string
        if (!is_null($accessToken) && !is_string($accessToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessToken, true), gettype($accessToken)), __LINE__);
        }
        if (is_null($accessToken) || (is_array($accessToken) && empty($accessToken))) {
            unset($this->AccessToken);
        } else {
            $this->AccessToken = $accessToken;
        }
        return $this;
    }
    /**
     * Get AppMenuItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem|null
     */
    public function getAppMenuItem()
    {
        return isset($this->AppMenuItem) ? $this->AppMenuItem : null;
    }
    /**
     * Set AppMenuItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\AppMenuItem $appMenuItem
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setAppMenuItem(\NexusDigital/MiratelForce\StructType\AppMenuItem $appMenuItem = null)
    {
        if (is_null($appMenuItem) || (is_array($appMenuItem) && empty($appMenuItem))) {
            unset($this->AppMenuItem);
        } else {
            $this->AppMenuItem = $appMenuItem;
        }
        return $this;
    }
    /**
     * Get AppMenuItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppMenuItemId()
    {
        return isset($this->AppMenuItemId) ? $this->AppMenuItemId : null;
    }
    /**
     * Set AppMenuItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appMenuItemId
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setAppMenuItemId($appMenuItemId = null)
    {
        // validation for constraint: string
        if (!is_null($appMenuItemId) && !is_string($appMenuItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appMenuItemId, true), gettype($appMenuItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($appMenuItemId) && mb_strlen($appMenuItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($appMenuItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($appMenuItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $appMenuItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($appMenuItemId, true)), __LINE__);
        }
        if (is_null($appMenuItemId) || (is_array($appMenuItemId) && empty($appMenuItemId))) {
            unset($this->AppMenuItemId);
        } else {
            $this->AppMenuItemId = $appMenuItemId;
        }
        return $this;
    }
    /**
     * Get AppName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppName()
    {
        return isset($this->AppName) ? $this->AppName : null;
    }
    /**
     * Set AppName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appName
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setAppName($appName = null)
    {
        // validation for constraint: string
        if (!is_null($appName) && !is_string($appName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appName, true), gettype($appName)), __LINE__);
        }
        if (is_null($appName) || (is_array($appName) && empty($appName))) {
            unset($this->AppName);
        } else {
            $this->AppName = $appName;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DeleteToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeleteToken()
    {
        return isset($this->DeleteToken) ? $this->DeleteToken : null;
    }
    /**
     * Set DeleteToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deleteToken
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setDeleteToken($deleteToken = null)
    {
        // validation for constraint: string
        if (!is_null($deleteToken) && !is_string($deleteToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deleteToken, true), gettype($deleteToken)), __LINE__);
        }
        if (is_null($deleteToken) || (is_array($deleteToken) && empty($deleteToken))) {
            unset($this->DeleteToken);
        } else {
            $this->DeleteToken = $deleteToken;
        }
        return $this;
    }
    /**
     * Get LastUsedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUsedDate()
    {
        return isset($this->LastUsedDate) ? $this->LastUsedDate : null;
    }
    /**
     * Set LastUsedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUsedDate
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setLastUsedDate($lastUsedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUsedDate) && !is_string($lastUsedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUsedDate, true), gettype($lastUsedDate)), __LINE__);
        }
        if (is_null($lastUsedDate) || (is_array($lastUsedDate) && empty($lastUsedDate))) {
            unset($this->LastUsedDate);
        } else {
            $this->LastUsedDate = $lastUsedDate;
        }
        return $this;
    }
    /**
     * Get RequestToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestToken()
    {
        return isset($this->RequestToken) ? $this->RequestToken : null;
    }
    /**
     * Set RequestToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestToken
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setRequestToken($requestToken = null)
    {
        // validation for constraint: string
        if (!is_null($requestToken) && !is_string($requestToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestToken, true), gettype($requestToken)), __LINE__);
        }
        if (is_null($requestToken) || (is_array($requestToken) && empty($requestToken))) {
            unset($this->RequestToken);
        } else {
            $this->RequestToken = $requestToken;
        }
        return $this;
    }
    /**
     * Get UseCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUseCount()
    {
        return isset($this->UseCount) ? $this->UseCount : null;
    }
    /**
     * Set UseCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $useCount
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setUseCount($useCount = null)
    {
        // validation for constraint: int
        if (!is_null($useCount) && !(is_int($useCount) || ctype_digit($useCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($useCount, true), gettype($useCount)), __LINE__);
        }
        if (is_null($useCount) || (is_array($useCount) && empty($useCount))) {
            unset($this->UseCount);
        } else {
            $this->UseCount = $useCount;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\OauthToken
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
