<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Network StructType
 * @subpackage Structs
 */
class Network extends SObject
{
    /**
     * The AllowedExtensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllowedExtensions;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The CaseCommentEmailTemplateId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CaseCommentEmailTemplateId;
    /**
     * The ChangePasswordEmailTemplateId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ChangePasswordEmailTemplateId;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CustomBrands
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CustomBrands;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EmailFooterLogoId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $EmailFooterLogoId;
    /**
     * The EmailFooterText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailFooterText;
    /**
     * The EmailSenderAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailSenderAddress;
    /**
     * The EmailSenderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailSenderName;
    /**
     * The FirstActivationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstActivationDate;
    /**
     * The ForgotPasswordEmailTemplateId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ForgotPasswordEmailTemplateId;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LockoutEmailTemplateId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LockoutEmailTemplateId;
    /**
     * The MaxFileSizeKb
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxFileSizeKb;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NetworkActivityAudits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkActivityAudits;
    /**
     * The NetworkBadgeDefinitions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkBadgeDefinitions;
    /**
     * The NetworkBadges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkBadges;
    /**
     * The NetworkCollaborationGroups
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkCollaborationGroups;
    /**
     * The NetworkEntitySubscriptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkEntitySubscriptions;
    /**
     * The NetworkMembers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkMembers;
    /**
     * The NetworkModerations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkModerations;
    /**
     * The NetworkRecommendations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkRecommendations;
    /**
     * The NetworkThanks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkThanks;
    /**
     * The NetworkUserHistoryRecentToNetwork
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NetworkUserHistoryRecentToNetwork;
    /**
     * The NewSenderAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewSenderAddress;
    /**
     * The OptionsAllowInternalUserLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsAllowInternalUserLogin;
    /**
     * The OptionsAllowMembersToFlag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsAllowMembersToFlag;
    /**
     * The OptionsCWBannerState
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsCWBannerState;
    /**
     * The OptionsDirectMessagesEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsDirectMessagesEnabled;
    /**
     * The OptionsDisableWorkspaceInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsDisableWorkspaceInfo;
    /**
     * The OptionsEinsteinAnswersEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsEinsteinAnswersEnabled;
    /**
     * The OptionsEinsteinAnswersKAEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsEinsteinAnswersKAEnabled;
    /**
     * The OptionsEinsteinAnswersQAEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsEinsteinAnswersQAEnabled;
    /**
     * The OptionsEinsteinAnswersSnippetEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsEinsteinAnswersSnippetEnabled;
    /**
     * The OptionsEnableTalkingAboutStats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsEnableTalkingAboutStats;
    /**
     * The OptionsEnableTopicAssignmentRules
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsEnableTopicAssignmentRules;
    /**
     * The OptionsGatherCustomerSentimentData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsGatherCustomerSentimentData;
    /**
     * The OptionsGuestChatterEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsGuestChatterEnabled;
    /**
     * The OptionsGuestFileAccessEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsGuestFileAccessEnabled;
    /**
     * The OptionsInvitationsEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsInvitationsEnabled;
    /**
     * The OptionsKnowledgeableEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsKnowledgeableEnabled;
    /**
     * The OptionsMemberVisibility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsMemberVisibility;
    /**
     * The OptionsMobileImageOptimizationEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsMobileImageOptimizationEnabled;
    /**
     * The OptionsNetworkSentimentAnalysis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsNetworkSentimentAnalysis;
    /**
     * The OptionsNicknameDisplayEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsNicknameDisplayEnabled;
    /**
     * The OptionsPrivateMessagesEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsPrivateMessagesEnabled;
    /**
     * The OptionsRecognitionBadgingEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsRecognitionBadgingEnabled;
    /**
     * The OptionsReputationEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsReputationEnabled;
    /**
     * The OptionsReputationRecordConversationsDisabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsReputationRecordConversationsDisabled;
    /**
     * The OptionsSelfRegistrationEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsSelfRegistrationEnabled;
    /**
     * The OptionsSendWelcomeEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsSendWelcomeEmail;
    /**
     * The OptionsShowAllNetworkSettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsShowAllNetworkSettings;
    /**
     * The OptionsSiteAsContainerEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsSiteAsContainerEnabled;
    /**
     * The OptionsThreadedDiscussionsEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsThreadedDiscussionsEnabled;
    /**
     * The OptionsTopicSuggestionsEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsTopicSuggestionsEnabled;
    /**
     * The OptionsUpDownVoteEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsUpDownVoteEnabled;
    /**
     * The SelfRegProfileId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $SelfRegProfileId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UrlPathPrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlPathPrefix;
    /**
     * The VerificationEmailTemplateId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $VerificationEmailTemplateId;
    /**
     * The WelcomeEmailTemplateId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $WelcomeEmailTemplateId;
    /**
     * Constructor method for Network
     * @uses Network::setAllowedExtensions()
     * @uses Network::setAttachedContentDocuments()
     * @uses Network::setAttachedContentNotes()
     * @uses Network::setCaseCommentEmailTemplateId()
     * @uses Network::setChangePasswordEmailTemplateId()
     * @uses Network::setCombinedAttachments()
     * @uses Network::setContentDocumentLinks()
     * @uses Network::setCreatedBy()
     * @uses Network::setCreatedById()
     * @uses Network::setCreatedDate()
     * @uses Network::setCustomBrands()
     * @uses Network::setDescription()
     * @uses Network::setEmailFooterLogoId()
     * @uses Network::setEmailFooterText()
     * @uses Network::setEmailSenderAddress()
     * @uses Network::setEmailSenderName()
     * @uses Network::setFirstActivationDate()
     * @uses Network::setForgotPasswordEmailTemplateId()
     * @uses Network::setLastModifiedBy()
     * @uses Network::setLastModifiedById()
     * @uses Network::setLastModifiedDate()
     * @uses Network::setLockoutEmailTemplateId()
     * @uses Network::setMaxFileSizeKb()
     * @uses Network::setName()
     * @uses Network::setNetworkActivityAudits()
     * @uses Network::setNetworkBadgeDefinitions()
     * @uses Network::setNetworkBadges()
     * @uses Network::setNetworkCollaborationGroups()
     * @uses Network::setNetworkEntitySubscriptions()
     * @uses Network::setNetworkMembers()
     * @uses Network::setNetworkModerations()
     * @uses Network::setNetworkRecommendations()
     * @uses Network::setNetworkThanks()
     * @uses Network::setNetworkUserHistoryRecentToNetwork()
     * @uses Network::setNewSenderAddress()
     * @uses Network::setOptionsAllowInternalUserLogin()
     * @uses Network::setOptionsAllowMembersToFlag()
     * @uses Network::setOptionsCWBannerState()
     * @uses Network::setOptionsDirectMessagesEnabled()
     * @uses Network::setOptionsDisableWorkspaceInfo()
     * @uses Network::setOptionsEinsteinAnswersEnabled()
     * @uses Network::setOptionsEinsteinAnswersKAEnabled()
     * @uses Network::setOptionsEinsteinAnswersQAEnabled()
     * @uses Network::setOptionsEinsteinAnswersSnippetEnabled()
     * @uses Network::setOptionsEnableTalkingAboutStats()
     * @uses Network::setOptionsEnableTopicAssignmentRules()
     * @uses Network::setOptionsGatherCustomerSentimentData()
     * @uses Network::setOptionsGuestChatterEnabled()
     * @uses Network::setOptionsGuestFileAccessEnabled()
     * @uses Network::setOptionsInvitationsEnabled()
     * @uses Network::setOptionsKnowledgeableEnabled()
     * @uses Network::setOptionsMemberVisibility()
     * @uses Network::setOptionsMobileImageOptimizationEnabled()
     * @uses Network::setOptionsNetworkSentimentAnalysis()
     * @uses Network::setOptionsNicknameDisplayEnabled()
     * @uses Network::setOptionsPrivateMessagesEnabled()
     * @uses Network::setOptionsRecognitionBadgingEnabled()
     * @uses Network::setOptionsReputationEnabled()
     * @uses Network::setOptionsReputationRecordConversationsDisabled()
     * @uses Network::setOptionsSelfRegistrationEnabled()
     * @uses Network::setOptionsSendWelcomeEmail()
     * @uses Network::setOptionsShowAllNetworkSettings()
     * @uses Network::setOptionsSiteAsContainerEnabled()
     * @uses Network::setOptionsThreadedDiscussionsEnabled()
     * @uses Network::setOptionsTopicSuggestionsEnabled()
     * @uses Network::setOptionsUpDownVoteEnabled()
     * @uses Network::setSelfRegProfileId()
     * @uses Network::setStatus()
     * @uses Network::setSystemModstamp()
     * @uses Network::setUrlPathPrefix()
     * @uses Network::setVerificationEmailTemplateId()
     * @uses Network::setWelcomeEmailTemplateId()
     * @param string $allowedExtensions
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param string $caseCommentEmailTemplateId
     * @param string $changePasswordEmailTemplateId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $customBrands
     * @param string $description
     * @param string $emailFooterLogoId
     * @param string $emailFooterText
     * @param string $emailSenderAddress
     * @param string $emailSenderName
     * @param string $firstActivationDate
     * @param string $forgotPasswordEmailTemplateId
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lockoutEmailTemplateId
     * @param int $maxFileSizeKb
     * @param string $name
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkActivityAudits
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkBadgeDefinitions
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkBadges
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkCollaborationGroups
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkEntitySubscriptions
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkMembers
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkModerations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkRecommendations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkThanks
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToNetwork
     * @param string $newSenderAddress
     * @param bool $optionsAllowInternalUserLogin
     * @param bool $optionsAllowMembersToFlag
     * @param bool $optionsCWBannerState
     * @param bool $optionsDirectMessagesEnabled
     * @param bool $optionsDisableWorkspaceInfo
     * @param bool $optionsEinsteinAnswersEnabled
     * @param bool $optionsEinsteinAnswersKAEnabled
     * @param bool $optionsEinsteinAnswersQAEnabled
     * @param bool $optionsEinsteinAnswersSnippetEnabled
     * @param bool $optionsEnableTalkingAboutStats
     * @param bool $optionsEnableTopicAssignmentRules
     * @param bool $optionsGatherCustomerSentimentData
     * @param bool $optionsGuestChatterEnabled
     * @param bool $optionsGuestFileAccessEnabled
     * @param bool $optionsInvitationsEnabled
     * @param bool $optionsKnowledgeableEnabled
     * @param bool $optionsMemberVisibility
     * @param bool $optionsMobileImageOptimizationEnabled
     * @param bool $optionsNetworkSentimentAnalysis
     * @param bool $optionsNicknameDisplayEnabled
     * @param bool $optionsPrivateMessagesEnabled
     * @param bool $optionsRecognitionBadgingEnabled
     * @param bool $optionsReputationEnabled
     * @param bool $optionsReputationRecordConversationsDisabled
     * @param bool $optionsSelfRegistrationEnabled
     * @param bool $optionsSendWelcomeEmail
     * @param bool $optionsShowAllNetworkSettings
     * @param bool $optionsSiteAsContainerEnabled
     * @param bool $optionsThreadedDiscussionsEnabled
     * @param bool $optionsTopicSuggestionsEnabled
     * @param bool $optionsUpDownVoteEnabled
     * @param string $selfRegProfileId
     * @param string $status
     * @param string $systemModstamp
     * @param string $urlPathPrefix
     * @param string $verificationEmailTemplateId
     * @param string $welcomeEmailTemplateId
     */
    public function __construct($allowedExtensions = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, $caseCommentEmailTemplateId = null, $changePasswordEmailTemplateId = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $customBrands = null, $description = null, $emailFooterLogoId = null, $emailFooterText = null, $emailSenderAddress = null, $emailSenderName = null, $firstActivationDate = null, $forgotPasswordEmailTemplateId = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lockoutEmailTemplateId = null, $maxFileSizeKb = null, $name = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkActivityAudits = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkBadgeDefinitions = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkBadges = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkCollaborationGroups = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkEntitySubscriptions = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkMembers = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkModerations = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkRecommendations = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkThanks = null, \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToNetwork = null, $newSenderAddress = null, $optionsAllowInternalUserLogin = null, $optionsAllowMembersToFlag = null, $optionsCWBannerState = null, $optionsDirectMessagesEnabled = null, $optionsDisableWorkspaceInfo = null, $optionsEinsteinAnswersEnabled = null, $optionsEinsteinAnswersKAEnabled = null, $optionsEinsteinAnswersQAEnabled = null, $optionsEinsteinAnswersSnippetEnabled = null, $optionsEnableTalkingAboutStats = null, $optionsEnableTopicAssignmentRules = null, $optionsGatherCustomerSentimentData = null, $optionsGuestChatterEnabled = null, $optionsGuestFileAccessEnabled = null, $optionsInvitationsEnabled = null, $optionsKnowledgeableEnabled = null, $optionsMemberVisibility = null, $optionsMobileImageOptimizationEnabled = null, $optionsNetworkSentimentAnalysis = null, $optionsNicknameDisplayEnabled = null, $optionsPrivateMessagesEnabled = null, $optionsRecognitionBadgingEnabled = null, $optionsReputationEnabled = null, $optionsReputationRecordConversationsDisabled = null, $optionsSelfRegistrationEnabled = null, $optionsSendWelcomeEmail = null, $optionsShowAllNetworkSettings = null, $optionsSiteAsContainerEnabled = null, $optionsThreadedDiscussionsEnabled = null, $optionsTopicSuggestionsEnabled = null, $optionsUpDownVoteEnabled = null, $selfRegProfileId = null, $status = null, $systemModstamp = null, $urlPathPrefix = null, $verificationEmailTemplateId = null, $welcomeEmailTemplateId = null)
    {
        $this
            ->setAllowedExtensions($allowedExtensions)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setCaseCommentEmailTemplateId($caseCommentEmailTemplateId)
            ->setChangePasswordEmailTemplateId($changePasswordEmailTemplateId)
            ->setCombinedAttachments($combinedAttachments)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCustomBrands($customBrands)
            ->setDescription($description)
            ->setEmailFooterLogoId($emailFooterLogoId)
            ->setEmailFooterText($emailFooterText)
            ->setEmailSenderAddress($emailSenderAddress)
            ->setEmailSenderName($emailSenderName)
            ->setFirstActivationDate($firstActivationDate)
            ->setForgotPasswordEmailTemplateId($forgotPasswordEmailTemplateId)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLockoutEmailTemplateId($lockoutEmailTemplateId)
            ->setMaxFileSizeKb($maxFileSizeKb)
            ->setName($name)
            ->setNetworkActivityAudits($networkActivityAudits)
            ->setNetworkBadgeDefinitions($networkBadgeDefinitions)
            ->setNetworkBadges($networkBadges)
            ->setNetworkCollaborationGroups($networkCollaborationGroups)
            ->setNetworkEntitySubscriptions($networkEntitySubscriptions)
            ->setNetworkMembers($networkMembers)
            ->setNetworkModerations($networkModerations)
            ->setNetworkRecommendations($networkRecommendations)
            ->setNetworkThanks($networkThanks)
            ->setNetworkUserHistoryRecentToNetwork($networkUserHistoryRecentToNetwork)
            ->setNewSenderAddress($newSenderAddress)
            ->setOptionsAllowInternalUserLogin($optionsAllowInternalUserLogin)
            ->setOptionsAllowMembersToFlag($optionsAllowMembersToFlag)
            ->setOptionsCWBannerState($optionsCWBannerState)
            ->setOptionsDirectMessagesEnabled($optionsDirectMessagesEnabled)
            ->setOptionsDisableWorkspaceInfo($optionsDisableWorkspaceInfo)
            ->setOptionsEinsteinAnswersEnabled($optionsEinsteinAnswersEnabled)
            ->setOptionsEinsteinAnswersKAEnabled($optionsEinsteinAnswersKAEnabled)
            ->setOptionsEinsteinAnswersQAEnabled($optionsEinsteinAnswersQAEnabled)
            ->setOptionsEinsteinAnswersSnippetEnabled($optionsEinsteinAnswersSnippetEnabled)
            ->setOptionsEnableTalkingAboutStats($optionsEnableTalkingAboutStats)
            ->setOptionsEnableTopicAssignmentRules($optionsEnableTopicAssignmentRules)
            ->setOptionsGatherCustomerSentimentData($optionsGatherCustomerSentimentData)
            ->setOptionsGuestChatterEnabled($optionsGuestChatterEnabled)
            ->setOptionsGuestFileAccessEnabled($optionsGuestFileAccessEnabled)
            ->setOptionsInvitationsEnabled($optionsInvitationsEnabled)
            ->setOptionsKnowledgeableEnabled($optionsKnowledgeableEnabled)
            ->setOptionsMemberVisibility($optionsMemberVisibility)
            ->setOptionsMobileImageOptimizationEnabled($optionsMobileImageOptimizationEnabled)
            ->setOptionsNetworkSentimentAnalysis($optionsNetworkSentimentAnalysis)
            ->setOptionsNicknameDisplayEnabled($optionsNicknameDisplayEnabled)
            ->setOptionsPrivateMessagesEnabled($optionsPrivateMessagesEnabled)
            ->setOptionsRecognitionBadgingEnabled($optionsRecognitionBadgingEnabled)
            ->setOptionsReputationEnabled($optionsReputationEnabled)
            ->setOptionsReputationRecordConversationsDisabled($optionsReputationRecordConversationsDisabled)
            ->setOptionsSelfRegistrationEnabled($optionsSelfRegistrationEnabled)
            ->setOptionsSendWelcomeEmail($optionsSendWelcomeEmail)
            ->setOptionsShowAllNetworkSettings($optionsShowAllNetworkSettings)
            ->setOptionsSiteAsContainerEnabled($optionsSiteAsContainerEnabled)
            ->setOptionsThreadedDiscussionsEnabled($optionsThreadedDiscussionsEnabled)
            ->setOptionsTopicSuggestionsEnabled($optionsTopicSuggestionsEnabled)
            ->setOptionsUpDownVoteEnabled($optionsUpDownVoteEnabled)
            ->setSelfRegProfileId($selfRegProfileId)
            ->setStatus($status)
            ->setSystemModstamp($systemModstamp)
            ->setUrlPathPrefix($urlPathPrefix)
            ->setVerificationEmailTemplateId($verificationEmailTemplateId)
            ->setWelcomeEmailTemplateId($welcomeEmailTemplateId);
    }
    /**
     * Get AllowedExtensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllowedExtensions()
    {
        return isset($this->AllowedExtensions) ? $this->AllowedExtensions : null;
    }
    /**
     * Set AllowedExtensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allowedExtensions
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setAllowedExtensions($allowedExtensions = null)
    {
        // validation for constraint: string
        if (!is_null($allowedExtensions) && !is_string($allowedExtensions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowedExtensions, true), gettype($allowedExtensions)), __LINE__);
        }
        if (is_null($allowedExtensions) || (is_array($allowedExtensions) && empty($allowedExtensions))) {
            unset($this->AllowedExtensions);
        } else {
            $this->AllowedExtensions = $allowedExtensions;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get CaseCommentEmailTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCaseCommentEmailTemplateId()
    {
        return isset($this->CaseCommentEmailTemplateId) ? $this->CaseCommentEmailTemplateId : null;
    }
    /**
     * Set CaseCommentEmailTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $caseCommentEmailTemplateId
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setCaseCommentEmailTemplateId($caseCommentEmailTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($caseCommentEmailTemplateId) && !is_string($caseCommentEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caseCommentEmailTemplateId, true), gettype($caseCommentEmailTemplateId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($caseCommentEmailTemplateId) && mb_strlen($caseCommentEmailTemplateId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($caseCommentEmailTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($caseCommentEmailTemplateId) && !preg_match('/[a-zA-Z0-9]{18}/', $caseCommentEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($caseCommentEmailTemplateId, true)), __LINE__);
        }
        if (is_null($caseCommentEmailTemplateId) || (is_array($caseCommentEmailTemplateId) && empty($caseCommentEmailTemplateId))) {
            unset($this->CaseCommentEmailTemplateId);
        } else {
            $this->CaseCommentEmailTemplateId = $caseCommentEmailTemplateId;
        }
        return $this;
    }
    /**
     * Get ChangePasswordEmailTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChangePasswordEmailTemplateId()
    {
        return isset($this->ChangePasswordEmailTemplateId) ? $this->ChangePasswordEmailTemplateId : null;
    }
    /**
     * Set ChangePasswordEmailTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $changePasswordEmailTemplateId
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setChangePasswordEmailTemplateId($changePasswordEmailTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($changePasswordEmailTemplateId) && !is_string($changePasswordEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changePasswordEmailTemplateId, true), gettype($changePasswordEmailTemplateId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($changePasswordEmailTemplateId) && mb_strlen($changePasswordEmailTemplateId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($changePasswordEmailTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($changePasswordEmailTemplateId) && !preg_match('/[a-zA-Z0-9]{18}/', $changePasswordEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($changePasswordEmailTemplateId, true)), __LINE__);
        }
        if (is_null($changePasswordEmailTemplateId) || (is_array($changePasswordEmailTemplateId) && empty($changePasswordEmailTemplateId))) {
            unset($this->ChangePasswordEmailTemplateId);
        } else {
            $this->ChangePasswordEmailTemplateId = $changePasswordEmailTemplateId;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CustomBrands value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCustomBrands()
    {
        return isset($this->CustomBrands) ? $this->CustomBrands : null;
    }
    /**
     * Set CustomBrands value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $customBrands
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setCustomBrands(\NexusDigital/MiratelForce\StructType\QueryResult $customBrands = null)
    {
        if (is_null($customBrands) || (is_array($customBrands) && empty($customBrands))) {
            unset($this->CustomBrands);
        } else {
            $this->CustomBrands = $customBrands;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EmailFooterLogoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailFooterLogoId()
    {
        return isset($this->EmailFooterLogoId) ? $this->EmailFooterLogoId : null;
    }
    /**
     * Set EmailFooterLogoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailFooterLogoId
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setEmailFooterLogoId($emailFooterLogoId = null)
    {
        // validation for constraint: string
        if (!is_null($emailFooterLogoId) && !is_string($emailFooterLogoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailFooterLogoId, true), gettype($emailFooterLogoId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($emailFooterLogoId) && mb_strlen($emailFooterLogoId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($emailFooterLogoId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($emailFooterLogoId) && !preg_match('/[a-zA-Z0-9]{18}/', $emailFooterLogoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($emailFooterLogoId, true)), __LINE__);
        }
        if (is_null($emailFooterLogoId) || (is_array($emailFooterLogoId) && empty($emailFooterLogoId))) {
            unset($this->EmailFooterLogoId);
        } else {
            $this->EmailFooterLogoId = $emailFooterLogoId;
        }
        return $this;
    }
    /**
     * Get EmailFooterText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailFooterText()
    {
        return isset($this->EmailFooterText) ? $this->EmailFooterText : null;
    }
    /**
     * Set EmailFooterText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailFooterText
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setEmailFooterText($emailFooterText = null)
    {
        // validation for constraint: string
        if (!is_null($emailFooterText) && !is_string($emailFooterText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailFooterText, true), gettype($emailFooterText)), __LINE__);
        }
        if (is_null($emailFooterText) || (is_array($emailFooterText) && empty($emailFooterText))) {
            unset($this->EmailFooterText);
        } else {
            $this->EmailFooterText = $emailFooterText;
        }
        return $this;
    }
    /**
     * Get EmailSenderAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailSenderAddress()
    {
        return isset($this->EmailSenderAddress) ? $this->EmailSenderAddress : null;
    }
    /**
     * Set EmailSenderAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailSenderAddress
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setEmailSenderAddress($emailSenderAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailSenderAddress) && !is_string($emailSenderAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSenderAddress, true), gettype($emailSenderAddress)), __LINE__);
        }
        if (is_null($emailSenderAddress) || (is_array($emailSenderAddress) && empty($emailSenderAddress))) {
            unset($this->EmailSenderAddress);
        } else {
            $this->EmailSenderAddress = $emailSenderAddress;
        }
        return $this;
    }
    /**
     * Get EmailSenderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailSenderName()
    {
        return isset($this->EmailSenderName) ? $this->EmailSenderName : null;
    }
    /**
     * Set EmailSenderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailSenderName
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setEmailSenderName($emailSenderName = null)
    {
        // validation for constraint: string
        if (!is_null($emailSenderName) && !is_string($emailSenderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSenderName, true), gettype($emailSenderName)), __LINE__);
        }
        if (is_null($emailSenderName) || (is_array($emailSenderName) && empty($emailSenderName))) {
            unset($this->EmailSenderName);
        } else {
            $this->EmailSenderName = $emailSenderName;
        }
        return $this;
    }
    /**
     * Get FirstActivationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstActivationDate()
    {
        return isset($this->FirstActivationDate) ? $this->FirstActivationDate : null;
    }
    /**
     * Set FirstActivationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstActivationDate
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setFirstActivationDate($firstActivationDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstActivationDate) && !is_string($firstActivationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstActivationDate, true), gettype($firstActivationDate)), __LINE__);
        }
        if (is_null($firstActivationDate) || (is_array($firstActivationDate) && empty($firstActivationDate))) {
            unset($this->FirstActivationDate);
        } else {
            $this->FirstActivationDate = $firstActivationDate;
        }
        return $this;
    }
    /**
     * Get ForgotPasswordEmailTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForgotPasswordEmailTemplateId()
    {
        return isset($this->ForgotPasswordEmailTemplateId) ? $this->ForgotPasswordEmailTemplateId : null;
    }
    /**
     * Set ForgotPasswordEmailTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forgotPasswordEmailTemplateId
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setForgotPasswordEmailTemplateId($forgotPasswordEmailTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($forgotPasswordEmailTemplateId) && !is_string($forgotPasswordEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forgotPasswordEmailTemplateId, true), gettype($forgotPasswordEmailTemplateId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($forgotPasswordEmailTemplateId) && mb_strlen($forgotPasswordEmailTemplateId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($forgotPasswordEmailTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($forgotPasswordEmailTemplateId) && !preg_match('/[a-zA-Z0-9]{18}/', $forgotPasswordEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($forgotPasswordEmailTemplateId, true)), __LINE__);
        }
        if (is_null($forgotPasswordEmailTemplateId) || (is_array($forgotPasswordEmailTemplateId) && empty($forgotPasswordEmailTemplateId))) {
            unset($this->ForgotPasswordEmailTemplateId);
        } else {
            $this->ForgotPasswordEmailTemplateId = $forgotPasswordEmailTemplateId;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LockoutEmailTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockoutEmailTemplateId()
    {
        return isset($this->LockoutEmailTemplateId) ? $this->LockoutEmailTemplateId : null;
    }
    /**
     * Set LockoutEmailTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockoutEmailTemplateId
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setLockoutEmailTemplateId($lockoutEmailTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($lockoutEmailTemplateId) && !is_string($lockoutEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockoutEmailTemplateId, true), gettype($lockoutEmailTemplateId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lockoutEmailTemplateId) && mb_strlen($lockoutEmailTemplateId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lockoutEmailTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lockoutEmailTemplateId) && !preg_match('/[a-zA-Z0-9]{18}/', $lockoutEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lockoutEmailTemplateId, true)), __LINE__);
        }
        if (is_null($lockoutEmailTemplateId) || (is_array($lockoutEmailTemplateId) && empty($lockoutEmailTemplateId))) {
            unset($this->LockoutEmailTemplateId);
        } else {
            $this->LockoutEmailTemplateId = $lockoutEmailTemplateId;
        }
        return $this;
    }
    /**
     * Get MaxFileSizeKb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxFileSizeKb()
    {
        return isset($this->MaxFileSizeKb) ? $this->MaxFileSizeKb : null;
    }
    /**
     * Set MaxFileSizeKb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxFileSizeKb
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setMaxFileSizeKb($maxFileSizeKb = null)
    {
        // validation for constraint: int
        if (!is_null($maxFileSizeKb) && !(is_int($maxFileSizeKb) || ctype_digit($maxFileSizeKb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxFileSizeKb, true), gettype($maxFileSizeKb)), __LINE__);
        }
        if (is_null($maxFileSizeKb) || (is_array($maxFileSizeKb) && empty($maxFileSizeKb))) {
            unset($this->MaxFileSizeKb);
        } else {
            $this->MaxFileSizeKb = $maxFileSizeKb;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NetworkActivityAudits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkActivityAudits()
    {
        return isset($this->NetworkActivityAudits) ? $this->NetworkActivityAudits : null;
    }
    /**
     * Set NetworkActivityAudits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkActivityAudits
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNetworkActivityAudits(\NexusDigital/MiratelForce\StructType\QueryResult $networkActivityAudits = null)
    {
        if (is_null($networkActivityAudits) || (is_array($networkActivityAudits) && empty($networkActivityAudits))) {
            unset($this->NetworkActivityAudits);
        } else {
            $this->NetworkActivityAudits = $networkActivityAudits;
        }
        return $this;
    }
    /**
     * Get NetworkBadgeDefinitions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkBadgeDefinitions()
    {
        return isset($this->NetworkBadgeDefinitions) ? $this->NetworkBadgeDefinitions : null;
    }
    /**
     * Set NetworkBadgeDefinitions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkBadgeDefinitions
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNetworkBadgeDefinitions(\NexusDigital/MiratelForce\StructType\QueryResult $networkBadgeDefinitions = null)
    {
        if (is_null($networkBadgeDefinitions) || (is_array($networkBadgeDefinitions) && empty($networkBadgeDefinitions))) {
            unset($this->NetworkBadgeDefinitions);
        } else {
            $this->NetworkBadgeDefinitions = $networkBadgeDefinitions;
        }
        return $this;
    }
    /**
     * Get NetworkBadges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkBadges()
    {
        return isset($this->NetworkBadges) ? $this->NetworkBadges : null;
    }
    /**
     * Set NetworkBadges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkBadges
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNetworkBadges(\NexusDigital/MiratelForce\StructType\QueryResult $networkBadges = null)
    {
        if (is_null($networkBadges) || (is_array($networkBadges) && empty($networkBadges))) {
            unset($this->NetworkBadges);
        } else {
            $this->NetworkBadges = $networkBadges;
        }
        return $this;
    }
    /**
     * Get NetworkCollaborationGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkCollaborationGroups()
    {
        return isset($this->NetworkCollaborationGroups) ? $this->NetworkCollaborationGroups : null;
    }
    /**
     * Set NetworkCollaborationGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkCollaborationGroups
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNetworkCollaborationGroups(\NexusDigital/MiratelForce\StructType\QueryResult $networkCollaborationGroups = null)
    {
        if (is_null($networkCollaborationGroups) || (is_array($networkCollaborationGroups) && empty($networkCollaborationGroups))) {
            unset($this->NetworkCollaborationGroups);
        } else {
            $this->NetworkCollaborationGroups = $networkCollaborationGroups;
        }
        return $this;
    }
    /**
     * Get NetworkEntitySubscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkEntitySubscriptions()
    {
        return isset($this->NetworkEntitySubscriptions) ? $this->NetworkEntitySubscriptions : null;
    }
    /**
     * Set NetworkEntitySubscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkEntitySubscriptions
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNetworkEntitySubscriptions(\NexusDigital/MiratelForce\StructType\QueryResult $networkEntitySubscriptions = null)
    {
        if (is_null($networkEntitySubscriptions) || (is_array($networkEntitySubscriptions) && empty($networkEntitySubscriptions))) {
            unset($this->NetworkEntitySubscriptions);
        } else {
            $this->NetworkEntitySubscriptions = $networkEntitySubscriptions;
        }
        return $this;
    }
    /**
     * Get NetworkMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkMembers()
    {
        return isset($this->NetworkMembers) ? $this->NetworkMembers : null;
    }
    /**
     * Set NetworkMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkMembers
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNetworkMembers(\NexusDigital/MiratelForce\StructType\QueryResult $networkMembers = null)
    {
        if (is_null($networkMembers) || (is_array($networkMembers) && empty($networkMembers))) {
            unset($this->NetworkMembers);
        } else {
            $this->NetworkMembers = $networkMembers;
        }
        return $this;
    }
    /**
     * Get NetworkModerations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkModerations()
    {
        return isset($this->NetworkModerations) ? $this->NetworkModerations : null;
    }
    /**
     * Set NetworkModerations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkModerations
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNetworkModerations(\NexusDigital/MiratelForce\StructType\QueryResult $networkModerations = null)
    {
        if (is_null($networkModerations) || (is_array($networkModerations) && empty($networkModerations))) {
            unset($this->NetworkModerations);
        } else {
            $this->NetworkModerations = $networkModerations;
        }
        return $this;
    }
    /**
     * Get NetworkRecommendations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkRecommendations()
    {
        return isset($this->NetworkRecommendations) ? $this->NetworkRecommendations : null;
    }
    /**
     * Set NetworkRecommendations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkRecommendations
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNetworkRecommendations(\NexusDigital/MiratelForce\StructType\QueryResult $networkRecommendations = null)
    {
        if (is_null($networkRecommendations) || (is_array($networkRecommendations) && empty($networkRecommendations))) {
            unset($this->NetworkRecommendations);
        } else {
            $this->NetworkRecommendations = $networkRecommendations;
        }
        return $this;
    }
    /**
     * Get NetworkThanks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkThanks()
    {
        return isset($this->NetworkThanks) ? $this->NetworkThanks : null;
    }
    /**
     * Set NetworkThanks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkThanks
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNetworkThanks(\NexusDigital/MiratelForce\StructType\QueryResult $networkThanks = null)
    {
        if (is_null($networkThanks) || (is_array($networkThanks) && empty($networkThanks))) {
            unset($this->NetworkThanks);
        } else {
            $this->NetworkThanks = $networkThanks;
        }
        return $this;
    }
    /**
     * Get NetworkUserHistoryRecentToNetwork value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNetworkUserHistoryRecentToNetwork()
    {
        return isset($this->NetworkUserHistoryRecentToNetwork) ? $this->NetworkUserHistoryRecentToNetwork : null;
    }
    /**
     * Set NetworkUserHistoryRecentToNetwork value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToNetwork
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNetworkUserHistoryRecentToNetwork(\NexusDigital/MiratelForce\StructType\QueryResult $networkUserHistoryRecentToNetwork = null)
    {
        if (is_null($networkUserHistoryRecentToNetwork) || (is_array($networkUserHistoryRecentToNetwork) && empty($networkUserHistoryRecentToNetwork))) {
            unset($this->NetworkUserHistoryRecentToNetwork);
        } else {
            $this->NetworkUserHistoryRecentToNetwork = $networkUserHistoryRecentToNetwork;
        }
        return $this;
    }
    /**
     * Get NewSenderAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewSenderAddress()
    {
        return isset($this->NewSenderAddress) ? $this->NewSenderAddress : null;
    }
    /**
     * Set NewSenderAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newSenderAddress
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setNewSenderAddress($newSenderAddress = null)
    {
        // validation for constraint: string
        if (!is_null($newSenderAddress) && !is_string($newSenderAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSenderAddress, true), gettype($newSenderAddress)), __LINE__);
        }
        if (is_null($newSenderAddress) || (is_array($newSenderAddress) && empty($newSenderAddress))) {
            unset($this->NewSenderAddress);
        } else {
            $this->NewSenderAddress = $newSenderAddress;
        }
        return $this;
    }
    /**
     * Get OptionsAllowInternalUserLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsAllowInternalUserLogin()
    {
        return isset($this->OptionsAllowInternalUserLogin) ? $this->OptionsAllowInternalUserLogin : null;
    }
    /**
     * Set OptionsAllowInternalUserLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsAllowInternalUserLogin
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsAllowInternalUserLogin($optionsAllowInternalUserLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsAllowInternalUserLogin) && !is_bool($optionsAllowInternalUserLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsAllowInternalUserLogin, true), gettype($optionsAllowInternalUserLogin)), __LINE__);
        }
        if (is_null($optionsAllowInternalUserLogin) || (is_array($optionsAllowInternalUserLogin) && empty($optionsAllowInternalUserLogin))) {
            unset($this->OptionsAllowInternalUserLogin);
        } else {
            $this->OptionsAllowInternalUserLogin = $optionsAllowInternalUserLogin;
        }
        return $this;
    }
    /**
     * Get OptionsAllowMembersToFlag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsAllowMembersToFlag()
    {
        return isset($this->OptionsAllowMembersToFlag) ? $this->OptionsAllowMembersToFlag : null;
    }
    /**
     * Set OptionsAllowMembersToFlag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsAllowMembersToFlag
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsAllowMembersToFlag($optionsAllowMembersToFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsAllowMembersToFlag) && !is_bool($optionsAllowMembersToFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsAllowMembersToFlag, true), gettype($optionsAllowMembersToFlag)), __LINE__);
        }
        if (is_null($optionsAllowMembersToFlag) || (is_array($optionsAllowMembersToFlag) && empty($optionsAllowMembersToFlag))) {
            unset($this->OptionsAllowMembersToFlag);
        } else {
            $this->OptionsAllowMembersToFlag = $optionsAllowMembersToFlag;
        }
        return $this;
    }
    /**
     * Get OptionsCWBannerState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsCWBannerState()
    {
        return isset($this->OptionsCWBannerState) ? $this->OptionsCWBannerState : null;
    }
    /**
     * Set OptionsCWBannerState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsCWBannerState
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsCWBannerState($optionsCWBannerState = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsCWBannerState) && !is_bool($optionsCWBannerState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsCWBannerState, true), gettype($optionsCWBannerState)), __LINE__);
        }
        if (is_null($optionsCWBannerState) || (is_array($optionsCWBannerState) && empty($optionsCWBannerState))) {
            unset($this->OptionsCWBannerState);
        } else {
            $this->OptionsCWBannerState = $optionsCWBannerState;
        }
        return $this;
    }
    /**
     * Get OptionsDirectMessagesEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsDirectMessagesEnabled()
    {
        return isset($this->OptionsDirectMessagesEnabled) ? $this->OptionsDirectMessagesEnabled : null;
    }
    /**
     * Set OptionsDirectMessagesEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsDirectMessagesEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsDirectMessagesEnabled($optionsDirectMessagesEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsDirectMessagesEnabled) && !is_bool($optionsDirectMessagesEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsDirectMessagesEnabled, true), gettype($optionsDirectMessagesEnabled)), __LINE__);
        }
        if (is_null($optionsDirectMessagesEnabled) || (is_array($optionsDirectMessagesEnabled) && empty($optionsDirectMessagesEnabled))) {
            unset($this->OptionsDirectMessagesEnabled);
        } else {
            $this->OptionsDirectMessagesEnabled = $optionsDirectMessagesEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsDisableWorkspaceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsDisableWorkspaceInfo()
    {
        return isset($this->OptionsDisableWorkspaceInfo) ? $this->OptionsDisableWorkspaceInfo : null;
    }
    /**
     * Set OptionsDisableWorkspaceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsDisableWorkspaceInfo
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsDisableWorkspaceInfo($optionsDisableWorkspaceInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsDisableWorkspaceInfo) && !is_bool($optionsDisableWorkspaceInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsDisableWorkspaceInfo, true), gettype($optionsDisableWorkspaceInfo)), __LINE__);
        }
        if (is_null($optionsDisableWorkspaceInfo) || (is_array($optionsDisableWorkspaceInfo) && empty($optionsDisableWorkspaceInfo))) {
            unset($this->OptionsDisableWorkspaceInfo);
        } else {
            $this->OptionsDisableWorkspaceInfo = $optionsDisableWorkspaceInfo;
        }
        return $this;
    }
    /**
     * Get OptionsEinsteinAnswersEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsEinsteinAnswersEnabled()
    {
        return isset($this->OptionsEinsteinAnswersEnabled) ? $this->OptionsEinsteinAnswersEnabled : null;
    }
    /**
     * Set OptionsEinsteinAnswersEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsEinsteinAnswersEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsEinsteinAnswersEnabled($optionsEinsteinAnswersEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsEinsteinAnswersEnabled) && !is_bool($optionsEinsteinAnswersEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsEinsteinAnswersEnabled, true), gettype($optionsEinsteinAnswersEnabled)), __LINE__);
        }
        if (is_null($optionsEinsteinAnswersEnabled) || (is_array($optionsEinsteinAnswersEnabled) && empty($optionsEinsteinAnswersEnabled))) {
            unset($this->OptionsEinsteinAnswersEnabled);
        } else {
            $this->OptionsEinsteinAnswersEnabled = $optionsEinsteinAnswersEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsEinsteinAnswersKAEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsEinsteinAnswersKAEnabled()
    {
        return isset($this->OptionsEinsteinAnswersKAEnabled) ? $this->OptionsEinsteinAnswersKAEnabled : null;
    }
    /**
     * Set OptionsEinsteinAnswersKAEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsEinsteinAnswersKAEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsEinsteinAnswersKAEnabled($optionsEinsteinAnswersKAEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsEinsteinAnswersKAEnabled) && !is_bool($optionsEinsteinAnswersKAEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsEinsteinAnswersKAEnabled, true), gettype($optionsEinsteinAnswersKAEnabled)), __LINE__);
        }
        if (is_null($optionsEinsteinAnswersKAEnabled) || (is_array($optionsEinsteinAnswersKAEnabled) && empty($optionsEinsteinAnswersKAEnabled))) {
            unset($this->OptionsEinsteinAnswersKAEnabled);
        } else {
            $this->OptionsEinsteinAnswersKAEnabled = $optionsEinsteinAnswersKAEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsEinsteinAnswersQAEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsEinsteinAnswersQAEnabled()
    {
        return isset($this->OptionsEinsteinAnswersQAEnabled) ? $this->OptionsEinsteinAnswersQAEnabled : null;
    }
    /**
     * Set OptionsEinsteinAnswersQAEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsEinsteinAnswersQAEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsEinsteinAnswersQAEnabled($optionsEinsteinAnswersQAEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsEinsteinAnswersQAEnabled) && !is_bool($optionsEinsteinAnswersQAEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsEinsteinAnswersQAEnabled, true), gettype($optionsEinsteinAnswersQAEnabled)), __LINE__);
        }
        if (is_null($optionsEinsteinAnswersQAEnabled) || (is_array($optionsEinsteinAnswersQAEnabled) && empty($optionsEinsteinAnswersQAEnabled))) {
            unset($this->OptionsEinsteinAnswersQAEnabled);
        } else {
            $this->OptionsEinsteinAnswersQAEnabled = $optionsEinsteinAnswersQAEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsEinsteinAnswersSnippetEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsEinsteinAnswersSnippetEnabled()
    {
        return isset($this->OptionsEinsteinAnswersSnippetEnabled) ? $this->OptionsEinsteinAnswersSnippetEnabled : null;
    }
    /**
     * Set OptionsEinsteinAnswersSnippetEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsEinsteinAnswersSnippetEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsEinsteinAnswersSnippetEnabled($optionsEinsteinAnswersSnippetEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsEinsteinAnswersSnippetEnabled) && !is_bool($optionsEinsteinAnswersSnippetEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsEinsteinAnswersSnippetEnabled, true), gettype($optionsEinsteinAnswersSnippetEnabled)), __LINE__);
        }
        if (is_null($optionsEinsteinAnswersSnippetEnabled) || (is_array($optionsEinsteinAnswersSnippetEnabled) && empty($optionsEinsteinAnswersSnippetEnabled))) {
            unset($this->OptionsEinsteinAnswersSnippetEnabled);
        } else {
            $this->OptionsEinsteinAnswersSnippetEnabled = $optionsEinsteinAnswersSnippetEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsEnableTalkingAboutStats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsEnableTalkingAboutStats()
    {
        return isset($this->OptionsEnableTalkingAboutStats) ? $this->OptionsEnableTalkingAboutStats : null;
    }
    /**
     * Set OptionsEnableTalkingAboutStats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsEnableTalkingAboutStats
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsEnableTalkingAboutStats($optionsEnableTalkingAboutStats = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsEnableTalkingAboutStats) && !is_bool($optionsEnableTalkingAboutStats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsEnableTalkingAboutStats, true), gettype($optionsEnableTalkingAboutStats)), __LINE__);
        }
        if (is_null($optionsEnableTalkingAboutStats) || (is_array($optionsEnableTalkingAboutStats) && empty($optionsEnableTalkingAboutStats))) {
            unset($this->OptionsEnableTalkingAboutStats);
        } else {
            $this->OptionsEnableTalkingAboutStats = $optionsEnableTalkingAboutStats;
        }
        return $this;
    }
    /**
     * Get OptionsEnableTopicAssignmentRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsEnableTopicAssignmentRules()
    {
        return isset($this->OptionsEnableTopicAssignmentRules) ? $this->OptionsEnableTopicAssignmentRules : null;
    }
    /**
     * Set OptionsEnableTopicAssignmentRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsEnableTopicAssignmentRules
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsEnableTopicAssignmentRules($optionsEnableTopicAssignmentRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsEnableTopicAssignmentRules) && !is_bool($optionsEnableTopicAssignmentRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsEnableTopicAssignmentRules, true), gettype($optionsEnableTopicAssignmentRules)), __LINE__);
        }
        if (is_null($optionsEnableTopicAssignmentRules) || (is_array($optionsEnableTopicAssignmentRules) && empty($optionsEnableTopicAssignmentRules))) {
            unset($this->OptionsEnableTopicAssignmentRules);
        } else {
            $this->OptionsEnableTopicAssignmentRules = $optionsEnableTopicAssignmentRules;
        }
        return $this;
    }
    /**
     * Get OptionsGatherCustomerSentimentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsGatherCustomerSentimentData()
    {
        return isset($this->OptionsGatherCustomerSentimentData) ? $this->OptionsGatherCustomerSentimentData : null;
    }
    /**
     * Set OptionsGatherCustomerSentimentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsGatherCustomerSentimentData
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsGatherCustomerSentimentData($optionsGatherCustomerSentimentData = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsGatherCustomerSentimentData) && !is_bool($optionsGatherCustomerSentimentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsGatherCustomerSentimentData, true), gettype($optionsGatherCustomerSentimentData)), __LINE__);
        }
        if (is_null($optionsGatherCustomerSentimentData) || (is_array($optionsGatherCustomerSentimentData) && empty($optionsGatherCustomerSentimentData))) {
            unset($this->OptionsGatherCustomerSentimentData);
        } else {
            $this->OptionsGatherCustomerSentimentData = $optionsGatherCustomerSentimentData;
        }
        return $this;
    }
    /**
     * Get OptionsGuestChatterEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsGuestChatterEnabled()
    {
        return isset($this->OptionsGuestChatterEnabled) ? $this->OptionsGuestChatterEnabled : null;
    }
    /**
     * Set OptionsGuestChatterEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsGuestChatterEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsGuestChatterEnabled($optionsGuestChatterEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsGuestChatterEnabled) && !is_bool($optionsGuestChatterEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsGuestChatterEnabled, true), gettype($optionsGuestChatterEnabled)), __LINE__);
        }
        if (is_null($optionsGuestChatterEnabled) || (is_array($optionsGuestChatterEnabled) && empty($optionsGuestChatterEnabled))) {
            unset($this->OptionsGuestChatterEnabled);
        } else {
            $this->OptionsGuestChatterEnabled = $optionsGuestChatterEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsGuestFileAccessEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsGuestFileAccessEnabled()
    {
        return isset($this->OptionsGuestFileAccessEnabled) ? $this->OptionsGuestFileAccessEnabled : null;
    }
    /**
     * Set OptionsGuestFileAccessEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsGuestFileAccessEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsGuestFileAccessEnabled($optionsGuestFileAccessEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsGuestFileAccessEnabled) && !is_bool($optionsGuestFileAccessEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsGuestFileAccessEnabled, true), gettype($optionsGuestFileAccessEnabled)), __LINE__);
        }
        if (is_null($optionsGuestFileAccessEnabled) || (is_array($optionsGuestFileAccessEnabled) && empty($optionsGuestFileAccessEnabled))) {
            unset($this->OptionsGuestFileAccessEnabled);
        } else {
            $this->OptionsGuestFileAccessEnabled = $optionsGuestFileAccessEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsInvitationsEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsInvitationsEnabled()
    {
        return isset($this->OptionsInvitationsEnabled) ? $this->OptionsInvitationsEnabled : null;
    }
    /**
     * Set OptionsInvitationsEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsInvitationsEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsInvitationsEnabled($optionsInvitationsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsInvitationsEnabled) && !is_bool($optionsInvitationsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsInvitationsEnabled, true), gettype($optionsInvitationsEnabled)), __LINE__);
        }
        if (is_null($optionsInvitationsEnabled) || (is_array($optionsInvitationsEnabled) && empty($optionsInvitationsEnabled))) {
            unset($this->OptionsInvitationsEnabled);
        } else {
            $this->OptionsInvitationsEnabled = $optionsInvitationsEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsKnowledgeableEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsKnowledgeableEnabled()
    {
        return isset($this->OptionsKnowledgeableEnabled) ? $this->OptionsKnowledgeableEnabled : null;
    }
    /**
     * Set OptionsKnowledgeableEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsKnowledgeableEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsKnowledgeableEnabled($optionsKnowledgeableEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsKnowledgeableEnabled) && !is_bool($optionsKnowledgeableEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsKnowledgeableEnabled, true), gettype($optionsKnowledgeableEnabled)), __LINE__);
        }
        if (is_null($optionsKnowledgeableEnabled) || (is_array($optionsKnowledgeableEnabled) && empty($optionsKnowledgeableEnabled))) {
            unset($this->OptionsKnowledgeableEnabled);
        } else {
            $this->OptionsKnowledgeableEnabled = $optionsKnowledgeableEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsMemberVisibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsMemberVisibility()
    {
        return isset($this->OptionsMemberVisibility) ? $this->OptionsMemberVisibility : null;
    }
    /**
     * Set OptionsMemberVisibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsMemberVisibility
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsMemberVisibility($optionsMemberVisibility = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsMemberVisibility) && !is_bool($optionsMemberVisibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsMemberVisibility, true), gettype($optionsMemberVisibility)), __LINE__);
        }
        if (is_null($optionsMemberVisibility) || (is_array($optionsMemberVisibility) && empty($optionsMemberVisibility))) {
            unset($this->OptionsMemberVisibility);
        } else {
            $this->OptionsMemberVisibility = $optionsMemberVisibility;
        }
        return $this;
    }
    /**
     * Get OptionsMobileImageOptimizationEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsMobileImageOptimizationEnabled()
    {
        return isset($this->OptionsMobileImageOptimizationEnabled) ? $this->OptionsMobileImageOptimizationEnabled : null;
    }
    /**
     * Set OptionsMobileImageOptimizationEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsMobileImageOptimizationEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsMobileImageOptimizationEnabled($optionsMobileImageOptimizationEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsMobileImageOptimizationEnabled) && !is_bool($optionsMobileImageOptimizationEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsMobileImageOptimizationEnabled, true), gettype($optionsMobileImageOptimizationEnabled)), __LINE__);
        }
        if (is_null($optionsMobileImageOptimizationEnabled) || (is_array($optionsMobileImageOptimizationEnabled) && empty($optionsMobileImageOptimizationEnabled))) {
            unset($this->OptionsMobileImageOptimizationEnabled);
        } else {
            $this->OptionsMobileImageOptimizationEnabled = $optionsMobileImageOptimizationEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsNetworkSentimentAnalysis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsNetworkSentimentAnalysis()
    {
        return isset($this->OptionsNetworkSentimentAnalysis) ? $this->OptionsNetworkSentimentAnalysis : null;
    }
    /**
     * Set OptionsNetworkSentimentAnalysis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsNetworkSentimentAnalysis
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsNetworkSentimentAnalysis($optionsNetworkSentimentAnalysis = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsNetworkSentimentAnalysis) && !is_bool($optionsNetworkSentimentAnalysis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsNetworkSentimentAnalysis, true), gettype($optionsNetworkSentimentAnalysis)), __LINE__);
        }
        if (is_null($optionsNetworkSentimentAnalysis) || (is_array($optionsNetworkSentimentAnalysis) && empty($optionsNetworkSentimentAnalysis))) {
            unset($this->OptionsNetworkSentimentAnalysis);
        } else {
            $this->OptionsNetworkSentimentAnalysis = $optionsNetworkSentimentAnalysis;
        }
        return $this;
    }
    /**
     * Get OptionsNicknameDisplayEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsNicknameDisplayEnabled()
    {
        return isset($this->OptionsNicknameDisplayEnabled) ? $this->OptionsNicknameDisplayEnabled : null;
    }
    /**
     * Set OptionsNicknameDisplayEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsNicknameDisplayEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsNicknameDisplayEnabled($optionsNicknameDisplayEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsNicknameDisplayEnabled) && !is_bool($optionsNicknameDisplayEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsNicknameDisplayEnabled, true), gettype($optionsNicknameDisplayEnabled)), __LINE__);
        }
        if (is_null($optionsNicknameDisplayEnabled) || (is_array($optionsNicknameDisplayEnabled) && empty($optionsNicknameDisplayEnabled))) {
            unset($this->OptionsNicknameDisplayEnabled);
        } else {
            $this->OptionsNicknameDisplayEnabled = $optionsNicknameDisplayEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsPrivateMessagesEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsPrivateMessagesEnabled()
    {
        return isset($this->OptionsPrivateMessagesEnabled) ? $this->OptionsPrivateMessagesEnabled : null;
    }
    /**
     * Set OptionsPrivateMessagesEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsPrivateMessagesEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsPrivateMessagesEnabled($optionsPrivateMessagesEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsPrivateMessagesEnabled) && !is_bool($optionsPrivateMessagesEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsPrivateMessagesEnabled, true), gettype($optionsPrivateMessagesEnabled)), __LINE__);
        }
        if (is_null($optionsPrivateMessagesEnabled) || (is_array($optionsPrivateMessagesEnabled) && empty($optionsPrivateMessagesEnabled))) {
            unset($this->OptionsPrivateMessagesEnabled);
        } else {
            $this->OptionsPrivateMessagesEnabled = $optionsPrivateMessagesEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsRecognitionBadgingEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsRecognitionBadgingEnabled()
    {
        return isset($this->OptionsRecognitionBadgingEnabled) ? $this->OptionsRecognitionBadgingEnabled : null;
    }
    /**
     * Set OptionsRecognitionBadgingEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsRecognitionBadgingEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsRecognitionBadgingEnabled($optionsRecognitionBadgingEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsRecognitionBadgingEnabled) && !is_bool($optionsRecognitionBadgingEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsRecognitionBadgingEnabled, true), gettype($optionsRecognitionBadgingEnabled)), __LINE__);
        }
        if (is_null($optionsRecognitionBadgingEnabled) || (is_array($optionsRecognitionBadgingEnabled) && empty($optionsRecognitionBadgingEnabled))) {
            unset($this->OptionsRecognitionBadgingEnabled);
        } else {
            $this->OptionsRecognitionBadgingEnabled = $optionsRecognitionBadgingEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsReputationEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsReputationEnabled()
    {
        return isset($this->OptionsReputationEnabled) ? $this->OptionsReputationEnabled : null;
    }
    /**
     * Set OptionsReputationEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsReputationEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsReputationEnabled($optionsReputationEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsReputationEnabled) && !is_bool($optionsReputationEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsReputationEnabled, true), gettype($optionsReputationEnabled)), __LINE__);
        }
        if (is_null($optionsReputationEnabled) || (is_array($optionsReputationEnabled) && empty($optionsReputationEnabled))) {
            unset($this->OptionsReputationEnabled);
        } else {
            $this->OptionsReputationEnabled = $optionsReputationEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsReputationRecordConversationsDisabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsReputationRecordConversationsDisabled()
    {
        return isset($this->OptionsReputationRecordConversationsDisabled) ? $this->OptionsReputationRecordConversationsDisabled : null;
    }
    /**
     * Set OptionsReputationRecordConversationsDisabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsReputationRecordConversationsDisabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsReputationRecordConversationsDisabled($optionsReputationRecordConversationsDisabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsReputationRecordConversationsDisabled) && !is_bool($optionsReputationRecordConversationsDisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsReputationRecordConversationsDisabled, true), gettype($optionsReputationRecordConversationsDisabled)), __LINE__);
        }
        if (is_null($optionsReputationRecordConversationsDisabled) || (is_array($optionsReputationRecordConversationsDisabled) && empty($optionsReputationRecordConversationsDisabled))) {
            unset($this->OptionsReputationRecordConversationsDisabled);
        } else {
            $this->OptionsReputationRecordConversationsDisabled = $optionsReputationRecordConversationsDisabled;
        }
        return $this;
    }
    /**
     * Get OptionsSelfRegistrationEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsSelfRegistrationEnabled()
    {
        return isset($this->OptionsSelfRegistrationEnabled) ? $this->OptionsSelfRegistrationEnabled : null;
    }
    /**
     * Set OptionsSelfRegistrationEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsSelfRegistrationEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsSelfRegistrationEnabled($optionsSelfRegistrationEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsSelfRegistrationEnabled) && !is_bool($optionsSelfRegistrationEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsSelfRegistrationEnabled, true), gettype($optionsSelfRegistrationEnabled)), __LINE__);
        }
        if (is_null($optionsSelfRegistrationEnabled) || (is_array($optionsSelfRegistrationEnabled) && empty($optionsSelfRegistrationEnabled))) {
            unset($this->OptionsSelfRegistrationEnabled);
        } else {
            $this->OptionsSelfRegistrationEnabled = $optionsSelfRegistrationEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsSendWelcomeEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsSendWelcomeEmail()
    {
        return isset($this->OptionsSendWelcomeEmail) ? $this->OptionsSendWelcomeEmail : null;
    }
    /**
     * Set OptionsSendWelcomeEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsSendWelcomeEmail
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsSendWelcomeEmail($optionsSendWelcomeEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsSendWelcomeEmail) && !is_bool($optionsSendWelcomeEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsSendWelcomeEmail, true), gettype($optionsSendWelcomeEmail)), __LINE__);
        }
        if (is_null($optionsSendWelcomeEmail) || (is_array($optionsSendWelcomeEmail) && empty($optionsSendWelcomeEmail))) {
            unset($this->OptionsSendWelcomeEmail);
        } else {
            $this->OptionsSendWelcomeEmail = $optionsSendWelcomeEmail;
        }
        return $this;
    }
    /**
     * Get OptionsShowAllNetworkSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsShowAllNetworkSettings()
    {
        return isset($this->OptionsShowAllNetworkSettings) ? $this->OptionsShowAllNetworkSettings : null;
    }
    /**
     * Set OptionsShowAllNetworkSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsShowAllNetworkSettings
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsShowAllNetworkSettings($optionsShowAllNetworkSettings = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsShowAllNetworkSettings) && !is_bool($optionsShowAllNetworkSettings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsShowAllNetworkSettings, true), gettype($optionsShowAllNetworkSettings)), __LINE__);
        }
        if (is_null($optionsShowAllNetworkSettings) || (is_array($optionsShowAllNetworkSettings) && empty($optionsShowAllNetworkSettings))) {
            unset($this->OptionsShowAllNetworkSettings);
        } else {
            $this->OptionsShowAllNetworkSettings = $optionsShowAllNetworkSettings;
        }
        return $this;
    }
    /**
     * Get OptionsSiteAsContainerEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsSiteAsContainerEnabled()
    {
        return isset($this->OptionsSiteAsContainerEnabled) ? $this->OptionsSiteAsContainerEnabled : null;
    }
    /**
     * Set OptionsSiteAsContainerEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsSiteAsContainerEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsSiteAsContainerEnabled($optionsSiteAsContainerEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsSiteAsContainerEnabled) && !is_bool($optionsSiteAsContainerEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsSiteAsContainerEnabled, true), gettype($optionsSiteAsContainerEnabled)), __LINE__);
        }
        if (is_null($optionsSiteAsContainerEnabled) || (is_array($optionsSiteAsContainerEnabled) && empty($optionsSiteAsContainerEnabled))) {
            unset($this->OptionsSiteAsContainerEnabled);
        } else {
            $this->OptionsSiteAsContainerEnabled = $optionsSiteAsContainerEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsThreadedDiscussionsEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsThreadedDiscussionsEnabled()
    {
        return isset($this->OptionsThreadedDiscussionsEnabled) ? $this->OptionsThreadedDiscussionsEnabled : null;
    }
    /**
     * Set OptionsThreadedDiscussionsEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsThreadedDiscussionsEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsThreadedDiscussionsEnabled($optionsThreadedDiscussionsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsThreadedDiscussionsEnabled) && !is_bool($optionsThreadedDiscussionsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsThreadedDiscussionsEnabled, true), gettype($optionsThreadedDiscussionsEnabled)), __LINE__);
        }
        if (is_null($optionsThreadedDiscussionsEnabled) || (is_array($optionsThreadedDiscussionsEnabled) && empty($optionsThreadedDiscussionsEnabled))) {
            unset($this->OptionsThreadedDiscussionsEnabled);
        } else {
            $this->OptionsThreadedDiscussionsEnabled = $optionsThreadedDiscussionsEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsTopicSuggestionsEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsTopicSuggestionsEnabled()
    {
        return isset($this->OptionsTopicSuggestionsEnabled) ? $this->OptionsTopicSuggestionsEnabled : null;
    }
    /**
     * Set OptionsTopicSuggestionsEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsTopicSuggestionsEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsTopicSuggestionsEnabled($optionsTopicSuggestionsEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsTopicSuggestionsEnabled) && !is_bool($optionsTopicSuggestionsEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsTopicSuggestionsEnabled, true), gettype($optionsTopicSuggestionsEnabled)), __LINE__);
        }
        if (is_null($optionsTopicSuggestionsEnabled) || (is_array($optionsTopicSuggestionsEnabled) && empty($optionsTopicSuggestionsEnabled))) {
            unset($this->OptionsTopicSuggestionsEnabled);
        } else {
            $this->OptionsTopicSuggestionsEnabled = $optionsTopicSuggestionsEnabled;
        }
        return $this;
    }
    /**
     * Get OptionsUpDownVoteEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsUpDownVoteEnabled()
    {
        return isset($this->OptionsUpDownVoteEnabled) ? $this->OptionsUpDownVoteEnabled : null;
    }
    /**
     * Set OptionsUpDownVoteEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsUpDownVoteEnabled
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setOptionsUpDownVoteEnabled($optionsUpDownVoteEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsUpDownVoteEnabled) && !is_bool($optionsUpDownVoteEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsUpDownVoteEnabled, true), gettype($optionsUpDownVoteEnabled)), __LINE__);
        }
        if (is_null($optionsUpDownVoteEnabled) || (is_array($optionsUpDownVoteEnabled) && empty($optionsUpDownVoteEnabled))) {
            unset($this->OptionsUpDownVoteEnabled);
        } else {
            $this->OptionsUpDownVoteEnabled = $optionsUpDownVoteEnabled;
        }
        return $this;
    }
    /**
     * Get SelfRegProfileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelfRegProfileId()
    {
        return isset($this->SelfRegProfileId) ? $this->SelfRegProfileId : null;
    }
    /**
     * Set SelfRegProfileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selfRegProfileId
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setSelfRegProfileId($selfRegProfileId = null)
    {
        // validation for constraint: string
        if (!is_null($selfRegProfileId) && !is_string($selfRegProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selfRegProfileId, true), gettype($selfRegProfileId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($selfRegProfileId) && mb_strlen($selfRegProfileId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($selfRegProfileId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($selfRegProfileId) && !preg_match('/[a-zA-Z0-9]{18}/', $selfRegProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($selfRegProfileId, true)), __LINE__);
        }
        if (is_null($selfRegProfileId) || (is_array($selfRegProfileId) && empty($selfRegProfileId))) {
            unset($this->SelfRegProfileId);
        } else {
            $this->SelfRegProfileId = $selfRegProfileId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UrlPathPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlPathPrefix()
    {
        return isset($this->UrlPathPrefix) ? $this->UrlPathPrefix : null;
    }
    /**
     * Set UrlPathPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlPathPrefix
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setUrlPathPrefix($urlPathPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($urlPathPrefix) && !is_string($urlPathPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlPathPrefix, true), gettype($urlPathPrefix)), __LINE__);
        }
        if (is_null($urlPathPrefix) || (is_array($urlPathPrefix) && empty($urlPathPrefix))) {
            unset($this->UrlPathPrefix);
        } else {
            $this->UrlPathPrefix = $urlPathPrefix;
        }
        return $this;
    }
    /**
     * Get VerificationEmailTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVerificationEmailTemplateId()
    {
        return isset($this->VerificationEmailTemplateId) ? $this->VerificationEmailTemplateId : null;
    }
    /**
     * Set VerificationEmailTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $verificationEmailTemplateId
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setVerificationEmailTemplateId($verificationEmailTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($verificationEmailTemplateId) && !is_string($verificationEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verificationEmailTemplateId, true), gettype($verificationEmailTemplateId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($verificationEmailTemplateId) && mb_strlen($verificationEmailTemplateId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($verificationEmailTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($verificationEmailTemplateId) && !preg_match('/[a-zA-Z0-9]{18}/', $verificationEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($verificationEmailTemplateId, true)), __LINE__);
        }
        if (is_null($verificationEmailTemplateId) || (is_array($verificationEmailTemplateId) && empty($verificationEmailTemplateId))) {
            unset($this->VerificationEmailTemplateId);
        } else {
            $this->VerificationEmailTemplateId = $verificationEmailTemplateId;
        }
        return $this;
    }
    /**
     * Get WelcomeEmailTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWelcomeEmailTemplateId()
    {
        return isset($this->WelcomeEmailTemplateId) ? $this->WelcomeEmailTemplateId : null;
    }
    /**
     * Set WelcomeEmailTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $welcomeEmailTemplateId
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public function setWelcomeEmailTemplateId($welcomeEmailTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($welcomeEmailTemplateId) && !is_string($welcomeEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($welcomeEmailTemplateId, true), gettype($welcomeEmailTemplateId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($welcomeEmailTemplateId) && mb_strlen($welcomeEmailTemplateId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($welcomeEmailTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($welcomeEmailTemplateId) && !preg_match('/[a-zA-Z0-9]{18}/', $welcomeEmailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($welcomeEmailTemplateId, true)), __LINE__);
        }
        if (is_null($welcomeEmailTemplateId) || (is_array($welcomeEmailTemplateId) && empty($welcomeEmailTemplateId))) {
            unset($this->WelcomeEmailTemplateId);
        } else {
            $this->WelcomeEmailTemplateId = $welcomeEmailTemplateId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Network
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
