<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginIp StructType
 * @subpackage Structs
 */
class LoginIp extends SObject
{
    /**
     * The ChallengeMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChallengeMethod;
    /**
     * The ChallengeSentDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChallengeSentDate;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The IsAuthenticated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAuthenticated;
    /**
     * The SourceIp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceIp;
    /**
     * The Users
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Users;
    /**
     * The UsersId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UsersId;
    /**
     * Constructor method for LoginIp
     * @uses LoginIp::setChallengeMethod()
     * @uses LoginIp::setChallengeSentDate()
     * @uses LoginIp::setCreatedDate()
     * @uses LoginIp::setIsAuthenticated()
     * @uses LoginIp::setSourceIp()
     * @uses LoginIp::setUsers()
     * @uses LoginIp::setUsersId()
     * @param string $challengeMethod
     * @param string $challengeSentDate
     * @param string $createdDate
     * @param bool $isAuthenticated
     * @param string $sourceIp
     * @param \NexusDigital/MiratelForce\StructType\User $users
     * @param string $usersId
     */
    public function __construct($challengeMethod = null, $challengeSentDate = null, $createdDate = null, $isAuthenticated = null, $sourceIp = null, \NexusDigital/MiratelForce\StructType\User $users = null, $usersId = null)
    {
        $this
            ->setChallengeMethod($challengeMethod)
            ->setChallengeSentDate($challengeSentDate)
            ->setCreatedDate($createdDate)
            ->setIsAuthenticated($isAuthenticated)
            ->setSourceIp($sourceIp)
            ->setUsers($users)
            ->setUsersId($usersId);
    }
    /**
     * Get ChallengeMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChallengeMethod()
    {
        return isset($this->ChallengeMethod) ? $this->ChallengeMethod : null;
    }
    /**
     * Set ChallengeMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $challengeMethod
     * @return \NexusDigital/MiratelForce\StructType\LoginIp
     */
    public function setChallengeMethod($challengeMethod = null)
    {
        // validation for constraint: string
        if (!is_null($challengeMethod) && !is_string($challengeMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($challengeMethod, true), gettype($challengeMethod)), __LINE__);
        }
        if (is_null($challengeMethod) || (is_array($challengeMethod) && empty($challengeMethod))) {
            unset($this->ChallengeMethod);
        } else {
            $this->ChallengeMethod = $challengeMethod;
        }
        return $this;
    }
    /**
     * Get ChallengeSentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChallengeSentDate()
    {
        return isset($this->ChallengeSentDate) ? $this->ChallengeSentDate : null;
    }
    /**
     * Set ChallengeSentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $challengeSentDate
     * @return \NexusDigital/MiratelForce\StructType\LoginIp
     */
    public function setChallengeSentDate($challengeSentDate = null)
    {
        // validation for constraint: string
        if (!is_null($challengeSentDate) && !is_string($challengeSentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($challengeSentDate, true), gettype($challengeSentDate)), __LINE__);
        }
        if (is_null($challengeSentDate) || (is_array($challengeSentDate) && empty($challengeSentDate))) {
            unset($this->ChallengeSentDate);
        } else {
            $this->ChallengeSentDate = $challengeSentDate;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\LoginIp
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get IsAuthenticated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAuthenticated()
    {
        return isset($this->IsAuthenticated) ? $this->IsAuthenticated : null;
    }
    /**
     * Set IsAuthenticated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAuthenticated
     * @return \NexusDigital/MiratelForce\StructType\LoginIp
     */
    public function setIsAuthenticated($isAuthenticated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAuthenticated) && !is_bool($isAuthenticated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAuthenticated, true), gettype($isAuthenticated)), __LINE__);
        }
        if (is_null($isAuthenticated) || (is_array($isAuthenticated) && empty($isAuthenticated))) {
            unset($this->IsAuthenticated);
        } else {
            $this->IsAuthenticated = $isAuthenticated;
        }
        return $this;
    }
    /**
     * Get SourceIp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceIp()
    {
        return isset($this->SourceIp) ? $this->SourceIp : null;
    }
    /**
     * Set SourceIp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceIp
     * @return \NexusDigital/MiratelForce\StructType\LoginIp
     */
    public function setSourceIp($sourceIp = null)
    {
        // validation for constraint: string
        if (!is_null($sourceIp) && !is_string($sourceIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceIp, true), gettype($sourceIp)), __LINE__);
        }
        if (is_null($sourceIp) || (is_array($sourceIp) && empty($sourceIp))) {
            unset($this->SourceIp);
        } else {
            $this->SourceIp = $sourceIp;
        }
        return $this;
    }
    /**
     * Get Users value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUsers()
    {
        return isset($this->Users) ? $this->Users : null;
    }
    /**
     * Set Users value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $users
     * @return \NexusDigital/MiratelForce\StructType\LoginIp
     */
    public function setUsers(\NexusDigital/MiratelForce\StructType\User $users = null)
    {
        if (is_null($users) || (is_array($users) && empty($users))) {
            unset($this->Users);
        } else {
            $this->Users = $users;
        }
        return $this;
    }
    /**
     * Get UsersId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsersId()
    {
        return isset($this->UsersId) ? $this->UsersId : null;
    }
    /**
     * Set UsersId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usersId
     * @return \NexusDigital/MiratelForce\StructType\LoginIp
     */
    public function setUsersId($usersId = null)
    {
        // validation for constraint: string
        if (!is_null($usersId) && !is_string($usersId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usersId, true), gettype($usersId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($usersId) && mb_strlen($usersId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($usersId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($usersId) && !preg_match('/[a-zA-Z0-9]{18}/', $usersId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($usersId, true)), __LINE__);
        }
        if (is_null($usersId) || (is_array($usersId) && empty($usersId))) {
            unset($this->UsersId);
        } else {
            $this->UsersId = $usersId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\LoginIp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
