<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LightningUsageByPageMetrics StructType
 * @subpackage Structs
 */
class LightningUsageByPageMetrics extends SObject
{
    /**
     * The EptBin3To5
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EptBin3To5;
    /**
     * The EptBin5To8
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EptBin5To8;
    /**
     * The EptBin8To10
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EptBin8To10;
    /**
     * The EptBinOver10
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EptBinOver10;
    /**
     * The EptBinUnder3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EptBinUnder3;
    /**
     * The MetricsDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MetricsDate;
    /**
     * The PageName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PageName;
    /**
     * The RecordCountEPT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RecordCountEPT;
    /**
     * The SumEPT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SumEPT;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TotalCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalCount;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for LightningUsageByPageMetrics
     * @uses LightningUsageByPageMetrics::setEptBin3To5()
     * @uses LightningUsageByPageMetrics::setEptBin5To8()
     * @uses LightningUsageByPageMetrics::setEptBin8To10()
     * @uses LightningUsageByPageMetrics::setEptBinOver10()
     * @uses LightningUsageByPageMetrics::setEptBinUnder3()
     * @uses LightningUsageByPageMetrics::setMetricsDate()
     * @uses LightningUsageByPageMetrics::setPageName()
     * @uses LightningUsageByPageMetrics::setRecordCountEPT()
     * @uses LightningUsageByPageMetrics::setSumEPT()
     * @uses LightningUsageByPageMetrics::setSystemModstamp()
     * @uses LightningUsageByPageMetrics::setTotalCount()
     * @uses LightningUsageByPageMetrics::setUser()
     * @uses LightningUsageByPageMetrics::setUserId()
     * @param int $eptBin3To5
     * @param int $eptBin5To8
     * @param int $eptBin8To10
     * @param int $eptBinOver10
     * @param int $eptBinUnder3
     * @param string $metricsDate
     * @param string $pageName
     * @param int $recordCountEPT
     * @param int $sumEPT
     * @param string $systemModstamp
     * @param int $totalCount
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     */
    public function __construct($eptBin3To5 = null, $eptBin5To8 = null, $eptBin8To10 = null, $eptBinOver10 = null, $eptBinUnder3 = null, $metricsDate = null, $pageName = null, $recordCountEPT = null, $sumEPT = null, $systemModstamp = null, $totalCount = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null)
    {
        $this
            ->setEptBin3To5($eptBin3To5)
            ->setEptBin5To8($eptBin5To8)
            ->setEptBin8To10($eptBin8To10)
            ->setEptBinOver10($eptBinOver10)
            ->setEptBinUnder3($eptBinUnder3)
            ->setMetricsDate($metricsDate)
            ->setPageName($pageName)
            ->setRecordCountEPT($recordCountEPT)
            ->setSumEPT($sumEPT)
            ->setSystemModstamp($systemModstamp)
            ->setTotalCount($totalCount)
            ->setUser($user)
            ->setUserId($userId);
    }
    /**
     * Get EptBin3To5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEptBin3To5()
    {
        return isset($this->EptBin3To5) ? $this->EptBin3To5 : null;
    }
    /**
     * Set EptBin3To5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eptBin3To5
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setEptBin3To5($eptBin3To5 = null)
    {
        // validation for constraint: int
        if (!is_null($eptBin3To5) && !(is_int($eptBin3To5) || ctype_digit($eptBin3To5))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eptBin3To5, true), gettype($eptBin3To5)), __LINE__);
        }
        if (is_null($eptBin3To5) || (is_array($eptBin3To5) && empty($eptBin3To5))) {
            unset($this->EptBin3To5);
        } else {
            $this->EptBin3To5 = $eptBin3To5;
        }
        return $this;
    }
    /**
     * Get EptBin5To8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEptBin5To8()
    {
        return isset($this->EptBin5To8) ? $this->EptBin5To8 : null;
    }
    /**
     * Set EptBin5To8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eptBin5To8
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setEptBin5To8($eptBin5To8 = null)
    {
        // validation for constraint: int
        if (!is_null($eptBin5To8) && !(is_int($eptBin5To8) || ctype_digit($eptBin5To8))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eptBin5To8, true), gettype($eptBin5To8)), __LINE__);
        }
        if (is_null($eptBin5To8) || (is_array($eptBin5To8) && empty($eptBin5To8))) {
            unset($this->EptBin5To8);
        } else {
            $this->EptBin5To8 = $eptBin5To8;
        }
        return $this;
    }
    /**
     * Get EptBin8To10 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEptBin8To10()
    {
        return isset($this->EptBin8To10) ? $this->EptBin8To10 : null;
    }
    /**
     * Set EptBin8To10 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eptBin8To10
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setEptBin8To10($eptBin8To10 = null)
    {
        // validation for constraint: int
        if (!is_null($eptBin8To10) && !(is_int($eptBin8To10) || ctype_digit($eptBin8To10))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eptBin8To10, true), gettype($eptBin8To10)), __LINE__);
        }
        if (is_null($eptBin8To10) || (is_array($eptBin8To10) && empty($eptBin8To10))) {
            unset($this->EptBin8To10);
        } else {
            $this->EptBin8To10 = $eptBin8To10;
        }
        return $this;
    }
    /**
     * Get EptBinOver10 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEptBinOver10()
    {
        return isset($this->EptBinOver10) ? $this->EptBinOver10 : null;
    }
    /**
     * Set EptBinOver10 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eptBinOver10
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setEptBinOver10($eptBinOver10 = null)
    {
        // validation for constraint: int
        if (!is_null($eptBinOver10) && !(is_int($eptBinOver10) || ctype_digit($eptBinOver10))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eptBinOver10, true), gettype($eptBinOver10)), __LINE__);
        }
        if (is_null($eptBinOver10) || (is_array($eptBinOver10) && empty($eptBinOver10))) {
            unset($this->EptBinOver10);
        } else {
            $this->EptBinOver10 = $eptBinOver10;
        }
        return $this;
    }
    /**
     * Get EptBinUnder3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEptBinUnder3()
    {
        return isset($this->EptBinUnder3) ? $this->EptBinUnder3 : null;
    }
    /**
     * Set EptBinUnder3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eptBinUnder3
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setEptBinUnder3($eptBinUnder3 = null)
    {
        // validation for constraint: int
        if (!is_null($eptBinUnder3) && !(is_int($eptBinUnder3) || ctype_digit($eptBinUnder3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eptBinUnder3, true), gettype($eptBinUnder3)), __LINE__);
        }
        if (is_null($eptBinUnder3) || (is_array($eptBinUnder3) && empty($eptBinUnder3))) {
            unset($this->EptBinUnder3);
        } else {
            $this->EptBinUnder3 = $eptBinUnder3;
        }
        return $this;
    }
    /**
     * Get MetricsDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMetricsDate()
    {
        return isset($this->MetricsDate) ? $this->MetricsDate : null;
    }
    /**
     * Set MetricsDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $metricsDate
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setMetricsDate($metricsDate = null)
    {
        // validation for constraint: string
        if (!is_null($metricsDate) && !is_string($metricsDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metricsDate, true), gettype($metricsDate)), __LINE__);
        }
        if (is_null($metricsDate) || (is_array($metricsDate) && empty($metricsDate))) {
            unset($this->MetricsDate);
        } else {
            $this->MetricsDate = $metricsDate;
        }
        return $this;
    }
    /**
     * Get PageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPageName()
    {
        return isset($this->PageName) ? $this->PageName : null;
    }
    /**
     * Set PageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pageName
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setPageName($pageName = null)
    {
        // validation for constraint: string
        if (!is_null($pageName) && !is_string($pageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageName, true), gettype($pageName)), __LINE__);
        }
        if (is_null($pageName) || (is_array($pageName) && empty($pageName))) {
            unset($this->PageName);
        } else {
            $this->PageName = $pageName;
        }
        return $this;
    }
    /**
     * Get RecordCountEPT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRecordCountEPT()
    {
        return isset($this->RecordCountEPT) ? $this->RecordCountEPT : null;
    }
    /**
     * Set RecordCountEPT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $recordCountEPT
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setRecordCountEPT($recordCountEPT = null)
    {
        // validation for constraint: int
        if (!is_null($recordCountEPT) && !(is_int($recordCountEPT) || ctype_digit($recordCountEPT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordCountEPT, true), gettype($recordCountEPT)), __LINE__);
        }
        if (is_null($recordCountEPT) || (is_array($recordCountEPT) && empty($recordCountEPT))) {
            unset($this->RecordCountEPT);
        } else {
            $this->RecordCountEPT = $recordCountEPT;
        }
        return $this;
    }
    /**
     * Get SumEPT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSumEPT()
    {
        return isset($this->SumEPT) ? $this->SumEPT : null;
    }
    /**
     * Set SumEPT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sumEPT
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setSumEPT($sumEPT = null)
    {
        // validation for constraint: int
        if (!is_null($sumEPT) && !(is_int($sumEPT) || ctype_digit($sumEPT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sumEPT, true), gettype($sumEPT)), __LINE__);
        }
        if (is_null($sumEPT) || (is_array($sumEPT) && empty($sumEPT))) {
            unset($this->SumEPT);
        } else {
            $this->SumEPT = $sumEPT;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TotalCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalCount()
    {
        return isset($this->TotalCount) ? $this->TotalCount : null;
    }
    /**
     * Set TotalCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalCount
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        if (is_null($totalCount) || (is_array($totalCount) && empty($totalCount))) {
            unset($this->TotalCount);
        } else {
            $this->TotalCount = $totalCount;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\LightningUsageByPageMetrics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
