<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lead StructType
 * @subpackage Structs
 */
class Lead extends SObject
{
    /**
     * The AcceptedEventRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AcceptedEventRelations;
    /**
     * The ActivityHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ActivityHistories;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Address
     */
    public $Address;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Attachments;
    /**
     * The Campaign
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Campaign
     */
    public $Campaign;
    /**
     * The CampaignMembers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CampaignMembers;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Company;
    /**
     * The ContactRequests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContactRequests;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The ConvertedAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Account
     */
    public $ConvertedAccount;
    /**
     * The ConvertedAccountId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ConvertedAccountId;
    /**
     * The ConvertedContact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Contact
     */
    public $ConvertedContact;
    /**
     * The ConvertedContactId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ConvertedContactId;
    /**
     * The ConvertedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConvertedDate;
    /**
     * The ConvertedOpportunity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Opportunity
     */
    public $ConvertedOpportunity;
    /**
     * The ConvertedOpportunityId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ConvertedOpportunityId;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DB_Created_Date_without_Time__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DB_Created_Date_without_Time__c;
    /**
     * The DB_Lead_Age__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DB_Lead_Age__c;
    /**
     * The DeclinedEventRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $DeclinedEventRelations;
    /**
     * The DuplicateRecordItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $DuplicateRecordItems;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The EmailBouncedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBouncedDate;
    /**
     * The EmailBouncedReason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBouncedReason;
    /**
     * The EmailMessageRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EmailMessageRelations;
    /**
     * The EmailStatuses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EmailStatuses;
    /**
     * The EventRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EventRelations;
    /**
     * The EventWhoRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EventWhoRelations;
    /**
     * The Events
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Events;
    /**
     * The FeedSubscriptionsForEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedSubscriptionsForEntity;
    /**
     * The Feeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Feeds;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The GeocodeAccuracy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeocodeAccuracy;
    /**
     * The Histories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Histories;
    /**
     * The Individual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Individual
     */
    public $Individual;
    /**
     * The IndividualId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $IndividualId;
    /**
     * The Industry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Industry;
    /**
     * The IsConverted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConverted;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsUnreadByOwner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUnreadByOwner;
    /**
     * The Jigsaw
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Jigsaw;
    /**
     * The JigsawContactId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JigsawContactId;
    /**
     * The LastActivityDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastActivityDate;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The LastReferencedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastReferencedDate;
    /**
     * The LastViewedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastViewedDate;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Latitude;
    /**
     * The LeadSource
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadSource;
    /**
     * The ListEmailIndividualRecipients
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ListEmailIndividualRecipients;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Longitude;
    /**
     * The LookedUpFromActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $LookedUpFromActivities;
    /**
     * The MasterRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Lead
     */
    public $MasterRecord;
    /**
     * The MasterRecordId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $MasterRecordId;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The MobilePhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Notes;
    /**
     * The NotesAndAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NotesAndAttachments;
    /**
     * The NumberOfEmployees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfEmployees;
    /**
     * The OpenActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $OpenActivities;
    /**
     * The OutgoingEmailRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $OutgoingEmailRelations;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The ParentEntities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ParentEntities;
    /**
     * The PersonRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $PersonRecord;
    /**
     * The Personas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Personas;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The PhotoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhotoUrl;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The Posts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Posts;
    /**
     * The ProcessInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessInstances;
    /**
     * The ProcessSteps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessSteps;
    /**
     * The Rating
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Rating;
    /**
     * The RecordActionHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActionHistories;
    /**
     * The RecordActions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActions;
    /**
     * The RecordAssociatedGroups
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordAssociatedGroups;
    /**
     * The Salutation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Salutation;
    /**
     * The Shares
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Shares;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Street;
    /**
     * The Suffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suffix;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TaskRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TaskRelations;
    /**
     * The TaskWhoRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TaskWhoRelations;
    /**
     * The Tasks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Tasks;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The TopicAssignments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TopicAssignments;
    /**
     * The UndecidedEventRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $UndecidedEventRelations;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * The Website
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Website;
    /**
     * Constructor method for Lead
     * @uses Lead::setAcceptedEventRelations()
     * @uses Lead::setActivityHistories()
     * @uses Lead::setAddress()
     * @uses Lead::setAttachedContentDocuments()
     * @uses Lead::setAttachedContentNotes()
     * @uses Lead::setAttachments()
     * @uses Lead::setCampaign()
     * @uses Lead::setCampaignMembers()
     * @uses Lead::setCity()
     * @uses Lead::setCombinedAttachments()
     * @uses Lead::setCompany()
     * @uses Lead::setContactRequests()
     * @uses Lead::setContentDocumentLinks()
     * @uses Lead::setConvertedAccount()
     * @uses Lead::setConvertedAccountId()
     * @uses Lead::setConvertedContact()
     * @uses Lead::setConvertedContactId()
     * @uses Lead::setConvertedDate()
     * @uses Lead::setConvertedOpportunity()
     * @uses Lead::setConvertedOpportunityId()
     * @uses Lead::setCountry()
     * @uses Lead::setCreatedBy()
     * @uses Lead::setCreatedById()
     * @uses Lead::setCreatedDate()
     * @uses Lead::setDB_Created_Date_without_Time__c()
     * @uses Lead::setDB_Lead_Age__c()
     * @uses Lead::setDeclinedEventRelations()
     * @uses Lead::setDuplicateRecordItems()
     * @uses Lead::setEmail()
     * @uses Lead::setEmailBouncedDate()
     * @uses Lead::setEmailBouncedReason()
     * @uses Lead::setEmailMessageRelations()
     * @uses Lead::setEmailStatuses()
     * @uses Lead::setEventRelations()
     * @uses Lead::setEventWhoRelations()
     * @uses Lead::setEvents()
     * @uses Lead::setFeedSubscriptionsForEntity()
     * @uses Lead::setFeeds()
     * @uses Lead::setFirstName()
     * @uses Lead::setGeocodeAccuracy()
     * @uses Lead::setHistories()
     * @uses Lead::setIndividual()
     * @uses Lead::setIndividualId()
     * @uses Lead::setIndustry()
     * @uses Lead::setIsConverted()
     * @uses Lead::setIsDeleted()
     * @uses Lead::setIsUnreadByOwner()
     * @uses Lead::setJigsaw()
     * @uses Lead::setJigsawContactId()
     * @uses Lead::setLastActivityDate()
     * @uses Lead::setLastModifiedBy()
     * @uses Lead::setLastModifiedById()
     * @uses Lead::setLastModifiedDate()
     * @uses Lead::setLastName()
     * @uses Lead::setLastReferencedDate()
     * @uses Lead::setLastViewedDate()
     * @uses Lead::setLatitude()
     * @uses Lead::setLeadSource()
     * @uses Lead::setListEmailIndividualRecipients()
     * @uses Lead::setLongitude()
     * @uses Lead::setLookedUpFromActivities()
     * @uses Lead::setMasterRecord()
     * @uses Lead::setMasterRecordId()
     * @uses Lead::setMiddleName()
     * @uses Lead::setMobilePhone()
     * @uses Lead::setName()
     * @uses Lead::setNotes()
     * @uses Lead::setNotesAndAttachments()
     * @uses Lead::setNumberOfEmployees()
     * @uses Lead::setOpenActivities()
     * @uses Lead::setOutgoingEmailRelations()
     * @uses Lead::setOwner()
     * @uses Lead::setOwnerId()
     * @uses Lead::setParentEntities()
     * @uses Lead::setPersonRecord()
     * @uses Lead::setPersonas()
     * @uses Lead::setPhone()
     * @uses Lead::setPhotoUrl()
     * @uses Lead::setPostalCode()
     * @uses Lead::setPosts()
     * @uses Lead::setProcessInstances()
     * @uses Lead::setProcessSteps()
     * @uses Lead::setRating()
     * @uses Lead::setRecordActionHistories()
     * @uses Lead::setRecordActions()
     * @uses Lead::setRecordAssociatedGroups()
     * @uses Lead::setSalutation()
     * @uses Lead::setShares()
     * @uses Lead::setState()
     * @uses Lead::setStatus()
     * @uses Lead::setStreet()
     * @uses Lead::setSuffix()
     * @uses Lead::setSystemModstamp()
     * @uses Lead::setTaskRelations()
     * @uses Lead::setTaskWhoRelations()
     * @uses Lead::setTasks()
     * @uses Lead::setTitle()
     * @uses Lead::setTopicAssignments()
     * @uses Lead::setUndecidedEventRelations()
     * @uses Lead::setUserRecordAccess()
     * @uses Lead::setWebsite()
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $acceptedEventRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $activityHistories
     * @param \NexusDigital/MiratelForce\StructType\Address $address
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @param \NexusDigital/MiratelForce\StructType\Campaign $campaign
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers
     * @param string $city
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param string $company
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contactRequests
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\Account $convertedAccount
     * @param string $convertedAccountId
     * @param \NexusDigital/MiratelForce\StructType\Contact $convertedContact
     * @param string $convertedContactId
     * @param string $convertedDate
     * @param \NexusDigital/MiratelForce\StructType\Opportunity $convertedOpportunity
     * @param string $convertedOpportunityId
     * @param string $country
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $dB_Created_Date_without_Time__c
     * @param float $dB_Lead_Age__c
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $declinedEventRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems
     * @param string $email
     * @param string $emailBouncedDate
     * @param string $emailBouncedReason
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emailStatuses
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventWhoRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $events
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @param string $firstName
     * @param string $geocodeAccuracy
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @param \NexusDigital/MiratelForce\StructType\Individual $individual
     * @param string $individualId
     * @param string $industry
     * @param bool $isConverted
     * @param bool $isDeleted
     * @param bool $isUnreadByOwner
     * @param string $jigsaw
     * @param string $jigsawContactId
     * @param string $lastActivityDate
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastName
     * @param string $lastReferencedDate
     * @param string $lastViewedDate
     * @param float $latitude
     * @param string $leadSource
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $listEmailIndividualRecipients
     * @param float $longitude
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities
     * @param \NexusDigital/MiratelForce\StructType\Lead $masterRecord
     * @param string $masterRecordId
     * @param string $middleName
     * @param string $mobilePhone
     * @param string $name
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments
     * @param int $numberOfEmployees
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $openActivities
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @param string $ownerId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $personRecord
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $personas
     * @param string $phone
     * @param string $photoUrl
     * @param string $postalCode
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $posts
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @param string $rating
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups
     * @param string $salutation
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $shares
     * @param string $state
     * @param string $status
     * @param string $street
     * @param string $suffix
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskWhoRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $tasks
     * @param string $title
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $undecidedEventRelations
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @param string $website
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\QueryResult $acceptedEventRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $activityHistories = null, \NexusDigital/MiratelForce\StructType\Address $address = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachments = null, \NexusDigital/MiratelForce\StructType\Campaign $campaign = null, \NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers = null, $city = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, $company = null, \NexusDigital/MiratelForce\StructType\QueryResult $contactRequests = null, \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\Account $convertedAccount = null, $convertedAccountId = null, \NexusDigital/MiratelForce\StructType\Contact $convertedContact = null, $convertedContactId = null, $convertedDate = null, \NexusDigital/MiratelForce\StructType\Opportunity $convertedOpportunity = null, $convertedOpportunityId = null, $country = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $dB_Created_Date_without_Time__c = null, $dB_Lead_Age__c = null, \NexusDigital/MiratelForce\StructType\QueryResult $declinedEventRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems = null, $email = null, $emailBouncedDate = null, $emailBouncedReason = null, \NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $emailStatuses = null, \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $eventWhoRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $events = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null, \NexusDigital/MiratelForce\StructType\QueryResult $feeds = null, $firstName = null, $geocodeAccuracy = null, \NexusDigital/MiratelForce\StructType\QueryResult $histories = null, \NexusDigital/MiratelForce\StructType\Individual $individual = null, $individualId = null, $industry = null, $isConverted = null, $isDeleted = null, $isUnreadByOwner = null, $jigsaw = null, $jigsawContactId = null, $lastActivityDate = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastName = null, $lastReferencedDate = null, $lastViewedDate = null, $latitude = null, $leadSource = null, \NexusDigital/MiratelForce\StructType\QueryResult $listEmailIndividualRecipients = null, $longitude = null, \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities = null, \NexusDigital/MiratelForce\StructType\Lead $masterRecord = null, $masterRecordId = null, $middleName = null, $mobilePhone = null, $name = null, \NexusDigital/MiratelForce\StructType\QueryResult $notes = null, \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments = null, $numberOfEmployees = null, \NexusDigital/MiratelForce\StructType\QueryResult $openActivities = null, \NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations = null, \NexusDigital/MiratelForce\StructType\SObject $owner = null, $ownerId = null, \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null, \NexusDigital/MiratelForce\StructType\QueryResult $personRecord = null, \NexusDigital/MiratelForce\StructType\QueryResult $personas = null, $phone = null, $photoUrl = null, $postalCode = null, \NexusDigital/MiratelForce\StructType\QueryResult $posts = null, \NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null, \NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null, $rating = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups = null, $salutation = null, \NexusDigital/MiratelForce\StructType\QueryResult $shares = null, $state = null, $status = null, $street = null, $suffix = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $taskWhoRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $tasks = null, $title = null, \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null, \NexusDigital/MiratelForce\StructType\QueryResult $undecidedEventRelations = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null, $website = null)
    {
        $this
            ->setAcceptedEventRelations($acceptedEventRelations)
            ->setActivityHistories($activityHistories)
            ->setAddress($address)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setAttachments($attachments)
            ->setCampaign($campaign)
            ->setCampaignMembers($campaignMembers)
            ->setCity($city)
            ->setCombinedAttachments($combinedAttachments)
            ->setCompany($company)
            ->setContactRequests($contactRequests)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setConvertedAccount($convertedAccount)
            ->setConvertedAccountId($convertedAccountId)
            ->setConvertedContact($convertedContact)
            ->setConvertedContactId($convertedContactId)
            ->setConvertedDate($convertedDate)
            ->setConvertedOpportunity($convertedOpportunity)
            ->setConvertedOpportunityId($convertedOpportunityId)
            ->setCountry($country)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDB_Created_Date_without_Time__c($dB_Created_Date_without_Time__c)
            ->setDB_Lead_Age__c($dB_Lead_Age__c)
            ->setDeclinedEventRelations($declinedEventRelations)
            ->setDuplicateRecordItems($duplicateRecordItems)
            ->setEmail($email)
            ->setEmailBouncedDate($emailBouncedDate)
            ->setEmailBouncedReason($emailBouncedReason)
            ->setEmailMessageRelations($emailMessageRelations)
            ->setEmailStatuses($emailStatuses)
            ->setEventRelations($eventRelations)
            ->setEventWhoRelations($eventWhoRelations)
            ->setEvents($events)
            ->setFeedSubscriptionsForEntity($feedSubscriptionsForEntity)
            ->setFeeds($feeds)
            ->setFirstName($firstName)
            ->setGeocodeAccuracy($geocodeAccuracy)
            ->setHistories($histories)
            ->setIndividual($individual)
            ->setIndividualId($individualId)
            ->setIndustry($industry)
            ->setIsConverted($isConverted)
            ->setIsDeleted($isDeleted)
            ->setIsUnreadByOwner($isUnreadByOwner)
            ->setJigsaw($jigsaw)
            ->setJigsawContactId($jigsawContactId)
            ->setLastActivityDate($lastActivityDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastName($lastName)
            ->setLastReferencedDate($lastReferencedDate)
            ->setLastViewedDate($lastViewedDate)
            ->setLatitude($latitude)
            ->setLeadSource($leadSource)
            ->setListEmailIndividualRecipients($listEmailIndividualRecipients)
            ->setLongitude($longitude)
            ->setLookedUpFromActivities($lookedUpFromActivities)
            ->setMasterRecord($masterRecord)
            ->setMasterRecordId($masterRecordId)
            ->setMiddleName($middleName)
            ->setMobilePhone($mobilePhone)
            ->setName($name)
            ->setNotes($notes)
            ->setNotesAndAttachments($notesAndAttachments)
            ->setNumberOfEmployees($numberOfEmployees)
            ->setOpenActivities($openActivities)
            ->setOutgoingEmailRelations($outgoingEmailRelations)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setParentEntities($parentEntities)
            ->setPersonRecord($personRecord)
            ->setPersonas($personas)
            ->setPhone($phone)
            ->setPhotoUrl($photoUrl)
            ->setPostalCode($postalCode)
            ->setPosts($posts)
            ->setProcessInstances($processInstances)
            ->setProcessSteps($processSteps)
            ->setRating($rating)
            ->setRecordActionHistories($recordActionHistories)
            ->setRecordActions($recordActions)
            ->setRecordAssociatedGroups($recordAssociatedGroups)
            ->setSalutation($salutation)
            ->setShares($shares)
            ->setState($state)
            ->setStatus($status)
            ->setStreet($street)
            ->setSuffix($suffix)
            ->setSystemModstamp($systemModstamp)
            ->setTaskRelations($taskRelations)
            ->setTaskWhoRelations($taskWhoRelations)
            ->setTasks($tasks)
            ->setTitle($title)
            ->setTopicAssignments($topicAssignments)
            ->setUndecidedEventRelations($undecidedEventRelations)
            ->setUserRecordAccess($userRecordAccess)
            ->setWebsite($website);
    }
    /**
     * Get AcceptedEventRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAcceptedEventRelations()
    {
        return isset($this->AcceptedEventRelations) ? $this->AcceptedEventRelations : null;
    }
    /**
     * Set AcceptedEventRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $acceptedEventRelations
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setAcceptedEventRelations(\NexusDigital/MiratelForce\StructType\QueryResult $acceptedEventRelations = null)
    {
        if (is_null($acceptedEventRelations) || (is_array($acceptedEventRelations) && empty($acceptedEventRelations))) {
            unset($this->AcceptedEventRelations);
        } else {
            $this->AcceptedEventRelations = $acceptedEventRelations;
        }
        return $this;
    }
    /**
     * Get ActivityHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getActivityHistories()
    {
        return isset($this->ActivityHistories) ? $this->ActivityHistories : null;
    }
    /**
     * Set ActivityHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $activityHistories
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setActivityHistories(\NexusDigital/MiratelForce\StructType\QueryResult $activityHistories = null)
    {
        if (is_null($activityHistories) || (is_array($activityHistories) && empty($activityHistories))) {
            unset($this->ActivityHistories);
        } else {
            $this->ActivityHistories = $activityHistories;
        }
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Address|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Address $address
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setAddress(\NexusDigital/MiratelForce\StructType\Address $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get Attachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachments()
    {
        return isset($this->Attachments) ? $this->Attachments : null;
    }
    /**
     * Set Attachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $attachments = null)
    {
        if (is_null($attachments) || (is_array($attachments) && empty($attachments))) {
            unset($this->Attachments);
        } else {
            $this->Attachments = $attachments;
        }
        return $this;
    }
    /**
     * Get Campaign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Campaign|null
     */
    public function getCampaign()
    {
        return isset($this->Campaign) ? $this->Campaign : null;
    }
    /**
     * Set Campaign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Campaign $campaign
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setCampaign(\NexusDigital/MiratelForce\StructType\Campaign $campaign = null)
    {
        if (is_null($campaign) || (is_array($campaign) && empty($campaign))) {
            unset($this->Campaign);
        } else {
            $this->Campaign = $campaign;
        }
        return $this;
    }
    /**
     * Get CampaignMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCampaignMembers()
    {
        return isset($this->CampaignMembers) ? $this->CampaignMembers : null;
    }
    /**
     * Set CampaignMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setCampaignMembers(\NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers = null)
    {
        if (is_null($campaignMembers) || (is_array($campaignMembers) && empty($campaignMembers))) {
            unset($this->CampaignMembers);
        } else {
            $this->CampaignMembers = $campaignMembers;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $company
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get ContactRequests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContactRequests()
    {
        return isset($this->ContactRequests) ? $this->ContactRequests : null;
    }
    /**
     * Set ContactRequests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contactRequests
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setContactRequests(\NexusDigital/MiratelForce\StructType\QueryResult $contactRequests = null)
    {
        if (is_null($contactRequests) || (is_array($contactRequests) && empty($contactRequests))) {
            unset($this->ContactRequests);
        } else {
            $this->ContactRequests = $contactRequests;
        }
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get ConvertedAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Account|null
     */
    public function getConvertedAccount()
    {
        return isset($this->ConvertedAccount) ? $this->ConvertedAccount : null;
    }
    /**
     * Set ConvertedAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Account $convertedAccount
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setConvertedAccount(\NexusDigital/MiratelForce\StructType\Account $convertedAccount = null)
    {
        if (is_null($convertedAccount) || (is_array($convertedAccount) && empty($convertedAccount))) {
            unset($this->ConvertedAccount);
        } else {
            $this->ConvertedAccount = $convertedAccount;
        }
        return $this;
    }
    /**
     * Get ConvertedAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConvertedAccountId()
    {
        return isset($this->ConvertedAccountId) ? $this->ConvertedAccountId : null;
    }
    /**
     * Set ConvertedAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $convertedAccountId
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setConvertedAccountId($convertedAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($convertedAccountId) && !is_string($convertedAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($convertedAccountId, true), gettype($convertedAccountId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($convertedAccountId) && mb_strlen($convertedAccountId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($convertedAccountId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($convertedAccountId) && !preg_match('/[a-zA-Z0-9]{18}/', $convertedAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($convertedAccountId, true)), __LINE__);
        }
        if (is_null($convertedAccountId) || (is_array($convertedAccountId) && empty($convertedAccountId))) {
            unset($this->ConvertedAccountId);
        } else {
            $this->ConvertedAccountId = $convertedAccountId;
        }
        return $this;
    }
    /**
     * Get ConvertedContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Contact|null
     */
    public function getConvertedContact()
    {
        return isset($this->ConvertedContact) ? $this->ConvertedContact : null;
    }
    /**
     * Set ConvertedContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Contact $convertedContact
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setConvertedContact(\NexusDigital/MiratelForce\StructType\Contact $convertedContact = null)
    {
        if (is_null($convertedContact) || (is_array($convertedContact) && empty($convertedContact))) {
            unset($this->ConvertedContact);
        } else {
            $this->ConvertedContact = $convertedContact;
        }
        return $this;
    }
    /**
     * Get ConvertedContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConvertedContactId()
    {
        return isset($this->ConvertedContactId) ? $this->ConvertedContactId : null;
    }
    /**
     * Set ConvertedContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $convertedContactId
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setConvertedContactId($convertedContactId = null)
    {
        // validation for constraint: string
        if (!is_null($convertedContactId) && !is_string($convertedContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($convertedContactId, true), gettype($convertedContactId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($convertedContactId) && mb_strlen($convertedContactId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($convertedContactId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($convertedContactId) && !preg_match('/[a-zA-Z0-9]{18}/', $convertedContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($convertedContactId, true)), __LINE__);
        }
        if (is_null($convertedContactId) || (is_array($convertedContactId) && empty($convertedContactId))) {
            unset($this->ConvertedContactId);
        } else {
            $this->ConvertedContactId = $convertedContactId;
        }
        return $this;
    }
    /**
     * Get ConvertedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConvertedDate()
    {
        return isset($this->ConvertedDate) ? $this->ConvertedDate : null;
    }
    /**
     * Set ConvertedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $convertedDate
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setConvertedDate($convertedDate = null)
    {
        // validation for constraint: string
        if (!is_null($convertedDate) && !is_string($convertedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($convertedDate, true), gettype($convertedDate)), __LINE__);
        }
        if (is_null($convertedDate) || (is_array($convertedDate) && empty($convertedDate))) {
            unset($this->ConvertedDate);
        } else {
            $this->ConvertedDate = $convertedDate;
        }
        return $this;
    }
    /**
     * Get ConvertedOpportunity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Opportunity|null
     */
    public function getConvertedOpportunity()
    {
        return isset($this->ConvertedOpportunity) ? $this->ConvertedOpportunity : null;
    }
    /**
     * Set ConvertedOpportunity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Opportunity $convertedOpportunity
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setConvertedOpportunity(\NexusDigital/MiratelForce\StructType\Opportunity $convertedOpportunity = null)
    {
        if (is_null($convertedOpportunity) || (is_array($convertedOpportunity) && empty($convertedOpportunity))) {
            unset($this->ConvertedOpportunity);
        } else {
            $this->ConvertedOpportunity = $convertedOpportunity;
        }
        return $this;
    }
    /**
     * Get ConvertedOpportunityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConvertedOpportunityId()
    {
        return isset($this->ConvertedOpportunityId) ? $this->ConvertedOpportunityId : null;
    }
    /**
     * Set ConvertedOpportunityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $convertedOpportunityId
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setConvertedOpportunityId($convertedOpportunityId = null)
    {
        // validation for constraint: string
        if (!is_null($convertedOpportunityId) && !is_string($convertedOpportunityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($convertedOpportunityId, true), gettype($convertedOpportunityId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($convertedOpportunityId) && mb_strlen($convertedOpportunityId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($convertedOpportunityId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($convertedOpportunityId) && !preg_match('/[a-zA-Z0-9]{18}/', $convertedOpportunityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($convertedOpportunityId, true)), __LINE__);
        }
        if (is_null($convertedOpportunityId) || (is_array($convertedOpportunityId) && empty($convertedOpportunityId))) {
            unset($this->ConvertedOpportunityId);
        } else {
            $this->ConvertedOpportunityId = $convertedOpportunityId;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DB_Created_Date_without_Time__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDB_Created_Date_without_Time__c()
    {
        return isset($this->DB_Created_Date_without_Time__c) ? $this->DB_Created_Date_without_Time__c : null;
    }
    /**
     * Set DB_Created_Date_without_Time__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dB_Created_Date_without_Time__c
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setDB_Created_Date_without_Time__c($dB_Created_Date_without_Time__c = null)
    {
        // validation for constraint: string
        if (!is_null($dB_Created_Date_without_Time__c) && !is_string($dB_Created_Date_without_Time__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dB_Created_Date_without_Time__c, true), gettype($dB_Created_Date_without_Time__c)), __LINE__);
        }
        if (is_null($dB_Created_Date_without_Time__c) || (is_array($dB_Created_Date_without_Time__c) && empty($dB_Created_Date_without_Time__c))) {
            unset($this->DB_Created_Date_without_Time__c);
        } else {
            $this->DB_Created_Date_without_Time__c = $dB_Created_Date_without_Time__c;
        }
        return $this;
    }
    /**
     * Get DB_Lead_Age__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDB_Lead_Age__c()
    {
        return isset($this->DB_Lead_Age__c) ? $this->DB_Lead_Age__c : null;
    }
    /**
     * Set DB_Lead_Age__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dB_Lead_Age__c
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setDB_Lead_Age__c($dB_Lead_Age__c = null)
    {
        // validation for constraint: float
        if (!is_null($dB_Lead_Age__c) && !(is_float($dB_Lead_Age__c) || is_numeric($dB_Lead_Age__c))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dB_Lead_Age__c, true), gettype($dB_Lead_Age__c)), __LINE__);
        }
        if (is_null($dB_Lead_Age__c) || (is_array($dB_Lead_Age__c) && empty($dB_Lead_Age__c))) {
            unset($this->DB_Lead_Age__c);
        } else {
            $this->DB_Lead_Age__c = $dB_Lead_Age__c;
        }
        return $this;
    }
    /**
     * Get DeclinedEventRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getDeclinedEventRelations()
    {
        return isset($this->DeclinedEventRelations) ? $this->DeclinedEventRelations : null;
    }
    /**
     * Set DeclinedEventRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $declinedEventRelations
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setDeclinedEventRelations(\NexusDigital/MiratelForce\StructType\QueryResult $declinedEventRelations = null)
    {
        if (is_null($declinedEventRelations) || (is_array($declinedEventRelations) && empty($declinedEventRelations))) {
            unset($this->DeclinedEventRelations);
        } else {
            $this->DeclinedEventRelations = $declinedEventRelations;
        }
        return $this;
    }
    /**
     * Get DuplicateRecordItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getDuplicateRecordItems()
    {
        return isset($this->DuplicateRecordItems) ? $this->DuplicateRecordItems : null;
    }
    /**
     * Set DuplicateRecordItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setDuplicateRecordItems(\NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems = null)
    {
        if (is_null($duplicateRecordItems) || (is_array($duplicateRecordItems) && empty($duplicateRecordItems))) {
            unset($this->DuplicateRecordItems);
        } else {
            $this->DuplicateRecordItems = $duplicateRecordItems;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get EmailBouncedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBouncedDate()
    {
        return isset($this->EmailBouncedDate) ? $this->EmailBouncedDate : null;
    }
    /**
     * Set EmailBouncedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBouncedDate
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setEmailBouncedDate($emailBouncedDate = null)
    {
        // validation for constraint: string
        if (!is_null($emailBouncedDate) && !is_string($emailBouncedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBouncedDate, true), gettype($emailBouncedDate)), __LINE__);
        }
        if (is_null($emailBouncedDate) || (is_array($emailBouncedDate) && empty($emailBouncedDate))) {
            unset($this->EmailBouncedDate);
        } else {
            $this->EmailBouncedDate = $emailBouncedDate;
        }
        return $this;
    }
    /**
     * Get EmailBouncedReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBouncedReason()
    {
        return isset($this->EmailBouncedReason) ? $this->EmailBouncedReason : null;
    }
    /**
     * Set EmailBouncedReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBouncedReason
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setEmailBouncedReason($emailBouncedReason = null)
    {
        // validation for constraint: string
        if (!is_null($emailBouncedReason) && !is_string($emailBouncedReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBouncedReason, true), gettype($emailBouncedReason)), __LINE__);
        }
        if (is_null($emailBouncedReason) || (is_array($emailBouncedReason) && empty($emailBouncedReason))) {
            unset($this->EmailBouncedReason);
        } else {
            $this->EmailBouncedReason = $emailBouncedReason;
        }
        return $this;
    }
    /**
     * Get EmailMessageRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEmailMessageRelations()
    {
        return isset($this->EmailMessageRelations) ? $this->EmailMessageRelations : null;
    }
    /**
     * Set EmailMessageRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setEmailMessageRelations(\NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations = null)
    {
        if (is_null($emailMessageRelations) || (is_array($emailMessageRelations) && empty($emailMessageRelations))) {
            unset($this->EmailMessageRelations);
        } else {
            $this->EmailMessageRelations = $emailMessageRelations;
        }
        return $this;
    }
    /**
     * Get EmailStatuses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEmailStatuses()
    {
        return isset($this->EmailStatuses) ? $this->EmailStatuses : null;
    }
    /**
     * Set EmailStatuses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emailStatuses
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setEmailStatuses(\NexusDigital/MiratelForce\StructType\QueryResult $emailStatuses = null)
    {
        if (is_null($emailStatuses) || (is_array($emailStatuses) && empty($emailStatuses))) {
            unset($this->EmailStatuses);
        } else {
            $this->EmailStatuses = $emailStatuses;
        }
        return $this;
    }
    /**
     * Get EventRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEventRelations()
    {
        return isset($this->EventRelations) ? $this->EventRelations : null;
    }
    /**
     * Set EventRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setEventRelations(\NexusDigital/MiratelForce\StructType\QueryResult $eventRelations = null)
    {
        if (is_null($eventRelations) || (is_array($eventRelations) && empty($eventRelations))) {
            unset($this->EventRelations);
        } else {
            $this->EventRelations = $eventRelations;
        }
        return $this;
    }
    /**
     * Get EventWhoRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEventWhoRelations()
    {
        return isset($this->EventWhoRelations) ? $this->EventWhoRelations : null;
    }
    /**
     * Set EventWhoRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventWhoRelations
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setEventWhoRelations(\NexusDigital/MiratelForce\StructType\QueryResult $eventWhoRelations = null)
    {
        if (is_null($eventWhoRelations) || (is_array($eventWhoRelations) && empty($eventWhoRelations))) {
            unset($this->EventWhoRelations);
        } else {
            $this->EventWhoRelations = $eventWhoRelations;
        }
        return $this;
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $events
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setEvents(\NexusDigital/MiratelForce\StructType\QueryResult $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get FeedSubscriptionsForEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedSubscriptionsForEntity()
    {
        return isset($this->FeedSubscriptionsForEntity) ? $this->FeedSubscriptionsForEntity : null;
    }
    /**
     * Set FeedSubscriptionsForEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setFeedSubscriptionsForEntity(\NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null)
    {
        if (is_null($feedSubscriptionsForEntity) || (is_array($feedSubscriptionsForEntity) && empty($feedSubscriptionsForEntity))) {
            unset($this->FeedSubscriptionsForEntity);
        } else {
            $this->FeedSubscriptionsForEntity = $feedSubscriptionsForEntity;
        }
        return $this;
    }
    /**
     * Get Feeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeeds()
    {
        return isset($this->Feeds) ? $this->Feeds : null;
    }
    /**
     * Set Feeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setFeeds(\NexusDigital/MiratelForce\StructType\QueryResult $feeds = null)
    {
        if (is_null($feeds) || (is_array($feeds) && empty($feeds))) {
            unset($this->Feeds);
        } else {
            $this->Feeds = $feeds;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get GeocodeAccuracy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeocodeAccuracy()
    {
        return isset($this->GeocodeAccuracy) ? $this->GeocodeAccuracy : null;
    }
    /**
     * Set GeocodeAccuracy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geocodeAccuracy
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setGeocodeAccuracy($geocodeAccuracy = null)
    {
        // validation for constraint: string
        if (!is_null($geocodeAccuracy) && !is_string($geocodeAccuracy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geocodeAccuracy, true), gettype($geocodeAccuracy)), __LINE__);
        }
        if (is_null($geocodeAccuracy) || (is_array($geocodeAccuracy) && empty($geocodeAccuracy))) {
            unset($this->GeocodeAccuracy);
        } else {
            $this->GeocodeAccuracy = $geocodeAccuracy;
        }
        return $this;
    }
    /**
     * Get Histories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getHistories()
    {
        return isset($this->Histories) ? $this->Histories : null;
    }
    /**
     * Set Histories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setHistories(\NexusDigital/MiratelForce\StructType\QueryResult $histories = null)
    {
        if (is_null($histories) || (is_array($histories) && empty($histories))) {
            unset($this->Histories);
        } else {
            $this->Histories = $histories;
        }
        return $this;
    }
    /**
     * Get Individual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Individual|null
     */
    public function getIndividual()
    {
        return isset($this->Individual) ? $this->Individual : null;
    }
    /**
     * Set Individual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Individual $individual
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setIndividual(\NexusDigital/MiratelForce\StructType\Individual $individual = null)
    {
        if (is_null($individual) || (is_array($individual) && empty($individual))) {
            unset($this->Individual);
        } else {
            $this->Individual = $individual;
        }
        return $this;
    }
    /**
     * Get IndividualId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndividualId()
    {
        return isset($this->IndividualId) ? $this->IndividualId : null;
    }
    /**
     * Set IndividualId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $individualId
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setIndividualId($individualId = null)
    {
        // validation for constraint: string
        if (!is_null($individualId) && !is_string($individualId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualId, true), gettype($individualId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($individualId) && mb_strlen($individualId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($individualId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($individualId) && !preg_match('/[a-zA-Z0-9]{18}/', $individualId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($individualId, true)), __LINE__);
        }
        if (is_null($individualId) || (is_array($individualId) && empty($individualId))) {
            unset($this->IndividualId);
        } else {
            $this->IndividualId = $individualId;
        }
        return $this;
    }
    /**
     * Get Industry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndustry()
    {
        return isset($this->Industry) ? $this->Industry : null;
    }
    /**
     * Set Industry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $industry
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setIndustry($industry = null)
    {
        // validation for constraint: string
        if (!is_null($industry) && !is_string($industry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($industry, true), gettype($industry)), __LINE__);
        }
        if (is_null($industry) || (is_array($industry) && empty($industry))) {
            unset($this->Industry);
        } else {
            $this->Industry = $industry;
        }
        return $this;
    }
    /**
     * Get IsConverted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConverted()
    {
        return isset($this->IsConverted) ? $this->IsConverted : null;
    }
    /**
     * Set IsConverted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConverted
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setIsConverted($isConverted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConverted) && !is_bool($isConverted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConverted, true), gettype($isConverted)), __LINE__);
        }
        if (is_null($isConverted) || (is_array($isConverted) && empty($isConverted))) {
            unset($this->IsConverted);
        } else {
            $this->IsConverted = $isConverted;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsUnreadByOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUnreadByOwner()
    {
        return isset($this->IsUnreadByOwner) ? $this->IsUnreadByOwner : null;
    }
    /**
     * Set IsUnreadByOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUnreadByOwner
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setIsUnreadByOwner($isUnreadByOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUnreadByOwner) && !is_bool($isUnreadByOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUnreadByOwner, true), gettype($isUnreadByOwner)), __LINE__);
        }
        if (is_null($isUnreadByOwner) || (is_array($isUnreadByOwner) && empty($isUnreadByOwner))) {
            unset($this->IsUnreadByOwner);
        } else {
            $this->IsUnreadByOwner = $isUnreadByOwner;
        }
        return $this;
    }
    /**
     * Get Jigsaw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJigsaw()
    {
        return isset($this->Jigsaw) ? $this->Jigsaw : null;
    }
    /**
     * Set Jigsaw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jigsaw
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setJigsaw($jigsaw = null)
    {
        // validation for constraint: string
        if (!is_null($jigsaw) && !is_string($jigsaw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jigsaw, true), gettype($jigsaw)), __LINE__);
        }
        if (is_null($jigsaw) || (is_array($jigsaw) && empty($jigsaw))) {
            unset($this->Jigsaw);
        } else {
            $this->Jigsaw = $jigsaw;
        }
        return $this;
    }
    /**
     * Get JigsawContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJigsawContactId()
    {
        return isset($this->JigsawContactId) ? $this->JigsawContactId : null;
    }
    /**
     * Set JigsawContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jigsawContactId
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setJigsawContactId($jigsawContactId = null)
    {
        // validation for constraint: string
        if (!is_null($jigsawContactId) && !is_string($jigsawContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jigsawContactId, true), gettype($jigsawContactId)), __LINE__);
        }
        if (is_null($jigsawContactId) || (is_array($jigsawContactId) && empty($jigsawContactId))) {
            unset($this->JigsawContactId);
        } else {
            $this->JigsawContactId = $jigsawContactId;
        }
        return $this;
    }
    /**
     * Get LastActivityDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastActivityDate()
    {
        return isset($this->LastActivityDate) ? $this->LastActivityDate : null;
    }
    /**
     * Set LastActivityDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastActivityDate
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLastActivityDate($lastActivityDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastActivityDate) && !is_string($lastActivityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActivityDate, true), gettype($lastActivityDate)), __LINE__);
        }
        if (is_null($lastActivityDate) || (is_array($lastActivityDate) && empty($lastActivityDate))) {
            unset($this->LastActivityDate);
        } else {
            $this->LastActivityDate = $lastActivityDate;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get LastReferencedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastReferencedDate()
    {
        return isset($this->LastReferencedDate) ? $this->LastReferencedDate : null;
    }
    /**
     * Set LastReferencedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastReferencedDate
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLastReferencedDate($lastReferencedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReferencedDate) && !is_string($lastReferencedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastReferencedDate, true), gettype($lastReferencedDate)), __LINE__);
        }
        if (is_null($lastReferencedDate) || (is_array($lastReferencedDate) && empty($lastReferencedDate))) {
            unset($this->LastReferencedDate);
        } else {
            $this->LastReferencedDate = $lastReferencedDate;
        }
        return $this;
    }
    /**
     * Get LastViewedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastViewedDate()
    {
        return isset($this->LastViewedDate) ? $this->LastViewedDate : null;
    }
    /**
     * Set LastViewedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastViewedDate
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLastViewedDate($lastViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastViewedDate) && !is_string($lastViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastViewedDate, true), gettype($lastViewedDate)), __LINE__);
        }
        if (is_null($lastViewedDate) || (is_array($lastViewedDate) && empty($lastViewedDate))) {
            unset($this->LastViewedDate);
        } else {
            $this->LastViewedDate = $lastViewedDate;
        }
        return $this;
    }
    /**
     * Get Latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLatitude()
    {
        return isset($this->Latitude) ? $this->Latitude : null;
    }
    /**
     * Set Latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $latitude
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        if (is_null($latitude) || (is_array($latitude) && empty($latitude))) {
            unset($this->Latitude);
        } else {
            $this->Latitude = $latitude;
        }
        return $this;
    }
    /**
     * Get LeadSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadSource()
    {
        return isset($this->LeadSource) ? $this->LeadSource : null;
    }
    /**
     * Set LeadSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadSource
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLeadSource($leadSource = null)
    {
        // validation for constraint: string
        if (!is_null($leadSource) && !is_string($leadSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadSource, true), gettype($leadSource)), __LINE__);
        }
        if (is_null($leadSource) || (is_array($leadSource) && empty($leadSource))) {
            unset($this->LeadSource);
        } else {
            $this->LeadSource = $leadSource;
        }
        return $this;
    }
    /**
     * Get ListEmailIndividualRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getListEmailIndividualRecipients()
    {
        return isset($this->ListEmailIndividualRecipients) ? $this->ListEmailIndividualRecipients : null;
    }
    /**
     * Set ListEmailIndividualRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $listEmailIndividualRecipients
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setListEmailIndividualRecipients(\NexusDigital/MiratelForce\StructType\QueryResult $listEmailIndividualRecipients = null)
    {
        if (is_null($listEmailIndividualRecipients) || (is_array($listEmailIndividualRecipients) && empty($listEmailIndividualRecipients))) {
            unset($this->ListEmailIndividualRecipients);
        } else {
            $this->ListEmailIndividualRecipients = $listEmailIndividualRecipients;
        }
        return $this;
    }
    /**
     * Get Longitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongitude()
    {
        return isset($this->Longitude) ? $this->Longitude : null;
    }
    /**
     * Set Longitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longitude
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        if (is_null($longitude) || (is_array($longitude) && empty($longitude))) {
            unset($this->Longitude);
        } else {
            $this->Longitude = $longitude;
        }
        return $this;
    }
    /**
     * Get LookedUpFromActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getLookedUpFromActivities()
    {
        return isset($this->LookedUpFromActivities) ? $this->LookedUpFromActivities : null;
    }
    /**
     * Set LookedUpFromActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setLookedUpFromActivities(\NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities = null)
    {
        if (is_null($lookedUpFromActivities) || (is_array($lookedUpFromActivities) && empty($lookedUpFromActivities))) {
            unset($this->LookedUpFromActivities);
        } else {
            $this->LookedUpFromActivities = $lookedUpFromActivities;
        }
        return $this;
    }
    /**
     * Get MasterRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Lead|null
     */
    public function getMasterRecord()
    {
        return isset($this->MasterRecord) ? $this->MasterRecord : null;
    }
    /**
     * Set MasterRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Lead $masterRecord
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setMasterRecord(\NexusDigital/MiratelForce\StructType\Lead $masterRecord = null)
    {
        if (is_null($masterRecord) || (is_array($masterRecord) && empty($masterRecord))) {
            unset($this->MasterRecord);
        } else {
            $this->MasterRecord = $masterRecord;
        }
        return $this;
    }
    /**
     * Get MasterRecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterRecordId()
    {
        return isset($this->MasterRecordId) ? $this->MasterRecordId : null;
    }
    /**
     * Set MasterRecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterRecordId
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setMasterRecordId($masterRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($masterRecordId) && !is_string($masterRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterRecordId, true), gettype($masterRecordId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($masterRecordId) && mb_strlen($masterRecordId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($masterRecordId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($masterRecordId) && !preg_match('/[a-zA-Z0-9]{18}/', $masterRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($masterRecordId, true)), __LINE__);
        }
        if (is_null($masterRecordId) || (is_array($masterRecordId) && empty($masterRecordId))) {
            unset($this->MasterRecordId);
        } else {
            $this->MasterRecordId = $masterRecordId;
        }
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notes
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setNotes(\NexusDigital/MiratelForce\StructType\QueryResult $notes = null)
    {
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get NotesAndAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNotesAndAttachments()
    {
        return isset($this->NotesAndAttachments) ? $this->NotesAndAttachments : null;
    }
    /**
     * Set NotesAndAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setNotesAndAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments = null)
    {
        if (is_null($notesAndAttachments) || (is_array($notesAndAttachments) && empty($notesAndAttachments))) {
            unset($this->NotesAndAttachments);
        } else {
            $this->NotesAndAttachments = $notesAndAttachments;
        }
        return $this;
    }
    /**
     * Get NumberOfEmployees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfEmployees()
    {
        return isset($this->NumberOfEmployees) ? $this->NumberOfEmployees : null;
    }
    /**
     * Set NumberOfEmployees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfEmployees
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setNumberOfEmployees($numberOfEmployees = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfEmployees) && !(is_int($numberOfEmployees) || ctype_digit($numberOfEmployees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfEmployees, true), gettype($numberOfEmployees)), __LINE__);
        }
        if (is_null($numberOfEmployees) || (is_array($numberOfEmployees) && empty($numberOfEmployees))) {
            unset($this->NumberOfEmployees);
        } else {
            $this->NumberOfEmployees = $numberOfEmployees;
        }
        return $this;
    }
    /**
     * Get OpenActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getOpenActivities()
    {
        return isset($this->OpenActivities) ? $this->OpenActivities : null;
    }
    /**
     * Set OpenActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $openActivities
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setOpenActivities(\NexusDigital/MiratelForce\StructType\QueryResult $openActivities = null)
    {
        if (is_null($openActivities) || (is_array($openActivities) && empty($openActivities))) {
            unset($this->OpenActivities);
        } else {
            $this->OpenActivities = $openActivities;
        }
        return $this;
    }
    /**
     * Get OutgoingEmailRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getOutgoingEmailRelations()
    {
        return isset($this->OutgoingEmailRelations) ? $this->OutgoingEmailRelations : null;
    }
    /**
     * Set OutgoingEmailRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setOutgoingEmailRelations(\NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations = null)
    {
        if (is_null($outgoingEmailRelations) || (is_array($outgoingEmailRelations) && empty($outgoingEmailRelations))) {
            unset($this->OutgoingEmailRelations);
        } else {
            $this->OutgoingEmailRelations = $outgoingEmailRelations;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $owner
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\SObject $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get ParentEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getParentEntities()
    {
        return isset($this->ParentEntities) ? $this->ParentEntities : null;
    }
    /**
     * Set ParentEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setParentEntities(\NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null)
    {
        if (is_null($parentEntities) || (is_array($parentEntities) && empty($parentEntities))) {
            unset($this->ParentEntities);
        } else {
            $this->ParentEntities = $parentEntities;
        }
        return $this;
    }
    /**
     * Get PersonRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getPersonRecord()
    {
        return isset($this->PersonRecord) ? $this->PersonRecord : null;
    }
    /**
     * Set PersonRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $personRecord
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setPersonRecord(\NexusDigital/MiratelForce\StructType\QueryResult $personRecord = null)
    {
        if (is_null($personRecord) || (is_array($personRecord) && empty($personRecord))) {
            unset($this->PersonRecord);
        } else {
            $this->PersonRecord = $personRecord;
        }
        return $this;
    }
    /**
     * Get Personas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getPersonas()
    {
        return isset($this->Personas) ? $this->Personas : null;
    }
    /**
     * Set Personas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $personas
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setPersonas(\NexusDigital/MiratelForce\StructType\QueryResult $personas = null)
    {
        if (is_null($personas) || (is_array($personas) && empty($personas))) {
            unset($this->Personas);
        } else {
            $this->Personas = $personas;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get PhotoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhotoUrl()
    {
        return isset($this->PhotoUrl) ? $this->PhotoUrl : null;
    }
    /**
     * Set PhotoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $photoUrl
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setPhotoUrl($photoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($photoUrl) && !is_string($photoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($photoUrl, true), gettype($photoUrl)), __LINE__);
        }
        if (is_null($photoUrl) || (is_array($photoUrl) && empty($photoUrl))) {
            unset($this->PhotoUrl);
        } else {
            $this->PhotoUrl = $photoUrl;
        }
        return $this;
    }
    /**
     * Get PostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostalCode()
    {
        return isset($this->PostalCode) ? $this->PostalCode : null;
    }
    /**
     * Set PostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postalCode
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        if (is_null($postalCode) || (is_array($postalCode) && empty($postalCode))) {
            unset($this->PostalCode);
        } else {
            $this->PostalCode = $postalCode;
        }
        return $this;
    }
    /**
     * Get Posts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getPosts()
    {
        return isset($this->Posts) ? $this->Posts : null;
    }
    /**
     * Set Posts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $posts
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setPosts(\NexusDigital/MiratelForce\StructType\QueryResult $posts = null)
    {
        if (is_null($posts) || (is_array($posts) && empty($posts))) {
            unset($this->Posts);
        } else {
            $this->Posts = $posts;
        }
        return $this;
    }
    /**
     * Get ProcessInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessInstances()
    {
        return isset($this->ProcessInstances) ? $this->ProcessInstances : null;
    }
    /**
     * Set ProcessInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setProcessInstances(\NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null)
    {
        if (is_null($processInstances) || (is_array($processInstances) && empty($processInstances))) {
            unset($this->ProcessInstances);
        } else {
            $this->ProcessInstances = $processInstances;
        }
        return $this;
    }
    /**
     * Get ProcessSteps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessSteps()
    {
        return isset($this->ProcessSteps) ? $this->ProcessSteps : null;
    }
    /**
     * Set ProcessSteps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setProcessSteps(\NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null)
    {
        if (is_null($processSteps) || (is_array($processSteps) && empty($processSteps))) {
            unset($this->ProcessSteps);
        } else {
            $this->ProcessSteps = $processSteps;
        }
        return $this;
    }
    /**
     * Get Rating value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRating()
    {
        return isset($this->Rating) ? $this->Rating : null;
    }
    /**
     * Set Rating value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rating
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setRating($rating = null)
    {
        // validation for constraint: string
        if (!is_null($rating) && !is_string($rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rating, true), gettype($rating)), __LINE__);
        }
        if (is_null($rating) || (is_array($rating) && empty($rating))) {
            unset($this->Rating);
        } else {
            $this->Rating = $rating;
        }
        return $this;
    }
    /**
     * Get RecordActionHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActionHistories()
    {
        return isset($this->RecordActionHistories) ? $this->RecordActionHistories : null;
    }
    /**
     * Set RecordActionHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setRecordActionHistories(\NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null)
    {
        if (is_null($recordActionHistories) || (is_array($recordActionHistories) && empty($recordActionHistories))) {
            unset($this->RecordActionHistories);
        } else {
            $this->RecordActionHistories = $recordActionHistories;
        }
        return $this;
    }
    /**
     * Get RecordActions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActions()
    {
        return isset($this->RecordActions) ? $this->RecordActions : null;
    }
    /**
     * Set RecordActions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setRecordActions(\NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null)
    {
        if (is_null($recordActions) || (is_array($recordActions) && empty($recordActions))) {
            unset($this->RecordActions);
        } else {
            $this->RecordActions = $recordActions;
        }
        return $this;
    }
    /**
     * Get RecordAssociatedGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordAssociatedGroups()
    {
        return isset($this->RecordAssociatedGroups) ? $this->RecordAssociatedGroups : null;
    }
    /**
     * Set RecordAssociatedGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setRecordAssociatedGroups(\NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups = null)
    {
        if (is_null($recordAssociatedGroups) || (is_array($recordAssociatedGroups) && empty($recordAssociatedGroups))) {
            unset($this->RecordAssociatedGroups);
        } else {
            $this->RecordAssociatedGroups = $recordAssociatedGroups;
        }
        return $this;
    }
    /**
     * Get Salutation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalutation()
    {
        return isset($this->Salutation) ? $this->Salutation : null;
    }
    /**
     * Set Salutation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salutation
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        if (is_null($salutation) || (is_array($salutation) && empty($salutation))) {
            unset($this->Salutation);
        } else {
            $this->Salutation = $salutation;
        }
        return $this;
    }
    /**
     * Get Shares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getShares()
    {
        return isset($this->Shares) ? $this->Shares : null;
    }
    /**
     * Set Shares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $shares
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setShares(\NexusDigital/MiratelForce\StructType\QueryResult $shares = null)
    {
        if (is_null($shares) || (is_array($shares) && empty($shares))) {
            unset($this->Shares);
        } else {
            $this->Shares = $shares;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->Street) ? $this->Street : null;
    }
    /**
     * Set Street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->Street);
        } else {
            $this->Street = $street;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffix
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TaskRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTaskRelations()
    {
        return isset($this->TaskRelations) ? $this->TaskRelations : null;
    }
    /**
     * Set TaskRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setTaskRelations(\NexusDigital/MiratelForce\StructType\QueryResult $taskRelations = null)
    {
        if (is_null($taskRelations) || (is_array($taskRelations) && empty($taskRelations))) {
            unset($this->TaskRelations);
        } else {
            $this->TaskRelations = $taskRelations;
        }
        return $this;
    }
    /**
     * Get TaskWhoRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTaskWhoRelations()
    {
        return isset($this->TaskWhoRelations) ? $this->TaskWhoRelations : null;
    }
    /**
     * Set TaskWhoRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskWhoRelations
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setTaskWhoRelations(\NexusDigital/MiratelForce\StructType\QueryResult $taskWhoRelations = null)
    {
        if (is_null($taskWhoRelations) || (is_array($taskWhoRelations) && empty($taskWhoRelations))) {
            unset($this->TaskWhoRelations);
        } else {
            $this->TaskWhoRelations = $taskWhoRelations;
        }
        return $this;
    }
    /**
     * Get Tasks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTasks()
    {
        return isset($this->Tasks) ? $this->Tasks : null;
    }
    /**
     * Set Tasks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $tasks
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setTasks(\NexusDigital/MiratelForce\StructType\QueryResult $tasks = null)
    {
        if (is_null($tasks) || (is_array($tasks) && empty($tasks))) {
            unset($this->Tasks);
        } else {
            $this->Tasks = $tasks;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get TopicAssignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTopicAssignments()
    {
        return isset($this->TopicAssignments) ? $this->TopicAssignments : null;
    }
    /**
     * Set TopicAssignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setTopicAssignments(\NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null)
    {
        if (is_null($topicAssignments) || (is_array($topicAssignments) && empty($topicAssignments))) {
            unset($this->TopicAssignments);
        } else {
            $this->TopicAssignments = $topicAssignments;
        }
        return $this;
    }
    /**
     * Get UndecidedEventRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getUndecidedEventRelations()
    {
        return isset($this->UndecidedEventRelations) ? $this->UndecidedEventRelations : null;
    }
    /**
     * Set UndecidedEventRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $undecidedEventRelations
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setUndecidedEventRelations(\NexusDigital/MiratelForce\StructType\QueryResult $undecidedEventRelations = null)
    {
        if (is_null($undecidedEventRelations) || (is_array($undecidedEventRelations) && empty($undecidedEventRelations))) {
            unset($this->UndecidedEventRelations);
        } else {
            $this->UndecidedEventRelations = $undecidedEventRelations;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Get Website value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebsite()
    {
        return isset($this->Website) ? $this->Website : null;
    }
    /**
     * Set Website value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $website
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($website, true), gettype($website)), __LINE__);
        }
        if (is_null($website) || (is_array($website) && empty($website))) {
            unset($this->Website);
        } else {
            $this->Website = $website;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Lead
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
