<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdeaComment StructType
 * @subpackage Structs
 */
class IdeaComment extends SObject
{
    /**
     * The CommentBody
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommentBody;
    /**
     * The CommunityId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CommunityId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreatorFullPhotoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatorFullPhotoUrl;
    /**
     * The CreatorName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatorName;
    /**
     * The CreatorSmallPhotoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatorSmallPhotoUrl;
    /**
     * The Idea
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Idea
     */
    public $Idea;
    /**
     * The IdeaId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $IdeaId;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsHtml
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHtml;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UpVotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UpVotes;
    /**
     * The Votes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Votes;
    /**
     * Constructor method for IdeaComment
     * @uses IdeaComment::setCommentBody()
     * @uses IdeaComment::setCommunityId()
     * @uses IdeaComment::setCreatedBy()
     * @uses IdeaComment::setCreatedById()
     * @uses IdeaComment::setCreatedDate()
     * @uses IdeaComment::setCreatorFullPhotoUrl()
     * @uses IdeaComment::setCreatorName()
     * @uses IdeaComment::setCreatorSmallPhotoUrl()
     * @uses IdeaComment::setIdea()
     * @uses IdeaComment::setIdeaId()
     * @uses IdeaComment::setIsDeleted()
     * @uses IdeaComment::setIsHtml()
     * @uses IdeaComment::setSystemModstamp()
     * @uses IdeaComment::setUpVotes()
     * @uses IdeaComment::setVotes()
     * @param string $commentBody
     * @param string $communityId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $creatorFullPhotoUrl
     * @param string $creatorName
     * @param string $creatorSmallPhotoUrl
     * @param \NexusDigital/MiratelForce\StructType\Idea $idea
     * @param string $ideaId
     * @param bool $isDeleted
     * @param bool $isHtml
     * @param string $systemModstamp
     * @param int $upVotes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $votes
     */
    public function __construct($commentBody = null, $communityId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $creatorFullPhotoUrl = null, $creatorName = null, $creatorSmallPhotoUrl = null, \NexusDigital/MiratelForce\StructType\Idea $idea = null, $ideaId = null, $isDeleted = null, $isHtml = null, $systemModstamp = null, $upVotes = null, \NexusDigital/MiratelForce\StructType\QueryResult $votes = null)
    {
        $this
            ->setCommentBody($commentBody)
            ->setCommunityId($communityId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCreatorFullPhotoUrl($creatorFullPhotoUrl)
            ->setCreatorName($creatorName)
            ->setCreatorSmallPhotoUrl($creatorSmallPhotoUrl)
            ->setIdea($idea)
            ->setIdeaId($ideaId)
            ->setIsDeleted($isDeleted)
            ->setIsHtml($isHtml)
            ->setSystemModstamp($systemModstamp)
            ->setUpVotes($upVotes)
            ->setVotes($votes);
    }
    /**
     * Get CommentBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommentBody()
    {
        return isset($this->CommentBody) ? $this->CommentBody : null;
    }
    /**
     * Set CommentBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commentBody
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setCommentBody($commentBody = null)
    {
        // validation for constraint: string
        if (!is_null($commentBody) && !is_string($commentBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentBody, true), gettype($commentBody)), __LINE__);
        }
        if (is_null($commentBody) || (is_array($commentBody) && empty($commentBody))) {
            unset($this->CommentBody);
        } else {
            $this->CommentBody = $commentBody;
        }
        return $this;
    }
    /**
     * Get CommunityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunityId()
    {
        return isset($this->CommunityId) ? $this->CommunityId : null;
    }
    /**
     * Set CommunityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communityId
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setCommunityId($communityId = null)
    {
        // validation for constraint: string
        if (!is_null($communityId) && !is_string($communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communityId, true), gettype($communityId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($communityId) && mb_strlen($communityId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($communityId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($communityId) && !preg_match('/[a-zA-Z0-9]{18}/', $communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($communityId, true)), __LINE__);
        }
        if (is_null($communityId) || (is_array($communityId) && empty($communityId))) {
            unset($this->CommunityId);
        } else {
            $this->CommunityId = $communityId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CreatorFullPhotoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatorFullPhotoUrl()
    {
        return isset($this->CreatorFullPhotoUrl) ? $this->CreatorFullPhotoUrl : null;
    }
    /**
     * Set CreatorFullPhotoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creatorFullPhotoUrl
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setCreatorFullPhotoUrl($creatorFullPhotoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($creatorFullPhotoUrl) && !is_string($creatorFullPhotoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorFullPhotoUrl, true), gettype($creatorFullPhotoUrl)), __LINE__);
        }
        if (is_null($creatorFullPhotoUrl) || (is_array($creatorFullPhotoUrl) && empty($creatorFullPhotoUrl))) {
            unset($this->CreatorFullPhotoUrl);
        } else {
            $this->CreatorFullPhotoUrl = $creatorFullPhotoUrl;
        }
        return $this;
    }
    /**
     * Get CreatorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatorName()
    {
        return isset($this->CreatorName) ? $this->CreatorName : null;
    }
    /**
     * Set CreatorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creatorName
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setCreatorName($creatorName = null)
    {
        // validation for constraint: string
        if (!is_null($creatorName) && !is_string($creatorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorName, true), gettype($creatorName)), __LINE__);
        }
        if (is_null($creatorName) || (is_array($creatorName) && empty($creatorName))) {
            unset($this->CreatorName);
        } else {
            $this->CreatorName = $creatorName;
        }
        return $this;
    }
    /**
     * Get CreatorSmallPhotoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatorSmallPhotoUrl()
    {
        return isset($this->CreatorSmallPhotoUrl) ? $this->CreatorSmallPhotoUrl : null;
    }
    /**
     * Set CreatorSmallPhotoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creatorSmallPhotoUrl
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setCreatorSmallPhotoUrl($creatorSmallPhotoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($creatorSmallPhotoUrl) && !is_string($creatorSmallPhotoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creatorSmallPhotoUrl, true), gettype($creatorSmallPhotoUrl)), __LINE__);
        }
        if (is_null($creatorSmallPhotoUrl) || (is_array($creatorSmallPhotoUrl) && empty($creatorSmallPhotoUrl))) {
            unset($this->CreatorSmallPhotoUrl);
        } else {
            $this->CreatorSmallPhotoUrl = $creatorSmallPhotoUrl;
        }
        return $this;
    }
    /**
     * Get Idea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Idea|null
     */
    public function getIdea()
    {
        return isset($this->Idea) ? $this->Idea : null;
    }
    /**
     * Set Idea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Idea $idea
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setIdea(\NexusDigital/MiratelForce\StructType\Idea $idea = null)
    {
        if (is_null($idea) || (is_array($idea) && empty($idea))) {
            unset($this->Idea);
        } else {
            $this->Idea = $idea;
        }
        return $this;
    }
    /**
     * Get IdeaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdeaId()
    {
        return isset($this->IdeaId) ? $this->IdeaId : null;
    }
    /**
     * Set IdeaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ideaId
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setIdeaId($ideaId = null)
    {
        // validation for constraint: string
        if (!is_null($ideaId) && !is_string($ideaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ideaId, true), gettype($ideaId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ideaId) && mb_strlen($ideaId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ideaId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ideaId) && !preg_match('/[a-zA-Z0-9]{18}/', $ideaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ideaId, true)), __LINE__);
        }
        if (is_null($ideaId) || (is_array($ideaId) && empty($ideaId))) {
            unset($this->IdeaId);
        } else {
            $this->IdeaId = $ideaId;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsHtml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHtml()
    {
        return isset($this->IsHtml) ? $this->IsHtml : null;
    }
    /**
     * Set IsHtml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHtml
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setIsHtml($isHtml = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHtml) && !is_bool($isHtml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHtml, true), gettype($isHtml)), __LINE__);
        }
        if (is_null($isHtml) || (is_array($isHtml) && empty($isHtml))) {
            unset($this->IsHtml);
        } else {
            $this->IsHtml = $isHtml;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UpVotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUpVotes()
    {
        return isset($this->UpVotes) ? $this->UpVotes : null;
    }
    /**
     * Set UpVotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $upVotes
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setUpVotes($upVotes = null)
    {
        // validation for constraint: int
        if (!is_null($upVotes) && !(is_int($upVotes) || ctype_digit($upVotes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($upVotes, true), gettype($upVotes)), __LINE__);
        }
        if (is_null($upVotes) || (is_array($upVotes) && empty($upVotes))) {
            unset($this->UpVotes);
        } else {
            $this->UpVotes = $upVotes;
        }
        return $this;
    }
    /**
     * Get Votes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getVotes()
    {
        return isset($this->Votes) ? $this->Votes : null;
    }
    /**
     * Set Votes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $votes
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public function setVotes(\NexusDigital/MiratelForce\StructType\QueryResult $votes = null)
    {
        if (is_null($votes) || (is_array($votes) && empty($votes))) {
            unset($this->Votes);
        } else {
            $this->Votes = $votes;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\IdeaComment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
