<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForecastingOwnerAdjustment StructType
 * @subpackage Structs
 */
class ForecastingOwnerAdjustment extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ForecastCategoryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastCategoryName;
    /**
     * The ForecastOwner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $ForecastOwner;
    /**
     * The ForecastOwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ForecastOwnerId;
    /**
     * The ForecastingItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public $ForecastingItem;
    /**
     * The ForecastingItemCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastingItemCategory;
    /**
     * The ForecastingItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ForecastingItemId;
    /**
     * The ForecastingType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ForecastingType
     */
    public $ForecastingType;
    /**
     * The ForecastingTypeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ForecastingTypeId;
    /**
     * The IsAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAmount;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsQuantity;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The OwnerAdjustedAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OwnerAdjustedAmount;
    /**
     * The OwnerAdjustedQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OwnerAdjustedQuantity;
    /**
     * The OwnerAdjustmentNote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerAdjustmentNote;
    /**
     * The Period
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Period
     */
    public $Period;
    /**
     * The PeriodId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PeriodId;
    /**
     * The ProductFamily
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductFamily;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for ForecastingOwnerAdjustment
     * @uses ForecastingOwnerAdjustment::setCreatedBy()
     * @uses ForecastingOwnerAdjustment::setCreatedById()
     * @uses ForecastingOwnerAdjustment::setCreatedDate()
     * @uses ForecastingOwnerAdjustment::setForecastCategoryName()
     * @uses ForecastingOwnerAdjustment::setForecastOwner()
     * @uses ForecastingOwnerAdjustment::setForecastOwnerId()
     * @uses ForecastingOwnerAdjustment::setForecastingItem()
     * @uses ForecastingOwnerAdjustment::setForecastingItemCategory()
     * @uses ForecastingOwnerAdjustment::setForecastingItemId()
     * @uses ForecastingOwnerAdjustment::setForecastingType()
     * @uses ForecastingOwnerAdjustment::setForecastingTypeId()
     * @uses ForecastingOwnerAdjustment::setIsAmount()
     * @uses ForecastingOwnerAdjustment::setIsDeleted()
     * @uses ForecastingOwnerAdjustment::setIsQuantity()
     * @uses ForecastingOwnerAdjustment::setLastModifiedBy()
     * @uses ForecastingOwnerAdjustment::setLastModifiedById()
     * @uses ForecastingOwnerAdjustment::setLastModifiedDate()
     * @uses ForecastingOwnerAdjustment::setOwnerAdjustedAmount()
     * @uses ForecastingOwnerAdjustment::setOwnerAdjustedQuantity()
     * @uses ForecastingOwnerAdjustment::setOwnerAdjustmentNote()
     * @uses ForecastingOwnerAdjustment::setPeriod()
     * @uses ForecastingOwnerAdjustment::setPeriodId()
     * @uses ForecastingOwnerAdjustment::setProductFamily()
     * @uses ForecastingOwnerAdjustment::setStartDate()
     * @uses ForecastingOwnerAdjustment::setSystemModstamp()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $forecastCategoryName
     * @param \NexusDigital/MiratelForce\StructType\User $forecastOwner
     * @param string $forecastOwnerId
     * @param \NexusDigital/MiratelForce\StructType\ForecastingItem $forecastingItem
     * @param string $forecastingItemCategory
     * @param string $forecastingItemId
     * @param \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType
     * @param string $forecastingTypeId
     * @param bool $isAmount
     * @param bool $isDeleted
     * @param bool $isQuantity
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param float $ownerAdjustedAmount
     * @param float $ownerAdjustedQuantity
     * @param string $ownerAdjustmentNote
     * @param \NexusDigital/MiratelForce\StructType\Period $period
     * @param string $periodId
     * @param string $productFamily
     * @param string $startDate
     * @param string $systemModstamp
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $forecastCategoryName = null, \NexusDigital/MiratelForce\StructType\User $forecastOwner = null, $forecastOwnerId = null, \NexusDigital/MiratelForce\StructType\ForecastingItem $forecastingItem = null, $forecastingItemCategory = null, $forecastingItemId = null, \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType = null, $forecastingTypeId = null, $isAmount = null, $isDeleted = null, $isQuantity = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $ownerAdjustedAmount = null, $ownerAdjustedQuantity = null, $ownerAdjustmentNote = null, \NexusDigital/MiratelForce\StructType\Period $period = null, $periodId = null, $productFamily = null, $startDate = null, $systemModstamp = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setForecastCategoryName($forecastCategoryName)
            ->setForecastOwner($forecastOwner)
            ->setForecastOwnerId($forecastOwnerId)
            ->setForecastingItem($forecastingItem)
            ->setForecastingItemCategory($forecastingItemCategory)
            ->setForecastingItemId($forecastingItemId)
            ->setForecastingType($forecastingType)
            ->setForecastingTypeId($forecastingTypeId)
            ->setIsAmount($isAmount)
            ->setIsDeleted($isDeleted)
            ->setIsQuantity($isQuantity)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setOwnerAdjustedAmount($ownerAdjustedAmount)
            ->setOwnerAdjustedQuantity($ownerAdjustedQuantity)
            ->setOwnerAdjustmentNote($ownerAdjustmentNote)
            ->setPeriod($period)
            ->setPeriodId($periodId)
            ->setProductFamily($productFamily)
            ->setStartDate($startDate)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ForecastCategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastCategoryName()
    {
        return isset($this->ForecastCategoryName) ? $this->ForecastCategoryName : null;
    }
    /**
     * Set ForecastCategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastCategoryName
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setForecastCategoryName($forecastCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($forecastCategoryName) && !is_string($forecastCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastCategoryName, true), gettype($forecastCategoryName)), __LINE__);
        }
        if (is_null($forecastCategoryName) || (is_array($forecastCategoryName) && empty($forecastCategoryName))) {
            unset($this->ForecastCategoryName);
        } else {
            $this->ForecastCategoryName = $forecastCategoryName;
        }
        return $this;
    }
    /**
     * Get ForecastOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getForecastOwner()
    {
        return isset($this->ForecastOwner) ? $this->ForecastOwner : null;
    }
    /**
     * Set ForecastOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $forecastOwner
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setForecastOwner(\NexusDigital/MiratelForce\StructType\User $forecastOwner = null)
    {
        if (is_null($forecastOwner) || (is_array($forecastOwner) && empty($forecastOwner))) {
            unset($this->ForecastOwner);
        } else {
            $this->ForecastOwner = $forecastOwner;
        }
        return $this;
    }
    /**
     * Get ForecastOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastOwnerId()
    {
        return isset($this->ForecastOwnerId) ? $this->ForecastOwnerId : null;
    }
    /**
     * Set ForecastOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastOwnerId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setForecastOwnerId($forecastOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($forecastOwnerId) && !is_string($forecastOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastOwnerId, true), gettype($forecastOwnerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($forecastOwnerId) && mb_strlen($forecastOwnerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($forecastOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($forecastOwnerId) && !preg_match('/[a-zA-Z0-9]{18}/', $forecastOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($forecastOwnerId, true)), __LINE__);
        }
        if (is_null($forecastOwnerId) || (is_array($forecastOwnerId) && empty($forecastOwnerId))) {
            unset($this->ForecastOwnerId);
        } else {
            $this->ForecastOwnerId = $forecastOwnerId;
        }
        return $this;
    }
    /**
     * Get ForecastingItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem|null
     */
    public function getForecastingItem()
    {
        return isset($this->ForecastingItem) ? $this->ForecastingItem : null;
    }
    /**
     * Set ForecastingItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ForecastingItem $forecastingItem
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setForecastingItem(\NexusDigital/MiratelForce\StructType\ForecastingItem $forecastingItem = null)
    {
        if (is_null($forecastingItem) || (is_array($forecastingItem) && empty($forecastingItem))) {
            unset($this->ForecastingItem);
        } else {
            $this->ForecastingItem = $forecastingItem;
        }
        return $this;
    }
    /**
     * Get ForecastingItemCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastingItemCategory()
    {
        return isset($this->ForecastingItemCategory) ? $this->ForecastingItemCategory : null;
    }
    /**
     * Set ForecastingItemCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastingItemCategory
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setForecastingItemCategory($forecastingItemCategory = null)
    {
        // validation for constraint: string
        if (!is_null($forecastingItemCategory) && !is_string($forecastingItemCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastingItemCategory, true), gettype($forecastingItemCategory)), __LINE__);
        }
        if (is_null($forecastingItemCategory) || (is_array($forecastingItemCategory) && empty($forecastingItemCategory))) {
            unset($this->ForecastingItemCategory);
        } else {
            $this->ForecastingItemCategory = $forecastingItemCategory;
        }
        return $this;
    }
    /**
     * Get ForecastingItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastingItemId()
    {
        return isset($this->ForecastingItemId) ? $this->ForecastingItemId : null;
    }
    /**
     * Set ForecastingItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastingItemId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setForecastingItemId($forecastingItemId = null)
    {
        // validation for constraint: string
        if (!is_null($forecastingItemId) && !is_string($forecastingItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastingItemId, true), gettype($forecastingItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($forecastingItemId) && mb_strlen($forecastingItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($forecastingItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($forecastingItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $forecastingItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($forecastingItemId, true)), __LINE__);
        }
        if (is_null($forecastingItemId) || (is_array($forecastingItemId) && empty($forecastingItemId))) {
            unset($this->ForecastingItemId);
        } else {
            $this->ForecastingItemId = $forecastingItemId;
        }
        return $this;
    }
    /**
     * Get ForecastingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ForecastingType|null
     */
    public function getForecastingType()
    {
        return isset($this->ForecastingType) ? $this->ForecastingType : null;
    }
    /**
     * Set ForecastingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setForecastingType(\NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType = null)
    {
        if (is_null($forecastingType) || (is_array($forecastingType) && empty($forecastingType))) {
            unset($this->ForecastingType);
        } else {
            $this->ForecastingType = $forecastingType;
        }
        return $this;
    }
    /**
     * Get ForecastingTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastingTypeId()
    {
        return isset($this->ForecastingTypeId) ? $this->ForecastingTypeId : null;
    }
    /**
     * Set ForecastingTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastingTypeId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setForecastingTypeId($forecastingTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($forecastingTypeId) && !is_string($forecastingTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastingTypeId, true), gettype($forecastingTypeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($forecastingTypeId) && mb_strlen($forecastingTypeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($forecastingTypeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($forecastingTypeId) && !preg_match('/[a-zA-Z0-9]{18}/', $forecastingTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($forecastingTypeId, true)), __LINE__);
        }
        if (is_null($forecastingTypeId) || (is_array($forecastingTypeId) && empty($forecastingTypeId))) {
            unset($this->ForecastingTypeId);
        } else {
            $this->ForecastingTypeId = $forecastingTypeId;
        }
        return $this;
    }
    /**
     * Get IsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAmount()
    {
        return isset($this->IsAmount) ? $this->IsAmount : null;
    }
    /**
     * Set IsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAmount
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setIsAmount($isAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAmount) && !is_bool($isAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAmount, true), gettype($isAmount)), __LINE__);
        }
        if (is_null($isAmount) || (is_array($isAmount) && empty($isAmount))) {
            unset($this->IsAmount);
        } else {
            $this->IsAmount = $isAmount;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsQuantity()
    {
        return isset($this->IsQuantity) ? $this->IsQuantity : null;
    }
    /**
     * Set IsQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isQuantity
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setIsQuantity($isQuantity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isQuantity) && !is_bool($isQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isQuantity, true), gettype($isQuantity)), __LINE__);
        }
        if (is_null($isQuantity) || (is_array($isQuantity) && empty($isQuantity))) {
            unset($this->IsQuantity);
        } else {
            $this->IsQuantity = $isQuantity;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get OwnerAdjustedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOwnerAdjustedAmount()
    {
        return isset($this->OwnerAdjustedAmount) ? $this->OwnerAdjustedAmount : null;
    }
    /**
     * Set OwnerAdjustedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ownerAdjustedAmount
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setOwnerAdjustedAmount($ownerAdjustedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($ownerAdjustedAmount) && !(is_float($ownerAdjustedAmount) || is_numeric($ownerAdjustedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ownerAdjustedAmount, true), gettype($ownerAdjustedAmount)), __LINE__);
        }
        if (is_null($ownerAdjustedAmount) || (is_array($ownerAdjustedAmount) && empty($ownerAdjustedAmount))) {
            unset($this->OwnerAdjustedAmount);
        } else {
            $this->OwnerAdjustedAmount = $ownerAdjustedAmount;
        }
        return $this;
    }
    /**
     * Get OwnerAdjustedQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOwnerAdjustedQuantity()
    {
        return isset($this->OwnerAdjustedQuantity) ? $this->OwnerAdjustedQuantity : null;
    }
    /**
     * Set OwnerAdjustedQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ownerAdjustedQuantity
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setOwnerAdjustedQuantity($ownerAdjustedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($ownerAdjustedQuantity) && !(is_float($ownerAdjustedQuantity) || is_numeric($ownerAdjustedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ownerAdjustedQuantity, true), gettype($ownerAdjustedQuantity)), __LINE__);
        }
        if (is_null($ownerAdjustedQuantity) || (is_array($ownerAdjustedQuantity) && empty($ownerAdjustedQuantity))) {
            unset($this->OwnerAdjustedQuantity);
        } else {
            $this->OwnerAdjustedQuantity = $ownerAdjustedQuantity;
        }
        return $this;
    }
    /**
     * Get OwnerAdjustmentNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerAdjustmentNote()
    {
        return isset($this->OwnerAdjustmentNote) ? $this->OwnerAdjustmentNote : null;
    }
    /**
     * Set OwnerAdjustmentNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerAdjustmentNote
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setOwnerAdjustmentNote($ownerAdjustmentNote = null)
    {
        // validation for constraint: string
        if (!is_null($ownerAdjustmentNote) && !is_string($ownerAdjustmentNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerAdjustmentNote, true), gettype($ownerAdjustmentNote)), __LINE__);
        }
        if (is_null($ownerAdjustmentNote) || (is_array($ownerAdjustmentNote) && empty($ownerAdjustmentNote))) {
            unset($this->OwnerAdjustmentNote);
        } else {
            $this->OwnerAdjustmentNote = $ownerAdjustmentNote;
        }
        return $this;
    }
    /**
     * Get Period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Period|null
     */
    public function getPeriod()
    {
        return isset($this->Period) ? $this->Period : null;
    }
    /**
     * Set Period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Period $period
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setPeriod(\NexusDigital/MiratelForce\StructType\Period $period = null)
    {
        if (is_null($period) || (is_array($period) && empty($period))) {
            unset($this->Period);
        } else {
            $this->Period = $period;
        }
        return $this;
    }
    /**
     * Get PeriodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodId()
    {
        return isset($this->PeriodId) ? $this->PeriodId : null;
    }
    /**
     * Set PeriodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setPeriodId($periodId = null)
    {
        // validation for constraint: string
        if (!is_null($periodId) && !is_string($periodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodId, true), gettype($periodId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($periodId) && mb_strlen($periodId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($periodId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($periodId) && !preg_match('/[a-zA-Z0-9]{18}/', $periodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($periodId, true)), __LINE__);
        }
        if (is_null($periodId) || (is_array($periodId) && empty($periodId))) {
            unset($this->PeriodId);
        } else {
            $this->PeriodId = $periodId;
        }
        return $this;
    }
    /**
     * Get ProductFamily value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductFamily()
    {
        return isset($this->ProductFamily) ? $this->ProductFamily : null;
    }
    /**
     * Set ProductFamily value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productFamily
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setProductFamily($productFamily = null)
    {
        // validation for constraint: string
        if (!is_null($productFamily) && !is_string($productFamily)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productFamily, true), gettype($productFamily)), __LINE__);
        }
        if (is_null($productFamily) || (is_array($productFamily) && empty($productFamily))) {
            unset($this->ProductFamily);
        } else {
            $this->ProductFamily = $productFamily;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ForecastingOwnerAdjustment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
