<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForecastingItem StructType
 * @subpackage Structs
 */
class ForecastingItem extends SObject
{
    /**
     * The AmountWithoutAdjustments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountWithoutAdjustments;
    /**
     * The AmountWithoutManagerAdjustment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountWithoutManagerAdjustment;
    /**
     * The AmountWithoutOwnerAdjustment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountWithoutOwnerAdjustment;
    /**
     * The ForecastAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ForecastAmount;
    /**
     * The ForecastCategoryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastCategoryName;
    /**
     * The ForecastQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ForecastQuantity;
    /**
     * The ForecastingFacts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ForecastingFacts;
    /**
     * The ForecastingItemCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastingItemCategory;
    /**
     * The ForecastingType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ForecastingType
     */
    public $ForecastingType;
    /**
     * The ForecastingTypeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ForecastingTypeId;
    /**
     * The HasAdjustment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasAdjustment;
    /**
     * The HasOwnerAdjustment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasOwnerAdjustment;
    /**
     * The IsAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAmount;
    /**
     * The IsQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsQuantity;
    /**
     * The IsUpToDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpToDate;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The OwnerOnlyAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OwnerOnlyAmount;
    /**
     * The OwnerOnlyQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OwnerOnlyQuantity;
    /**
     * The ParentForecastingItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public $ParentForecastingItem;
    /**
     * The ParentForecastingItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentForecastingItemId;
    /**
     * The Period
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Period
     */
    public $Period;
    /**
     * The PeriodId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PeriodId;
    /**
     * The ProductFamily
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductFamily;
    /**
     * The QuantityWithoutAdjustments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityWithoutAdjustments;
    /**
     * The QuantityWithoutManagerAdjustment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityWithoutManagerAdjustment;
    /**
     * The QuantityWithoutOwnerAdjustment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityWithoutOwnerAdjustment;
    /**
     * The SubordinateOverrides
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubordinateOverrides;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for ForecastingItem
     * @uses ForecastingItem::setAmountWithoutAdjustments()
     * @uses ForecastingItem::setAmountWithoutManagerAdjustment()
     * @uses ForecastingItem::setAmountWithoutOwnerAdjustment()
     * @uses ForecastingItem::setForecastAmount()
     * @uses ForecastingItem::setForecastCategoryName()
     * @uses ForecastingItem::setForecastQuantity()
     * @uses ForecastingItem::setForecastingFacts()
     * @uses ForecastingItem::setForecastingItemCategory()
     * @uses ForecastingItem::setForecastingType()
     * @uses ForecastingItem::setForecastingTypeId()
     * @uses ForecastingItem::setHasAdjustment()
     * @uses ForecastingItem::setHasOwnerAdjustment()
     * @uses ForecastingItem::setIsAmount()
     * @uses ForecastingItem::setIsQuantity()
     * @uses ForecastingItem::setIsUpToDate()
     * @uses ForecastingItem::setOwner()
     * @uses ForecastingItem::setOwnerId()
     * @uses ForecastingItem::setOwnerOnlyAmount()
     * @uses ForecastingItem::setOwnerOnlyQuantity()
     * @uses ForecastingItem::setParentForecastingItem()
     * @uses ForecastingItem::setParentForecastingItemId()
     * @uses ForecastingItem::setPeriod()
     * @uses ForecastingItem::setPeriodId()
     * @uses ForecastingItem::setProductFamily()
     * @uses ForecastingItem::setQuantityWithoutAdjustments()
     * @uses ForecastingItem::setQuantityWithoutManagerAdjustment()
     * @uses ForecastingItem::setQuantityWithoutOwnerAdjustment()
     * @uses ForecastingItem::setSubordinateOverrides()
     * @uses ForecastingItem::setSystemModstamp()
     * @param float $amountWithoutAdjustments
     * @param float $amountWithoutManagerAdjustment
     * @param float $amountWithoutOwnerAdjustment
     * @param float $forecastAmount
     * @param string $forecastCategoryName
     * @param float $forecastQuantity
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $forecastingFacts
     * @param string $forecastingItemCategory
     * @param \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType
     * @param string $forecastingTypeId
     * @param bool $hasAdjustment
     * @param bool $hasOwnerAdjustment
     * @param bool $isAmount
     * @param bool $isQuantity
     * @param bool $isUpToDate
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @param string $ownerId
     * @param float $ownerOnlyAmount
     * @param float $ownerOnlyQuantity
     * @param \NexusDigital/MiratelForce\StructType\ForecastingItem $parentForecastingItem
     * @param string $parentForecastingItemId
     * @param \NexusDigital/MiratelForce\StructType\Period $period
     * @param string $periodId
     * @param string $productFamily
     * @param float $quantityWithoutAdjustments
     * @param float $quantityWithoutManagerAdjustment
     * @param float $quantityWithoutOwnerAdjustment
     * @param int $subordinateOverrides
     * @param string $systemModstamp
     */
    public function __construct($amountWithoutAdjustments = null, $amountWithoutManagerAdjustment = null, $amountWithoutOwnerAdjustment = null, $forecastAmount = null, $forecastCategoryName = null, $forecastQuantity = null, \NexusDigital/MiratelForce\StructType\QueryResult $forecastingFacts = null, $forecastingItemCategory = null, \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType = null, $forecastingTypeId = null, $hasAdjustment = null, $hasOwnerAdjustment = null, $isAmount = null, $isQuantity = null, $isUpToDate = null, \NexusDigital/MiratelForce\StructType\User $owner = null, $ownerId = null, $ownerOnlyAmount = null, $ownerOnlyQuantity = null, \NexusDigital/MiratelForce\StructType\ForecastingItem $parentForecastingItem = null, $parentForecastingItemId = null, \NexusDigital/MiratelForce\StructType\Period $period = null, $periodId = null, $productFamily = null, $quantityWithoutAdjustments = null, $quantityWithoutManagerAdjustment = null, $quantityWithoutOwnerAdjustment = null, $subordinateOverrides = null, $systemModstamp = null)
    {
        $this
            ->setAmountWithoutAdjustments($amountWithoutAdjustments)
            ->setAmountWithoutManagerAdjustment($amountWithoutManagerAdjustment)
            ->setAmountWithoutOwnerAdjustment($amountWithoutOwnerAdjustment)
            ->setForecastAmount($forecastAmount)
            ->setForecastCategoryName($forecastCategoryName)
            ->setForecastQuantity($forecastQuantity)
            ->setForecastingFacts($forecastingFacts)
            ->setForecastingItemCategory($forecastingItemCategory)
            ->setForecastingType($forecastingType)
            ->setForecastingTypeId($forecastingTypeId)
            ->setHasAdjustment($hasAdjustment)
            ->setHasOwnerAdjustment($hasOwnerAdjustment)
            ->setIsAmount($isAmount)
            ->setIsQuantity($isQuantity)
            ->setIsUpToDate($isUpToDate)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setOwnerOnlyAmount($ownerOnlyAmount)
            ->setOwnerOnlyQuantity($ownerOnlyQuantity)
            ->setParentForecastingItem($parentForecastingItem)
            ->setParentForecastingItemId($parentForecastingItemId)
            ->setPeriod($period)
            ->setPeriodId($periodId)
            ->setProductFamily($productFamily)
            ->setQuantityWithoutAdjustments($quantityWithoutAdjustments)
            ->setQuantityWithoutManagerAdjustment($quantityWithoutManagerAdjustment)
            ->setQuantityWithoutOwnerAdjustment($quantityWithoutOwnerAdjustment)
            ->setSubordinateOverrides($subordinateOverrides)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get AmountWithoutAdjustments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountWithoutAdjustments()
    {
        return isset($this->AmountWithoutAdjustments) ? $this->AmountWithoutAdjustments : null;
    }
    /**
     * Set AmountWithoutAdjustments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountWithoutAdjustments
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setAmountWithoutAdjustments($amountWithoutAdjustments = null)
    {
        // validation for constraint: float
        if (!is_null($amountWithoutAdjustments) && !(is_float($amountWithoutAdjustments) || is_numeric($amountWithoutAdjustments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountWithoutAdjustments, true), gettype($amountWithoutAdjustments)), __LINE__);
        }
        if (is_null($amountWithoutAdjustments) || (is_array($amountWithoutAdjustments) && empty($amountWithoutAdjustments))) {
            unset($this->AmountWithoutAdjustments);
        } else {
            $this->AmountWithoutAdjustments = $amountWithoutAdjustments;
        }
        return $this;
    }
    /**
     * Get AmountWithoutManagerAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountWithoutManagerAdjustment()
    {
        return isset($this->AmountWithoutManagerAdjustment) ? $this->AmountWithoutManagerAdjustment : null;
    }
    /**
     * Set AmountWithoutManagerAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountWithoutManagerAdjustment
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setAmountWithoutManagerAdjustment($amountWithoutManagerAdjustment = null)
    {
        // validation for constraint: float
        if (!is_null($amountWithoutManagerAdjustment) && !(is_float($amountWithoutManagerAdjustment) || is_numeric($amountWithoutManagerAdjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountWithoutManagerAdjustment, true), gettype($amountWithoutManagerAdjustment)), __LINE__);
        }
        if (is_null($amountWithoutManagerAdjustment) || (is_array($amountWithoutManagerAdjustment) && empty($amountWithoutManagerAdjustment))) {
            unset($this->AmountWithoutManagerAdjustment);
        } else {
            $this->AmountWithoutManagerAdjustment = $amountWithoutManagerAdjustment;
        }
        return $this;
    }
    /**
     * Get AmountWithoutOwnerAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountWithoutOwnerAdjustment()
    {
        return isset($this->AmountWithoutOwnerAdjustment) ? $this->AmountWithoutOwnerAdjustment : null;
    }
    /**
     * Set AmountWithoutOwnerAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountWithoutOwnerAdjustment
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setAmountWithoutOwnerAdjustment($amountWithoutOwnerAdjustment = null)
    {
        // validation for constraint: float
        if (!is_null($amountWithoutOwnerAdjustment) && !(is_float($amountWithoutOwnerAdjustment) || is_numeric($amountWithoutOwnerAdjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountWithoutOwnerAdjustment, true), gettype($amountWithoutOwnerAdjustment)), __LINE__);
        }
        if (is_null($amountWithoutOwnerAdjustment) || (is_array($amountWithoutOwnerAdjustment) && empty($amountWithoutOwnerAdjustment))) {
            unset($this->AmountWithoutOwnerAdjustment);
        } else {
            $this->AmountWithoutOwnerAdjustment = $amountWithoutOwnerAdjustment;
        }
        return $this;
    }
    /**
     * Get ForecastAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getForecastAmount()
    {
        return isset($this->ForecastAmount) ? $this->ForecastAmount : null;
    }
    /**
     * Set ForecastAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $forecastAmount
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setForecastAmount($forecastAmount = null)
    {
        // validation for constraint: float
        if (!is_null($forecastAmount) && !(is_float($forecastAmount) || is_numeric($forecastAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($forecastAmount, true), gettype($forecastAmount)), __LINE__);
        }
        if (is_null($forecastAmount) || (is_array($forecastAmount) && empty($forecastAmount))) {
            unset($this->ForecastAmount);
        } else {
            $this->ForecastAmount = $forecastAmount;
        }
        return $this;
    }
    /**
     * Get ForecastCategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastCategoryName()
    {
        return isset($this->ForecastCategoryName) ? $this->ForecastCategoryName : null;
    }
    /**
     * Set ForecastCategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastCategoryName
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setForecastCategoryName($forecastCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($forecastCategoryName) && !is_string($forecastCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastCategoryName, true), gettype($forecastCategoryName)), __LINE__);
        }
        if (is_null($forecastCategoryName) || (is_array($forecastCategoryName) && empty($forecastCategoryName))) {
            unset($this->ForecastCategoryName);
        } else {
            $this->ForecastCategoryName = $forecastCategoryName;
        }
        return $this;
    }
    /**
     * Get ForecastQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getForecastQuantity()
    {
        return isset($this->ForecastQuantity) ? $this->ForecastQuantity : null;
    }
    /**
     * Set ForecastQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $forecastQuantity
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setForecastQuantity($forecastQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($forecastQuantity) && !(is_float($forecastQuantity) || is_numeric($forecastQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($forecastQuantity, true), gettype($forecastQuantity)), __LINE__);
        }
        if (is_null($forecastQuantity) || (is_array($forecastQuantity) && empty($forecastQuantity))) {
            unset($this->ForecastQuantity);
        } else {
            $this->ForecastQuantity = $forecastQuantity;
        }
        return $this;
    }
    /**
     * Get ForecastingFacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getForecastingFacts()
    {
        return isset($this->ForecastingFacts) ? $this->ForecastingFacts : null;
    }
    /**
     * Set ForecastingFacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $forecastingFacts
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setForecastingFacts(\NexusDigital/MiratelForce\StructType\QueryResult $forecastingFacts = null)
    {
        if (is_null($forecastingFacts) || (is_array($forecastingFacts) && empty($forecastingFacts))) {
            unset($this->ForecastingFacts);
        } else {
            $this->ForecastingFacts = $forecastingFacts;
        }
        return $this;
    }
    /**
     * Get ForecastingItemCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastingItemCategory()
    {
        return isset($this->ForecastingItemCategory) ? $this->ForecastingItemCategory : null;
    }
    /**
     * Set ForecastingItemCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastingItemCategory
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setForecastingItemCategory($forecastingItemCategory = null)
    {
        // validation for constraint: string
        if (!is_null($forecastingItemCategory) && !is_string($forecastingItemCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastingItemCategory, true), gettype($forecastingItemCategory)), __LINE__);
        }
        if (is_null($forecastingItemCategory) || (is_array($forecastingItemCategory) && empty($forecastingItemCategory))) {
            unset($this->ForecastingItemCategory);
        } else {
            $this->ForecastingItemCategory = $forecastingItemCategory;
        }
        return $this;
    }
    /**
     * Get ForecastingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ForecastingType|null
     */
    public function getForecastingType()
    {
        return isset($this->ForecastingType) ? $this->ForecastingType : null;
    }
    /**
     * Set ForecastingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setForecastingType(\NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType = null)
    {
        if (is_null($forecastingType) || (is_array($forecastingType) && empty($forecastingType))) {
            unset($this->ForecastingType);
        } else {
            $this->ForecastingType = $forecastingType;
        }
        return $this;
    }
    /**
     * Get ForecastingTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastingTypeId()
    {
        return isset($this->ForecastingTypeId) ? $this->ForecastingTypeId : null;
    }
    /**
     * Set ForecastingTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastingTypeId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setForecastingTypeId($forecastingTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($forecastingTypeId) && !is_string($forecastingTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastingTypeId, true), gettype($forecastingTypeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($forecastingTypeId) && mb_strlen($forecastingTypeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($forecastingTypeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($forecastingTypeId) && !preg_match('/[a-zA-Z0-9]{18}/', $forecastingTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($forecastingTypeId, true)), __LINE__);
        }
        if (is_null($forecastingTypeId) || (is_array($forecastingTypeId) && empty($forecastingTypeId))) {
            unset($this->ForecastingTypeId);
        } else {
            $this->ForecastingTypeId = $forecastingTypeId;
        }
        return $this;
    }
    /**
     * Get HasAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasAdjustment()
    {
        return isset($this->HasAdjustment) ? $this->HasAdjustment : null;
    }
    /**
     * Set HasAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasAdjustment
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setHasAdjustment($hasAdjustment = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasAdjustment) && !is_bool($hasAdjustment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasAdjustment, true), gettype($hasAdjustment)), __LINE__);
        }
        if (is_null($hasAdjustment) || (is_array($hasAdjustment) && empty($hasAdjustment))) {
            unset($this->HasAdjustment);
        } else {
            $this->HasAdjustment = $hasAdjustment;
        }
        return $this;
    }
    /**
     * Get HasOwnerAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasOwnerAdjustment()
    {
        return isset($this->HasOwnerAdjustment) ? $this->HasOwnerAdjustment : null;
    }
    /**
     * Set HasOwnerAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasOwnerAdjustment
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setHasOwnerAdjustment($hasOwnerAdjustment = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasOwnerAdjustment) && !is_bool($hasOwnerAdjustment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasOwnerAdjustment, true), gettype($hasOwnerAdjustment)), __LINE__);
        }
        if (is_null($hasOwnerAdjustment) || (is_array($hasOwnerAdjustment) && empty($hasOwnerAdjustment))) {
            unset($this->HasOwnerAdjustment);
        } else {
            $this->HasOwnerAdjustment = $hasOwnerAdjustment;
        }
        return $this;
    }
    /**
     * Get IsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAmount()
    {
        return isset($this->IsAmount) ? $this->IsAmount : null;
    }
    /**
     * Set IsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAmount
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setIsAmount($isAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAmount) && !is_bool($isAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAmount, true), gettype($isAmount)), __LINE__);
        }
        if (is_null($isAmount) || (is_array($isAmount) && empty($isAmount))) {
            unset($this->IsAmount);
        } else {
            $this->IsAmount = $isAmount;
        }
        return $this;
    }
    /**
     * Get IsQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsQuantity()
    {
        return isset($this->IsQuantity) ? $this->IsQuantity : null;
    }
    /**
     * Set IsQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isQuantity
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setIsQuantity($isQuantity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isQuantity) && !is_bool($isQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isQuantity, true), gettype($isQuantity)), __LINE__);
        }
        if (is_null($isQuantity) || (is_array($isQuantity) && empty($isQuantity))) {
            unset($this->IsQuantity);
        } else {
            $this->IsQuantity = $isQuantity;
        }
        return $this;
    }
    /**
     * Get IsUpToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpToDate()
    {
        return isset($this->IsUpToDate) ? $this->IsUpToDate : null;
    }
    /**
     * Set IsUpToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpToDate
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setIsUpToDate($isUpToDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpToDate) && !is_bool($isUpToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpToDate, true), gettype($isUpToDate)), __LINE__);
        }
        if (is_null($isUpToDate) || (is_array($isUpToDate) && empty($isUpToDate))) {
            unset($this->IsUpToDate);
        } else {
            $this->IsUpToDate = $isUpToDate;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\User $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get OwnerOnlyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOwnerOnlyAmount()
    {
        return isset($this->OwnerOnlyAmount) ? $this->OwnerOnlyAmount : null;
    }
    /**
     * Set OwnerOnlyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ownerOnlyAmount
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setOwnerOnlyAmount($ownerOnlyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($ownerOnlyAmount) && !(is_float($ownerOnlyAmount) || is_numeric($ownerOnlyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ownerOnlyAmount, true), gettype($ownerOnlyAmount)), __LINE__);
        }
        if (is_null($ownerOnlyAmount) || (is_array($ownerOnlyAmount) && empty($ownerOnlyAmount))) {
            unset($this->OwnerOnlyAmount);
        } else {
            $this->OwnerOnlyAmount = $ownerOnlyAmount;
        }
        return $this;
    }
    /**
     * Get OwnerOnlyQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOwnerOnlyQuantity()
    {
        return isset($this->OwnerOnlyQuantity) ? $this->OwnerOnlyQuantity : null;
    }
    /**
     * Set OwnerOnlyQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ownerOnlyQuantity
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setOwnerOnlyQuantity($ownerOnlyQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($ownerOnlyQuantity) && !(is_float($ownerOnlyQuantity) || is_numeric($ownerOnlyQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ownerOnlyQuantity, true), gettype($ownerOnlyQuantity)), __LINE__);
        }
        if (is_null($ownerOnlyQuantity) || (is_array($ownerOnlyQuantity) && empty($ownerOnlyQuantity))) {
            unset($this->OwnerOnlyQuantity);
        } else {
            $this->OwnerOnlyQuantity = $ownerOnlyQuantity;
        }
        return $this;
    }
    /**
     * Get ParentForecastingItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem|null
     */
    public function getParentForecastingItem()
    {
        return isset($this->ParentForecastingItem) ? $this->ParentForecastingItem : null;
    }
    /**
     * Set ParentForecastingItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ForecastingItem $parentForecastingItem
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setParentForecastingItem(\NexusDigital/MiratelForce\StructType\ForecastingItem $parentForecastingItem = null)
    {
        if (is_null($parentForecastingItem) || (is_array($parentForecastingItem) && empty($parentForecastingItem))) {
            unset($this->ParentForecastingItem);
        } else {
            $this->ParentForecastingItem = $parentForecastingItem;
        }
        return $this;
    }
    /**
     * Get ParentForecastingItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentForecastingItemId()
    {
        return isset($this->ParentForecastingItemId) ? $this->ParentForecastingItemId : null;
    }
    /**
     * Set ParentForecastingItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentForecastingItemId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setParentForecastingItemId($parentForecastingItemId = null)
    {
        // validation for constraint: string
        if (!is_null($parentForecastingItemId) && !is_string($parentForecastingItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentForecastingItemId, true), gettype($parentForecastingItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentForecastingItemId) && mb_strlen($parentForecastingItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentForecastingItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentForecastingItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentForecastingItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentForecastingItemId, true)), __LINE__);
        }
        if (is_null($parentForecastingItemId) || (is_array($parentForecastingItemId) && empty($parentForecastingItemId))) {
            unset($this->ParentForecastingItemId);
        } else {
            $this->ParentForecastingItemId = $parentForecastingItemId;
        }
        return $this;
    }
    /**
     * Get Period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Period|null
     */
    public function getPeriod()
    {
        return isset($this->Period) ? $this->Period : null;
    }
    /**
     * Set Period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Period $period
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setPeriod(\NexusDigital/MiratelForce\StructType\Period $period = null)
    {
        if (is_null($period) || (is_array($period) && empty($period))) {
            unset($this->Period);
        } else {
            $this->Period = $period;
        }
        return $this;
    }
    /**
     * Get PeriodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodId()
    {
        return isset($this->PeriodId) ? $this->PeriodId : null;
    }
    /**
     * Set PeriodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setPeriodId($periodId = null)
    {
        // validation for constraint: string
        if (!is_null($periodId) && !is_string($periodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodId, true), gettype($periodId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($periodId) && mb_strlen($periodId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($periodId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($periodId) && !preg_match('/[a-zA-Z0-9]{18}/', $periodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($periodId, true)), __LINE__);
        }
        if (is_null($periodId) || (is_array($periodId) && empty($periodId))) {
            unset($this->PeriodId);
        } else {
            $this->PeriodId = $periodId;
        }
        return $this;
    }
    /**
     * Get ProductFamily value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductFamily()
    {
        return isset($this->ProductFamily) ? $this->ProductFamily : null;
    }
    /**
     * Set ProductFamily value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productFamily
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setProductFamily($productFamily = null)
    {
        // validation for constraint: string
        if (!is_null($productFamily) && !is_string($productFamily)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productFamily, true), gettype($productFamily)), __LINE__);
        }
        if (is_null($productFamily) || (is_array($productFamily) && empty($productFamily))) {
            unset($this->ProductFamily);
        } else {
            $this->ProductFamily = $productFamily;
        }
        return $this;
    }
    /**
     * Get QuantityWithoutAdjustments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityWithoutAdjustments()
    {
        return isset($this->QuantityWithoutAdjustments) ? $this->QuantityWithoutAdjustments : null;
    }
    /**
     * Set QuantityWithoutAdjustments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityWithoutAdjustments
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setQuantityWithoutAdjustments($quantityWithoutAdjustments = null)
    {
        // validation for constraint: float
        if (!is_null($quantityWithoutAdjustments) && !(is_float($quantityWithoutAdjustments) || is_numeric($quantityWithoutAdjustments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityWithoutAdjustments, true), gettype($quantityWithoutAdjustments)), __LINE__);
        }
        if (is_null($quantityWithoutAdjustments) || (is_array($quantityWithoutAdjustments) && empty($quantityWithoutAdjustments))) {
            unset($this->QuantityWithoutAdjustments);
        } else {
            $this->QuantityWithoutAdjustments = $quantityWithoutAdjustments;
        }
        return $this;
    }
    /**
     * Get QuantityWithoutManagerAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityWithoutManagerAdjustment()
    {
        return isset($this->QuantityWithoutManagerAdjustment) ? $this->QuantityWithoutManagerAdjustment : null;
    }
    /**
     * Set QuantityWithoutManagerAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityWithoutManagerAdjustment
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setQuantityWithoutManagerAdjustment($quantityWithoutManagerAdjustment = null)
    {
        // validation for constraint: float
        if (!is_null($quantityWithoutManagerAdjustment) && !(is_float($quantityWithoutManagerAdjustment) || is_numeric($quantityWithoutManagerAdjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityWithoutManagerAdjustment, true), gettype($quantityWithoutManagerAdjustment)), __LINE__);
        }
        if (is_null($quantityWithoutManagerAdjustment) || (is_array($quantityWithoutManagerAdjustment) && empty($quantityWithoutManagerAdjustment))) {
            unset($this->QuantityWithoutManagerAdjustment);
        } else {
            $this->QuantityWithoutManagerAdjustment = $quantityWithoutManagerAdjustment;
        }
        return $this;
    }
    /**
     * Get QuantityWithoutOwnerAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityWithoutOwnerAdjustment()
    {
        return isset($this->QuantityWithoutOwnerAdjustment) ? $this->QuantityWithoutOwnerAdjustment : null;
    }
    /**
     * Set QuantityWithoutOwnerAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityWithoutOwnerAdjustment
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setQuantityWithoutOwnerAdjustment($quantityWithoutOwnerAdjustment = null)
    {
        // validation for constraint: float
        if (!is_null($quantityWithoutOwnerAdjustment) && !(is_float($quantityWithoutOwnerAdjustment) || is_numeric($quantityWithoutOwnerAdjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityWithoutOwnerAdjustment, true), gettype($quantityWithoutOwnerAdjustment)), __LINE__);
        }
        if (is_null($quantityWithoutOwnerAdjustment) || (is_array($quantityWithoutOwnerAdjustment) && empty($quantityWithoutOwnerAdjustment))) {
            unset($this->QuantityWithoutOwnerAdjustment);
        } else {
            $this->QuantityWithoutOwnerAdjustment = $quantityWithoutOwnerAdjustment;
        }
        return $this;
    }
    /**
     * Get SubordinateOverrides value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubordinateOverrides()
    {
        return isset($this->SubordinateOverrides) ? $this->SubordinateOverrides : null;
    }
    /**
     * Set SubordinateOverrides value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subordinateOverrides
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setSubordinateOverrides($subordinateOverrides = null)
    {
        // validation for constraint: int
        if (!is_null($subordinateOverrides) && !(is_int($subordinateOverrides) || ctype_digit($subordinateOverrides))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subordinateOverrides, true), gettype($subordinateOverrides)), __LINE__);
        }
        if (is_null($subordinateOverrides) || (is_array($subordinateOverrides) && empty($subordinateOverrides))) {
            unset($this->SubordinateOverrides);
        } else {
            $this->SubordinateOverrides = $subordinateOverrides;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
