<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForecastingFact StructType
 * @subpackage Structs
 */
class ForecastingFact extends SObject
{
    /**
     * The ForecastCategoryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastCategoryName;
    /**
     * The ForecastedObjectId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ForecastedObjectId;
    /**
     * The ForecastingItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ForecastingItem
     */
    public $ForecastingItem;
    /**
     * The ForecastingItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ForecastingItemId;
    /**
     * The ForecastingType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ForecastingType
     */
    public $ForecastingType;
    /**
     * The ForecastingTypeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ForecastingTypeId;
    /**
     * The OpportunityId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OpportunityId;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The PeriodId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PeriodId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for ForecastingFact
     * @uses ForecastingFact::setForecastCategoryName()
     * @uses ForecastingFact::setForecastedObjectId()
     * @uses ForecastingFact::setForecastingItem()
     * @uses ForecastingFact::setForecastingItemId()
     * @uses ForecastingFact::setForecastingType()
     * @uses ForecastingFact::setForecastingTypeId()
     * @uses ForecastingFact::setOpportunityId()
     * @uses ForecastingFact::setOwner()
     * @uses ForecastingFact::setOwnerId()
     * @uses ForecastingFact::setPeriodId()
     * @uses ForecastingFact::setSystemModstamp()
     * @param string $forecastCategoryName
     * @param string $forecastedObjectId
     * @param \NexusDigital/MiratelForce\StructType\ForecastingItem $forecastingItem
     * @param string $forecastingItemId
     * @param \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType
     * @param string $forecastingTypeId
     * @param string $opportunityId
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @param string $ownerId
     * @param string $periodId
     * @param string $systemModstamp
     */
    public function __construct($forecastCategoryName = null, $forecastedObjectId = null, \NexusDigital/MiratelForce\StructType\ForecastingItem $forecastingItem = null, $forecastingItemId = null, \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType = null, $forecastingTypeId = null, $opportunityId = null, \NexusDigital/MiratelForce\StructType\User $owner = null, $ownerId = null, $periodId = null, $systemModstamp = null)
    {
        $this
            ->setForecastCategoryName($forecastCategoryName)
            ->setForecastedObjectId($forecastedObjectId)
            ->setForecastingItem($forecastingItem)
            ->setForecastingItemId($forecastingItemId)
            ->setForecastingType($forecastingType)
            ->setForecastingTypeId($forecastingTypeId)
            ->setOpportunityId($opportunityId)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setPeriodId($periodId)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get ForecastCategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastCategoryName()
    {
        return isset($this->ForecastCategoryName) ? $this->ForecastCategoryName : null;
    }
    /**
     * Set ForecastCategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastCategoryName
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setForecastCategoryName($forecastCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($forecastCategoryName) && !is_string($forecastCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastCategoryName, true), gettype($forecastCategoryName)), __LINE__);
        }
        if (is_null($forecastCategoryName) || (is_array($forecastCategoryName) && empty($forecastCategoryName))) {
            unset($this->ForecastCategoryName);
        } else {
            $this->ForecastCategoryName = $forecastCategoryName;
        }
        return $this;
    }
    /**
     * Get ForecastedObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastedObjectId()
    {
        return isset($this->ForecastedObjectId) ? $this->ForecastedObjectId : null;
    }
    /**
     * Set ForecastedObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastedObjectId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setForecastedObjectId($forecastedObjectId = null)
    {
        // validation for constraint: string
        if (!is_null($forecastedObjectId) && !is_string($forecastedObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastedObjectId, true), gettype($forecastedObjectId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($forecastedObjectId) && mb_strlen($forecastedObjectId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($forecastedObjectId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($forecastedObjectId) && !preg_match('/[a-zA-Z0-9]{18}/', $forecastedObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($forecastedObjectId, true)), __LINE__);
        }
        if (is_null($forecastedObjectId) || (is_array($forecastedObjectId) && empty($forecastedObjectId))) {
            unset($this->ForecastedObjectId);
        } else {
            $this->ForecastedObjectId = $forecastedObjectId;
        }
        return $this;
    }
    /**
     * Get ForecastingItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ForecastingItem|null
     */
    public function getForecastingItem()
    {
        return isset($this->ForecastingItem) ? $this->ForecastingItem : null;
    }
    /**
     * Set ForecastingItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ForecastingItem $forecastingItem
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setForecastingItem(\NexusDigital/MiratelForce\StructType\ForecastingItem $forecastingItem = null)
    {
        if (is_null($forecastingItem) || (is_array($forecastingItem) && empty($forecastingItem))) {
            unset($this->ForecastingItem);
        } else {
            $this->ForecastingItem = $forecastingItem;
        }
        return $this;
    }
    /**
     * Get ForecastingItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastingItemId()
    {
        return isset($this->ForecastingItemId) ? $this->ForecastingItemId : null;
    }
    /**
     * Set ForecastingItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastingItemId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setForecastingItemId($forecastingItemId = null)
    {
        // validation for constraint: string
        if (!is_null($forecastingItemId) && !is_string($forecastingItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastingItemId, true), gettype($forecastingItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($forecastingItemId) && mb_strlen($forecastingItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($forecastingItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($forecastingItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $forecastingItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($forecastingItemId, true)), __LINE__);
        }
        if (is_null($forecastingItemId) || (is_array($forecastingItemId) && empty($forecastingItemId))) {
            unset($this->ForecastingItemId);
        } else {
            $this->ForecastingItemId = $forecastingItemId;
        }
        return $this;
    }
    /**
     * Get ForecastingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ForecastingType|null
     */
    public function getForecastingType()
    {
        return isset($this->ForecastingType) ? $this->ForecastingType : null;
    }
    /**
     * Set ForecastingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setForecastingType(\NexusDigital/MiratelForce\StructType\ForecastingType $forecastingType = null)
    {
        if (is_null($forecastingType) || (is_array($forecastingType) && empty($forecastingType))) {
            unset($this->ForecastingType);
        } else {
            $this->ForecastingType = $forecastingType;
        }
        return $this;
    }
    /**
     * Get ForecastingTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastingTypeId()
    {
        return isset($this->ForecastingTypeId) ? $this->ForecastingTypeId : null;
    }
    /**
     * Set ForecastingTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastingTypeId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setForecastingTypeId($forecastingTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($forecastingTypeId) && !is_string($forecastingTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastingTypeId, true), gettype($forecastingTypeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($forecastingTypeId) && mb_strlen($forecastingTypeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($forecastingTypeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($forecastingTypeId) && !preg_match('/[a-zA-Z0-9]{18}/', $forecastingTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($forecastingTypeId, true)), __LINE__);
        }
        if (is_null($forecastingTypeId) || (is_array($forecastingTypeId) && empty($forecastingTypeId))) {
            unset($this->ForecastingTypeId);
        } else {
            $this->ForecastingTypeId = $forecastingTypeId;
        }
        return $this;
    }
    /**
     * Get OpportunityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpportunityId()
    {
        return isset($this->OpportunityId) ? $this->OpportunityId : null;
    }
    /**
     * Set OpportunityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opportunityId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setOpportunityId($opportunityId = null)
    {
        // validation for constraint: string
        if (!is_null($opportunityId) && !is_string($opportunityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opportunityId, true), gettype($opportunityId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($opportunityId) && mb_strlen($opportunityId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($opportunityId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($opportunityId) && !preg_match('/[a-zA-Z0-9]{18}/', $opportunityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($opportunityId, true)), __LINE__);
        }
        if (is_null($opportunityId) || (is_array($opportunityId) && empty($opportunityId))) {
            unset($this->OpportunityId);
        } else {
            $this->OpportunityId = $opportunityId;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\User $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get PeriodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodId()
    {
        return isset($this->PeriodId) ? $this->PeriodId : null;
    }
    /**
     * Set PeriodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setPeriodId($periodId = null)
    {
        // validation for constraint: string
        if (!is_null($periodId) && !is_string($periodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodId, true), gettype($periodId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($periodId) && mb_strlen($periodId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($periodId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($periodId) && !preg_match('/[a-zA-Z0-9]{18}/', $periodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($periodId, true)), __LINE__);
        }
        if (is_null($periodId) || (is_array($periodId) && empty($periodId))) {
            unset($this->PeriodId);
        } else {
            $this->PeriodId = $periodId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ForecastingFact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
