<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlexQueueItem StructType
 * @subpackage Structs
 */
class FlexQueueItem extends SObject
{
    /**
     * The AsyncApexJob
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public $AsyncApexJob;
    /**
     * The AsyncApexJobId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AsyncApexJobId;
    /**
     * The FlexQueueItemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlexQueueItemId;
    /**
     * The JobPosition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $JobPosition;
    /**
     * The JobType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JobType;
    /**
     * Constructor method for FlexQueueItem
     * @uses FlexQueueItem::setAsyncApexJob()
     * @uses FlexQueueItem::setAsyncApexJobId()
     * @uses FlexQueueItem::setFlexQueueItemId()
     * @uses FlexQueueItem::setJobPosition()
     * @uses FlexQueueItem::setJobType()
     * @param \NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob
     * @param string $asyncApexJobId
     * @param string $flexQueueItemId
     * @param int $jobPosition
     * @param string $jobType
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob = null, $asyncApexJobId = null, $flexQueueItemId = null, $jobPosition = null, $jobType = null)
    {
        $this
            ->setAsyncApexJob($asyncApexJob)
            ->setAsyncApexJobId($asyncApexJobId)
            ->setFlexQueueItemId($flexQueueItemId)
            ->setJobPosition($jobPosition)
            ->setJobType($jobType);
    }
    /**
     * Get AsyncApexJob value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob|null
     */
    public function getAsyncApexJob()
    {
        return isset($this->AsyncApexJob) ? $this->AsyncApexJob : null;
    }
    /**
     * Set AsyncApexJob value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob
     * @return \NexusDigital/MiratelForce\StructType\FlexQueueItem
     */
    public function setAsyncApexJob(\NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob = null)
    {
        if (is_null($asyncApexJob) || (is_array($asyncApexJob) && empty($asyncApexJob))) {
            unset($this->AsyncApexJob);
        } else {
            $this->AsyncApexJob = $asyncApexJob;
        }
        return $this;
    }
    /**
     * Get AsyncApexJobId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsyncApexJobId()
    {
        return isset($this->AsyncApexJobId) ? $this->AsyncApexJobId : null;
    }
    /**
     * Set AsyncApexJobId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asyncApexJobId
     * @return \NexusDigital/MiratelForce\StructType\FlexQueueItem
     */
    public function setAsyncApexJobId($asyncApexJobId = null)
    {
        // validation for constraint: string
        if (!is_null($asyncApexJobId) && !is_string($asyncApexJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asyncApexJobId, true), gettype($asyncApexJobId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($asyncApexJobId) && mb_strlen($asyncApexJobId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($asyncApexJobId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($asyncApexJobId) && !preg_match('/[a-zA-Z0-9]{18}/', $asyncApexJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($asyncApexJobId, true)), __LINE__);
        }
        if (is_null($asyncApexJobId) || (is_array($asyncApexJobId) && empty($asyncApexJobId))) {
            unset($this->AsyncApexJobId);
        } else {
            $this->AsyncApexJobId = $asyncApexJobId;
        }
        return $this;
    }
    /**
     * Get FlexQueueItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlexQueueItemId()
    {
        return isset($this->FlexQueueItemId) ? $this->FlexQueueItemId : null;
    }
    /**
     * Set FlexQueueItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flexQueueItemId
     * @return \NexusDigital/MiratelForce\StructType\FlexQueueItem
     */
    public function setFlexQueueItemId($flexQueueItemId = null)
    {
        // validation for constraint: string
        if (!is_null($flexQueueItemId) && !is_string($flexQueueItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flexQueueItemId, true), gettype($flexQueueItemId)), __LINE__);
        }
        if (is_null($flexQueueItemId) || (is_array($flexQueueItemId) && empty($flexQueueItemId))) {
            unset($this->FlexQueueItemId);
        } else {
            $this->FlexQueueItemId = $flexQueueItemId;
        }
        return $this;
    }
    /**
     * Get JobPosition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getJobPosition()
    {
        return isset($this->JobPosition) ? $this->JobPosition : null;
    }
    /**
     * Set JobPosition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $jobPosition
     * @return \NexusDigital/MiratelForce\StructType\FlexQueueItem
     */
    public function setJobPosition($jobPosition = null)
    {
        // validation for constraint: int
        if (!is_null($jobPosition) && !(is_int($jobPosition) || ctype_digit($jobPosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobPosition, true), gettype($jobPosition)), __LINE__);
        }
        if (is_null($jobPosition) || (is_array($jobPosition) && empty($jobPosition))) {
            unset($this->JobPosition);
        } else {
            $this->JobPosition = $jobPosition;
        }
        return $this;
    }
    /**
     * Get JobType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobType()
    {
        return isset($this->JobType) ? $this->JobType : null;
    }
    /**
     * Set JobType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jobType
     * @return \NexusDigital/MiratelForce\StructType\FlexQueueItem
     */
    public function setJobType($jobType = null)
    {
        // validation for constraint: string
        if (!is_null($jobType) && !is_string($jobType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobType, true), gettype($jobType)), __LINE__);
        }
        if (is_null($jobType) || (is_array($jobType) && empty($jobType))) {
            unset($this->JobType);
        } else {
            $this->JobType = $jobType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\FlexQueueItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
