<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FiscalYearSettings StructType
 * @subpackage Structs
 */
class FiscalYearSettings extends SObject
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The IsStandardYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStandardYear;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The PeriodId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PeriodId;
    /**
     * The PeriodLabelScheme
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PeriodLabelScheme;
    /**
     * The PeriodPrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PeriodPrefix;
    /**
     * The Periods
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Periods;
    /**
     * The QuarterLabelScheme
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuarterLabelScheme;
    /**
     * The QuarterPrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuarterPrefix;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The WeekLabelScheme
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WeekLabelScheme;
    /**
     * The WeekStartDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WeekStartDay;
    /**
     * The YearType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $YearType;
    /**
     * Constructor method for FiscalYearSettings
     * @uses FiscalYearSettings::setDescription()
     * @uses FiscalYearSettings::setEndDate()
     * @uses FiscalYearSettings::setIsStandardYear()
     * @uses FiscalYearSettings::setName()
     * @uses FiscalYearSettings::setPeriodId()
     * @uses FiscalYearSettings::setPeriodLabelScheme()
     * @uses FiscalYearSettings::setPeriodPrefix()
     * @uses FiscalYearSettings::setPeriods()
     * @uses FiscalYearSettings::setQuarterLabelScheme()
     * @uses FiscalYearSettings::setQuarterPrefix()
     * @uses FiscalYearSettings::setStartDate()
     * @uses FiscalYearSettings::setSystemModstamp()
     * @uses FiscalYearSettings::setWeekLabelScheme()
     * @uses FiscalYearSettings::setWeekStartDay()
     * @uses FiscalYearSettings::setYearType()
     * @param string $description
     * @param string $endDate
     * @param bool $isStandardYear
     * @param string $name
     * @param string $periodId
     * @param string $periodLabelScheme
     * @param string $periodPrefix
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $periods
     * @param string $quarterLabelScheme
     * @param string $quarterPrefix
     * @param string $startDate
     * @param string $systemModstamp
     * @param string $weekLabelScheme
     * @param int $weekStartDay
     * @param string $yearType
     */
    public function __construct($description = null, $endDate = null, $isStandardYear = null, $name = null, $periodId = null, $periodLabelScheme = null, $periodPrefix = null, \NexusDigital/MiratelForce\StructType\QueryResult $periods = null, $quarterLabelScheme = null, $quarterPrefix = null, $startDate = null, $systemModstamp = null, $weekLabelScheme = null, $weekStartDay = null, $yearType = null)
    {
        $this
            ->setDescription($description)
            ->setEndDate($endDate)
            ->setIsStandardYear($isStandardYear)
            ->setName($name)
            ->setPeriodId($periodId)
            ->setPeriodLabelScheme($periodLabelScheme)
            ->setPeriodPrefix($periodPrefix)
            ->setPeriods($periods)
            ->setQuarterLabelScheme($quarterLabelScheme)
            ->setQuarterPrefix($quarterPrefix)
            ->setStartDate($startDate)
            ->setSystemModstamp($systemModstamp)
            ->setWeekLabelScheme($weekLabelScheme)
            ->setWeekStartDay($weekStartDay)
            ->setYearType($yearType);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get IsStandardYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStandardYear()
    {
        return isset($this->IsStandardYear) ? $this->IsStandardYear : null;
    }
    /**
     * Set IsStandardYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStandardYear
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setIsStandardYear($isStandardYear = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStandardYear) && !is_bool($isStandardYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStandardYear, true), gettype($isStandardYear)), __LINE__);
        }
        if (is_null($isStandardYear) || (is_array($isStandardYear) && empty($isStandardYear))) {
            unset($this->IsStandardYear);
        } else {
            $this->IsStandardYear = $isStandardYear;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PeriodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodId()
    {
        return isset($this->PeriodId) ? $this->PeriodId : null;
    }
    /**
     * Set PeriodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodId
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setPeriodId($periodId = null)
    {
        // validation for constraint: string
        if (!is_null($periodId) && !is_string($periodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodId, true), gettype($periodId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($periodId) && mb_strlen($periodId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($periodId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($periodId) && !preg_match('/[a-zA-Z0-9]{18}/', $periodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($periodId, true)), __LINE__);
        }
        if (is_null($periodId) || (is_array($periodId) && empty($periodId))) {
            unset($this->PeriodId);
        } else {
            $this->PeriodId = $periodId;
        }
        return $this;
    }
    /**
     * Get PeriodLabelScheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodLabelScheme()
    {
        return isset($this->PeriodLabelScheme) ? $this->PeriodLabelScheme : null;
    }
    /**
     * Set PeriodLabelScheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodLabelScheme
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setPeriodLabelScheme($periodLabelScheme = null)
    {
        // validation for constraint: string
        if (!is_null($periodLabelScheme) && !is_string($periodLabelScheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodLabelScheme, true), gettype($periodLabelScheme)), __LINE__);
        }
        if (is_null($periodLabelScheme) || (is_array($periodLabelScheme) && empty($periodLabelScheme))) {
            unset($this->PeriodLabelScheme);
        } else {
            $this->PeriodLabelScheme = $periodLabelScheme;
        }
        return $this;
    }
    /**
     * Get PeriodPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodPrefix()
    {
        return isset($this->PeriodPrefix) ? $this->PeriodPrefix : null;
    }
    /**
     * Set PeriodPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodPrefix
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setPeriodPrefix($periodPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($periodPrefix) && !is_string($periodPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodPrefix, true), gettype($periodPrefix)), __LINE__);
        }
        if (is_null($periodPrefix) || (is_array($periodPrefix) && empty($periodPrefix))) {
            unset($this->PeriodPrefix);
        } else {
            $this->PeriodPrefix = $periodPrefix;
        }
        return $this;
    }
    /**
     * Get Periods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getPeriods()
    {
        return isset($this->Periods) ? $this->Periods : null;
    }
    /**
     * Set Periods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $periods
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setPeriods(\NexusDigital/MiratelForce\StructType\QueryResult $periods = null)
    {
        if (is_null($periods) || (is_array($periods) && empty($periods))) {
            unset($this->Periods);
        } else {
            $this->Periods = $periods;
        }
        return $this;
    }
    /**
     * Get QuarterLabelScheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuarterLabelScheme()
    {
        return isset($this->QuarterLabelScheme) ? $this->QuarterLabelScheme : null;
    }
    /**
     * Set QuarterLabelScheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $quarterLabelScheme
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setQuarterLabelScheme($quarterLabelScheme = null)
    {
        // validation for constraint: string
        if (!is_null($quarterLabelScheme) && !is_string($quarterLabelScheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quarterLabelScheme, true), gettype($quarterLabelScheme)), __LINE__);
        }
        if (is_null($quarterLabelScheme) || (is_array($quarterLabelScheme) && empty($quarterLabelScheme))) {
            unset($this->QuarterLabelScheme);
        } else {
            $this->QuarterLabelScheme = $quarterLabelScheme;
        }
        return $this;
    }
    /**
     * Get QuarterPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuarterPrefix()
    {
        return isset($this->QuarterPrefix) ? $this->QuarterPrefix : null;
    }
    /**
     * Set QuarterPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $quarterPrefix
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setQuarterPrefix($quarterPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($quarterPrefix) && !is_string($quarterPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quarterPrefix, true), gettype($quarterPrefix)), __LINE__);
        }
        if (is_null($quarterPrefix) || (is_array($quarterPrefix) && empty($quarterPrefix))) {
            unset($this->QuarterPrefix);
        } else {
            $this->QuarterPrefix = $quarterPrefix;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get WeekLabelScheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWeekLabelScheme()
    {
        return isset($this->WeekLabelScheme) ? $this->WeekLabelScheme : null;
    }
    /**
     * Set WeekLabelScheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $weekLabelScheme
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setWeekLabelScheme($weekLabelScheme = null)
    {
        // validation for constraint: string
        if (!is_null($weekLabelScheme) && !is_string($weekLabelScheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weekLabelScheme, true), gettype($weekLabelScheme)), __LINE__);
        }
        if (is_null($weekLabelScheme) || (is_array($weekLabelScheme) && empty($weekLabelScheme))) {
            unset($this->WeekLabelScheme);
        } else {
            $this->WeekLabelScheme = $weekLabelScheme;
        }
        return $this;
    }
    /**
     * Get WeekStartDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWeekStartDay()
    {
        return isset($this->WeekStartDay) ? $this->WeekStartDay : null;
    }
    /**
     * Set WeekStartDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $weekStartDay
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setWeekStartDay($weekStartDay = null)
    {
        // validation for constraint: int
        if (!is_null($weekStartDay) && !(is_int($weekStartDay) || ctype_digit($weekStartDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weekStartDay, true), gettype($weekStartDay)), __LINE__);
        }
        if (is_null($weekStartDay) || (is_array($weekStartDay) && empty($weekStartDay))) {
            unset($this->WeekStartDay);
        } else {
            $this->WeekStartDay = $weekStartDay;
        }
        return $this;
    }
    /**
     * Get YearType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getYearType()
    {
        return isset($this->YearType) ? $this->YearType : null;
    }
    /**
     * Set YearType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $yearType
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public function setYearType($yearType = null)
    {
        // validation for constraint: string
        if (!is_null($yearType) && !is_string($yearType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yearType, true), gettype($yearType)), __LINE__);
        }
        if (is_null($yearType) || (is_array($yearType) && empty($yearType))) {
            unset($this->YearType);
        } else {
            $this->YearType = $yearType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\FiscalYearSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
