<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailStatus StructType
 * @subpackage Structs
 */
class EmailStatus extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The EmailTemplateName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailTemplateName;
    /**
     * The FirstOpenDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstOpenDate;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastOpenDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastOpenDate;
    /**
     * The Task
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Task
     */
    public $Task;
    /**
     * The TaskId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $TaskId;
    /**
     * The TimesOpened
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TimesOpened;
    /**
     * The Who
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Who;
    /**
     * The WhoId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $WhoId;
    /**
     * Constructor method for EmailStatus
     * @uses EmailStatus::setCreatedBy()
     * @uses EmailStatus::setCreatedById()
     * @uses EmailStatus::setCreatedDate()
     * @uses EmailStatus::setEmailTemplateName()
     * @uses EmailStatus::setFirstOpenDate()
     * @uses EmailStatus::setLastModifiedBy()
     * @uses EmailStatus::setLastModifiedById()
     * @uses EmailStatus::setLastModifiedDate()
     * @uses EmailStatus::setLastOpenDate()
     * @uses EmailStatus::setTask()
     * @uses EmailStatus::setTaskId()
     * @uses EmailStatus::setTimesOpened()
     * @uses EmailStatus::setWho()
     * @uses EmailStatus::setWhoId()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $emailTemplateName
     * @param string $firstOpenDate
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastOpenDate
     * @param \NexusDigital/MiratelForce\StructType\Task $task
     * @param string $taskId
     * @param int $timesOpened
     * @param \NexusDigital/MiratelForce\StructType\SObject $who
     * @param string $whoId
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $emailTemplateName = null, $firstOpenDate = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastOpenDate = null, \NexusDigital/MiratelForce\StructType\Task $task = null, $taskId = null, $timesOpened = null, \NexusDigital/MiratelForce\StructType\SObject $who = null, $whoId = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setEmailTemplateName($emailTemplateName)
            ->setFirstOpenDate($firstOpenDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastOpenDate($lastOpenDate)
            ->setTask($task)
            ->setTaskId($taskId)
            ->setTimesOpened($timesOpened)
            ->setWho($who)
            ->setWhoId($whoId);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get EmailTemplateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailTemplateName()
    {
        return isset($this->EmailTemplateName) ? $this->EmailTemplateName : null;
    }
    /**
     * Set EmailTemplateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailTemplateName
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setEmailTemplateName($emailTemplateName = null)
    {
        // validation for constraint: string
        if (!is_null($emailTemplateName) && !is_string($emailTemplateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailTemplateName, true), gettype($emailTemplateName)), __LINE__);
        }
        if (is_null($emailTemplateName) || (is_array($emailTemplateName) && empty($emailTemplateName))) {
            unset($this->EmailTemplateName);
        } else {
            $this->EmailTemplateName = $emailTemplateName;
        }
        return $this;
    }
    /**
     * Get FirstOpenDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstOpenDate()
    {
        return isset($this->FirstOpenDate) ? $this->FirstOpenDate : null;
    }
    /**
     * Set FirstOpenDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstOpenDate
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setFirstOpenDate($firstOpenDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstOpenDate) && !is_string($firstOpenDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstOpenDate, true), gettype($firstOpenDate)), __LINE__);
        }
        if (is_null($firstOpenDate) || (is_array($firstOpenDate) && empty($firstOpenDate))) {
            unset($this->FirstOpenDate);
        } else {
            $this->FirstOpenDate = $firstOpenDate;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastOpenDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastOpenDate()
    {
        return isset($this->LastOpenDate) ? $this->LastOpenDate : null;
    }
    /**
     * Set LastOpenDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastOpenDate
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setLastOpenDate($lastOpenDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastOpenDate) && !is_string($lastOpenDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastOpenDate, true), gettype($lastOpenDate)), __LINE__);
        }
        if (is_null($lastOpenDate) || (is_array($lastOpenDate) && empty($lastOpenDate))) {
            unset($this->LastOpenDate);
        } else {
            $this->LastOpenDate = $lastOpenDate;
        }
        return $this;
    }
    /**
     * Get Task value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Task|null
     */
    public function getTask()
    {
        return isset($this->Task) ? $this->Task : null;
    }
    /**
     * Set Task value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Task $task
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setTask(\NexusDigital/MiratelForce\StructType\Task $task = null)
    {
        if (is_null($task) || (is_array($task) && empty($task))) {
            unset($this->Task);
        } else {
            $this->Task = $task;
        }
        return $this;
    }
    /**
     * Get TaskId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaskId()
    {
        return isset($this->TaskId) ? $this->TaskId : null;
    }
    /**
     * Set TaskId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taskId
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setTaskId($taskId = null)
    {
        // validation for constraint: string
        if (!is_null($taskId) && !is_string($taskId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taskId, true), gettype($taskId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($taskId) && mb_strlen($taskId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($taskId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($taskId) && !preg_match('/[a-zA-Z0-9]{18}/', $taskId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($taskId, true)), __LINE__);
        }
        if (is_null($taskId) || (is_array($taskId) && empty($taskId))) {
            unset($this->TaskId);
        } else {
            $this->TaskId = $taskId;
        }
        return $this;
    }
    /**
     * Get TimesOpened value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTimesOpened()
    {
        return isset($this->TimesOpened) ? $this->TimesOpened : null;
    }
    /**
     * Set TimesOpened value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $timesOpened
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setTimesOpened($timesOpened = null)
    {
        // validation for constraint: int
        if (!is_null($timesOpened) && !(is_int($timesOpened) || ctype_digit($timesOpened))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timesOpened, true), gettype($timesOpened)), __LINE__);
        }
        if (is_null($timesOpened) || (is_array($timesOpened) && empty($timesOpened))) {
            unset($this->TimesOpened);
        } else {
            $this->TimesOpened = $timesOpened;
        }
        return $this;
    }
    /**
     * Get Who value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getWho()
    {
        return isset($this->Who) ? $this->Who : null;
    }
    /**
     * Set Who value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $who
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setWho(\NexusDigital/MiratelForce\StructType\SObject $who = null)
    {
        if (is_null($who) || (is_array($who) && empty($who))) {
            unset($this->Who);
        } else {
            $this->Who = $who;
        }
        return $this;
    }
    /**
     * Get WhoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhoId()
    {
        return isset($this->WhoId) ? $this->WhoId : null;
    }
    /**
     * Set WhoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $whoId
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public function setWhoId($whoId = null)
    {
        // validation for constraint: string
        if (!is_null($whoId) && !is_string($whoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whoId, true), gettype($whoId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($whoId) && mb_strlen($whoId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($whoId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($whoId) && !preg_match('/[a-zA-Z0-9]{18}/', $whoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($whoId, true)), __LINE__);
        }
        if (is_null($whoId) || (is_array($whoId) && empty($whoId))) {
            unset($this->WhoId);
        } else {
            $this->WhoId = $whoId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\EmailStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
