<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataType StructType
 * @subpackage Structs
 */
class DataType extends SObject
{
    /**
     * The ContextServiceDataTypeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextServiceDataTypeId;
    /**
     * The ContextWsdlDataTypeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextWsdlDataTypeId;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The IsComplex
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplex;
    /**
     * Constructor method for DataType
     * @uses DataType::setContextServiceDataTypeId()
     * @uses DataType::setContextWsdlDataTypeId()
     * @uses DataType::setDeveloperName()
     * @uses DataType::setDurableId()
     * @uses DataType::setIsComplex()
     * @param string $contextServiceDataTypeId
     * @param string $contextWsdlDataTypeId
     * @param string $developerName
     * @param string $durableId
     * @param bool $isComplex
     */
    public function __construct($contextServiceDataTypeId = null, $contextWsdlDataTypeId = null, $developerName = null, $durableId = null, $isComplex = null)
    {
        $this
            ->setContextServiceDataTypeId($contextServiceDataTypeId)
            ->setContextWsdlDataTypeId($contextWsdlDataTypeId)
            ->setDeveloperName($developerName)
            ->setDurableId($durableId)
            ->setIsComplex($isComplex);
    }
    /**
     * Get ContextServiceDataTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextServiceDataTypeId()
    {
        return isset($this->ContextServiceDataTypeId) ? $this->ContextServiceDataTypeId : null;
    }
    /**
     * Set ContextServiceDataTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextServiceDataTypeId
     * @return \NexusDigital/MiratelForce\StructType\DataType
     */
    public function setContextServiceDataTypeId($contextServiceDataTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($contextServiceDataTypeId) && !is_string($contextServiceDataTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextServiceDataTypeId, true), gettype($contextServiceDataTypeId)), __LINE__);
        }
        if (is_null($contextServiceDataTypeId) || (is_array($contextServiceDataTypeId) && empty($contextServiceDataTypeId))) {
            unset($this->ContextServiceDataTypeId);
        } else {
            $this->ContextServiceDataTypeId = $contextServiceDataTypeId;
        }
        return $this;
    }
    /**
     * Get ContextWsdlDataTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextWsdlDataTypeId()
    {
        return isset($this->ContextWsdlDataTypeId) ? $this->ContextWsdlDataTypeId : null;
    }
    /**
     * Set ContextWsdlDataTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextWsdlDataTypeId
     * @return \NexusDigital/MiratelForce\StructType\DataType
     */
    public function setContextWsdlDataTypeId($contextWsdlDataTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($contextWsdlDataTypeId) && !is_string($contextWsdlDataTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextWsdlDataTypeId, true), gettype($contextWsdlDataTypeId)), __LINE__);
        }
        if (is_null($contextWsdlDataTypeId) || (is_array($contextWsdlDataTypeId) && empty($contextWsdlDataTypeId))) {
            unset($this->ContextWsdlDataTypeId);
        } else {
            $this->ContextWsdlDataTypeId = $contextWsdlDataTypeId;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\DataType
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\DataType
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get IsComplex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplex()
    {
        return isset($this->IsComplex) ? $this->IsComplex : null;
    }
    /**
     * Set IsComplex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplex
     * @return \NexusDigital/MiratelForce\StructType\DataType
     */
    public function setIsComplex($isComplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplex) && !is_bool($isComplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplex, true), gettype($isComplex)), __LINE__);
        }
        if (is_null($isComplex) || (is_array($isComplex) && empty($isComplex))) {
            unset($this->IsComplex);
        } else {
            $this->IsComplex = $isComplex;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\DataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
