<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataAssessmentFieldMetric StructType
 * @subpackage Structs
 */
class DataAssessmentFieldMetric extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DataAssessmentMetric
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\DataAssessmentMetric
     */
    public $DataAssessmentMetric;
    /**
     * The DataAssessmentMetricId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $DataAssessmentMetricId;
    /**
     * The DataAssessmentValueMetrics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $DataAssessmentValueMetrics;
    /**
     * The FieldName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FieldName;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NumMatchedBlanks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumMatchedBlanks;
    /**
     * The NumMatchedDifferent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumMatchedDifferent;
    /**
     * The NumMatchedInSync
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumMatchedInSync;
    /**
     * The NumUnmatchedBlanks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumUnmatchedBlanks;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * Constructor method for DataAssessmentFieldMetric
     * @uses DataAssessmentFieldMetric::setCreatedBy()
     * @uses DataAssessmentFieldMetric::setCreatedById()
     * @uses DataAssessmentFieldMetric::setCreatedDate()
     * @uses DataAssessmentFieldMetric::setDataAssessmentMetric()
     * @uses DataAssessmentFieldMetric::setDataAssessmentMetricId()
     * @uses DataAssessmentFieldMetric::setDataAssessmentValueMetrics()
     * @uses DataAssessmentFieldMetric::setFieldName()
     * @uses DataAssessmentFieldMetric::setIsDeleted()
     * @uses DataAssessmentFieldMetric::setLastModifiedBy()
     * @uses DataAssessmentFieldMetric::setLastModifiedById()
     * @uses DataAssessmentFieldMetric::setLastModifiedDate()
     * @uses DataAssessmentFieldMetric::setName()
     * @uses DataAssessmentFieldMetric::setNumMatchedBlanks()
     * @uses DataAssessmentFieldMetric::setNumMatchedDifferent()
     * @uses DataAssessmentFieldMetric::setNumMatchedInSync()
     * @uses DataAssessmentFieldMetric::setNumUnmatchedBlanks()
     * @uses DataAssessmentFieldMetric::setSystemModstamp()
     * @uses DataAssessmentFieldMetric::setUserRecordAccess()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\DataAssessmentMetric $dataAssessmentMetric
     * @param string $dataAssessmentMetricId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $dataAssessmentValueMetrics
     * @param string $fieldName
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $name
     * @param int $numMatchedBlanks
     * @param int $numMatchedDifferent
     * @param int $numMatchedInSync
     * @param int $numUnmatchedBlanks
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\DataAssessmentMetric $dataAssessmentMetric = null, $dataAssessmentMetricId = null, \NexusDigital/MiratelForce\StructType\QueryResult $dataAssessmentValueMetrics = null, $fieldName = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $name = null, $numMatchedBlanks = null, $numMatchedDifferent = null, $numMatchedInSync = null, $numUnmatchedBlanks = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDataAssessmentMetric($dataAssessmentMetric)
            ->setDataAssessmentMetricId($dataAssessmentMetricId)
            ->setDataAssessmentValueMetrics($dataAssessmentValueMetrics)
            ->setFieldName($fieldName)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setName($name)
            ->setNumMatchedBlanks($numMatchedBlanks)
            ->setNumMatchedDifferent($numMatchedDifferent)
            ->setNumMatchedInSync($numMatchedInSync)
            ->setNumUnmatchedBlanks($numUnmatchedBlanks)
            ->setSystemModstamp($systemModstamp)
            ->setUserRecordAccess($userRecordAccess);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DataAssessmentMetric value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentMetric|null
     */
    public function getDataAssessmentMetric()
    {
        return isset($this->DataAssessmentMetric) ? $this->DataAssessmentMetric : null;
    }
    /**
     * Set DataAssessmentMetric value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\DataAssessmentMetric $dataAssessmentMetric
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setDataAssessmentMetric(\NexusDigital/MiratelForce\StructType\DataAssessmentMetric $dataAssessmentMetric = null)
    {
        if (is_null($dataAssessmentMetric) || (is_array($dataAssessmentMetric) && empty($dataAssessmentMetric))) {
            unset($this->DataAssessmentMetric);
        } else {
            $this->DataAssessmentMetric = $dataAssessmentMetric;
        }
        return $this;
    }
    /**
     * Get DataAssessmentMetricId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataAssessmentMetricId()
    {
        return isset($this->DataAssessmentMetricId) ? $this->DataAssessmentMetricId : null;
    }
    /**
     * Set DataAssessmentMetricId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataAssessmentMetricId
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setDataAssessmentMetricId($dataAssessmentMetricId = null)
    {
        // validation for constraint: string
        if (!is_null($dataAssessmentMetricId) && !is_string($dataAssessmentMetricId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAssessmentMetricId, true), gettype($dataAssessmentMetricId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($dataAssessmentMetricId) && mb_strlen($dataAssessmentMetricId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($dataAssessmentMetricId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($dataAssessmentMetricId) && !preg_match('/[a-zA-Z0-9]{18}/', $dataAssessmentMetricId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($dataAssessmentMetricId, true)), __LINE__);
        }
        if (is_null($dataAssessmentMetricId) || (is_array($dataAssessmentMetricId) && empty($dataAssessmentMetricId))) {
            unset($this->DataAssessmentMetricId);
        } else {
            $this->DataAssessmentMetricId = $dataAssessmentMetricId;
        }
        return $this;
    }
    /**
     * Get DataAssessmentValueMetrics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getDataAssessmentValueMetrics()
    {
        return isset($this->DataAssessmentValueMetrics) ? $this->DataAssessmentValueMetrics : null;
    }
    /**
     * Set DataAssessmentValueMetrics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $dataAssessmentValueMetrics
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setDataAssessmentValueMetrics(\NexusDigital/MiratelForce\StructType\QueryResult $dataAssessmentValueMetrics = null)
    {
        if (is_null($dataAssessmentValueMetrics) || (is_array($dataAssessmentValueMetrics) && empty($dataAssessmentValueMetrics))) {
            unset($this->DataAssessmentValueMetrics);
        } else {
            $this->DataAssessmentValueMetrics = $dataAssessmentValueMetrics;
        }
        return $this;
    }
    /**
     * Get FieldName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFieldName()
    {
        return isset($this->FieldName) ? $this->FieldName : null;
    }
    /**
     * Set FieldName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fieldName
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldName, true), gettype($fieldName)), __LINE__);
        }
        if (is_null($fieldName) || (is_array($fieldName) && empty($fieldName))) {
            unset($this->FieldName);
        } else {
            $this->FieldName = $fieldName;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumMatchedBlanks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumMatchedBlanks()
    {
        return isset($this->NumMatchedBlanks) ? $this->NumMatchedBlanks : null;
    }
    /**
     * Set NumMatchedBlanks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numMatchedBlanks
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setNumMatchedBlanks($numMatchedBlanks = null)
    {
        // validation for constraint: int
        if (!is_null($numMatchedBlanks) && !(is_int($numMatchedBlanks) || ctype_digit($numMatchedBlanks))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMatchedBlanks, true), gettype($numMatchedBlanks)), __LINE__);
        }
        if (is_null($numMatchedBlanks) || (is_array($numMatchedBlanks) && empty($numMatchedBlanks))) {
            unset($this->NumMatchedBlanks);
        } else {
            $this->NumMatchedBlanks = $numMatchedBlanks;
        }
        return $this;
    }
    /**
     * Get NumMatchedDifferent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumMatchedDifferent()
    {
        return isset($this->NumMatchedDifferent) ? $this->NumMatchedDifferent : null;
    }
    /**
     * Set NumMatchedDifferent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numMatchedDifferent
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setNumMatchedDifferent($numMatchedDifferent = null)
    {
        // validation for constraint: int
        if (!is_null($numMatchedDifferent) && !(is_int($numMatchedDifferent) || ctype_digit($numMatchedDifferent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMatchedDifferent, true), gettype($numMatchedDifferent)), __LINE__);
        }
        if (is_null($numMatchedDifferent) || (is_array($numMatchedDifferent) && empty($numMatchedDifferent))) {
            unset($this->NumMatchedDifferent);
        } else {
            $this->NumMatchedDifferent = $numMatchedDifferent;
        }
        return $this;
    }
    /**
     * Get NumMatchedInSync value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumMatchedInSync()
    {
        return isset($this->NumMatchedInSync) ? $this->NumMatchedInSync : null;
    }
    /**
     * Set NumMatchedInSync value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numMatchedInSync
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setNumMatchedInSync($numMatchedInSync = null)
    {
        // validation for constraint: int
        if (!is_null($numMatchedInSync) && !(is_int($numMatchedInSync) || ctype_digit($numMatchedInSync))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMatchedInSync, true), gettype($numMatchedInSync)), __LINE__);
        }
        if (is_null($numMatchedInSync) || (is_array($numMatchedInSync) && empty($numMatchedInSync))) {
            unset($this->NumMatchedInSync);
        } else {
            $this->NumMatchedInSync = $numMatchedInSync;
        }
        return $this;
    }
    /**
     * Get NumUnmatchedBlanks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumUnmatchedBlanks()
    {
        return isset($this->NumUnmatchedBlanks) ? $this->NumUnmatchedBlanks : null;
    }
    /**
     * Set NumUnmatchedBlanks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numUnmatchedBlanks
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setNumUnmatchedBlanks($numUnmatchedBlanks = null)
    {
        // validation for constraint: int
        if (!is_null($numUnmatchedBlanks) && !(is_int($numUnmatchedBlanks) || ctype_digit($numUnmatchedBlanks))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numUnmatchedBlanks, true), gettype($numUnmatchedBlanks)), __LINE__);
        }
        if (is_null($numUnmatchedBlanks) || (is_array($numUnmatchedBlanks) && empty($numUnmatchedBlanks))) {
            unset($this->NumUnmatchedBlanks);
        } else {
            $this->NumUnmatchedBlanks = $numUnmatchedBlanks;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\DataAssessmentFieldMetric
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
