<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentHubItem StructType
 * @subpackage Structs
 */
class ContentHubItem extends SObject
{
    /**
     * The ContentHubRepository
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ContentHubRepository
     */
    public $ContentHubRepository;
    /**
     * The ContentHubRepositoryId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ContentHubRepositoryId;
    /**
     * The ContentModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContentModifiedDate;
    /**
     * The ContentSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ContentSize;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ExternalContentUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalContentUrl;
    /**
     * The ExternalDocumentUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalDocumentUrl;
    /**
     * The ExternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The FileExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileExtension;
    /**
     * The FileType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileType;
    /**
     * The IsFolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFolder;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MimeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MimeType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Owner;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParentId;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The UpdatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpdatedBy;
    /**
     * Constructor method for ContentHubItem
     * @uses ContentHubItem::setContentHubRepository()
     * @uses ContentHubItem::setContentHubRepositoryId()
     * @uses ContentHubItem::setContentModifiedDate()
     * @uses ContentHubItem::setContentSize()
     * @uses ContentHubItem::setCreatedDate()
     * @uses ContentHubItem::setDescription()
     * @uses ContentHubItem::setExternalContentUrl()
     * @uses ContentHubItem::setExternalDocumentUrl()
     * @uses ContentHubItem::setExternalId()
     * @uses ContentHubItem::setFileExtension()
     * @uses ContentHubItem::setFileType()
     * @uses ContentHubItem::setIsFolder()
     * @uses ContentHubItem::setLastModifiedDate()
     * @uses ContentHubItem::setMimeType()
     * @uses ContentHubItem::setName()
     * @uses ContentHubItem::setOwner()
     * @uses ContentHubItem::setParentId()
     * @uses ContentHubItem::setTitle()
     * @uses ContentHubItem::setUpdatedBy()
     * @param \NexusDigital/MiratelForce\StructType\ContentHubRepository $contentHubRepository
     * @param string $contentHubRepositoryId
     * @param string $contentModifiedDate
     * @param int $contentSize
     * @param string $createdDate
     * @param string $description
     * @param string $externalContentUrl
     * @param string $externalDocumentUrl
     * @param string $externalId
     * @param string $fileExtension
     * @param string $fileType
     * @param bool $isFolder
     * @param string $lastModifiedDate
     * @param string $mimeType
     * @param string $name
     * @param string $owner
     * @param string $parentId
     * @param string $title
     * @param string $updatedBy
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\ContentHubRepository $contentHubRepository = null, $contentHubRepositoryId = null, $contentModifiedDate = null, $contentSize = null, $createdDate = null, $description = null, $externalContentUrl = null, $externalDocumentUrl = null, $externalId = null, $fileExtension = null, $fileType = null, $isFolder = null, $lastModifiedDate = null, $mimeType = null, $name = null, $owner = null, $parentId = null, $title = null, $updatedBy = null)
    {
        $this
            ->setContentHubRepository($contentHubRepository)
            ->setContentHubRepositoryId($contentHubRepositoryId)
            ->setContentModifiedDate($contentModifiedDate)
            ->setContentSize($contentSize)
            ->setCreatedDate($createdDate)
            ->setDescription($description)
            ->setExternalContentUrl($externalContentUrl)
            ->setExternalDocumentUrl($externalDocumentUrl)
            ->setExternalId($externalId)
            ->setFileExtension($fileExtension)
            ->setFileType($fileType)
            ->setIsFolder($isFolder)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMimeType($mimeType)
            ->setName($name)
            ->setOwner($owner)
            ->setParentId($parentId)
            ->setTitle($title)
            ->setUpdatedBy($updatedBy);
    }
    /**
     * Get ContentHubRepository value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ContentHubRepository|null
     */
    public function getContentHubRepository()
    {
        return isset($this->ContentHubRepository) ? $this->ContentHubRepository : null;
    }
    /**
     * Set ContentHubRepository value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ContentHubRepository $contentHubRepository
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setContentHubRepository(\NexusDigital/MiratelForce\StructType\ContentHubRepository $contentHubRepository = null)
    {
        if (is_null($contentHubRepository) || (is_array($contentHubRepository) && empty($contentHubRepository))) {
            unset($this->ContentHubRepository);
        } else {
            $this->ContentHubRepository = $contentHubRepository;
        }
        return $this;
    }
    /**
     * Get ContentHubRepositoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentHubRepositoryId()
    {
        return isset($this->ContentHubRepositoryId) ? $this->ContentHubRepositoryId : null;
    }
    /**
     * Set ContentHubRepositoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentHubRepositoryId
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setContentHubRepositoryId($contentHubRepositoryId = null)
    {
        // validation for constraint: string
        if (!is_null($contentHubRepositoryId) && !is_string($contentHubRepositoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentHubRepositoryId, true), gettype($contentHubRepositoryId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($contentHubRepositoryId) && mb_strlen($contentHubRepositoryId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($contentHubRepositoryId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentHubRepositoryId) && !preg_match('/[a-zA-Z0-9]{18}/', $contentHubRepositoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentHubRepositoryId, true)), __LINE__);
        }
        if (is_null($contentHubRepositoryId) || (is_array($contentHubRepositoryId) && empty($contentHubRepositoryId))) {
            unset($this->ContentHubRepositoryId);
        } else {
            $this->ContentHubRepositoryId = $contentHubRepositoryId;
        }
        return $this;
    }
    /**
     * Get ContentModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentModifiedDate()
    {
        return isset($this->ContentModifiedDate) ? $this->ContentModifiedDate : null;
    }
    /**
     * Set ContentModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setContentModifiedDate($contentModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($contentModifiedDate) && !is_string($contentModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentModifiedDate, true), gettype($contentModifiedDate)), __LINE__);
        }
        if (is_null($contentModifiedDate) || (is_array($contentModifiedDate) && empty($contentModifiedDate))) {
            unset($this->ContentModifiedDate);
        } else {
            $this->ContentModifiedDate = $contentModifiedDate;
        }
        return $this;
    }
    /**
     * Get ContentSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getContentSize()
    {
        return isset($this->ContentSize) ? $this->ContentSize : null;
    }
    /**
     * Set ContentSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $contentSize
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setContentSize($contentSize = null)
    {
        // validation for constraint: int
        if (!is_null($contentSize) && !(is_int($contentSize) || ctype_digit($contentSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contentSize, true), gettype($contentSize)), __LINE__);
        }
        if (is_null($contentSize) || (is_array($contentSize) && empty($contentSize))) {
            unset($this->ContentSize);
        } else {
            $this->ContentSize = $contentSize;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExternalContentUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalContentUrl()
    {
        return isset($this->ExternalContentUrl) ? $this->ExternalContentUrl : null;
    }
    /**
     * Set ExternalContentUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalContentUrl
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setExternalContentUrl($externalContentUrl = null)
    {
        // validation for constraint: string
        if (!is_null($externalContentUrl) && !is_string($externalContentUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalContentUrl, true), gettype($externalContentUrl)), __LINE__);
        }
        if (is_null($externalContentUrl) || (is_array($externalContentUrl) && empty($externalContentUrl))) {
            unset($this->ExternalContentUrl);
        } else {
            $this->ExternalContentUrl = $externalContentUrl;
        }
        return $this;
    }
    /**
     * Get ExternalDocumentUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalDocumentUrl()
    {
        return isset($this->ExternalDocumentUrl) ? $this->ExternalDocumentUrl : null;
    }
    /**
     * Set ExternalDocumentUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalDocumentUrl
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setExternalDocumentUrl($externalDocumentUrl = null)
    {
        // validation for constraint: string
        if (!is_null($externalDocumentUrl) && !is_string($externalDocumentUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalDocumentUrl, true), gettype($externalDocumentUrl)), __LINE__);
        }
        if (is_null($externalDocumentUrl) || (is_array($externalDocumentUrl) && empty($externalDocumentUrl))) {
            unset($this->ExternalDocumentUrl);
        } else {
            $this->ExternalDocumentUrl = $externalDocumentUrl;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get FileExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileExtension()
    {
        return isset($this->FileExtension) ? $this->FileExtension : null;
    }
    /**
     * Set FileExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileExtension
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setFileExtension($fileExtension = null)
    {
        // validation for constraint: string
        if (!is_null($fileExtension) && !is_string($fileExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileExtension, true), gettype($fileExtension)), __LINE__);
        }
        if (is_null($fileExtension) || (is_array($fileExtension) && empty($fileExtension))) {
            unset($this->FileExtension);
        } else {
            $this->FileExtension = $fileExtension;
        }
        return $this;
    }
    /**
     * Get FileType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileType()
    {
        return isset($this->FileType) ? $this->FileType : null;
    }
    /**
     * Set FileType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileType
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setFileType($fileType = null)
    {
        // validation for constraint: string
        if (!is_null($fileType) && !is_string($fileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileType, true), gettype($fileType)), __LINE__);
        }
        if (is_null($fileType) || (is_array($fileType) && empty($fileType))) {
            unset($this->FileType);
        } else {
            $this->FileType = $fileType;
        }
        return $this;
    }
    /**
     * Get IsFolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFolder()
    {
        return isset($this->IsFolder) ? $this->IsFolder : null;
    }
    /**
     * Set IsFolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFolder
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setIsFolder($isFolder = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFolder) && !is_bool($isFolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFolder, true), gettype($isFolder)), __LINE__);
        }
        if (is_null($isFolder) || (is_array($isFolder) && empty($isFolder))) {
            unset($this->IsFolder);
        } else {
            $this->IsFolder = $isFolder;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MimeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMimeType()
    {
        return isset($this->MimeType) ? $this->MimeType : null;
    }
    /**
     * Set MimeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mimeType
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeType, true), gettype($mimeType)), __LINE__);
        }
        if (is_null($mimeType) || (is_array($mimeType) && empty($mimeType))) {
            unset($this->MimeType);
        } else {
            $this->MimeType = $mimeType;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $owner
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get UpdatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdatedBy()
    {
        return isset($this->UpdatedBy) ? $this->UpdatedBy : null;
    }
    /**
     * Set UpdatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updatedBy
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public function setUpdatedBy($updatedBy = null)
    {
        // validation for constraint: string
        if (!is_null($updatedBy) && !is_string($updatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedBy, true), gettype($updatedBy)), __LINE__);
        }
        if (is_null($updatedBy) || (is_array($updatedBy) && empty($updatedBy))) {
            unset($this->UpdatedBy);
        } else {
            $this->UpdatedBy = $updatedBy;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ContentHubItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
