<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentDocumentSubscription StructType
 * @subpackage Structs
 */
class ContentDocumentSubscription extends SObject
{
    /**
     * The ContentDocument
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ContentDocument
     */
    public $ContentDocument;
    /**
     * The ContentDocumentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ContentDocumentId;
    /**
     * The IsCommentSub
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCommentSub;
    /**
     * The IsDocumentSub
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDocumentSub;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for ContentDocumentSubscription
     * @uses ContentDocumentSubscription::setContentDocument()
     * @uses ContentDocumentSubscription::setContentDocumentId()
     * @uses ContentDocumentSubscription::setIsCommentSub()
     * @uses ContentDocumentSubscription::setIsDocumentSub()
     * @uses ContentDocumentSubscription::setUser()
     * @uses ContentDocumentSubscription::setUserId()
     * @param \NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument
     * @param string $contentDocumentId
     * @param bool $isCommentSub
     * @param bool $isDocumentSub
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument = null, $contentDocumentId = null, $isCommentSub = null, $isDocumentSub = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null)
    {
        $this
            ->setContentDocument($contentDocument)
            ->setContentDocumentId($contentDocumentId)
            ->setIsCommentSub($isCommentSub)
            ->setIsDocumentSub($isDocumentSub)
            ->setUser($user)
            ->setUserId($userId);
    }
    /**
     * Get ContentDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ContentDocument|null
     */
    public function getContentDocument()
    {
        return isset($this->ContentDocument) ? $this->ContentDocument : null;
    }
    /**
     * Set ContentDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentSubscription
     */
    public function setContentDocument(\NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument = null)
    {
        if (is_null($contentDocument) || (is_array($contentDocument) && empty($contentDocument))) {
            unset($this->ContentDocument);
        } else {
            $this->ContentDocument = $contentDocument;
        }
        return $this;
    }
    /**
     * Get ContentDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentDocumentId()
    {
        return isset($this->ContentDocumentId) ? $this->ContentDocumentId : null;
    }
    /**
     * Set ContentDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentDocumentId
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentSubscription
     */
    public function setContentDocumentId($contentDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($contentDocumentId) && !is_string($contentDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentDocumentId, true), gettype($contentDocumentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($contentDocumentId) && mb_strlen($contentDocumentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($contentDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentDocumentId) && !preg_match('/[a-zA-Z0-9]{18}/', $contentDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentDocumentId, true)), __LINE__);
        }
        if (is_null($contentDocumentId) || (is_array($contentDocumentId) && empty($contentDocumentId))) {
            unset($this->ContentDocumentId);
        } else {
            $this->ContentDocumentId = $contentDocumentId;
        }
        return $this;
    }
    /**
     * Get IsCommentSub value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCommentSub()
    {
        return isset($this->IsCommentSub) ? $this->IsCommentSub : null;
    }
    /**
     * Set IsCommentSub value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCommentSub
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentSubscription
     */
    public function setIsCommentSub($isCommentSub = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommentSub) && !is_bool($isCommentSub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommentSub, true), gettype($isCommentSub)), __LINE__);
        }
        if (is_null($isCommentSub) || (is_array($isCommentSub) && empty($isCommentSub))) {
            unset($this->IsCommentSub);
        } else {
            $this->IsCommentSub = $isCommentSub;
        }
        return $this;
    }
    /**
     * Get IsDocumentSub value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDocumentSub()
    {
        return isset($this->IsDocumentSub) ? $this->IsDocumentSub : null;
    }
    /**
     * Set IsDocumentSub value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDocumentSub
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentSubscription
     */
    public function setIsDocumentSub($isDocumentSub = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDocumentSub) && !is_bool($isDocumentSub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDocumentSub, true), gettype($isDocumentSub)), __LINE__);
        }
        if (is_null($isDocumentSub) || (is_array($isDocumentSub) && empty($isDocumentSub))) {
            unset($this->IsDocumentSub);
        } else {
            $this->IsDocumentSub = $isDocumentSub;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentSubscription
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentSubscription
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ContentDocumentSubscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
