<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact StructType
 * @subpackage Structs
 */
class Contact extends SObject
{
    /**
     * The AcceptedEventRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AcceptedEventRelations;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Account
     */
    public $Account;
    /**
     * The AccountContactRoles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AccountContactRoles;
    /**
     * The AccountId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AccountId;
    /**
     * The ActivityHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ActivityHistories;
    /**
     * The Assets
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Assets;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Attachments;
    /**
     * The Call_Reason2__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Call_Reason2__c;
    /**
     * The Call_Reason__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Call_Reason__c;
    /**
     * The CampaignMembers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CampaignMembers;
    /**
     * The CaseContactRoles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CaseContactRoles;
    /**
     * The Cases
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Cases;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The ContactRequests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContactRequests;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The ContractContactRoles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContractContactRoles;
    /**
     * The ContractsSigned
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContractsSigned;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DeclinedEventRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $DeclinedEventRelations;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Department;
    /**
     * The DuplicateRecordItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $DuplicateRecordItems;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The EmailBouncedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBouncedDate;
    /**
     * The EmailBouncedReason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBouncedReason;
    /**
     * The EmailMessageRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EmailMessageRelations;
    /**
     * The EmailStatuses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EmailStatuses;
    /**
     * The EventRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EventRelations;
    /**
     * The EventWhoRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EventWhoRelations;
    /**
     * The Events
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Events;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The FeedSubscriptionsForEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedSubscriptionsForEntity;
    /**
     * The Feeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Feeds;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The Histories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Histories;
    /**
     * The Individual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Individual
     */
    public $Individual;
    /**
     * The IndividualId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $IndividualId;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsEmailBounced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEmailBounced;
    /**
     * The Jigsaw
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Jigsaw;
    /**
     * The JigsawContactId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JigsawContactId;
    /**
     * The LastActivityDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastActivityDate;
    /**
     * The LastCURequestDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastCURequestDate;
    /**
     * The LastCUUpdateDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastCUUpdateDate;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The LastReferencedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastReferencedDate;
    /**
     * The LastViewedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastViewedDate;
    /**
     * The ListEmailIndividualRecipients
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ListEmailIndividualRecipients;
    /**
     * The LookedUpFromActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $LookedUpFromActivities;
    /**
     * The MailingAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Address
     */
    public $MailingAddress;
    /**
     * The MailingCity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingCity;
    /**
     * The MailingCountry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingCountry;
    /**
     * The MailingGeocodeAccuracy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingGeocodeAccuracy;
    /**
     * The MailingLatitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MailingLatitude;
    /**
     * The MailingLongitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MailingLongitude;
    /**
     * The MailingPostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingPostalCode;
    /**
     * The MailingState
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingState;
    /**
     * The MailingStreet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MailingStreet;
    /**
     * The MasterRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Contact
     */
    public $MasterRecord;
    /**
     * The MasterRecordId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $MasterRecordId;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The MobilePhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Notes;
    /**
     * The NotesAndAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NotesAndAttachments;
    /**
     * The OpenActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $OpenActivities;
    /**
     * The Opportunities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Opportunities;
    /**
     * The OpportunityContactRoles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $OpportunityContactRoles;
    /**
     * The OutgoingEmailRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $OutgoingEmailRelations;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The ParentEntities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ParentEntities;
    /**
     * The PersonRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $PersonRecord;
    /**
     * The Personas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Personas;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The PhotoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhotoUrl;
    /**
     * The Posts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Posts;
    /**
     * The ProcessInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessInstances;
    /**
     * The ProcessSteps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessSteps;
    /**
     * The Quotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Quotes;
    /**
     * The RecordActionHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActionHistories;
    /**
     * The RecordActions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActions;
    /**
     * The RecordAssociatedGroups
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordAssociatedGroups;
    /**
     * The ReportsTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Contact
     */
    public $ReportsTo;
    /**
     * The ReportsToId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ReportsToId;
    /**
     * The Salutation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Salutation;
    /**
     * The Shares
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Shares;
    /**
     * The Suffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suffix;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TaskRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TaskRelations;
    /**
     * The TaskWhoRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TaskWhoRelations;
    /**
     * The Tasks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Tasks;
    /**
     * The Ticket_Orders__r
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Ticket_Orders__r;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The TopicAssignments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TopicAssignments;
    /**
     * The UndecidedEventRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $UndecidedEventRelations;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * The Users
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Users;
    /**
     * The WorkOrders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $WorkOrders;
    /**
     * Constructor method for Contact
     * @uses Contact::setAcceptedEventRelations()
     * @uses Contact::setAccount()
     * @uses Contact::setAccountContactRoles()
     * @uses Contact::setAccountId()
     * @uses Contact::setActivityHistories()
     * @uses Contact::setAssets()
     * @uses Contact::setAttachedContentDocuments()
     * @uses Contact::setAttachedContentNotes()
     * @uses Contact::setAttachments()
     * @uses Contact::setCall_Reason2__c()
     * @uses Contact::setCall_Reason__c()
     * @uses Contact::setCampaignMembers()
     * @uses Contact::setCaseContactRoles()
     * @uses Contact::setCases()
     * @uses Contact::setCombinedAttachments()
     * @uses Contact::setContactRequests()
     * @uses Contact::setContentDocumentLinks()
     * @uses Contact::setContractContactRoles()
     * @uses Contact::setContractsSigned()
     * @uses Contact::setCreatedBy()
     * @uses Contact::setCreatedById()
     * @uses Contact::setCreatedDate()
     * @uses Contact::setDeclinedEventRelations()
     * @uses Contact::setDepartment()
     * @uses Contact::setDuplicateRecordItems()
     * @uses Contact::setEmail()
     * @uses Contact::setEmailBouncedDate()
     * @uses Contact::setEmailBouncedReason()
     * @uses Contact::setEmailMessageRelations()
     * @uses Contact::setEmailStatuses()
     * @uses Contact::setEventRelations()
     * @uses Contact::setEventWhoRelations()
     * @uses Contact::setEvents()
     * @uses Contact::setFax()
     * @uses Contact::setFeedSubscriptionsForEntity()
     * @uses Contact::setFeeds()
     * @uses Contact::setFirstName()
     * @uses Contact::setHistories()
     * @uses Contact::setIndividual()
     * @uses Contact::setIndividualId()
     * @uses Contact::setIsDeleted()
     * @uses Contact::setIsEmailBounced()
     * @uses Contact::setJigsaw()
     * @uses Contact::setJigsawContactId()
     * @uses Contact::setLastActivityDate()
     * @uses Contact::setLastCURequestDate()
     * @uses Contact::setLastCUUpdateDate()
     * @uses Contact::setLastModifiedBy()
     * @uses Contact::setLastModifiedById()
     * @uses Contact::setLastModifiedDate()
     * @uses Contact::setLastName()
     * @uses Contact::setLastReferencedDate()
     * @uses Contact::setLastViewedDate()
     * @uses Contact::setListEmailIndividualRecipients()
     * @uses Contact::setLookedUpFromActivities()
     * @uses Contact::setMailingAddress()
     * @uses Contact::setMailingCity()
     * @uses Contact::setMailingCountry()
     * @uses Contact::setMailingGeocodeAccuracy()
     * @uses Contact::setMailingLatitude()
     * @uses Contact::setMailingLongitude()
     * @uses Contact::setMailingPostalCode()
     * @uses Contact::setMailingState()
     * @uses Contact::setMailingStreet()
     * @uses Contact::setMasterRecord()
     * @uses Contact::setMasterRecordId()
     * @uses Contact::setMiddleName()
     * @uses Contact::setMobilePhone()
     * @uses Contact::setName()
     * @uses Contact::setNotes()
     * @uses Contact::setNotesAndAttachments()
     * @uses Contact::setOpenActivities()
     * @uses Contact::setOpportunities()
     * @uses Contact::setOpportunityContactRoles()
     * @uses Contact::setOutgoingEmailRelations()
     * @uses Contact::setOwner()
     * @uses Contact::setOwnerId()
     * @uses Contact::setParentEntities()
     * @uses Contact::setPersonRecord()
     * @uses Contact::setPersonas()
     * @uses Contact::setPhone()
     * @uses Contact::setPhotoUrl()
     * @uses Contact::setPosts()
     * @uses Contact::setProcessInstances()
     * @uses Contact::setProcessSteps()
     * @uses Contact::setQuotes()
     * @uses Contact::setRecordActionHistories()
     * @uses Contact::setRecordActions()
     * @uses Contact::setRecordAssociatedGroups()
     * @uses Contact::setReportsTo()
     * @uses Contact::setReportsToId()
     * @uses Contact::setSalutation()
     * @uses Contact::setShares()
     * @uses Contact::setSuffix()
     * @uses Contact::setSystemModstamp()
     * @uses Contact::setTaskRelations()
     * @uses Contact::setTaskWhoRelations()
     * @uses Contact::setTasks()
     * @uses Contact::setTicket_Orders__r()
     * @uses Contact::setTitle()
     * @uses Contact::setTopicAssignments()
     * @uses Contact::setUndecidedEventRelations()
     * @uses Contact::setUserRecordAccess()
     * @uses Contact::setUsers()
     * @uses Contact::setWorkOrders()
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $acceptedEventRelations
     * @param \NexusDigital/MiratelForce\StructType\Account $account
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $accountContactRoles
     * @param string $accountId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $activityHistories
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $assets
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @param string $call_Reason2__c
     * @param string $call_Reason__c
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $caseContactRoles
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $cases
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contactRequests
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contractContactRoles
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contractsSigned
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $declinedEventRelations
     * @param string $department
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems
     * @param string $email
     * @param string $emailBouncedDate
     * @param string $emailBouncedReason
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emailStatuses
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventWhoRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $events
     * @param string $fax
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @param string $firstName
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @param \NexusDigital/MiratelForce\StructType\Individual $individual
     * @param string $individualId
     * @param bool $isDeleted
     * @param bool $isEmailBounced
     * @param string $jigsaw
     * @param string $jigsawContactId
     * @param string $lastActivityDate
     * @param string $lastCURequestDate
     * @param string $lastCUUpdateDate
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastName
     * @param string $lastReferencedDate
     * @param string $lastViewedDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $listEmailIndividualRecipients
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities
     * @param \NexusDigital/MiratelForce\StructType\Address $mailingAddress
     * @param string $mailingCity
     * @param string $mailingCountry
     * @param string $mailingGeocodeAccuracy
     * @param float $mailingLatitude
     * @param float $mailingLongitude
     * @param string $mailingPostalCode
     * @param string $mailingState
     * @param string $mailingStreet
     * @param \NexusDigital/MiratelForce\StructType\Contact $masterRecord
     * @param string $masterRecordId
     * @param string $middleName
     * @param string $mobilePhone
     * @param string $name
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $openActivities
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $opportunities
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $opportunityContactRoles
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @param string $ownerId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $personRecord
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $personas
     * @param string $phone
     * @param string $photoUrl
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $posts
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $quotes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups
     * @param \NexusDigital/MiratelForce\StructType\Contact $reportsTo
     * @param string $reportsToId
     * @param string $salutation
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $shares
     * @param string $suffix
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskWhoRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $tasks
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $ticket_Orders__r
     * @param string $title
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $undecidedEventRelations
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $users
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $workOrders
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\QueryResult $acceptedEventRelations = null, \NexusDigital/MiratelForce\StructType\Account $account = null, \NexusDigital/MiratelForce\StructType\QueryResult $accountContactRoles = null, $accountId = null, \NexusDigital/MiratelForce\StructType\QueryResult $activityHistories = null, \NexusDigital/MiratelForce\StructType\QueryResult $assets = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachments = null, $call_Reason2__c = null, $call_Reason__c = null, \NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers = null, \NexusDigital/MiratelForce\StructType\QueryResult $caseContactRoles = null, \NexusDigital/MiratelForce\StructType\QueryResult $cases = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $contactRequests = null, \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\QueryResult $contractContactRoles = null, \NexusDigital/MiratelForce\StructType\QueryResult $contractsSigned = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $declinedEventRelations = null, $department = null, \NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems = null, $email = null, $emailBouncedDate = null, $emailBouncedReason = null, \NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $emailStatuses = null, \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $eventWhoRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $events = null, $fax = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null, \NexusDigital/MiratelForce\StructType\QueryResult $feeds = null, $firstName = null, \NexusDigital/MiratelForce\StructType\QueryResult $histories = null, \NexusDigital/MiratelForce\StructType\Individual $individual = null, $individualId = null, $isDeleted = null, $isEmailBounced = null, $jigsaw = null, $jigsawContactId = null, $lastActivityDate = null, $lastCURequestDate = null, $lastCUUpdateDate = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastName = null, $lastReferencedDate = null, $lastViewedDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $listEmailIndividualRecipients = null, \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities = null, \NexusDigital/MiratelForce\StructType\Address $mailingAddress = null, $mailingCity = null, $mailingCountry = null, $mailingGeocodeAccuracy = null, $mailingLatitude = null, $mailingLongitude = null, $mailingPostalCode = null, $mailingState = null, $mailingStreet = null, \NexusDigital/MiratelForce\StructType\Contact $masterRecord = null, $masterRecordId = null, $middleName = null, $mobilePhone = null, $name = null, \NexusDigital/MiratelForce\StructType\QueryResult $notes = null, \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $openActivities = null, \NexusDigital/MiratelForce\StructType\QueryResult $opportunities = null, \NexusDigital/MiratelForce\StructType\QueryResult $opportunityContactRoles = null, \NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations = null, \NexusDigital/MiratelForce\StructType\User $owner = null, $ownerId = null, \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null, \NexusDigital/MiratelForce\StructType\QueryResult $personRecord = null, \NexusDigital/MiratelForce\StructType\QueryResult $personas = null, $phone = null, $photoUrl = null, \NexusDigital/MiratelForce\StructType\QueryResult $posts = null, \NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null, \NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null, \NexusDigital/MiratelForce\StructType\QueryResult $quotes = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups = null, \NexusDigital/MiratelForce\StructType\Contact $reportsTo = null, $reportsToId = null, $salutation = null, \NexusDigital/MiratelForce\StructType\QueryResult $shares = null, $suffix = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $taskWhoRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $tasks = null, \NexusDigital/MiratelForce\StructType\QueryResult $ticket_Orders__r = null, $title = null, \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null, \NexusDigital/MiratelForce\StructType\QueryResult $undecidedEventRelations = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null, \NexusDigital/MiratelForce\StructType\QueryResult $users = null, \NexusDigital/MiratelForce\StructType\QueryResult $workOrders = null)
    {
        $this
            ->setAcceptedEventRelations($acceptedEventRelations)
            ->setAccount($account)
            ->setAccountContactRoles($accountContactRoles)
            ->setAccountId($accountId)
            ->setActivityHistories($activityHistories)
            ->setAssets($assets)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setAttachments($attachments)
            ->setCall_Reason2__c($call_Reason2__c)
            ->setCall_Reason__c($call_Reason__c)
            ->setCampaignMembers($campaignMembers)
            ->setCaseContactRoles($caseContactRoles)
            ->setCases($cases)
            ->setCombinedAttachments($combinedAttachments)
            ->setContactRequests($contactRequests)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setContractContactRoles($contractContactRoles)
            ->setContractsSigned($contractsSigned)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDeclinedEventRelations($declinedEventRelations)
            ->setDepartment($department)
            ->setDuplicateRecordItems($duplicateRecordItems)
            ->setEmail($email)
            ->setEmailBouncedDate($emailBouncedDate)
            ->setEmailBouncedReason($emailBouncedReason)
            ->setEmailMessageRelations($emailMessageRelations)
            ->setEmailStatuses($emailStatuses)
            ->setEventRelations($eventRelations)
            ->setEventWhoRelations($eventWhoRelations)
            ->setEvents($events)
            ->setFax($fax)
            ->setFeedSubscriptionsForEntity($feedSubscriptionsForEntity)
            ->setFeeds($feeds)
            ->setFirstName($firstName)
            ->setHistories($histories)
            ->setIndividual($individual)
            ->setIndividualId($individualId)
            ->setIsDeleted($isDeleted)
            ->setIsEmailBounced($isEmailBounced)
            ->setJigsaw($jigsaw)
            ->setJigsawContactId($jigsawContactId)
            ->setLastActivityDate($lastActivityDate)
            ->setLastCURequestDate($lastCURequestDate)
            ->setLastCUUpdateDate($lastCUUpdateDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastName($lastName)
            ->setLastReferencedDate($lastReferencedDate)
            ->setLastViewedDate($lastViewedDate)
            ->setListEmailIndividualRecipients($listEmailIndividualRecipients)
            ->setLookedUpFromActivities($lookedUpFromActivities)
            ->setMailingAddress($mailingAddress)
            ->setMailingCity($mailingCity)
            ->setMailingCountry($mailingCountry)
            ->setMailingGeocodeAccuracy($mailingGeocodeAccuracy)
            ->setMailingLatitude($mailingLatitude)
            ->setMailingLongitude($mailingLongitude)
            ->setMailingPostalCode($mailingPostalCode)
            ->setMailingState($mailingState)
            ->setMailingStreet($mailingStreet)
            ->setMasterRecord($masterRecord)
            ->setMasterRecordId($masterRecordId)
            ->setMiddleName($middleName)
            ->setMobilePhone($mobilePhone)
            ->setName($name)
            ->setNotes($notes)
            ->setNotesAndAttachments($notesAndAttachments)
            ->setOpenActivities($openActivities)
            ->setOpportunities($opportunities)
            ->setOpportunityContactRoles($opportunityContactRoles)
            ->setOutgoingEmailRelations($outgoingEmailRelations)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setParentEntities($parentEntities)
            ->setPersonRecord($personRecord)
            ->setPersonas($personas)
            ->setPhone($phone)
            ->setPhotoUrl($photoUrl)
            ->setPosts($posts)
            ->setProcessInstances($processInstances)
            ->setProcessSteps($processSteps)
            ->setQuotes($quotes)
            ->setRecordActionHistories($recordActionHistories)
            ->setRecordActions($recordActions)
            ->setRecordAssociatedGroups($recordAssociatedGroups)
            ->setReportsTo($reportsTo)
            ->setReportsToId($reportsToId)
            ->setSalutation($salutation)
            ->setShares($shares)
            ->setSuffix($suffix)
            ->setSystemModstamp($systemModstamp)
            ->setTaskRelations($taskRelations)
            ->setTaskWhoRelations($taskWhoRelations)
            ->setTasks($tasks)
            ->setTicket_Orders__r($ticket_Orders__r)
            ->setTitle($title)
            ->setTopicAssignments($topicAssignments)
            ->setUndecidedEventRelations($undecidedEventRelations)
            ->setUserRecordAccess($userRecordAccess)
            ->setUsers($users)
            ->setWorkOrders($workOrders);
    }
    /**
     * Get AcceptedEventRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAcceptedEventRelations()
    {
        return isset($this->AcceptedEventRelations) ? $this->AcceptedEventRelations : null;
    }
    /**
     * Set AcceptedEventRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $acceptedEventRelations
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setAcceptedEventRelations(\NexusDigital/MiratelForce\StructType\QueryResult $acceptedEventRelations = null)
    {
        if (is_null($acceptedEventRelations) || (is_array($acceptedEventRelations) && empty($acceptedEventRelations))) {
            unset($this->AcceptedEventRelations);
        } else {
            $this->AcceptedEventRelations = $acceptedEventRelations;
        }
        return $this;
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Account|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Account $account
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setAccount(\NexusDigital/MiratelForce\StructType\Account $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get AccountContactRoles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAccountContactRoles()
    {
        return isset($this->AccountContactRoles) ? $this->AccountContactRoles : null;
    }
    /**
     * Set AccountContactRoles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $accountContactRoles
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setAccountContactRoles(\NexusDigital/MiratelForce\StructType\QueryResult $accountContactRoles = null)
    {
        if (is_null($accountContactRoles) || (is_array($accountContactRoles) && empty($accountContactRoles))) {
            unset($this->AccountContactRoles);
        } else {
            $this->AccountContactRoles = $accountContactRoles;
        }
        return $this;
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($accountId) && mb_strlen($accountId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($accountId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($accountId) && !preg_match('/[a-zA-Z0-9]{18}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($accountId, true)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get ActivityHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getActivityHistories()
    {
        return isset($this->ActivityHistories) ? $this->ActivityHistories : null;
    }
    /**
     * Set ActivityHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $activityHistories
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setActivityHistories(\NexusDigital/MiratelForce\StructType\QueryResult $activityHistories = null)
    {
        if (is_null($activityHistories) || (is_array($activityHistories) && empty($activityHistories))) {
            unset($this->ActivityHistories);
        } else {
            $this->ActivityHistories = $activityHistories;
        }
        return $this;
    }
    /**
     * Get Assets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAssets()
    {
        return isset($this->Assets) ? $this->Assets : null;
    }
    /**
     * Set Assets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $assets
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setAssets(\NexusDigital/MiratelForce\StructType\QueryResult $assets = null)
    {
        if (is_null($assets) || (is_array($assets) && empty($assets))) {
            unset($this->Assets);
        } else {
            $this->Assets = $assets;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get Attachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachments()
    {
        return isset($this->Attachments) ? $this->Attachments : null;
    }
    /**
     * Set Attachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $attachments = null)
    {
        if (is_null($attachments) || (is_array($attachments) && empty($attachments))) {
            unset($this->Attachments);
        } else {
            $this->Attachments = $attachments;
        }
        return $this;
    }
    /**
     * Get Call_Reason2__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCall_Reason2__c()
    {
        return isset($this->Call_Reason2__c) ? $this->Call_Reason2__c : null;
    }
    /**
     * Set Call_Reason2__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $call_Reason2__c
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setCall_Reason2__c($call_Reason2__c = null)
    {
        // validation for constraint: string
        if (!is_null($call_Reason2__c) && !is_string($call_Reason2__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($call_Reason2__c, true), gettype($call_Reason2__c)), __LINE__);
        }
        if (is_null($call_Reason2__c) || (is_array($call_Reason2__c) && empty($call_Reason2__c))) {
            unset($this->Call_Reason2__c);
        } else {
            $this->Call_Reason2__c = $call_Reason2__c;
        }
        return $this;
    }
    /**
     * Get Call_Reason__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCall_Reason__c()
    {
        return isset($this->Call_Reason__c) ? $this->Call_Reason__c : null;
    }
    /**
     * Set Call_Reason__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $call_Reason__c
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setCall_Reason__c($call_Reason__c = null)
    {
        // validation for constraint: string
        if (!is_null($call_Reason__c) && !is_string($call_Reason__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($call_Reason__c, true), gettype($call_Reason__c)), __LINE__);
        }
        if (is_null($call_Reason__c) || (is_array($call_Reason__c) && empty($call_Reason__c))) {
            unset($this->Call_Reason__c);
        } else {
            $this->Call_Reason__c = $call_Reason__c;
        }
        return $this;
    }
    /**
     * Get CampaignMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCampaignMembers()
    {
        return isset($this->CampaignMembers) ? $this->CampaignMembers : null;
    }
    /**
     * Set CampaignMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setCampaignMembers(\NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers = null)
    {
        if (is_null($campaignMembers) || (is_array($campaignMembers) && empty($campaignMembers))) {
            unset($this->CampaignMembers);
        } else {
            $this->CampaignMembers = $campaignMembers;
        }
        return $this;
    }
    /**
     * Get CaseContactRoles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCaseContactRoles()
    {
        return isset($this->CaseContactRoles) ? $this->CaseContactRoles : null;
    }
    /**
     * Set CaseContactRoles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $caseContactRoles
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setCaseContactRoles(\NexusDigital/MiratelForce\StructType\QueryResult $caseContactRoles = null)
    {
        if (is_null($caseContactRoles) || (is_array($caseContactRoles) && empty($caseContactRoles))) {
            unset($this->CaseContactRoles);
        } else {
            $this->CaseContactRoles = $caseContactRoles;
        }
        return $this;
    }
    /**
     * Get Cases value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCases()
    {
        return isset($this->Cases) ? $this->Cases : null;
    }
    /**
     * Set Cases value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $cases
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setCases(\NexusDigital/MiratelForce\StructType\QueryResult $cases = null)
    {
        if (is_null($cases) || (is_array($cases) && empty($cases))) {
            unset($this->Cases);
        } else {
            $this->Cases = $cases;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get ContactRequests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContactRequests()
    {
        return isset($this->ContactRequests) ? $this->ContactRequests : null;
    }
    /**
     * Set ContactRequests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contactRequests
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setContactRequests(\NexusDigital/MiratelForce\StructType\QueryResult $contactRequests = null)
    {
        if (is_null($contactRequests) || (is_array($contactRequests) && empty($contactRequests))) {
            unset($this->ContactRequests);
        } else {
            $this->ContactRequests = $contactRequests;
        }
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get ContractContactRoles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContractContactRoles()
    {
        return isset($this->ContractContactRoles) ? $this->ContractContactRoles : null;
    }
    /**
     * Set ContractContactRoles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contractContactRoles
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setContractContactRoles(\NexusDigital/MiratelForce\StructType\QueryResult $contractContactRoles = null)
    {
        if (is_null($contractContactRoles) || (is_array($contractContactRoles) && empty($contractContactRoles))) {
            unset($this->ContractContactRoles);
        } else {
            $this->ContractContactRoles = $contractContactRoles;
        }
        return $this;
    }
    /**
     * Get ContractsSigned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContractsSigned()
    {
        return isset($this->ContractsSigned) ? $this->ContractsSigned : null;
    }
    /**
     * Set ContractsSigned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contractsSigned
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setContractsSigned(\NexusDigital/MiratelForce\StructType\QueryResult $contractsSigned = null)
    {
        if (is_null($contractsSigned) || (is_array($contractsSigned) && empty($contractsSigned))) {
            unset($this->ContractsSigned);
        } else {
            $this->ContractsSigned = $contractsSigned;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DeclinedEventRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getDeclinedEventRelations()
    {
        return isset($this->DeclinedEventRelations) ? $this->DeclinedEventRelations : null;
    }
    /**
     * Set DeclinedEventRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $declinedEventRelations
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setDeclinedEventRelations(\NexusDigital/MiratelForce\StructType\QueryResult $declinedEventRelations = null)
    {
        if (is_null($declinedEventRelations) || (is_array($declinedEventRelations) && empty($declinedEventRelations))) {
            unset($this->DeclinedEventRelations);
        } else {
            $this->DeclinedEventRelations = $declinedEventRelations;
        }
        return $this;
    }
    /**
     * Get Department value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartment()
    {
        return isset($this->Department) ? $this->Department : null;
    }
    /**
     * Set Department value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $department
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        if (is_null($department) || (is_array($department) && empty($department))) {
            unset($this->Department);
        } else {
            $this->Department = $department;
        }
        return $this;
    }
    /**
     * Get DuplicateRecordItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getDuplicateRecordItems()
    {
        return isset($this->DuplicateRecordItems) ? $this->DuplicateRecordItems : null;
    }
    /**
     * Set DuplicateRecordItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setDuplicateRecordItems(\NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems = null)
    {
        if (is_null($duplicateRecordItems) || (is_array($duplicateRecordItems) && empty($duplicateRecordItems))) {
            unset($this->DuplicateRecordItems);
        } else {
            $this->DuplicateRecordItems = $duplicateRecordItems;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get EmailBouncedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBouncedDate()
    {
        return isset($this->EmailBouncedDate) ? $this->EmailBouncedDate : null;
    }
    /**
     * Set EmailBouncedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBouncedDate
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setEmailBouncedDate($emailBouncedDate = null)
    {
        // validation for constraint: string
        if (!is_null($emailBouncedDate) && !is_string($emailBouncedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBouncedDate, true), gettype($emailBouncedDate)), __LINE__);
        }
        if (is_null($emailBouncedDate) || (is_array($emailBouncedDate) && empty($emailBouncedDate))) {
            unset($this->EmailBouncedDate);
        } else {
            $this->EmailBouncedDate = $emailBouncedDate;
        }
        return $this;
    }
    /**
     * Get EmailBouncedReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBouncedReason()
    {
        return isset($this->EmailBouncedReason) ? $this->EmailBouncedReason : null;
    }
    /**
     * Set EmailBouncedReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBouncedReason
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setEmailBouncedReason($emailBouncedReason = null)
    {
        // validation for constraint: string
        if (!is_null($emailBouncedReason) && !is_string($emailBouncedReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBouncedReason, true), gettype($emailBouncedReason)), __LINE__);
        }
        if (is_null($emailBouncedReason) || (is_array($emailBouncedReason) && empty($emailBouncedReason))) {
            unset($this->EmailBouncedReason);
        } else {
            $this->EmailBouncedReason = $emailBouncedReason;
        }
        return $this;
    }
    /**
     * Get EmailMessageRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEmailMessageRelations()
    {
        return isset($this->EmailMessageRelations) ? $this->EmailMessageRelations : null;
    }
    /**
     * Set EmailMessageRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setEmailMessageRelations(\NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations = null)
    {
        if (is_null($emailMessageRelations) || (is_array($emailMessageRelations) && empty($emailMessageRelations))) {
            unset($this->EmailMessageRelations);
        } else {
            $this->EmailMessageRelations = $emailMessageRelations;
        }
        return $this;
    }
    /**
     * Get EmailStatuses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEmailStatuses()
    {
        return isset($this->EmailStatuses) ? $this->EmailStatuses : null;
    }
    /**
     * Set EmailStatuses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emailStatuses
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setEmailStatuses(\NexusDigital/MiratelForce\StructType\QueryResult $emailStatuses = null)
    {
        if (is_null($emailStatuses) || (is_array($emailStatuses) && empty($emailStatuses))) {
            unset($this->EmailStatuses);
        } else {
            $this->EmailStatuses = $emailStatuses;
        }
        return $this;
    }
    /**
     * Get EventRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEventRelations()
    {
        return isset($this->EventRelations) ? $this->EventRelations : null;
    }
    /**
     * Set EventRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setEventRelations(\NexusDigital/MiratelForce\StructType\QueryResult $eventRelations = null)
    {
        if (is_null($eventRelations) || (is_array($eventRelations) && empty($eventRelations))) {
            unset($this->EventRelations);
        } else {
            $this->EventRelations = $eventRelations;
        }
        return $this;
    }
    /**
     * Get EventWhoRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEventWhoRelations()
    {
        return isset($this->EventWhoRelations) ? $this->EventWhoRelations : null;
    }
    /**
     * Set EventWhoRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventWhoRelations
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setEventWhoRelations(\NexusDigital/MiratelForce\StructType\QueryResult $eventWhoRelations = null)
    {
        if (is_null($eventWhoRelations) || (is_array($eventWhoRelations) && empty($eventWhoRelations))) {
            unset($this->EventWhoRelations);
        } else {
            $this->EventWhoRelations = $eventWhoRelations;
        }
        return $this;
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $events
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setEvents(\NexusDigital/MiratelForce\StructType\QueryResult $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get FeedSubscriptionsForEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedSubscriptionsForEntity()
    {
        return isset($this->FeedSubscriptionsForEntity) ? $this->FeedSubscriptionsForEntity : null;
    }
    /**
     * Set FeedSubscriptionsForEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setFeedSubscriptionsForEntity(\NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null)
    {
        if (is_null($feedSubscriptionsForEntity) || (is_array($feedSubscriptionsForEntity) && empty($feedSubscriptionsForEntity))) {
            unset($this->FeedSubscriptionsForEntity);
        } else {
            $this->FeedSubscriptionsForEntity = $feedSubscriptionsForEntity;
        }
        return $this;
    }
    /**
     * Get Feeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeeds()
    {
        return isset($this->Feeds) ? $this->Feeds : null;
    }
    /**
     * Set Feeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setFeeds(\NexusDigital/MiratelForce\StructType\QueryResult $feeds = null)
    {
        if (is_null($feeds) || (is_array($feeds) && empty($feeds))) {
            unset($this->Feeds);
        } else {
            $this->Feeds = $feeds;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get Histories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getHistories()
    {
        return isset($this->Histories) ? $this->Histories : null;
    }
    /**
     * Set Histories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setHistories(\NexusDigital/MiratelForce\StructType\QueryResult $histories = null)
    {
        if (is_null($histories) || (is_array($histories) && empty($histories))) {
            unset($this->Histories);
        } else {
            $this->Histories = $histories;
        }
        return $this;
    }
    /**
     * Get Individual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Individual|null
     */
    public function getIndividual()
    {
        return isset($this->Individual) ? $this->Individual : null;
    }
    /**
     * Set Individual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Individual $individual
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setIndividual(\NexusDigital/MiratelForce\StructType\Individual $individual = null)
    {
        if (is_null($individual) || (is_array($individual) && empty($individual))) {
            unset($this->Individual);
        } else {
            $this->Individual = $individual;
        }
        return $this;
    }
    /**
     * Get IndividualId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndividualId()
    {
        return isset($this->IndividualId) ? $this->IndividualId : null;
    }
    /**
     * Set IndividualId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $individualId
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setIndividualId($individualId = null)
    {
        // validation for constraint: string
        if (!is_null($individualId) && !is_string($individualId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualId, true), gettype($individualId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($individualId) && mb_strlen($individualId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($individualId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($individualId) && !preg_match('/[a-zA-Z0-9]{18}/', $individualId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($individualId, true)), __LINE__);
        }
        if (is_null($individualId) || (is_array($individualId) && empty($individualId))) {
            unset($this->IndividualId);
        } else {
            $this->IndividualId = $individualId;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsEmailBounced value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEmailBounced()
    {
        return isset($this->IsEmailBounced) ? $this->IsEmailBounced : null;
    }
    /**
     * Set IsEmailBounced value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEmailBounced
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setIsEmailBounced($isEmailBounced = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEmailBounced) && !is_bool($isEmailBounced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEmailBounced, true), gettype($isEmailBounced)), __LINE__);
        }
        if (is_null($isEmailBounced) || (is_array($isEmailBounced) && empty($isEmailBounced))) {
            unset($this->IsEmailBounced);
        } else {
            $this->IsEmailBounced = $isEmailBounced;
        }
        return $this;
    }
    /**
     * Get Jigsaw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJigsaw()
    {
        return isset($this->Jigsaw) ? $this->Jigsaw : null;
    }
    /**
     * Set Jigsaw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jigsaw
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setJigsaw($jigsaw = null)
    {
        // validation for constraint: string
        if (!is_null($jigsaw) && !is_string($jigsaw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jigsaw, true), gettype($jigsaw)), __LINE__);
        }
        if (is_null($jigsaw) || (is_array($jigsaw) && empty($jigsaw))) {
            unset($this->Jigsaw);
        } else {
            $this->Jigsaw = $jigsaw;
        }
        return $this;
    }
    /**
     * Get JigsawContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJigsawContactId()
    {
        return isset($this->JigsawContactId) ? $this->JigsawContactId : null;
    }
    /**
     * Set JigsawContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jigsawContactId
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setJigsawContactId($jigsawContactId = null)
    {
        // validation for constraint: string
        if (!is_null($jigsawContactId) && !is_string($jigsawContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jigsawContactId, true), gettype($jigsawContactId)), __LINE__);
        }
        if (is_null($jigsawContactId) || (is_array($jigsawContactId) && empty($jigsawContactId))) {
            unset($this->JigsawContactId);
        } else {
            $this->JigsawContactId = $jigsawContactId;
        }
        return $this;
    }
    /**
     * Get LastActivityDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastActivityDate()
    {
        return isset($this->LastActivityDate) ? $this->LastActivityDate : null;
    }
    /**
     * Set LastActivityDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastActivityDate
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setLastActivityDate($lastActivityDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastActivityDate) && !is_string($lastActivityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActivityDate, true), gettype($lastActivityDate)), __LINE__);
        }
        if (is_null($lastActivityDate) || (is_array($lastActivityDate) && empty($lastActivityDate))) {
            unset($this->LastActivityDate);
        } else {
            $this->LastActivityDate = $lastActivityDate;
        }
        return $this;
    }
    /**
     * Get LastCURequestDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastCURequestDate()
    {
        return isset($this->LastCURequestDate) ? $this->LastCURequestDate : null;
    }
    /**
     * Set LastCURequestDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastCURequestDate
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setLastCURequestDate($lastCURequestDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastCURequestDate) && !is_string($lastCURequestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastCURequestDate, true), gettype($lastCURequestDate)), __LINE__);
        }
        if (is_null($lastCURequestDate) || (is_array($lastCURequestDate) && empty($lastCURequestDate))) {
            unset($this->LastCURequestDate);
        } else {
            $this->LastCURequestDate = $lastCURequestDate;
        }
        return $this;
    }
    /**
     * Get LastCUUpdateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastCUUpdateDate()
    {
        return isset($this->LastCUUpdateDate) ? $this->LastCUUpdateDate : null;
    }
    /**
     * Set LastCUUpdateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastCUUpdateDate
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setLastCUUpdateDate($lastCUUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastCUUpdateDate) && !is_string($lastCUUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastCUUpdateDate, true), gettype($lastCUUpdateDate)), __LINE__);
        }
        if (is_null($lastCUUpdateDate) || (is_array($lastCUUpdateDate) && empty($lastCUUpdateDate))) {
            unset($this->LastCUUpdateDate);
        } else {
            $this->LastCUUpdateDate = $lastCUUpdateDate;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get LastReferencedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastReferencedDate()
    {
        return isset($this->LastReferencedDate) ? $this->LastReferencedDate : null;
    }
    /**
     * Set LastReferencedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastReferencedDate
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setLastReferencedDate($lastReferencedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReferencedDate) && !is_string($lastReferencedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastReferencedDate, true), gettype($lastReferencedDate)), __LINE__);
        }
        if (is_null($lastReferencedDate) || (is_array($lastReferencedDate) && empty($lastReferencedDate))) {
            unset($this->LastReferencedDate);
        } else {
            $this->LastReferencedDate = $lastReferencedDate;
        }
        return $this;
    }
    /**
     * Get LastViewedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastViewedDate()
    {
        return isset($this->LastViewedDate) ? $this->LastViewedDate : null;
    }
    /**
     * Set LastViewedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastViewedDate
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setLastViewedDate($lastViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastViewedDate) && !is_string($lastViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastViewedDate, true), gettype($lastViewedDate)), __LINE__);
        }
        if (is_null($lastViewedDate) || (is_array($lastViewedDate) && empty($lastViewedDate))) {
            unset($this->LastViewedDate);
        } else {
            $this->LastViewedDate = $lastViewedDate;
        }
        return $this;
    }
    /**
     * Get ListEmailIndividualRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getListEmailIndividualRecipients()
    {
        return isset($this->ListEmailIndividualRecipients) ? $this->ListEmailIndividualRecipients : null;
    }
    /**
     * Set ListEmailIndividualRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $listEmailIndividualRecipients
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setListEmailIndividualRecipients(\NexusDigital/MiratelForce\StructType\QueryResult $listEmailIndividualRecipients = null)
    {
        if (is_null($listEmailIndividualRecipients) || (is_array($listEmailIndividualRecipients) && empty($listEmailIndividualRecipients))) {
            unset($this->ListEmailIndividualRecipients);
        } else {
            $this->ListEmailIndividualRecipients = $listEmailIndividualRecipients;
        }
        return $this;
    }
    /**
     * Get LookedUpFromActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getLookedUpFromActivities()
    {
        return isset($this->LookedUpFromActivities) ? $this->LookedUpFromActivities : null;
    }
    /**
     * Set LookedUpFromActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setLookedUpFromActivities(\NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities = null)
    {
        if (is_null($lookedUpFromActivities) || (is_array($lookedUpFromActivities) && empty($lookedUpFromActivities))) {
            unset($this->LookedUpFromActivities);
        } else {
            $this->LookedUpFromActivities = $lookedUpFromActivities;
        }
        return $this;
    }
    /**
     * Get MailingAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Address|null
     */
    public function getMailingAddress()
    {
        return isset($this->MailingAddress) ? $this->MailingAddress : null;
    }
    /**
     * Set MailingAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Address $mailingAddress
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMailingAddress(\NexusDigital/MiratelForce\StructType\Address $mailingAddress = null)
    {
        if (is_null($mailingAddress) || (is_array($mailingAddress) && empty($mailingAddress))) {
            unset($this->MailingAddress);
        } else {
            $this->MailingAddress = $mailingAddress;
        }
        return $this;
    }
    /**
     * Get MailingCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingCity()
    {
        return isset($this->MailingCity) ? $this->MailingCity : null;
    }
    /**
     * Set MailingCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingCity
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMailingCity($mailingCity = null)
    {
        // validation for constraint: string
        if (!is_null($mailingCity) && !is_string($mailingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingCity, true), gettype($mailingCity)), __LINE__);
        }
        if (is_null($mailingCity) || (is_array($mailingCity) && empty($mailingCity))) {
            unset($this->MailingCity);
        } else {
            $this->MailingCity = $mailingCity;
        }
        return $this;
    }
    /**
     * Get MailingCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingCountry()
    {
        return isset($this->MailingCountry) ? $this->MailingCountry : null;
    }
    /**
     * Set MailingCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingCountry
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMailingCountry($mailingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($mailingCountry) && !is_string($mailingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingCountry, true), gettype($mailingCountry)), __LINE__);
        }
        if (is_null($mailingCountry) || (is_array($mailingCountry) && empty($mailingCountry))) {
            unset($this->MailingCountry);
        } else {
            $this->MailingCountry = $mailingCountry;
        }
        return $this;
    }
    /**
     * Get MailingGeocodeAccuracy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingGeocodeAccuracy()
    {
        return isset($this->MailingGeocodeAccuracy) ? $this->MailingGeocodeAccuracy : null;
    }
    /**
     * Set MailingGeocodeAccuracy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingGeocodeAccuracy
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMailingGeocodeAccuracy($mailingGeocodeAccuracy = null)
    {
        // validation for constraint: string
        if (!is_null($mailingGeocodeAccuracy) && !is_string($mailingGeocodeAccuracy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingGeocodeAccuracy, true), gettype($mailingGeocodeAccuracy)), __LINE__);
        }
        if (is_null($mailingGeocodeAccuracy) || (is_array($mailingGeocodeAccuracy) && empty($mailingGeocodeAccuracy))) {
            unset($this->MailingGeocodeAccuracy);
        } else {
            $this->MailingGeocodeAccuracy = $mailingGeocodeAccuracy;
        }
        return $this;
    }
    /**
     * Get MailingLatitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMailingLatitude()
    {
        return isset($this->MailingLatitude) ? $this->MailingLatitude : null;
    }
    /**
     * Set MailingLatitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mailingLatitude
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMailingLatitude($mailingLatitude = null)
    {
        // validation for constraint: float
        if (!is_null($mailingLatitude) && !(is_float($mailingLatitude) || is_numeric($mailingLatitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mailingLatitude, true), gettype($mailingLatitude)), __LINE__);
        }
        if (is_null($mailingLatitude) || (is_array($mailingLatitude) && empty($mailingLatitude))) {
            unset($this->MailingLatitude);
        } else {
            $this->MailingLatitude = $mailingLatitude;
        }
        return $this;
    }
    /**
     * Get MailingLongitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMailingLongitude()
    {
        return isset($this->MailingLongitude) ? $this->MailingLongitude : null;
    }
    /**
     * Set MailingLongitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $mailingLongitude
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMailingLongitude($mailingLongitude = null)
    {
        // validation for constraint: float
        if (!is_null($mailingLongitude) && !(is_float($mailingLongitude) || is_numeric($mailingLongitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mailingLongitude, true), gettype($mailingLongitude)), __LINE__);
        }
        if (is_null($mailingLongitude) || (is_array($mailingLongitude) && empty($mailingLongitude))) {
            unset($this->MailingLongitude);
        } else {
            $this->MailingLongitude = $mailingLongitude;
        }
        return $this;
    }
    /**
     * Get MailingPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingPostalCode()
    {
        return isset($this->MailingPostalCode) ? $this->MailingPostalCode : null;
    }
    /**
     * Set MailingPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingPostalCode
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMailingPostalCode($mailingPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($mailingPostalCode) && !is_string($mailingPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingPostalCode, true), gettype($mailingPostalCode)), __LINE__);
        }
        if (is_null($mailingPostalCode) || (is_array($mailingPostalCode) && empty($mailingPostalCode))) {
            unset($this->MailingPostalCode);
        } else {
            $this->MailingPostalCode = $mailingPostalCode;
        }
        return $this;
    }
    /**
     * Get MailingState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingState()
    {
        return isset($this->MailingState) ? $this->MailingState : null;
    }
    /**
     * Set MailingState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingState
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMailingState($mailingState = null)
    {
        // validation for constraint: string
        if (!is_null($mailingState) && !is_string($mailingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingState, true), gettype($mailingState)), __LINE__);
        }
        if (is_null($mailingState) || (is_array($mailingState) && empty($mailingState))) {
            unset($this->MailingState);
        } else {
            $this->MailingState = $mailingState;
        }
        return $this;
    }
    /**
     * Get MailingStreet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMailingStreet()
    {
        return isset($this->MailingStreet) ? $this->MailingStreet : null;
    }
    /**
     * Set MailingStreet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mailingStreet
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMailingStreet($mailingStreet = null)
    {
        // validation for constraint: string
        if (!is_null($mailingStreet) && !is_string($mailingStreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailingStreet, true), gettype($mailingStreet)), __LINE__);
        }
        if (is_null($mailingStreet) || (is_array($mailingStreet) && empty($mailingStreet))) {
            unset($this->MailingStreet);
        } else {
            $this->MailingStreet = $mailingStreet;
        }
        return $this;
    }
    /**
     * Get MasterRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Contact|null
     */
    public function getMasterRecord()
    {
        return isset($this->MasterRecord) ? $this->MasterRecord : null;
    }
    /**
     * Set MasterRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Contact $masterRecord
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMasterRecord(\NexusDigital/MiratelForce\StructType\Contact $masterRecord = null)
    {
        if (is_null($masterRecord) || (is_array($masterRecord) && empty($masterRecord))) {
            unset($this->MasterRecord);
        } else {
            $this->MasterRecord = $masterRecord;
        }
        return $this;
    }
    /**
     * Get MasterRecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterRecordId()
    {
        return isset($this->MasterRecordId) ? $this->MasterRecordId : null;
    }
    /**
     * Set MasterRecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterRecordId
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMasterRecordId($masterRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($masterRecordId) && !is_string($masterRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterRecordId, true), gettype($masterRecordId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($masterRecordId) && mb_strlen($masterRecordId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($masterRecordId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($masterRecordId) && !preg_match('/[a-zA-Z0-9]{18}/', $masterRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($masterRecordId, true)), __LINE__);
        }
        if (is_null($masterRecordId) || (is_array($masterRecordId) && empty($masterRecordId))) {
            unset($this->MasterRecordId);
        } else {
            $this->MasterRecordId = $masterRecordId;
        }
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notes
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setNotes(\NexusDigital/MiratelForce\StructType\QueryResult $notes = null)
    {
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get NotesAndAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNotesAndAttachments()
    {
        return isset($this->NotesAndAttachments) ? $this->NotesAndAttachments : null;
    }
    /**
     * Set NotesAndAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setNotesAndAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments = null)
    {
        if (is_null($notesAndAttachments) || (is_array($notesAndAttachments) && empty($notesAndAttachments))) {
            unset($this->NotesAndAttachments);
        } else {
            $this->NotesAndAttachments = $notesAndAttachments;
        }
        return $this;
    }
    /**
     * Get OpenActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getOpenActivities()
    {
        return isset($this->OpenActivities) ? $this->OpenActivities : null;
    }
    /**
     * Set OpenActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $openActivities
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setOpenActivities(\NexusDigital/MiratelForce\StructType\QueryResult $openActivities = null)
    {
        if (is_null($openActivities) || (is_array($openActivities) && empty($openActivities))) {
            unset($this->OpenActivities);
        } else {
            $this->OpenActivities = $openActivities;
        }
        return $this;
    }
    /**
     * Get Opportunities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getOpportunities()
    {
        return isset($this->Opportunities) ? $this->Opportunities : null;
    }
    /**
     * Set Opportunities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $opportunities
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setOpportunities(\NexusDigital/MiratelForce\StructType\QueryResult $opportunities = null)
    {
        if (is_null($opportunities) || (is_array($opportunities) && empty($opportunities))) {
            unset($this->Opportunities);
        } else {
            $this->Opportunities = $opportunities;
        }
        return $this;
    }
    /**
     * Get OpportunityContactRoles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getOpportunityContactRoles()
    {
        return isset($this->OpportunityContactRoles) ? $this->OpportunityContactRoles : null;
    }
    /**
     * Set OpportunityContactRoles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $opportunityContactRoles
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setOpportunityContactRoles(\NexusDigital/MiratelForce\StructType\QueryResult $opportunityContactRoles = null)
    {
        if (is_null($opportunityContactRoles) || (is_array($opportunityContactRoles) && empty($opportunityContactRoles))) {
            unset($this->OpportunityContactRoles);
        } else {
            $this->OpportunityContactRoles = $opportunityContactRoles;
        }
        return $this;
    }
    /**
     * Get OutgoingEmailRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getOutgoingEmailRelations()
    {
        return isset($this->OutgoingEmailRelations) ? $this->OutgoingEmailRelations : null;
    }
    /**
     * Set OutgoingEmailRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setOutgoingEmailRelations(\NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations = null)
    {
        if (is_null($outgoingEmailRelations) || (is_array($outgoingEmailRelations) && empty($outgoingEmailRelations))) {
            unset($this->OutgoingEmailRelations);
        } else {
            $this->OutgoingEmailRelations = $outgoingEmailRelations;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\User $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get ParentEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getParentEntities()
    {
        return isset($this->ParentEntities) ? $this->ParentEntities : null;
    }
    /**
     * Set ParentEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setParentEntities(\NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null)
    {
        if (is_null($parentEntities) || (is_array($parentEntities) && empty($parentEntities))) {
            unset($this->ParentEntities);
        } else {
            $this->ParentEntities = $parentEntities;
        }
        return $this;
    }
    /**
     * Get PersonRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getPersonRecord()
    {
        return isset($this->PersonRecord) ? $this->PersonRecord : null;
    }
    /**
     * Set PersonRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $personRecord
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setPersonRecord(\NexusDigital/MiratelForce\StructType\QueryResult $personRecord = null)
    {
        if (is_null($personRecord) || (is_array($personRecord) && empty($personRecord))) {
            unset($this->PersonRecord);
        } else {
            $this->PersonRecord = $personRecord;
        }
        return $this;
    }
    /**
     * Get Personas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getPersonas()
    {
        return isset($this->Personas) ? $this->Personas : null;
    }
    /**
     * Set Personas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $personas
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setPersonas(\NexusDigital/MiratelForce\StructType\QueryResult $personas = null)
    {
        if (is_null($personas) || (is_array($personas) && empty($personas))) {
            unset($this->Personas);
        } else {
            $this->Personas = $personas;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get PhotoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhotoUrl()
    {
        return isset($this->PhotoUrl) ? $this->PhotoUrl : null;
    }
    /**
     * Set PhotoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $photoUrl
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setPhotoUrl($photoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($photoUrl) && !is_string($photoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($photoUrl, true), gettype($photoUrl)), __LINE__);
        }
        if (is_null($photoUrl) || (is_array($photoUrl) && empty($photoUrl))) {
            unset($this->PhotoUrl);
        } else {
            $this->PhotoUrl = $photoUrl;
        }
        return $this;
    }
    /**
     * Get Posts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getPosts()
    {
        return isset($this->Posts) ? $this->Posts : null;
    }
    /**
     * Set Posts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $posts
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setPosts(\NexusDigital/MiratelForce\StructType\QueryResult $posts = null)
    {
        if (is_null($posts) || (is_array($posts) && empty($posts))) {
            unset($this->Posts);
        } else {
            $this->Posts = $posts;
        }
        return $this;
    }
    /**
     * Get ProcessInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessInstances()
    {
        return isset($this->ProcessInstances) ? $this->ProcessInstances : null;
    }
    /**
     * Set ProcessInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setProcessInstances(\NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null)
    {
        if (is_null($processInstances) || (is_array($processInstances) && empty($processInstances))) {
            unset($this->ProcessInstances);
        } else {
            $this->ProcessInstances = $processInstances;
        }
        return $this;
    }
    /**
     * Get ProcessSteps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessSteps()
    {
        return isset($this->ProcessSteps) ? $this->ProcessSteps : null;
    }
    /**
     * Set ProcessSteps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setProcessSteps(\NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null)
    {
        if (is_null($processSteps) || (is_array($processSteps) && empty($processSteps))) {
            unset($this->ProcessSteps);
        } else {
            $this->ProcessSteps = $processSteps;
        }
        return $this;
    }
    /**
     * Get Quotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getQuotes()
    {
        return isset($this->Quotes) ? $this->Quotes : null;
    }
    /**
     * Set Quotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $quotes
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setQuotes(\NexusDigital/MiratelForce\StructType\QueryResult $quotes = null)
    {
        if (is_null($quotes) || (is_array($quotes) && empty($quotes))) {
            unset($this->Quotes);
        } else {
            $this->Quotes = $quotes;
        }
        return $this;
    }
    /**
     * Get RecordActionHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActionHistories()
    {
        return isset($this->RecordActionHistories) ? $this->RecordActionHistories : null;
    }
    /**
     * Set RecordActionHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setRecordActionHistories(\NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null)
    {
        if (is_null($recordActionHistories) || (is_array($recordActionHistories) && empty($recordActionHistories))) {
            unset($this->RecordActionHistories);
        } else {
            $this->RecordActionHistories = $recordActionHistories;
        }
        return $this;
    }
    /**
     * Get RecordActions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActions()
    {
        return isset($this->RecordActions) ? $this->RecordActions : null;
    }
    /**
     * Set RecordActions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setRecordActions(\NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null)
    {
        if (is_null($recordActions) || (is_array($recordActions) && empty($recordActions))) {
            unset($this->RecordActions);
        } else {
            $this->RecordActions = $recordActions;
        }
        return $this;
    }
    /**
     * Get RecordAssociatedGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordAssociatedGroups()
    {
        return isset($this->RecordAssociatedGroups) ? $this->RecordAssociatedGroups : null;
    }
    /**
     * Set RecordAssociatedGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setRecordAssociatedGroups(\NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups = null)
    {
        if (is_null($recordAssociatedGroups) || (is_array($recordAssociatedGroups) && empty($recordAssociatedGroups))) {
            unset($this->RecordAssociatedGroups);
        } else {
            $this->RecordAssociatedGroups = $recordAssociatedGroups;
        }
        return $this;
    }
    /**
     * Get ReportsTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Contact|null
     */
    public function getReportsTo()
    {
        return isset($this->ReportsTo) ? $this->ReportsTo : null;
    }
    /**
     * Set ReportsTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Contact $reportsTo
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setReportsTo(\NexusDigital/MiratelForce\StructType\Contact $reportsTo = null)
    {
        if (is_null($reportsTo) || (is_array($reportsTo) && empty($reportsTo))) {
            unset($this->ReportsTo);
        } else {
            $this->ReportsTo = $reportsTo;
        }
        return $this;
    }
    /**
     * Get ReportsToId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportsToId()
    {
        return isset($this->ReportsToId) ? $this->ReportsToId : null;
    }
    /**
     * Set ReportsToId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportsToId
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setReportsToId($reportsToId = null)
    {
        // validation for constraint: string
        if (!is_null($reportsToId) && !is_string($reportsToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportsToId, true), gettype($reportsToId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($reportsToId) && mb_strlen($reportsToId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($reportsToId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($reportsToId) && !preg_match('/[a-zA-Z0-9]{18}/', $reportsToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($reportsToId, true)), __LINE__);
        }
        if (is_null($reportsToId) || (is_array($reportsToId) && empty($reportsToId))) {
            unset($this->ReportsToId);
        } else {
            $this->ReportsToId = $reportsToId;
        }
        return $this;
    }
    /**
     * Get Salutation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalutation()
    {
        return isset($this->Salutation) ? $this->Salutation : null;
    }
    /**
     * Set Salutation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salutation
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        if (is_null($salutation) || (is_array($salutation) && empty($salutation))) {
            unset($this->Salutation);
        } else {
            $this->Salutation = $salutation;
        }
        return $this;
    }
    /**
     * Get Shares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getShares()
    {
        return isset($this->Shares) ? $this->Shares : null;
    }
    /**
     * Set Shares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $shares
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setShares(\NexusDigital/MiratelForce\StructType\QueryResult $shares = null)
    {
        if (is_null($shares) || (is_array($shares) && empty($shares))) {
            unset($this->Shares);
        } else {
            $this->Shares = $shares;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffix
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TaskRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTaskRelations()
    {
        return isset($this->TaskRelations) ? $this->TaskRelations : null;
    }
    /**
     * Set TaskRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setTaskRelations(\NexusDigital/MiratelForce\StructType\QueryResult $taskRelations = null)
    {
        if (is_null($taskRelations) || (is_array($taskRelations) && empty($taskRelations))) {
            unset($this->TaskRelations);
        } else {
            $this->TaskRelations = $taskRelations;
        }
        return $this;
    }
    /**
     * Get TaskWhoRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTaskWhoRelations()
    {
        return isset($this->TaskWhoRelations) ? $this->TaskWhoRelations : null;
    }
    /**
     * Set TaskWhoRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskWhoRelations
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setTaskWhoRelations(\NexusDigital/MiratelForce\StructType\QueryResult $taskWhoRelations = null)
    {
        if (is_null($taskWhoRelations) || (is_array($taskWhoRelations) && empty($taskWhoRelations))) {
            unset($this->TaskWhoRelations);
        } else {
            $this->TaskWhoRelations = $taskWhoRelations;
        }
        return $this;
    }
    /**
     * Get Tasks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTasks()
    {
        return isset($this->Tasks) ? $this->Tasks : null;
    }
    /**
     * Set Tasks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $tasks
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setTasks(\NexusDigital/MiratelForce\StructType\QueryResult $tasks = null)
    {
        if (is_null($tasks) || (is_array($tasks) && empty($tasks))) {
            unset($this->Tasks);
        } else {
            $this->Tasks = $tasks;
        }
        return $this;
    }
    /**
     * Get Ticket_Orders__r value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTicket_Orders__r()
    {
        return isset($this->Ticket_Orders__r) ? $this->Ticket_Orders__r : null;
    }
    /**
     * Set Ticket_Orders__r value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $ticket_Orders__r
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setTicket_Orders__r(\NexusDigital/MiratelForce\StructType\QueryResult $ticket_Orders__r = null)
    {
        if (is_null($ticket_Orders__r) || (is_array($ticket_Orders__r) && empty($ticket_Orders__r))) {
            unset($this->Ticket_Orders__r);
        } else {
            $this->Ticket_Orders__r = $ticket_Orders__r;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get TopicAssignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTopicAssignments()
    {
        return isset($this->TopicAssignments) ? $this->TopicAssignments : null;
    }
    /**
     * Set TopicAssignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setTopicAssignments(\NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null)
    {
        if (is_null($topicAssignments) || (is_array($topicAssignments) && empty($topicAssignments))) {
            unset($this->TopicAssignments);
        } else {
            $this->TopicAssignments = $topicAssignments;
        }
        return $this;
    }
    /**
     * Get UndecidedEventRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getUndecidedEventRelations()
    {
        return isset($this->UndecidedEventRelations) ? $this->UndecidedEventRelations : null;
    }
    /**
     * Set UndecidedEventRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $undecidedEventRelations
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setUndecidedEventRelations(\NexusDigital/MiratelForce\StructType\QueryResult $undecidedEventRelations = null)
    {
        if (is_null($undecidedEventRelations) || (is_array($undecidedEventRelations) && empty($undecidedEventRelations))) {
            unset($this->UndecidedEventRelations);
        } else {
            $this->UndecidedEventRelations = $undecidedEventRelations;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Get Users value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getUsers()
    {
        return isset($this->Users) ? $this->Users : null;
    }
    /**
     * Set Users value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $users
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setUsers(\NexusDigital/MiratelForce\StructType\QueryResult $users = null)
    {
        if (is_null($users) || (is_array($users) && empty($users))) {
            unset($this->Users);
        } else {
            $this->Users = $users;
        }
        return $this;
    }
    /**
     * Get WorkOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getWorkOrders()
    {
        return isset($this->WorkOrders) ? $this->WorkOrders : null;
    }
    /**
     * Set WorkOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $workOrders
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public function setWorkOrders(\NexusDigital/MiratelForce\StructType\QueryResult $workOrders = null)
    {
        if (is_null($workOrders) || (is_array($workOrders) && empty($workOrders))) {
            unset($this->WorkOrders);
        } else {
            $this->WorkOrders = $workOrders;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Contact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
