<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campaign__Feed StructType
 * @subpackage Structs
 */
class Campaign__Feed extends SObject
{
    /**
     * The BestComment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\FeedComment
     */
    public $BestComment;
    /**
     * The BestCommentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $BestCommentId;
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Body;
    /**
     * The CommentCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CommentCount;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The FeedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedAttachments;
    /**
     * The FeedComments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedComments;
    /**
     * The FeedLikes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedLikes;
    /**
     * The FeedSignals
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedSignals;
    /**
     * The FeedTrackedChanges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedTrackedChanges;
    /**
     * The InsertedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $InsertedBy;
    /**
     * The InsertedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $InsertedById;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsRichText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRichText;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LikeCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LikeCount;
    /**
     * The LinkUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinkUrl;
    /**
     * The NetworkScope
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NetworkScope;
    /**
     * The Parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Campaign__c
     */
    public $Parent;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The RelatedRecordId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RelatedRecordId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The Visibility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Visibility;
    /**
     * Constructor method for Campaign__Feed
     * @uses Campaign__Feed::setBestComment()
     * @uses Campaign__Feed::setBestCommentId()
     * @uses Campaign__Feed::setBody()
     * @uses Campaign__Feed::setCommentCount()
     * @uses Campaign__Feed::setCreatedBy()
     * @uses Campaign__Feed::setCreatedById()
     * @uses Campaign__Feed::setCreatedDate()
     * @uses Campaign__Feed::setFeedAttachments()
     * @uses Campaign__Feed::setFeedComments()
     * @uses Campaign__Feed::setFeedLikes()
     * @uses Campaign__Feed::setFeedSignals()
     * @uses Campaign__Feed::setFeedTrackedChanges()
     * @uses Campaign__Feed::setInsertedBy()
     * @uses Campaign__Feed::setInsertedById()
     * @uses Campaign__Feed::setIsDeleted()
     * @uses Campaign__Feed::setIsRichText()
     * @uses Campaign__Feed::setLastModifiedDate()
     * @uses Campaign__Feed::setLikeCount()
     * @uses Campaign__Feed::setLinkUrl()
     * @uses Campaign__Feed::setNetworkScope()
     * @uses Campaign__Feed::setParent()
     * @uses Campaign__Feed::setParentId()
     * @uses Campaign__Feed::setRelatedRecordId()
     * @uses Campaign__Feed::setSystemModstamp()
     * @uses Campaign__Feed::setTitle()
     * @uses Campaign__Feed::setType()
     * @uses Campaign__Feed::setVisibility()
     * @param \NexusDigital/MiratelForce\StructType\FeedComment $bestComment
     * @param string $bestCommentId
     * @param string $body
     * @param int $commentCount
     * @param \NexusDigital/MiratelForce\StructType\SObject $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedComments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedLikes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSignals
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedTrackedChanges
     * @param \NexusDigital/MiratelForce\StructType\SObject $insertedBy
     * @param string $insertedById
     * @param bool $isDeleted
     * @param bool $isRichText
     * @param string $lastModifiedDate
     * @param int $likeCount
     * @param string $linkUrl
     * @param string $networkScope
     * @param \NexusDigital/MiratelForce\StructType\Campaign__c $parent
     * @param string $parentId
     * @param string $relatedRecordId
     * @param string $systemModstamp
     * @param string $title
     * @param string $type
     * @param string $visibility
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\FeedComment $bestComment = null, $bestCommentId = null, $body = null, $commentCount = null, \NexusDigital/MiratelForce\StructType\SObject $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedComments = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedLikes = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedSignals = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedTrackedChanges = null, \NexusDigital/MiratelForce\StructType\SObject $insertedBy = null, $insertedById = null, $isDeleted = null, $isRichText = null, $lastModifiedDate = null, $likeCount = null, $linkUrl = null, $networkScope = null, \NexusDigital/MiratelForce\StructType\Campaign__c $parent = null, $parentId = null, $relatedRecordId = null, $systemModstamp = null, $title = null, $type = null, $visibility = null)
    {
        $this
            ->setBestComment($bestComment)
            ->setBestCommentId($bestCommentId)
            ->setBody($body)
            ->setCommentCount($commentCount)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setFeedAttachments($feedAttachments)
            ->setFeedComments($feedComments)
            ->setFeedLikes($feedLikes)
            ->setFeedSignals($feedSignals)
            ->setFeedTrackedChanges($feedTrackedChanges)
            ->setInsertedBy($insertedBy)
            ->setInsertedById($insertedById)
            ->setIsDeleted($isDeleted)
            ->setIsRichText($isRichText)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLikeCount($likeCount)
            ->setLinkUrl($linkUrl)
            ->setNetworkScope($networkScope)
            ->setParent($parent)
            ->setParentId($parentId)
            ->setRelatedRecordId($relatedRecordId)
            ->setSystemModstamp($systemModstamp)
            ->setTitle($title)
            ->setType($type)
            ->setVisibility($visibility);
    }
    /**
     * Get BestComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\FeedComment|null
     */
    public function getBestComment()
    {
        return isset($this->BestComment) ? $this->BestComment : null;
    }
    /**
     * Set BestComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\FeedComment $bestComment
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setBestComment(\NexusDigital/MiratelForce\StructType\FeedComment $bestComment = null)
    {
        if (is_null($bestComment) || (is_array($bestComment) && empty($bestComment))) {
            unset($this->BestComment);
        } else {
            $this->BestComment = $bestComment;
        }
        return $this;
    }
    /**
     * Get BestCommentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBestCommentId()
    {
        return isset($this->BestCommentId) ? $this->BestCommentId : null;
    }
    /**
     * Set BestCommentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bestCommentId
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setBestCommentId($bestCommentId = null)
    {
        // validation for constraint: string
        if (!is_null($bestCommentId) && !is_string($bestCommentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestCommentId, true), gettype($bestCommentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($bestCommentId) && mb_strlen($bestCommentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($bestCommentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($bestCommentId) && !preg_match('/[a-zA-Z0-9]{18}/', $bestCommentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($bestCommentId, true)), __LINE__);
        }
        if (is_null($bestCommentId) || (is_array($bestCommentId) && empty($bestCommentId))) {
            unset($this->BestCommentId);
        } else {
            $this->BestCommentId = $bestCommentId;
        }
        return $this;
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $body
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($body, true), gettype($body)), __LINE__);
        }
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get CommentCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCommentCount()
    {
        return isset($this->CommentCount) ? $this->CommentCount : null;
    }
    /**
     * Set CommentCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $commentCount
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setCommentCount($commentCount = null)
    {
        // validation for constraint: int
        if (!is_null($commentCount) && !(is_int($commentCount) || ctype_digit($commentCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commentCount, true), gettype($commentCount)), __LINE__);
        }
        if (is_null($commentCount) || (is_array($commentCount) && empty($commentCount))) {
            unset($this->CommentCount);
        } else {
            $this->CommentCount = $commentCount;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\SObject $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get FeedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedAttachments()
    {
        return isset($this->FeedAttachments) ? $this->FeedAttachments : null;
    }
    /**
     * Set FeedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedAttachments
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setFeedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $feedAttachments = null)
    {
        if (is_null($feedAttachments) || (is_array($feedAttachments) && empty($feedAttachments))) {
            unset($this->FeedAttachments);
        } else {
            $this->FeedAttachments = $feedAttachments;
        }
        return $this;
    }
    /**
     * Get FeedComments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedComments()
    {
        return isset($this->FeedComments) ? $this->FeedComments : null;
    }
    /**
     * Set FeedComments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedComments
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setFeedComments(\NexusDigital/MiratelForce\StructType\QueryResult $feedComments = null)
    {
        if (is_null($feedComments) || (is_array($feedComments) && empty($feedComments))) {
            unset($this->FeedComments);
        } else {
            $this->FeedComments = $feedComments;
        }
        return $this;
    }
    /**
     * Get FeedLikes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedLikes()
    {
        return isset($this->FeedLikes) ? $this->FeedLikes : null;
    }
    /**
     * Set FeedLikes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedLikes
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setFeedLikes(\NexusDigital/MiratelForce\StructType\QueryResult $feedLikes = null)
    {
        if (is_null($feedLikes) || (is_array($feedLikes) && empty($feedLikes))) {
            unset($this->FeedLikes);
        } else {
            $this->FeedLikes = $feedLikes;
        }
        return $this;
    }
    /**
     * Get FeedSignals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedSignals()
    {
        return isset($this->FeedSignals) ? $this->FeedSignals : null;
    }
    /**
     * Set FeedSignals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSignals
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setFeedSignals(\NexusDigital/MiratelForce\StructType\QueryResult $feedSignals = null)
    {
        if (is_null($feedSignals) || (is_array($feedSignals) && empty($feedSignals))) {
            unset($this->FeedSignals);
        } else {
            $this->FeedSignals = $feedSignals;
        }
        return $this;
    }
    /**
     * Get FeedTrackedChanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedTrackedChanges()
    {
        return isset($this->FeedTrackedChanges) ? $this->FeedTrackedChanges : null;
    }
    /**
     * Set FeedTrackedChanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedTrackedChanges
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setFeedTrackedChanges(\NexusDigital/MiratelForce\StructType\QueryResult $feedTrackedChanges = null)
    {
        if (is_null($feedTrackedChanges) || (is_array($feedTrackedChanges) && empty($feedTrackedChanges))) {
            unset($this->FeedTrackedChanges);
        } else {
            $this->FeedTrackedChanges = $feedTrackedChanges;
        }
        return $this;
    }
    /**
     * Get InsertedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getInsertedBy()
    {
        return isset($this->InsertedBy) ? $this->InsertedBy : null;
    }
    /**
     * Set InsertedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $insertedBy
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setInsertedBy(\NexusDigital/MiratelForce\StructType\SObject $insertedBy = null)
    {
        if (is_null($insertedBy) || (is_array($insertedBy) && empty($insertedBy))) {
            unset($this->InsertedBy);
        } else {
            $this->InsertedBy = $insertedBy;
        }
        return $this;
    }
    /**
     * Get InsertedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertedById()
    {
        return isset($this->InsertedById) ? $this->InsertedById : null;
    }
    /**
     * Set InsertedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $insertedById
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setInsertedById($insertedById = null)
    {
        // validation for constraint: string
        if (!is_null($insertedById) && !is_string($insertedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertedById, true), gettype($insertedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($insertedById) && mb_strlen($insertedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($insertedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($insertedById) && !preg_match('/[a-zA-Z0-9]{18}/', $insertedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($insertedById, true)), __LINE__);
        }
        if (is_null($insertedById) || (is_array($insertedById) && empty($insertedById))) {
            unset($this->InsertedById);
        } else {
            $this->InsertedById = $insertedById;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsRichText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRichText()
    {
        return isset($this->IsRichText) ? $this->IsRichText : null;
    }
    /**
     * Set IsRichText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRichText
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setIsRichText($isRichText = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRichText) && !is_bool($isRichText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRichText, true), gettype($isRichText)), __LINE__);
        }
        if (is_null($isRichText) || (is_array($isRichText) && empty($isRichText))) {
            unset($this->IsRichText);
        } else {
            $this->IsRichText = $isRichText;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LikeCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLikeCount()
    {
        return isset($this->LikeCount) ? $this->LikeCount : null;
    }
    /**
     * Set LikeCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $likeCount
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setLikeCount($likeCount = null)
    {
        // validation for constraint: int
        if (!is_null($likeCount) && !(is_int($likeCount) || ctype_digit($likeCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($likeCount, true), gettype($likeCount)), __LINE__);
        }
        if (is_null($likeCount) || (is_array($likeCount) && empty($likeCount))) {
            unset($this->LikeCount);
        } else {
            $this->LikeCount = $likeCount;
        }
        return $this;
    }
    /**
     * Get LinkUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkUrl()
    {
        return isset($this->LinkUrl) ? $this->LinkUrl : null;
    }
    /**
     * Set LinkUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkUrl
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setLinkUrl($linkUrl = null)
    {
        // validation for constraint: string
        if (!is_null($linkUrl) && !is_string($linkUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkUrl, true), gettype($linkUrl)), __LINE__);
        }
        if (is_null($linkUrl) || (is_array($linkUrl) && empty($linkUrl))) {
            unset($this->LinkUrl);
        } else {
            $this->LinkUrl = $linkUrl;
        }
        return $this;
    }
    /**
     * Get NetworkScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkScope()
    {
        return isset($this->NetworkScope) ? $this->NetworkScope : null;
    }
    /**
     * Set NetworkScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkScope
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setNetworkScope($networkScope = null)
    {
        // validation for constraint: string
        if (!is_null($networkScope) && !is_string($networkScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkScope, true), gettype($networkScope)), __LINE__);
        }
        if (is_null($networkScope) || (is_array($networkScope) && empty($networkScope))) {
            unset($this->NetworkScope);
        } else {
            $this->NetworkScope = $networkScope;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Campaign__c|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Campaign__c $parent
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setParent(\NexusDigital/MiratelForce\StructType\Campaign__c $parent = null)
    {
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get RelatedRecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedRecordId()
    {
        return isset($this->RelatedRecordId) ? $this->RelatedRecordId : null;
    }
    /**
     * Set RelatedRecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedRecordId
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setRelatedRecordId($relatedRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedRecordId) && !is_string($relatedRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedRecordId, true), gettype($relatedRecordId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($relatedRecordId) && mb_strlen($relatedRecordId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($relatedRecordId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($relatedRecordId) && !preg_match('/[a-zA-Z0-9]{18}/', $relatedRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($relatedRecordId, true)), __LINE__);
        }
        if (is_null($relatedRecordId) || (is_array($relatedRecordId) && empty($relatedRecordId))) {
            unset($this->RelatedRecordId);
        } else {
            $this->RelatedRecordId = $relatedRecordId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Visibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisibility()
    {
        return isset($this->Visibility) ? $this->Visibility : null;
    }
    /**
     * Set Visibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visibility
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public function setVisibility($visibility = null)
    {
        // validation for constraint: string
        if (!is_null($visibility) && !is_string($visibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visibility, true), gettype($visibility)), __LINE__);
        }
        if (is_null($visibility) || (is_array($visibility) && empty($visibility))) {
            unset($this->Visibility);
        } else {
            $this->Visibility = $visibility;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Campaign__Feed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
