<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campaign StructType
 * @subpackage Structs
 */
class Campaign extends SObject
{
    /**
     * The ActivityHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ActivityHistories;
    /**
     * The ActualCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ActualCost;
    /**
     * The AmountAllOpportunities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountAllOpportunities;
    /**
     * The AmountWonOpportunities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountWonOpportunities;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Attachments;
    /**
     * The BudgetedCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BudgetedCost;
    /**
     * The CampaignMemberRecordType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\RecordType
     */
    public $CampaignMemberRecordType;
    /**
     * The CampaignMemberRecordTypeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CampaignMemberRecordTypeId;
    /**
     * The CampaignMemberStatuses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CampaignMemberStatuses;
    /**
     * The CampaignMembers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CampaignMembers;
    /**
     * The ChildCampaigns
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ChildCampaigns;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DB_Campaign_Tactic__c
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DB_Campaign_Tactic__c;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Emails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Emails;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The EventRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EventRelations;
    /**
     * The Events
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Events;
    /**
     * The ExpectedResponse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ExpectedResponse;
    /**
     * The ExpectedRevenue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ExpectedRevenue;
    /**
     * The FeedSubscriptionsForEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedSubscriptionsForEntity;
    /**
     * The Feeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Feeds;
    /**
     * The Histories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Histories;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastActivityDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastActivityDate;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastReferencedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastReferencedDate;
    /**
     * The LastViewedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastViewedDate;
    /**
     * The Leads
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Leads;
    /**
     * The ListEmailRecipientSources
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ListEmailRecipientSources;
    /**
     * The ListEmails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ListEmails;
    /**
     * The LookedUpFromActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $LookedUpFromActivities;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NumberOfContacts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfContacts;
    /**
     * The NumberOfConvertedLeads
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfConvertedLeads;
    /**
     * The NumberOfLeads
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfLeads;
    /**
     * The NumberOfOpportunities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfOpportunities;
    /**
     * The NumberOfResponses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfResponses;
    /**
     * The NumberOfWonOpportunities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfWonOpportunities;
    /**
     * The NumberSent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NumberSent;
    /**
     * The OpenActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $OpenActivities;
    /**
     * The Opportunities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Opportunities;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The Parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Campaign
     */
    public $Parent;
    /**
     * The ParentEntities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ParentEntities;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The ProcessInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessInstances;
    /**
     * The ProcessSteps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessSteps;
    /**
     * The RecordActionHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActionHistories;
    /**
     * The RecordActions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActions;
    /**
     * The RecordAssociatedGroups
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordAssociatedGroups;
    /**
     * The Shares
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Shares;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TaskRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TaskRelations;
    /**
     * The Tasks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Tasks;
    /**
     * The TopicAssignments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TopicAssignments;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * Constructor method for Campaign
     * @uses Campaign::setActivityHistories()
     * @uses Campaign::setActualCost()
     * @uses Campaign::setAmountAllOpportunities()
     * @uses Campaign::setAmountWonOpportunities()
     * @uses Campaign::setAttachedContentDocuments()
     * @uses Campaign::setAttachedContentNotes()
     * @uses Campaign::setAttachments()
     * @uses Campaign::setBudgetedCost()
     * @uses Campaign::setCampaignMemberRecordType()
     * @uses Campaign::setCampaignMemberRecordTypeId()
     * @uses Campaign::setCampaignMemberStatuses()
     * @uses Campaign::setCampaignMembers()
     * @uses Campaign::setChildCampaigns()
     * @uses Campaign::setCombinedAttachments()
     * @uses Campaign::setContentDocumentLinks()
     * @uses Campaign::setCreatedBy()
     * @uses Campaign::setCreatedById()
     * @uses Campaign::setCreatedDate()
     * @uses Campaign::setDB_Campaign_Tactic__c()
     * @uses Campaign::setDescription()
     * @uses Campaign::setEmails()
     * @uses Campaign::setEndDate()
     * @uses Campaign::setEventRelations()
     * @uses Campaign::setEvents()
     * @uses Campaign::setExpectedResponse()
     * @uses Campaign::setExpectedRevenue()
     * @uses Campaign::setFeedSubscriptionsForEntity()
     * @uses Campaign::setFeeds()
     * @uses Campaign::setHistories()
     * @uses Campaign::setIsActive()
     * @uses Campaign::setIsDeleted()
     * @uses Campaign::setLastActivityDate()
     * @uses Campaign::setLastModifiedBy()
     * @uses Campaign::setLastModifiedById()
     * @uses Campaign::setLastModifiedDate()
     * @uses Campaign::setLastReferencedDate()
     * @uses Campaign::setLastViewedDate()
     * @uses Campaign::setLeads()
     * @uses Campaign::setListEmailRecipientSources()
     * @uses Campaign::setListEmails()
     * @uses Campaign::setLookedUpFromActivities()
     * @uses Campaign::setName()
     * @uses Campaign::setNumberOfContacts()
     * @uses Campaign::setNumberOfConvertedLeads()
     * @uses Campaign::setNumberOfLeads()
     * @uses Campaign::setNumberOfOpportunities()
     * @uses Campaign::setNumberOfResponses()
     * @uses Campaign::setNumberOfWonOpportunities()
     * @uses Campaign::setNumberSent()
     * @uses Campaign::setOpenActivities()
     * @uses Campaign::setOpportunities()
     * @uses Campaign::setOwner()
     * @uses Campaign::setOwnerId()
     * @uses Campaign::setParent()
     * @uses Campaign::setParentEntities()
     * @uses Campaign::setParentId()
     * @uses Campaign::setProcessInstances()
     * @uses Campaign::setProcessSteps()
     * @uses Campaign::setRecordActionHistories()
     * @uses Campaign::setRecordActions()
     * @uses Campaign::setRecordAssociatedGroups()
     * @uses Campaign::setShares()
     * @uses Campaign::setStartDate()
     * @uses Campaign::setStatus()
     * @uses Campaign::setSystemModstamp()
     * @uses Campaign::setTaskRelations()
     * @uses Campaign::setTasks()
     * @uses Campaign::setTopicAssignments()
     * @uses Campaign::setType()
     * @uses Campaign::setUserRecordAccess()
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $activityHistories
     * @param float $actualCost
     * @param float $amountAllOpportunities
     * @param float $amountWonOpportunities
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @param float $budgetedCost
     * @param \NexusDigital/MiratelForce\StructType\RecordType $campaignMemberRecordType
     * @param string $campaignMemberRecordTypeId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $campaignMemberStatuses
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $childCampaigns
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $dB_Campaign_Tactic__c
     * @param string $description
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emails
     * @param string $endDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $events
     * @param float $expectedResponse
     * @param float $expectedRevenue
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @param bool $isActive
     * @param bool $isDeleted
     * @param string $lastActivityDate
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastReferencedDate
     * @param string $lastViewedDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $leads
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $listEmailRecipientSources
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $listEmails
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities
     * @param string $name
     * @param int $numberOfContacts
     * @param int $numberOfConvertedLeads
     * @param int $numberOfLeads
     * @param int $numberOfOpportunities
     * @param int $numberOfResponses
     * @param int $numberOfWonOpportunities
     * @param float $numberSent
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $openActivities
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $opportunities
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @param string $ownerId
     * @param \NexusDigital/MiratelForce\StructType\Campaign $parent
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @param string $parentId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $shares
     * @param string $startDate
     * @param string $status
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $tasks
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @param string $type
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\QueryResult $activityHistories = null, $actualCost = null, $amountAllOpportunities = null, $amountWonOpportunities = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachments = null, $budgetedCost = null, \NexusDigital/MiratelForce\StructType\RecordType $campaignMemberRecordType = null, $campaignMemberRecordTypeId = null, \NexusDigital/MiratelForce\StructType\QueryResult $campaignMemberStatuses = null, \NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers = null, \NexusDigital/MiratelForce\StructType\QueryResult $childCampaigns = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $dB_Campaign_Tactic__c = null, $description = null, \NexusDigital/MiratelForce\StructType\QueryResult $emails = null, $endDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $events = null, $expectedResponse = null, $expectedRevenue = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null, \NexusDigital/MiratelForce\StructType\QueryResult $feeds = null, \NexusDigital/MiratelForce\StructType\QueryResult $histories = null, $isActive = null, $isDeleted = null, $lastActivityDate = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastReferencedDate = null, $lastViewedDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $leads = null, \NexusDigital/MiratelForce\StructType\QueryResult $listEmailRecipientSources = null, \NexusDigital/MiratelForce\StructType\QueryResult $listEmails = null, \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities = null, $name = null, $numberOfContacts = null, $numberOfConvertedLeads = null, $numberOfLeads = null, $numberOfOpportunities = null, $numberOfResponses = null, $numberOfWonOpportunities = null, $numberSent = null, \NexusDigital/MiratelForce\StructType\QueryResult $openActivities = null, \NexusDigital/MiratelForce\StructType\QueryResult $opportunities = null, \NexusDigital/MiratelForce\StructType\User $owner = null, $ownerId = null, \NexusDigital/MiratelForce\StructType\Campaign $parent = null, \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null, $parentId = null, \NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null, \NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups = null, \NexusDigital/MiratelForce\StructType\QueryResult $shares = null, $startDate = null, $status = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $tasks = null, \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null, $type = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        $this
            ->setActivityHistories($activityHistories)
            ->setActualCost($actualCost)
            ->setAmountAllOpportunities($amountAllOpportunities)
            ->setAmountWonOpportunities($amountWonOpportunities)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setAttachments($attachments)
            ->setBudgetedCost($budgetedCost)
            ->setCampaignMemberRecordType($campaignMemberRecordType)
            ->setCampaignMemberRecordTypeId($campaignMemberRecordTypeId)
            ->setCampaignMemberStatuses($campaignMemberStatuses)
            ->setCampaignMembers($campaignMembers)
            ->setChildCampaigns($childCampaigns)
            ->setCombinedAttachments($combinedAttachments)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDB_Campaign_Tactic__c($dB_Campaign_Tactic__c)
            ->setDescription($description)
            ->setEmails($emails)
            ->setEndDate($endDate)
            ->setEventRelations($eventRelations)
            ->setEvents($events)
            ->setExpectedResponse($expectedResponse)
            ->setExpectedRevenue($expectedRevenue)
            ->setFeedSubscriptionsForEntity($feedSubscriptionsForEntity)
            ->setFeeds($feeds)
            ->setHistories($histories)
            ->setIsActive($isActive)
            ->setIsDeleted($isDeleted)
            ->setLastActivityDate($lastActivityDate)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastReferencedDate($lastReferencedDate)
            ->setLastViewedDate($lastViewedDate)
            ->setLeads($leads)
            ->setListEmailRecipientSources($listEmailRecipientSources)
            ->setListEmails($listEmails)
            ->setLookedUpFromActivities($lookedUpFromActivities)
            ->setName($name)
            ->setNumberOfContacts($numberOfContacts)
            ->setNumberOfConvertedLeads($numberOfConvertedLeads)
            ->setNumberOfLeads($numberOfLeads)
            ->setNumberOfOpportunities($numberOfOpportunities)
            ->setNumberOfResponses($numberOfResponses)
            ->setNumberOfWonOpportunities($numberOfWonOpportunities)
            ->setNumberSent($numberSent)
            ->setOpenActivities($openActivities)
            ->setOpportunities($opportunities)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setParent($parent)
            ->setParentEntities($parentEntities)
            ->setParentId($parentId)
            ->setProcessInstances($processInstances)
            ->setProcessSteps($processSteps)
            ->setRecordActionHistories($recordActionHistories)
            ->setRecordActions($recordActions)
            ->setRecordAssociatedGroups($recordAssociatedGroups)
            ->setShares($shares)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setSystemModstamp($systemModstamp)
            ->setTaskRelations($taskRelations)
            ->setTasks($tasks)
            ->setTopicAssignments($topicAssignments)
            ->setType($type)
            ->setUserRecordAccess($userRecordAccess);
    }
    /**
     * Get ActivityHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getActivityHistories()
    {
        return isset($this->ActivityHistories) ? $this->ActivityHistories : null;
    }
    /**
     * Set ActivityHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $activityHistories
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setActivityHistories(\NexusDigital/MiratelForce\StructType\QueryResult $activityHistories = null)
    {
        if (is_null($activityHistories) || (is_array($activityHistories) && empty($activityHistories))) {
            unset($this->ActivityHistories);
        } else {
            $this->ActivityHistories = $activityHistories;
        }
        return $this;
    }
    /**
     * Get ActualCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getActualCost()
    {
        return isset($this->ActualCost) ? $this->ActualCost : null;
    }
    /**
     * Set ActualCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $actualCost
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setActualCost($actualCost = null)
    {
        // validation for constraint: float
        if (!is_null($actualCost) && !(is_float($actualCost) || is_numeric($actualCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($actualCost, true), gettype($actualCost)), __LINE__);
        }
        if (is_null($actualCost) || (is_array($actualCost) && empty($actualCost))) {
            unset($this->ActualCost);
        } else {
            $this->ActualCost = $actualCost;
        }
        return $this;
    }
    /**
     * Get AmountAllOpportunities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountAllOpportunities()
    {
        return isset($this->AmountAllOpportunities) ? $this->AmountAllOpportunities : null;
    }
    /**
     * Set AmountAllOpportunities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountAllOpportunities
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setAmountAllOpportunities($amountAllOpportunities = null)
    {
        // validation for constraint: float
        if (!is_null($amountAllOpportunities) && !(is_float($amountAllOpportunities) || is_numeric($amountAllOpportunities))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountAllOpportunities, true), gettype($amountAllOpportunities)), __LINE__);
        }
        if (is_null($amountAllOpportunities) || (is_array($amountAllOpportunities) && empty($amountAllOpportunities))) {
            unset($this->AmountAllOpportunities);
        } else {
            $this->AmountAllOpportunities = $amountAllOpportunities;
        }
        return $this;
    }
    /**
     * Get AmountWonOpportunities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountWonOpportunities()
    {
        return isset($this->AmountWonOpportunities) ? $this->AmountWonOpportunities : null;
    }
    /**
     * Set AmountWonOpportunities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountWonOpportunities
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setAmountWonOpportunities($amountWonOpportunities = null)
    {
        // validation for constraint: float
        if (!is_null($amountWonOpportunities) && !(is_float($amountWonOpportunities) || is_numeric($amountWonOpportunities))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountWonOpportunities, true), gettype($amountWonOpportunities)), __LINE__);
        }
        if (is_null($amountWonOpportunities) || (is_array($amountWonOpportunities) && empty($amountWonOpportunities))) {
            unset($this->AmountWonOpportunities);
        } else {
            $this->AmountWonOpportunities = $amountWonOpportunities;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get Attachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachments()
    {
        return isset($this->Attachments) ? $this->Attachments : null;
    }
    /**
     * Set Attachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $attachments = null)
    {
        if (is_null($attachments) || (is_array($attachments) && empty($attachments))) {
            unset($this->Attachments);
        } else {
            $this->Attachments = $attachments;
        }
        return $this;
    }
    /**
     * Get BudgetedCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBudgetedCost()
    {
        return isset($this->BudgetedCost) ? $this->BudgetedCost : null;
    }
    /**
     * Set BudgetedCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $budgetedCost
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setBudgetedCost($budgetedCost = null)
    {
        // validation for constraint: float
        if (!is_null($budgetedCost) && !(is_float($budgetedCost) || is_numeric($budgetedCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($budgetedCost, true), gettype($budgetedCost)), __LINE__);
        }
        if (is_null($budgetedCost) || (is_array($budgetedCost) && empty($budgetedCost))) {
            unset($this->BudgetedCost);
        } else {
            $this->BudgetedCost = $budgetedCost;
        }
        return $this;
    }
    /**
     * Get CampaignMemberRecordType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\RecordType|null
     */
    public function getCampaignMemberRecordType()
    {
        return isset($this->CampaignMemberRecordType) ? $this->CampaignMemberRecordType : null;
    }
    /**
     * Set CampaignMemberRecordType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\RecordType $campaignMemberRecordType
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setCampaignMemberRecordType(\NexusDigital/MiratelForce\StructType\RecordType $campaignMemberRecordType = null)
    {
        if (is_null($campaignMemberRecordType) || (is_array($campaignMemberRecordType) && empty($campaignMemberRecordType))) {
            unset($this->CampaignMemberRecordType);
        } else {
            $this->CampaignMemberRecordType = $campaignMemberRecordType;
        }
        return $this;
    }
    /**
     * Get CampaignMemberRecordTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignMemberRecordTypeId()
    {
        return isset($this->CampaignMemberRecordTypeId) ? $this->CampaignMemberRecordTypeId : null;
    }
    /**
     * Set CampaignMemberRecordTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignMemberRecordTypeId
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setCampaignMemberRecordTypeId($campaignMemberRecordTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignMemberRecordTypeId) && !is_string($campaignMemberRecordTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignMemberRecordTypeId, true), gettype($campaignMemberRecordTypeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($campaignMemberRecordTypeId) && mb_strlen($campaignMemberRecordTypeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($campaignMemberRecordTypeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($campaignMemberRecordTypeId) && !preg_match('/[a-zA-Z0-9]{18}/', $campaignMemberRecordTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($campaignMemberRecordTypeId, true)), __LINE__);
        }
        if (is_null($campaignMemberRecordTypeId) || (is_array($campaignMemberRecordTypeId) && empty($campaignMemberRecordTypeId))) {
            unset($this->CampaignMemberRecordTypeId);
        } else {
            $this->CampaignMemberRecordTypeId = $campaignMemberRecordTypeId;
        }
        return $this;
    }
    /**
     * Get CampaignMemberStatuses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCampaignMemberStatuses()
    {
        return isset($this->CampaignMemberStatuses) ? $this->CampaignMemberStatuses : null;
    }
    /**
     * Set CampaignMemberStatuses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $campaignMemberStatuses
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setCampaignMemberStatuses(\NexusDigital/MiratelForce\StructType\QueryResult $campaignMemberStatuses = null)
    {
        if (is_null($campaignMemberStatuses) || (is_array($campaignMemberStatuses) && empty($campaignMemberStatuses))) {
            unset($this->CampaignMemberStatuses);
        } else {
            $this->CampaignMemberStatuses = $campaignMemberStatuses;
        }
        return $this;
    }
    /**
     * Get CampaignMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCampaignMembers()
    {
        return isset($this->CampaignMembers) ? $this->CampaignMembers : null;
    }
    /**
     * Set CampaignMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setCampaignMembers(\NexusDigital/MiratelForce\StructType\QueryResult $campaignMembers = null)
    {
        if (is_null($campaignMembers) || (is_array($campaignMembers) && empty($campaignMembers))) {
            unset($this->CampaignMembers);
        } else {
            $this->CampaignMembers = $campaignMembers;
        }
        return $this;
    }
    /**
     * Get ChildCampaigns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getChildCampaigns()
    {
        return isset($this->ChildCampaigns) ? $this->ChildCampaigns : null;
    }
    /**
     * Set ChildCampaigns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $childCampaigns
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setChildCampaigns(\NexusDigital/MiratelForce\StructType\QueryResult $childCampaigns = null)
    {
        if (is_null($childCampaigns) || (is_array($childCampaigns) && empty($childCampaigns))) {
            unset($this->ChildCampaigns);
        } else {
            $this->ChildCampaigns = $childCampaigns;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DB_Campaign_Tactic__c value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDB_Campaign_Tactic__c()
    {
        return isset($this->DB_Campaign_Tactic__c) ? $this->DB_Campaign_Tactic__c : null;
    }
    /**
     * Set DB_Campaign_Tactic__c value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dB_Campaign_Tactic__c
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setDB_Campaign_Tactic__c($dB_Campaign_Tactic__c = null)
    {
        // validation for constraint: string
        if (!is_null($dB_Campaign_Tactic__c) && !is_string($dB_Campaign_Tactic__c)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dB_Campaign_Tactic__c, true), gettype($dB_Campaign_Tactic__c)), __LINE__);
        }
        if (is_null($dB_Campaign_Tactic__c) || (is_array($dB_Campaign_Tactic__c) && empty($dB_Campaign_Tactic__c))) {
            unset($this->DB_Campaign_Tactic__c);
        } else {
            $this->DB_Campaign_Tactic__c = $dB_Campaign_Tactic__c;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Emails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEmails()
    {
        return isset($this->Emails) ? $this->Emails : null;
    }
    /**
     * Set Emails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emails
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setEmails(\NexusDigital/MiratelForce\StructType\QueryResult $emails = null)
    {
        if (is_null($emails) || (is_array($emails) && empty($emails))) {
            unset($this->Emails);
        } else {
            $this->Emails = $emails;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get EventRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEventRelations()
    {
        return isset($this->EventRelations) ? $this->EventRelations : null;
    }
    /**
     * Set EventRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setEventRelations(\NexusDigital/MiratelForce\StructType\QueryResult $eventRelations = null)
    {
        if (is_null($eventRelations) || (is_array($eventRelations) && empty($eventRelations))) {
            unset($this->EventRelations);
        } else {
            $this->EventRelations = $eventRelations;
        }
        return $this;
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $events
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setEvents(\NexusDigital/MiratelForce\StructType\QueryResult $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get ExpectedResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getExpectedResponse()
    {
        return isset($this->ExpectedResponse) ? $this->ExpectedResponse : null;
    }
    /**
     * Set ExpectedResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $expectedResponse
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setExpectedResponse($expectedResponse = null)
    {
        // validation for constraint: float
        if (!is_null($expectedResponse) && !(is_float($expectedResponse) || is_numeric($expectedResponse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expectedResponse, true), gettype($expectedResponse)), __LINE__);
        }
        if (is_null($expectedResponse) || (is_array($expectedResponse) && empty($expectedResponse))) {
            unset($this->ExpectedResponse);
        } else {
            $this->ExpectedResponse = $expectedResponse;
        }
        return $this;
    }
    /**
     * Get ExpectedRevenue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getExpectedRevenue()
    {
        return isset($this->ExpectedRevenue) ? $this->ExpectedRevenue : null;
    }
    /**
     * Set ExpectedRevenue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $expectedRevenue
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setExpectedRevenue($expectedRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($expectedRevenue) && !(is_float($expectedRevenue) || is_numeric($expectedRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expectedRevenue, true), gettype($expectedRevenue)), __LINE__);
        }
        if (is_null($expectedRevenue) || (is_array($expectedRevenue) && empty($expectedRevenue))) {
            unset($this->ExpectedRevenue);
        } else {
            $this->ExpectedRevenue = $expectedRevenue;
        }
        return $this;
    }
    /**
     * Get FeedSubscriptionsForEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedSubscriptionsForEntity()
    {
        return isset($this->FeedSubscriptionsForEntity) ? $this->FeedSubscriptionsForEntity : null;
    }
    /**
     * Set FeedSubscriptionsForEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setFeedSubscriptionsForEntity(\NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null)
    {
        if (is_null($feedSubscriptionsForEntity) || (is_array($feedSubscriptionsForEntity) && empty($feedSubscriptionsForEntity))) {
            unset($this->FeedSubscriptionsForEntity);
        } else {
            $this->FeedSubscriptionsForEntity = $feedSubscriptionsForEntity;
        }
        return $this;
    }
    /**
     * Get Feeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeeds()
    {
        return isset($this->Feeds) ? $this->Feeds : null;
    }
    /**
     * Set Feeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setFeeds(\NexusDigital/MiratelForce\StructType\QueryResult $feeds = null)
    {
        if (is_null($feeds) || (is_array($feeds) && empty($feeds))) {
            unset($this->Feeds);
        } else {
            $this->Feeds = $feeds;
        }
        return $this;
    }
    /**
     * Get Histories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getHistories()
    {
        return isset($this->Histories) ? $this->Histories : null;
    }
    /**
     * Set Histories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setHistories(\NexusDigital/MiratelForce\StructType\QueryResult $histories = null)
    {
        if (is_null($histories) || (is_array($histories) && empty($histories))) {
            unset($this->Histories);
        } else {
            $this->Histories = $histories;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastActivityDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastActivityDate()
    {
        return isset($this->LastActivityDate) ? $this->LastActivityDate : null;
    }
    /**
     * Set LastActivityDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastActivityDate
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setLastActivityDate($lastActivityDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastActivityDate) && !is_string($lastActivityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActivityDate, true), gettype($lastActivityDate)), __LINE__);
        }
        if (is_null($lastActivityDate) || (is_array($lastActivityDate) && empty($lastActivityDate))) {
            unset($this->LastActivityDate);
        } else {
            $this->LastActivityDate = $lastActivityDate;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastReferencedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastReferencedDate()
    {
        return isset($this->LastReferencedDate) ? $this->LastReferencedDate : null;
    }
    /**
     * Set LastReferencedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastReferencedDate
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setLastReferencedDate($lastReferencedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReferencedDate) && !is_string($lastReferencedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastReferencedDate, true), gettype($lastReferencedDate)), __LINE__);
        }
        if (is_null($lastReferencedDate) || (is_array($lastReferencedDate) && empty($lastReferencedDate))) {
            unset($this->LastReferencedDate);
        } else {
            $this->LastReferencedDate = $lastReferencedDate;
        }
        return $this;
    }
    /**
     * Get LastViewedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastViewedDate()
    {
        return isset($this->LastViewedDate) ? $this->LastViewedDate : null;
    }
    /**
     * Set LastViewedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastViewedDate
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setLastViewedDate($lastViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastViewedDate) && !is_string($lastViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastViewedDate, true), gettype($lastViewedDate)), __LINE__);
        }
        if (is_null($lastViewedDate) || (is_array($lastViewedDate) && empty($lastViewedDate))) {
            unset($this->LastViewedDate);
        } else {
            $this->LastViewedDate = $lastViewedDate;
        }
        return $this;
    }
    /**
     * Get Leads value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getLeads()
    {
        return isset($this->Leads) ? $this->Leads : null;
    }
    /**
     * Set Leads value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $leads
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setLeads(\NexusDigital/MiratelForce\StructType\QueryResult $leads = null)
    {
        if (is_null($leads) || (is_array($leads) && empty($leads))) {
            unset($this->Leads);
        } else {
            $this->Leads = $leads;
        }
        return $this;
    }
    /**
     * Get ListEmailRecipientSources value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getListEmailRecipientSources()
    {
        return isset($this->ListEmailRecipientSources) ? $this->ListEmailRecipientSources : null;
    }
    /**
     * Set ListEmailRecipientSources value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $listEmailRecipientSources
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setListEmailRecipientSources(\NexusDigital/MiratelForce\StructType\QueryResult $listEmailRecipientSources = null)
    {
        if (is_null($listEmailRecipientSources) || (is_array($listEmailRecipientSources) && empty($listEmailRecipientSources))) {
            unset($this->ListEmailRecipientSources);
        } else {
            $this->ListEmailRecipientSources = $listEmailRecipientSources;
        }
        return $this;
    }
    /**
     * Get ListEmails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getListEmails()
    {
        return isset($this->ListEmails) ? $this->ListEmails : null;
    }
    /**
     * Set ListEmails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $listEmails
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setListEmails(\NexusDigital/MiratelForce\StructType\QueryResult $listEmails = null)
    {
        if (is_null($listEmails) || (is_array($listEmails) && empty($listEmails))) {
            unset($this->ListEmails);
        } else {
            $this->ListEmails = $listEmails;
        }
        return $this;
    }
    /**
     * Get LookedUpFromActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getLookedUpFromActivities()
    {
        return isset($this->LookedUpFromActivities) ? $this->LookedUpFromActivities : null;
    }
    /**
     * Set LookedUpFromActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setLookedUpFromActivities(\NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities = null)
    {
        if (is_null($lookedUpFromActivities) || (is_array($lookedUpFromActivities) && empty($lookedUpFromActivities))) {
            unset($this->LookedUpFromActivities);
        } else {
            $this->LookedUpFromActivities = $lookedUpFromActivities;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumberOfContacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfContacts()
    {
        return isset($this->NumberOfContacts) ? $this->NumberOfContacts : null;
    }
    /**
     * Set NumberOfContacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfContacts
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setNumberOfContacts($numberOfContacts = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfContacts) && !(is_int($numberOfContacts) || ctype_digit($numberOfContacts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfContacts, true), gettype($numberOfContacts)), __LINE__);
        }
        if (is_null($numberOfContacts) || (is_array($numberOfContacts) && empty($numberOfContacts))) {
            unset($this->NumberOfContacts);
        } else {
            $this->NumberOfContacts = $numberOfContacts;
        }
        return $this;
    }
    /**
     * Get NumberOfConvertedLeads value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfConvertedLeads()
    {
        return isset($this->NumberOfConvertedLeads) ? $this->NumberOfConvertedLeads : null;
    }
    /**
     * Set NumberOfConvertedLeads value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfConvertedLeads
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setNumberOfConvertedLeads($numberOfConvertedLeads = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfConvertedLeads) && !(is_int($numberOfConvertedLeads) || ctype_digit($numberOfConvertedLeads))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfConvertedLeads, true), gettype($numberOfConvertedLeads)), __LINE__);
        }
        if (is_null($numberOfConvertedLeads) || (is_array($numberOfConvertedLeads) && empty($numberOfConvertedLeads))) {
            unset($this->NumberOfConvertedLeads);
        } else {
            $this->NumberOfConvertedLeads = $numberOfConvertedLeads;
        }
        return $this;
    }
    /**
     * Get NumberOfLeads value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfLeads()
    {
        return isset($this->NumberOfLeads) ? $this->NumberOfLeads : null;
    }
    /**
     * Set NumberOfLeads value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfLeads
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setNumberOfLeads($numberOfLeads = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfLeads) && !(is_int($numberOfLeads) || ctype_digit($numberOfLeads))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfLeads, true), gettype($numberOfLeads)), __LINE__);
        }
        if (is_null($numberOfLeads) || (is_array($numberOfLeads) && empty($numberOfLeads))) {
            unset($this->NumberOfLeads);
        } else {
            $this->NumberOfLeads = $numberOfLeads;
        }
        return $this;
    }
    /**
     * Get NumberOfOpportunities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfOpportunities()
    {
        return isset($this->NumberOfOpportunities) ? $this->NumberOfOpportunities : null;
    }
    /**
     * Set NumberOfOpportunities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfOpportunities
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setNumberOfOpportunities($numberOfOpportunities = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOpportunities) && !(is_int($numberOfOpportunities) || ctype_digit($numberOfOpportunities))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfOpportunities, true), gettype($numberOfOpportunities)), __LINE__);
        }
        if (is_null($numberOfOpportunities) || (is_array($numberOfOpportunities) && empty($numberOfOpportunities))) {
            unset($this->NumberOfOpportunities);
        } else {
            $this->NumberOfOpportunities = $numberOfOpportunities;
        }
        return $this;
    }
    /**
     * Get NumberOfResponses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfResponses()
    {
        return isset($this->NumberOfResponses) ? $this->NumberOfResponses : null;
    }
    /**
     * Set NumberOfResponses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfResponses
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setNumberOfResponses($numberOfResponses = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfResponses) && !(is_int($numberOfResponses) || ctype_digit($numberOfResponses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfResponses, true), gettype($numberOfResponses)), __LINE__);
        }
        if (is_null($numberOfResponses) || (is_array($numberOfResponses) && empty($numberOfResponses))) {
            unset($this->NumberOfResponses);
        } else {
            $this->NumberOfResponses = $numberOfResponses;
        }
        return $this;
    }
    /**
     * Get NumberOfWonOpportunities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfWonOpportunities()
    {
        return isset($this->NumberOfWonOpportunities) ? $this->NumberOfWonOpportunities : null;
    }
    /**
     * Set NumberOfWonOpportunities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfWonOpportunities
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setNumberOfWonOpportunities($numberOfWonOpportunities = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfWonOpportunities) && !(is_int($numberOfWonOpportunities) || ctype_digit($numberOfWonOpportunities))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfWonOpportunities, true), gettype($numberOfWonOpportunities)), __LINE__);
        }
        if (is_null($numberOfWonOpportunities) || (is_array($numberOfWonOpportunities) && empty($numberOfWonOpportunities))) {
            unset($this->NumberOfWonOpportunities);
        } else {
            $this->NumberOfWonOpportunities = $numberOfWonOpportunities;
        }
        return $this;
    }
    /**
     * Get NumberSent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNumberSent()
    {
        return isset($this->NumberSent) ? $this->NumberSent : null;
    }
    /**
     * Set NumberSent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $numberSent
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setNumberSent($numberSent = null)
    {
        // validation for constraint: float
        if (!is_null($numberSent) && !(is_float($numberSent) || is_numeric($numberSent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numberSent, true), gettype($numberSent)), __LINE__);
        }
        if (is_null($numberSent) || (is_array($numberSent) && empty($numberSent))) {
            unset($this->NumberSent);
        } else {
            $this->NumberSent = $numberSent;
        }
        return $this;
    }
    /**
     * Get OpenActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getOpenActivities()
    {
        return isset($this->OpenActivities) ? $this->OpenActivities : null;
    }
    /**
     * Set OpenActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $openActivities
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setOpenActivities(\NexusDigital/MiratelForce\StructType\QueryResult $openActivities = null)
    {
        if (is_null($openActivities) || (is_array($openActivities) && empty($openActivities))) {
            unset($this->OpenActivities);
        } else {
            $this->OpenActivities = $openActivities;
        }
        return $this;
    }
    /**
     * Get Opportunities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getOpportunities()
    {
        return isset($this->Opportunities) ? $this->Opportunities : null;
    }
    /**
     * Set Opportunities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $opportunities
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setOpportunities(\NexusDigital/MiratelForce\StructType\QueryResult $opportunities = null)
    {
        if (is_null($opportunities) || (is_array($opportunities) && empty($opportunities))) {
            unset($this->Opportunities);
        } else {
            $this->Opportunities = $opportunities;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\User $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Campaign|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Campaign $parent
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setParent(\NexusDigital/MiratelForce\StructType\Campaign $parent = null)
    {
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get ParentEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getParentEntities()
    {
        return isset($this->ParentEntities) ? $this->ParentEntities : null;
    }
    /**
     * Set ParentEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setParentEntities(\NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null)
    {
        if (is_null($parentEntities) || (is_array($parentEntities) && empty($parentEntities))) {
            unset($this->ParentEntities);
        } else {
            $this->ParentEntities = $parentEntities;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get ProcessInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessInstances()
    {
        return isset($this->ProcessInstances) ? $this->ProcessInstances : null;
    }
    /**
     * Set ProcessInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setProcessInstances(\NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null)
    {
        if (is_null($processInstances) || (is_array($processInstances) && empty($processInstances))) {
            unset($this->ProcessInstances);
        } else {
            $this->ProcessInstances = $processInstances;
        }
        return $this;
    }
    /**
     * Get ProcessSteps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessSteps()
    {
        return isset($this->ProcessSteps) ? $this->ProcessSteps : null;
    }
    /**
     * Set ProcessSteps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setProcessSteps(\NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null)
    {
        if (is_null($processSteps) || (is_array($processSteps) && empty($processSteps))) {
            unset($this->ProcessSteps);
        } else {
            $this->ProcessSteps = $processSteps;
        }
        return $this;
    }
    /**
     * Get RecordActionHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActionHistories()
    {
        return isset($this->RecordActionHistories) ? $this->RecordActionHistories : null;
    }
    /**
     * Set RecordActionHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setRecordActionHistories(\NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null)
    {
        if (is_null($recordActionHistories) || (is_array($recordActionHistories) && empty($recordActionHistories))) {
            unset($this->RecordActionHistories);
        } else {
            $this->RecordActionHistories = $recordActionHistories;
        }
        return $this;
    }
    /**
     * Get RecordActions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActions()
    {
        return isset($this->RecordActions) ? $this->RecordActions : null;
    }
    /**
     * Set RecordActions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setRecordActions(\NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null)
    {
        if (is_null($recordActions) || (is_array($recordActions) && empty($recordActions))) {
            unset($this->RecordActions);
        } else {
            $this->RecordActions = $recordActions;
        }
        return $this;
    }
    /**
     * Get RecordAssociatedGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordAssociatedGroups()
    {
        return isset($this->RecordAssociatedGroups) ? $this->RecordAssociatedGroups : null;
    }
    /**
     * Set RecordAssociatedGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setRecordAssociatedGroups(\NexusDigital/MiratelForce\StructType\QueryResult $recordAssociatedGroups = null)
    {
        if (is_null($recordAssociatedGroups) || (is_array($recordAssociatedGroups) && empty($recordAssociatedGroups))) {
            unset($this->RecordAssociatedGroups);
        } else {
            $this->RecordAssociatedGroups = $recordAssociatedGroups;
        }
        return $this;
    }
    /**
     * Get Shares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getShares()
    {
        return isset($this->Shares) ? $this->Shares : null;
    }
    /**
     * Set Shares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $shares
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setShares(\NexusDigital/MiratelForce\StructType\QueryResult $shares = null)
    {
        if (is_null($shares) || (is_array($shares) && empty($shares))) {
            unset($this->Shares);
        } else {
            $this->Shares = $shares;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TaskRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTaskRelations()
    {
        return isset($this->TaskRelations) ? $this->TaskRelations : null;
    }
    /**
     * Set TaskRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setTaskRelations(\NexusDigital/MiratelForce\StructType\QueryResult $taskRelations = null)
    {
        if (is_null($taskRelations) || (is_array($taskRelations) && empty($taskRelations))) {
            unset($this->TaskRelations);
        } else {
            $this->TaskRelations = $taskRelations;
        }
        return $this;
    }
    /**
     * Get Tasks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTasks()
    {
        return isset($this->Tasks) ? $this->Tasks : null;
    }
    /**
     * Set Tasks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $tasks
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setTasks(\NexusDigital/MiratelForce\StructType\QueryResult $tasks = null)
    {
        if (is_null($tasks) || (is_array($tasks) && empty($tasks))) {
            unset($this->Tasks);
        } else {
            $this->Tasks = $tasks;
        }
        return $this;
    }
    /**
     * Get TopicAssignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTopicAssignments()
    {
        return isset($this->TopicAssignments) ? $this->TopicAssignments : null;
    }
    /**
     * Set TopicAssignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setTopicAssignments(\NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null)
    {
        if (is_null($topicAssignments) || (is_array($topicAssignments) && empty($topicAssignments))) {
            unset($this->TopicAssignments);
        } else {
            $this->TopicAssignments = $topicAssignments;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Campaign
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
