<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthSession StructType
 * @subpackage Structs
 */
class AuthSession extends SObject
{
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The IsCurrent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCurrent;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LoginGeo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\LoginGeo
     */
    public $LoginGeo;
    /**
     * The LoginGeoId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LoginGeoId;
    /**
     * The LoginHistory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\LoginHistory
     */
    public $LoginHistory;
    /**
     * The LoginHistoryId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LoginHistoryId;
    /**
     * The LoginType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginType;
    /**
     * The LogoutUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogoutUrl;
    /**
     * The NumSecondsValid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumSecondsValid;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The SessionPermSetActivations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $SessionPermSetActivations;
    /**
     * The SessionSecurityLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SessionSecurityLevel;
    /**
     * The SessionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SessionType;
    /**
     * The SourceIp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceIp;
    /**
     * The UserType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserType;
    /**
     * The Users
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Users;
    /**
     * The UsersId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UsersId;
    /**
     * Constructor method for AuthSession
     * @uses AuthSession::setCreatedDate()
     * @uses AuthSession::setIsCurrent()
     * @uses AuthSession::setLastModifiedDate()
     * @uses AuthSession::setLoginGeo()
     * @uses AuthSession::setLoginGeoId()
     * @uses AuthSession::setLoginHistory()
     * @uses AuthSession::setLoginHistoryId()
     * @uses AuthSession::setLoginType()
     * @uses AuthSession::setLogoutUrl()
     * @uses AuthSession::setNumSecondsValid()
     * @uses AuthSession::setParentId()
     * @uses AuthSession::setSessionPermSetActivations()
     * @uses AuthSession::setSessionSecurityLevel()
     * @uses AuthSession::setSessionType()
     * @uses AuthSession::setSourceIp()
     * @uses AuthSession::setUserType()
     * @uses AuthSession::setUsers()
     * @uses AuthSession::setUsersId()
     * @param string $createdDate
     * @param bool $isCurrent
     * @param string $lastModifiedDate
     * @param \NexusDigital/MiratelForce\StructType\LoginGeo $loginGeo
     * @param string $loginGeoId
     * @param \NexusDigital/MiratelForce\StructType\LoginHistory $loginHistory
     * @param string $loginHistoryId
     * @param string $loginType
     * @param string $logoutUrl
     * @param int $numSecondsValid
     * @param string $parentId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $sessionPermSetActivations
     * @param string $sessionSecurityLevel
     * @param string $sessionType
     * @param string $sourceIp
     * @param string $userType
     * @param \NexusDigital/MiratelForce\StructType\User $users
     * @param string $usersId
     */
    public function __construct($createdDate = null, $isCurrent = null, $lastModifiedDate = null, \NexusDigital/MiratelForce\StructType\LoginGeo $loginGeo = null, $loginGeoId = null, \NexusDigital/MiratelForce\StructType\LoginHistory $loginHistory = null, $loginHistoryId = null, $loginType = null, $logoutUrl = null, $numSecondsValid = null, $parentId = null, \NexusDigital/MiratelForce\StructType\QueryResult $sessionPermSetActivations = null, $sessionSecurityLevel = null, $sessionType = null, $sourceIp = null, $userType = null, \NexusDigital/MiratelForce\StructType\User $users = null, $usersId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setIsCurrent($isCurrent)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLoginGeo($loginGeo)
            ->setLoginGeoId($loginGeoId)
            ->setLoginHistory($loginHistory)
            ->setLoginHistoryId($loginHistoryId)
            ->setLoginType($loginType)
            ->setLogoutUrl($logoutUrl)
            ->setNumSecondsValid($numSecondsValid)
            ->setParentId($parentId)
            ->setSessionPermSetActivations($sessionPermSetActivations)
            ->setSessionSecurityLevel($sessionSecurityLevel)
            ->setSessionType($sessionType)
            ->setSourceIp($sourceIp)
            ->setUserType($userType)
            ->setUsers($users)
            ->setUsersId($usersId);
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get IsCurrent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCurrent()
    {
        return isset($this->IsCurrent) ? $this->IsCurrent : null;
    }
    /**
     * Set IsCurrent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCurrent
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setIsCurrent($isCurrent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCurrent) && !is_bool($isCurrent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCurrent, true), gettype($isCurrent)), __LINE__);
        }
        if (is_null($isCurrent) || (is_array($isCurrent) && empty($isCurrent))) {
            unset($this->IsCurrent);
        } else {
            $this->IsCurrent = $isCurrent;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LoginGeo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\LoginGeo|null
     */
    public function getLoginGeo()
    {
        return isset($this->LoginGeo) ? $this->LoginGeo : null;
    }
    /**
     * Set LoginGeo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\LoginGeo $loginGeo
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setLoginGeo(\NexusDigital/MiratelForce\StructType\LoginGeo $loginGeo = null)
    {
        if (is_null($loginGeo) || (is_array($loginGeo) && empty($loginGeo))) {
            unset($this->LoginGeo);
        } else {
            $this->LoginGeo = $loginGeo;
        }
        return $this;
    }
    /**
     * Get LoginGeoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginGeoId()
    {
        return isset($this->LoginGeoId) ? $this->LoginGeoId : null;
    }
    /**
     * Set LoginGeoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginGeoId
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setLoginGeoId($loginGeoId = null)
    {
        // validation for constraint: string
        if (!is_null($loginGeoId) && !is_string($loginGeoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginGeoId, true), gettype($loginGeoId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($loginGeoId) && mb_strlen($loginGeoId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($loginGeoId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($loginGeoId) && !preg_match('/[a-zA-Z0-9]{18}/', $loginGeoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($loginGeoId, true)), __LINE__);
        }
        if (is_null($loginGeoId) || (is_array($loginGeoId) && empty($loginGeoId))) {
            unset($this->LoginGeoId);
        } else {
            $this->LoginGeoId = $loginGeoId;
        }
        return $this;
    }
    /**
     * Get LoginHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\LoginHistory|null
     */
    public function getLoginHistory()
    {
        return isset($this->LoginHistory) ? $this->LoginHistory : null;
    }
    /**
     * Set LoginHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\LoginHistory $loginHistory
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setLoginHistory(\NexusDigital/MiratelForce\StructType\LoginHistory $loginHistory = null)
    {
        if (is_null($loginHistory) || (is_array($loginHistory) && empty($loginHistory))) {
            unset($this->LoginHistory);
        } else {
            $this->LoginHistory = $loginHistory;
        }
        return $this;
    }
    /**
     * Get LoginHistoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginHistoryId()
    {
        return isset($this->LoginHistoryId) ? $this->LoginHistoryId : null;
    }
    /**
     * Set LoginHistoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginHistoryId
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setLoginHistoryId($loginHistoryId = null)
    {
        // validation for constraint: string
        if (!is_null($loginHistoryId) && !is_string($loginHistoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginHistoryId, true), gettype($loginHistoryId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($loginHistoryId) && mb_strlen($loginHistoryId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($loginHistoryId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($loginHistoryId) && !preg_match('/[a-zA-Z0-9]{18}/', $loginHistoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($loginHistoryId, true)), __LINE__);
        }
        if (is_null($loginHistoryId) || (is_array($loginHistoryId) && empty($loginHistoryId))) {
            unset($this->LoginHistoryId);
        } else {
            $this->LoginHistoryId = $loginHistoryId;
        }
        return $this;
    }
    /**
     * Get LoginType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginType()
    {
        return isset($this->LoginType) ? $this->LoginType : null;
    }
    /**
     * Set LoginType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginType
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setLoginType($loginType = null)
    {
        // validation for constraint: string
        if (!is_null($loginType) && !is_string($loginType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginType, true), gettype($loginType)), __LINE__);
        }
        if (is_null($loginType) || (is_array($loginType) && empty($loginType))) {
            unset($this->LoginType);
        } else {
            $this->LoginType = $loginType;
        }
        return $this;
    }
    /**
     * Get LogoutUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogoutUrl()
    {
        return isset($this->LogoutUrl) ? $this->LogoutUrl : null;
    }
    /**
     * Set LogoutUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logoutUrl
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setLogoutUrl($logoutUrl = null)
    {
        // validation for constraint: string
        if (!is_null($logoutUrl) && !is_string($logoutUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoutUrl, true), gettype($logoutUrl)), __LINE__);
        }
        if (is_null($logoutUrl) || (is_array($logoutUrl) && empty($logoutUrl))) {
            unset($this->LogoutUrl);
        } else {
            $this->LogoutUrl = $logoutUrl;
        }
        return $this;
    }
    /**
     * Get NumSecondsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumSecondsValid()
    {
        return isset($this->NumSecondsValid) ? $this->NumSecondsValid : null;
    }
    /**
     * Set NumSecondsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numSecondsValid
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setNumSecondsValid($numSecondsValid = null)
    {
        // validation for constraint: int
        if (!is_null($numSecondsValid) && !(is_int($numSecondsValid) || ctype_digit($numSecondsValid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numSecondsValid, true), gettype($numSecondsValid)), __LINE__);
        }
        if (is_null($numSecondsValid) || (is_array($numSecondsValid) && empty($numSecondsValid))) {
            unset($this->NumSecondsValid);
        } else {
            $this->NumSecondsValid = $numSecondsValid;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get SessionPermSetActivations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getSessionPermSetActivations()
    {
        return isset($this->SessionPermSetActivations) ? $this->SessionPermSetActivations : null;
    }
    /**
     * Set SessionPermSetActivations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $sessionPermSetActivations
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setSessionPermSetActivations(\NexusDigital/MiratelForce\StructType\QueryResult $sessionPermSetActivations = null)
    {
        if (is_null($sessionPermSetActivations) || (is_array($sessionPermSetActivations) && empty($sessionPermSetActivations))) {
            unset($this->SessionPermSetActivations);
        } else {
            $this->SessionPermSetActivations = $sessionPermSetActivations;
        }
        return $this;
    }
    /**
     * Get SessionSecurityLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionSecurityLevel()
    {
        return isset($this->SessionSecurityLevel) ? $this->SessionSecurityLevel : null;
    }
    /**
     * Set SessionSecurityLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionSecurityLevel
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setSessionSecurityLevel($sessionSecurityLevel = null)
    {
        // validation for constraint: string
        if (!is_null($sessionSecurityLevel) && !is_string($sessionSecurityLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionSecurityLevel, true), gettype($sessionSecurityLevel)), __LINE__);
        }
        if (is_null($sessionSecurityLevel) || (is_array($sessionSecurityLevel) && empty($sessionSecurityLevel))) {
            unset($this->SessionSecurityLevel);
        } else {
            $this->SessionSecurityLevel = $sessionSecurityLevel;
        }
        return $this;
    }
    /**
     * Get SessionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionType()
    {
        return isset($this->SessionType) ? $this->SessionType : null;
    }
    /**
     * Set SessionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionType
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setSessionType($sessionType = null)
    {
        // validation for constraint: string
        if (!is_null($sessionType) && !is_string($sessionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionType, true), gettype($sessionType)), __LINE__);
        }
        if (is_null($sessionType) || (is_array($sessionType) && empty($sessionType))) {
            unset($this->SessionType);
        } else {
            $this->SessionType = $sessionType;
        }
        return $this;
    }
    /**
     * Get SourceIp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceIp()
    {
        return isset($this->SourceIp) ? $this->SourceIp : null;
    }
    /**
     * Set SourceIp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceIp
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setSourceIp($sourceIp = null)
    {
        // validation for constraint: string
        if (!is_null($sourceIp) && !is_string($sourceIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceIp, true), gettype($sourceIp)), __LINE__);
        }
        if (is_null($sourceIp) || (is_array($sourceIp) && empty($sourceIp))) {
            unset($this->SourceIp);
        } else {
            $this->SourceIp = $sourceIp;
        }
        return $this;
    }
    /**
     * Get UserType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserType()
    {
        return isset($this->UserType) ? $this->UserType : null;
    }
    /**
     * Set UserType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userType
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: string
        if (!is_null($userType) && !is_string($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userType, true), gettype($userType)), __LINE__);
        }
        if (is_null($userType) || (is_array($userType) && empty($userType))) {
            unset($this->UserType);
        } else {
            $this->UserType = $userType;
        }
        return $this;
    }
    /**
     * Get Users value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUsers()
    {
        return isset($this->Users) ? $this->Users : null;
    }
    /**
     * Set Users value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $users
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setUsers(\NexusDigital/MiratelForce\StructType\User $users = null)
    {
        if (is_null($users) || (is_array($users) && empty($users))) {
            unset($this->Users);
        } else {
            $this->Users = $users;
        }
        return $this;
    }
    /**
     * Get UsersId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsersId()
    {
        return isset($this->UsersId) ? $this->UsersId : null;
    }
    /**
     * Set UsersId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usersId
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public function setUsersId($usersId = null)
    {
        // validation for constraint: string
        if (!is_null($usersId) && !is_string($usersId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usersId, true), gettype($usersId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($usersId) && mb_strlen($usersId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($usersId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($usersId) && !preg_match('/[a-zA-Z0-9]{18}/', $usersId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($usersId, true)), __LINE__);
        }
        if (is_null($usersId) || (is_array($usersId) && empty($usersId))) {
            unset($this->UsersId);
        } else {
            $this->UsersId = $usersId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
