<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuraDefinitionBundleInfo StructType
 * @subpackage Structs
 */
class AuraDefinitionBundleInfo extends SObject
{
    /**
     * The ApiVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ApiVersion;
    /**
     * The AuraDefinitionBundleId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuraDefinitionBundleId;
    /**
     * The Bundle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Bundle;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The NamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamespacePrefix;
    /**
     * Constructor method for AuraDefinitionBundleInfo
     * @uses AuraDefinitionBundleInfo::setApiVersion()
     * @uses AuraDefinitionBundleInfo::setAuraDefinitionBundleId()
     * @uses AuraDefinitionBundleInfo::setBundle()
     * @uses AuraDefinitionBundleInfo::setDeveloperName()
     * @uses AuraDefinitionBundleInfo::setDurableId()
     * @uses AuraDefinitionBundleInfo::setNamespacePrefix()
     * @param float $apiVersion
     * @param string $auraDefinitionBundleId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $bundle
     * @param string $developerName
     * @param string $durableId
     * @param string $namespacePrefix
     */
    public function __construct($apiVersion = null, $auraDefinitionBundleId = null, \NexusDigital/MiratelForce\StructType\QueryResult $bundle = null, $developerName = null, $durableId = null, $namespacePrefix = null)
    {
        $this
            ->setApiVersion($apiVersion)
            ->setAuraDefinitionBundleId($auraDefinitionBundleId)
            ->setBundle($bundle)
            ->setDeveloperName($developerName)
            ->setDurableId($durableId)
            ->setNamespacePrefix($namespacePrefix);
    }
    /**
     * Get ApiVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getApiVersion()
    {
        return isset($this->ApiVersion) ? $this->ApiVersion : null;
    }
    /**
     * Set ApiVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $apiVersion
     * @return \NexusDigital/MiratelForce\StructType\AuraDefinitionBundleInfo
     */
    public function setApiVersion($apiVersion = null)
    {
        // validation for constraint: float
        if (!is_null($apiVersion) && !(is_float($apiVersion) || is_numeric($apiVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($apiVersion, true), gettype($apiVersion)), __LINE__);
        }
        if (is_null($apiVersion) || (is_array($apiVersion) && empty($apiVersion))) {
            unset($this->ApiVersion);
        } else {
            $this->ApiVersion = $apiVersion;
        }
        return $this;
    }
    /**
     * Get AuraDefinitionBundleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuraDefinitionBundleId()
    {
        return isset($this->AuraDefinitionBundleId) ? $this->AuraDefinitionBundleId : null;
    }
    /**
     * Set AuraDefinitionBundleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $auraDefinitionBundleId
     * @return \NexusDigital/MiratelForce\StructType\AuraDefinitionBundleInfo
     */
    public function setAuraDefinitionBundleId($auraDefinitionBundleId = null)
    {
        // validation for constraint: string
        if (!is_null($auraDefinitionBundleId) && !is_string($auraDefinitionBundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($auraDefinitionBundleId, true), gettype($auraDefinitionBundleId)), __LINE__);
        }
        if (is_null($auraDefinitionBundleId) || (is_array($auraDefinitionBundleId) && empty($auraDefinitionBundleId))) {
            unset($this->AuraDefinitionBundleId);
        } else {
            $this->AuraDefinitionBundleId = $auraDefinitionBundleId;
        }
        return $this;
    }
    /**
     * Get Bundle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getBundle()
    {
        return isset($this->Bundle) ? $this->Bundle : null;
    }
    /**
     * Set Bundle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $bundle
     * @return \NexusDigital/MiratelForce\StructType\AuraDefinitionBundleInfo
     */
    public function setBundle(\NexusDigital/MiratelForce\StructType\QueryResult $bundle = null)
    {
        if (is_null($bundle) || (is_array($bundle) && empty($bundle))) {
            unset($this->Bundle);
        } else {
            $this->Bundle = $bundle;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\AuraDefinitionBundleInfo
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\AuraDefinitionBundleInfo
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get NamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamespacePrefix()
    {
        return isset($this->NamespacePrefix) ? $this->NamespacePrefix : null;
    }
    /**
     * Set NamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\AuraDefinitionBundleInfo
     */
    public function setNamespacePrefix($namespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namespacePrefix) && !is_string($namespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespacePrefix, true), gettype($namespacePrefix)), __LINE__);
        }
        if (is_null($namespacePrefix) || (is_array($namespacePrefix) && empty($namespacePrefix))) {
            unset($this->NamespacePrefix);
        } else {
            $this->NamespacePrefix = $namespacePrefix;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\AuraDefinitionBundleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
