<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApexTrigger StructType
 * @subpackage Structs
 */
class ApexTrigger extends SObject
{
    /**
     * The ApiVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ApiVersion;
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Body;
    /**
     * The BodyCrc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BodyCrc;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The IsValid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LengthWithoutComments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LengthWithoutComments;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamespacePrefix;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TableEnumOrId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TableEnumOrId;
    /**
     * The UsageAfterDelete
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsageAfterDelete;
    /**
     * The UsageAfterInsert
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsageAfterInsert;
    /**
     * The UsageAfterUndelete
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsageAfterUndelete;
    /**
     * The UsageAfterUpdate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsageAfterUpdate;
    /**
     * The UsageBeforeDelete
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsageBeforeDelete;
    /**
     * The UsageBeforeInsert
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsageBeforeInsert;
    /**
     * The UsageBeforeUpdate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsageBeforeUpdate;
    /**
     * The UsageIsBulk
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UsageIsBulk;
    /**
     * Constructor method for ApexTrigger
     * @uses ApexTrigger::setApiVersion()
     * @uses ApexTrigger::setBody()
     * @uses ApexTrigger::setBodyCrc()
     * @uses ApexTrigger::setCreatedBy()
     * @uses ApexTrigger::setCreatedById()
     * @uses ApexTrigger::setCreatedDate()
     * @uses ApexTrigger::setIsValid()
     * @uses ApexTrigger::setLastModifiedBy()
     * @uses ApexTrigger::setLastModifiedById()
     * @uses ApexTrigger::setLastModifiedDate()
     * @uses ApexTrigger::setLengthWithoutComments()
     * @uses ApexTrigger::setName()
     * @uses ApexTrigger::setNamespacePrefix()
     * @uses ApexTrigger::setStatus()
     * @uses ApexTrigger::setSystemModstamp()
     * @uses ApexTrigger::setTableEnumOrId()
     * @uses ApexTrigger::setUsageAfterDelete()
     * @uses ApexTrigger::setUsageAfterInsert()
     * @uses ApexTrigger::setUsageAfterUndelete()
     * @uses ApexTrigger::setUsageAfterUpdate()
     * @uses ApexTrigger::setUsageBeforeDelete()
     * @uses ApexTrigger::setUsageBeforeInsert()
     * @uses ApexTrigger::setUsageBeforeUpdate()
     * @uses ApexTrigger::setUsageIsBulk()
     * @param float $apiVersion
     * @param string $body
     * @param float $bodyCrc
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param bool $isValid
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param int $lengthWithoutComments
     * @param string $name
     * @param string $namespacePrefix
     * @param string $status
     * @param string $systemModstamp
     * @param string $tableEnumOrId
     * @param bool $usageAfterDelete
     * @param bool $usageAfterInsert
     * @param bool $usageAfterUndelete
     * @param bool $usageAfterUpdate
     * @param bool $usageBeforeDelete
     * @param bool $usageBeforeInsert
     * @param bool $usageBeforeUpdate
     * @param bool $usageIsBulk
     */
    public function __construct($apiVersion = null, $body = null, $bodyCrc = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $isValid = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lengthWithoutComments = null, $name = null, $namespacePrefix = null, $status = null, $systemModstamp = null, $tableEnumOrId = null, $usageAfterDelete = null, $usageAfterInsert = null, $usageAfterUndelete = null, $usageAfterUpdate = null, $usageBeforeDelete = null, $usageBeforeInsert = null, $usageBeforeUpdate = null, $usageIsBulk = null)
    {
        $this
            ->setApiVersion($apiVersion)
            ->setBody($body)
            ->setBodyCrc($bodyCrc)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setIsValid($isValid)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLengthWithoutComments($lengthWithoutComments)
            ->setName($name)
            ->setNamespacePrefix($namespacePrefix)
            ->setStatus($status)
            ->setSystemModstamp($systemModstamp)
            ->setTableEnumOrId($tableEnumOrId)
            ->setUsageAfterDelete($usageAfterDelete)
            ->setUsageAfterInsert($usageAfterInsert)
            ->setUsageAfterUndelete($usageAfterUndelete)
            ->setUsageAfterUpdate($usageAfterUpdate)
            ->setUsageBeforeDelete($usageBeforeDelete)
            ->setUsageBeforeInsert($usageBeforeInsert)
            ->setUsageBeforeUpdate($usageBeforeUpdate)
            ->setUsageIsBulk($usageIsBulk);
    }
    /**
     * Get ApiVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getApiVersion()
    {
        return isset($this->ApiVersion) ? $this->ApiVersion : null;
    }
    /**
     * Set ApiVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $apiVersion
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setApiVersion($apiVersion = null)
    {
        // validation for constraint: float
        if (!is_null($apiVersion) && !(is_float($apiVersion) || is_numeric($apiVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($apiVersion, true), gettype($apiVersion)), __LINE__);
        }
        if (is_null($apiVersion) || (is_array($apiVersion) && empty($apiVersion))) {
            unset($this->ApiVersion);
        } else {
            $this->ApiVersion = $apiVersion;
        }
        return $this;
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $body
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($body, true), gettype($body)), __LINE__);
        }
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get BodyCrc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBodyCrc()
    {
        return isset($this->BodyCrc) ? $this->BodyCrc : null;
    }
    /**
     * Set BodyCrc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $bodyCrc
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setBodyCrc($bodyCrc = null)
    {
        // validation for constraint: float
        if (!is_null($bodyCrc) && !(is_float($bodyCrc) || is_numeric($bodyCrc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bodyCrc, true), gettype($bodyCrc)), __LINE__);
        }
        if (is_null($bodyCrc) || (is_array($bodyCrc) && empty($bodyCrc))) {
            unset($this->BodyCrc);
        } else {
            $this->BodyCrc = $bodyCrc;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LengthWithoutComments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLengthWithoutComments()
    {
        return isset($this->LengthWithoutComments) ? $this->LengthWithoutComments : null;
    }
    /**
     * Set LengthWithoutComments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lengthWithoutComments
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setLengthWithoutComments($lengthWithoutComments = null)
    {
        // validation for constraint: int
        if (!is_null($lengthWithoutComments) && !(is_int($lengthWithoutComments) || ctype_digit($lengthWithoutComments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lengthWithoutComments, true), gettype($lengthWithoutComments)), __LINE__);
        }
        if (is_null($lengthWithoutComments) || (is_array($lengthWithoutComments) && empty($lengthWithoutComments))) {
            unset($this->LengthWithoutComments);
        } else {
            $this->LengthWithoutComments = $lengthWithoutComments;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamespacePrefix()
    {
        return isset($this->NamespacePrefix) ? $this->NamespacePrefix : null;
    }
    /**
     * Set NamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setNamespacePrefix($namespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namespacePrefix) && !is_string($namespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespacePrefix, true), gettype($namespacePrefix)), __LINE__);
        }
        if (is_null($namespacePrefix) || (is_array($namespacePrefix) && empty($namespacePrefix))) {
            unset($this->NamespacePrefix);
        } else {
            $this->NamespacePrefix = $namespacePrefix;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TableEnumOrId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTableEnumOrId()
    {
        return isset($this->TableEnumOrId) ? $this->TableEnumOrId : null;
    }
    /**
     * Set TableEnumOrId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tableEnumOrId
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setTableEnumOrId($tableEnumOrId = null)
    {
        // validation for constraint: string
        if (!is_null($tableEnumOrId) && !is_string($tableEnumOrId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tableEnumOrId, true), gettype($tableEnumOrId)), __LINE__);
        }
        if (is_null($tableEnumOrId) || (is_array($tableEnumOrId) && empty($tableEnumOrId))) {
            unset($this->TableEnumOrId);
        } else {
            $this->TableEnumOrId = $tableEnumOrId;
        }
        return $this;
    }
    /**
     * Get UsageAfterDelete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsageAfterDelete()
    {
        return isset($this->UsageAfterDelete) ? $this->UsageAfterDelete : null;
    }
    /**
     * Set UsageAfterDelete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usageAfterDelete
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setUsageAfterDelete($usageAfterDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($usageAfterDelete) && !is_bool($usageAfterDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usageAfterDelete, true), gettype($usageAfterDelete)), __LINE__);
        }
        if (is_null($usageAfterDelete) || (is_array($usageAfterDelete) && empty($usageAfterDelete))) {
            unset($this->UsageAfterDelete);
        } else {
            $this->UsageAfterDelete = $usageAfterDelete;
        }
        return $this;
    }
    /**
     * Get UsageAfterInsert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsageAfterInsert()
    {
        return isset($this->UsageAfterInsert) ? $this->UsageAfterInsert : null;
    }
    /**
     * Set UsageAfterInsert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usageAfterInsert
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setUsageAfterInsert($usageAfterInsert = null)
    {
        // validation for constraint: boolean
        if (!is_null($usageAfterInsert) && !is_bool($usageAfterInsert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usageAfterInsert, true), gettype($usageAfterInsert)), __LINE__);
        }
        if (is_null($usageAfterInsert) || (is_array($usageAfterInsert) && empty($usageAfterInsert))) {
            unset($this->UsageAfterInsert);
        } else {
            $this->UsageAfterInsert = $usageAfterInsert;
        }
        return $this;
    }
    /**
     * Get UsageAfterUndelete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsageAfterUndelete()
    {
        return isset($this->UsageAfterUndelete) ? $this->UsageAfterUndelete : null;
    }
    /**
     * Set UsageAfterUndelete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usageAfterUndelete
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setUsageAfterUndelete($usageAfterUndelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($usageAfterUndelete) && !is_bool($usageAfterUndelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usageAfterUndelete, true), gettype($usageAfterUndelete)), __LINE__);
        }
        if (is_null($usageAfterUndelete) || (is_array($usageAfterUndelete) && empty($usageAfterUndelete))) {
            unset($this->UsageAfterUndelete);
        } else {
            $this->UsageAfterUndelete = $usageAfterUndelete;
        }
        return $this;
    }
    /**
     * Get UsageAfterUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsageAfterUpdate()
    {
        return isset($this->UsageAfterUpdate) ? $this->UsageAfterUpdate : null;
    }
    /**
     * Set UsageAfterUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usageAfterUpdate
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setUsageAfterUpdate($usageAfterUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($usageAfterUpdate) && !is_bool($usageAfterUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usageAfterUpdate, true), gettype($usageAfterUpdate)), __LINE__);
        }
        if (is_null($usageAfterUpdate) || (is_array($usageAfterUpdate) && empty($usageAfterUpdate))) {
            unset($this->UsageAfterUpdate);
        } else {
            $this->UsageAfterUpdate = $usageAfterUpdate;
        }
        return $this;
    }
    /**
     * Get UsageBeforeDelete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsageBeforeDelete()
    {
        return isset($this->UsageBeforeDelete) ? $this->UsageBeforeDelete : null;
    }
    /**
     * Set UsageBeforeDelete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usageBeforeDelete
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setUsageBeforeDelete($usageBeforeDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($usageBeforeDelete) && !is_bool($usageBeforeDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usageBeforeDelete, true), gettype($usageBeforeDelete)), __LINE__);
        }
        if (is_null($usageBeforeDelete) || (is_array($usageBeforeDelete) && empty($usageBeforeDelete))) {
            unset($this->UsageBeforeDelete);
        } else {
            $this->UsageBeforeDelete = $usageBeforeDelete;
        }
        return $this;
    }
    /**
     * Get UsageBeforeInsert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsageBeforeInsert()
    {
        return isset($this->UsageBeforeInsert) ? $this->UsageBeforeInsert : null;
    }
    /**
     * Set UsageBeforeInsert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usageBeforeInsert
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setUsageBeforeInsert($usageBeforeInsert = null)
    {
        // validation for constraint: boolean
        if (!is_null($usageBeforeInsert) && !is_bool($usageBeforeInsert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usageBeforeInsert, true), gettype($usageBeforeInsert)), __LINE__);
        }
        if (is_null($usageBeforeInsert) || (is_array($usageBeforeInsert) && empty($usageBeforeInsert))) {
            unset($this->UsageBeforeInsert);
        } else {
            $this->UsageBeforeInsert = $usageBeforeInsert;
        }
        return $this;
    }
    /**
     * Get UsageBeforeUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsageBeforeUpdate()
    {
        return isset($this->UsageBeforeUpdate) ? $this->UsageBeforeUpdate : null;
    }
    /**
     * Set UsageBeforeUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usageBeforeUpdate
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setUsageBeforeUpdate($usageBeforeUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($usageBeforeUpdate) && !is_bool($usageBeforeUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usageBeforeUpdate, true), gettype($usageBeforeUpdate)), __LINE__);
        }
        if (is_null($usageBeforeUpdate) || (is_array($usageBeforeUpdate) && empty($usageBeforeUpdate))) {
            unset($this->UsageBeforeUpdate);
        } else {
            $this->UsageBeforeUpdate = $usageBeforeUpdate;
        }
        return $this;
    }
    /**
     * Get UsageIsBulk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUsageIsBulk()
    {
        return isset($this->UsageIsBulk) ? $this->UsageIsBulk : null;
    }
    /**
     * Set UsageIsBulk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $usageIsBulk
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public function setUsageIsBulk($usageIsBulk = null)
    {
        // validation for constraint: boolean
        if (!is_null($usageIsBulk) && !is_bool($usageIsBulk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usageIsBulk, true), gettype($usageIsBulk)), __LINE__);
        }
        if (is_null($usageIsBulk) || (is_array($usageIsBulk) && empty($usageIsBulk))) {
            unset($this->UsageIsBulk);
        } else {
            $this->UsageIsBulk = $usageIsBulk;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ApexTrigger
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
