<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApexTestResultLimits StructType
 * @subpackage Structs
 */
class ApexTestResultLimits extends SObject
{
    /**
     * The ApexTestResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public $ApexTestResult;
    /**
     * The ApexTestResultId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApexTestResultId;
    /**
     * The AsyncCalls
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AsyncCalls;
    /**
     * The Callouts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Callouts;
    /**
     * The Cpu
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Cpu;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Dml
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Dml;
    /**
     * The DmlRows
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DmlRows;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Email;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LimitContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimitContext;
    /**
     * The LimitExceptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LimitExceptions;
    /**
     * The MobilePush
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MobilePush;
    /**
     * The QueryRows
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QueryRows;
    /**
     * The Soql
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Soql;
    /**
     * The Sosl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Sosl;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for ApexTestResultLimits
     * @uses ApexTestResultLimits::setApexTestResult()
     * @uses ApexTestResultLimits::setApexTestResultId()
     * @uses ApexTestResultLimits::setAsyncCalls()
     * @uses ApexTestResultLimits::setCallouts()
     * @uses ApexTestResultLimits::setCpu()
     * @uses ApexTestResultLimits::setCreatedBy()
     * @uses ApexTestResultLimits::setCreatedById()
     * @uses ApexTestResultLimits::setCreatedDate()
     * @uses ApexTestResultLimits::setDml()
     * @uses ApexTestResultLimits::setDmlRows()
     * @uses ApexTestResultLimits::setEmail()
     * @uses ApexTestResultLimits::setIsDeleted()
     * @uses ApexTestResultLimits::setLastModifiedBy()
     * @uses ApexTestResultLimits::setLastModifiedById()
     * @uses ApexTestResultLimits::setLastModifiedDate()
     * @uses ApexTestResultLimits::setLimitContext()
     * @uses ApexTestResultLimits::setLimitExceptions()
     * @uses ApexTestResultLimits::setMobilePush()
     * @uses ApexTestResultLimits::setQueryRows()
     * @uses ApexTestResultLimits::setSoql()
     * @uses ApexTestResultLimits::setSosl()
     * @uses ApexTestResultLimits::setSystemModstamp()
     * @param \NexusDigital/MiratelForce\StructType\ApexTestResult $apexTestResult
     * @param string $apexTestResultId
     * @param int $asyncCalls
     * @param int $callouts
     * @param int $cpu
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param int $dml
     * @param int $dmlRows
     * @param int $email
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $limitContext
     * @param string $limitExceptions
     * @param int $mobilePush
     * @param int $queryRows
     * @param int $soql
     * @param int $sosl
     * @param string $systemModstamp
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\ApexTestResult $apexTestResult = null, $apexTestResultId = null, $asyncCalls = null, $callouts = null, $cpu = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $dml = null, $dmlRows = null, $email = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $limitContext = null, $limitExceptions = null, $mobilePush = null, $queryRows = null, $soql = null, $sosl = null, $systemModstamp = null)
    {
        $this
            ->setApexTestResult($apexTestResult)
            ->setApexTestResultId($apexTestResultId)
            ->setAsyncCalls($asyncCalls)
            ->setCallouts($callouts)
            ->setCpu($cpu)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDml($dml)
            ->setDmlRows($dmlRows)
            ->setEmail($email)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLimitContext($limitContext)
            ->setLimitExceptions($limitExceptions)
            ->setMobilePush($mobilePush)
            ->setQueryRows($queryRows)
            ->setSoql($soql)
            ->setSosl($sosl)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get ApexTestResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult|null
     */
    public function getApexTestResult()
    {
        return isset($this->ApexTestResult) ? $this->ApexTestResult : null;
    }
    /**
     * Set ApexTestResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ApexTestResult $apexTestResult
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setApexTestResult(\NexusDigital/MiratelForce\StructType\ApexTestResult $apexTestResult = null)
    {
        if (is_null($apexTestResult) || (is_array($apexTestResult) && empty($apexTestResult))) {
            unset($this->ApexTestResult);
        } else {
            $this->ApexTestResult = $apexTestResult;
        }
        return $this;
    }
    /**
     * Get ApexTestResultId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApexTestResultId()
    {
        return isset($this->ApexTestResultId) ? $this->ApexTestResultId : null;
    }
    /**
     * Set ApexTestResultId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apexTestResultId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setApexTestResultId($apexTestResultId = null)
    {
        // validation for constraint: string
        if (!is_null($apexTestResultId) && !is_string($apexTestResultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apexTestResultId, true), gettype($apexTestResultId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($apexTestResultId) && mb_strlen($apexTestResultId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($apexTestResultId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($apexTestResultId) && !preg_match('/[a-zA-Z0-9]{18}/', $apexTestResultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($apexTestResultId, true)), __LINE__);
        }
        if (is_null($apexTestResultId) || (is_array($apexTestResultId) && empty($apexTestResultId))) {
            unset($this->ApexTestResultId);
        } else {
            $this->ApexTestResultId = $apexTestResultId;
        }
        return $this;
    }
    /**
     * Get AsyncCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAsyncCalls()
    {
        return isset($this->AsyncCalls) ? $this->AsyncCalls : null;
    }
    /**
     * Set AsyncCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $asyncCalls
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setAsyncCalls($asyncCalls = null)
    {
        // validation for constraint: int
        if (!is_null($asyncCalls) && !(is_int($asyncCalls) || ctype_digit($asyncCalls))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asyncCalls, true), gettype($asyncCalls)), __LINE__);
        }
        if (is_null($asyncCalls) || (is_array($asyncCalls) && empty($asyncCalls))) {
            unset($this->AsyncCalls);
        } else {
            $this->AsyncCalls = $asyncCalls;
        }
        return $this;
    }
    /**
     * Get Callouts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCallouts()
    {
        return isset($this->Callouts) ? $this->Callouts : null;
    }
    /**
     * Set Callouts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $callouts
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setCallouts($callouts = null)
    {
        // validation for constraint: int
        if (!is_null($callouts) && !(is_int($callouts) || ctype_digit($callouts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($callouts, true), gettype($callouts)), __LINE__);
        }
        if (is_null($callouts) || (is_array($callouts) && empty($callouts))) {
            unset($this->Callouts);
        } else {
            $this->Callouts = $callouts;
        }
        return $this;
    }
    /**
     * Get Cpu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCpu()
    {
        return isset($this->Cpu) ? $this->Cpu : null;
    }
    /**
     * Set Cpu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cpu
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setCpu($cpu = null)
    {
        // validation for constraint: int
        if (!is_null($cpu) && !(is_int($cpu) || ctype_digit($cpu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cpu, true), gettype($cpu)), __LINE__);
        }
        if (is_null($cpu) || (is_array($cpu) && empty($cpu))) {
            unset($this->Cpu);
        } else {
            $this->Cpu = $cpu;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Dml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDml()
    {
        return isset($this->Dml) ? $this->Dml : null;
    }
    /**
     * Set Dml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dml
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setDml($dml = null)
    {
        // validation for constraint: int
        if (!is_null($dml) && !(is_int($dml) || ctype_digit($dml))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dml, true), gettype($dml)), __LINE__);
        }
        if (is_null($dml) || (is_array($dml) && empty($dml))) {
            unset($this->Dml);
        } else {
            $this->Dml = $dml;
        }
        return $this;
    }
    /**
     * Get DmlRows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDmlRows()
    {
        return isset($this->DmlRows) ? $this->DmlRows : null;
    }
    /**
     * Set DmlRows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dmlRows
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setDmlRows($dmlRows = null)
    {
        // validation for constraint: int
        if (!is_null($dmlRows) && !(is_int($dmlRows) || ctype_digit($dmlRows))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dmlRows, true), gettype($dmlRows)), __LINE__);
        }
        if (is_null($dmlRows) || (is_array($dmlRows) && empty($dmlRows))) {
            unset($this->DmlRows);
        } else {
            $this->DmlRows = $dmlRows;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $email
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setEmail($email = null)
    {
        // validation for constraint: int
        if (!is_null($email) && !(is_int($email) || ctype_digit($email))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LimitContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimitContext()
    {
        return isset($this->LimitContext) ? $this->LimitContext : null;
    }
    /**
     * Set LimitContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $limitContext
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setLimitContext($limitContext = null)
    {
        // validation for constraint: string
        if (!is_null($limitContext) && !is_string($limitContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limitContext, true), gettype($limitContext)), __LINE__);
        }
        if (is_null($limitContext) || (is_array($limitContext) && empty($limitContext))) {
            unset($this->LimitContext);
        } else {
            $this->LimitContext = $limitContext;
        }
        return $this;
    }
    /**
     * Get LimitExceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLimitExceptions()
    {
        return isset($this->LimitExceptions) ? $this->LimitExceptions : null;
    }
    /**
     * Set LimitExceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $limitExceptions
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setLimitExceptions($limitExceptions = null)
    {
        // validation for constraint: string
        if (!is_null($limitExceptions) && !is_string($limitExceptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limitExceptions, true), gettype($limitExceptions)), __LINE__);
        }
        if (is_null($limitExceptions) || (is_array($limitExceptions) && empty($limitExceptions))) {
            unset($this->LimitExceptions);
        } else {
            $this->LimitExceptions = $limitExceptions;
        }
        return $this;
    }
    /**
     * Get MobilePush value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMobilePush()
    {
        return isset($this->MobilePush) ? $this->MobilePush : null;
    }
    /**
     * Set MobilePush value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mobilePush
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setMobilePush($mobilePush = null)
    {
        // validation for constraint: int
        if (!is_null($mobilePush) && !(is_int($mobilePush) || ctype_digit($mobilePush))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mobilePush, true), gettype($mobilePush)), __LINE__);
        }
        if (is_null($mobilePush) || (is_array($mobilePush) && empty($mobilePush))) {
            unset($this->MobilePush);
        } else {
            $this->MobilePush = $mobilePush;
        }
        return $this;
    }
    /**
     * Get QueryRows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQueryRows()
    {
        return isset($this->QueryRows) ? $this->QueryRows : null;
    }
    /**
     * Set QueryRows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $queryRows
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setQueryRows($queryRows = null)
    {
        // validation for constraint: int
        if (!is_null($queryRows) && !(is_int($queryRows) || ctype_digit($queryRows))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($queryRows, true), gettype($queryRows)), __LINE__);
        }
        if (is_null($queryRows) || (is_array($queryRows) && empty($queryRows))) {
            unset($this->QueryRows);
        } else {
            $this->QueryRows = $queryRows;
        }
        return $this;
    }
    /**
     * Get Soql value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSoql()
    {
        return isset($this->Soql) ? $this->Soql : null;
    }
    /**
     * Set Soql value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $soql
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setSoql($soql = null)
    {
        // validation for constraint: int
        if (!is_null($soql) && !(is_int($soql) || ctype_digit($soql))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soql, true), gettype($soql)), __LINE__);
        }
        if (is_null($soql) || (is_array($soql) && empty($soql))) {
            unset($this->Soql);
        } else {
            $this->Soql = $soql;
        }
        return $this;
    }
    /**
     * Get Sosl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSosl()
    {
        return isset($this->Sosl) ? $this->Sosl : null;
    }
    /**
     * Set Sosl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sosl
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setSosl($sosl = null)
    {
        // validation for constraint: int
        if (!is_null($sosl) && !(is_int($sosl) || ctype_digit($sosl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sosl, true), gettype($sosl)), __LINE__);
        }
        if (is_null($sosl) || (is_array($sosl) && empty($sosl))) {
            unset($this->Sosl);
        } else {
            $this->Sosl = $sosl;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResultLimits
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
