<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApexTestQueueItem StructType
 * @subpackage Structs
 */
class ApexTestQueueItem extends SObject
{
    /**
     * The ApexClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ApexClass
     */
    public $ApexClass;
    /**
     * The ApexClassId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApexClassId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ExtendedStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedStatus;
    /**
     * The ParentJobId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentJobId;
    /**
     * The ShouldSkipCodeCoverage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldSkipCodeCoverage;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TestRunResultId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $TestRunResultId;
    /**
     * Constructor method for ApexTestQueueItem
     * @uses ApexTestQueueItem::setApexClass()
     * @uses ApexTestQueueItem::setApexClassId()
     * @uses ApexTestQueueItem::setCreatedBy()
     * @uses ApexTestQueueItem::setCreatedById()
     * @uses ApexTestQueueItem::setCreatedDate()
     * @uses ApexTestQueueItem::setExtendedStatus()
     * @uses ApexTestQueueItem::setParentJobId()
     * @uses ApexTestQueueItem::setShouldSkipCodeCoverage()
     * @uses ApexTestQueueItem::setStatus()
     * @uses ApexTestQueueItem::setSystemModstamp()
     * @uses ApexTestQueueItem::setTestRunResultId()
     * @param \NexusDigital/MiratelForce\StructType\ApexClass $apexClass
     * @param string $apexClassId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $extendedStatus
     * @param string $parentJobId
     * @param bool $shouldSkipCodeCoverage
     * @param string $status
     * @param string $systemModstamp
     * @param string $testRunResultId
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\ApexClass $apexClass = null, $apexClassId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $extendedStatus = null, $parentJobId = null, $shouldSkipCodeCoverage = null, $status = null, $systemModstamp = null, $testRunResultId = null)
    {
        $this
            ->setApexClass($apexClass)
            ->setApexClassId($apexClassId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setExtendedStatus($extendedStatus)
            ->setParentJobId($parentJobId)
            ->setShouldSkipCodeCoverage($shouldSkipCodeCoverage)
            ->setStatus($status)
            ->setSystemModstamp($systemModstamp)
            ->setTestRunResultId($testRunResultId);
    }
    /**
     * Get ApexClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ApexClass|null
     */
    public function getApexClass()
    {
        return isset($this->ApexClass) ? $this->ApexClass : null;
    }
    /**
     * Set ApexClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ApexClass $apexClass
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setApexClass(\NexusDigital/MiratelForce\StructType\ApexClass $apexClass = null)
    {
        if (is_null($apexClass) || (is_array($apexClass) && empty($apexClass))) {
            unset($this->ApexClass);
        } else {
            $this->ApexClass = $apexClass;
        }
        return $this;
    }
    /**
     * Get ApexClassId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApexClassId()
    {
        return isset($this->ApexClassId) ? $this->ApexClassId : null;
    }
    /**
     * Set ApexClassId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apexClassId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setApexClassId($apexClassId = null)
    {
        // validation for constraint: string
        if (!is_null($apexClassId) && !is_string($apexClassId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apexClassId, true), gettype($apexClassId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($apexClassId) && mb_strlen($apexClassId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($apexClassId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($apexClassId) && !preg_match('/[a-zA-Z0-9]{18}/', $apexClassId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($apexClassId, true)), __LINE__);
        }
        if (is_null($apexClassId) || (is_array($apexClassId) && empty($apexClassId))) {
            unset($this->ApexClassId);
        } else {
            $this->ApexClassId = $apexClassId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ExtendedStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedStatus()
    {
        return isset($this->ExtendedStatus) ? $this->ExtendedStatus : null;
    }
    /**
     * Set ExtendedStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedStatus
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setExtendedStatus($extendedStatus = null)
    {
        // validation for constraint: string
        if (!is_null($extendedStatus) && !is_string($extendedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedStatus, true), gettype($extendedStatus)), __LINE__);
        }
        if (is_null($extendedStatus) || (is_array($extendedStatus) && empty($extendedStatus))) {
            unset($this->ExtendedStatus);
        } else {
            $this->ExtendedStatus = $extendedStatus;
        }
        return $this;
    }
    /**
     * Get ParentJobId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentJobId()
    {
        return isset($this->ParentJobId) ? $this->ParentJobId : null;
    }
    /**
     * Set ParentJobId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentJobId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setParentJobId($parentJobId = null)
    {
        // validation for constraint: string
        if (!is_null($parentJobId) && !is_string($parentJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentJobId, true), gettype($parentJobId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentJobId) && mb_strlen($parentJobId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentJobId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentJobId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentJobId, true)), __LINE__);
        }
        if (is_null($parentJobId) || (is_array($parentJobId) && empty($parentJobId))) {
            unset($this->ParentJobId);
        } else {
            $this->ParentJobId = $parentJobId;
        }
        return $this;
    }
    /**
     * Get ShouldSkipCodeCoverage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldSkipCodeCoverage()
    {
        return isset($this->ShouldSkipCodeCoverage) ? $this->ShouldSkipCodeCoverage : null;
    }
    /**
     * Set ShouldSkipCodeCoverage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldSkipCodeCoverage
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setShouldSkipCodeCoverage($shouldSkipCodeCoverage = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldSkipCodeCoverage) && !is_bool($shouldSkipCodeCoverage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldSkipCodeCoverage, true), gettype($shouldSkipCodeCoverage)), __LINE__);
        }
        if (is_null($shouldSkipCodeCoverage) || (is_array($shouldSkipCodeCoverage) && empty($shouldSkipCodeCoverage))) {
            unset($this->ShouldSkipCodeCoverage);
        } else {
            $this->ShouldSkipCodeCoverage = $shouldSkipCodeCoverage;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TestRunResultId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTestRunResultId()
    {
        return isset($this->TestRunResultId) ? $this->TestRunResultId : null;
    }
    /**
     * Set TestRunResultId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $testRunResultId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public function setTestRunResultId($testRunResultId = null)
    {
        // validation for constraint: string
        if (!is_null($testRunResultId) && !is_string($testRunResultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testRunResultId, true), gettype($testRunResultId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($testRunResultId) && mb_strlen($testRunResultId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($testRunResultId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($testRunResultId) && !preg_match('/[a-zA-Z0-9]{18}/', $testRunResultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($testRunResultId, true)), __LINE__);
        }
        if (is_null($testRunResultId) || (is_array($testRunResultId) && empty($testRunResultId))) {
            unset($this->TestRunResultId);
        } else {
            $this->TestRunResultId = $testRunResultId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
