<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApexPageInfo StructType
 * @subpackage Structs
 */
class ApexPageInfo extends SObject
{
    /**
     * The ApexPageId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApexPageId;
    /**
     * The ApiVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ApiVersion;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The IsAvailableInTouch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableInTouch;
    /**
     * The IsShowHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IsShowHeader;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NameSpacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameSpacePrefix;
    /**
     * Constructor method for ApexPageInfo
     * @uses ApexPageInfo::setApexPageId()
     * @uses ApexPageInfo::setApiVersion()
     * @uses ApexPageInfo::setDescription()
     * @uses ApexPageInfo::setDurableId()
     * @uses ApexPageInfo::setIsAvailableInTouch()
     * @uses ApexPageInfo::setIsShowHeader()
     * @uses ApexPageInfo::setMasterLabel()
     * @uses ApexPageInfo::setName()
     * @uses ApexPageInfo::setNameSpacePrefix()
     * @param string $apexPageId
     * @param float $apiVersion
     * @param string $description
     * @param string $durableId
     * @param bool $isAvailableInTouch
     * @param string $isShowHeader
     * @param string $masterLabel
     * @param string $name
     * @param string $nameSpacePrefix
     */
    public function __construct($apexPageId = null, $apiVersion = null, $description = null, $durableId = null, $isAvailableInTouch = null, $isShowHeader = null, $masterLabel = null, $name = null, $nameSpacePrefix = null)
    {
        $this
            ->setApexPageId($apexPageId)
            ->setApiVersion($apiVersion)
            ->setDescription($description)
            ->setDurableId($durableId)
            ->setIsAvailableInTouch($isAvailableInTouch)
            ->setIsShowHeader($isShowHeader)
            ->setMasterLabel($masterLabel)
            ->setName($name)
            ->setNameSpacePrefix($nameSpacePrefix);
    }
    /**
     * Get ApexPageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApexPageId()
    {
        return isset($this->ApexPageId) ? $this->ApexPageId : null;
    }
    /**
     * Set ApexPageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apexPageId
     * @return \NexusDigital/MiratelForce\StructType\ApexPageInfo
     */
    public function setApexPageId($apexPageId = null)
    {
        // validation for constraint: string
        if (!is_null($apexPageId) && !is_string($apexPageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apexPageId, true), gettype($apexPageId)), __LINE__);
        }
        if (is_null($apexPageId) || (is_array($apexPageId) && empty($apexPageId))) {
            unset($this->ApexPageId);
        } else {
            $this->ApexPageId = $apexPageId;
        }
        return $this;
    }
    /**
     * Get ApiVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getApiVersion()
    {
        return isset($this->ApiVersion) ? $this->ApiVersion : null;
    }
    /**
     * Set ApiVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $apiVersion
     * @return \NexusDigital/MiratelForce\StructType\ApexPageInfo
     */
    public function setApiVersion($apiVersion = null)
    {
        // validation for constraint: float
        if (!is_null($apiVersion) && !(is_float($apiVersion) || is_numeric($apiVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($apiVersion, true), gettype($apiVersion)), __LINE__);
        }
        if (is_null($apiVersion) || (is_array($apiVersion) && empty($apiVersion))) {
            unset($this->ApiVersion);
        } else {
            $this->ApiVersion = $apiVersion;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\ApexPageInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\ApexPageInfo
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get IsAvailableInTouch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableInTouch()
    {
        return isset($this->IsAvailableInTouch) ? $this->IsAvailableInTouch : null;
    }
    /**
     * Set IsAvailableInTouch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableInTouch
     * @return \NexusDigital/MiratelForce\StructType\ApexPageInfo
     */
    public function setIsAvailableInTouch($isAvailableInTouch = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableInTouch) && !is_bool($isAvailableInTouch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableInTouch, true), gettype($isAvailableInTouch)), __LINE__);
        }
        if (is_null($isAvailableInTouch) || (is_array($isAvailableInTouch) && empty($isAvailableInTouch))) {
            unset($this->IsAvailableInTouch);
        } else {
            $this->IsAvailableInTouch = $isAvailableInTouch;
        }
        return $this;
    }
    /**
     * Get IsShowHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsShowHeader()
    {
        return isset($this->IsShowHeader) ? $this->IsShowHeader : null;
    }
    /**
     * Set IsShowHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isShowHeader
     * @return \NexusDigital/MiratelForce\StructType\ApexPageInfo
     */
    public function setIsShowHeader($isShowHeader = null)
    {
        // validation for constraint: string
        if (!is_null($isShowHeader) && !is_string($isShowHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isShowHeader, true), gettype($isShowHeader)), __LINE__);
        }
        if (is_null($isShowHeader) || (is_array($isShowHeader) && empty($isShowHeader))) {
            unset($this->IsShowHeader);
        } else {
            $this->IsShowHeader = $isShowHeader;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\ApexPageInfo
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\ApexPageInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NameSpacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameSpacePrefix()
    {
        return isset($this->NameSpacePrefix) ? $this->NameSpacePrefix : null;
    }
    /**
     * Set NameSpacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameSpacePrefix
     * @return \NexusDigital/MiratelForce\StructType\ApexPageInfo
     */
    public function setNameSpacePrefix($nameSpacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($nameSpacePrefix) && !is_string($nameSpacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameSpacePrefix, true), gettype($nameSpacePrefix)), __LINE__);
        }
        if (is_null($nameSpacePrefix) || (is_array($nameSpacePrefix) && empty($nameSpacePrefix))) {
            unset($this->NameSpacePrefix);
        } else {
            $this->NameSpacePrefix = $nameSpacePrefix;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ApexPageInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
