<?php

namespace NexusDigital/MiratelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Describe ServiceType
 * @subpackage Services
 */
class Describe extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the PackageVersionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\PackageVersionHeader $packageVersionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPackageVersionHeader(\NexusDigital/MiratelForce\StructType\PackageVersionHeader $packageVersionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'PackageVersionHeader', $packageVersionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the LocaleOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\LocaleOptions $localeOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLocaleOptions(\NexusDigital/MiratelForce\StructType\LocaleOptions $localeOptions, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'LocaleOptions', $localeOptions, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named describeSObject
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Describe an sObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeSObject $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeSObjectResponse|bool
     */
    public function describeSObject(\NexusDigital/MiratelForce\StructType\DescribeSObject $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeSObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSObjects
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Describe multiple sObjects (upto 100)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeSObjects $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeSObjectsResponse|bool
     */
    public function describeSObjects(\NexusDigital/MiratelForce\StructType\DescribeSObjects $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeSObjects($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeGlobal
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the Global state
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeGlobal $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeGlobalResponse|bool
     */
    public function describeGlobal(\NexusDigital/MiratelForce\StructType\DescribeGlobal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeGlobal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeDataCategoryGroups
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Describe all the data category groups available for a given set of types
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeDataCategoryGroups $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeDataCategoryGroupsResponse|bool
     */
    public function describeDataCategoryGroups(\NexusDigital/MiratelForce\StructType\DescribeDataCategoryGroups $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeDataCategoryGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * describeDataCategoryGroupStructures
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the data category group structures for a given set of pair of types and data category group name
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeDataCategoryGroupStructures $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeDataCategoryGroupStructuresResponse|bool
     */
    public function describeDataCategoryGroupStructures(\NexusDigital/MiratelForce\StructType\DescribeDataCategoryGroupStructures $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeDataCategoryGroupStructures($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeDataCategoryMappings
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Describe your Data Category Mappings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeDataCategoryMappings $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeDataCategoryMappingsResponse|bool
     */
    public function describeDataCategoryMappings(\NexusDigital/MiratelForce\StructType\DescribeDataCategoryMappings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeDataCategoryMappings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeKnowledgeSettings
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Describes your Knowledge settings, such as if knowledgeEnabled is on or off, its default language and supported languages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeKnowledgeSettings $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeKnowledgeSettingsResponse|bool
     */
    public function describeKnowledgeSettings(\NexusDigital/MiratelForce\StructType\DescribeKnowledgeSettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeKnowledgeSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeAppMenu
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the items in an AppMenu
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeAppMenu $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeAppMenuResponse|bool
     */
    public function describeAppMenu(\NexusDigital/MiratelForce\StructType\DescribeAppMenu $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeAppMenu($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeGlobalTheme
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe Gloal and Themes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeGlobalTheme_1 $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeGlobalThemeResponse|bool
     */
    public function describeGlobalTheme(\NexusDigital/MiratelForce\StructType\DescribeGlobalTheme_1 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeGlobalTheme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeTheme
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe Themes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeTheme $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeThemeResponse|bool
     */
    public function describeTheme(\NexusDigital/MiratelForce\StructType\DescribeTheme $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeTheme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeLayout
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the layout of the given sObject or the given actionable global page.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeLayout_1 $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeLayoutResponse|bool
     */
    public function describeLayout(\NexusDigital/MiratelForce\StructType\DescribeLayout_1 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeLayout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSoftphoneLayout
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the layout of the SoftPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeSoftphoneLayout $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeSoftphoneLayoutResponse|bool
     */
    public function describeSoftphoneLayout(\NexusDigital/MiratelForce\StructType\DescribeSoftphoneLayout $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeSoftphoneLayout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSearchLayouts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the search view of an sObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeSearchLayouts $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeSearchLayoutsResponse|bool
     */
    public function describeSearchLayouts(\NexusDigital/MiratelForce\StructType\DescribeSearchLayouts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeSearchLayouts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSearchableEntities
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe a list of entity names that reflects the current user's searchable entities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeSearchableEntities $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeSearchableEntitiesResponse|bool
     */
    public function describeSearchableEntities(\NexusDigital/MiratelForce\StructType\DescribeSearchableEntities $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeSearchableEntities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSearchScopeOrder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe a list of objects representing the order and scope of objects on a users search result page
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeSearchScopeOrder $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeSearchScopeOrderResponse|bool
     */
    public function describeSearchScopeOrder(\NexusDigital/MiratelForce\StructType\DescribeSearchScopeOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeSearchScopeOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeCompactLayouts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the compact layouts of the given sObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeCompactLayouts $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeCompactLayoutsResponse|bool
     */
    public function describeCompactLayouts(\NexusDigital/MiratelForce\StructType\DescribeCompactLayouts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeCompactLayouts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describePathAssistants
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the Path Assistants for the given sObject and optionally RecordTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribePathAssistants $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribePathAssistantsResponse|bool
     */
    public function describePathAssistants(\NexusDigital/MiratelForce\StructType\DescribePathAssistants $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describePathAssistants($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeApprovalLayout
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the approval layouts of the given sObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeApprovalLayout_1 $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeApprovalLayoutResponse|bool
     */
    public function describeApprovalLayout(\NexusDigital/MiratelForce\StructType\DescribeApprovalLayout_1 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeApprovalLayout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSoqlListViews
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the ListViews as SOQL metadata for the generation of SOQL.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeSoqlListViews $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeSoqlListViewsResponse|bool
     */
    public function describeSoqlListViews(\NexusDigital/MiratelForce\StructType\DescribeSoqlListViews $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeSoqlListViews($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeSObjectListViews
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the ListViews of a SObject as SOQL metadata for the generation of SOQL.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeSObjectListViews $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeSObjectListViewsResponse|bool
     */
    public function describeSObjectListViews(\NexusDigital/MiratelForce\StructType\DescribeSObjectListViews $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeSObjectListViews($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeTabs
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the tabs that appear on a users page
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeTabs $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeTabsResponse|bool
     */
    public function describeTabs(\NexusDigital/MiratelForce\StructType\DescribeTabs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeTabs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeAllTabs
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe all tabs available to a user
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeAllTabs $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeAllTabsResponse|bool
     */
    public function describeAllTabs(\NexusDigital/MiratelForce\StructType\DescribeAllTabs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeAllTabs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describePrimaryCompactLayouts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe the primary compact layouts for the sObjects requested
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribePrimaryCompactLayouts $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribePrimaryCompactLayoutsResponse|bool
     */
    public function describePrimaryCompactLayouts(\NexusDigital/MiratelForce\StructType\DescribePrimaryCompactLayouts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describePrimaryCompactLayouts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeQuickActions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the details of a series of quick actions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeQuickActions $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeQuickActionsResponse|bool
     */
    public function describeQuickActions(\NexusDigital/MiratelForce\StructType\DescribeQuickActions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeQuickActions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeQuickActionsForRecordType
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the details of a series of quick actions in context of requested recordType id for Update actions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeQuickActionsForRecordType $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeQuickActionsForRecordTypeResponse|bool
     */
    public function describeQuickActionsForRecordType(\NexusDigital/MiratelForce\StructType\DescribeQuickActionsForRecordType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeQuickActionsForRecordType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeAvailableQuickActions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Describe the details of a series of quick actions available for the given contextType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeAvailableQuickActions $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeAvailableQuickActionsResponse|bool
     */
    public function describeAvailableQuickActions(\NexusDigital/MiratelForce\StructType\DescribeAvailableQuickActions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeAvailableQuickActions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeVisualForce
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required
     * - documentation: Describe visualforce for an org
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeVisualForce $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeVisualForceResponse|bool
     */
    public function describeVisualForce(\NexusDigital/MiratelForce\StructType\DescribeVisualForce $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeVisualForce($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named describeNouns
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Return the renameable nouns from the server for use in presentation using the salesforce grammar engine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\DescribeNouns $parameters
     * @return \NexusDigital/MiratelForce\StructType\DescribeNounsResponse|bool
     */
    public function describeNouns(\NexusDigital/MiratelForce\StructType\DescribeNouns $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->describeNouns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NexusDigital/MiratelForce\StructType\DescribeAllTabsResponse|\NexusDigital/MiratelForce\StructType\DescribeAppMenuResponse|\NexusDigital/MiratelForce\StructType\DescribeApprovalLayoutResponse|\NexusDigital/MiratelForce\StructType\DescribeAvailableQuickActionsResponse|\NexusDigital/MiratelForce\StructType\DescribeCompactLayoutsResponse|\NexusDigital/MiratelForce\StructType\DescribeDataCategoryGroupsResponse|\NexusDigital/MiratelForce\StructType\DescribeDataCategoryGroupStructuresResponse|\NexusDigital/MiratelForce\StructType\DescribeDataCategoryMappingsResponse|\NexusDigital/MiratelForce\StructType\DescribeGlobalResponse|\NexusDigital/MiratelForce\StructType\DescribeGlobalThemeResponse|\NexusDigital/MiratelForce\StructType\DescribeKnowledgeSettingsResponse|\NexusDigital/MiratelForce\StructType\DescribeLayoutResponse|\NexusDigital/MiratelForce\StructType\DescribeNounsResponse|\NexusDigital/MiratelForce\StructType\DescribePathAssistantsResponse|\NexusDigital/MiratelForce\StructType\DescribePrimaryCompactLayoutsResponse|\NexusDigital/MiratelForce\StructType\DescribeQuickActionsForRecordTypeResponse|\NexusDigital/MiratelForce\StructType\DescribeQuickActionsResponse|\NexusDigital/MiratelForce\StructType\DescribeSearchableEntitiesResponse|\NexusDigital/MiratelForce\StructType\DescribeSearchLayoutsResponse|\NexusDigital/MiratelForce\StructType\DescribeSearchScopeOrderResponse|\NexusDigital/MiratelForce\StructType\DescribeSObjectListViewsResponse|\NexusDigital/MiratelForce\StructType\DescribeSObjectResponse|\NexusDigital/MiratelForce\StructType\DescribeSObjectsResponse|\NexusDigital/MiratelForce\StructType\DescribeSoftphoneLayoutResponse|\NexusDigital/MiratelForce\StructType\DescribeSoqlListViewsResponse|\NexusDigital/MiratelForce\StructType\DescribeTabsResponse|\NexusDigital/MiratelForce\StructType\DescribeThemeResponse|\NexusDigital/MiratelForce\StructType\DescribeVisualForceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
