<?php

namespace NexusDigital/MiratelForce;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'sObject' => '\\NexusDigital/MiratelForce\\StructType\\SObject',
            'AggregateResult' => '\\NexusDigital/MiratelForce\\StructType\\AggregateResult',
            'AcceptedEventRelation' => '\\NexusDigital/MiratelForce\\StructType\\AcceptedEventRelation',
            'Account' => '\\NexusDigital/MiratelForce\\StructType\\Account',
            'AccountBrand' => '\\NexusDigital/MiratelForce\\StructType\\AccountBrand',
            'AccountBrandShare' => '\\NexusDigital/MiratelForce\\StructType\\AccountBrandShare',
            'AccountContactRole' => '\\NexusDigital/MiratelForce\\StructType\\AccountContactRole',
            'AccountFeed' => '\\NexusDigital/MiratelForce\\StructType\\AccountFeed',
            'AccountHistory' => '\\NexusDigital/MiratelForce\\StructType\\AccountHistory',
            'AccountPartner' => '\\NexusDigital/MiratelForce\\StructType\\AccountPartner',
            'AccountShare' => '\\NexusDigital/MiratelForce\\StructType\\AccountShare',
            'ActionLinkGroupTemplate' => '\\NexusDigital/MiratelForce\\StructType\\ActionLinkGroupTemplate',
            'ActionLinkTemplate' => '\\NexusDigital/MiratelForce\\StructType\\ActionLinkTemplate',
            'ActivityHistory' => '\\NexusDigital/MiratelForce\\StructType\\ActivityHistory',
            'AdditionalNumber' => '\\NexusDigital/MiratelForce\\StructType\\AdditionalNumber',
            'AgentWork' => '\\NexusDigital/MiratelForce\\StructType\\AgentWork',
            'AgentWorkShare' => '\\NexusDigital/MiratelForce\\StructType\\AgentWorkShare',
            'Agent_App__Feed' => '\\NexusDigital/MiratelForce\\StructType\\Agent_App__Feed',
            'Agent_App__Share' => '\\NexusDigital/MiratelForce\\StructType\\Agent_App__Share',
            'Agent_App__c' => '\\NexusDigital/MiratelForce\\StructType\\Agent_App__c',
            'Announcement' => '\\NexusDigital/MiratelForce\\StructType\\Announcement',
            'ApexClass' => '\\NexusDigital/MiratelForce\\StructType\\ApexClass',
            'ApexComponent' => '\\NexusDigital/MiratelForce\\StructType\\ApexComponent',
            'ApexEmailNotification' => '\\NexusDigital/MiratelForce\\StructType\\ApexEmailNotification',
            'ApexLog' => '\\NexusDigital/MiratelForce\\StructType\\ApexLog',
            'ApexPage' => '\\NexusDigital/MiratelForce\\StructType\\ApexPage',
            'ApexPageInfo' => '\\NexusDigital/MiratelForce\\StructType\\ApexPageInfo',
            'ApexTestQueueItem' => '\\NexusDigital/MiratelForce\\StructType\\ApexTestQueueItem',
            'ApexTestResult' => '\\NexusDigital/MiratelForce\\StructType\\ApexTestResult',
            'ApexTestResultLimits' => '\\NexusDigital/MiratelForce\\StructType\\ApexTestResultLimits',
            'ApexTestRunResult' => '\\NexusDigital/MiratelForce\\StructType\\ApexTestRunResult',
            'ApexTestSuite' => '\\NexusDigital/MiratelForce\\StructType\\ApexTestSuite',
            'ApexTrigger' => '\\NexusDigital/MiratelForce\\StructType\\ApexTrigger',
            'AppAnalyticsQueryRequest' => '\\NexusDigital/MiratelForce\\StructType\\AppAnalyticsQueryRequest',
            'AppDefinition' => '\\NexusDigital/MiratelForce\\StructType\\AppDefinition',
            'AppMenuItem' => '\\NexusDigital/MiratelForce\\StructType\\AppMenuItem',
            'AppTabMember' => '\\NexusDigital/MiratelForce\\StructType\\AppTabMember',
            'Approval' => '\\NexusDigital/MiratelForce\\StructType\\Approval',
            'Asset' => '\\NexusDigital/MiratelForce\\StructType\\Asset',
            'AssetFeed' => '\\NexusDigital/MiratelForce\\StructType\\AssetFeed',
            'AssetHistory' => '\\NexusDigital/MiratelForce\\StructType\\AssetHistory',
            'AssetRelationship' => '\\NexusDigital/MiratelForce\\StructType\\AssetRelationship',
            'AssetRelationshipFeed' => '\\NexusDigital/MiratelForce\\StructType\\AssetRelationshipFeed',
            'AssetRelationshipHistory' => '\\NexusDigital/MiratelForce\\StructType\\AssetRelationshipHistory',
            'AssetShare' => '\\NexusDigital/MiratelForce\\StructType\\AssetShare',
            'AssetTokenEvent' => '\\NexusDigital/MiratelForce\\StructType\\AssetTokenEvent',
            'AssignmentRule' => '\\NexusDigital/MiratelForce\\StructType\\AssignmentRule',
            'AsyncApexJob' => '\\NexusDigital/MiratelForce\\StructType\\AsyncApexJob',
            'AsyncOperationEvent' => '\\NexusDigital/MiratelForce\\StructType\\AsyncOperationEvent',
            'AsyncOperationStatus' => '\\NexusDigital/MiratelForce\\StructType\\AsyncOperationStatus',
            'AttachedContentDocument' => '\\NexusDigital/MiratelForce\\StructType\\AttachedContentDocument',
            'AttachedContentNote' => '\\NexusDigital/MiratelForce\\StructType\\AttachedContentNote',
            'Attachment' => '\\NexusDigital/MiratelForce\\StructType\\Attachment',
            'Audience' => '\\NexusDigital/MiratelForce\\StructType\\Audience',
            'AuraDefinition' => '\\NexusDigital/MiratelForce\\StructType\\AuraDefinition',
            'AuraDefinitionBundle' => '\\NexusDigital/MiratelForce\\StructType\\AuraDefinitionBundle',
            'AuraDefinitionBundleInfo' => '\\NexusDigital/MiratelForce\\StructType\\AuraDefinitionBundleInfo',
            'AuraDefinitionInfo' => '\\NexusDigital/MiratelForce\\StructType\\AuraDefinitionInfo',
            'AuthConfig' => '\\NexusDigital/MiratelForce\\StructType\\AuthConfig',
            'AuthConfigProviders' => '\\NexusDigital/MiratelForce\\StructType\\AuthConfigProviders',
            'AuthProvider' => '\\NexusDigital/MiratelForce\\StructType\\AuthProvider',
            'AuthSession' => '\\NexusDigital/MiratelForce\\StructType\\AuthSession',
            'AuthorizationForm' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationForm',
            'AuthorizationFormConsent' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationFormConsent',
            'AuthorizationFormConsentHistory' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationFormConsentHistory',
            'AuthorizationFormConsentShare' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationFormConsentShare',
            'AuthorizationFormDataUse' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationFormDataUse',
            'AuthorizationFormDataUseHistory' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationFormDataUseHistory',
            'AuthorizationFormDataUseShare' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationFormDataUseShare',
            'AuthorizationFormHistory' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationFormHistory',
            'AuthorizationFormShare' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationFormShare',
            'AuthorizationFormText' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationFormText',
            'AuthorizationFormTextHistory' => '\\NexusDigital/MiratelForce\\StructType\\AuthorizationFormTextHistory',
            'BackgroundOperation' => '\\NexusDigital/MiratelForce\\StructType\\BackgroundOperation',
            'BatchApexErrorEvent' => '\\NexusDigital/MiratelForce\\StructType\\BatchApexErrorEvent',
            'BrandTemplate' => '\\NexusDigital/MiratelForce\\StructType\\BrandTemplate',
            'BrandingSet' => '\\NexusDigital/MiratelForce\\StructType\\BrandingSet',
            'BrandingSetProperty' => '\\NexusDigital/MiratelForce\\StructType\\BrandingSetProperty',
            'BusinessHours' => '\\NexusDigital/MiratelForce\\StructType\\BusinessHours',
            'BusinessProcess' => '\\NexusDigital/MiratelForce\\StructType\\BusinessProcess',
            'Calendar' => '\\NexusDigital/MiratelForce\\StructType\\Calendar',
            'CallCenter' => '\\NexusDigital/MiratelForce\\StructType\\CallCenter',
            'CallManager__mdt' => '\\NexusDigital/MiratelForce\\StructType\\CallManager__mdt',
            'Campaign' => '\\NexusDigital/MiratelForce\\StructType\\Campaign',
            'CampaignFeed' => '\\NexusDigital/MiratelForce\\StructType\\CampaignFeed',
            'CampaignHistory' => '\\NexusDigital/MiratelForce\\StructType\\CampaignHistory',
            'CampaignMember' => '\\NexusDigital/MiratelForce\\StructType\\CampaignMember',
            'CampaignMemberStatus' => '\\NexusDigital/MiratelForce\\StructType\\CampaignMemberStatus',
            'CampaignShare' => '\\NexusDigital/MiratelForce\\StructType\\CampaignShare',
            'Campaign_Agent__History' => '\\NexusDigital/MiratelForce\\StructType\\Campaign_Agent__History',
            'Campaign_Agent__c' => '\\NexusDigital/MiratelForce\\StructType\\Campaign_Agent__c',
            'Campaign_Member__Feed' => '\\NexusDigital/MiratelForce\\StructType\\Campaign_Member__Feed',
            'Campaign_Member__History' => '\\NexusDigital/MiratelForce\\StructType\\Campaign_Member__History',
            'Campaign_Member__c' => '\\NexusDigital/MiratelForce\\StructType\\Campaign_Member__c',
            'Campaign_Restriction__mdt' => '\\NexusDigital/MiratelForce\\StructType\\Campaign_Restriction__mdt',
            'Campaign__Feed' => '\\NexusDigital/MiratelForce\\StructType\\Campaign__Feed',
            'Campaign__History' => '\\NexusDigital/MiratelForce\\StructType\\Campaign__History',
            'Campaign__Share' => '\\NexusDigital/MiratelForce\\StructType\\Campaign__Share',
            'Campaign__c' => '\\NexusDigital/MiratelForce\\StructType\\Campaign__c',
            'Case' => '\\NexusDigital/MiratelForce\\StructType\\_Case',
            'CaseArticle' => '\\NexusDigital/MiratelForce\\StructType\\CaseArticle',
            'CaseComment' => '\\NexusDigital/MiratelForce\\StructType\\CaseComment',
            'CaseContactRole' => '\\NexusDigital/MiratelForce\\StructType\\CaseContactRole',
            'CaseExternalDocument' => '\\NexusDigital/MiratelForce\\StructType\\CaseExternalDocument',
            'CaseFeed' => '\\NexusDigital/MiratelForce\\StructType\\CaseFeed',
            'CaseHistory' => '\\NexusDigital/MiratelForce\\StructType\\CaseHistory',
            'CaseShare' => '\\NexusDigital/MiratelForce\\StructType\\CaseShare',
            'CaseSolution' => '\\NexusDigital/MiratelForce\\StructType\\CaseSolution',
            'CaseStatus' => '\\NexusDigital/MiratelForce\\StructType\\CaseStatus',
            'CaseSubjectParticle' => '\\NexusDigital/MiratelForce\\StructType\\CaseSubjectParticle',
            'CaseTeamMember' => '\\NexusDigital/MiratelForce\\StructType\\CaseTeamMember',
            'CaseTeamRole' => '\\NexusDigital/MiratelForce\\StructType\\CaseTeamRole',
            'CaseTeamTemplate' => '\\NexusDigital/MiratelForce\\StructType\\CaseTeamTemplate',
            'CaseTeamTemplateMember' => '\\NexusDigital/MiratelForce\\StructType\\CaseTeamTemplateMember',
            'CaseTeamTemplateRecord' => '\\NexusDigital/MiratelForce\\StructType\\CaseTeamTemplateRecord',
            'CategoryData' => '\\NexusDigital/MiratelForce\\StructType\\CategoryData',
            'CategoryNode' => '\\NexusDigital/MiratelForce\\StructType\\CategoryNode',
            'ChatterActivity' => '\\NexusDigital/MiratelForce\\StructType\\ChatterActivity',
            'ChatterExtension' => '\\NexusDigital/MiratelForce\\StructType\\ChatterExtension',
            'ChatterExtensionConfig' => '\\NexusDigital/MiratelForce\\StructType\\ChatterExtensionConfig',
            'ClientBrowser' => '\\NexusDigital/MiratelForce\\StructType\\ClientBrowser',
            'Client__mdt' => '\\NexusDigital/MiratelForce\\StructType\\Client__mdt',
            'CollaborationGroup' => '\\NexusDigital/MiratelForce\\StructType\\CollaborationGroup',
            'CollaborationGroupFeed' => '\\NexusDigital/MiratelForce\\StructType\\CollaborationGroupFeed',
            'CollaborationGroupMember' => '\\NexusDigital/MiratelForce\\StructType\\CollaborationGroupMember',
            'CollaborationGroupMemberRequest' => '\\NexusDigital/MiratelForce\\StructType\\CollaborationGroupMemberRequest',
            'CollaborationGroupRecord' => '\\NexusDigital/MiratelForce\\StructType\\CollaborationGroupRecord',
            'CollaborationInvitation' => '\\NexusDigital/MiratelForce\\StructType\\CollaborationInvitation',
            'ColorDefinition' => '\\NexusDigital/MiratelForce\\StructType\\ColorDefinition',
            'CombinedAttachment' => '\\NexusDigital/MiratelForce\\StructType\\CombinedAttachment',
            'Community' => '\\NexusDigital/MiratelForce\\StructType\\Community',
            'ConnectedApplication' => '\\NexusDigital/MiratelForce\\StructType\\ConnectedApplication',
            'Contact' => '\\NexusDigital/MiratelForce\\StructType\\Contact',
            'ContactFeed' => '\\NexusDigital/MiratelForce\\StructType\\ContactFeed',
            'ContactHistory' => '\\NexusDigital/MiratelForce\\StructType\\ContactHistory',
            'ContactPointTypeConsent' => '\\NexusDigital/MiratelForce\\StructType\\ContactPointTypeConsent',
            'ContactPointTypeConsentHistory' => '\\NexusDigital/MiratelForce\\StructType\\ContactPointTypeConsentHistory',
            'ContactRequest' => '\\NexusDigital/MiratelForce\\StructType\\ContactRequest',
            'ContactRequestShare' => '\\NexusDigital/MiratelForce\\StructType\\ContactRequestShare',
            'ContactShare' => '\\NexusDigital/MiratelForce\\StructType\\ContactShare',
            'ContentAsset' => '\\NexusDigital/MiratelForce\\StructType\\ContentAsset',
            'ContentDistribution' => '\\NexusDigital/MiratelForce\\StructType\\ContentDistribution',
            'ContentDistributionView' => '\\NexusDigital/MiratelForce\\StructType\\ContentDistributionView',
            'ContentDocument' => '\\NexusDigital/MiratelForce\\StructType\\ContentDocument',
            'ContentDocumentFeed' => '\\NexusDigital/MiratelForce\\StructType\\ContentDocumentFeed',
            'ContentDocumentHistory' => '\\NexusDigital/MiratelForce\\StructType\\ContentDocumentHistory',
            'ContentDocumentLink' => '\\NexusDigital/MiratelForce\\StructType\\ContentDocumentLink',
            'ContentDocumentSubscription' => '\\NexusDigital/MiratelForce\\StructType\\ContentDocumentSubscription',
            'ContentFolder' => '\\NexusDigital/MiratelForce\\StructType\\ContentFolder',
            'ContentFolderItem' => '\\NexusDigital/MiratelForce\\StructType\\ContentFolderItem',
            'ContentFolderMember' => '\\NexusDigital/MiratelForce\\StructType\\ContentFolderMember',
            'ContentHubItem' => '\\NexusDigital/MiratelForce\\StructType\\ContentHubItem',
            'ContentHubRepository' => '\\NexusDigital/MiratelForce\\StructType\\ContentHubRepository',
            'ContentNote' => '\\NexusDigital/MiratelForce\\StructType\\ContentNote',
            'ContentNotification' => '\\NexusDigital/MiratelForce\\StructType\\ContentNotification',
            'ContentTagSubscription' => '\\NexusDigital/MiratelForce\\StructType\\ContentTagSubscription',
            'ContentUserSubscription' => '\\NexusDigital/MiratelForce\\StructType\\ContentUserSubscription',
            'ContentVersion' => '\\NexusDigital/MiratelForce\\StructType\\ContentVersion',
            'ContentVersionComment' => '\\NexusDigital/MiratelForce\\StructType\\ContentVersionComment',
            'ContentVersionHistory' => '\\NexusDigital/MiratelForce\\StructType\\ContentVersionHistory',
            'ContentVersionRating' => '\\NexusDigital/MiratelForce\\StructType\\ContentVersionRating',
            'ContentWorkspaceSubscription' => '\\NexusDigital/MiratelForce\\StructType\\ContentWorkspaceSubscription',
            'Contract' => '\\NexusDigital/MiratelForce\\StructType\\Contract',
            'ContractContactRole' => '\\NexusDigital/MiratelForce\\StructType\\ContractContactRole',
            'ContractFeed' => '\\NexusDigital/MiratelForce\\StructType\\ContractFeed',
            'ContractHistory' => '\\NexusDigital/MiratelForce\\StructType\\ContractHistory',
            'ContractStatus' => '\\NexusDigital/MiratelForce\\StructType\\ContractStatus',
            'CorsWhitelistEntry' => '\\NexusDigital/MiratelForce\\StructType\\CorsWhitelistEntry',
            'Cost_Calculation__mdt' => '\\NexusDigital/MiratelForce\\StructType\\Cost_Calculation__mdt',
            'CountryMapping__mdt' => '\\NexusDigital/MiratelForce\\StructType\\CountryMapping__mdt',
            'CronJobDetail' => '\\NexusDigital/MiratelForce\\StructType\\CronJobDetail',
            'CronTrigger' => '\\NexusDigital/MiratelForce\\StructType\\CronTrigger',
            'CspTrustedSite' => '\\NexusDigital/MiratelForce\\StructType\\CspTrustedSite',
            'CustomBrand' => '\\NexusDigital/MiratelForce\\StructType\\CustomBrand',
            'CustomBrandAsset' => '\\NexusDigital/MiratelForce\\StructType\\CustomBrandAsset',
            'CustomHelpMenuItem' => '\\NexusDigital/MiratelForce\\StructType\\CustomHelpMenuItem',
            'CustomHelpMenuSection' => '\\NexusDigital/MiratelForce\\StructType\\CustomHelpMenuSection',
            'CustomHttpHeader' => '\\NexusDigital/MiratelForce\\StructType\\CustomHttpHeader',
            'CustomObjectUserLicenseMetrics' => '\\NexusDigital/MiratelForce\\StructType\\CustomObjectUserLicenseMetrics',
            'CustomPermission' => '\\NexusDigital/MiratelForce\\StructType\\CustomPermission',
            'CustomPermissionDependency' => '\\NexusDigital/MiratelForce\\StructType\\CustomPermissionDependency',
            'CustomSetup' => '\\NexusDigital/MiratelForce\\StructType\\CustomSetup',
            'CustomSetupDefinition' => '\\NexusDigital/MiratelForce\\StructType\\CustomSetupDefinition',
            'Dashboard' => '\\NexusDigital/MiratelForce\\StructType\\Dashboard',
            'DashboardComponent' => '\\NexusDigital/MiratelForce\\StructType\\DashboardComponent',
            'DashboardComponentFeed' => '\\NexusDigital/MiratelForce\\StructType\\DashboardComponentFeed',
            'DashboardFeed' => '\\NexusDigital/MiratelForce\\StructType\\DashboardFeed',
            'DataAssessmentFieldMetric' => '\\NexusDigital/MiratelForce\\StructType\\DataAssessmentFieldMetric',
            'DataAssessmentMetric' => '\\NexusDigital/MiratelForce\\StructType\\DataAssessmentMetric',
            'DataAssessmentValueMetric' => '\\NexusDigital/MiratelForce\\StructType\\DataAssessmentValueMetric',
            'DataIntegrationRecordPurchasePermission' => '\\NexusDigital/MiratelForce\\StructType\\DataIntegrationRecordPurchasePermission',
            'DataStatistics' => '\\NexusDigital/MiratelForce\\StructType\\DataStatistics',
            'DataType' => '\\NexusDigital/MiratelForce\\StructType\\DataType',
            'DataUseLegalBasis' => '\\NexusDigital/MiratelForce\\StructType\\DataUseLegalBasis',
            'DataUseLegalBasisHistory' => '\\NexusDigital/MiratelForce\\StructType\\DataUseLegalBasisHistory',
            'DataUseLegalBasisShare' => '\\NexusDigital/MiratelForce\\StructType\\DataUseLegalBasisShare',
            'DataUsePurpose' => '\\NexusDigital/MiratelForce\\StructType\\DataUsePurpose',
            'DataUsePurposeHistory' => '\\NexusDigital/MiratelForce\\StructType\\DataUsePurposeHistory',
            'DataUsePurposeShare' => '\\NexusDigital/MiratelForce\\StructType\\DataUsePurposeShare',
            'DatacloudAddress' => '\\NexusDigital/MiratelForce\\StructType\\DatacloudAddress',
            'DeclinedEventRelation' => '\\NexusDigital/MiratelForce\\StructType\\DeclinedEventRelation',
            'Document' => '\\NexusDigital/MiratelForce\\StructType\\Document',
            'DocumentAttachmentMap' => '\\NexusDigital/MiratelForce\\StructType\\DocumentAttachmentMap',
            'Domain' => '\\NexusDigital/MiratelForce\\StructType\\Domain',
            'DomainSite' => '\\NexusDigital/MiratelForce\\StructType\\DomainSite',
            'Donation__History' => '\\NexusDigital/MiratelForce\\StructType\\Donation__History',
            'Donation__Share' => '\\NexusDigital/MiratelForce\\StructType\\Donation__Share',
            'Donation__c' => '\\NexusDigital/MiratelForce\\StructType\\Donation__c',
            'DuplicateRecordItem' => '\\NexusDigital/MiratelForce\\StructType\\DuplicateRecordItem',
            'DuplicateRecordSet' => '\\NexusDigital/MiratelForce\\StructType\\DuplicateRecordSet',
            'DuplicateRule' => '\\NexusDigital/MiratelForce\\StructType\\DuplicateRule',
            'EmailCapture' => '\\NexusDigital/MiratelForce\\StructType\\EmailCapture',
            'EmailDomainFilter' => '\\NexusDigital/MiratelForce\\StructType\\EmailDomainFilter',
            'EmailDomainKey' => '\\NexusDigital/MiratelForce\\StructType\\EmailDomainKey',
            'EmailMessage' => '\\NexusDigital/MiratelForce\\StructType\\EmailMessage',
            'EmailMessageRelation' => '\\NexusDigital/MiratelForce\\StructType\\EmailMessageRelation',
            'EmailRelay' => '\\NexusDigital/MiratelForce\\StructType\\EmailRelay',
            'EmailServicesAddress' => '\\NexusDigital/MiratelForce\\StructType\\EmailServicesAddress',
            'EmailServicesFunction' => '\\NexusDigital/MiratelForce\\StructType\\EmailServicesFunction',
            'EmailStatus' => '\\NexusDigital/MiratelForce\\StructType\\EmailStatus',
            'EmailTemplate' => '\\NexusDigital/MiratelForce\\StructType\\EmailTemplate',
            'EmbeddedServiceDetail' => '\\NexusDigital/MiratelForce\\StructType\\EmbeddedServiceDetail',
            'EmbeddedServiceLabel' => '\\NexusDigital/MiratelForce\\StructType\\EmbeddedServiceLabel',
            'EnhancedLetterhead' => '\\NexusDigital/MiratelForce\\StructType\\EnhancedLetterhead',
            'EnhancedLetterheadFeed' => '\\NexusDigital/MiratelForce\\StructType\\EnhancedLetterheadFeed',
            'EntityDefinition' => '\\NexusDigital/MiratelForce\\StructType\\EntityDefinition',
            'EntityParticle' => '\\NexusDigital/MiratelForce\\StructType\\EntityParticle',
            'EntitySubscription' => '\\NexusDigital/MiratelForce\\StructType\\EntitySubscription',
            'Event' => '\\NexusDigital/MiratelForce\\StructType\\Event',
            'EventBusSubscriber' => '\\NexusDigital/MiratelForce\\StructType\\EventBusSubscriber',
            'EventFeed' => '\\NexusDigital/MiratelForce\\StructType\\EventFeed',
            'EventLogFile' => '\\NexusDigital/MiratelForce\\StructType\\EventLogFile',
            'EventRelation' => '\\NexusDigital/MiratelForce\\StructType\\EventRelation',
            'EventWhoRelation' => '\\NexusDigital/MiratelForce\\StructType\\EventWhoRelation',
            'ExpressionFilter' => '\\NexusDigital/MiratelForce\\StructType\\ExpressionFilter',
            'ExpressionFilterCriteria' => '\\NexusDigital/MiratelForce\\StructType\\ExpressionFilterCriteria',
            'ExternalDataSource' => '\\NexusDigital/MiratelForce\\StructType\\ExternalDataSource',
            'ExternalDataUserAuth' => '\\NexusDigital/MiratelForce\\StructType\\ExternalDataUserAuth',
            'ExternalSocialAccount' => '\\NexusDigital/MiratelForce\\StructType\\ExternalSocialAccount',
            'FeedAttachment' => '\\NexusDigital/MiratelForce\\StructType\\FeedAttachment',
            'FeedComment' => '\\NexusDigital/MiratelForce\\StructType\\FeedComment',
            'FeedItem' => '\\NexusDigital/MiratelForce\\StructType\\FeedItem',
            'FeedLike' => '\\NexusDigital/MiratelForce\\StructType\\FeedLike',
            'FeedPollChoice' => '\\NexusDigital/MiratelForce\\StructType\\FeedPollChoice',
            'FeedPollVote' => '\\NexusDigital/MiratelForce\\StructType\\FeedPollVote',
            'FeedRevision' => '\\NexusDigital/MiratelForce\\StructType\\FeedRevision',
            'FeedSignal' => '\\NexusDigital/MiratelForce\\StructType\\FeedSignal',
            'FeedTrackedChange' => '\\NexusDigital/MiratelForce\\StructType\\FeedTrackedChange',
            'FieldDefinition' => '\\NexusDigital/MiratelForce\\StructType\\FieldDefinition',
            'FieldPermissions' => '\\NexusDigital/MiratelForce\\StructType\\FieldPermissions',
            'FieldSecurityClassification' => '\\NexusDigital/MiratelForce\\StructType\\FieldSecurityClassification',
            'FileSearchActivity' => '\\NexusDigital/MiratelForce\\StructType\\FileSearchActivity',
            'FiscalYearSettings' => '\\NexusDigital/MiratelForce\\StructType\\FiscalYearSettings',
            'FlexQueueItem' => '\\NexusDigital/MiratelForce\\StructType\\FlexQueueItem',
            'FlowDefinitionView' => '\\NexusDigital/MiratelForce\\StructType\\FlowDefinitionView',
            'FlowInterview' => '\\NexusDigital/MiratelForce\\StructType\\FlowInterview',
            'FlowInterviewShare' => '\\NexusDigital/MiratelForce\\StructType\\FlowInterviewShare',
            'FlowRecordRelation' => '\\NexusDigital/MiratelForce\\StructType\\FlowRecordRelation',
            'FlowStageRelation' => '\\NexusDigital/MiratelForce\\StructType\\FlowStageRelation',
            'FlowVariableView' => '\\NexusDigital/MiratelForce\\StructType\\FlowVariableView',
            'FlowVersionView' => '\\NexusDigital/MiratelForce\\StructType\\FlowVersionView',
            'Folder' => '\\NexusDigital/MiratelForce\\StructType\\Folder',
            'FolderedContentDocument' => '\\NexusDigital/MiratelForce\\StructType\\FolderedContentDocument',
            'ForecastShare' => '\\NexusDigital/MiratelForce\\StructType\\ForecastShare',
            'ForecastingAdjustment' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingAdjustment',
            'ForecastingCategoryMapping' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingCategoryMapping',
            'ForecastingDisplayedFamily' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingDisplayedFamily',
            'ForecastingFact' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingFact',
            'ForecastingItem' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingItem',
            'ForecastingOwnerAdjustment' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingOwnerAdjustment',
            'ForecastingQuota' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingQuota',
            'ForecastingShare' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingShare',
            'ForecastingType' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingType',
            'ForecastingTypeToCategory' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingTypeToCategory',
            'ForecastingUserPreference' => '\\NexusDigital/MiratelForce\\StructType\\ForecastingUserPreference',
            'Goole_API_Key__mdt' => '\\NexusDigital/MiratelForce\\StructType\\Goole_API_Key__mdt',
            'GrantedByLicense' => '\\NexusDigital/MiratelForce\\StructType\\GrantedByLicense',
            'Group' => '\\NexusDigital/MiratelForce\\StructType\\Group',
            'GroupMember' => '\\NexusDigital/MiratelForce\\StructType\\GroupMember',
            'Holiday' => '\\NexusDigital/MiratelForce\\StructType\\Holiday',
            'IconDefinition' => '\\NexusDigital/MiratelForce\\StructType\\IconDefinition',
            'Idea' => '\\NexusDigital/MiratelForce\\StructType\\Idea',
            'IdeaComment' => '\\NexusDigital/MiratelForce\\StructType\\IdeaComment',
            'IdpEventLog' => '\\NexusDigital/MiratelForce\\StructType\\IdpEventLog',
            'IframeWhiteListUrl' => '\\NexusDigital/MiratelForce\\StructType\\IframeWhiteListUrl',
            'Image' => '\\NexusDigital/MiratelForce\\StructType\\Image',
            'ImageShare' => '\\NexusDigital/MiratelForce\\StructType\\ImageShare',
            'Individual' => '\\NexusDigital/MiratelForce\\StructType\\Individual',
            'IndividualHistory' => '\\NexusDigital/MiratelForce\\StructType\\IndividualHistory',
            'IndividualShare' => '\\NexusDigital/MiratelForce\\StructType\\IndividualShare',
            'InstalledMobileApp' => '\\NexusDigital/MiratelForce\\StructType\\InstalledMobileApp',
            'KnowledgeArticle' => '\\NexusDigital/MiratelForce\\StructType\\KnowledgeArticle',
            'KnowledgeArticleVersion' => '\\NexusDigital/MiratelForce\\StructType\\KnowledgeArticleVersion',
            'KnowledgeArticleVersionHistory' => '\\NexusDigital/MiratelForce\\StructType\\KnowledgeArticleVersionHistory',
            'KnowledgeArticleViewStat' => '\\NexusDigital/MiratelForce\\StructType\\KnowledgeArticleViewStat',
            'KnowledgeArticleVoteStat' => '\\NexusDigital/MiratelForce\\StructType\\KnowledgeArticleVoteStat',
            'Knowledge__DataCategorySelection' => '\\NexusDigital/MiratelForce\\StructType\\Knowledge__DataCategorySelection',
            'Knowledge__Feed' => '\\NexusDigital/MiratelForce\\StructType\\Knowledge__Feed',
            'Knowledge__ViewStat' => '\\NexusDigital/MiratelForce\\StructType\\Knowledge__ViewStat',
            'Knowledge__VoteStat' => '\\NexusDigital/MiratelForce\\StructType\\Knowledge__VoteStat',
            'Knowledge__ka' => '\\NexusDigital/MiratelForce\\StructType\\Knowledge__ka',
            'Knowledge__kav' => '\\NexusDigital/MiratelForce\\StructType\\Knowledge__kav',
            'KnowledgeableUser' => '\\NexusDigital/MiratelForce\\StructType\\KnowledgeableUser',
            'Lead' => '\\NexusDigital/MiratelForce\\StructType\\Lead',
            'LeadFeed' => '\\NexusDigital/MiratelForce\\StructType\\LeadFeed',
            'LeadHistory' => '\\NexusDigital/MiratelForce\\StructType\\LeadHistory',
            'LeadShare' => '\\NexusDigital/MiratelForce\\StructType\\LeadShare',
            'LeadStatus' => '\\NexusDigital/MiratelForce\\StructType\\LeadStatus',
            'LightningExitByPageMetrics' => '\\NexusDigital/MiratelForce\\StructType\\LightningExitByPageMetrics',
            'LightningExperienceTheme' => '\\NexusDigital/MiratelForce\\StructType\\LightningExperienceTheme',
            'LightningToggleMetrics' => '\\NexusDigital/MiratelForce\\StructType\\LightningToggleMetrics',
            'LightningUsageByAppTypeMetrics' => '\\NexusDigital/MiratelForce\\StructType\\LightningUsageByAppTypeMetrics',
            'LightningUsageByBrowserMetrics' => '\\NexusDigital/MiratelForce\\StructType\\LightningUsageByBrowserMetrics',
            'LightningUsageByFlexiPageMetrics' => '\\NexusDigital/MiratelForce\\StructType\\LightningUsageByFlexiPageMetrics',
            'LightningUsageByPageMetrics' => '\\NexusDigital/MiratelForce\\StructType\\LightningUsageByPageMetrics',
            'LinkedArticle' => '\\NexusDigital/MiratelForce\\StructType\\LinkedArticle',
            'LinkedArticleFeed' => '\\NexusDigital/MiratelForce\\StructType\\LinkedArticleFeed',
            'LinkedArticleHistory' => '\\NexusDigital/MiratelForce\\StructType\\LinkedArticleHistory',
            'ListEmail' => '\\NexusDigital/MiratelForce\\StructType\\ListEmail',
            'ListEmailIndividualRecipient' => '\\NexusDigital/MiratelForce\\StructType\\ListEmailIndividualRecipient',
            'ListEmailRecipientSource' => '\\NexusDigital/MiratelForce\\StructType\\ListEmailRecipientSource',
            'ListEmailShare' => '\\NexusDigital/MiratelForce\\StructType\\ListEmailShare',
            'ListView' => '\\NexusDigital/MiratelForce\\StructType\\ListView',
            'ListViewChart' => '\\NexusDigital/MiratelForce\\StructType\\ListViewChart',
            'ListViewChartInstance' => '\\NexusDigital/MiratelForce\\StructType\\ListViewChartInstance',
            'LoginGeo' => '\\NexusDigital/MiratelForce\\StructType\\LoginGeo',
            'LoginHistory' => '\\NexusDigital/MiratelForce\\StructType\\LoginHistory',
            'LoginIp' => '\\NexusDigital/MiratelForce\\StructType\\LoginIp',
            'LogoutEventStream' => '\\NexusDigital/MiratelForce\\StructType\\LogoutEventStream',
            'LookedUpFromActivity' => '\\NexusDigital/MiratelForce\\StructType\\LookedUpFromActivity',
            'Macro' => '\\NexusDigital/MiratelForce\\StructType\\Macro',
            'MacroHistory' => '\\NexusDigital/MiratelForce\\StructType\\MacroHistory',
            'MacroInstruction' => '\\NexusDigital/MiratelForce\\StructType\\MacroInstruction',
            'MacroShare' => '\\NexusDigital/MiratelForce\\StructType\\MacroShare',
            'MailmergeTemplate' => '\\NexusDigital/MiratelForce\\StructType\\MailmergeTemplate',
            'MatchingRule' => '\\NexusDigital/MiratelForce\\StructType\\MatchingRule',
            'MatchingRuleItem' => '\\NexusDigital/MiratelForce\\StructType\\MatchingRuleItem',
            'MyDomainDiscoverableLogin' => '\\NexusDigital/MiratelForce\\StructType\\MyDomainDiscoverableLogin',
            'Name' => '\\NexusDigital/MiratelForce\\StructType\\Name',
            'NamedCredential' => '\\NexusDigital/MiratelForce\\StructType\\NamedCredential',
            'NavigationLinkSet' => '\\NexusDigital/MiratelForce\\StructType\\NavigationLinkSet',
            'NavigationMenuItem' => '\\NexusDigital/MiratelForce\\StructType\\NavigationMenuItem',
            'Network' => '\\NexusDigital/MiratelForce\\StructType\\Network',
            'NetworkActivityAudit' => '\\NexusDigital/MiratelForce\\StructType\\NetworkActivityAudit',
            'NetworkAffinity' => '\\NexusDigital/MiratelForce\\StructType\\NetworkAffinity',
            'NetworkDiscoverableLogin' => '\\NexusDigital/MiratelForce\\StructType\\NetworkDiscoverableLogin',
            'NetworkMember' => '\\NexusDigital/MiratelForce\\StructType\\NetworkMember',
            'NetworkMemberGroup' => '\\NexusDigital/MiratelForce\\StructType\\NetworkMemberGroup',
            'NetworkModeration' => '\\NexusDigital/MiratelForce\\StructType\\NetworkModeration',
            'NetworkPageOverride' => '\\NexusDigital/MiratelForce\\StructType\\NetworkPageOverride',
            'NetworkSelfRegistration' => '\\NexusDigital/MiratelForce\\StructType\\NetworkSelfRegistration',
            'NetworkUserHistoryRecent' => '\\NexusDigital/MiratelForce\\StructType\\NetworkUserHistoryRecent',
            'Note' => '\\NexusDigital/MiratelForce\\StructType\\Note',
            'NoteAndAttachment' => '\\NexusDigital/MiratelForce\\StructType\\NoteAndAttachment',
            'OauthCustomScope' => '\\NexusDigital/MiratelForce\\StructType\\OauthCustomScope',
            'OauthToken' => '\\NexusDigital/MiratelForce\\StructType\\OauthToken',
            'ObjectPermissions' => '\\NexusDigital/MiratelForce\\StructType\\ObjectPermissions',
            'OnboardingMetrics' => '\\NexusDigital/MiratelForce\\StructType\\OnboardingMetrics',
            'OpenActivity' => '\\NexusDigital/MiratelForce\\StructType\\OpenActivity',
            'Opportunity' => '\\NexusDigital/MiratelForce\\StructType\\Opportunity',
            'OpportunityCompetitor' => '\\NexusDigital/MiratelForce\\StructType\\OpportunityCompetitor',
            'OpportunityContactRole' => '\\NexusDigital/MiratelForce\\StructType\\OpportunityContactRole',
            'OpportunityFeed' => '\\NexusDigital/MiratelForce\\StructType\\OpportunityFeed',
            'OpportunityFieldHistory' => '\\NexusDigital/MiratelForce\\StructType\\OpportunityFieldHistory',
            'OpportunityHistory' => '\\NexusDigital/MiratelForce\\StructType\\OpportunityHistory',
            'OpportunityLineItem' => '\\NexusDigital/MiratelForce\\StructType\\OpportunityLineItem',
            'OpportunityPartner' => '\\NexusDigital/MiratelForce\\StructType\\OpportunityPartner',
            'OpportunityShare' => '\\NexusDigital/MiratelForce\\StructType\\OpportunityShare',
            'OpportunityStage' => '\\NexusDigital/MiratelForce\\StructType\\OpportunityStage',
            'Order' => '\\NexusDigital/MiratelForce\\StructType\\Order',
            'OrderFeed' => '\\NexusDigital/MiratelForce\\StructType\\OrderFeed',
            'OrderHistory' => '\\NexusDigital/MiratelForce\\StructType\\OrderHistory',
            'OrderItem' => '\\NexusDigital/MiratelForce\\StructType\\OrderItem',
            'OrderItemFeed' => '\\NexusDigital/MiratelForce\\StructType\\OrderItemFeed',
            'OrderItemHistory' => '\\NexusDigital/MiratelForce\\StructType\\OrderItemHistory',
            'OrderShare' => '\\NexusDigital/MiratelForce\\StructType\\OrderShare',
            'OrderStatus' => '\\NexusDigital/MiratelForce\\StructType\\OrderStatus',
            'OrgLifecycleNotification' => '\\NexusDigital/MiratelForce\\StructType\\OrgLifecycleNotification',
            'OrgWideEmailAddress' => '\\NexusDigital/MiratelForce\\StructType\\OrgWideEmailAddress',
            'Organization' => '\\NexusDigital/MiratelForce\\StructType\\Organization',
            'OutOfOffice' => '\\NexusDigital/MiratelForce\\StructType\\OutOfOffice',
            'OutgoingEmail' => '\\NexusDigital/MiratelForce\\StructType\\OutgoingEmail',
            'OutgoingEmailRelation' => '\\NexusDigital/MiratelForce\\StructType\\OutgoingEmailRelation',
            'OwnedContentDocument' => '\\NexusDigital/MiratelForce\\StructType\\OwnedContentDocument',
            'OwnerChangeOptionInfo' => '\\NexusDigital/MiratelForce\\StructType\\OwnerChangeOptionInfo',
            'PackageLicense' => '\\NexusDigital/MiratelForce\\StructType\\PackageLicense',
            'Partner' => '\\NexusDigital/MiratelForce\\StructType\\Partner',
            'PartnerRole' => '\\NexusDigital/MiratelForce\\StructType\\PartnerRole',
            'PendingServiceRouting' => '\\NexusDigital/MiratelForce\\StructType\\PendingServiceRouting',
            'PendingServiceRoutingShare' => '\\NexusDigital/MiratelForce\\StructType\\PendingServiceRoutingShare',
            'Period' => '\\NexusDigital/MiratelForce\\StructType\\Period',
            'PermissionSet' => '\\NexusDigital/MiratelForce\\StructType\\PermissionSet',
            'PermissionSetAssignment' => '\\NexusDigital/MiratelForce\\StructType\\PermissionSetAssignment',
            'PermissionSetLicense' => '\\NexusDigital/MiratelForce\\StructType\\PermissionSetLicense',
            'PermissionSetLicenseAssign' => '\\NexusDigital/MiratelForce\\StructType\\PermissionSetLicenseAssign',
            'PermissionSetTabSetting' => '\\NexusDigital/MiratelForce\\StructType\\PermissionSetTabSetting',
            'PicklistValueInfo' => '\\NexusDigital/MiratelForce\\StructType\\PicklistValueInfo',
            'PlatformAction' => '\\NexusDigital/MiratelForce\\StructType\\PlatformAction',
            'PlatformCachePartition' => '\\NexusDigital/MiratelForce\\StructType\\PlatformCachePartition',
            'PlatformCachePartitionType' => '\\NexusDigital/MiratelForce\\StructType\\PlatformCachePartitionType',
            'PlatformStatusAlertEvent' => '\\NexusDigital/MiratelForce\\StructType\\PlatformStatusAlertEvent',
            'PresenceConfigDeclineReason' => '\\NexusDigital/MiratelForce\\StructType\\PresenceConfigDeclineReason',
            'PresenceDeclineReason' => '\\NexusDigital/MiratelForce\\StructType\\PresenceDeclineReason',
            'PresenceUserConfig' => '\\NexusDigital/MiratelForce\\StructType\\PresenceUserConfig',
            'PresenceUserConfigProfile' => '\\NexusDigital/MiratelForce\\StructType\\PresenceUserConfigProfile',
            'PresenceUserConfigUser' => '\\NexusDigital/MiratelForce\\StructType\\PresenceUserConfigUser',
            'Pricebook2' => '\\NexusDigital/MiratelForce\\StructType\\Pricebook2',
            'Pricebook2History' => '\\NexusDigital/MiratelForce\\StructType\\Pricebook2History',
            'PricebookEntry' => '\\NexusDigital/MiratelForce\\StructType\\PricebookEntry',
            'ProcessDefinition' => '\\NexusDigital/MiratelForce\\StructType\\ProcessDefinition',
            'ProcessInstance' => '\\NexusDigital/MiratelForce\\StructType\\ProcessInstance',
            'ProcessInstanceHistory' => '\\NexusDigital/MiratelForce\\StructType\\ProcessInstanceHistory',
            'ProcessInstanceNode' => '\\NexusDigital/MiratelForce\\StructType\\ProcessInstanceNode',
            'ProcessInstanceStep' => '\\NexusDigital/MiratelForce\\StructType\\ProcessInstanceStep',
            'ProcessInstanceWorkitem' => '\\NexusDigital/MiratelForce\\StructType\\ProcessInstanceWorkitem',
            'ProcessNode' => '\\NexusDigital/MiratelForce\\StructType\\ProcessNode',
            'Product2' => '\\NexusDigital/MiratelForce\\StructType\\Product2',
            'Product2Feed' => '\\NexusDigital/MiratelForce\\StructType\\Product2Feed',
            'Product2History' => '\\NexusDigital/MiratelForce\\StructType\\Product2History',
            'Profile' => '\\NexusDigital/MiratelForce\\StructType\\Profile',
            'ProfileSkill' => '\\NexusDigital/MiratelForce\\StructType\\ProfileSkill',
            'ProfileSkillEndorsement' => '\\NexusDigital/MiratelForce\\StructType\\ProfileSkillEndorsement',
            'ProfileSkillEndorsementFeed' => '\\NexusDigital/MiratelForce\\StructType\\ProfileSkillEndorsementFeed',
            'ProfileSkillEndorsementHistory' => '\\NexusDigital/MiratelForce\\StructType\\ProfileSkillEndorsementHistory',
            'ProfileSkillFeed' => '\\NexusDigital/MiratelForce\\StructType\\ProfileSkillFeed',
            'ProfileSkillHistory' => '\\NexusDigital/MiratelForce\\StructType\\ProfileSkillHistory',
            'ProfileSkillShare' => '\\NexusDigital/MiratelForce\\StructType\\ProfileSkillShare',
            'ProfileSkillUser' => '\\NexusDigital/MiratelForce\\StructType\\ProfileSkillUser',
            'ProfileSkillUserFeed' => '\\NexusDigital/MiratelForce\\StructType\\ProfileSkillUserFeed',
            'ProfileSkillUserHistory' => '\\NexusDigital/MiratelForce\\StructType\\ProfileSkillUserHistory',
            'Prompt' => '\\NexusDigital/MiratelForce\\StructType\\Prompt',
            'PromptAction' => '\\NexusDigital/MiratelForce\\StructType\\PromptAction',
            'PromptActionShare' => '\\NexusDigital/MiratelForce\\StructType\\PromptActionShare',
            'PromptVersion' => '\\NexusDigital/MiratelForce\\StructType\\PromptVersion',
            'Publisher' => '\\NexusDigital/MiratelForce\\StructType\\Publisher',
            'PushTopic' => '\\NexusDigital/MiratelForce\\StructType\\PushTopic',
            'QueueRoutingConfig' => '\\NexusDigital/MiratelForce\\StructType\\QueueRoutingConfig',
            'QueueSobject' => '\\NexusDigital/MiratelForce\\StructType\\QueueSobject',
            'QuickText' => '\\NexusDigital/MiratelForce\\StructType\\QuickText',
            'QuickTextHistory' => '\\NexusDigital/MiratelForce\\StructType\\QuickTextHistory',
            'QuickTextShare' => '\\NexusDigital/MiratelForce\\StructType\\QuickTextShare',
            'Quote' => '\\NexusDigital/MiratelForce\\StructType\\Quote',
            'QuoteDocument' => '\\NexusDigital/MiratelForce\\StructType\\QuoteDocument',
            'QuoteFeed' => '\\NexusDigital/MiratelForce\\StructType\\QuoteFeed',
            'QuoteLineItem' => '\\NexusDigital/MiratelForce\\StructType\\QuoteLineItem',
            'QuoteShare' => '\\NexusDigital/MiratelForce\\StructType\\QuoteShare',
            'QuoteTemplateRichTextData' => '\\NexusDigital/MiratelForce\\StructType\\QuoteTemplateRichTextData',
            'RecentlyViewed' => '\\NexusDigital/MiratelForce\\StructType\\RecentlyViewed',
            'Recommendation' => '\\NexusDigital/MiratelForce\\StructType\\Recommendation',
            'RecordAction' => '\\NexusDigital/MiratelForce\\StructType\\RecordAction',
            'RecordActionHistory' => '\\NexusDigital/MiratelForce\\StructType\\RecordActionHistory',
            'RecordType' => '\\NexusDigital/MiratelForce\\StructType\\RecordType',
            'RelationshipDomain' => '\\NexusDigital/MiratelForce\\StructType\\RelationshipDomain',
            'RelationshipInfo' => '\\NexusDigital/MiratelForce\\StructType\\RelationshipInfo',
            'Report' => '\\NexusDigital/MiratelForce\\StructType\\Report',
            'ReportFeed' => '\\NexusDigital/MiratelForce\\StructType\\ReportFeed',
            'ReputationLevel' => '\\NexusDigital/MiratelForce\\StructType\\ReputationLevel',
            'ReputationPointsRule' => '\\NexusDigital/MiratelForce\\StructType\\ReputationPointsRule',
            'SamlSsoConfig' => '\\NexusDigital/MiratelForce\\StructType\\SamlSsoConfig',
            'Scontrol' => '\\NexusDigital/MiratelForce\\StructType\\Scontrol',
            'SearchActivity' => '\\NexusDigital/MiratelForce\\StructType\\SearchActivity',
            'SearchLayout' => '\\NexusDigital/MiratelForce\\StructType\\SearchLayout',
            'SearchPromotionRule' => '\\NexusDigital/MiratelForce\\StructType\\SearchPromotionRule',
            'SecureAgentsCluster' => '\\NexusDigital/MiratelForce\\StructType\\SecureAgentsCluster',
            'SecurityCustomBaseline' => '\\NexusDigital/MiratelForce\\StructType\\SecurityCustomBaseline',
            'ServiceChannel' => '\\NexusDigital/MiratelForce\\StructType\\ServiceChannel',
            'ServiceChannelStatus' => '\\NexusDigital/MiratelForce\\StructType\\ServiceChannelStatus',
            'ServicePresenceStatus' => '\\NexusDigital/MiratelForce\\StructType\\ServicePresenceStatus',
            'SessionPermSetActivation' => '\\NexusDigital/MiratelForce\\StructType\\SessionPermSetActivation',
            'SetupAuditTrail' => '\\NexusDigital/MiratelForce\\StructType\\SetupAuditTrail',
            'SetupEntityAccess' => '\\NexusDigital/MiratelForce\\StructType\\SetupEntityAccess',
            'Site' => '\\NexusDigital/MiratelForce\\StructType\\Site',
            'SiteDetail' => '\\NexusDigital/MiratelForce\\StructType\\SiteDetail',
            'SiteFeed' => '\\NexusDigital/MiratelForce\\StructType\\SiteFeed',
            'SiteHistory' => '\\NexusDigital/MiratelForce\\StructType\\SiteHistory',
            'SiteIframeWhiteListUrl' => '\\NexusDigital/MiratelForce\\StructType\\SiteIframeWhiteListUrl',
            'SocialPersona' => '\\NexusDigital/MiratelForce\\StructType\\SocialPersona',
            'SocialPersonaHistory' => '\\NexusDigital/MiratelForce\\StructType\\SocialPersonaHistory',
            'SocialPost' => '\\NexusDigital/MiratelForce\\StructType\\SocialPost',
            'SocialPostFeed' => '\\NexusDigital/MiratelForce\\StructType\\SocialPostFeed',
            'SocialPostHistory' => '\\NexusDigital/MiratelForce\\StructType\\SocialPostHistory',
            'SocialPostShare' => '\\NexusDigital/MiratelForce\\StructType\\SocialPostShare',
            'Solution' => '\\NexusDigital/MiratelForce\\StructType\\Solution',
            'SolutionFeed' => '\\NexusDigital/MiratelForce\\StructType\\SolutionFeed',
            'SolutionHistory' => '\\NexusDigital/MiratelForce\\StructType\\SolutionHistory',
            'SolutionStatus' => '\\NexusDigital/MiratelForce\\StructType\\SolutionStatus',
            'Stamp' => '\\NexusDigital/MiratelForce\\StructType\\Stamp',
            'StampAssignment' => '\\NexusDigital/MiratelForce\\StructType\\StampAssignment',
            'StaticResource' => '\\NexusDigital/MiratelForce\\StructType\\StaticResource',
            'StreamingChannel' => '\\NexusDigital/MiratelForce\\StructType\\StreamingChannel',
            'StreamingChannelShare' => '\\NexusDigital/MiratelForce\\StructType\\StreamingChannelShare',
            'TabDefinition' => '\\NexusDigital/MiratelForce\\StructType\\TabDefinition',
            'Task' => '\\NexusDigital/MiratelForce\\StructType\\Task',
            'TaskFeed' => '\\NexusDigital/MiratelForce\\StructType\\TaskFeed',
            'TaskPriority' => '\\NexusDigital/MiratelForce\\StructType\\TaskPriority',
            'TaskRelation' => '\\NexusDigital/MiratelForce\\StructType\\TaskRelation',
            'TaskStatus' => '\\NexusDigital/MiratelForce\\StructType\\TaskStatus',
            'TaskWhoRelation' => '\\NexusDigital/MiratelForce\\StructType\\TaskWhoRelation',
            'TenantUsageEntitlement' => '\\NexusDigital/MiratelForce\\StructType\\TenantUsageEntitlement',
            'TestSuiteMembership' => '\\NexusDigital/MiratelForce\\StructType\\TestSuiteMembership',
            'ThirdPartyAccountLink' => '\\NexusDigital/MiratelForce\\StructType\\ThirdPartyAccountLink',
            'Ticket_Order_Line_Item__History' => '\\NexusDigital/MiratelForce\\StructType\\Ticket_Order_Line_Item__History',
            'Ticket_Order_Line_Item__c' => '\\NexusDigital/MiratelForce\\StructType\\Ticket_Order_Line_Item__c',
            'Ticket_Order__History' => '\\NexusDigital/MiratelForce\\StructType\\Ticket_Order__History',
            'Ticket_Order__Share' => '\\NexusDigital/MiratelForce\\StructType\\Ticket_Order__Share',
            'Ticket_Order__c' => '\\NexusDigital/MiratelForce\\StructType\\Ticket_Order__c',
            'Ticket_Pack__History' => '\\NexusDigital/MiratelForce\\StructType\\Ticket_Pack__History',
            'Ticket_Pack__Share' => '\\NexusDigital/MiratelForce\\StructType\\Ticket_Pack__Share',
            'Ticket_Pack__c' => '\\NexusDigital/MiratelForce\\StructType\\Ticket_Pack__c',
            'TodayGoal' => '\\NexusDigital/MiratelForce\\StructType\\TodayGoal',
            'TodayGoalShare' => '\\NexusDigital/MiratelForce\\StructType\\TodayGoalShare',
            'Topic' => '\\NexusDigital/MiratelForce\\StructType\\Topic',
            'TopicAssignment' => '\\NexusDigital/MiratelForce\\StructType\\TopicAssignment',
            'TopicFeed' => '\\NexusDigital/MiratelForce\\StructType\\TopicFeed',
            'TopicUserEvent' => '\\NexusDigital/MiratelForce\\StructType\\TopicUserEvent',
            'UndecidedEventRelation' => '\\NexusDigital/MiratelForce\\StructType\\UndecidedEventRelation',
            'User' => '\\NexusDigital/MiratelForce\\StructType\\User',
            'UserAppInfo' => '\\NexusDigital/MiratelForce\\StructType\\UserAppInfo',
            'UserAppMenuCustomization' => '\\NexusDigital/MiratelForce\\StructType\\UserAppMenuCustomization',
            'UserAppMenuCustomizationShare' => '\\NexusDigital/MiratelForce\\StructType\\UserAppMenuCustomizationShare',
            'UserAppMenuItem' => '\\NexusDigital/MiratelForce\\StructType\\UserAppMenuItem',
            'UserCustomBadge' => '\\NexusDigital/MiratelForce\\StructType\\UserCustomBadge',
            'UserEmailPreferredPerson' => '\\NexusDigital/MiratelForce\\StructType\\UserEmailPreferredPerson',
            'UserEmailPreferredPersonShare' => '\\NexusDigital/MiratelForce\\StructType\\UserEmailPreferredPersonShare',
            'UserEntityAccess' => '\\NexusDigital/MiratelForce\\StructType\\UserEntityAccess',
            'UserFeed' => '\\NexusDigital/MiratelForce\\StructType\\UserFeed',
            'UserFieldAccess' => '\\NexusDigital/MiratelForce\\StructType\\UserFieldAccess',
            'UserLicense' => '\\NexusDigital/MiratelForce\\StructType\\UserLicense',
            'UserListView' => '\\NexusDigital/MiratelForce\\StructType\\UserListView',
            'UserListViewCriterion' => '\\NexusDigital/MiratelForce\\StructType\\UserListViewCriterion',
            'UserLogin' => '\\NexusDigital/MiratelForce\\StructType\\UserLogin',
            'UserPackageLicense' => '\\NexusDigital/MiratelForce\\StructType\\UserPackageLicense',
            'UserPermissionAccess' => '\\NexusDigital/MiratelForce\\StructType\\UserPermissionAccess',
            'UserPreference' => '\\NexusDigital/MiratelForce\\StructType\\UserPreference',
            'UserRecordAccess' => '\\NexusDigital/MiratelForce\\StructType\\UserRecordAccess',
            'UserRole' => '\\NexusDigital/MiratelForce\\StructType\\UserRole',
            'UserServicePresence' => '\\NexusDigital/MiratelForce\\StructType\\UserServicePresence',
            'UserServicePresenceShare' => '\\NexusDigital/MiratelForce\\StructType\\UserServicePresenceShare',
            'UserShare' => '\\NexusDigital/MiratelForce\\StructType\\UserShare',
            'Validation_Rule_Switch__mdt' => '\\NexusDigital/MiratelForce\\StructType\\Validation_Rule_Switch__mdt',
            'VerificationHistory' => '\\NexusDigital/MiratelForce\\StructType\\VerificationHistory',
            'VisualforceAccessMetrics' => '\\NexusDigital/MiratelForce\\StructType\\VisualforceAccessMetrics',
            'Vote' => '\\NexusDigital/MiratelForce\\StructType\\Vote',
            'WebLink' => '\\NexusDigital/MiratelForce\\StructType\\WebLink',
            'WorkAccess' => '\\NexusDigital/MiratelForce\\StructType\\WorkAccess',
            'WorkAccessShare' => '\\NexusDigital/MiratelForce\\StructType\\WorkAccessShare',
            'WorkBadge' => '\\NexusDigital/MiratelForce\\StructType\\WorkBadge',
            'WorkBadgeDefinition' => '\\NexusDigital/MiratelForce\\StructType\\WorkBadgeDefinition',
            'WorkBadgeDefinitionFeed' => '\\NexusDigital/MiratelForce\\StructType\\WorkBadgeDefinitionFeed',
            'WorkBadgeDefinitionHistory' => '\\NexusDigital/MiratelForce\\StructType\\WorkBadgeDefinitionHistory',
            'WorkBadgeDefinitionShare' => '\\NexusDigital/MiratelForce\\StructType\\WorkBadgeDefinitionShare',
            'WorkOrder' => '\\NexusDigital/MiratelForce\\StructType\\WorkOrder',
            'WorkOrderFeed' => '\\NexusDigital/MiratelForce\\StructType\\WorkOrderFeed',
            'WorkOrderHistory' => '\\NexusDigital/MiratelForce\\StructType\\WorkOrderHistory',
            'WorkOrderLineItem' => '\\NexusDigital/MiratelForce\\StructType\\WorkOrderLineItem',
            'WorkOrderLineItemFeed' => '\\NexusDigital/MiratelForce\\StructType\\WorkOrderLineItemFeed',
            'WorkOrderLineItemHistory' => '\\NexusDigital/MiratelForce\\StructType\\WorkOrderLineItemHistory',
            'WorkOrderLineItemStatus' => '\\NexusDigital/MiratelForce\\StructType\\WorkOrderLineItemStatus',
            'WorkOrderShare' => '\\NexusDigital/MiratelForce\\StructType\\WorkOrderShare',
            'WorkOrderStatus' => '\\NexusDigital/MiratelForce\\StructType\\WorkOrderStatus',
            'WorkThanks' => '\\NexusDigital/MiratelForce\\StructType\\WorkThanks',
            'WorkThanksShare' => '\\NexusDigital/MiratelForce\\StructType\\WorkThanksShare',
            'flowmagic__FlowPicklistConfiguration__c' => '\\NexusDigital/MiratelForce\\StructType\\Flowmagic__FlowPicklistConfiguration__c',
            'p0pFD__ObjectsToDump__c' => '\\NexusDigital/MiratelForce\\StructType\\P0pFD__ObjectsToDump__c',
            'trailheadapp__Badge__History' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__Badge__History',
            'trailheadapp__Badge__c' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__Badge__c',
            'trailheadapp__Debug_Log__c' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__Debug_Log__c',
            'trailheadapp__Trail__History' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__Trail__History',
            'trailheadapp__Trail__c' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__Trail__c',
            'trailheadapp__Trailmix_Assignment__History' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__Trailmix_Assignment__History',
            'trailheadapp__Trailmix_Assignment__c' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__Trailmix_Assignment__c',
            'trailheadapp__Trailmix__History' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__Trailmix__History',
            'trailheadapp__Trailmix__c' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__Trailmix__c',
            'trailheadapp__User_Badge__History' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__User_Badge__History',
            'trailheadapp__User_Badge__c' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__User_Badge__c',
            'trailheadapp__User_Trailmix__History' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__User_Trailmix__History',
            'trailheadapp__User_Trailmix__c' => '\\NexusDigital/MiratelForce\\StructType\\Trailheadapp__User_Trailmix__c',
            'address' => '\\NexusDigital/MiratelForce\\StructType\\Address',
            'location' => '\\NexusDigital/MiratelForce\\StructType\\Location',
            'QueryResult' => '\\NexusDigital/MiratelForce\\StructType\\QueryResult',
            'SearchResult' => '\\NexusDigital/MiratelForce\\StructType\\SearchResult',
            'SearchRecord' => '\\NexusDigital/MiratelForce\\StructType\\SearchRecord',
            'SearchRecordMetadata' => '\\NexusDigital/MiratelForce\\StructType\\SearchRecordMetadata',
            'SearchSnippet' => '\\NexusDigital/MiratelForce\\StructType\\SearchSnippet',
            'SearchResultsMetadata' => '\\NexusDigital/MiratelForce\\StructType\\SearchResultsMetadata',
            'LabelsSearchMetadata' => '\\NexusDigital/MiratelForce\\StructType\\LabelsSearchMetadata',
            'EntitySearchMetadata' => '\\NexusDigital/MiratelForce\\StructType\\EntitySearchMetadata',
            'FieldLevelSearchMetadata' => '\\NexusDigital/MiratelForce\\StructType\\FieldLevelSearchMetadata',
            'EntitySpellCorrectionMetadata' => '\\NexusDigital/MiratelForce\\StructType\\EntitySpellCorrectionMetadata',
            'EntitySearchPromotionMetadata' => '\\NexusDigital/MiratelForce\\StructType\\EntitySearchPromotionMetadata',
            'EntityIntentQueryMetadata' => '\\NexusDigital/MiratelForce\\StructType\\EntityIntentQueryMetadata',
            'RelationshipReferenceTo' => '\\NexusDigital/MiratelForce\\StructType\\RelationshipReferenceTo',
            'RecordTypesSupported' => '\\NexusDigital/MiratelForce\\StructType\\RecordTypesSupported',
            'JunctionIdListNames' => '\\NexusDigital/MiratelForce\\StructType\\JunctionIdListNames',
            'SearchLayoutButtonsDisplayed' => '\\NexusDigital/MiratelForce\\StructType\\SearchLayoutButtonsDisplayed',
            'SearchLayoutButton' => '\\NexusDigital/MiratelForce\\StructType\\SearchLayoutButton',
            'SearchLayoutFieldsDisplayed' => '\\NexusDigital/MiratelForce\\StructType\\SearchLayoutFieldsDisplayed',
            'SearchLayoutField' => '\\NexusDigital/MiratelForce\\StructType\\SearchLayoutField',
            'NameValuePair' => '\\NexusDigital/MiratelForce\\StructType\\NameValuePair',
            'NameObjectValuePair' => '\\NexusDigital/MiratelForce\\StructType\\NameObjectValuePair',
            'GetUpdatedResult' => '\\NexusDigital/MiratelForce\\StructType\\GetUpdatedResult',
            'GetDeletedResult' => '\\NexusDigital/MiratelForce\\StructType\\GetDeletedResult',
            'DeletedRecord' => '\\NexusDigital/MiratelForce\\StructType\\DeletedRecord',
            'GetServerTimestampResult' => '\\NexusDigital/MiratelForce\\StructType\\GetServerTimestampResult',
            'InvalidateSessionsResult' => '\\NexusDigital/MiratelForce\\StructType\\InvalidateSessionsResult',
            'SetPasswordResult' => '\\NexusDigital/MiratelForce\\StructType\\SetPasswordResult',
            'ChangeOwnPasswordResult' => '\\NexusDigital/MiratelForce\\StructType\\ChangeOwnPasswordResult',
            'ResetPasswordResult' => '\\NexusDigital/MiratelForce\\StructType\\ResetPasswordResult',
            'GetUserInfoResult' => '\\NexusDigital/MiratelForce\\StructType\\GetUserInfoResult',
            'LoginResult' => '\\NexusDigital/MiratelForce\\StructType\\LoginResult',
            'ExtendedErrorDetails' => '\\NexusDigital/MiratelForce\\StructType\\ExtendedErrorDetails',
            'Error' => '\\NexusDigital/MiratelForce\\StructType\\Error',
            'SendEmailError' => '\\NexusDigital/MiratelForce\\StructType\\SendEmailError',
            'SaveResult' => '\\NexusDigital/MiratelForce\\StructType\\SaveResult',
            'RenderEmailTemplateError' => '\\NexusDigital/MiratelForce\\StructType\\RenderEmailTemplateError',
            'UpsertResult' => '\\NexusDigital/MiratelForce\\StructType\\UpsertResult',
            'PerformQuickActionResult' => '\\NexusDigital/MiratelForce\\StructType\\PerformQuickActionResult',
            'QuickActionTemplateResult' => '\\NexusDigital/MiratelForce\\StructType\\QuickActionTemplateResult',
            'MergeRequest' => '\\NexusDigital/MiratelForce\\StructType\\MergeRequest',
            'MergeResult' => '\\NexusDigital/MiratelForce\\StructType\\MergeResult',
            'ProcessRequest' => '\\NexusDigital/MiratelForce\\StructType\\ProcessRequest',
            'ProcessSubmitRequest' => '\\NexusDigital/MiratelForce\\StructType\\ProcessSubmitRequest',
            'ProcessWorkitemRequest' => '\\NexusDigital/MiratelForce\\StructType\\ProcessWorkitemRequest',
            'PerformQuickActionRequest' => '\\NexusDigital/MiratelForce\\StructType\\PerformQuickActionRequest',
            'DescribeAvailableQuickActionResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeAvailableQuickActionResult',
            'DescribeQuickActionResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeQuickActionResult',
            'DescribeQuickActionDefaultValue' => '\\NexusDigital/MiratelForce\\StructType\\DescribeQuickActionDefaultValue',
            'DescribeVisualForceResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeVisualForceResult',
            'ProcessResult' => '\\NexusDigital/MiratelForce\\StructType\\ProcessResult',
            'DeleteResult' => '\\NexusDigital/MiratelForce\\StructType\\DeleteResult',
            'UndeleteResult' => '\\NexusDigital/MiratelForce\\StructType\\UndeleteResult',
            'DeleteByExampleResult' => '\\NexusDigital/MiratelForce\\StructType\\DeleteByExampleResult',
            'EmptyRecycleBinResult' => '\\NexusDigital/MiratelForce\\StructType\\EmptyRecycleBinResult',
            'LeadConvert' => '\\NexusDigital/MiratelForce\\StructType\\LeadConvert',
            'LeadConvertResult' => '\\NexusDigital/MiratelForce\\StructType\\LeadConvertResult',
            'DescribeSObjectResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSObjectResult',
            'DescribeGlobalSObjectResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeGlobalSObjectResult',
            'ChildRelationship' => '\\NexusDigital/MiratelForce\\StructType\\ChildRelationship',
            'DescribeGlobalResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeGlobalResult',
            'DescribeGlobalTheme' => '\\NexusDigital/MiratelForce\\StructType\\DescribeGlobalTheme',
            'ScopeInfo' => '\\NexusDigital/MiratelForce\\StructType\\ScopeInfo',
            'StringList' => '\\NexusDigital/MiratelForce\\StructType\\StringList',
            'FilteredLookupInfo' => '\\NexusDigital/MiratelForce\\StructType\\FilteredLookupInfo',
            'Field' => '\\NexusDigital/MiratelForce\\StructType\\Field',
            'PicklistEntry' => '\\NexusDigital/MiratelForce\\StructType\\PicklistEntry',
            'DescribeDataCategoryGroupResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeDataCategoryGroupResult',
            'DescribeDataCategoryGroupStructureResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeDataCategoryGroupStructureResult',
            'DataCategoryGroupSobjectTypePair' => '\\NexusDigital/MiratelForce\\StructType\\DataCategoryGroupSobjectTypePair',
            'DataCategory' => '\\NexusDigital/MiratelForce\\StructType\\DataCategory',
            'DescribeDataCategoryMappingResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeDataCategoryMappingResult',
            'KnowledgeSettings' => '\\NexusDigital/MiratelForce\\StructType\\KnowledgeSettings',
            'KnowledgeLanguageItem' => '\\NexusDigital/MiratelForce\\StructType\\KnowledgeLanguageItem',
            'FieldDiff' => '\\NexusDigital/MiratelForce\\StructType\\FieldDiff',
            'AdditionalInformationMap' => '\\NexusDigital/MiratelForce\\StructType\\AdditionalInformationMap',
            'MatchRecord' => '\\NexusDigital/MiratelForce\\StructType\\MatchRecord',
            'MatchResult' => '\\NexusDigital/MiratelForce\\StructType\\MatchResult',
            'DuplicateResult' => '\\NexusDigital/MiratelForce\\StructType\\DuplicateResult',
            'DuplicateError' => '\\NexusDigital/MiratelForce\\StructType\\DuplicateError',
            'DescribeNounResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeNounResult',
            'NameCaseValue' => '\\NexusDigital/MiratelForce\\StructType\\NameCaseValue',
            'findDuplicates' => '\\NexusDigital/MiratelForce\\StructType\\FindDuplicates',
            'findDuplicatesByIds' => '\\NexusDigital/MiratelForce\\StructType\\FindDuplicatesByIds',
            'findDuplicatesByIdsResponse' => '\\NexusDigital/MiratelForce\\StructType\\FindDuplicatesByIdsResponse',
            'findDuplicatesResponse' => '\\NexusDigital/MiratelForce\\StructType\\FindDuplicatesResponse',
            'FindDuplicatesResult' => '\\NexusDigital/MiratelForce\\StructType\\FindDuplicatesResult',
            'DescribeAppMenuResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeAppMenuResult',
            'DescribeAppMenuItem' => '\\NexusDigital/MiratelForce\\StructType\\DescribeAppMenuItem',
            'DescribeThemeResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeThemeResult',
            'DescribeThemeItem' => '\\NexusDigital/MiratelForce\\StructType\\DescribeThemeItem',
            'DescribeSoftphoneLayoutResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoftphoneLayoutResult',
            'DescribeSoftphoneLayoutCallType' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoftphoneLayoutCallType',
            'DescribeSoftphoneScreenPopOption' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoftphoneScreenPopOption',
            'DescribeSoftphoneLayoutInfoField' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoftphoneLayoutInfoField',
            'DescribeSoftphoneLayoutSection' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoftphoneLayoutSection',
            'DescribeSoftphoneLayoutItem' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoftphoneLayoutItem',
            'DescribeCompactLayoutsResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeCompactLayoutsResult',
            'DescribeCompactLayout' => '\\NexusDigital/MiratelForce\\StructType\\DescribeCompactLayout',
            'RecordTypeCompactLayoutMapping' => '\\NexusDigital/MiratelForce\\StructType\\RecordTypeCompactLayoutMapping',
            'DescribePathAssistantsResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribePathAssistantsResult',
            'DescribePathAssistant' => '\\NexusDigital/MiratelForce\\StructType\\DescribePathAssistant',
            'DescribePathAssistantStep' => '\\NexusDigital/MiratelForce\\StructType\\DescribePathAssistantStep',
            'DescribePathAssistantField' => '\\NexusDigital/MiratelForce\\StructType\\DescribePathAssistantField',
            'DescribeApprovalLayoutResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeApprovalLayoutResult',
            'DescribeApprovalLayout' => '\\NexusDigital/MiratelForce\\StructType\\DescribeApprovalLayout',
            'DescribeLayoutResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutResult',
            'DescribeLayout' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayout',
            'DescribeQuickActionListResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeQuickActionListResult',
            'DescribeQuickActionListItemResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeQuickActionListItemResult',
            'DescribeLayoutFeedView' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutFeedView',
            'DescribeLayoutFeedFilter' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutFeedFilter',
            'DescribeLayoutSaveOption' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutSaveOption',
            'DescribeLayoutSection' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutSection',
            'DescribeLayoutButtonSection' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutButtonSection',
            'DescribeLayoutRow' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutRow',
            'DescribeLayoutItem' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutItem',
            'DescribeLayoutButton' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutButton',
            'DescribeLayoutComponent' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutComponent',
            'FieldComponent' => '\\NexusDigital/MiratelForce\\StructType\\FieldComponent',
            'FieldLayoutComponent' => '\\NexusDigital/MiratelForce\\StructType\\FieldLayoutComponent',
            'VisualforcePage' => '\\NexusDigital/MiratelForce\\StructType\\VisualforcePage',
            'Canvas' => '\\NexusDigital/MiratelForce\\StructType\\Canvas',
            'ReportChartComponent' => '\\NexusDigital/MiratelForce\\StructType\\ReportChartComponent',
            'AnalyticsCloudComponent' => '\\NexusDigital/MiratelForce\\StructType\\AnalyticsCloudComponent',
            'CustomLinkComponent' => '\\NexusDigital/MiratelForce\\StructType\\CustomLinkComponent',
            'NamedLayoutInfo' => '\\NexusDigital/MiratelForce\\StructType\\NamedLayoutInfo',
            'RecordTypeInfo' => '\\NexusDigital/MiratelForce\\StructType\\RecordTypeInfo',
            'RecordTypeMapping' => '\\NexusDigital/MiratelForce\\StructType\\RecordTypeMapping',
            'PicklistForRecordType' => '\\NexusDigital/MiratelForce\\StructType\\PicklistForRecordType',
            'RelatedContent' => '\\NexusDigital/MiratelForce\\StructType\\RelatedContent',
            'DescribeRelatedContentItem' => '\\NexusDigital/MiratelForce\\StructType\\DescribeRelatedContentItem',
            'RelatedList' => '\\NexusDigital/MiratelForce\\StructType\\RelatedList',
            'RelatedListColumn' => '\\NexusDigital/MiratelForce\\StructType\\RelatedListColumn',
            'RelatedListSort' => '\\NexusDigital/MiratelForce\\StructType\\RelatedListSort',
            'EmailFileAttachment' => '\\NexusDigital/MiratelForce\\StructType\\EmailFileAttachment',
            'Email' => '\\NexusDigital/MiratelForce\\StructType\\Email',
            'MassEmailMessage' => '\\NexusDigital/MiratelForce\\StructType\\MassEmailMessage',
            'SingleEmailMessage' => '\\NexusDigital/MiratelForce\\StructType\\SingleEmailMessage',
            'SendEmailResult' => '\\NexusDigital/MiratelForce\\StructType\\SendEmailResult',
            'ListViewColumn' => '\\NexusDigital/MiratelForce\\StructType\\ListViewColumn',
            'ListViewOrderBy' => '\\NexusDigital/MiratelForce\\StructType\\ListViewOrderBy',
            'DescribeSoqlListView' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoqlListView',
            'DescribeSoqlListViewsRequest' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoqlListViewsRequest',
            'DescribeSoqlListViewParams' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoqlListViewParams',
            'DescribeSoqlListViewResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoqlListViewResult',
            'ExecuteListViewRequest' => '\\NexusDigital/MiratelForce\\StructType\\ExecuteListViewRequest',
            'ExecuteListViewResult' => '\\NexusDigital/MiratelForce\\StructType\\ExecuteListViewResult',
            'ListViewRecord' => '\\NexusDigital/MiratelForce\\StructType\\ListViewRecord',
            'ListViewRecordColumn' => '\\NexusDigital/MiratelForce\\StructType\\ListViewRecordColumn',
            'SoqlWhereCondition' => '\\NexusDigital/MiratelForce\\StructType\\SoqlWhereCondition',
            'SoqlCondition' => '\\NexusDigital/MiratelForce\\StructType\\SoqlCondition',
            'SoqlNotCondition' => '\\NexusDigital/MiratelForce\\StructType\\SoqlNotCondition',
            'SoqlConditionGroup' => '\\NexusDigital/MiratelForce\\StructType\\SoqlConditionGroup',
            'SoqlSubQueryCondition' => '\\NexusDigital/MiratelForce\\StructType\\SoqlSubQueryCondition',
            'DescribeSearchLayoutResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSearchLayoutResult',
            'DescribeColumn' => '\\NexusDigital/MiratelForce\\StructType\\DescribeColumn',
            'DescribeSearchScopeOrderResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSearchScopeOrderResult',
            'DescribeSearchableEntityResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSearchableEntityResult',
            'DescribeTabSetResult' => '\\NexusDigital/MiratelForce\\StructType\\DescribeTabSetResult',
            'DescribeTab' => '\\NexusDigital/MiratelForce\\StructType\\DescribeTab',
            'DescribeColor' => '\\NexusDigital/MiratelForce\\StructType\\DescribeColor',
            'DescribeIcon' => '\\NexusDigital/MiratelForce\\StructType\\DescribeIcon',
            'ActionOverride' => '\\NexusDigital/MiratelForce\\StructType\\ActionOverride',
            'login' => '\\NexusDigital/MiratelForce\\StructType\\Login',
            'loginResponse' => '\\NexusDigital/MiratelForce\\StructType\\LoginResponse',
            'describeSObject' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSObject',
            'describeSObjectResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSObjectResponse',
            'describeSObjects' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSObjects',
            'describeSObjectsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSObjectsResponse',
            'describeGlobal' => '\\NexusDigital/MiratelForce\\StructType\\DescribeGlobal',
            'describeGlobalResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeGlobalResponse',
            'describeGlobalTheme' => '\\NexusDigital/MiratelForce\\StructType\\DescribeGlobalTheme_1',
            'describeGlobalThemeResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeGlobalThemeResponse',
            'describeTheme' => '\\NexusDigital/MiratelForce\\StructType\\DescribeTheme',
            'describeThemeResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeThemeResponse',
            'describeDataCategoryGroups' => '\\NexusDigital/MiratelForce\\StructType\\DescribeDataCategoryGroups',
            'describeDataCategoryGroupsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeDataCategoryGroupsResponse',
            'describeDataCategoryGroupStructures' => '\\NexusDigital/MiratelForce\\StructType\\DescribeDataCategoryGroupStructures',
            'describeDataCategoryGroupStructuresResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeDataCategoryGroupStructuresResponse',
            'describeDataCategoryMappings' => '\\NexusDigital/MiratelForce\\StructType\\DescribeDataCategoryMappings',
            'describeDataCategoryMappingsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeDataCategoryMappingsResponse',
            'describeKnowledgeSettings' => '\\NexusDigital/MiratelForce\\StructType\\DescribeKnowledgeSettings',
            'describeKnowledgeSettingsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeKnowledgeSettingsResponse',
            'describeAppMenu' => '\\NexusDigital/MiratelForce\\StructType\\DescribeAppMenu',
            'describeAppMenuResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeAppMenuResponse',
            'describeLayout' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayout_1',
            'describeLayoutResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeLayoutResponse',
            'describeCompactLayouts' => '\\NexusDigital/MiratelForce\\StructType\\DescribeCompactLayouts',
            'describeCompactLayoutsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeCompactLayoutsResponse',
            'describePrimaryCompactLayouts' => '\\NexusDigital/MiratelForce\\StructType\\DescribePrimaryCompactLayouts',
            'describePrimaryCompactLayoutsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribePrimaryCompactLayoutsResponse',
            'describePathAssistants' => '\\NexusDigital/MiratelForce\\StructType\\DescribePathAssistants',
            'describePathAssistantsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribePathAssistantsResponse',
            'describeApprovalLayout' => '\\NexusDigital/MiratelForce\\StructType\\DescribeApprovalLayout_1',
            'describeApprovalLayoutResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeApprovalLayoutResponse',
            'describeSoftphoneLayout' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoftphoneLayout',
            'describeSoftphoneLayoutResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoftphoneLayoutResponse',
            'describeSoqlListViews' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoqlListViews',
            'describeSoqlListViewsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSoqlListViewsResponse',
            'executeListView' => '\\NexusDigital/MiratelForce\\StructType\\ExecuteListView',
            'executeListViewResponse' => '\\NexusDigital/MiratelForce\\StructType\\ExecuteListViewResponse',
            'describeSObjectListViews' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSObjectListViews',
            'describeSObjectListViewsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSObjectListViewsResponse',
            'describeSearchLayouts' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSearchLayouts',
            'describeSearchLayoutsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSearchLayoutsResponse',
            'describeSearchScopeOrder' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSearchScopeOrder',
            'describeSearchScopeOrderResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSearchScopeOrderResponse',
            'describeSearchableEntities' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSearchableEntities',
            'describeSearchableEntitiesResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeSearchableEntitiesResponse',
            'describeTabs' => '\\NexusDigital/MiratelForce\\StructType\\DescribeTabs',
            'describeTabsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeTabsResponse',
            'describeAllTabs' => '\\NexusDigital/MiratelForce\\StructType\\DescribeAllTabs',
            'describeAllTabsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeAllTabsResponse',
            'describeNouns' => '\\NexusDigital/MiratelForce\\StructType\\DescribeNouns',
            'describeNounsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeNounsResponse',
            'create' => '\\NexusDigital/MiratelForce\\StructType\\Create',
            'createResponse' => '\\NexusDigital/MiratelForce\\StructType\\CreateResponse',
            'sendEmail' => '\\NexusDigital/MiratelForce\\StructType\\SendEmail',
            'sendEmailResponse' => '\\NexusDigital/MiratelForce\\StructType\\SendEmailResponse',
            'RenderEmailTemplateRequest' => '\\NexusDigital/MiratelForce\\StructType\\RenderEmailTemplateRequest',
            'RenderEmailTemplateBodyResult' => '\\NexusDigital/MiratelForce\\StructType\\RenderEmailTemplateBodyResult',
            'RenderEmailTemplateResult' => '\\NexusDigital/MiratelForce\\StructType\\RenderEmailTemplateResult',
            'renderEmailTemplate' => '\\NexusDigital/MiratelForce\\StructType\\RenderEmailTemplate',
            'renderEmailTemplateResponse' => '\\NexusDigital/MiratelForce\\StructType\\RenderEmailTemplateResponse',
            'RenderStoredEmailTemplateRequest' => '\\NexusDigital/MiratelForce\\StructType\\RenderStoredEmailTemplateRequest',
            'RenderStoredEmailTemplateResult' => '\\NexusDigital/MiratelForce\\StructType\\RenderStoredEmailTemplateResult',
            'renderStoredEmailTemplate' => '\\NexusDigital/MiratelForce\\StructType\\RenderStoredEmailTemplate',
            'renderStoredEmailTemplateResponse' => '\\NexusDigital/MiratelForce\\StructType\\RenderStoredEmailTemplateResponse',
            'sendEmailMessage' => '\\NexusDigital/MiratelForce\\StructType\\SendEmailMessage',
            'sendEmailMessageResponse' => '\\NexusDigital/MiratelForce\\StructType\\SendEmailMessageResponse',
            'update' => '\\NexusDigital/MiratelForce\\StructType\\Update',
            'updateResponse' => '\\NexusDigital/MiratelForce\\StructType\\UpdateResponse',
            'upsert' => '\\NexusDigital/MiratelForce\\StructType\\Upsert',
            'upsertResponse' => '\\NexusDigital/MiratelForce\\StructType\\UpsertResponse',
            'merge' => '\\NexusDigital/MiratelForce\\StructType\\Merge',
            'mergeResponse' => '\\NexusDigital/MiratelForce\\StructType\\MergeResponse',
            'delete' => '\\NexusDigital/MiratelForce\\StructType\\Delete',
            'deleteResponse' => '\\NexusDigital/MiratelForce\\StructType\\DeleteResponse',
            'deleteByExample' => '\\NexusDigital/MiratelForce\\StructType\\DeleteByExample',
            'deleteByExampleResponse' => '\\NexusDigital/MiratelForce\\StructType\\DeleteByExampleResponse',
            'undelete' => '\\NexusDigital/MiratelForce\\StructType\\Undelete',
            'undeleteResponse' => '\\NexusDigital/MiratelForce\\StructType\\UndeleteResponse',
            'emptyRecycleBin' => '\\NexusDigital/MiratelForce\\StructType\\EmptyRecycleBin',
            'emptyRecycleBinResponse' => '\\NexusDigital/MiratelForce\\StructType\\EmptyRecycleBinResponse',
            'process' => '\\NexusDigital/MiratelForce\\StructType\\Process',
            'processResponse' => '\\NexusDigital/MiratelForce\\StructType\\ProcessResponse',
            'performQuickActions' => '\\NexusDigital/MiratelForce\\StructType\\PerformQuickActions',
            'performQuickActionsResponse' => '\\NexusDigital/MiratelForce\\StructType\\PerformQuickActionsResponse',
            'retrieveMassQuickActionTemplates' => '\\NexusDigital/MiratelForce\\StructType\\RetrieveMassQuickActionTemplates',
            'retrieveMassQuickActionTemplatesResponse' => '\\NexusDigital/MiratelForce\\StructType\\RetrieveMassQuickActionTemplatesResponse',
            'retrieveQuickActionTemplates' => '\\NexusDigital/MiratelForce\\StructType\\RetrieveQuickActionTemplates',
            'retrieveQuickActionTemplatesResponse' => '\\NexusDigital/MiratelForce\\StructType\\RetrieveQuickActionTemplatesResponse',
            'describeQuickActions' => '\\NexusDigital/MiratelForce\\StructType\\DescribeQuickActions',
            'describeQuickActionsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeQuickActionsResponse',
            'describeQuickActionsForRecordType' => '\\NexusDigital/MiratelForce\\StructType\\DescribeQuickActionsForRecordType',
            'describeQuickActionsForRecordTypeResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeQuickActionsForRecordTypeResponse',
            'describeAvailableQuickActions' => '\\NexusDigital/MiratelForce\\StructType\\DescribeAvailableQuickActions',
            'describeAvailableQuickActionsResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeAvailableQuickActionsResponse',
            'describeVisualForce' => '\\NexusDigital/MiratelForce\\StructType\\DescribeVisualForce',
            'describeVisualForceResponse' => '\\NexusDigital/MiratelForce\\StructType\\DescribeVisualForceResponse',
            'retrieve' => '\\NexusDigital/MiratelForce\\StructType\\Retrieve',
            'retrieveResponse' => '\\NexusDigital/MiratelForce\\StructType\\RetrieveResponse',
            'convertLead' => '\\NexusDigital/MiratelForce\\StructType\\ConvertLead',
            'convertLeadResponse' => '\\NexusDigital/MiratelForce\\StructType\\ConvertLeadResponse',
            'getUpdated' => '\\NexusDigital/MiratelForce\\StructType\\GetUpdated',
            'getUpdatedResponse' => '\\NexusDigital/MiratelForce\\StructType\\GetUpdatedResponse',
            'getDeleted' => '\\NexusDigital/MiratelForce\\StructType\\GetDeleted',
            'getDeletedResponse' => '\\NexusDigital/MiratelForce\\StructType\\GetDeletedResponse',
            'logout' => '\\NexusDigital/MiratelForce\\StructType\\Logout',
            'logoutResponse' => '\\NexusDigital/MiratelForce\\StructType\\LogoutResponse',
            'invalidateSessions' => '\\NexusDigital/MiratelForce\\StructType\\InvalidateSessions',
            'invalidateSessionsResponse' => '\\NexusDigital/MiratelForce\\StructType\\InvalidateSessionsResponse',
            'query' => '\\NexusDigital/MiratelForce\\StructType\\Query',
            'queryResponse' => '\\NexusDigital/MiratelForce\\StructType\\QueryResponse',
            'queryAll' => '\\NexusDigital/MiratelForce\\StructType\\QueryAll',
            'queryAllResponse' => '\\NexusDigital/MiratelForce\\StructType\\QueryAllResponse',
            'queryMore' => '\\NexusDigital/MiratelForce\\StructType\\QueryMore',
            'queryMoreResponse' => '\\NexusDigital/MiratelForce\\StructType\\QueryMoreResponse',
            'search' => '\\NexusDigital/MiratelForce\\StructType\\Search',
            'searchResponse' => '\\NexusDigital/MiratelForce\\StructType\\SearchResponse',
            'getServerTimestamp' => '\\NexusDigital/MiratelForce\\StructType\\GetServerTimestamp',
            'getServerTimestampResponse' => '\\NexusDigital/MiratelForce\\StructType\\GetServerTimestampResponse',
            'setPassword' => '\\NexusDigital/MiratelForce\\StructType\\SetPassword',
            'setPasswordResponse' => '\\NexusDigital/MiratelForce\\StructType\\SetPasswordResponse',
            'changeOwnPassword' => '\\NexusDigital/MiratelForce\\StructType\\ChangeOwnPassword',
            'changeOwnPasswordResponse' => '\\NexusDigital/MiratelForce\\StructType\\ChangeOwnPasswordResponse',
            'resetPassword' => '\\NexusDigital/MiratelForce\\StructType\\ResetPassword',
            'resetPasswordResponse' => '\\NexusDigital/MiratelForce\\StructType\\ResetPasswordResponse',
            'getUserInfo' => '\\NexusDigital/MiratelForce\\StructType\\GetUserInfo',
            'getUserInfoResponse' => '\\NexusDigital/MiratelForce\\StructType\\GetUserInfoResponse',
            'SessionHeader' => '\\NexusDigital/MiratelForce\\StructType\\SessionHeader',
            'LoginScopeHeader' => '\\NexusDigital/MiratelForce\\StructType\\LoginScopeHeader',
            'QueryOptions' => '\\NexusDigital/MiratelForce\\StructType\\QueryOptions',
            'DebuggingHeader' => '\\NexusDigital/MiratelForce\\StructType\\DebuggingHeader',
            'LogInfo' => '\\NexusDigital/MiratelForce\\StructType\\LogInfo',
            'DebuggingInfo' => '\\NexusDigital/MiratelForce\\StructType\\DebuggingInfo',
            'PackageVersion' => '\\NexusDigital/MiratelForce\\StructType\\PackageVersion',
            'PackageVersionHeader' => '\\NexusDigital/MiratelForce\\StructType\\PackageVersionHeader',
            'AllowFieldTruncationHeader' => '\\NexusDigital/MiratelForce\\StructType\\AllowFieldTruncationHeader',
            'DisableFeedTrackingHeader' => '\\NexusDigital/MiratelForce\\StructType\\DisableFeedTrackingHeader',
            'StreamingEnabledHeader' => '\\NexusDigital/MiratelForce\\StructType\\StreamingEnabledHeader',
            'AllOrNoneHeader' => '\\NexusDigital/MiratelForce\\StructType\\AllOrNoneHeader',
            'DuplicateRuleHeader' => '\\NexusDigital/MiratelForce\\StructType\\DuplicateRuleHeader',
            'LimitInfo' => '\\NexusDigital/MiratelForce\\StructType\\LimitInfo',
            'LimitInfoHeader' => '\\NexusDigital/MiratelForce\\StructType\\LimitInfoHeader',
            'MruHeader' => '\\NexusDigital/MiratelForce\\StructType\\MruHeader',
            'EmailHeader' => '\\NexusDigital/MiratelForce\\StructType\\EmailHeader',
            'AssignmentRuleHeader' => '\\NexusDigital/MiratelForce\\StructType\\AssignmentRuleHeader',
            'UserTerritoryDeleteHeader' => '\\NexusDigital/MiratelForce\\StructType\\UserTerritoryDeleteHeader',
            'LocaleOptions' => '\\NexusDigital/MiratelForce\\StructType\\LocaleOptions',
            'OwnerChangeOption' => '\\NexusDigital/MiratelForce\\StructType\\OwnerChangeOption',
            'OwnerChangeOptions' => '\\NexusDigital/MiratelForce\\StructType\\OwnerChangeOptions',
            'ApiFault' => '\\NexusDigital/MiratelForce\\StructType\\ApiFault',
            'ApiQueryFault' => '\\NexusDigital/MiratelForce\\StructType\\ApiQueryFault',
            'LoginFault' => '\\NexusDigital/MiratelForce\\StructType\\LoginFault',
            'InvalidQueryLocatorFault' => '\\NexusDigital/MiratelForce\\StructType\\InvalidQueryLocatorFault',
            'InvalidNewPasswordFault' => '\\NexusDigital/MiratelForce\\StructType\\InvalidNewPasswordFault',
            'InvalidOldPasswordFault' => '\\NexusDigital/MiratelForce\\StructType\\InvalidOldPasswordFault',
            'InvalidIdFault' => '\\NexusDigital/MiratelForce\\StructType\\InvalidIdFault',
            'UnexpectedErrorFault' => '\\NexusDigital/MiratelForce\\StructType\\UnexpectedErrorFault',
            'InvalidFieldFault' => '\\NexusDigital/MiratelForce\\StructType\\InvalidFieldFault',
            'InvalidSObjectFault' => '\\NexusDigital/MiratelForce\\StructType\\InvalidSObjectFault',
            'MalformedQueryFault' => '\\NexusDigital/MiratelForce\\StructType\\MalformedQueryFault',
            'MalformedSearchFault' => '\\NexusDigital/MiratelForce\\StructType\\MalformedSearchFault',
        );
    }
}
