<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \NexusDigital/MiratelForce\ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \NexusDigital/MiratelForce\ServiceType\Login($options);
$login->setSoapHeaderLoginScopeHeader(new \NexusDigital/MiratelForce\StructType\LoginScopeHeader());
/**
 * Sample call for login operation/method
 */
if ($login->login(new \NexusDigital/MiratelForce\StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Describe ServiceType
 */
$describe = new \NexusDigital/MiratelForce\ServiceType\Describe($options);
$describe->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$describe->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
$describe->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
/**
 * Sample call for describeSObject operation/method
 */
if ($describe->describeSObject(new \NexusDigital/MiratelForce\StructType\DescribeSObject()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSObjects operation/method
 */
if ($describe->describeSObjects(new \NexusDigital/MiratelForce\StructType\DescribeSObjects()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeGlobal operation/method
 */
if ($describe->describeGlobal(new \NexusDigital/MiratelForce\StructType\DescribeGlobal()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeDataCategoryGroups operation/method
 */
if ($describe->describeDataCategoryGroups(new \NexusDigital/MiratelForce\StructType\DescribeDataCategoryGroups()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeDataCategoryGroupStructures operation/method
 */
if ($describe->describeDataCategoryGroupStructures(new \NexusDigital/MiratelForce\StructType\DescribeDataCategoryGroupStructures()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeDataCategoryMappings operation/method
 */
if ($describe->describeDataCategoryMappings(new \NexusDigital/MiratelForce\StructType\DescribeDataCategoryMappings()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeKnowledgeSettings operation/method
 */
if ($describe->describeKnowledgeSettings(new \NexusDigital/MiratelForce\StructType\DescribeKnowledgeSettings()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeAppMenu operation/method
 */
if ($describe->describeAppMenu(new \NexusDigital/MiratelForce\StructType\DescribeAppMenu()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeGlobalTheme operation/method
 */
if ($describe->describeGlobalTheme(new \NexusDigital/MiratelForce\StructType\DescribeGlobalTheme_1()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeTheme operation/method
 */
if ($describe->describeTheme(new \NexusDigital/MiratelForce\StructType\DescribeTheme()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeLayout operation/method
 */
if ($describe->describeLayout(new \NexusDigital/MiratelForce\StructType\DescribeLayout_1()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSoftphoneLayout operation/method
 */
if ($describe->describeSoftphoneLayout(new \NexusDigital/MiratelForce\StructType\DescribeSoftphoneLayout()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSearchLayouts operation/method
 */
if ($describe->describeSearchLayouts(new \NexusDigital/MiratelForce\StructType\DescribeSearchLayouts()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSearchableEntities operation/method
 */
if ($describe->describeSearchableEntities(new \NexusDigital/MiratelForce\StructType\DescribeSearchableEntities()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSearchScopeOrder operation/method
 */
if ($describe->describeSearchScopeOrder(new \NexusDigital/MiratelForce\StructType\DescribeSearchScopeOrder()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeCompactLayouts operation/method
 */
if ($describe->describeCompactLayouts(new \NexusDigital/MiratelForce\StructType\DescribeCompactLayouts()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describePathAssistants operation/method
 */
if ($describe->describePathAssistants(new \NexusDigital/MiratelForce\StructType\DescribePathAssistants()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeApprovalLayout operation/method
 */
if ($describe->describeApprovalLayout(new \NexusDigital/MiratelForce\StructType\DescribeApprovalLayout_1()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSoqlListViews operation/method
 */
if ($describe->describeSoqlListViews(new \NexusDigital/MiratelForce\StructType\DescribeSoqlListViews()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeSObjectListViews operation/method
 */
if ($describe->describeSObjectListViews(new \NexusDigital/MiratelForce\StructType\DescribeSObjectListViews()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeTabs operation/method
 */
if ($describe->describeTabs(new \NexusDigital/MiratelForce\StructType\DescribeTabs()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeAllTabs operation/method
 */
if ($describe->describeAllTabs(new \NexusDigital/MiratelForce\StructType\DescribeAllTabs()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describePrimaryCompactLayouts operation/method
 */
if ($describe->describePrimaryCompactLayouts(new \NexusDigital/MiratelForce\StructType\DescribePrimaryCompactLayouts()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeQuickActions operation/method
 */
if ($describe->describeQuickActions(new \NexusDigital/MiratelForce\StructType\DescribeQuickActions()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeQuickActionsForRecordType operation/method
 */
if ($describe->describeQuickActionsForRecordType(new \NexusDigital/MiratelForce\StructType\DescribeQuickActionsForRecordType()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeAvailableQuickActions operation/method
 */
if ($describe->describeAvailableQuickActions(new \NexusDigital/MiratelForce\StructType\DescribeAvailableQuickActions()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeVisualForce operation/method
 */
if ($describe->describeVisualForce(new \NexusDigital/MiratelForce\StructType\DescribeVisualForce()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Sample call for describeNouns operation/method
 */
if ($describe->describeNouns(new \NexusDigital/MiratelForce\StructType\DescribeNouns()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Samples for Execute ServiceType
 */
$execute = new \NexusDigital/MiratelForce\ServiceType\Execute($options);
$execute->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$execute->setSoapHeaderMruHeader(new \NexusDigital/MiratelForce\StructType\MruHeader());
/**
 * Sample call for executeListView operation/method
 */
if ($execute->executeListView(new \NexusDigital/MiratelForce\StructType\ExecuteListView()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \NexusDigital/MiratelForce\ServiceType\Create($options);
$create->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$create->setSoapHeaderAssignmentRuleHeader(new \NexusDigital/MiratelForce\StructType\AssignmentRuleHeader());
$create->setSoapHeaderMruHeader(new \NexusDigital/MiratelForce\StructType\MruHeader());
$create->setSoapHeaderAllowFieldTruncationHeader(new \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader());
$create->setSoapHeaderDisableFeedTrackingHeader(new \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader());
$create->setSoapHeaderStreamingEnabledHeader(new \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader());
$create->setSoapHeaderAllOrNoneHeader(new \NexusDigital/MiratelForce\StructType\AllOrNoneHeader());
$create->setSoapHeaderDuplicateRuleHeader(new \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader());
$create->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
$create->setSoapHeaderDebuggingHeader(new \NexusDigital/MiratelForce\StructType\DebuggingHeader());
$create->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
$create->setSoapHeaderEmailHeader(new \NexusDigital/MiratelForce\StructType\EmailHeader());
/**
 * Sample call for create operation/method
 */
if ($create->create(new \NexusDigital/MiratelForce\StructType\Create()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \NexusDigital/MiratelForce\ServiceType\Update($options);
$update->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$update->setSoapHeaderAssignmentRuleHeader(new \NexusDigital/MiratelForce\StructType\AssignmentRuleHeader());
$update->setSoapHeaderMruHeader(new \NexusDigital/MiratelForce\StructType\MruHeader());
$update->setSoapHeaderAllowFieldTruncationHeader(new \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader());
$update->setSoapHeaderDisableFeedTrackingHeader(new \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader());
$update->setSoapHeaderStreamingEnabledHeader(new \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader());
$update->setSoapHeaderAllOrNoneHeader(new \NexusDigital/MiratelForce\StructType\AllOrNoneHeader());
$update->setSoapHeaderDuplicateRuleHeader(new \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader());
$update->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
$update->setSoapHeaderDebuggingHeader(new \NexusDigital/MiratelForce\StructType\DebuggingHeader());
$update->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
$update->setSoapHeaderEmailHeader(new \NexusDigital/MiratelForce\StructType\EmailHeader());
$update->setSoapHeaderOwnerChangeOptions(new \NexusDigital/MiratelForce\StructType\OwnerChangeOptions());
/**
 * Sample call for update operation/method
 */
if ($update->update(new \NexusDigital/MiratelForce\StructType\Update()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Upsert ServiceType
 */
$upsert = new \NexusDigital/MiratelForce\ServiceType\Upsert($options);
$upsert->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$upsert->setSoapHeaderAssignmentRuleHeader(new \NexusDigital/MiratelForce\StructType\AssignmentRuleHeader());
$upsert->setSoapHeaderMruHeader(new \NexusDigital/MiratelForce\StructType\MruHeader());
$upsert->setSoapHeaderAllowFieldTruncationHeader(new \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader());
$upsert->setSoapHeaderDisableFeedTrackingHeader(new \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader());
$upsert->setSoapHeaderStreamingEnabledHeader(new \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader());
$upsert->setSoapHeaderAllOrNoneHeader(new \NexusDigital/MiratelForce\StructType\AllOrNoneHeader());
$upsert->setSoapHeaderDuplicateRuleHeader(new \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader());
$upsert->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
$upsert->setSoapHeaderDebuggingHeader(new \NexusDigital/MiratelForce\StructType\DebuggingHeader());
$upsert->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
$upsert->setSoapHeaderEmailHeader(new \NexusDigital/MiratelForce\StructType\EmailHeader());
$upsert->setSoapHeaderOwnerChangeOptions(new \NexusDigital/MiratelForce\StructType\OwnerChangeOptions());
/**
 * Sample call for upsert operation/method
 */
if ($upsert->upsert(new \NexusDigital/MiratelForce\StructType\Upsert()) !== false) {
    print_r($upsert->getResult());
} else {
    print_r($upsert->getLastError());
}
/**
 * Samples for Merge ServiceType
 */
$merge = new \NexusDigital/MiratelForce\ServiceType\Merge($options);
$merge->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$merge->setSoapHeaderAssignmentRuleHeader(new \NexusDigital/MiratelForce\StructType\AssignmentRuleHeader());
$merge->setSoapHeaderMruHeader(new \NexusDigital/MiratelForce\StructType\MruHeader());
$merge->setSoapHeaderAllowFieldTruncationHeader(new \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader());
$merge->setSoapHeaderDisableFeedTrackingHeader(new \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader());
$merge->setSoapHeaderStreamingEnabledHeader(new \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader());
$merge->setSoapHeaderDuplicateRuleHeader(new \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader());
$merge->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
$merge->setSoapHeaderDebuggingHeader(new \NexusDigital/MiratelForce\StructType\DebuggingHeader());
$merge->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
$merge->setSoapHeaderEmailHeader(new \NexusDigital/MiratelForce\StructType\EmailHeader());
/**
 * Sample call for merge operation/method
 */
if ($merge->merge(new \NexusDigital/MiratelForce\StructType\Merge()) !== false) {
    print_r($merge->getResult());
} else {
    print_r($merge->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \NexusDigital/MiratelForce\ServiceType\Delete($options);
$delete->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$delete->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
$delete->setSoapHeaderUserTerritoryDeleteHeader(new \NexusDigital/MiratelForce\StructType\UserTerritoryDeleteHeader());
$delete->setSoapHeaderEmailHeader(new \NexusDigital/MiratelForce\StructType\EmailHeader());
$delete->setSoapHeaderAllowFieldTruncationHeader(new \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader());
$delete->setSoapHeaderDisableFeedTrackingHeader(new \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader());
$delete->setSoapHeaderStreamingEnabledHeader(new \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader());
$delete->setSoapHeaderAllOrNoneHeader(new \NexusDigital/MiratelForce\StructType\AllOrNoneHeader());
$delete->setSoapHeaderDuplicateRuleHeader(new \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader());
$delete->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
$delete->setSoapHeaderDebuggingHeader(new \NexusDigital/MiratelForce\StructType\DebuggingHeader());
/**
 * Sample call for delete operation/method
 */
if ($delete->delete(new \NexusDigital/MiratelForce\StructType\Delete()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteByExample operation/method
 */
if ($delete->deleteByExample(new \NexusDigital/MiratelForce\StructType\DeleteByExample()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Undelete ServiceType
 */
$undelete = new \NexusDigital/MiratelForce\ServiceType\Undelete($options);
$undelete->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$undelete->setSoapHeaderAllowFieldTruncationHeader(new \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader());
$undelete->setSoapHeaderDisableFeedTrackingHeader(new \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader());
$undelete->setSoapHeaderStreamingEnabledHeader(new \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader());
$undelete->setSoapHeaderAllOrNoneHeader(new \NexusDigital/MiratelForce\StructType\AllOrNoneHeader());
$undelete->setSoapHeaderDuplicateRuleHeader(new \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader());
$undelete->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
$undelete->setSoapHeaderDebuggingHeader(new \NexusDigital/MiratelForce\StructType\DebuggingHeader());
$undelete->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
/**
 * Sample call for undelete operation/method
 */
if ($undelete->undelete(new \NexusDigital/MiratelForce\StructType\Undelete()) !== false) {
    print_r($undelete->getResult());
} else {
    print_r($undelete->getLastError());
}
/**
 * Samples for Empty ServiceType
 */
$empty = new \NexusDigital/MiratelForce\ServiceType\_Empty($options);
$empty->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
/**
 * Sample call for emptyRecycleBin operation/method
 */
if ($empty->emptyRecycleBin(new \NexusDigital/MiratelForce\StructType\EmptyRecycleBin()) !== false) {
    print_r($empty->getResult());
} else {
    print_r($empty->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \NexusDigital/MiratelForce\ServiceType\Retrieve($options);
$retrieve->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$retrieve->setSoapHeaderQueryOptions(new \NexusDigital/MiratelForce\StructType\QueryOptions());
$retrieve->setSoapHeaderMruHeader(new \NexusDigital/MiratelForce\StructType\MruHeader());
$retrieve->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
$retrieve->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
/**
 * Sample call for retrieve operation/method
 */
if ($retrieve->retrieve(new \NexusDigital/MiratelForce\StructType\Retrieve()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for retrieveQuickActionTemplates operation/method
 */
if ($retrieve->retrieveQuickActionTemplates(new \NexusDigital/MiratelForce\StructType\RetrieveQuickActionTemplates()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for retrieveMassQuickActionTemplates operation/method
 */
if ($retrieve->retrieveMassQuickActionTemplates(new \NexusDigital/MiratelForce\StructType\RetrieveMassQuickActionTemplates()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Process ServiceType
 */
$process = new \NexusDigital/MiratelForce\ServiceType\Process($options);
$process->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$process->setSoapHeaderAllowFieldTruncationHeader(new \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader());
$process->setSoapHeaderDisableFeedTrackingHeader(new \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader());
$process->setSoapHeaderStreamingEnabledHeader(new \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader());
$process->setSoapHeaderDuplicateRuleHeader(new \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader());
$process->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
$process->setSoapHeaderDebuggingHeader(new \NexusDigital/MiratelForce\StructType\DebuggingHeader());
$process->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
/**
 * Sample call for process operation/method
 */
if ($process->process(new \NexusDigital/MiratelForce\StructType\Process()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \NexusDigital/MiratelForce\ServiceType\Convert($options);
$convert->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$convert->setSoapHeaderAllowFieldTruncationHeader(new \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader());
$convert->setSoapHeaderDisableFeedTrackingHeader(new \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader());
$convert->setSoapHeaderStreamingEnabledHeader(new \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader());
$convert->setSoapHeaderDuplicateRuleHeader(new \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader());
$convert->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
$convert->setSoapHeaderDebuggingHeader(new \NexusDigital/MiratelForce\StructType\DebuggingHeader());
$convert->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
/**
 * Sample call for convertLead operation/method
 */
if ($convert->convertLead(new \NexusDigital/MiratelForce\StructType\ConvertLead()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \NexusDigital/MiratelForce\ServiceType\Logout($options);
$logout->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
/**
 * Sample call for logout operation/method
 */
if ($logout->logout(new \NexusDigital/MiratelForce\StructType\Logout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Invalidate ServiceType
 */
$invalidate = new \NexusDigital/MiratelForce\ServiceType\Invalidate($options);
$invalidate->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
/**
 * Sample call for invalidateSessions operation/method
 */
if ($invalidate->invalidateSessions(new \NexusDigital/MiratelForce\StructType\InvalidateSessions()) !== false) {
    print_r($invalidate->getResult());
} else {
    print_r($invalidate->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \NexusDigital/MiratelForce\ServiceType\Get($options);
$get->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
/**
 * Sample call for getDeleted operation/method
 */
if ($get->getDeleted(new \NexusDigital/MiratelForce\StructType\GetDeleted()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUpdated operation/method
 */
if ($get->getUpdated(new \NexusDigital/MiratelForce\StructType\GetUpdated()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getServerTimestamp operation/method
 */
if ($get->getServerTimestamp(new \NexusDigital/MiratelForce\StructType\GetServerTimestamp()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserInfo operation/method
 */
if ($get->getUserInfo(new \NexusDigital/MiratelForce\StructType\GetUserInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \NexusDigital/MiratelForce\ServiceType\Query($options);
$query->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$query->setSoapHeaderQueryOptions(new \NexusDigital/MiratelForce\StructType\QueryOptions());
$query->setSoapHeaderMruHeader(new \NexusDigital/MiratelForce\StructType\MruHeader());
$query->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
/**
 * Sample call for query operation/method
 */
if ($query->query(new \NexusDigital/MiratelForce\StructType\Query()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryAll operation/method
 */
if ($query->queryAll(new \NexusDigital/MiratelForce\StructType\QueryAll()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for queryMore operation/method
 */
if ($query->queryMore(new \NexusDigital/MiratelForce\StructType\QueryMore()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \NexusDigital/MiratelForce\ServiceType\Search($options);
$search->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$search->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
/**
 * Sample call for search operation/method
 */
if ($search->search(new \NexusDigital/MiratelForce\StructType\Search()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \NexusDigital/MiratelForce\ServiceType\Set($options);
$set->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
/**
 * Sample call for setPassword operation/method
 */
if ($set->setPassword(new \NexusDigital/MiratelForce\StructType\SetPassword()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \NexusDigital/MiratelForce\ServiceType\Change($options);
$change->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
/**
 * Sample call for changeOwnPassword operation/method
 */
if ($change->changeOwnPassword(new \NexusDigital/MiratelForce\StructType\ChangeOwnPassword()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \NexusDigital/MiratelForce\ServiceType\Reset($options);
$reset->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$reset->setSoapHeaderEmailHeader(new \NexusDigital/MiratelForce\StructType\EmailHeader());
/**
 * Sample call for resetPassword operation/method
 */
if ($reset->resetPassword(new \NexusDigital/MiratelForce\StructType\ResetPassword()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \NexusDigital/MiratelForce\ServiceType\Send($options);
$send->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
/**
 * Sample call for sendEmailMessage operation/method
 */
if ($send->sendEmailMessage(new \NexusDigital/MiratelForce\StructType\SendEmailMessage()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendEmail operation/method
 */
if ($send->sendEmail(new \NexusDigital/MiratelForce\StructType\SendEmail()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Render ServiceType
 */
$render = new \NexusDigital/MiratelForce\ServiceType\Render($options);
$render->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
/**
 * Sample call for renderEmailTemplate operation/method
 */
if ($render->renderEmailTemplate(new \NexusDigital/MiratelForce\StructType\RenderEmailTemplate()) !== false) {
    print_r($render->getResult());
} else {
    print_r($render->getLastError());
}
/**
 * Sample call for renderStoredEmailTemplate operation/method
 */
if ($render->renderStoredEmailTemplate(new \NexusDigital/MiratelForce\StructType\RenderStoredEmailTemplate()) !== false) {
    print_r($render->getResult());
} else {
    print_r($render->getLastError());
}
/**
 * Samples for Perform ServiceType
 */
$perform = new \NexusDigital/MiratelForce\ServiceType\Perform($options);
$perform->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$perform->setSoapHeaderAssignmentRuleHeader(new \NexusDigital/MiratelForce\StructType\AssignmentRuleHeader());
$perform->setSoapHeaderMruHeader(new \NexusDigital/MiratelForce\StructType\MruHeader());
$perform->setSoapHeaderAllowFieldTruncationHeader(new \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader());
$perform->setSoapHeaderDisableFeedTrackingHeader(new \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader());
$perform->setSoapHeaderStreamingEnabledHeader(new \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader());
$perform->setSoapHeaderAllOrNoneHeader(new \NexusDigital/MiratelForce\StructType\AllOrNoneHeader());
$perform->setSoapHeaderDuplicateRuleHeader(new \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader());
$perform->setSoapHeaderLocaleOptions(new \NexusDigital/MiratelForce\StructType\LocaleOptions());
$perform->setSoapHeaderDebuggingHeader(new \NexusDigital/MiratelForce\StructType\DebuggingHeader());
$perform->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
$perform->setSoapHeaderEmailHeader(new \NexusDigital/MiratelForce\StructType\EmailHeader());
$perform->setSoapHeaderOwnerChangeOptions(new \NexusDigital/MiratelForce\StructType\OwnerChangeOptions());
/**
 * Sample call for performQuickActions operation/method
 */
if ($perform->performQuickActions(new \NexusDigital/MiratelForce\StructType\PerformQuickActions()) !== false) {
    print_r($perform->getResult());
} else {
    print_r($perform->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \NexusDigital/MiratelForce\ServiceType\Find($options);
$find->setSoapHeaderSessionHeader(new \NexusDigital/MiratelForce\StructType\SessionHeader());
$find->setSoapHeaderPackageVersionHeader(new \NexusDigital/MiratelForce\StructType\PackageVersionHeader());
$find->setSoapHeaderDuplicateRuleHeader(new \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader());
/**
 * Sample call for findDuplicates operation/method
 */
if ($find->findDuplicates(new \NexusDigital/MiratelForce\StructType\FindDuplicates()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findDuplicatesByIds operation/method
 */
if ($find->findDuplicatesByIds(new \NexusDigital/MiratelForce\StructType\FindDuplicatesByIds()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
