<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkOrderLineItem StructType
 * @subpackage Structs
 */
class WorkOrderLineItem extends SObject
{
    /**
     * The ActivityHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ActivityHistories;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Address
     */
    public $Address;
    /**
     * The Asset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Asset
     */
    public $Asset;
    /**
     * The AssetId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AssetId;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Attachments;
    /**
     * The ChildWorkOrderLineItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ChildWorkOrderLineItems;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DescendantWorkOrderLineItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $DescendantWorkOrderLineItems;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Discount;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Duration;
    /**
     * The DurationInMinutes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DurationInMinutes;
    /**
     * The DurationType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurationType;
    /**
     * The Emails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Emails;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The EventRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EventRelations;
    /**
     * The Events
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Events;
    /**
     * The FeedSubscriptionsForEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedSubscriptionsForEntity;
    /**
     * The Feeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Feeds;
    /**
     * The GeocodeAccuracy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GeocodeAccuracy;
    /**
     * The Histories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Histories;
    /**
     * The IsClosed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClosed;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastReferencedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastReferencedDate;
    /**
     * The LastViewedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastViewedDate;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Latitude;
    /**
     * The LineItemNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LineItemNumber;
    /**
     * The LinkedArticles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $LinkedArticles;
    /**
     * The ListPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ListPrice;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Longitude;
    /**
     * The LookedUpFromActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $LookedUpFromActivities;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Notes;
    /**
     * The NotesAndAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NotesAndAttachments;
    /**
     * The OpenActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $OpenActivities;
    /**
     * The Order
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Order
     */
    public $Order;
    /**
     * The OrderId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OrderId;
    /**
     * The ParentEntities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ParentEntities;
    /**
     * The ParentWorkOrderLineItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public $ParentWorkOrderLineItem;
    /**
     * The ParentWorkOrderLineItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentWorkOrderLineItemId;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostalCode;
    /**
     * The PricebookEntry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\PricebookEntry
     */
    public $PricebookEntry;
    /**
     * The PricebookEntryId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PricebookEntryId;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Priority;
    /**
     * The ProcessInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessInstances;
    /**
     * The ProcessSteps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessSteps;
    /**
     * The Product2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Product2
     */
    public $Product2;
    /**
     * The Product2Id
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $Product2Id;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The RecordActionHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActionHistories;
    /**
     * The RecordActions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActions;
    /**
     * The RootWorkOrderLineItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public $RootWorkOrderLineItem;
    /**
     * The RootWorkOrderLineItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RootWorkOrderLineItemId;
    /**
     * The ServiceAppointmentCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ServiceAppointmentCount;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The StatusCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCategory;
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Street;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Subject;
    /**
     * The Subtotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Subtotal;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TaskRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TaskRelations;
    /**
     * The Tasks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Tasks;
    /**
     * The TopicAssignments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TopicAssignments;
    /**
     * The TotalPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalPrice;
    /**
     * The UnitPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $UnitPrice;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * The WorkOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\WorkOrder
     */
    public $WorkOrder;
    /**
     * The WorkOrderId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $WorkOrderId;
    /**
     * Constructor method for WorkOrderLineItem
     * @uses WorkOrderLineItem::setActivityHistories()
     * @uses WorkOrderLineItem::setAddress()
     * @uses WorkOrderLineItem::setAsset()
     * @uses WorkOrderLineItem::setAssetId()
     * @uses WorkOrderLineItem::setAttachedContentDocuments()
     * @uses WorkOrderLineItem::setAttachedContentNotes()
     * @uses WorkOrderLineItem::setAttachments()
     * @uses WorkOrderLineItem::setChildWorkOrderLineItems()
     * @uses WorkOrderLineItem::setCity()
     * @uses WorkOrderLineItem::setCombinedAttachments()
     * @uses WorkOrderLineItem::setContentDocumentLinks()
     * @uses WorkOrderLineItem::setCountry()
     * @uses WorkOrderLineItem::setCreatedBy()
     * @uses WorkOrderLineItem::setCreatedById()
     * @uses WorkOrderLineItem::setCreatedDate()
     * @uses WorkOrderLineItem::setDescendantWorkOrderLineItems()
     * @uses WorkOrderLineItem::setDescription()
     * @uses WorkOrderLineItem::setDiscount()
     * @uses WorkOrderLineItem::setDuration()
     * @uses WorkOrderLineItem::setDurationInMinutes()
     * @uses WorkOrderLineItem::setDurationType()
     * @uses WorkOrderLineItem::setEmails()
     * @uses WorkOrderLineItem::setEndDate()
     * @uses WorkOrderLineItem::setEventRelations()
     * @uses WorkOrderLineItem::setEvents()
     * @uses WorkOrderLineItem::setFeedSubscriptionsForEntity()
     * @uses WorkOrderLineItem::setFeeds()
     * @uses WorkOrderLineItem::setGeocodeAccuracy()
     * @uses WorkOrderLineItem::setHistories()
     * @uses WorkOrderLineItem::setIsClosed()
     * @uses WorkOrderLineItem::setIsDeleted()
     * @uses WorkOrderLineItem::setLastModifiedBy()
     * @uses WorkOrderLineItem::setLastModifiedById()
     * @uses WorkOrderLineItem::setLastModifiedDate()
     * @uses WorkOrderLineItem::setLastReferencedDate()
     * @uses WorkOrderLineItem::setLastViewedDate()
     * @uses WorkOrderLineItem::setLatitude()
     * @uses WorkOrderLineItem::setLineItemNumber()
     * @uses WorkOrderLineItem::setLinkedArticles()
     * @uses WorkOrderLineItem::setListPrice()
     * @uses WorkOrderLineItem::setLongitude()
     * @uses WorkOrderLineItem::setLookedUpFromActivities()
     * @uses WorkOrderLineItem::setNotes()
     * @uses WorkOrderLineItem::setNotesAndAttachments()
     * @uses WorkOrderLineItem::setOpenActivities()
     * @uses WorkOrderLineItem::setOrder()
     * @uses WorkOrderLineItem::setOrderId()
     * @uses WorkOrderLineItem::setParentEntities()
     * @uses WorkOrderLineItem::setParentWorkOrderLineItem()
     * @uses WorkOrderLineItem::setParentWorkOrderLineItemId()
     * @uses WorkOrderLineItem::setPostalCode()
     * @uses WorkOrderLineItem::setPricebookEntry()
     * @uses WorkOrderLineItem::setPricebookEntryId()
     * @uses WorkOrderLineItem::setPriority()
     * @uses WorkOrderLineItem::setProcessInstances()
     * @uses WorkOrderLineItem::setProcessSteps()
     * @uses WorkOrderLineItem::setProduct2()
     * @uses WorkOrderLineItem::setProduct2Id()
     * @uses WorkOrderLineItem::setQuantity()
     * @uses WorkOrderLineItem::setRecordActionHistories()
     * @uses WorkOrderLineItem::setRecordActions()
     * @uses WorkOrderLineItem::setRootWorkOrderLineItem()
     * @uses WorkOrderLineItem::setRootWorkOrderLineItemId()
     * @uses WorkOrderLineItem::setServiceAppointmentCount()
     * @uses WorkOrderLineItem::setStartDate()
     * @uses WorkOrderLineItem::setState()
     * @uses WorkOrderLineItem::setStatus()
     * @uses WorkOrderLineItem::setStatusCategory()
     * @uses WorkOrderLineItem::setStreet()
     * @uses WorkOrderLineItem::setSubject()
     * @uses WorkOrderLineItem::setSubtotal()
     * @uses WorkOrderLineItem::setSystemModstamp()
     * @uses WorkOrderLineItem::setTaskRelations()
     * @uses WorkOrderLineItem::setTasks()
     * @uses WorkOrderLineItem::setTopicAssignments()
     * @uses WorkOrderLineItem::setTotalPrice()
     * @uses WorkOrderLineItem::setUnitPrice()
     * @uses WorkOrderLineItem::setUserRecordAccess()
     * @uses WorkOrderLineItem::setWorkOrder()
     * @uses WorkOrderLineItem::setWorkOrderId()
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $activityHistories
     * @param \NexusDigital/MiratelForce\StructType\Address $address
     * @param \NexusDigital/MiratelForce\StructType\Asset $asset
     * @param string $assetId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $childWorkOrderLineItems
     * @param string $city
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param string $country
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $descendantWorkOrderLineItems
     * @param string $description
     * @param float $discount
     * @param float $duration
     * @param float $durationInMinutes
     * @param string $durationType
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emails
     * @param string $endDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $events
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @param string $geocodeAccuracy
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @param bool $isClosed
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastReferencedDate
     * @param string $lastViewedDate
     * @param float $latitude
     * @param string $lineItemNumber
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles
     * @param float $listPrice
     * @param float $longitude
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $openActivities
     * @param \NexusDigital/MiratelForce\StructType\Order $order
     * @param string $orderId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @param \NexusDigital/MiratelForce\StructType\WorkOrderLineItem $parentWorkOrderLineItem
     * @param string $parentWorkOrderLineItemId
     * @param string $postalCode
     * @param \NexusDigital/MiratelForce\StructType\PricebookEntry $pricebookEntry
     * @param string $pricebookEntryId
     * @param string $priority
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @param \NexusDigital/MiratelForce\StructType\Product2 $product2
     * @param string $product2Id
     * @param float $quantity
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @param \NexusDigital/MiratelForce\StructType\WorkOrderLineItem $rootWorkOrderLineItem
     * @param string $rootWorkOrderLineItemId
     * @param int $serviceAppointmentCount
     * @param string $startDate
     * @param string $state
     * @param string $status
     * @param string $statusCategory
     * @param string $street
     * @param string $subject
     * @param float $subtotal
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $tasks
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @param float $totalPrice
     * @param float $unitPrice
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @param \NexusDigital/MiratelForce\StructType\WorkOrder $workOrder
     * @param string $workOrderId
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\QueryResult $activityHistories = null, \NexusDigital/MiratelForce\StructType\Address $address = null, \NexusDigital/MiratelForce\StructType\Asset $asset = null, $assetId = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $childWorkOrderLineItems = null, $city = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, $country = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $descendantWorkOrderLineItems = null, $description = null, $discount = null, $duration = null, $durationInMinutes = null, $durationType = null, \NexusDigital/MiratelForce\StructType\QueryResult $emails = null, $endDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $events = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null, \NexusDigital/MiratelForce\StructType\QueryResult $feeds = null, $geocodeAccuracy = null, \NexusDigital/MiratelForce\StructType\QueryResult $histories = null, $isClosed = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastReferencedDate = null, $lastViewedDate = null, $latitude = null, $lineItemNumber = null, \NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles = null, $listPrice = null, $longitude = null, \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities = null, \NexusDigital/MiratelForce\StructType\QueryResult $notes = null, \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $openActivities = null, \NexusDigital/MiratelForce\StructType\Order $order = null, $orderId = null, \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null, \NexusDigital/MiratelForce\StructType\WorkOrderLineItem $parentWorkOrderLineItem = null, $parentWorkOrderLineItemId = null, $postalCode = null, \NexusDigital/MiratelForce\StructType\PricebookEntry $pricebookEntry = null, $pricebookEntryId = null, $priority = null, \NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null, \NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null, \NexusDigital/MiratelForce\StructType\Product2 $product2 = null, $product2Id = null, $quantity = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null, \NexusDigital/MiratelForce\StructType\WorkOrderLineItem $rootWorkOrderLineItem = null, $rootWorkOrderLineItemId = null, $serviceAppointmentCount = null, $startDate = null, $state = null, $status = null, $statusCategory = null, $street = null, $subject = null, $subtotal = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations = null, \NexusDigital/MiratelForce\StructType\QueryResult $tasks = null, \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null, $totalPrice = null, $unitPrice = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null, \NexusDigital/MiratelForce\StructType\WorkOrder $workOrder = null, $workOrderId = null)
    {
        $this
            ->setActivityHistories($activityHistories)
            ->setAddress($address)
            ->setAsset($asset)
            ->setAssetId($assetId)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setAttachments($attachments)
            ->setChildWorkOrderLineItems($childWorkOrderLineItems)
            ->setCity($city)
            ->setCombinedAttachments($combinedAttachments)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCountry($country)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDescendantWorkOrderLineItems($descendantWorkOrderLineItems)
            ->setDescription($description)
            ->setDiscount($discount)
            ->setDuration($duration)
            ->setDurationInMinutes($durationInMinutes)
            ->setDurationType($durationType)
            ->setEmails($emails)
            ->setEndDate($endDate)
            ->setEventRelations($eventRelations)
            ->setEvents($events)
            ->setFeedSubscriptionsForEntity($feedSubscriptionsForEntity)
            ->setFeeds($feeds)
            ->setGeocodeAccuracy($geocodeAccuracy)
            ->setHistories($histories)
            ->setIsClosed($isClosed)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastReferencedDate($lastReferencedDate)
            ->setLastViewedDate($lastViewedDate)
            ->setLatitude($latitude)
            ->setLineItemNumber($lineItemNumber)
            ->setLinkedArticles($linkedArticles)
            ->setListPrice($listPrice)
            ->setLongitude($longitude)
            ->setLookedUpFromActivities($lookedUpFromActivities)
            ->setNotes($notes)
            ->setNotesAndAttachments($notesAndAttachments)
            ->setOpenActivities($openActivities)
            ->setOrder($order)
            ->setOrderId($orderId)
            ->setParentEntities($parentEntities)
            ->setParentWorkOrderLineItem($parentWorkOrderLineItem)
            ->setParentWorkOrderLineItemId($parentWorkOrderLineItemId)
            ->setPostalCode($postalCode)
            ->setPricebookEntry($pricebookEntry)
            ->setPricebookEntryId($pricebookEntryId)
            ->setPriority($priority)
            ->setProcessInstances($processInstances)
            ->setProcessSteps($processSteps)
            ->setProduct2($product2)
            ->setProduct2Id($product2Id)
            ->setQuantity($quantity)
            ->setRecordActionHistories($recordActionHistories)
            ->setRecordActions($recordActions)
            ->setRootWorkOrderLineItem($rootWorkOrderLineItem)
            ->setRootWorkOrderLineItemId($rootWorkOrderLineItemId)
            ->setServiceAppointmentCount($serviceAppointmentCount)
            ->setStartDate($startDate)
            ->setState($state)
            ->setStatus($status)
            ->setStatusCategory($statusCategory)
            ->setStreet($street)
            ->setSubject($subject)
            ->setSubtotal($subtotal)
            ->setSystemModstamp($systemModstamp)
            ->setTaskRelations($taskRelations)
            ->setTasks($tasks)
            ->setTopicAssignments($topicAssignments)
            ->setTotalPrice($totalPrice)
            ->setUnitPrice($unitPrice)
            ->setUserRecordAccess($userRecordAccess)
            ->setWorkOrder($workOrder)
            ->setWorkOrderId($workOrderId);
    }
    /**
     * Get ActivityHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getActivityHistories()
    {
        return isset($this->ActivityHistories) ? $this->ActivityHistories : null;
    }
    /**
     * Set ActivityHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $activityHistories
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setActivityHistories(\NexusDigital/MiratelForce\StructType\QueryResult $activityHistories = null)
    {
        if (is_null($activityHistories) || (is_array($activityHistories) && empty($activityHistories))) {
            unset($this->ActivityHistories);
        } else {
            $this->ActivityHistories = $activityHistories;
        }
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Address|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Address $address
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setAddress(\NexusDigital/MiratelForce\StructType\Address $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Asset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Asset|null
     */
    public function getAsset()
    {
        return isset($this->Asset) ? $this->Asset : null;
    }
    /**
     * Set Asset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Asset $asset
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setAsset(\NexusDigital/MiratelForce\StructType\Asset $asset = null)
    {
        if (is_null($asset) || (is_array($asset) && empty($asset))) {
            unset($this->Asset);
        } else {
            $this->Asset = $asset;
        }
        return $this;
    }
    /**
     * Get AssetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssetId()
    {
        return isset($this->AssetId) ? $this->AssetId : null;
    }
    /**
     * Set AssetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assetId
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setAssetId($assetId = null)
    {
        // validation for constraint: string
        if (!is_null($assetId) && !is_string($assetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assetId, true), gettype($assetId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($assetId) && mb_strlen($assetId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($assetId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($assetId) && !preg_match('/[a-zA-Z0-9]{18}/', $assetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($assetId, true)), __LINE__);
        }
        if (is_null($assetId) || (is_array($assetId) && empty($assetId))) {
            unset($this->AssetId);
        } else {
            $this->AssetId = $assetId;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get Attachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachments()
    {
        return isset($this->Attachments) ? $this->Attachments : null;
    }
    /**
     * Set Attachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $attachments = null)
    {
        if (is_null($attachments) || (is_array($attachments) && empty($attachments))) {
            unset($this->Attachments);
        } else {
            $this->Attachments = $attachments;
        }
        return $this;
    }
    /**
     * Get ChildWorkOrderLineItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getChildWorkOrderLineItems()
    {
        return isset($this->ChildWorkOrderLineItems) ? $this->ChildWorkOrderLineItems : null;
    }
    /**
     * Set ChildWorkOrderLineItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $childWorkOrderLineItems
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setChildWorkOrderLineItems(\NexusDigital/MiratelForce\StructType\QueryResult $childWorkOrderLineItems = null)
    {
        if (is_null($childWorkOrderLineItems) || (is_array($childWorkOrderLineItems) && empty($childWorkOrderLineItems))) {
            unset($this->ChildWorkOrderLineItems);
        } else {
            $this->ChildWorkOrderLineItems = $childWorkOrderLineItems;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DescendantWorkOrderLineItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getDescendantWorkOrderLineItems()
    {
        return isset($this->DescendantWorkOrderLineItems) ? $this->DescendantWorkOrderLineItems : null;
    }
    /**
     * Set DescendantWorkOrderLineItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $descendantWorkOrderLineItems
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setDescendantWorkOrderLineItems(\NexusDigital/MiratelForce\StructType\QueryResult $descendantWorkOrderLineItems = null)
    {
        if (is_null($descendantWorkOrderLineItems) || (is_array($descendantWorkOrderLineItems) && empty($descendantWorkOrderLineItems))) {
            unset($this->DescendantWorkOrderLineItems);
        } else {
            $this->DescendantWorkOrderLineItems = $descendantWorkOrderLineItems;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDiscount()
    {
        return isset($this->Discount) ? $this->Discount : null;
    }
    /**
     * Set Discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $discount
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        if (is_null($discount) || (is_array($discount) && empty($discount))) {
            unset($this->Discount);
        } else {
            $this->Discount = $discount;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $duration
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: float
        if (!is_null($duration) && !(is_float($duration) || is_numeric($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get DurationInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDurationInMinutes()
    {
        return isset($this->DurationInMinutes) ? $this->DurationInMinutes : null;
    }
    /**
     * Set DurationInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $durationInMinutes
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setDurationInMinutes($durationInMinutes = null)
    {
        // validation for constraint: float
        if (!is_null($durationInMinutes) && !(is_float($durationInMinutes) || is_numeric($durationInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durationInMinutes, true), gettype($durationInMinutes)), __LINE__);
        }
        if (is_null($durationInMinutes) || (is_array($durationInMinutes) && empty($durationInMinutes))) {
            unset($this->DurationInMinutes);
        } else {
            $this->DurationInMinutes = $durationInMinutes;
        }
        return $this;
    }
    /**
     * Get DurationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurationType()
    {
        return isset($this->DurationType) ? $this->DurationType : null;
    }
    /**
     * Set DurationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durationType
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setDurationType($durationType = null)
    {
        // validation for constraint: string
        if (!is_null($durationType) && !is_string($durationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durationType, true), gettype($durationType)), __LINE__);
        }
        if (is_null($durationType) || (is_array($durationType) && empty($durationType))) {
            unset($this->DurationType);
        } else {
            $this->DurationType = $durationType;
        }
        return $this;
    }
    /**
     * Get Emails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEmails()
    {
        return isset($this->Emails) ? $this->Emails : null;
    }
    /**
     * Set Emails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emails
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setEmails(\NexusDigital/MiratelForce\StructType\QueryResult $emails = null)
    {
        if (is_null($emails) || (is_array($emails) && empty($emails))) {
            unset($this->Emails);
        } else {
            $this->Emails = $emails;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get EventRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEventRelations()
    {
        return isset($this->EventRelations) ? $this->EventRelations : null;
    }
    /**
     * Set EventRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $eventRelations
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setEventRelations(\NexusDigital/MiratelForce\StructType\QueryResult $eventRelations = null)
    {
        if (is_null($eventRelations) || (is_array($eventRelations) && empty($eventRelations))) {
            unset($this->EventRelations);
        } else {
            $this->EventRelations = $eventRelations;
        }
        return $this;
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $events
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setEvents(\NexusDigital/MiratelForce\StructType\QueryResult $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get FeedSubscriptionsForEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedSubscriptionsForEntity()
    {
        return isset($this->FeedSubscriptionsForEntity) ? $this->FeedSubscriptionsForEntity : null;
    }
    /**
     * Set FeedSubscriptionsForEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setFeedSubscriptionsForEntity(\NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null)
    {
        if (is_null($feedSubscriptionsForEntity) || (is_array($feedSubscriptionsForEntity) && empty($feedSubscriptionsForEntity))) {
            unset($this->FeedSubscriptionsForEntity);
        } else {
            $this->FeedSubscriptionsForEntity = $feedSubscriptionsForEntity;
        }
        return $this;
    }
    /**
     * Get Feeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeeds()
    {
        return isset($this->Feeds) ? $this->Feeds : null;
    }
    /**
     * Set Feeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setFeeds(\NexusDigital/MiratelForce\StructType\QueryResult $feeds = null)
    {
        if (is_null($feeds) || (is_array($feeds) && empty($feeds))) {
            unset($this->Feeds);
        } else {
            $this->Feeds = $feeds;
        }
        return $this;
    }
    /**
     * Get GeocodeAccuracy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeocodeAccuracy()
    {
        return isset($this->GeocodeAccuracy) ? $this->GeocodeAccuracy : null;
    }
    /**
     * Set GeocodeAccuracy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geocodeAccuracy
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setGeocodeAccuracy($geocodeAccuracy = null)
    {
        // validation for constraint: string
        if (!is_null($geocodeAccuracy) && !is_string($geocodeAccuracy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geocodeAccuracy, true), gettype($geocodeAccuracy)), __LINE__);
        }
        if (is_null($geocodeAccuracy) || (is_array($geocodeAccuracy) && empty($geocodeAccuracy))) {
            unset($this->GeocodeAccuracy);
        } else {
            $this->GeocodeAccuracy = $geocodeAccuracy;
        }
        return $this;
    }
    /**
     * Get Histories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getHistories()
    {
        return isset($this->Histories) ? $this->Histories : null;
    }
    /**
     * Set Histories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setHistories(\NexusDigital/MiratelForce\StructType\QueryResult $histories = null)
    {
        if (is_null($histories) || (is_array($histories) && empty($histories))) {
            unset($this->Histories);
        } else {
            $this->Histories = $histories;
        }
        return $this;
    }
    /**
     * Get IsClosed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClosed()
    {
        return isset($this->IsClosed) ? $this->IsClosed : null;
    }
    /**
     * Set IsClosed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClosed
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        if (is_null($isClosed) || (is_array($isClosed) && empty($isClosed))) {
            unset($this->IsClosed);
        } else {
            $this->IsClosed = $isClosed;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastReferencedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastReferencedDate()
    {
        return isset($this->LastReferencedDate) ? $this->LastReferencedDate : null;
    }
    /**
     * Set LastReferencedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastReferencedDate
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setLastReferencedDate($lastReferencedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReferencedDate) && !is_string($lastReferencedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastReferencedDate, true), gettype($lastReferencedDate)), __LINE__);
        }
        if (is_null($lastReferencedDate) || (is_array($lastReferencedDate) && empty($lastReferencedDate))) {
            unset($this->LastReferencedDate);
        } else {
            $this->LastReferencedDate = $lastReferencedDate;
        }
        return $this;
    }
    /**
     * Get LastViewedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastViewedDate()
    {
        return isset($this->LastViewedDate) ? $this->LastViewedDate : null;
    }
    /**
     * Set LastViewedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastViewedDate
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setLastViewedDate($lastViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastViewedDate) && !is_string($lastViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastViewedDate, true), gettype($lastViewedDate)), __LINE__);
        }
        if (is_null($lastViewedDate) || (is_array($lastViewedDate) && empty($lastViewedDate))) {
            unset($this->LastViewedDate);
        } else {
            $this->LastViewedDate = $lastViewedDate;
        }
        return $this;
    }
    /**
     * Get Latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLatitude()
    {
        return isset($this->Latitude) ? $this->Latitude : null;
    }
    /**
     * Set Latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $latitude
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        if (is_null($latitude) || (is_array($latitude) && empty($latitude))) {
            unset($this->Latitude);
        } else {
            $this->Latitude = $latitude;
        }
        return $this;
    }
    /**
     * Get LineItemNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLineItemNumber()
    {
        return isset($this->LineItemNumber) ? $this->LineItemNumber : null;
    }
    /**
     * Set LineItemNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lineItemNumber
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setLineItemNumber($lineItemNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lineItemNumber) && !is_string($lineItemNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineItemNumber, true), gettype($lineItemNumber)), __LINE__);
        }
        if (is_null($lineItemNumber) || (is_array($lineItemNumber) && empty($lineItemNumber))) {
            unset($this->LineItemNumber);
        } else {
            $this->LineItemNumber = $lineItemNumber;
        }
        return $this;
    }
    /**
     * Get LinkedArticles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getLinkedArticles()
    {
        return isset($this->LinkedArticles) ? $this->LinkedArticles : null;
    }
    /**
     * Set LinkedArticles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setLinkedArticles(\NexusDigital/MiratelForce\StructType\QueryResult $linkedArticles = null)
    {
        if (is_null($linkedArticles) || (is_array($linkedArticles) && empty($linkedArticles))) {
            unset($this->LinkedArticles);
        } else {
            $this->LinkedArticles = $linkedArticles;
        }
        return $this;
    }
    /**
     * Get ListPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getListPrice()
    {
        return isset($this->ListPrice) ? $this->ListPrice : null;
    }
    /**
     * Set ListPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $listPrice
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setListPrice($listPrice = null)
    {
        // validation for constraint: float
        if (!is_null($listPrice) && !(is_float($listPrice) || is_numeric($listPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($listPrice, true), gettype($listPrice)), __LINE__);
        }
        if (is_null($listPrice) || (is_array($listPrice) && empty($listPrice))) {
            unset($this->ListPrice);
        } else {
            $this->ListPrice = $listPrice;
        }
        return $this;
    }
    /**
     * Get Longitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongitude()
    {
        return isset($this->Longitude) ? $this->Longitude : null;
    }
    /**
     * Set Longitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longitude
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        if (is_null($longitude) || (is_array($longitude) && empty($longitude))) {
            unset($this->Longitude);
        } else {
            $this->Longitude = $longitude;
        }
        return $this;
    }
    /**
     * Get LookedUpFromActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getLookedUpFromActivities()
    {
        return isset($this->LookedUpFromActivities) ? $this->LookedUpFromActivities : null;
    }
    /**
     * Set LookedUpFromActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setLookedUpFromActivities(\NexusDigital/MiratelForce\StructType\QueryResult $lookedUpFromActivities = null)
    {
        if (is_null($lookedUpFromActivities) || (is_array($lookedUpFromActivities) && empty($lookedUpFromActivities))) {
            unset($this->LookedUpFromActivities);
        } else {
            $this->LookedUpFromActivities = $lookedUpFromActivities;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notes
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setNotes(\NexusDigital/MiratelForce\StructType\QueryResult $notes = null)
    {
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get NotesAndAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNotesAndAttachments()
    {
        return isset($this->NotesAndAttachments) ? $this->NotesAndAttachments : null;
    }
    /**
     * Set NotesAndAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setNotesAndAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments = null)
    {
        if (is_null($notesAndAttachments) || (is_array($notesAndAttachments) && empty($notesAndAttachments))) {
            unset($this->NotesAndAttachments);
        } else {
            $this->NotesAndAttachments = $notesAndAttachments;
        }
        return $this;
    }
    /**
     * Get OpenActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getOpenActivities()
    {
        return isset($this->OpenActivities) ? $this->OpenActivities : null;
    }
    /**
     * Set OpenActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $openActivities
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setOpenActivities(\NexusDigital/MiratelForce\StructType\QueryResult $openActivities = null)
    {
        if (is_null($openActivities) || (is_array($openActivities) && empty($openActivities))) {
            unset($this->OpenActivities);
        } else {
            $this->OpenActivities = $openActivities;
        }
        return $this;
    }
    /**
     * Get Order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Order|null
     */
    public function getOrder()
    {
        return isset($this->Order) ? $this->Order : null;
    }
    /**
     * Set Order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Order $order
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setOrder(\NexusDigital/MiratelForce\StructType\Order $order = null)
    {
        if (is_null($order) || (is_array($order) && empty($order))) {
            unset($this->Order);
        } else {
            $this->Order = $order;
        }
        return $this;
    }
    /**
     * Get OrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderId()
    {
        return isset($this->OrderId) ? $this->OrderId : null;
    }
    /**
     * Set OrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderId
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($orderId) && mb_strlen($orderId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($orderId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($orderId) && !preg_match('/[a-zA-Z0-9]{18}/', $orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($orderId, true)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->OrderId);
        } else {
            $this->OrderId = $orderId;
        }
        return $this;
    }
    /**
     * Get ParentEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getParentEntities()
    {
        return isset($this->ParentEntities) ? $this->ParentEntities : null;
    }
    /**
     * Set ParentEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setParentEntities(\NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null)
    {
        if (is_null($parentEntities) || (is_array($parentEntities) && empty($parentEntities))) {
            unset($this->ParentEntities);
        } else {
            $this->ParentEntities = $parentEntities;
        }
        return $this;
    }
    /**
     * Get ParentWorkOrderLineItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem|null
     */
    public function getParentWorkOrderLineItem()
    {
        return isset($this->ParentWorkOrderLineItem) ? $this->ParentWorkOrderLineItem : null;
    }
    /**
     * Set ParentWorkOrderLineItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\WorkOrderLineItem $parentWorkOrderLineItem
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setParentWorkOrderLineItem(\NexusDigital/MiratelForce\StructType\WorkOrderLineItem $parentWorkOrderLineItem = null)
    {
        if (is_null($parentWorkOrderLineItem) || (is_array($parentWorkOrderLineItem) && empty($parentWorkOrderLineItem))) {
            unset($this->ParentWorkOrderLineItem);
        } else {
            $this->ParentWorkOrderLineItem = $parentWorkOrderLineItem;
        }
        return $this;
    }
    /**
     * Get ParentWorkOrderLineItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentWorkOrderLineItemId()
    {
        return isset($this->ParentWorkOrderLineItemId) ? $this->ParentWorkOrderLineItemId : null;
    }
    /**
     * Set ParentWorkOrderLineItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentWorkOrderLineItemId
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setParentWorkOrderLineItemId($parentWorkOrderLineItemId = null)
    {
        // validation for constraint: string
        if (!is_null($parentWorkOrderLineItemId) && !is_string($parentWorkOrderLineItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentWorkOrderLineItemId, true), gettype($parentWorkOrderLineItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentWorkOrderLineItemId) && mb_strlen($parentWorkOrderLineItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentWorkOrderLineItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentWorkOrderLineItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentWorkOrderLineItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentWorkOrderLineItemId, true)), __LINE__);
        }
        if (is_null($parentWorkOrderLineItemId) || (is_array($parentWorkOrderLineItemId) && empty($parentWorkOrderLineItemId))) {
            unset($this->ParentWorkOrderLineItemId);
        } else {
            $this->ParentWorkOrderLineItemId = $parentWorkOrderLineItemId;
        }
        return $this;
    }
    /**
     * Get PostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostalCode()
    {
        return isset($this->PostalCode) ? $this->PostalCode : null;
    }
    /**
     * Set PostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postalCode
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        if (is_null($postalCode) || (is_array($postalCode) && empty($postalCode))) {
            unset($this->PostalCode);
        } else {
            $this->PostalCode = $postalCode;
        }
        return $this;
    }
    /**
     * Get PricebookEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\PricebookEntry|null
     */
    public function getPricebookEntry()
    {
        return isset($this->PricebookEntry) ? $this->PricebookEntry : null;
    }
    /**
     * Set PricebookEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\PricebookEntry $pricebookEntry
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setPricebookEntry(\NexusDigital/MiratelForce\StructType\PricebookEntry $pricebookEntry = null)
    {
        if (is_null($pricebookEntry) || (is_array($pricebookEntry) && empty($pricebookEntry))) {
            unset($this->PricebookEntry);
        } else {
            $this->PricebookEntry = $pricebookEntry;
        }
        return $this;
    }
    /**
     * Get PricebookEntryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricebookEntryId()
    {
        return isset($this->PricebookEntryId) ? $this->PricebookEntryId : null;
    }
    /**
     * Set PricebookEntryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pricebookEntryId
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setPricebookEntryId($pricebookEntryId = null)
    {
        // validation for constraint: string
        if (!is_null($pricebookEntryId) && !is_string($pricebookEntryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricebookEntryId, true), gettype($pricebookEntryId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($pricebookEntryId) && mb_strlen($pricebookEntryId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($pricebookEntryId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($pricebookEntryId) && !preg_match('/[a-zA-Z0-9]{18}/', $pricebookEntryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($pricebookEntryId, true)), __LINE__);
        }
        if (is_null($pricebookEntryId) || (is_array($pricebookEntryId) && empty($pricebookEntryId))) {
            unset($this->PricebookEntryId);
        } else {
            $this->PricebookEntryId = $pricebookEntryId;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priority
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ProcessInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessInstances()
    {
        return isset($this->ProcessInstances) ? $this->ProcessInstances : null;
    }
    /**
     * Set ProcessInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setProcessInstances(\NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null)
    {
        if (is_null($processInstances) || (is_array($processInstances) && empty($processInstances))) {
            unset($this->ProcessInstances);
        } else {
            $this->ProcessInstances = $processInstances;
        }
        return $this;
    }
    /**
     * Get ProcessSteps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessSteps()
    {
        return isset($this->ProcessSteps) ? $this->ProcessSteps : null;
    }
    /**
     * Set ProcessSteps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setProcessSteps(\NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null)
    {
        if (is_null($processSteps) || (is_array($processSteps) && empty($processSteps))) {
            unset($this->ProcessSteps);
        } else {
            $this->ProcessSteps = $processSteps;
        }
        return $this;
    }
    /**
     * Get Product2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Product2|null
     */
    public function getProduct2()
    {
        return isset($this->Product2) ? $this->Product2 : null;
    }
    /**
     * Set Product2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Product2 $product2
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setProduct2(\NexusDigital/MiratelForce\StructType\Product2 $product2 = null)
    {
        if (is_null($product2) || (is_array($product2) && empty($product2))) {
            unset($this->Product2);
        } else {
            $this->Product2 = $product2;
        }
        return $this;
    }
    /**
     * Get Product2Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProduct2Id()
    {
        return isset($this->Product2Id) ? $this->Product2Id : null;
    }
    /**
     * Set Product2Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $product2Id
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setProduct2Id($product2Id = null)
    {
        // validation for constraint: string
        if (!is_null($product2Id) && !is_string($product2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product2Id, true), gettype($product2Id)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($product2Id) && mb_strlen($product2Id) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($product2Id)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($product2Id) && !preg_match('/[a-zA-Z0-9]{18}/', $product2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($product2Id, true)), __LINE__);
        }
        if (is_null($product2Id) || (is_array($product2Id) && empty($product2Id))) {
            unset($this->Product2Id);
        } else {
            $this->Product2Id = $product2Id;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantity
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RecordActionHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActionHistories()
    {
        return isset($this->RecordActionHistories) ? $this->RecordActionHistories : null;
    }
    /**
     * Set RecordActionHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setRecordActionHistories(\NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null)
    {
        if (is_null($recordActionHistories) || (is_array($recordActionHistories) && empty($recordActionHistories))) {
            unset($this->RecordActionHistories);
        } else {
            $this->RecordActionHistories = $recordActionHistories;
        }
        return $this;
    }
    /**
     * Get RecordActions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActions()
    {
        return isset($this->RecordActions) ? $this->RecordActions : null;
    }
    /**
     * Set RecordActions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setRecordActions(\NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null)
    {
        if (is_null($recordActions) || (is_array($recordActions) && empty($recordActions))) {
            unset($this->RecordActions);
        } else {
            $this->RecordActions = $recordActions;
        }
        return $this;
    }
    /**
     * Get RootWorkOrderLineItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem|null
     */
    public function getRootWorkOrderLineItem()
    {
        return isset($this->RootWorkOrderLineItem) ? $this->RootWorkOrderLineItem : null;
    }
    /**
     * Set RootWorkOrderLineItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\WorkOrderLineItem $rootWorkOrderLineItem
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setRootWorkOrderLineItem(\NexusDigital/MiratelForce\StructType\WorkOrderLineItem $rootWorkOrderLineItem = null)
    {
        if (is_null($rootWorkOrderLineItem) || (is_array($rootWorkOrderLineItem) && empty($rootWorkOrderLineItem))) {
            unset($this->RootWorkOrderLineItem);
        } else {
            $this->RootWorkOrderLineItem = $rootWorkOrderLineItem;
        }
        return $this;
    }
    /**
     * Get RootWorkOrderLineItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRootWorkOrderLineItemId()
    {
        return isset($this->RootWorkOrderLineItemId) ? $this->RootWorkOrderLineItemId : null;
    }
    /**
     * Set RootWorkOrderLineItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rootWorkOrderLineItemId
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setRootWorkOrderLineItemId($rootWorkOrderLineItemId = null)
    {
        // validation for constraint: string
        if (!is_null($rootWorkOrderLineItemId) && !is_string($rootWorkOrderLineItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rootWorkOrderLineItemId, true), gettype($rootWorkOrderLineItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($rootWorkOrderLineItemId) && mb_strlen($rootWorkOrderLineItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($rootWorkOrderLineItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($rootWorkOrderLineItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $rootWorkOrderLineItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($rootWorkOrderLineItemId, true)), __LINE__);
        }
        if (is_null($rootWorkOrderLineItemId) || (is_array($rootWorkOrderLineItemId) && empty($rootWorkOrderLineItemId))) {
            unset($this->RootWorkOrderLineItemId);
        } else {
            $this->RootWorkOrderLineItemId = $rootWorkOrderLineItemId;
        }
        return $this;
    }
    /**
     * Get ServiceAppointmentCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getServiceAppointmentCount()
    {
        return isset($this->ServiceAppointmentCount) ? $this->ServiceAppointmentCount : null;
    }
    /**
     * Set ServiceAppointmentCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $serviceAppointmentCount
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setServiceAppointmentCount($serviceAppointmentCount = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAppointmentCount) && !(is_int($serviceAppointmentCount) || ctype_digit($serviceAppointmentCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceAppointmentCount, true), gettype($serviceAppointmentCount)), __LINE__);
        }
        if (is_null($serviceAppointmentCount) || (is_array($serviceAppointmentCount) && empty($serviceAppointmentCount))) {
            unset($this->ServiceAppointmentCount);
        } else {
            $this->ServiceAppointmentCount = $serviceAppointmentCount;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StatusCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCategory()
    {
        return isset($this->StatusCategory) ? $this->StatusCategory : null;
    }
    /**
     * Set StatusCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCategory
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setStatusCategory($statusCategory = null)
    {
        // validation for constraint: string
        if (!is_null($statusCategory) && !is_string($statusCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCategory, true), gettype($statusCategory)), __LINE__);
        }
        if (is_null($statusCategory) || (is_array($statusCategory) && empty($statusCategory))) {
            unset($this->StatusCategory);
        } else {
            $this->StatusCategory = $statusCategory;
        }
        return $this;
    }
    /**
     * Get Street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->Street) ? $this->Street : null;
    }
    /**
     * Set Street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->Street);
        } else {
            $this->Street = $street;
        }
        return $this;
    }
    /**
     * Get Subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubject()
    {
        return isset($this->Subject) ? $this->Subject : null;
    }
    /**
     * Set Subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subject
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->Subject);
        } else {
            $this->Subject = $subject;
        }
        return $this;
    }
    /**
     * Get Subtotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSubtotal()
    {
        return isset($this->Subtotal) ? $this->Subtotal : null;
    }
    /**
     * Set Subtotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $subtotal
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setSubtotal($subtotal = null)
    {
        // validation for constraint: float
        if (!is_null($subtotal) && !(is_float($subtotal) || is_numeric($subtotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subtotal, true), gettype($subtotal)), __LINE__);
        }
        if (is_null($subtotal) || (is_array($subtotal) && empty($subtotal))) {
            unset($this->Subtotal);
        } else {
            $this->Subtotal = $subtotal;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TaskRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTaskRelations()
    {
        return isset($this->TaskRelations) ? $this->TaskRelations : null;
    }
    /**
     * Set TaskRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $taskRelations
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setTaskRelations(\NexusDigital/MiratelForce\StructType\QueryResult $taskRelations = null)
    {
        if (is_null($taskRelations) || (is_array($taskRelations) && empty($taskRelations))) {
            unset($this->TaskRelations);
        } else {
            $this->TaskRelations = $taskRelations;
        }
        return $this;
    }
    /**
     * Get Tasks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTasks()
    {
        return isset($this->Tasks) ? $this->Tasks : null;
    }
    /**
     * Set Tasks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $tasks
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setTasks(\NexusDigital/MiratelForce\StructType\QueryResult $tasks = null)
    {
        if (is_null($tasks) || (is_array($tasks) && empty($tasks))) {
            unset($this->Tasks);
        } else {
            $this->Tasks = $tasks;
        }
        return $this;
    }
    /**
     * Get TopicAssignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTopicAssignments()
    {
        return isset($this->TopicAssignments) ? $this->TopicAssignments : null;
    }
    /**
     * Set TopicAssignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setTopicAssignments(\NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null)
    {
        if (is_null($topicAssignments) || (is_array($topicAssignments) && empty($topicAssignments))) {
            unset($this->TopicAssignments);
        } else {
            $this->TopicAssignments = $topicAssignments;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalPrice
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $unitPrice
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Get WorkOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\WorkOrder|null
     */
    public function getWorkOrder()
    {
        return isset($this->WorkOrder) ? $this->WorkOrder : null;
    }
    /**
     * Set WorkOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\WorkOrder $workOrder
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setWorkOrder(\NexusDigital/MiratelForce\StructType\WorkOrder $workOrder = null)
    {
        if (is_null($workOrder) || (is_array($workOrder) && empty($workOrder))) {
            unset($this->WorkOrder);
        } else {
            $this->WorkOrder = $workOrder;
        }
        return $this;
    }
    /**
     * Get WorkOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkOrderId()
    {
        return isset($this->WorkOrderId) ? $this->WorkOrderId : null;
    }
    /**
     * Set WorkOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workOrderId
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public function setWorkOrderId($workOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($workOrderId) && !is_string($workOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workOrderId, true), gettype($workOrderId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($workOrderId) && mb_strlen($workOrderId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($workOrderId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($workOrderId) && !preg_match('/[a-zA-Z0-9]{18}/', $workOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($workOrderId, true)), __LINE__);
        }
        if (is_null($workOrderId) || (is_array($workOrderId) && empty($workOrderId))) {
            unset($this->WorkOrderId);
        } else {
            $this->WorkOrderId = $workOrderId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\WorkOrderLineItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
