<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserAppMenuItem StructType
 * @subpackage Structs
 */
class UserAppMenuItem extends SObject
{
    /**
     * The AppMenuItemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AppMenuItemId;
    /**
     * The ApplicationId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApplicationId;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IconUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IconUrl;
    /**
     * The InfoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InfoUrl;
    /**
     * The IsUsingAdminAuthorization
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUsingAdminAuthorization;
    /**
     * The IsVisible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisible;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The LogoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogoUrl;
    /**
     * The MobileStartUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileStartUrl;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SortOrder;
    /**
     * The StartUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartUrl;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The UserSortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UserSortOrder;
    /**
     * Constructor method for UserAppMenuItem
     * @uses UserAppMenuItem::setAppMenuItemId()
     * @uses UserAppMenuItem::setApplicationId()
     * @uses UserAppMenuItem::setDescription()
     * @uses UserAppMenuItem::setIconUrl()
     * @uses UserAppMenuItem::setInfoUrl()
     * @uses UserAppMenuItem::setIsUsingAdminAuthorization()
     * @uses UserAppMenuItem::setIsVisible()
     * @uses UserAppMenuItem::setLabel()
     * @uses UserAppMenuItem::setLogoUrl()
     * @uses UserAppMenuItem::setMobileStartUrl()
     * @uses UserAppMenuItem::setName()
     * @uses UserAppMenuItem::setSortOrder()
     * @uses UserAppMenuItem::setStartUrl()
     * @uses UserAppMenuItem::setType()
     * @uses UserAppMenuItem::setUserSortOrder()
     * @param string $appMenuItemId
     * @param string $applicationId
     * @param string $description
     * @param string $iconUrl
     * @param string $infoUrl
     * @param bool $isUsingAdminAuthorization
     * @param bool $isVisible
     * @param string $label
     * @param string $logoUrl
     * @param string $mobileStartUrl
     * @param string $name
     * @param int $sortOrder
     * @param string $startUrl
     * @param string $type
     * @param int $userSortOrder
     */
    public function __construct($appMenuItemId = null, $applicationId = null, $description = null, $iconUrl = null, $infoUrl = null, $isUsingAdminAuthorization = null, $isVisible = null, $label = null, $logoUrl = null, $mobileStartUrl = null, $name = null, $sortOrder = null, $startUrl = null, $type = null, $userSortOrder = null)
    {
        $this
            ->setAppMenuItemId($appMenuItemId)
            ->setApplicationId($applicationId)
            ->setDescription($description)
            ->setIconUrl($iconUrl)
            ->setInfoUrl($infoUrl)
            ->setIsUsingAdminAuthorization($isUsingAdminAuthorization)
            ->setIsVisible($isVisible)
            ->setLabel($label)
            ->setLogoUrl($logoUrl)
            ->setMobileStartUrl($mobileStartUrl)
            ->setName($name)
            ->setSortOrder($sortOrder)
            ->setStartUrl($startUrl)
            ->setType($type)
            ->setUserSortOrder($userSortOrder);
    }
    /**
     * Get AppMenuItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppMenuItemId()
    {
        return isset($this->AppMenuItemId) ? $this->AppMenuItemId : null;
    }
    /**
     * Set AppMenuItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appMenuItemId
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setAppMenuItemId($appMenuItemId = null)
    {
        // validation for constraint: string
        if (!is_null($appMenuItemId) && !is_string($appMenuItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appMenuItemId, true), gettype($appMenuItemId)), __LINE__);
        }
        if (is_null($appMenuItemId) || (is_array($appMenuItemId) && empty($appMenuItemId))) {
            unset($this->AppMenuItemId);
        } else {
            $this->AppMenuItemId = $appMenuItemId;
        }
        return $this;
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationId
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($applicationId) && mb_strlen($applicationId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($applicationId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($applicationId) && !preg_match('/[a-zA-Z0-9]{18}/', $applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($applicationId, true)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IconUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIconUrl()
    {
        return isset($this->IconUrl) ? $this->IconUrl : null;
    }
    /**
     * Set IconUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iconUrl
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setIconUrl($iconUrl = null)
    {
        // validation for constraint: string
        if (!is_null($iconUrl) && !is_string($iconUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iconUrl, true), gettype($iconUrl)), __LINE__);
        }
        if (is_null($iconUrl) || (is_array($iconUrl) && empty($iconUrl))) {
            unset($this->IconUrl);
        } else {
            $this->IconUrl = $iconUrl;
        }
        return $this;
    }
    /**
     * Get InfoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfoUrl()
    {
        return isset($this->InfoUrl) ? $this->InfoUrl : null;
    }
    /**
     * Set InfoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $infoUrl
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setInfoUrl($infoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($infoUrl) && !is_string($infoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoUrl, true), gettype($infoUrl)), __LINE__);
        }
        if (is_null($infoUrl) || (is_array($infoUrl) && empty($infoUrl))) {
            unset($this->InfoUrl);
        } else {
            $this->InfoUrl = $infoUrl;
        }
        return $this;
    }
    /**
     * Get IsUsingAdminAuthorization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUsingAdminAuthorization()
    {
        return isset($this->IsUsingAdminAuthorization) ? $this->IsUsingAdminAuthorization : null;
    }
    /**
     * Set IsUsingAdminAuthorization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUsingAdminAuthorization
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setIsUsingAdminAuthorization($isUsingAdminAuthorization = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUsingAdminAuthorization) && !is_bool($isUsingAdminAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUsingAdminAuthorization, true), gettype($isUsingAdminAuthorization)), __LINE__);
        }
        if (is_null($isUsingAdminAuthorization) || (is_array($isUsingAdminAuthorization) && empty($isUsingAdminAuthorization))) {
            unset($this->IsUsingAdminAuthorization);
        } else {
            $this->IsUsingAdminAuthorization = $isUsingAdminAuthorization;
        }
        return $this;
    }
    /**
     * Get IsVisible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisible()
    {
        return isset($this->IsVisible) ? $this->IsVisible : null;
    }
    /**
     * Set IsVisible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisible
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setIsVisible($isVisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisible) && !is_bool($isVisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisible, true), gettype($isVisible)), __LINE__);
        }
        if (is_null($isVisible) || (is_array($isVisible) && empty($isVisible))) {
            unset($this->IsVisible);
        } else {
            $this->IsVisible = $isVisible;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get LogoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogoUrl()
    {
        return isset($this->LogoUrl) ? $this->LogoUrl : null;
    }
    /**
     * Set LogoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logoUrl
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setLogoUrl($logoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($logoUrl) && !is_string($logoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoUrl, true), gettype($logoUrl)), __LINE__);
        }
        if (is_null($logoUrl) || (is_array($logoUrl) && empty($logoUrl))) {
            unset($this->LogoUrl);
        } else {
            $this->LogoUrl = $logoUrl;
        }
        return $this;
    }
    /**
     * Get MobileStartUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileStartUrl()
    {
        return isset($this->MobileStartUrl) ? $this->MobileStartUrl : null;
    }
    /**
     * Set MobileStartUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileStartUrl
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setMobileStartUrl($mobileStartUrl = null)
    {
        // validation for constraint: string
        if (!is_null($mobileStartUrl) && !is_string($mobileStartUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileStartUrl, true), gettype($mobileStartUrl)), __LINE__);
        }
        if (is_null($mobileStartUrl) || (is_array($mobileStartUrl) && empty($mobileStartUrl))) {
            unset($this->MobileStartUrl);
        } else {
            $this->MobileStartUrl = $mobileStartUrl;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SortOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSortOrder()
    {
        return isset($this->SortOrder) ? $this->SortOrder : null;
    }
    /**
     * Set SortOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sortOrder
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !(is_int($sortOrder) || ctype_digit($sortOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sortOrder, true), gettype($sortOrder)), __LINE__);
        }
        if (is_null($sortOrder) || (is_array($sortOrder) && empty($sortOrder))) {
            unset($this->SortOrder);
        } else {
            $this->SortOrder = $sortOrder;
        }
        return $this;
    }
    /**
     * Get StartUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartUrl()
    {
        return isset($this->StartUrl) ? $this->StartUrl : null;
    }
    /**
     * Set StartUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startUrl
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setStartUrl($startUrl = null)
    {
        // validation for constraint: string
        if (!is_null($startUrl) && !is_string($startUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startUrl, true), gettype($startUrl)), __LINE__);
        }
        if (is_null($startUrl) || (is_array($startUrl) && empty($startUrl))) {
            unset($this->StartUrl);
        } else {
            $this->StartUrl = $startUrl;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UserSortOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserSortOrder()
    {
        return isset($this->UserSortOrder) ? $this->UserSortOrder : null;
    }
    /**
     * Set UserSortOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userSortOrder
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public function setUserSortOrder($userSortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($userSortOrder) && !(is_int($userSortOrder) || ctype_digit($userSortOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userSortOrder, true), gettype($userSortOrder)), __LINE__);
        }
        if (is_null($userSortOrder) || (is_array($userSortOrder) && empty($userSortOrder))) {
            unset($this->UserSortOrder);
        } else {
            $this->UserSortOrder = $userSortOrder;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\UserAppMenuItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
