<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Topic StructType
 * @subpackage Structs
 */
class Topic extends SObject
{
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CustomBrands
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CustomBrands;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The FeedSubscriptionsForEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedSubscriptionsForEntity;
    /**
     * The Feeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Feeds;
    /**
     * The ManagedTopicType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ManagedTopicType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NetworkId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $NetworkId;
    /**
     * The ParentEntities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ParentEntities;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TalkingAbout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TalkingAbout;
    /**
     * The TopicAssignments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TopicAssignments;
    /**
     * Constructor method for Topic
     * @uses Topic::setContentDocumentLinks()
     * @uses Topic::setCreatedBy()
     * @uses Topic::setCreatedById()
     * @uses Topic::setCreatedDate()
     * @uses Topic::setCustomBrands()
     * @uses Topic::setDescription()
     * @uses Topic::setFeedSubscriptionsForEntity()
     * @uses Topic::setFeeds()
     * @uses Topic::setManagedTopicType()
     * @uses Topic::setName()
     * @uses Topic::setNetworkId()
     * @uses Topic::setParentEntities()
     * @uses Topic::setSystemModstamp()
     * @uses Topic::setTalkingAbout()
     * @uses Topic::setTopicAssignments()
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $customBrands
     * @param string $description
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @param string $managedTopicType
     * @param string $name
     * @param string $networkId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @param string $systemModstamp
     * @param int $talkingAbout
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $customBrands = null, $description = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null, \NexusDigital/MiratelForce\StructType\QueryResult $feeds = null, $managedTopicType = null, $name = null, $networkId = null, \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null, $systemModstamp = null, $talkingAbout = null, \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null)
    {
        $this
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCustomBrands($customBrands)
            ->setDescription($description)
            ->setFeedSubscriptionsForEntity($feedSubscriptionsForEntity)
            ->setFeeds($feeds)
            ->setManagedTopicType($managedTopicType)
            ->setName($name)
            ->setNetworkId($networkId)
            ->setParentEntities($parentEntities)
            ->setSystemModstamp($systemModstamp)
            ->setTalkingAbout($talkingAbout)
            ->setTopicAssignments($topicAssignments);
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CustomBrands value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCustomBrands()
    {
        return isset($this->CustomBrands) ? $this->CustomBrands : null;
    }
    /**
     * Set CustomBrands value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $customBrands
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setCustomBrands(\NexusDigital/MiratelForce\StructType\QueryResult $customBrands = null)
    {
        if (is_null($customBrands) || (is_array($customBrands) && empty($customBrands))) {
            unset($this->CustomBrands);
        } else {
            $this->CustomBrands = $customBrands;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FeedSubscriptionsForEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedSubscriptionsForEntity()
    {
        return isset($this->FeedSubscriptionsForEntity) ? $this->FeedSubscriptionsForEntity : null;
    }
    /**
     * Set FeedSubscriptionsForEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setFeedSubscriptionsForEntity(\NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null)
    {
        if (is_null($feedSubscriptionsForEntity) || (is_array($feedSubscriptionsForEntity) && empty($feedSubscriptionsForEntity))) {
            unset($this->FeedSubscriptionsForEntity);
        } else {
            $this->FeedSubscriptionsForEntity = $feedSubscriptionsForEntity;
        }
        return $this;
    }
    /**
     * Get Feeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeeds()
    {
        return isset($this->Feeds) ? $this->Feeds : null;
    }
    /**
     * Set Feeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setFeeds(\NexusDigital/MiratelForce\StructType\QueryResult $feeds = null)
    {
        if (is_null($feeds) || (is_array($feeds) && empty($feeds))) {
            unset($this->Feeds);
        } else {
            $this->Feeds = $feeds;
        }
        return $this;
    }
    /**
     * Get ManagedTopicType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManagedTopicType()
    {
        return isset($this->ManagedTopicType) ? $this->ManagedTopicType : null;
    }
    /**
     * Set ManagedTopicType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $managedTopicType
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setManagedTopicType($managedTopicType = null)
    {
        // validation for constraint: string
        if (!is_null($managedTopicType) && !is_string($managedTopicType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($managedTopicType, true), gettype($managedTopicType)), __LINE__);
        }
        if (is_null($managedTopicType) || (is_array($managedTopicType) && empty($managedTopicType))) {
            unset($this->ManagedTopicType);
        } else {
            $this->ManagedTopicType = $managedTopicType;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NetworkId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkId()
    {
        return isset($this->NetworkId) ? $this->NetworkId : null;
    }
    /**
     * Set NetworkId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkId
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setNetworkId($networkId = null)
    {
        // validation for constraint: string
        if (!is_null($networkId) && !is_string($networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkId, true), gettype($networkId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($networkId) && mb_strlen($networkId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($networkId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($networkId) && !preg_match('/[a-zA-Z0-9]{18}/', $networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($networkId, true)), __LINE__);
        }
        if (is_null($networkId) || (is_array($networkId) && empty($networkId))) {
            unset($this->NetworkId);
        } else {
            $this->NetworkId = $networkId;
        }
        return $this;
    }
    /**
     * Get ParentEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getParentEntities()
    {
        return isset($this->ParentEntities) ? $this->ParentEntities : null;
    }
    /**
     * Set ParentEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setParentEntities(\NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null)
    {
        if (is_null($parentEntities) || (is_array($parentEntities) && empty($parentEntities))) {
            unset($this->ParentEntities);
        } else {
            $this->ParentEntities = $parentEntities;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TalkingAbout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTalkingAbout()
    {
        return isset($this->TalkingAbout) ? $this->TalkingAbout : null;
    }
    /**
     * Set TalkingAbout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $talkingAbout
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setTalkingAbout($talkingAbout = null)
    {
        // validation for constraint: int
        if (!is_null($talkingAbout) && !(is_int($talkingAbout) || ctype_digit($talkingAbout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($talkingAbout, true), gettype($talkingAbout)), __LINE__);
        }
        if (is_null($talkingAbout) || (is_array($talkingAbout) && empty($talkingAbout))) {
            unset($this->TalkingAbout);
        } else {
            $this->TalkingAbout = $talkingAbout;
        }
        return $this;
    }
    /**
     * Get TopicAssignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTopicAssignments()
    {
        return isset($this->TopicAssignments) ? $this->TopicAssignments : null;
    }
    /**
     * Set TopicAssignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public function setTopicAssignments(\NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null)
    {
        if (is_null($topicAssignments) || (is_array($topicAssignments) && empty($topicAssignments))) {
            unset($this->TopicAssignments);
        } else {
            $this->TopicAssignments = $topicAssignments;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Topic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
