<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SocialPersona StructType
 * @subpackage Structs
 */
class SocialPersona extends SObject
{
    /**
     * The AreWeFollowing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AreWeFollowing;
    /**
     * The AuthorLabels
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorLabels;
    /**
     * The AvatarUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AvatarUrl;
    /**
     * The Bio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Bio;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ExternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The ExternalPictureURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalPictureURL;
    /**
     * The Followers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Followers;
    /**
     * The Following
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Following;
    /**
     * The Histories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Histories;
    /**
     * The InfluencerScore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InfluencerScore;
    /**
     * The IsBlacklisted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBlacklisted;
    /**
     * The IsDefault
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefault;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsFollowingUs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFollowingUs;
    /**
     * The IsVerified
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVerified;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastReferencedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastReferencedDate;
    /**
     * The LastViewedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastViewedDate;
    /**
     * The ListedCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ListedCount;
    /**
     * The MediaProvider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MediaProvider;
    /**
     * The MediaType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MediaType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NumberOfFriends
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfFriends;
    /**
     * The NumberOfTweets
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfTweets;
    /**
     * The Parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Parent;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The Posts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Posts;
    /**
     * The ProfileType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProfileType;
    /**
     * The ProfileUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProfileUrl;
    /**
     * The Provider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * The R6SourceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $R6SourceId;
    /**
     * The RealName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RealName;
    /**
     * The RecordActionHistories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActionHistories;
    /**
     * The RecordActions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $RecordActions;
    /**
     * The SourceApp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceApp;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TopicType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TopicType;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * Constructor method for SocialPersona
     * @uses SocialPersona::setAreWeFollowing()
     * @uses SocialPersona::setAuthorLabels()
     * @uses SocialPersona::setAvatarUrl()
     * @uses SocialPersona::setBio()
     * @uses SocialPersona::setCreatedBy()
     * @uses SocialPersona::setCreatedById()
     * @uses SocialPersona::setCreatedDate()
     * @uses SocialPersona::setExternalId()
     * @uses SocialPersona::setExternalPictureURL()
     * @uses SocialPersona::setFollowers()
     * @uses SocialPersona::setFollowing()
     * @uses SocialPersona::setHistories()
     * @uses SocialPersona::setInfluencerScore()
     * @uses SocialPersona::setIsBlacklisted()
     * @uses SocialPersona::setIsDefault()
     * @uses SocialPersona::setIsDeleted()
     * @uses SocialPersona::setIsFollowingUs()
     * @uses SocialPersona::setIsVerified()
     * @uses SocialPersona::setLastModifiedBy()
     * @uses SocialPersona::setLastModifiedById()
     * @uses SocialPersona::setLastModifiedDate()
     * @uses SocialPersona::setLastReferencedDate()
     * @uses SocialPersona::setLastViewedDate()
     * @uses SocialPersona::setListedCount()
     * @uses SocialPersona::setMediaProvider()
     * @uses SocialPersona::setMediaType()
     * @uses SocialPersona::setName()
     * @uses SocialPersona::setNumberOfFriends()
     * @uses SocialPersona::setNumberOfTweets()
     * @uses SocialPersona::setParent()
     * @uses SocialPersona::setParentId()
     * @uses SocialPersona::setPosts()
     * @uses SocialPersona::setProfileType()
     * @uses SocialPersona::setProfileUrl()
     * @uses SocialPersona::setProvider()
     * @uses SocialPersona::setR6SourceId()
     * @uses SocialPersona::setRealName()
     * @uses SocialPersona::setRecordActionHistories()
     * @uses SocialPersona::setRecordActions()
     * @uses SocialPersona::setSourceApp()
     * @uses SocialPersona::setSystemModstamp()
     * @uses SocialPersona::setTopicType()
     * @uses SocialPersona::setUserRecordAccess()
     * @param bool $areWeFollowing
     * @param string $authorLabels
     * @param string $avatarUrl
     * @param string $bio
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $externalId
     * @param string $externalPictureURL
     * @param int $followers
     * @param int $following
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @param int $influencerScore
     * @param bool $isBlacklisted
     * @param bool $isDefault
     * @param bool $isDeleted
     * @param bool $isFollowingUs
     * @param bool $isVerified
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastReferencedDate
     * @param string $lastViewedDate
     * @param int $listedCount
     * @param string $mediaProvider
     * @param string $mediaType
     * @param string $name
     * @param int $numberOfFriends
     * @param int $numberOfTweets
     * @param \NexusDigital/MiratelForce\StructType\SObject $parent
     * @param string $parentId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $posts
     * @param string $profileType
     * @param string $profileUrl
     * @param string $provider
     * @param string $r6SourceId
     * @param string $realName
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @param string $sourceApp
     * @param string $systemModstamp
     * @param string $topicType
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     */
    public function __construct($areWeFollowing = null, $authorLabels = null, $avatarUrl = null, $bio = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $externalId = null, $externalPictureURL = null, $followers = null, $following = null, \NexusDigital/MiratelForce\StructType\QueryResult $histories = null, $influencerScore = null, $isBlacklisted = null, $isDefault = null, $isDeleted = null, $isFollowingUs = null, $isVerified = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastReferencedDate = null, $lastViewedDate = null, $listedCount = null, $mediaProvider = null, $mediaType = null, $name = null, $numberOfFriends = null, $numberOfTweets = null, \NexusDigital/MiratelForce\StructType\SObject $parent = null, $parentId = null, \NexusDigital/MiratelForce\StructType\QueryResult $posts = null, $profileType = null, $profileUrl = null, $provider = null, $r6SourceId = null, $realName = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null, \NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null, $sourceApp = null, $systemModstamp = null, $topicType = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        $this
            ->setAreWeFollowing($areWeFollowing)
            ->setAuthorLabels($authorLabels)
            ->setAvatarUrl($avatarUrl)
            ->setBio($bio)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setExternalId($externalId)
            ->setExternalPictureURL($externalPictureURL)
            ->setFollowers($followers)
            ->setFollowing($following)
            ->setHistories($histories)
            ->setInfluencerScore($influencerScore)
            ->setIsBlacklisted($isBlacklisted)
            ->setIsDefault($isDefault)
            ->setIsDeleted($isDeleted)
            ->setIsFollowingUs($isFollowingUs)
            ->setIsVerified($isVerified)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastReferencedDate($lastReferencedDate)
            ->setLastViewedDate($lastViewedDate)
            ->setListedCount($listedCount)
            ->setMediaProvider($mediaProvider)
            ->setMediaType($mediaType)
            ->setName($name)
            ->setNumberOfFriends($numberOfFriends)
            ->setNumberOfTweets($numberOfTweets)
            ->setParent($parent)
            ->setParentId($parentId)
            ->setPosts($posts)
            ->setProfileType($profileType)
            ->setProfileUrl($profileUrl)
            ->setProvider($provider)
            ->setR6SourceId($r6SourceId)
            ->setRealName($realName)
            ->setRecordActionHistories($recordActionHistories)
            ->setRecordActions($recordActions)
            ->setSourceApp($sourceApp)
            ->setSystemModstamp($systemModstamp)
            ->setTopicType($topicType)
            ->setUserRecordAccess($userRecordAccess);
    }
    /**
     * Get AreWeFollowing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAreWeFollowing()
    {
        return isset($this->AreWeFollowing) ? $this->AreWeFollowing : null;
    }
    /**
     * Set AreWeFollowing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $areWeFollowing
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setAreWeFollowing($areWeFollowing = null)
    {
        // validation for constraint: boolean
        if (!is_null($areWeFollowing) && !is_bool($areWeFollowing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($areWeFollowing, true), gettype($areWeFollowing)), __LINE__);
        }
        if (is_null($areWeFollowing) || (is_array($areWeFollowing) && empty($areWeFollowing))) {
            unset($this->AreWeFollowing);
        } else {
            $this->AreWeFollowing = $areWeFollowing;
        }
        return $this;
    }
    /**
     * Get AuthorLabels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorLabels()
    {
        return isset($this->AuthorLabels) ? $this->AuthorLabels : null;
    }
    /**
     * Set AuthorLabels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorLabels
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setAuthorLabels($authorLabels = null)
    {
        // validation for constraint: string
        if (!is_null($authorLabels) && !is_string($authorLabels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorLabels, true), gettype($authorLabels)), __LINE__);
        }
        if (is_null($authorLabels) || (is_array($authorLabels) && empty($authorLabels))) {
            unset($this->AuthorLabels);
        } else {
            $this->AuthorLabels = $authorLabels;
        }
        return $this;
    }
    /**
     * Get AvatarUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvatarUrl()
    {
        return isset($this->AvatarUrl) ? $this->AvatarUrl : null;
    }
    /**
     * Set AvatarUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $avatarUrl
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setAvatarUrl($avatarUrl = null)
    {
        // validation for constraint: string
        if (!is_null($avatarUrl) && !is_string($avatarUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avatarUrl, true), gettype($avatarUrl)), __LINE__);
        }
        if (is_null($avatarUrl) || (is_array($avatarUrl) && empty($avatarUrl))) {
            unset($this->AvatarUrl);
        } else {
            $this->AvatarUrl = $avatarUrl;
        }
        return $this;
    }
    /**
     * Get Bio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBio()
    {
        return isset($this->Bio) ? $this->Bio : null;
    }
    /**
     * Set Bio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bio
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setBio($bio = null)
    {
        // validation for constraint: string
        if (!is_null($bio) && !is_string($bio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bio, true), gettype($bio)), __LINE__);
        }
        if (is_null($bio) || (is_array($bio) && empty($bio))) {
            unset($this->Bio);
        } else {
            $this->Bio = $bio;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get ExternalPictureURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalPictureURL()
    {
        return isset($this->ExternalPictureURL) ? $this->ExternalPictureURL : null;
    }
    /**
     * Set ExternalPictureURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalPictureURL
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setExternalPictureURL($externalPictureURL = null)
    {
        // validation for constraint: string
        if (!is_null($externalPictureURL) && !is_string($externalPictureURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalPictureURL, true), gettype($externalPictureURL)), __LINE__);
        }
        if (is_null($externalPictureURL) || (is_array($externalPictureURL) && empty($externalPictureURL))) {
            unset($this->ExternalPictureURL);
        } else {
            $this->ExternalPictureURL = $externalPictureURL;
        }
        return $this;
    }
    /**
     * Get Followers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFollowers()
    {
        return isset($this->Followers) ? $this->Followers : null;
    }
    /**
     * Set Followers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $followers
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setFollowers($followers = null)
    {
        // validation for constraint: int
        if (!is_null($followers) && !(is_int($followers) || ctype_digit($followers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($followers, true), gettype($followers)), __LINE__);
        }
        if (is_null($followers) || (is_array($followers) && empty($followers))) {
            unset($this->Followers);
        } else {
            $this->Followers = $followers;
        }
        return $this;
    }
    /**
     * Get Following value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFollowing()
    {
        return isset($this->Following) ? $this->Following : null;
    }
    /**
     * Set Following value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $following
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setFollowing($following = null)
    {
        // validation for constraint: int
        if (!is_null($following) && !(is_int($following) || ctype_digit($following))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($following, true), gettype($following)), __LINE__);
        }
        if (is_null($following) || (is_array($following) && empty($following))) {
            unset($this->Following);
        } else {
            $this->Following = $following;
        }
        return $this;
    }
    /**
     * Get Histories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getHistories()
    {
        return isset($this->Histories) ? $this->Histories : null;
    }
    /**
     * Set Histories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setHistories(\NexusDigital/MiratelForce\StructType\QueryResult $histories = null)
    {
        if (is_null($histories) || (is_array($histories) && empty($histories))) {
            unset($this->Histories);
        } else {
            $this->Histories = $histories;
        }
        return $this;
    }
    /**
     * Get InfluencerScore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInfluencerScore()
    {
        return isset($this->InfluencerScore) ? $this->InfluencerScore : null;
    }
    /**
     * Set InfluencerScore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $influencerScore
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setInfluencerScore($influencerScore = null)
    {
        // validation for constraint: int
        if (!is_null($influencerScore) && !(is_int($influencerScore) || ctype_digit($influencerScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($influencerScore, true), gettype($influencerScore)), __LINE__);
        }
        if (is_null($influencerScore) || (is_array($influencerScore) && empty($influencerScore))) {
            unset($this->InfluencerScore);
        } else {
            $this->InfluencerScore = $influencerScore;
        }
        return $this;
    }
    /**
     * Get IsBlacklisted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBlacklisted()
    {
        return isset($this->IsBlacklisted) ? $this->IsBlacklisted : null;
    }
    /**
     * Set IsBlacklisted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBlacklisted
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setIsBlacklisted($isBlacklisted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBlacklisted) && !is_bool($isBlacklisted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBlacklisted, true), gettype($isBlacklisted)), __LINE__);
        }
        if (is_null($isBlacklisted) || (is_array($isBlacklisted) && empty($isBlacklisted))) {
            unset($this->IsBlacklisted);
        } else {
            $this->IsBlacklisted = $isBlacklisted;
        }
        return $this;
    }
    /**
     * Get IsDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefault()
    {
        return isset($this->IsDefault) ? $this->IsDefault : null;
    }
    /**
     * Set IsDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefault
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        if (is_null($isDefault) || (is_array($isDefault) && empty($isDefault))) {
            unset($this->IsDefault);
        } else {
            $this->IsDefault = $isDefault;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsFollowingUs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFollowingUs()
    {
        return isset($this->IsFollowingUs) ? $this->IsFollowingUs : null;
    }
    /**
     * Set IsFollowingUs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFollowingUs
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setIsFollowingUs($isFollowingUs = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFollowingUs) && !is_bool($isFollowingUs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFollowingUs, true), gettype($isFollowingUs)), __LINE__);
        }
        if (is_null($isFollowingUs) || (is_array($isFollowingUs) && empty($isFollowingUs))) {
            unset($this->IsFollowingUs);
        } else {
            $this->IsFollowingUs = $isFollowingUs;
        }
        return $this;
    }
    /**
     * Get IsVerified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVerified()
    {
        return isset($this->IsVerified) ? $this->IsVerified : null;
    }
    /**
     * Set IsVerified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVerified
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setIsVerified($isVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerified) && !is_bool($isVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerified, true), gettype($isVerified)), __LINE__);
        }
        if (is_null($isVerified) || (is_array($isVerified) && empty($isVerified))) {
            unset($this->IsVerified);
        } else {
            $this->IsVerified = $isVerified;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastReferencedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastReferencedDate()
    {
        return isset($this->LastReferencedDate) ? $this->LastReferencedDate : null;
    }
    /**
     * Set LastReferencedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastReferencedDate
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setLastReferencedDate($lastReferencedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastReferencedDate) && !is_string($lastReferencedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastReferencedDate, true), gettype($lastReferencedDate)), __LINE__);
        }
        if (is_null($lastReferencedDate) || (is_array($lastReferencedDate) && empty($lastReferencedDate))) {
            unset($this->LastReferencedDate);
        } else {
            $this->LastReferencedDate = $lastReferencedDate;
        }
        return $this;
    }
    /**
     * Get LastViewedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastViewedDate()
    {
        return isset($this->LastViewedDate) ? $this->LastViewedDate : null;
    }
    /**
     * Set LastViewedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastViewedDate
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setLastViewedDate($lastViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastViewedDate) && !is_string($lastViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastViewedDate, true), gettype($lastViewedDate)), __LINE__);
        }
        if (is_null($lastViewedDate) || (is_array($lastViewedDate) && empty($lastViewedDate))) {
            unset($this->LastViewedDate);
        } else {
            $this->LastViewedDate = $lastViewedDate;
        }
        return $this;
    }
    /**
     * Get ListedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getListedCount()
    {
        return isset($this->ListedCount) ? $this->ListedCount : null;
    }
    /**
     * Set ListedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $listedCount
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setListedCount($listedCount = null)
    {
        // validation for constraint: int
        if (!is_null($listedCount) && !(is_int($listedCount) || ctype_digit($listedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listedCount, true), gettype($listedCount)), __LINE__);
        }
        if (is_null($listedCount) || (is_array($listedCount) && empty($listedCount))) {
            unset($this->ListedCount);
        } else {
            $this->ListedCount = $listedCount;
        }
        return $this;
    }
    /**
     * Get MediaProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMediaProvider()
    {
        return isset($this->MediaProvider) ? $this->MediaProvider : null;
    }
    /**
     * Set MediaProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mediaProvider
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setMediaProvider($mediaProvider = null)
    {
        // validation for constraint: string
        if (!is_null($mediaProvider) && !is_string($mediaProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediaProvider, true), gettype($mediaProvider)), __LINE__);
        }
        if (is_null($mediaProvider) || (is_array($mediaProvider) && empty($mediaProvider))) {
            unset($this->MediaProvider);
        } else {
            $this->MediaProvider = $mediaProvider;
        }
        return $this;
    }
    /**
     * Get MediaType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMediaType()
    {
        return isset($this->MediaType) ? $this->MediaType : null;
    }
    /**
     * Set MediaType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mediaType
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setMediaType($mediaType = null)
    {
        // validation for constraint: string
        if (!is_null($mediaType) && !is_string($mediaType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediaType, true), gettype($mediaType)), __LINE__);
        }
        if (is_null($mediaType) || (is_array($mediaType) && empty($mediaType))) {
            unset($this->MediaType);
        } else {
            $this->MediaType = $mediaType;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumberOfFriends value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfFriends()
    {
        return isset($this->NumberOfFriends) ? $this->NumberOfFriends : null;
    }
    /**
     * Set NumberOfFriends value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfFriends
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setNumberOfFriends($numberOfFriends = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfFriends) && !(is_int($numberOfFriends) || ctype_digit($numberOfFriends))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfFriends, true), gettype($numberOfFriends)), __LINE__);
        }
        if (is_null($numberOfFriends) || (is_array($numberOfFriends) && empty($numberOfFriends))) {
            unset($this->NumberOfFriends);
        } else {
            $this->NumberOfFriends = $numberOfFriends;
        }
        return $this;
    }
    /**
     * Get NumberOfTweets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfTweets()
    {
        return isset($this->NumberOfTweets) ? $this->NumberOfTweets : null;
    }
    /**
     * Set NumberOfTweets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfTweets
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setNumberOfTweets($numberOfTweets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTweets) && !(is_int($numberOfTweets) || ctype_digit($numberOfTweets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfTweets, true), gettype($numberOfTweets)), __LINE__);
        }
        if (is_null($numberOfTweets) || (is_array($numberOfTweets) && empty($numberOfTweets))) {
            unset($this->NumberOfTweets);
        } else {
            $this->NumberOfTweets = $numberOfTweets;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $parent
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setParent(\NexusDigital/MiratelForce\StructType\SObject $parent = null)
    {
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get Posts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getPosts()
    {
        return isset($this->Posts) ? $this->Posts : null;
    }
    /**
     * Set Posts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $posts
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setPosts(\NexusDigital/MiratelForce\StructType\QueryResult $posts = null)
    {
        if (is_null($posts) || (is_array($posts) && empty($posts))) {
            unset($this->Posts);
        } else {
            $this->Posts = $posts;
        }
        return $this;
    }
    /**
     * Get ProfileType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfileType()
    {
        return isset($this->ProfileType) ? $this->ProfileType : null;
    }
    /**
     * Set ProfileType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profileType
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: string
        if (!is_null($profileType) && !is_string($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileType, true), gettype($profileType)), __LINE__);
        }
        if (is_null($profileType) || (is_array($profileType) && empty($profileType))) {
            unset($this->ProfileType);
        } else {
            $this->ProfileType = $profileType;
        }
        return $this;
    }
    /**
     * Get ProfileUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfileUrl()
    {
        return isset($this->ProfileUrl) ? $this->ProfileUrl : null;
    }
    /**
     * Set ProfileUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profileUrl
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setProfileUrl($profileUrl = null)
    {
        // validation for constraint: string
        if (!is_null($profileUrl) && !is_string($profileUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileUrl, true), gettype($profileUrl)), __LINE__);
        }
        if (is_null($profileUrl) || (is_array($profileUrl) && empty($profileUrl))) {
            unset($this->ProfileUrl);
        } else {
            $this->ProfileUrl = $profileUrl;
        }
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
    /**
     * Get R6SourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getR6SourceId()
    {
        return isset($this->R6SourceId) ? $this->R6SourceId : null;
    }
    /**
     * Set R6SourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $r6SourceId
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setR6SourceId($r6SourceId = null)
    {
        // validation for constraint: string
        if (!is_null($r6SourceId) && !is_string($r6SourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($r6SourceId, true), gettype($r6SourceId)), __LINE__);
        }
        if (is_null($r6SourceId) || (is_array($r6SourceId) && empty($r6SourceId))) {
            unset($this->R6SourceId);
        } else {
            $this->R6SourceId = $r6SourceId;
        }
        return $this;
    }
    /**
     * Get RealName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRealName()
    {
        return isset($this->RealName) ? $this->RealName : null;
    }
    /**
     * Set RealName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $realName
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setRealName($realName = null)
    {
        // validation for constraint: string
        if (!is_null($realName) && !is_string($realName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($realName, true), gettype($realName)), __LINE__);
        }
        if (is_null($realName) || (is_array($realName) && empty($realName))) {
            unset($this->RealName);
        } else {
            $this->RealName = $realName;
        }
        return $this;
    }
    /**
     * Get RecordActionHistories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActionHistories()
    {
        return isset($this->RecordActionHistories) ? $this->RecordActionHistories : null;
    }
    /**
     * Set RecordActionHistories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setRecordActionHistories(\NexusDigital/MiratelForce\StructType\QueryResult $recordActionHistories = null)
    {
        if (is_null($recordActionHistories) || (is_array($recordActionHistories) && empty($recordActionHistories))) {
            unset($this->RecordActionHistories);
        } else {
            $this->RecordActionHistories = $recordActionHistories;
        }
        return $this;
    }
    /**
     * Get RecordActions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getRecordActions()
    {
        return isset($this->RecordActions) ? $this->RecordActions : null;
    }
    /**
     * Set RecordActions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $recordActions
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setRecordActions(\NexusDigital/MiratelForce\StructType\QueryResult $recordActions = null)
    {
        if (is_null($recordActions) || (is_array($recordActions) && empty($recordActions))) {
            unset($this->RecordActions);
        } else {
            $this->RecordActions = $recordActions;
        }
        return $this;
    }
    /**
     * Get SourceApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceApp()
    {
        return isset($this->SourceApp) ? $this->SourceApp : null;
    }
    /**
     * Set SourceApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceApp
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setSourceApp($sourceApp = null)
    {
        // validation for constraint: string
        if (!is_null($sourceApp) && !is_string($sourceApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceApp, true), gettype($sourceApp)), __LINE__);
        }
        if (is_null($sourceApp) || (is_array($sourceApp) && empty($sourceApp))) {
            unset($this->SourceApp);
        } else {
            $this->SourceApp = $sourceApp;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TopicType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTopicType()
    {
        return isset($this->TopicType) ? $this->TopicType : null;
    }
    /**
     * Set TopicType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $topicType
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setTopicType($topicType = null)
    {
        // validation for constraint: string
        if (!is_null($topicType) && !is_string($topicType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($topicType, true), gettype($topicType)), __LINE__);
        }
        if (is_null($topicType) || (is_array($topicType) && empty($topicType))) {
            unset($this->TopicType);
        } else {
            $this->TopicType = $topicType;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\SocialPersona
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
