<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetupAuditTrail StructType
 * @subpackage Structs
 */
class SetupAuditTrail extends SObject
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedByContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedByContext;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedByIssuer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedByIssuer;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DelegateUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DelegateUser;
    /**
     * The Display
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Display;
    /**
     * The ResponsibleNamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponsibleNamespacePrefix;
    /**
     * The Section
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Section;
    /**
     * Constructor method for SetupAuditTrail
     * @uses SetupAuditTrail::setAction()
     * @uses SetupAuditTrail::setCreatedBy()
     * @uses SetupAuditTrail::setCreatedByContext()
     * @uses SetupAuditTrail::setCreatedById()
     * @uses SetupAuditTrail::setCreatedByIssuer()
     * @uses SetupAuditTrail::setCreatedDate()
     * @uses SetupAuditTrail::setDelegateUser()
     * @uses SetupAuditTrail::setDisplay()
     * @uses SetupAuditTrail::setResponsibleNamespacePrefix()
     * @uses SetupAuditTrail::setSection()
     * @param string $action
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdByContext
     * @param string $createdById
     * @param string $createdByIssuer
     * @param string $createdDate
     * @param string $delegateUser
     * @param string $display
     * @param string $responsibleNamespacePrefix
     * @param string $section
     */
    public function __construct($action = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdByContext = null, $createdById = null, $createdByIssuer = null, $createdDate = null, $delegateUser = null, $display = null, $responsibleNamespacePrefix = null, $section = null)
    {
        $this
            ->setAction($action)
            ->setCreatedBy($createdBy)
            ->setCreatedByContext($createdByContext)
            ->setCreatedById($createdById)
            ->setCreatedByIssuer($createdByIssuer)
            ->setCreatedDate($createdDate)
            ->setDelegateUser($delegateUser)
            ->setDisplay($display)
            ->setResponsibleNamespacePrefix($responsibleNamespacePrefix)
            ->setSection($section);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $action
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedByContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedByContext()
    {
        return isset($this->CreatedByContext) ? $this->CreatedByContext : null;
    }
    /**
     * Set CreatedByContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdByContext
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public function setCreatedByContext($createdByContext = null)
    {
        // validation for constraint: string
        if (!is_null($createdByContext) && !is_string($createdByContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByContext, true), gettype($createdByContext)), __LINE__);
        }
        if (is_null($createdByContext) || (is_array($createdByContext) && empty($createdByContext))) {
            unset($this->CreatedByContext);
        } else {
            $this->CreatedByContext = $createdByContext;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedByIssuer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedByIssuer()
    {
        return isset($this->CreatedByIssuer) ? $this->CreatedByIssuer : null;
    }
    /**
     * Set CreatedByIssuer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdByIssuer
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public function setCreatedByIssuer($createdByIssuer = null)
    {
        // validation for constraint: string
        if (!is_null($createdByIssuer) && !is_string($createdByIssuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByIssuer, true), gettype($createdByIssuer)), __LINE__);
        }
        if (is_null($createdByIssuer) || (is_array($createdByIssuer) && empty($createdByIssuer))) {
            unset($this->CreatedByIssuer);
        } else {
            $this->CreatedByIssuer = $createdByIssuer;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DelegateUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDelegateUser()
    {
        return isset($this->DelegateUser) ? $this->DelegateUser : null;
    }
    /**
     * Set DelegateUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $delegateUser
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public function setDelegateUser($delegateUser = null)
    {
        // validation for constraint: string
        if (!is_null($delegateUser) && !is_string($delegateUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delegateUser, true), gettype($delegateUser)), __LINE__);
        }
        if (is_null($delegateUser) || (is_array($delegateUser) && empty($delegateUser))) {
            unset($this->DelegateUser);
        } else {
            $this->DelegateUser = $delegateUser;
        }
        return $this;
    }
    /**
     * Get Display value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplay()
    {
        return isset($this->Display) ? $this->Display : null;
    }
    /**
     * Set Display value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $display
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($display, true), gettype($display)), __LINE__);
        }
        if (is_null($display) || (is_array($display) && empty($display))) {
            unset($this->Display);
        } else {
            $this->Display = $display;
        }
        return $this;
    }
    /**
     * Get ResponsibleNamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponsibleNamespacePrefix()
    {
        return isset($this->ResponsibleNamespacePrefix) ? $this->ResponsibleNamespacePrefix : null;
    }
    /**
     * Set ResponsibleNamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responsibleNamespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public function setResponsibleNamespacePrefix($responsibleNamespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($responsibleNamespacePrefix) && !is_string($responsibleNamespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responsibleNamespacePrefix, true), gettype($responsibleNamespacePrefix)), __LINE__);
        }
        if (is_null($responsibleNamespacePrefix) || (is_array($responsibleNamespacePrefix) && empty($responsibleNamespacePrefix))) {
            unset($this->ResponsibleNamespacePrefix);
        } else {
            $this->ResponsibleNamespacePrefix = $responsibleNamespacePrefix;
        }
        return $this;
    }
    /**
     * Get Section value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSection()
    {
        return isset($this->Section) ? $this->Section : null;
    }
    /**
     * Set Section value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $section
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public function setSection($section = null)
    {
        // validation for constraint: string
        if (!is_null($section) && !is_string($section)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($section, true), gettype($section)), __LINE__);
        }
        if (is_null($section) || (is_array($section) && empty($section))) {
            unset($this->Section);
        } else {
            $this->Section = $section;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\SetupAuditTrail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
