<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SessionPermSetActivation StructType
 * @subpackage Structs
 */
class SessionPermSetActivation extends SObject
{
    /**
     * The AuthSession
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\AuthSession
     */
    public $AuthSession;
    /**
     * The AuthSessionId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AuthSessionId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The PermissionSet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\PermissionSet
     */
    public $PermissionSet;
    /**
     * The PermissionSetId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PermissionSetId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for SessionPermSetActivation
     * @uses SessionPermSetActivation::setAuthSession()
     * @uses SessionPermSetActivation::setAuthSessionId()
     * @uses SessionPermSetActivation::setCreatedBy()
     * @uses SessionPermSetActivation::setCreatedById()
     * @uses SessionPermSetActivation::setCreatedDate()
     * @uses SessionPermSetActivation::setDescription()
     * @uses SessionPermSetActivation::setIsDeleted()
     * @uses SessionPermSetActivation::setLastModifiedBy()
     * @uses SessionPermSetActivation::setLastModifiedById()
     * @uses SessionPermSetActivation::setLastModifiedDate()
     * @uses SessionPermSetActivation::setPermissionSet()
     * @uses SessionPermSetActivation::setPermissionSetId()
     * @uses SessionPermSetActivation::setSystemModstamp()
     * @uses SessionPermSetActivation::setUser()
     * @uses SessionPermSetActivation::setUserId()
     * @param \NexusDigital/MiratelForce\StructType\AuthSession $authSession
     * @param string $authSessionId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $description
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param \NexusDigital/MiratelForce\StructType\PermissionSet $permissionSet
     * @param string $permissionSetId
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\AuthSession $authSession = null, $authSessionId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $description = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, \NexusDigital/MiratelForce\StructType\PermissionSet $permissionSet = null, $permissionSetId = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null)
    {
        $this
            ->setAuthSession($authSession)
            ->setAuthSessionId($authSessionId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDescription($description)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setPermissionSet($permissionSet)
            ->setPermissionSetId($permissionSetId)
            ->setSystemModstamp($systemModstamp)
            ->setUser($user)
            ->setUserId($userId);
    }
    /**
     * Get AuthSession value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\AuthSession|null
     */
    public function getAuthSession()
    {
        return isset($this->AuthSession) ? $this->AuthSession : null;
    }
    /**
     * Set AuthSession value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\AuthSession $authSession
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setAuthSession(\NexusDigital/MiratelForce\StructType\AuthSession $authSession = null)
    {
        if (is_null($authSession) || (is_array($authSession) && empty($authSession))) {
            unset($this->AuthSession);
        } else {
            $this->AuthSession = $authSession;
        }
        return $this;
    }
    /**
     * Get AuthSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthSessionId()
    {
        return isset($this->AuthSessionId) ? $this->AuthSessionId : null;
    }
    /**
     * Set AuthSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authSessionId
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setAuthSessionId($authSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($authSessionId) && !is_string($authSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authSessionId, true), gettype($authSessionId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($authSessionId) && mb_strlen($authSessionId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($authSessionId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($authSessionId) && !preg_match('/[a-zA-Z0-9]{18}/', $authSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($authSessionId, true)), __LINE__);
        }
        if (is_null($authSessionId) || (is_array($authSessionId) && empty($authSessionId))) {
            unset($this->AuthSessionId);
        } else {
            $this->AuthSessionId = $authSessionId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get PermissionSet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\PermissionSet|null
     */
    public function getPermissionSet()
    {
        return isset($this->PermissionSet) ? $this->PermissionSet : null;
    }
    /**
     * Set PermissionSet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\PermissionSet $permissionSet
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setPermissionSet(\NexusDigital/MiratelForce\StructType\PermissionSet $permissionSet = null)
    {
        if (is_null($permissionSet) || (is_array($permissionSet) && empty($permissionSet))) {
            unset($this->PermissionSet);
        } else {
            $this->PermissionSet = $permissionSet;
        }
        return $this;
    }
    /**
     * Get PermissionSetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPermissionSetId()
    {
        return isset($this->PermissionSetId) ? $this->PermissionSetId : null;
    }
    /**
     * Set PermissionSetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $permissionSetId
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setPermissionSetId($permissionSetId = null)
    {
        // validation for constraint: string
        if (!is_null($permissionSetId) && !is_string($permissionSetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($permissionSetId, true), gettype($permissionSetId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($permissionSetId) && mb_strlen($permissionSetId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($permissionSetId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($permissionSetId) && !preg_match('/[a-zA-Z0-9]{18}/', $permissionSetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($permissionSetId, true)), __LINE__);
        }
        if (is_null($permissionSetId) || (is_array($permissionSetId) && empty($permissionSetId))) {
            unset($this->PermissionSetId);
        } else {
            $this->PermissionSetId = $permissionSetId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\SessionPermSetActivation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
