<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchLayout StructType
 * @subpackage Structs
 */
class SearchLayout extends SObject
{
    /**
     * The ButtonsDisplayed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SearchLayoutButtonsDisplayed
     */
    public $ButtonsDisplayed;
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The EntityDefinition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\EntityDefinition
     */
    public $EntityDefinition;
    /**
     * The EntityDefinitionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityDefinitionId;
    /**
     * The FieldsDisplayed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SearchLayoutFieldsDisplayed
     */
    public $FieldsDisplayed;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LayoutType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LayoutType;
    /**
     * Constructor method for SearchLayout
     * @uses SearchLayout::setButtonsDisplayed()
     * @uses SearchLayout::setDurableId()
     * @uses SearchLayout::setEntityDefinition()
     * @uses SearchLayout::setEntityDefinitionId()
     * @uses SearchLayout::setFieldsDisplayed()
     * @uses SearchLayout::setLabel()
     * @uses SearchLayout::setLastModifiedBy()
     * @uses SearchLayout::setLastModifiedById()
     * @uses SearchLayout::setLastModifiedDate()
     * @uses SearchLayout::setLayoutType()
     * @param \NexusDigital/MiratelForce\StructType\SearchLayoutButtonsDisplayed $buttonsDisplayed
     * @param string $durableId
     * @param \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition
     * @param string $entityDefinitionId
     * @param \NexusDigital/MiratelForce\StructType\SearchLayoutFieldsDisplayed $fieldsDisplayed
     * @param string $label
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $layoutType
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\SearchLayoutButtonsDisplayed $buttonsDisplayed = null, $durableId = null, \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition = null, $entityDefinitionId = null, \NexusDigital/MiratelForce\StructType\SearchLayoutFieldsDisplayed $fieldsDisplayed = null, $label = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $layoutType = null)
    {
        $this
            ->setButtonsDisplayed($buttonsDisplayed)
            ->setDurableId($durableId)
            ->setEntityDefinition($entityDefinition)
            ->setEntityDefinitionId($entityDefinitionId)
            ->setFieldsDisplayed($fieldsDisplayed)
            ->setLabel($label)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLayoutType($layoutType);
    }
    /**
     * Get ButtonsDisplayed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SearchLayoutButtonsDisplayed|null
     */
    public function getButtonsDisplayed()
    {
        return isset($this->ButtonsDisplayed) ? $this->ButtonsDisplayed : null;
    }
    /**
     * Set ButtonsDisplayed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SearchLayoutButtonsDisplayed $buttonsDisplayed
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public function setButtonsDisplayed(\NexusDigital/MiratelForce\StructType\SearchLayoutButtonsDisplayed $buttonsDisplayed = null)
    {
        if (is_null($buttonsDisplayed) || (is_array($buttonsDisplayed) && empty($buttonsDisplayed))) {
            unset($this->ButtonsDisplayed);
        } else {
            $this->ButtonsDisplayed = $buttonsDisplayed;
        }
        return $this;
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get EntityDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\EntityDefinition|null
     */
    public function getEntityDefinition()
    {
        return isset($this->EntityDefinition) ? $this->EntityDefinition : null;
    }
    /**
     * Set EntityDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public function setEntityDefinition(\NexusDigital/MiratelForce\StructType\EntityDefinition $entityDefinition = null)
    {
        if (is_null($entityDefinition) || (is_array($entityDefinition) && empty($entityDefinition))) {
            unset($this->EntityDefinition);
        } else {
            $this->EntityDefinition = $entityDefinition;
        }
        return $this;
    }
    /**
     * Get EntityDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityDefinitionId()
    {
        return isset($this->EntityDefinitionId) ? $this->EntityDefinitionId : null;
    }
    /**
     * Set EntityDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityDefinitionId
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public function setEntityDefinitionId($entityDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($entityDefinitionId) && !is_string($entityDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityDefinitionId, true), gettype($entityDefinitionId)), __LINE__);
        }
        if (is_null($entityDefinitionId) || (is_array($entityDefinitionId) && empty($entityDefinitionId))) {
            unset($this->EntityDefinitionId);
        } else {
            $this->EntityDefinitionId = $entityDefinitionId;
        }
        return $this;
    }
    /**
     * Get FieldsDisplayed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SearchLayoutFieldsDisplayed|null
     */
    public function getFieldsDisplayed()
    {
        return isset($this->FieldsDisplayed) ? $this->FieldsDisplayed : null;
    }
    /**
     * Set FieldsDisplayed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SearchLayoutFieldsDisplayed $fieldsDisplayed
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public function setFieldsDisplayed(\NexusDigital/MiratelForce\StructType\SearchLayoutFieldsDisplayed $fieldsDisplayed = null)
    {
        if (is_null($fieldsDisplayed) || (is_array($fieldsDisplayed) && empty($fieldsDisplayed))) {
            unset($this->FieldsDisplayed);
        } else {
            $this->FieldsDisplayed = $fieldsDisplayed;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LayoutType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayoutType()
    {
        return isset($this->LayoutType) ? $this->LayoutType : null;
    }
    /**
     * Set LayoutType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $layoutType
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public function setLayoutType($layoutType = null)
    {
        // validation for constraint: string
        if (!is_null($layoutType) && !is_string($layoutType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($layoutType, true), gettype($layoutType)), __LINE__);
        }
        if (is_null($layoutType) || (is_array($layoutType) && empty($layoutType))) {
            unset($this->LayoutType);
        } else {
            $this->LayoutType = $layoutType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\SearchLayout
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
